/*************************************************************************
 *
 *  $RCSfile: script.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SETUP_SCRIPT_HXX
#define SETUP_SCRIPT_HXX

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#include "hashtbl.hxx"
#include "decltor.hxx"

class SiCompiler;
class SiEnvironment;
class SiProcedure;

DECLARE_HASHTABLE(DeclaratorSet,ByteString,SiDeclarator*)

DECLARE_LIST( SiSlideList, SiSlide* )
DECLARE_LIST( SiHelpTextList, SiHelpText* )
DECLARE_LIST( SiScpActionList, SiScpAction* )
DECLARE_LIST( SiModSetList, SiModulesSet* )
DECLARE_LIST( SiModIdsList, SiModuleIds* )
DECLARE_LIST( SiExplicitUNORegList, ByteString* )

class SiCompiledScript
{
	// Verweise auf spezielle Objekte
	SiInstallation  *m_pInstallation;
	SiProfileItem   *m_pInstallInfo;	// z.B. sversion.ini

	SiModule        *m_pRootModule;
	SiFile			*m_pSetup;			// Objects des setup.zip
	SiFile			*m_pCompiledHelp;	// vom Setup komp. Hilfedateien

	SiProfile		*m_pORegINI;		// special fuer OFFICE
	SiProfile		*m_pOfficeINI;		// special fuer OFFICE
	SiProfile		*m_pServerINI;		// sodaemonrc

	SiDirList		 m_Directories;

	SiSlideList		 m_Slides;
	SiHelpTextList	 m_HelpTextLst;
	SiScpActionList  m_ScpActionLst;
    SiModSetList     m_ModSetLst;
    SiModIdsList     m_ModIdsLst;
	SiExplicitUNORegList m_ExplicitUNORegList;


    DeclaratorSet   *m_pDeclarators;
	BOOL             m_bUncomplete; // als Anzeige, dass Daten inkonsistent sind

	BOOL 			 m_bWriteScpAction;
	BOOL			 m_bSecondLevel;
	BOOL			 m_bBindUnlinked;
	BOOL			 m_bBindUnlinkedWarning;

	void Join (SiModule*, DeclaratorSet const&);
	void CreateNameSpace(ByteString const& rPrefix);
	BOOL PrepareForLocalInstallation(SiModule*);

public:
    SiCompiledScript();
    ~SiCompiledScript();

	BOOL 				DoWriteScpAction() const { return m_bWriteScpAction; }
	void				SetWriteScpAction(BOOL bNew) { m_bWriteScpAction = bNew; }

	BOOL 				IsSecondLevel() const { return m_bSecondLevel; }
	void				SetSecondLevel(BOOL bNew) { m_bSecondLevel = bNew; }

    DeclaratorSet*		GetDeclarators() const { return m_pDeclarators; }
	void				RemoveDeclarator(const ByteString& rID);
	BOOL				Add(SiDeclarator*, SiCompiler*);

	void				DoBindUnlinkedObjects(BOOL bNew, BOOL bWarn = TRUE) { m_bBindUnlinked = bNew; m_bBindUnlinkedWarning = bWarn; }
	void				AddUnlinkedObjectsToRoot();

	// fuer das von dem Setup comp. Hilfefile
	void				SetCompiledHelp(const SiFile* pFile, const ByteString& rFileName);
	SiFile*				GetCompiledHelp() const { return m_pCompiledHelp; }
	ByteString 			GetSetupExePath(const SiEnvironment& rEnv);

	SiModule*					GetRootModule() const;
    SiModule*					GetModule(ByteString const& ID) const;
	SiInstallation*				GetInstallation() const;
	SiProfileItem*				GetInstallInfo() const;

	SiDirList   const&			GetDirectoryList() const;
	SiSlideList const&			GetSlideList() const;
	SiHelpTextList const&		GetHelpTextList() const;
	SiScpActionList const&		GetScpActionList() const;
    SiModSetList const&         GetModuleSetList() const;
    SiModIdsList const&         GetModuleIdsList() const;

	SiExplicitUNORegList const& GetExplicitUNORegList() const
								{ return m_ExplicitUNORegList; }
	void 						AddExplicitUNOReg( ByteString* pAdd )
								{ m_ExplicitUNORegList.Insert( pAdd, LIST_APPEND ); }

	SiFile*						GetReadMe() const;
	SiProfile*					GetOfficeINI() const { return m_pOfficeINI; }
	SiProfile*					GetORegINI() const { return m_pORegINI; }
	SiProfile*					GetServerINI() const { return m_pServerINI; }

	SiHelpText*			GetHelpTextForId( USHORT nId, USHORT nLanguage );

    SiDeclarator*		Find(ByteString const& ID) const;
	SiDeclarator*		FindProcedureByName(ByteString const& aName) const;

	SiProcedure*		FindPreSelectProc() const;
	SiProcedure*		FindLanguageSelectProc() const;

	void SetUncomplete(BOOL b = TRUE) { m_bUncomplete = TRUE; }
	BOOL IsUncomplete() const         { return m_bUncomplete; }

	void Join(SiCompiledScript*);
	void PrepareForLocalInstallation();
};

// inlines ----------------------------------------------------------

inline SiModule* SiCompiledScript::GetRootModule() const
{
	return m_pRootModule;
}

inline SiModule* SiCompiledScript::GetModule(ByteString const& ID) const
{
	return PTR_CAST(SiModule,m_pDeclarators->Find(ID));
}

inline SiInstallation* SiCompiledScript::GetInstallation() const
{
	return m_pInstallation;
}

inline SiProfileItem* SiCompiledScript::GetInstallInfo() const
{
	return m_pInstallInfo;
}

inline SiDirectoryList const& SiCompiledScript::GetDirectoryList() const
{
	return m_Directories;
}

inline SiSlideList const& SiCompiledScript::GetSlideList() const
{
	return m_Slides;
}

inline SiHelpTextList const& SiCompiledScript::GetHelpTextList() const
{
	return m_HelpTextLst;
}

inline SiScpActionList const& SiCompiledScript::GetScpActionList() const
{
	return m_ScpActionLst;
}

inline SiModSetList const& SiCompiledScript::GetModuleSetList() const
{
	return m_ModSetLst;
}

inline SiModIdsList const& SiCompiledScript::GetModuleIdsList() const
{
	return m_ModIdsLst;
}

inline SiDeclarator* SiCompiledScript::Find(ByteString const& ID) const
{
	return m_pDeclarators->Find(ID);
}

#endif // __SCRIPT_HXX

