/*************************************************************************
 *
 *  $RCSfile: paths.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2000/11/10 12:40:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif
#ifndef _WLDCRD_HXX
#include <tools/wldcrd.hxx>
#endif
#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "paths.hxx"

#ifndef _SETUP_ENVIRON_HXX
#include "environ.hxx"
#endif

//=========================================================================

#ifdef UNX
#define OFFICE_CONFIG_FILE	"sofficerc"
#else
#define OFFICE_CONFIG_FILE	"soffice.ini"
#endif

//=========================================================================
//
// Copy following soffice.ini entries...
//
//=========================================================================

enum MigrationMode_Impl
{
	REPLACE_VALUE,
	INSERT_BEFORE_VALUE,
	INSERT_AFTER_VALUE
};

struct PathMigrationInfo_Impl
{
	const sal_Char*		pOldKey;	// old key name
	const sal_Char*		pNewKey;    // new key name
	MigrationMode_Impl 	eMode;
};

// Key names taken from svtools/source/misc/iniman.cxx
static PathMigrationInfo_Impl aPathsToMigrate_Impl[] =
{
	{ "Autostart-Dir", 	 	"", 				   	REPLACE_VALUE, 	   },
	{ "Backup-Path", 	 	"", 				   	REPLACE_VALUE, 	   },
	{ "Desktop-Dir", 	 	"", 				   	INSERT_AFTER_VALUE },
	{ "Dictionary-Path",	"UserDictionary-Dir",	REPLACE_VALUE, 	   },
	{ "Download-Dir", 	 	"", 				   	REPLACE_VALUE,	   },
//	{ "Gallery-Dir", 	 	"",  				   	INSERT_AFTER_VALUE },
	{ "Glossary-Path", 	 	"", 				   	INSERT_AFTER_VALUE },
	{ "Quickstart-Dir",  	"", 				   	REPLACE_VALUE, 	   },
	{ "Template-Path", 	 	"", 				   	INSERT_AFTER_VALUE },
	{ "Work-Path", 		 	"", 				   	REPLACE_VALUE, 	   },
	// EOT
	{ "", 				 	"", 				   	REPLACE_VALUE, 	   }
};

//=========================================================================

static WildCard aExcludePattern_Impl[] =
{
	// placeholders for paths inside office installation tree
	WildCard( UniString::CreateFromAscii("*$(*") ),
	// virtual file URL's, like file:///{bookmarks}/
	WildCard( UniString::CreateFromAscii("file:///{*") ),
	// EOT
	WildCard( UniString::CreateFromAscii("") )
};

//=========================================================================
//=========================================================================
//
// class MigrationTask_Paths_Impl.
//
//=========================================================================
//=========================================================================

class MigrationTask_Paths_Impl
{
public:
	MigrationTask_Paths_Impl() {}
	~MigrationTask_Paths_Impl() {}

	void transferPathsSettings( SiEnvironment* pEnv );
};

//=========================================================================
//=========================================================================
//
// MigrationTask_Paths_Impl Implementation.
//
//=========================================================================
//=========================================================================

static BOOL isLocatedIn( const SiDirEntry& rChild, const SiDirEntry& rParent )
{
	USHORT nLevel = rChild.Level();
	if ( rParent.Level() >= nLevel )
		return FALSE;

	USHORT n = 1;
	while ( n < nLevel )
	{
		const SiDirEntry& rCurr = rChild[ n ];
		if ( rCurr == rParent )
			return TRUE;

		n++;
	}

	return FALSE;
}

//-------------------------------------------------------------------------
static void RemoveIllegalPaths( String& rValue, SiEnvironment* pEnv )
{
	const String aValue( rValue );
	String aNewValue;

	SiDirEntry aOldOfficeDir( pEnv->GetMigrationPath() );

	// Value may contain several paths - separated by a semicolon.
	xub_StrLen nCount = aValue.GetTokenCount( ';' );
	xub_StrLen nToken = 0;
	while ( nToken < nCount )
	{
		String aToken( aValue.GetToken( nToken, ';' ) );
		if ( aToken.Len() )
		{
			BOOL bValid = TRUE;

			// 1) Check for directory name patterns always to exclude...

			USHORT n = 0;
			WildCard* pPattern = &aExcludePattern_Impl[ n ];
			while ( pPattern->GetWildCard().Len() )
			{
				if ( pPattern->Matches( aToken ) )
				{
					bValid = FALSE;
					break;
				}

				// Next...
				n++;
				pPattern = &aExcludePattern_Impl[ n ];
			}

			// 2) Check, whether path points into old Office install tree...

			if ( bValid )
				bValid = !isLocatedIn( SiDirEntry( aToken ), aOldOfficeDir );

			if ( bValid )
			{
				aNewValue += aToken;
				aNewValue += ';';
			}
		}

		// Next...
		nToken++;
	}

	if ( aNewValue.Len() &&
		 ( aNewValue.GetChar( aNewValue.Len() - 1 ) == ';' ) )
		aNewValue.Erase( aNewValue.Len() - 1 );

	rValue = aNewValue;
}

//-------------------------------------------------------------------------
void MigrationTask_Paths_Impl::transferPathsSettings( SiEnvironment* pEnv )
{
	SiDirEntry aSource( pEnv->GetMigrationPath() );
	aSource += SiDirEntry( OFFICE_CONFIG_FILE );

	if ( aSource.Exists() )
	{
		SiDirEntry aDest( pEnv->GetDestPath() );
		aDest += SiDirEntry( "user" );
		aDest += SiDirEntry( OFFICE_CONFIG_FILE );

		Config aSrcCfg( aSource.GetFullUni() );
		Config aDstCfg( aDest.GetFullUni() );

		aSrcCfg.SetGroup( "Directories" );
		aDstCfg.SetGroup( "Directories" );

  		USHORT n = 0;
		PathMigrationInfo_Impl* pEntry = &aPathsToMigrate_Impl[ n ];
		ByteString aKey( pEntry->pOldKey );
		while ( aKey.Len() )
		{
			ByteString aValue( aSrcCfg.ReadKey( aKey ) );
			if ( aValue.Len() )
			{
//				aValue.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );

				RemoveIllegalPaths( UniString::CreateFromAscii(aValue.GetBuffer()), pEnv );

				if ( aValue.Len() )
				{
					ByteString aNewKey( pEntry->pNewKey );
					if ( !aNewKey.Len() )
						aNewKey = aKey;

					switch ( pEntry->eMode )
					{
						case REPLACE_VALUE:
						{
							aDstCfg.WriteKey( aNewKey, aValue );
							break;
						}

						case INSERT_BEFORE_VALUE:
						{
							ByteString aNewValue( aDstCfg.ReadKey( aKey ) );

							if ( aNewValue.Len() )
							{
//								aNewValue.Convert( CHARSET_IBMPC,
//												   CHARSET_SYSTEM );

								// @@@ Check for and removal of duplicate paths

								aValue += ';';
								aValue += aNewValue;
							}

							aDstCfg.WriteKey( aNewKey, aValue );
							break;
						}

						case INSERT_AFTER_VALUE:
						{
							ByteString aNewValue( aDstCfg.ReadKey( aKey ) );
							if ( aNewValue.Len() )
							{
//								aNewValue.Convert( CHARSET_IBMPC,
//												   CHARSET_SYSTEM );

								if ( aNewValue.GetChar(
								 			aNewValue.Len() - 1 ) != ';' )
									aNewValue += ';';
							}

							// @@@ Check for and removal of duplicate paths

							aNewValue += aValue;
							aDstCfg.WriteKey( aNewKey, aNewValue );
							break;
						}

						default:
							DBG_ERROR( "MigrationTask_Paths_Impl::"
									   "transferPathsSettings - "
									   "Unknown migration mode!" );
							break;
					}
				}
			}

			// Next...
			n++;
			pEntry = &aPathsToMigrate_Impl[ n ];
			aKey = pEntry->pOldKey;
		}
	}
}

//=========================================================================
//=========================================================================
//
// MigrationTask_Paths Implementation.
//
//=========================================================================
//=========================================================================

MigrationTask_Paths::MigrationTask_Paths( SetupMigrationPlugin* pPlugin )
: SetupMigrationTask( pPlugin )
{
	m_pImpl = new MigrationTask_Paths_Impl;
}

//-------------------------------------------------------------------------
MigrationTask_Paths::~MigrationTask_Paths()
{
	delete m_pImpl;
}

//-------------------------------------------------------------------------
// virtual
ULONG MigrationTask_Paths::Execute(
							MigrationExecType eTyp, SiEnvironment* pEnv )
{
	switch ( eTyp )
	{
		case CALCULATE_SIZE:
			return 0;

		// Transfer files...
		case EXECUTE:
			m_pImpl->transferPathsSettings( pEnv );
			break;

		default:
			DBG_ERROR( "MigrationTask_ChaosViews::Execute - Unknown type!" );
			break;
	}
	return 0;
}

