#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.57.14.1 $
#
#   last change: $Author: hr $ $Date: 2004/01/09 18:53:12 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************
PRJ=..

PRJNAME=setup2
TARGET=setup
TARGETTYPE=GUI

VERSION=$(UPD)
GEN_HID=TRUE
APP2NOSAL=TRUE

# --- Settings -----------------------------------------------------------
USE_JAVAVER=TRUE

.INCLUDE :  settings.mk

VERINFONAME=verinfo

RSCLOCINC!:=$(PRJ)$/res -I$(RSCLOCINC)

RESLIB1NAME=set
RESLIB1SRSFILES=\
	$(SRS)$/uibase.srs	\
	$(SRS)$/pages.srs	\
	$(SRS)$/ui.srs		\
	$(SRS)$/dialog.srs

RESLIB2NAME=set_pp1
RESLIB2SRSFILES=\
	$(SRS)$/ui.srs		\
	$(SRS)$/productpatch1.srs

# --- setup dynamic link library -----------------------------------------

LIB1TARGET = $(SLB)$/set.lib
LIB1FILES = \
		$(SLB)$/pages.lib      	\
		$(SLB)$/agenda.lib     	\
		$(SLB)$/compiler.lib	\
		$(SLB)$/sibasic.lib    	\
		$(SLB)$/other.lib      	\
		$(SLB)$/sicustom.lib	\
		$(SLB)$/uibase.lib

.IF "$(GUI)"=="UNX"
.IF "$(GUIBASE)"=="aqua"
LIB1FILES += $(SLB)$/aquaos.lib
.ELSE
LIB1FILES += $(SLB)$/mowos.lib
.ENDIF
.ENDIF
.IF "$(GUIBASE)"=="WIN"
LIB1FILES += $(SLB)$/winos.lib
.ENDIF

# ---------------------------------

SHL1TARGET = set$(UPD)$(DLLPOSTFIX)
SHL1IMPLIB = iset
SHL1LIBS = $(LIB1TARGET)
SHL1DEF=    $(MISC)$/$(SHL1TARGET).def

SHL1DEPN = $(L)$/itools.lib $(SVLIBDEPEND)

SHL1STDLIBS= \
		$(BASICLIB) \
		$(SVTOOLLIB) \
		$(VCLLIB) \
		$(SVLLIB) \
		$(TOOLSLIB) \
		$(VOSLIB) \
		$(COMPHELPERLIB) \
		$(CPPUHELPERLIB) \
		$(CPPULIB) \
		$(SALHELPERLIB) \
		$(SALLIB)

.IF "$(GUI)"=="UNX"
.IF "$(OS)"!="MACOSX"
SHL1STDLIBS += \
	-Bdynamic $(THREADLIB) \
	-lX11 \
	-lXext
.ENDIF # "$(OS)"!="MACOSX"
.ELSE  # "$(GUI)"=="UNX"
SHL1OBJS = $(SLO)$/agenda.obj
SHL1STDLIBS+= $(SVUNZIPDLL)
.ENDIF # "$(GUI)"=="UNX"

.IF "$(GUI)"=="WNT"
SHL1STDLIBS += \
		uwinapi.lib advapi32.lib gdi32.lib shell32.lib ole32.lib uuid.lib version.lib \
		winmm.lib
.ENDIF # "$(GUI)"=="WNT"

DEF1NAME    =$(SHL1TARGET)
DEF1DEPN    =$(MISC)$/$(SHL1TARGET).flt
DEFLIB1NAME =set
DEF1DES     =S.E.T.U.P.

DEF1EXPORT1 = component_writeInfo
DEF1EXPORT2 = component_getFactory
DEF1EXPORT3 = component_getImplementationEnvironment

# --- setup binary --------------------------------------------------------

APP2TARGET = $(TARGET)

.IF "$(GUI)"=="WNT"
APP2ICON=$(SOLARRESDIR)$/icons$/500_setup.ico
APP2VERINFO=verinfo.rc
APP2LINKRES=$(MISC)$/$(TARGET).res
.ENDIF # "$(GUI)"=="WNT"

APP2LIBS+= \
	$(LB)$/ui.lib \
	$(LB)$/dialog.lib \
	$(LB)$/iset.lib

.IF "$(OS)"=="MACOSX"
APP2LIBS+=$(LIB1FILES)
.ENDIF # "$(OS)"=="MACOSX"

APP2STDLIBS=\
		$(BASICLIB) \
		$(SVTOOLLIB) \
		$(VCLLIB) \
		$(TOOLSLIB) \
		$(COMPHELPERLIB) \
		$(CPPUHELPERLIB) \
		$(CPPULIB) \
		$(VOSLIB) \
		$(SVLLIB) \
		$(SALHELPERLIB) \
		$(UNOTOOLSLIB)  \
		$(SALLIB)
.IF "$(SOLAR_JAVA)"!=""
APP2STDLIBS+=\
		$(JVMACCESSLIB)
.ENDIF

.IF "$(GUI)"=="WNT"
APP2STDLIBS += uwinapi.lib advapi32.lib gdi32.lib shell32.lib ole32.lib uuid.lib version.lib \
		winmm.lib
.ENDIF # "$(GUI)"=="WNT"

.IF "$(GUI)"=="UNX"

APP2DEPN+= $(LB)$/libset$(UPD)$(DLLPOSTFIX)$(DLLPOST)

.IF "$(OS)" == "SOLARIS"
APP2STDLIBS += \
	-lset$(UPD)$(DLLPOSTFIX) \
	-Bdynamic $(THREADLIB) \
	-lX11 \
	-lXext
.ENDIF

.IF "$(OS)"=="LINUX" ||"$(OS)"=="FREEBSD" || "$(OS)"=="NETBSD" || "$(OS)"=="IRIX" || "$(OS)"=="FREEBSD"
APP2STDLIBS+= 	\
	-lset$(UPD)$(DLLPOSTFIX) \
	-Wl,-Bdynamic $(THREADLIB) \
	-lX11 \
	-lXext \
	-lSM \
	-lICE
.ENDIF

.ENDIF # "$(GUI)"=="UNX"

APP2DEPN+=\
	$(LB)$/ui.lib 				\
	$(SLB)$/pages.lib			\
	$(LB)$/dialog.lib			\
	verinfo.rc					\
	$(APP1RES)					\
	makefile.mk

.IF "$(GUI)" != "UNX"
APP2OBJS+=\
		$(OBJ)$/main.obj		\
		$(OBJ)$/mainwnd.obj		\
		$(OBJ)$/mainevt.obj		\
		$(OBJ)$/magenda.obj		\
		$(OBJ)$/textani.obj
.ENDIF # "$(GUI)" != "UNX"

APP2DEF=   $(MISCX)$/$(TARGET).def

# --- setup --------------------------------------------------------------

.IF "$(GUI)"!="UNX"

#
#	Loader
#

.IF "$(GUIBASE)"=="WIN"
UWINAPILIB=$(0)
.ENDIF

LIBSALCPPRT=$(0)

APP3NOSAL=TRUE
APP3TARGET=loader

.IF "$(GUI)"=="WNT"
APP3STDLIBS=svunzip.lib gdi32.lib advapi32.lib libcmt.lib shell32.lib
.ENDIF

.IF "$(GUI)"=="WNT"
APP3OBJS = $(OBJ)$/loader.obj $(OBJ)$/larch.obj
.ELSE
APP3OBJS = $(OBJ)$/loader.obj $(OBJ)$/arch.obj
.ENDIF

APP3DEF = $(MISCX)$/loader.def
APP3RES = $(RES)$/loader.res
APP3NOSVRES = $(RES)$/loader.res
APP3DEPN = $(APP3TARGETN:d:+"unloader.exe")

.ENDIF # "$(GUI)"!="UNX"

.INCLUDE :  target.mk

# -------------------------------------------------------------------------
# --- Targets -------------------------------------------------------------

ALLTAR : $(BIN)$/setup_services.rdb $(BIN)$/remote$/setup_services.rdb

UPDATE_TEST : makefile.mk setup.inf f_zip f_zipdir
	@echo ------------------------------
.IF "$(GUI)"!="MAC"
.IF "$(UPDATER)"=="YES"
	+-$(COPY) setup.inf $(BIN)$
	+-$(COPY) setup.inf $(BIN)$/setup.ins
	+-$(COPY) f_zip $(BIN)$
	+-$(COPY) f_zipdir $(BIN)$
	+-$(COPY) $(SOLARBINDIR)$/vcl???49.res $(BIN)$
.ENDIF
.ENDIF

# -------------------------------------------------------------------------
# Filter fuer set?????.dll
# -------------------------------------------------------------------------
$(MISC)$/$(SHL1TARGET).flt : makefile.mk
    @echo ------------------------------
    @echo Making: 						$@
    @echo Impl							>$@
    @echo Registry_Api					>>$@


REGISTERLIBS= \
	$(DLLPRE)i18n$(UPD)$(DLLPOSTFIX)$(DLLPOST) \
	$(DLLPRE)i18npool$(UPD)$(DLLPOSTFIX)$(DLLPOST) \
	$(DLLPRE)tk$(UPD)$(DLLPOSTFIX)$(DLLPOST) \
	$(DLLPRE)mcnttype$(DLLPOST)

.IF "$(GUI)" == "UNX"
MY_DLLDIR=$(SOLARLIBDIR)
REGISTERLIBS+= \
	$(DLLPRE)dtransX11$(UPD)$(DLLPOSTFIX)$(DLLPOST)

.ELSE			# "$(GUI)" == "UNX"
.IF "$(GUI)"=="WNT"

MY_DLLDIR=$(SOLARBINDIR)
REGISTERLIBS+= \
	$(DLLPRE)sysdtrans$(DLLPOST) \
	$(DLLPRE)ftransl$(DLLPOST) \
	$(DLLPRE)dnd$(DLLPOST)

.ELSE			# "$(GUI)"=="WNT"

	@echo "**********************************************************"
	@echo "*** unknown platform: don't know which librarys to use ***"
	@echo "**********************************************************"
	force_dmake_to_error
.ENDIF			# "$(GUI)"=="WNT"
.ENDIF			# "$(GUI)" == "UNX"

.IF "$(SOLAR_JAVA)" != ""
.IF "$(JAVANUMVER)" >= "000100040000"
# native libraries, which are only necessary, when java shall run within setup
REGISTERLIBS_JAVA= \
	javavm.uno$(DLLPOST) \
	javaloader.uno$(DLLPOST)

# add here java components, which shall run with setup
REGISTERJARS=\
	java_uno_accessbridge.jar

# jar-files, which regcomp needs so that it can use java
REGCOMP_JARS=unoil.jar java_uno.jar ridl.jar sandbox.jar jurt.jar

# CLASSPATH, which regcomp needs to be run
# $(SOLARLIBDIR) needs to be included in case Java components are registered,
# because java_uno.jar needs to find the native java_uno shared library:
MY_CLASSPATH_TMP=$(foreach,i,$(REGCOMP_JARS) $(SOLARBINDIR)$/$i)$(PATH_SEPERATOR)$(SOLARLIBDIR)$(PATH_SEPERATOR)$(XCLASSPATH)
REGCOMP_CLASSPATH=$(strip $(subst,!,$(PATH_SEPERATOR) $(MY_CLASSPATH_TMP:s/ /!/)))

.IF "$(GUI)"!="WNT"
DOLLAR_SIGN=\$$
MY_JAVA_COMPPATH=file://$(SOLARBINDIR)
.IF "$(OS)"=="MACOSX"
REGCOMP_ENV=\
	setenv CLASSPATH $(REGCOMP_CLASSPATH) && \
	setenv DYLD_LIBRARY_PATH $(DYLD_LIBRARY_PATH):$(JDKLIB)
.ELSE
REGCOMP_ENV=\
	setenv CLASSPATH $(REGCOMP_CLASSPATH) && \
	setenv LD_LIBRARY_PATH $(LD_LIBRARY_PATH):$(JDKLIB)
.ENDIF
.ELSE # "$(GUI)" != "WNT"
.IF "$(USE_SHELL)" != "4nt"
DOLLAR_SIGN=\$$
REGCOMP_ENV=\
	setenv CLASSPATH "$(strip $(subst,\,/ $(shell guw.pl echo $(REGCOMP_CLASSPATH))))" && \
	setenv PATH "$(PATH):$(JREPATH)"
MY_JAVA_COMPPATH=$(strip $(subst,\,/ file:///$(shell guw.pl echo $(SOLARBINDIR))))
.ELSE # "$(USE_SHELL)" != "4nt"
DOLLAR_SIGN=$$
REGCOMP_ENV=\
	set CLASSPATH=$(REGCOMP_CLASSPATH) && \
	set PATH=$(PATH);$(JREPATH)
MY_JAVA_COMPPATH=$(strip $(subst,\,/ file:///$(SOLARBINDIR)))
.ENDIF  # "$(USE_SHELL)" != "4nt"
.ENDIF  # "$(GUI)"!="WNT"
.ENDIF  # "$(JAVANUMVER)" >= "000100040000"
.ENDIF  # "$(SOLAR_JAVA)" != ""

$(BIN)$/setup_services.rdb: \
		makefile.mk \
		$(foreach,i,$(REGISTERLIBS) $(MY_DLLDIR)$/$(i)) \
		$(foreach,i,$(REGISTERLIBS_JAVA) $(MY_DLLDIR)$/$(i))
	-rm -f $@ $(BIN)$/regcomp.rdb $(BIN)$/setup_services.tmp
# register the native libraries
	$(REGCOMP) -register -r $(BIN)$/setup_services.tmp -c "$(strip $(REGISTERLIBS))"
.IF "$(SOLAR_JAVA)" != ""
.IF "$(OS)"!="MACOSX"
.IF "$(JAVANUMVER)" >= "000100040000"
	$(REGCOMP) -register -r $(BIN)$/setup_services.tmp -c "$(strip $(REGISTERLIBS_JAVA))"
# prepare a registry which regcomp can work on (types+java services)
	$(REGCOMP) -register -r $(BIN)$/regcomp.rdb -c "$(strip $(REGISTERLIBS_JAVA))"
	$(REGMERGE) $(BIN)$/regcomp.rdb / $(SOLARBINDIR)/udkapi.rdb
# now do the registration
	+$(REGCOMP_ENV) && \
		$(REGCOMP) -br $(BIN)$/regcomp.rdb 			\
			-register					\
			-r $(BIN)$/setup_services.tmp 		\
			-l com.sun.star.loader.Java2			\
			-env:UNO_JAVA_COMPPATH=$(MY_JAVA_COMPPATH)	\
			$(foreach,i,$(REGISTERJARS) -c vnd.sun.star.expand:$(DOLLAR_SIGN)UNO_JAVA_COMPPATH/$(i))
.ENDIF # "$(JAVANUMVER)" >= "000100040000"
.ENDIF # "$(OS)" != "MACOSX"
.ENDIF #  "$(SOLAR_JAVA)" != ""
# to have a transaction, move it now to the final name
	mv $(BIN)$/setup_services.tmp $@


# register services needed for a webtop-setup (does not need accessibility)
$(BIN)$/remote$/setup_services.rdb: \
		makefile.mk \
		$(foreach,i,$(REGISTERLIBS) $(MY_DLLDIR)$/$(i))
	-$(MKDIRHIER) $(BIN)/remote
	-rm -f $@
	$(REGCOMP) -register -r $@ -c "$(strip $(REGISTERLIBS))"
