/*************************************************************************
 *
 *  $RCSfile: wysiwyg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 15:06:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define USHRT_MAX 65535

#include <sv.hxx>
#ifdef XOUT
#include <xout.hxx>     // bis XOutGetCharOutline als extern deklariert wird
#endif

typedef unsigned char UCHAR;

const unsigned char CH_BLANK = ' ';  	// ' ' Leerzeichen
#define POSX 1702
#define POSY 2205

// Faktor der Width-Angaben ( 1 => Twips, 20 => Pt. )
#define WIDTHFKT 1

// Delta X/Y = Abstand der Controls
#define DX 8
#define DY 8

// Width 1..n = Breite der Controls der i. Spalte
#define W0 20
#define W1 170
#define W2 50
#define W3 W2
#define W4 100
#define W5 90
#define W6 90
#define W7 90
#define W8 90
#define W9 90
#define W10 90


// Height 1..n = Hoehe der Controls der i. Zeile
#define H1 20
#define H2 25
#define H3 H1
#define H4 H3
#define H5 H3
#define H6 H2

// PX/Y1..n = Position der Controls
#define PX0 DX
#define PX1 PX0+W0+DX
#define PX2 PX1+W1+DX
#define PX3 PX2+W2+DX
#define PX4 PX3+W3+DX
#define PX5 PX4+W4+DX
#define PX6 PX5+W5+DX
#define PX7 PX6+W6+DX
#define PX8 PX7+W7+DX
#define PX9 PX8+W8+DX
#define PX10 PX9+W9+DX

#define PY1 DY
#define PY2 PY1+H1+DY
#define PY3 PY2+H2+DY
#define PY4 PY3+H3+DY
#define PY5 PY4+H4+DY
#define PY6 PY5+H5+DY
#define PY7 PY6+H6+DY

// Die folgenden Makros ersparen Schreibarbeit, die sich bei jeder Spalte
// wiederholen wuerde.

#define DEFINE123( what, who ) what who##1; what who##2; what who##3; \
							   what who##4; what who##5; what who##6; \
							   what who##7; what who##8; what who##9; \
							   what who##10;

#define INIT123( who ) who##1( this ), who##2( this ), who##3( this ), \
					   who##4( this ), who##5( this ), who##6( this ), \
					   who##7( this ), who##8( this ), who##9( this ), \
					   who##10(this ),

#define SETPOS123( who, where ) \
	who##1.SetPosSizePixel( Point( PX1, PY##where ), Size( W1, H##where ) ); \
	who##2.SetPosSizePixel( Point( PX2, PY##where ), Size( W2, H##where ) ); \
	who##3.SetPosSizePixel( Point( PX3, PY##where ), Size( W3, H##where ) ); \
	who##4.SetPosSizePixel( Point( PX4, PY##where ), Size( W4, H##where ) ); \
	who##5.SetPosSizePixel( Point( PX5, PY##where ), Size( W5, H##where ) ); \
	who##6.SetPosSizePixel( Point( PX6, PY##where ), Size( W6, H##where ) ); \
	who##7.SetPosSizePixel( Point( PX7, PY##where ), Size( W7, H##where ) ); \
	who##8.SetPosSizePixel( Point( PX8, PY##where ), Size( W8, H##where ) ); \
	who##9.SetPosSizePixel( Point( PX9, PY##where ), Size( W9, H##where ) ); \
	who##10.SetPosSizePixel( Point( PX10, PY##where ), Size( W10, H##where ) );

#define SHOW123( who ) who##1.Show(); who##2.Show(); who##3.Show(); \
					   who##4.Show(); who##5.Show(); who##6.Show(); \
					   who##7.Show(); who##8.Show(); who##9.Show(); \
					   who##10.Show();

// Das folgende Makro erspart die Schreibarbeit, die sich bei jeder Zeile
// wiederholen wuerde.

#define ROW( who, font ) 										\
	who##1.SetText( font##Font.GetName( ) );					\
	aStr = "";													\
	aSz = font##Font.GetSize( );								\
	aStr += aSz.Height( )/20;									\
	who##2.SetText( aStr );										\
	aStr = "";                                  				\
	aStr += aSz.Width( )/WIDTHFKT;             				    \
	who##3.SetText( aStr );  				          			\
	who##4.SetText( FamilyName( font##Font.GetFamily() ) );		\
	who##5.SetText( WeightName( font##Font.GetWeight() ) );     \
	who##6.SetText( CharSetName( font##Font.GetCharSet() ) );   \
	who##7.SetText( ItalicName( font##Font.GetItalic() ) );     \
	who##8.SetText( PitchName( font##Font.GetPitch() ) );		\
	who##9.SetText( UnderlineName( font##Font.GetUnderline() ) );	\
	who##10.SetText( StrikeoutName( font##Font.GetStrikeout() ) );	\
	SHOW123( who )


// --- class MyApp -------------------------------------------------

class MyApp : public Application
{
public:
	virtual void Main( int, char*[] );
};

// --- class AppWindow ---------------------------------------------

class AppWindow : public WorkWindow
{
private:
	Printer             aPrn;
	Edit                aEdit;			// der Ausgabetext
	PushButton          aFresh;         // Bildschirmrefresh
	CheckBox			aNettoBx;		// GetTextArray korrigieren
	CheckBox			aWordWiseBx;	// Wortweises Unter/Durchstreichen
	CheckBox			aKerningBx;		// Kerning An/Aus
	CheckBox			aChckLnBx;		// Druckerpositionen ausgeben (Linien)
	CheckBox			aChckScrBx;		// Bildschirmfont ausgeben
	CheckBox			aChckPrtBx;		// druckerangepassten Font ausgeben
	CheckBox			aWriterBx;		// Ausgabe wie beim Writer 3.0
	DEFINE123( FixedText, aTopLine)     // Ueberschriften
	DEFINE123( FixedText, aPrint)       // Infozeile des Druckerfonts
	DEFINE123( FixedText, aScreen)      // Infozeile des Bildschirmfonts
	DEFINE123( FixedText, aScrPrt)      // Infozeile des dr.angep. B.fonts
	ComboBox			aNameBx;        // Fontname
	ComboBox			aFamilyBx;		// Fontfamilyname
	ComboBox			aWeightBx;		// Fontweight
	ComboBox			aCharSetBx;		// Fontcharset
	ComboBox			aItalicBx;		// Fontneigung
	ComboBox			aPitchBx;		// Fontpitch
	ComboBox			aUnderlineBx; 	// FontUnderline
	ComboBox			aStrikeoutBx; 	// FontStrikeout
	NumericField        aHeight;        // Fonthoehe
	NumericField        aWidth;         // Fontbreite
	Point				aStartPos;      // Ausgabeposition
	Size				aSize;          // Fontsize
	Font				aFont;          // Font
	Font				aPrtFont;		// Druckerfont
	Font				aScrFont;       // Bildschirmfont
	Font				aScrPrtFont;    // druckerangep. Bildschirmfont
	long*				pScrWidth;		// Char-Breiten
	long*				pScrPrtWidth;   //  "     "
	BOOL				bChoose;		// Druckerabgleich ja/nein

public:
						AppWindow();
	virtual void		Paint( const Rectangle& aRect );
	void				ChooseFont( );
	void				ShowPara( );
	DECL_LINK( NameSelect, ComboBox * );
	DECL_LINK( ChgSize, NumericField * );
	const String 		WeightName( FontWeight eWeight );
	const String 		CharSetName( CharSet eChSet );
	const String 		ItalicName( FontItalic eItalic );
	const String 		FamilyName( FontFamily eFam );
	const String 		PitchName( FontPitch ePitch );
	const String 		UnderlineName( FontUnderline eUnderline );
	const String 		StrikeoutName( FontStrikeout eStrikeout );
	DECL_LINK( Modify, Edit * );
	void				YpsLine( const Point aP, long nHght,
								 const Color eCol = COL_BLUE,
								 PenStyle eWhichPen = PEN_DOT  );
	void				DrawLines( Point &rPos );
	void				DrawKrnLines( Point &rPos );
	void				DrawTxt( Point &rPos, Font &rFont );
	void				DrawKrnTxt( Point &rPos, Font &rFont );
	void				DrawWriter( Point &rPos );
	DECL_LINK( Fresh, PushButton * );
};

// --- AppWindow::AppWindow() --------------------------------------

AppWindow::AppWindow() :
				WorkWindow( NULL, WinBits( WB_APP | WB_STDWORK ) ),
				aHeight( this, WinBits(WB_BORDER | WB_SPIN | WB_REPEAT) ),
				aWidth( this, WinBits(WB_BORDER | WB_SPIN | WB_REPEAT) ),
				aNameBx( this, WB_DROPDOWN | WB_SORT ),
				aFamilyBx( this, WB_DROPDOWN ),
				aWeightBx( this, WB_DROPDOWN ),
				aCharSetBx( this, WB_DROPDOWN ),
				aItalicBx( this, WB_DROPDOWN ),
				aPitchBx( this, WB_DROPDOWN ),
				aUnderlineBx( this, WB_DROPDOWN ),
				aStrikeoutBx( this, WB_DROPDOWN ),
				INIT123( aTopLine )
				INIT123( aPrint )
				INIT123( aScreen )
				INIT123( aScrPrt )
				aNettoBx( this ),
				aWordWiseBx( this ),
				aKerningBx( this ),
				aChckLnBx( this ),
				aChckScrBx( this ),
				aChckPrtBx( this ),
				aWriterBx( this ),
				aFresh( this ),
				aEdit( this )
{
	aSize = Size( 0, 480 );
	aFont = Font( "Arial", aSize );

	pScrWidth = new long[256];
	pScrPrtWidth = new long[256];

	aFresh.SetPosSizePixel( Point( PX0, PY6 ), Size( W0, H6 ) );
	aFresh.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aFresh.SetText( "" );
	aFresh.Show();

	SETPOS123( aTopLine, 1 )
	aTopLine1.SetText("Name");
	aTopLine2.SetText("Height");
	aTopLine3.SetText("Width");
	aTopLine4.SetText("Family");
	aTopLine5.SetText("Weight");
	aTopLine6.SetText("CharSet");
	aTopLine7.SetText("Italic");
	aTopLine8.SetText("Pitch");
	aTopLine9.SetText("Underline");
	aTopLine10.SetText("Strikeout");
	SHOW123( aTopLine )

	SETPOS123( aPrint, 3 )
	SETPOS123( aScreen, 4 )
	SETPOS123( aScrPrt, 5 )

	aNameBx.SetPosSizePixel( Point( PX1, PY2 ), Size( W1, 150 ) );
	aNameBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	USHORT nCnt = GetDevFontCount( );
	String aNewFont("");
	USHORT i;
	for ( i=0; i<nCnt; i++ )
	{
		aNewFont = GetDevFont(i).GetName();
		if ( USHRT_MAX == aNameBx.GetEntryPos( aNewFont ) )
			aNameBx.InsertEntry( aNewFont );
	}
	nCnt = aPrn.GetDevFontCount( );
	for ( i=0; i<nCnt; i++ )
	{
		aNewFont = aPrn.GetDevFont(i).GetName();
		if ( USHRT_MAX == aNameBx.GetEntryPos( aNewFont ) )
			aNameBx.InsertEntry( aNewFont );
	}
	aNameBx.SetText( aFont.GetName( ) );
	aNameBx.Show();

	aFamilyBx.SetPosSizePixel( Point( PX4, PY2 ), Size( W4, 150 ) );
	aFamilyBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aFamilyBx.InsertEntry( "DontKnow" );
	aFamilyBx.InsertEntry( "Decorative" );
	aFamilyBx.InsertEntry( "Modern" );
	aFamilyBx.InsertEntry( "Roman" );
	aFamilyBx.InsertEntry( "Script" );
	aFamilyBx.InsertEntry( "Swiss" );
	aFamilyBx.InsertEntry( "System" );
	aFamilyBx.SetText( FamilyName( aFont.GetFamily() ) );
	aFamilyBx.Show();

	aWeightBx.SetPosSizePixel( Point( PX5, PY2 ), Size( W5, 150 ) );
	aWeightBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aWeightBx.InsertEntry( "DontKnow" );
	aWeightBx.InsertEntry( "Thin" );
	aWeightBx.InsertEntry( "Ultralight" );
	aWeightBx.InsertEntry( "Light" );
	aWeightBx.InsertEntry( "Semilight" );
	aWeightBx.InsertEntry( "Normal" );
	aWeightBx.InsertEntry( "Medium" );
	aWeightBx.InsertEntry( "Semibold" );
	aWeightBx.InsertEntry( "Bold" );
	aWeightBx.InsertEntry( "Ultrabold" );
	aWeightBx.InsertEntry( "Black" );
	aWeightBx.SetText( WeightName( aFont.GetWeight() ) );
	aWeightBx.Show();

	aCharSetBx.SetPosSizePixel( Point( PX6, PY2 ), Size( W6, 150 ) );
	aCharSetBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aCharSetBx.InsertEntry( "DontKnow" );
	aCharSetBx.InsertEntry( "ANSI" );
	aCharSetBx.InsertEntry( "MAC" );
	aCharSetBx.InsertEntry( "PC 437" );
	aCharSetBx.InsertEntry( "PC 850" );
	aCharSetBx.InsertEntry( "PC 860" );
	aCharSetBx.InsertEntry( "PC 861" );
	aCharSetBx.InsertEntry( "PC 863" );
	aCharSetBx.InsertEntry( "PC 865" );
	aCharSetBx.InsertEntry( "System" );
	aCharSetBx.InsertEntry( "Symbol" );
	aCharSetBx.InsertEntry( "IBMPC" );
	aCharSetBx.SetText( CharSetName( aFont.GetCharSet() ) );
	aCharSetBx.Show();

	aItalicBx.SetPosSizePixel( Point( PX7, PY2 ), Size( W7, 80 ) );
	aItalicBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aItalicBx.InsertEntry( "None" );
	aItalicBx.InsertEntry( "Oblique" );
	aItalicBx.InsertEntry( "Italic" );
	aItalicBx.SetText( ItalicName( aFont.GetItalic() ) );
	aItalicBx.Show();

	aPitchBx.SetPosSizePixel( Point( PX8, PY2 ), Size( W8, 80 ) );
	aPitchBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aPitchBx.InsertEntry( "DontKnow" );
	aPitchBx.InsertEntry( "Fixed" );
	aPitchBx.InsertEntry( "Variable" );
	aPitchBx.SetText( PitchName( aFont.GetPitch() ) );
	aPitchBx.Show();

	aUnderlineBx.SetPosSizePixel( Point( PX9, PY2 ), Size( W9, 80 ) );
	aUnderlineBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aUnderlineBx.InsertEntry( "None" );
	aUnderlineBx.InsertEntry( "Single" );
	aUnderlineBx.InsertEntry( "Double" );
	aUnderlineBx.InsertEntry( "Dotted" );
	aUnderlineBx.SetText( UnderlineName( aFont.GetUnderline() ) );
	aUnderlineBx.Show();

	aStrikeoutBx.SetPosSizePixel( Point( PX10, PY2 ), Size( W10, 80 ) );
	aStrikeoutBx.SetSelectHdl( LINK( this, AppWindow, NameSelect ) );
	aStrikeoutBx.InsertEntry( "None" );
	aStrikeoutBx.InsertEntry( "Single" );
	aStrikeoutBx.InsertEntry( "Double" );
	aStrikeoutBx.SetText( StrikeoutName( aFont.GetStrikeout() ) );
	aStrikeoutBx.Show();

	aHeight.SetPosSizePixel( Point( PX2, PY2 ), Size( W2, H2 ) );
	aHeight.SetModifyHdl( LINK( this, AppWindow, ChgSize ) );
	aHeight.SetMin(4);
	aHeight.SetMax(100);
	aHeight.SetValue( aSize.Height()/20 );
	aHeight.Show();

	aWidth.SetPosSizePixel( Point( PX3, PY2 ), Size( W3, H2 ) );
	aWidth.SetModifyHdl( LINK( this, AppWindow, ChgSize ) );
	aWidth.SetMin( 0 );
	aWidth.SetMax( 1000/WIDTHFKT );
	aWidth.SetValue( aSize.Width()/WIDTHFKT );
	aWidth.Show();

	aNettoBx.SetPosSizePixel( Point( PX5, PY6 ), Size( W5, H6 ) );
	aNettoBx.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aNettoBx.SetText( "Netto" );
	aNettoBx.Show();

	aWordWiseBx.SetPosSizePixel( Point( PX6, PY6 ), Size( W6, H6 ) );
	aWordWiseBx.SetClickHdl( LINK( this, AppWindow, NameSelect ) );
	aWordWiseBx.SetText( "WordWise" );
	aWordWiseBx.Show();

	aKerningBx.SetPosSizePixel( Point( PX7, PY6 ), Size( W6, H6 ) );
	aKerningBx.SetClickHdl( LINK( this, AppWindow, NameSelect ) );
	aKerningBx.SetText( "Kerning" );
	aKerningBx.Show();

	aWriterBx.SetPosSizePixel( Point( PX8, PY6 ), Size( W6, H6 ) );
	aWriterBx.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aWriterBx.SetText( "Writer" );
	aWriterBx.Show();

	aChckLnBx.SetPosSizePixel( Point( PX0, PY3 ), Size( W0, H3 ) );
	aChckLnBx.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aChckLnBx.SetText( "" );
	aChckLnBx.Show();

	aChckScrBx.SetPosSizePixel( Point( PX0, PY4 ), Size( W0, H4 ) );
	aChckScrBx.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aChckScrBx.SetText( "" );
	aChckScrBx.Show();

	aChckPrtBx.SetPosSizePixel( Point( PX0, PY5 ), Size( W0, H5 ) );
	aChckPrtBx.SetClickHdl( LINK( this, AppWindow, Fresh ) );
	aChckPrtBx.SetText( "" );
	aChckPrtBx.Show();

	aEdit.SetPosSizePixel( Point( PX1, PY6 ), Size( PX5 -(PX1+DX), 25 ) );
	aEdit.SetModifyHdl( LINK( this, AppWindow, Modify ) );
	aEdit.Show();
	aEdit.GrabFocus();

	SetPen( Pen( PEN_NULL ) );

	SetMapMode( MapMode( MAP_TWIP ) );
	aPrn.SetMapMode( MapMode( MAP_TWIP ) );

	ShowPara( );

//	aStartPos = Point (POSX, POSY);
	aStartPos = PixelToLogic( Point (PX1, PY7) );

	SetText( String( "Testlabor: Font-Mapping + GetTextArray" ) );
	Show();
}

// --- AppWindow::FamilyName( ) ---------------------------------------

const String AppWindow::FamilyName( FontFamily eFam )
{
	switch ( eFam )
	{
		case FAMILY_DONTKNOW: return ( "DontKnow" );
		case FAMILY_DECORATIVE: return ( "Decorative" );
		case FAMILY_MODERN: return ( "Modern" );
		case FAMILY_ROMAN: return ( "Roman" );
		case FAMILY_SCRIPT: return ( "Script" );
		case FAMILY_SWISS: return ( "Swiss" );
		case FAMILY_SYSTEM: return ( "System" );
	}
	return ( "" );
}

// --- AppWindow::WeightName( ) ---------------------------------------

const String AppWindow::WeightName( FontWeight eWeight )
{
	switch ( eWeight )
	{
		case WEIGHT_DONTKNOW: return ( "DontKnow" );
		case WEIGHT_THIN: return ( "Thin" );
		case WEIGHT_ULTRALIGHT: return ( "Ultralight" );
		case WEIGHT_LIGHT: return ( "Light" );
		case WEIGHT_SEMILIGHT: return ( "Semilight" );
		case WEIGHT_NORMAL: return ( "Normal" );
		case WEIGHT_MEDIUM: return ( "Medium" );
		case WEIGHT_SEMIBOLD: return ( "Semibold" );
		case WEIGHT_BOLD: return ( "Bold" );
		case WEIGHT_ULTRABOLD: return ( "Ultrabold" );
		case WEIGHT_BLACK: return ( "Black" );
	}
	return ( "" );
}

// --- AppWindow::CharSetName( ) ---------------------------------------

const String AppWindow::CharSetName( CharSet eCharSet )
{
	switch ( eCharSet )
	{
		case CHARSET_DONTKNOW: return ( "DontKnow" );
		case CHARSET_ANSI: return ( "ANSI" );
		case CHARSET_MAC: return ( "MAC" );
		case CHARSET_IBMPC_437: return ( "PC 437" );
		case CHARSET_IBMPC_850: return ( "PC 850" );
		case CHARSET_IBMPC_860: return ( "PC 860" );
		case CHARSET_IBMPC_861: return ( "PC 861" );
		case CHARSET_IBMPC_863: return ( "PC 863" );
		case CHARSET_IBMPC_865: return ( "PC 865" );
		case CHARSET_SYSTEM: return ( "System" );
		case CHARSET_SYMBOL: return ( "Symbol" );
//		case CHARSET_IBMPC: return ( "IBMPC" );
	}
	return ( "" );
}

// --- AppWindow::ItalicName( ) ---------------------------------------

const String AppWindow::ItalicName( FontItalic eItalic )
{
	switch ( eItalic )
	{
		case ITALIC_NONE: return ( "None" );
		case ITALIC_OBLIQUE: return ( "Oblique" );
		case ITALIC_NORMAL: return ( "Italic" );
	}
	return ( "" );
}

// --- AppWindow::PitchName( ) ---------------------------------------

const String AppWindow::PitchName( FontPitch ePitch )
{
	switch ( ePitch )
	{
		case PITCH_DONTKNOW: return ( "DontKnow" );
		case PITCH_FIXED: return ( "Fixed" );
		case PITCH_VARIABLE: return ( "Variable" );
	}
	return ( "" );
}

// --- AppWindow::UnderlineName( ) ---------------------------------------

const String AppWindow::UnderlineName( FontUnderline eUnderline )
{
	switch ( eUnderline )
	{
		case UNDERLINE_NONE: return ( "None" );
		case UNDERLINE_SINGLE: return ( "Single" );
		case UNDERLINE_DOUBLE: return ( "Double" );
		case UNDERLINE_DOTTED: return ( "Dotted" );
	}
	return ( "" );
}

// --- AppWindow::StrikeoutName( ) ---------------------------------------

const String AppWindow::StrikeoutName( FontStrikeout eStrikeout )
{
	switch ( eStrikeout )
	{
		case STRIKEOUT_NONE: return ( "None" );
		case STRIKEOUT_SINGLE: return ( "Single" );
		case STRIKEOUT_DOUBLE: return ( "Double" );
	}
	return ( "" );
}

// --- AppWindow::ChooseFont( ) ---------------------------------------

static const String aStandardString = "Dies ist der Teststring";

void AppWindow::ChooseFont( )
{
	bChoose = FALSE;

	Font aFnt( GetFont() );
	SetFont( aFont );

	Font aOldFnt( aPrn.GetFont() );
	aPrn.SetFont( aFont );
	FontMetric aMet = aPrn.GetFontMetric( );

	if ( aMet.IsDeviceFont( ) )
	{
		if ( (CHARSET_DONTKNOW == aFont.GetCharSet() ||
			  FAMILY_DONTKNOW  == aFont.GetFamily()  ||
			  PITCH_DONTKNOW   == aFont.GetPitch()     ) &&
			 (CHARSET_DONTKNOW == aMet.GetCharSet()  ||
			  FAMILY_DONTKNOW  == aMet.GetFamily()   ||
			  PITCH_DONTKNOW   == aMet.GetPitch()      )    )
		{
			// Das folgende ist teuer, aber selten: ein unbekannter Font
			// kann vom Drucker nicht vernuenftig zugeordnet werden. Dann
			// nehmen wir eben das Mapping des Bildschirms in Anspruch und
			// setzen den Familyname, Charset und Pitch wie dort. Dieser
			// Font wird nun nochmals auf dem Drucker eingestellt.
			SetFont( aFont );
			Font aFnt1 = GetFontMetric();
			Font aFnt2( aFont );
			aFnt2.SetCharSet( aFnt1.GetCharSet() );
			aFnt2.SetFamily( aFnt1.GetFamily() );
			aFnt2.SetPitch( aFnt1.GetPitch() );
			aPrn.SetFont( aFnt2 );
			aMet = aPrn.GetFontMetric( );
		}
		long nOWidth = aPrn.GetTextSize( aStandardString ).Width();
		Size aSz = GetTextSize( aStandardString );
		long nSWidth = nOWidth - aSz.Width();
		// Um Aerger mit dem Generic Printer aus dem Wege zu gehen.
		if( aMet.GetSize().Height() )
		{
			SetFont( aMet );  // Druckerabgleich
			bChoose = TRUE;
			long nPWidth = nOWidth - GetTextSize(aStandardString).Width();
			if ( nSWidth<0 ) { nSWidth *= -2; } // lieber schmaler als breiter
			if ( nPWidth<0 ) { nPWidth *= -2; } // lieber schmaler als breiter
			if ( nSWidth<nPWidth )
			{
				SetFont( aFont ); // ohne Abgl.
				bChoose = FALSE;
			}
		}
	}
	aPrn.SetFont( aOldFnt );

	SetFont( aFnt );
}

// --- AppWindow::ShowPara( ) ---------------------------------------

void AppWindow::ShowPara( )
{
	Size aSz;
	String aStr;

	aPrn.SetFont( aFont );
	aPrtFont = aPrn.GetFontMetric( );
	ROW( aPrint, aPrt )

	SetFont( aFont );
	aScrFont = GetFontMetric( );
	GetCharWidth('\0','\xFF', pScrWidth );
	ROW( aScreen, aScr )

	SetFont( aPrtFont );
	GetCharWidth('\0','\xFF', pScrPrtWidth );
	aScrPrtFont = GetFontMetric( );
	ROW( aScrPrt, aScrPrt )

	ChooseFont( );
}

// --- AppWindow::YpsLine( Point, long, Color, PenStyle ) ----------

void AppWindow::YpsLine( const Point aP, long nHght,
				const Color eCol, PenStyle eWhichPen )
{
	Pen aPen( eWhichPen );
	aPen.SetColor( eCol );
	SetPen( aPen );
	DrawLine( aP, Point( aP.X(), aP.Y()+nHght ) );
	SetPen( Pen( PEN_NULL ) );
}

// --- AppWindow::DrawLines( Point &rPos ) ---------------

void AppWindow::DrawLines( Point &rPos )
{
	String aStr = aEdit.GetText();
	USHORT nLen = aStr.Len();
	Size aSz = aPrn.GetTextSize( aEdit.GetText() );
	YpsLine( rPos, aSz.Height( ) );
	for ( USHORT i=0; i<nLen; i++ )
	{
		long nWidth = aPrn.GetTextSize( aStr, 0, i+1 ).Width();
		YpsLine( Point( rPos.X()+nWidth, rPos.Y() ), aSz.Height( ) );
	}
	rPos.Y() += aSz.Height( )+50;
#ifdef XOUT
	{
		XPolyPolygon aXPoly = XOutGetCharOutline((BYTE)aStr[i],aPrn,FALSE);
		if ( aXPoly.Count() )
		{
			aRect = aXPoly.GetBoundRect( &aPrn );
		}
	}
#endif
}

// --- AppWindow::DrawKrnLines( Point &rPos ) ---------------

void AppWindow::DrawKrnLines( Point &rPos )
{
	String aStr = aEdit.GetText();
	USHORT nLen = aStr.Len();
	long *pKernArray = new long[nLen];
	Font aActFont = aPrn.GetFontMetric( );
	Size aSz = aPrn.GetTextArray( aStr, pKernArray, 0, nLen );
//	Size aSz = aPrn.GetTextSize( aEdit.GetText() );
	YpsLine( rPos, aSz.Height( ) );
	// nToMuch ist die Abweichung, die bei einigen Fonts, insbesondere bei
	// Italicfonts, zwischen der Einzelzeichenbreite ( TextSize("X") ) und
	// der Nettozeichenbreite innerhalb eines Strings ( TextSize("XXX")-
	// TextSize("XX"), entsteht und die von GetTextArray aufsummiert wird
	// und so zu den Abweichungen fuehrt.
	long nToMuch;

	if(!aNettoBx.IsChecked())
		nToMuch =  0;
	else
		nToMuch = 2*aPrn.GetTextSize(" ").Width()-aPrn.GetTextSize("  ").Width();
	// Vorsicht: Es gibt schon mal ein rundungsbedingtes nToMuch = -1 !
	if ( nToMuch<0 )
		nToMuch = 0;
	for ( USHORT i=0; i<nLen; i++ )
	{
		YpsLine( Point( rPos.X()+pKernArray[i]-i*nToMuch, rPos.Y() ),
						aSz.Height( ) );
	}
	rPos.Y() += aSz.Height( )+50;
	delete[] pKernArray;
}

// --- AppWindow::DrawTxt( Point &rPos, Font &rFont ) ---------------

void AppWindow::DrawTxt( Point &rPos, Font &rFont )
{
	SetFont( rFont );
	DrawText( rPos,	aEdit.GetText() );
	Size aSz = GetTextSize( aEdit.GetText() );
	rPos.Y() += aSz.Height( )+50;
}

// --- AppWindow::DrawKrnTxt( Point &rPos, Font &rFont ) ---------------

void AppWindow::DrawKrnTxt( Point &rPos, Font &rFont )
{
	String aStr = aEdit.GetText();
	USHORT nLen = aStr.Len();
	long *pKernArray = new long[nLen];
	SetFont( rFont );
	GetTextArray( aStr, pKernArray, 0, nLen );
	DrawTextArray( rPos, aStr, pKernArray, 0, nLen );
	Size aSz = GetTextSize( aStr );
	rPos.Y() += aSz.Height( )+50;
	delete[] pKernArray;
}

// --- AppWindow::DrawWriter( Point &rPos ) ---------------

void AppWindow::DrawWriter( Point &rPos )
{
	String aStr = aEdit.GetText();
	USHORT nLen = aStr.Len();
	long *pKernArray = new long[nLen];

	long nDiff = PixelToLogic( Point( LogicToPixel(rPos) )).X();

	long* pWidth = bChoose ? pScrPrtWidth : pScrWidth;

	SetFont( bChoose ? aScrPrtFont : aScrFont );

	long nScrPos = pWidth[ aStr[USHORT(0)] ];

	long nOfs = aPrn.LogicToPixel( Size( rPos.X(),0 ) ).Width();

	aPrn.EnableMapMode( FALSE );
	aPrn.GetTextArray( aStr, pKernArray, 0, nLen);
	aPrn.EnableMapMode( TRUE );

	for ( USHORT j=0; j<nLen; j++ )
		pKernArray[j] = aPrn.PixelToLogic
			( Size( pKernArray[j]+nOfs, 0 ) ).Width() - rPos.X();

	UCHAR nChPrev = aStr[USHORT(0)];
	UCHAR nCh;
	for ( USHORT i=1; i<nLen; i++ )
	{
		long nScr = pWidth[ aStr[i] ];
		nCh = aStr[i];

		if ( (nChPrev == CH_BLANK ) || (nChPrev == '-') )
			nScrPos = pKernArray[i-1]+nScr;
		else
		{
			nScrPos += nScr;
			nScrPos = (3*nScrPos+pKernArray[i])/4;
		}
		nChPrev = nCh;
		pKernArray[i-1] = nScrPos-nScr+rPos.X()-nDiff;
	}

	DrawTextArray( Point(nDiff, rPos.Y()), aStr, pKernArray, 0, nLen );

	Size aSz = GetTextSize( aStr );
	rPos.Y() += aSz.Height( )+50;
	delete[] pKernArray;
}

// --- AppWindow::Paint( ) ------------------------------------------

void AppWindow::Paint( const Rectangle& aRect )
{
	WorkWindow::Paint( aRect );
	Point aPos = aStartPos;
	if ( aChckLnBx.IsChecked( ) ) DrawLines( aPos );
	if ( aChckScrBx.IsChecked( ) ) DrawTxt( aPos, aScrFont );
	if ( aChckPrtBx.IsChecked( ) ) DrawTxt( aPos, aScrPrtFont );
	if ( aChckLnBx.IsChecked( ) ) DrawKrnLines( aPos );
	if ( aChckScrBx.IsChecked( ) ) DrawKrnTxt( aPos, aScrFont );
	if ( aChckPrtBx.IsChecked( ) ) DrawKrnTxt( aPos, aScrPrtFont );
	if ( aWriterBx.IsChecked( ) ) DrawWriter( aPos );
}

// --- AppWindow::NameSelect( ) -----------------------------------------

IMPL_LINK( AppWindow, NameSelect, ComboBox *, EMPTYARG )
{
	aFont.SetName( aNameBx.GetText( ) );
	aFont.SetFamily( ( FontFamily )
						( aFamilyBx.GetEntryPos(aFamilyBx.GetText()) ) );
	aFont.SetWeight( ( FontWeight )
						( aWeightBx.GetEntryPos(aWeightBx.GetText()) ) );
	aFont.SetCharSet( ( CharSet )
						( aCharSetBx.GetEntryPos(aCharSetBx.GetText()) ) );
	aFont.SetItalic( ( FontItalic )
						( aItalicBx.GetEntryPos(aItalicBx.GetText()) ) );
	aFont.SetPitch( ( FontPitch )
						( aPitchBx.GetEntryPos(aPitchBx.GetText()) ) );
	aFont.SetUnderline( ( FontUnderline )
						( aUnderlineBx.GetEntryPos(aUnderlineBx.GetText()) ) );
	aFont.SetStrikeout( ( FontStrikeout )
						( aStrikeoutBx.GetEntryPos(aStrikeoutBx.GetText()) ) );
	aFont.SetWordLineMode( aWordWiseBx.IsChecked() );
	aFont.SetKerning( aKerningBx.IsChecked() );
	ShowPara( );
	Invalidate( );
	return 0;
}

// --- AppWindow::ChgSize( ) -----------------------------------------

IMPL_LINK_INLINE_START( AppWindow, ChgSize, NumericField *, EMPTYARG )
{
	aSize.Width( ) = (USHORT) aWidth.GetValue()*WIDTHFKT;
	aSize.Height( ) = (USHORT) aHeight.GetValue()*20;
	aFont.SetSize( aSize );
	ShowPara( );
	Invalidate( );
	return 0;
}
IMPL_LINK_INLINE_END( AppWindow, ChgSize, NumericField *, EMPTYARG )

// --- AppWindow::Modify( ) -----------------------------------------

IMPL_LINK_INLINE_START( AppWindow, Modify, Edit *, pEdit )
{
	return 0;
}
IMPL_LINK_INLINE_END( AppWindow, Modify, Edit *, pEdit )

// --- AppWindow::Fresh() ------------------------------------------

IMPL_LINK_INLINE_START( AppWindow, Fresh, PushButton *, EMPTYARG )
{
	Invalidate( );
	return 0;
}
IMPL_LINK_INLINE_END( AppWindow, Fresh, PushButton *, EMPTYARG )

// --- MyApp::Main() -----------------------------------------------

void MyApp::Main( int, char*[] )
{
   AppWindow aWindow;
   Execute();
}

// --- aMyApp ------------------------------------------------------

MyApp aMyApp;

/*************************************************************************

Source Code Control System - Header

$Header: /cvs/graphics/svx/workben/Attic/wysiwyg.cxx,v 1.3 2003/03/27 15:06:04 hr Exp $

   Allgemeines Testlabor

*************************************************************************/

#pragma SEG_EOFMODULE
