/*************************************************************************
 *
 *  $RCSfile: rmsound.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: pl $ $Date: 2001/09/11 15:52:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_RMSOUND_CXX

#include <tools/debug.hxx>
#include <tools/new.hxx>
#include <tools/stream.hxx>
#include <tools/urlobj.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <svdata.hxx>
#include <sound.hxx>
#include <rmsound.hxx>
#include <rmcache.hxx>

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XWEAK_HPP_
#include <com/sun/star/uno/XWeak.hpp>
#endif

using namespace ::com::sun::star::uno;

// -----------
// - RMSound -
// -----------

static ::vcl::InterfaceCache< ::com::sun::star::portal::client::XRmSound >* pRemoteSoundCache = NULL;

void createRemoteSoundCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& )
{
}

void eraseRemoteSoundCache()
{
	if( pRemoteSoundCache )
	{
		delete pRemoteSoundCache;
		pRemoteSoundCache = NULL;
	}
}

// -----------
// - RMSound -
// -----------

RMSound::RMSound() :
	mbLoopMode( FALSE )
{
}

// ------------------------------------------------------------------------

RMSound::~RMSound()
{
	if( pRemoteSoundCache )
		pRemoteSoundCache->putInterface( mxRemoteSound );
}

// ------------------------------------------------------------------------

void RMSound::ImplNotify( SoundNotification eNotification, ULONG nError )
{
	mpSound->ImplNotify( eNotification, nError );
}

// ------------------------------------------------------------------------

void RMSound::Create( Sound* pSound )
{
	if( ! pRemoteSoundCache )
	{
		ImplSVData* pSVData = ImplGetSVData();
		pRemoteSoundCache = new ::vcl::InterfaceCache< ::com::sun::star::portal::client::XRmSound >(
			pSVData->mxMultiFactory, 
			::rtl::OUString::createFromAscii( "OfficeSound.stardiv.de" ), 
			5,1,6 );
	}

	mpSound = pSound;
	mxSoundCallback = REF( NMSP_CLIENT::XSoundCallback )( new XRmsSoundCallback( this ) );
	mxRemoteSound = pRemoteSoundCache->takeInterface();
	
    if( !mxRemoteSound.is() )
		mxSoundCallback = REF( NMSP_CLIENT::XSoundCallback )();
	else
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->Create( mxSoundCallback );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

BOOL RMSound::Init( SalFrame* pFrame, const String& rSoundName, ULONG& rSoundLen )
{
	INetURLObject aSoundURL( rSoundName );
	DBG_ASSERT( aSoundURL.GetProtocol() != INET_PROT_NOT_VALID, "RMSound::Init(...): invalid URL" );
	SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aSoundURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );

	if( pIStm && !pIStm->GetError() && mxRemoteSound.is() )
	{
		const ULONG					nFileLen = pIStm->Seek( STREAM_SEEK_TO_END );
		NMSP_CLIENT::SoundSequence	aSoundSeq( nFileLen );

		pIStm->Seek( 0UL );
		pIStm->Read( (char*) aSoundSeq.getArray(), nFileLen );

		if( !pIStm->GetError() )
		{
			maSoundName = rSoundName;
			CHECK_FOR_RVPSYNC_SOUND();
            try
            {
			    rSoundLen = mxRemoteSound->Transfer( 0UL, aSoundSeq, maSoundName );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
                return FALSE;
            }
			return TRUE;
		}
	}

	delete pIStm;

	return FALSE;
}

// ------------------------------------------------------------------------

BOOL RMSound::Init( SalFrame* pFrame, const BYTE* pSound, ULONG nDataLen, ULONG& rSoundLen )
{
	return FALSE;
}

// ------------------------------------------------------------------------

void RMSound::SetStartTime( ULONG nStartTime )
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->SetStartTime( nStartTime );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void RMSound::SetPlayTime( ULONG nPlayTime )
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->SetPlayTime( nPlayTime );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void RMSound::SetLoopMode( BOOL bLoop )
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->SetLoopMode( bLoop );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void  RMSound::ClearError()
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
		
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->ClearError();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void RMSound::Play()
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->Play();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void RMSound::Stop()
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->Stop();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ------------------------------------------------------------------------

void RMSound::Pause()
{
	DBG_ASSERT( mxRemoteSound.is(), "RMSound object is _not_ valid!" )
	
	if( mxRemoteSound.is() )
	{
		CHECK_FOR_RVPSYNC_SOUND();
        try
        {
		    mxRemoteSound->Pause();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// ---------------------
// - XRMsSoundCallback -
// ---------------------

XRmsSoundCallback::XRmsSoundCallback( RMSound* pSound ) :
	mpSound( pSound )
{
}

// ------------------------------------------------------------------------

XRmsSoundCallback::~XRmsSoundCallback()
{
}

// ------------------------------------------------------------------------

void SAL_CALL XRmsSoundCallback::Notify( sal_uInt16 nNotification, sal_uInt32 nError ) throw()
{
	mpSound->ImplNotify( (SoundNotification) nNotification, nError );
}
