/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: idg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:52:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDG_HXX
#define ARY_IDG_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>

namespace ary
{


class IdGenerator
{
  public:
    virtual 		    ~IdGenerator() {}

    // OPERATIONS
    Cid                 NewCid();               /// Id for CodeEntity's
    Tid                 NewTid();               /// Id for Type's
	cpp::Did            NewDid();               /// Id for Define's (Define or Macro)
	Gid                 NewGid();               /// Id for Group's

	Lid                 NewLid();               /// Id for Location's
	OSid                NewOSid();              /// Id for OperationSignature's

    udmstri             NewAnonymousName(
                            char                i_cStart );

	// INQUIRY
	Gid                 Id_TopProject() const;
	Cid                 Id_GlobalNamespace_Cpp() const;
	Tid					FirstId_BuiltInTypes() const;
	Tid					IdEllipse() const;

  private:
    virtual Cid         do_NewCid() = 0;
    virtual Tid         do_NewTid() = 0;
    virtual cpp::Did    do_NewDid() = 0;
    virtual Gid         do_NewGid() = 0;
    virtual Lid         do_NewLid() = 0;
    virtual OSid        do_NewOSid() = 0;
    virtual udmstri     do_NewAnonymousName(
                            char                i_cStart ) = 0;
    virtual Gid         inq_Id_TopProject() const = 0;
    virtual Cid         inq_Id_GlobalNamespace_Cpp() const = 0;
	virtual Tid         inq_FirstId_BuiltInTypes() const = 0;
	virtual Tid			inq_IdEllipse() const = 0;
};



// IMPLEMENTATION

inline Cid
IdGenerator::NewCid()
    { return do_NewCid(); }
inline Tid
IdGenerator::NewTid()
    { return do_NewTid(); }
inline cpp::Did
IdGenerator::NewDid()
	{ return do_NewDid(); }
inline Gid
IdGenerator::NewGid()
    { return do_NewGid(); }
inline Lid
IdGenerator::NewLid()
    { return do_NewLid(); }
inline OSid
IdGenerator::NewOSid()
    { return do_NewOSid(); }
inline udmstri
IdGenerator::NewAnonymousName( char i_cStart )
    { return do_NewAnonymousName(i_cStart); }
inline Gid
IdGenerator::Id_TopProject() const
	{ return inq_Id_TopProject(); }
inline Cid
IdGenerator::Id_GlobalNamespace_Cpp() const
	{ return inq_Id_GlobalNamespace_Cpp(); }
inline Cid
IdGenerator::FirstId_BuiltInTypes() const
	{ return inq_FirstId_BuiltInTypes(); }
inline Cid
IdGenerator::IdEllipse() const
	{ return inq_IdEllipse(); }



}   // namespace ary


#endif





