/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: is_type_indices.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:52:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDL_IS_TYPE_INDICES_HXX
#define ARY_IDL_IS_TYPE_INDICES_HXX



// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <cosv/template/tpltools.hxx>
#include <ary/idl/i_language.hxx>

namespace ary
{
namespace idl
{



class Type_StorageIndices
{
  public:
    // LIFECYCLE
                        Type_StorageIndices();
                        ~Type_StorageIndices();

    // OPERATIONS
    void                Add_Sequence(
                            Type_id             i_nRelatedType,
                            Type_id             i_nSequence )
                        { aSequenceIndex[i_nRelatedType] = i_nSequence; }
    // INQUIRY
    Type_id             Search_SequenceOf(
                            Type_id             i_nRelatedType )
                        { return csv::value_from_map(aSequenceIndex, i_nRelatedType); }
    // ACCESS

  private:
    typedef std::map<Type_id,Type_id>                        Map_Sequences;

    // DATA
    Map_Sequences       aSequenceIndex;
};


}   // namespace idl
}   // namespace ary

#endif


