/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TableDesignHelpBar.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 15:36:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_TABLEDESIGNHELPBAR_HXX
#define DBAUI_TABLEDESIGNHELPBAR_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _SV_TABCTRL_HXX 
#include <vcl/tabctrl.hxx>
#endif
#ifndef _SV_TABPAGE_HXX 
#include <vcl/tabpage.hxx>
#endif
#ifndef DBACCESS_TABLEDESIGN_ICLIPBOARDTEST_HXX
#include "IClipBoardTest.hxx"
#endif

class MultiLineEdit;
namespace dbaui
{
	//==================================================================
	// Ableitung von TabPage ist ein Trick von TH,
	// um Aenderungen der Systemfarben zu bemerken (Bug #53905)
	class OTableDesignHelpBar : public TabPage
								,public IClipboardTest
	{
	private:
		String			m_sHelpText;
		MultiLineEdit*	m_pTextWin;
		USHORT			m_nDummy;

	protected:
		virtual void Resize();

	public:
		OTableDesignHelpBar( Window* pParent );
		virtual ~OTableDesignHelpBar();

		void SetHelpText( const String& rText );
		String GetHelpText() const { return m_sHelpText; }

		virtual long PreNotify( NotifyEvent& rNEvt );

		// IClipboardTest
		virtual sal_Bool isCutAllowed();
		virtual sal_Bool isCopyAllowed();
		virtual sal_Bool isPasteAllowed();
		virtual sal_Bool hasChildPathFocus() { return HasChildPathFocus(); }

		virtual void copy();
		virtual void cut();
		virtual void paste();
	};

	//==================================================================
	class OFieldPropTabCtrl : public TabControl
	{
	public:
		OFieldPropTabCtrl( Window* pParent, WinBits nWinStyle = WB_STDTABCONTROL );
		virtual ~OFieldPropTabCtrl();

	};

}
#endif // DBAUI_TABLEDESIGNHELPBAR_HXX

