#!/bin/sh
#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: glibcpatch.sh,v $
#
#   $Revision: 1.6 $
#
#   last change: $Author: rt $ $Date: 2005/09/06 14:21:32 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

tarball="../download/glibc-2.1.3-stub.tar.gz"
unziptarball="../download/glibc-2.1.3-stub.tar"

if test -s "$tarball"; then
  if test "$OS" = "SOLARIS"; then
#Only SOLARIS
    _gnutar=`tar --version 2> /dev/null`
    gnutar=`echo $_gnutar | awk '/GNU/ { print "true" }'`
    if test "$gnutar" = "true"; then
       tar -T flist.cp -x -z -f $tarball
       chmod -R +w glibc-2.1.3 
    else
       gunzip -d $tarball
       tar xf $unziptarball -I flist.cp
       chmod -R +w glibc-2.1.3
       gzip $unziptarball
    fi
  elif test "$OS" = "MACOSX"; then
#Only MACOSX
    tar -x -z -f $tarball `cat flist.cp`
  else
#LINUX and others
    tar -T flist.cp -x -z -f $tarball
  fi

#
# convert the files into unix format
#

  for CPNAME in `cat flist.cp`
  do
     if test -s "$CPNAME"; then
      mv -f $CPNAME ./csa.tmp
      sed -e 's/
$//' ./csa.tmp > $CPNAME
      rm -f csa.tmp
     fi
  done

#
# move the files into the final place
#

  for FNAME in `cat flist.cp`
  do
    mv $FNAME rtufiles
  done
  rm -rf glibc-2.1.3

#
# apply the patches
#

# there is no need to apply patch here


#
# copy the SD files into rtufiles directory
#

  for SDNAME in `cat flist.sd`
  do
    SDDIR=`dirname $SDNAME`
    if test ! -d "rtufiles/$SDDIR"; then
      mkdir -p rtufiles/$SDDIR
    fi
    cp sdfiles/$SDNAME rtufiles/$SDNAME
  done

  echo Extraction is  done. > patchinf
  echo Extraction is  done.
  rm -f patcherror

else

#
# error message
#

  echo "Can't find the $tarball file. See patcherror file."
  echo "Source tarball is missing: $tarball " > patcherror
  echo "Copy it into <OPENOFFICE>/external/download directory. " >> patcherror
fi
