/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: resetableguard.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:48:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::osl	;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	definitions
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
ResetableGuard::ResetableGuard( Mutex* pMutex )
	:	m_pMutex	( pMutex	)
	,	m_bLocked	( sal_False	)
{
	lock();
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
ResetableGuard::ResetableGuard( Mutex& rMutex )
	:	m_pMutex	( &rMutex	)
	,	m_bLocked	( sal_False	)
{
	lock();
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
ResetableGuard::~ResetableGuard()
{
	unlock();
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
void ResetableGuard::lock()
{
	if( m_bLocked == sal_False )
	{
		m_bLocked = m_pMutex->acquire();
	}
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
void ResetableGuard::unlock()
{
	if( m_bLocked == sal_True )
	{
		m_bLocked = !(m_pMutex->release());
	}
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
sal_Bool ResetableGuard::tryToLock()
{
	if( m_bLocked == sal_False )
	{
		m_bLocked = m_pMutex->tryToAcquire();
	}
	return m_bLocked;
}

//*****************************************************************************************************************
//	public method
//*****************************************************************************************************************
sal_Bool ResetableGuard::isLocked() const
{
	return m_bLocked;
}

}	//	namespace framework
