package org.netbeans.modules.openoffice;

import java.io.*;

import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.filesystems.*;

/** Cleans up after an external compiler.
 *
 * @author unknown
 */
public class OOURDCleanCompiler extends Compiler {

    private FileObject fo;

    public OOURDCleanCompiler(FileObject fo) {
        this.fo = fo;
        writeDBG("Ctor CleanCompiler");
        writeDBG("this.fo =" +  fo.toString());
    }

    // This is important to write correctly!
    public boolean equals (Object o) {
            if (! (o instanceof OOURDCleanCompiler)) return false;
            OOURDCleanCompiler other = (OOURDCleanCompiler) o;
        // Add any other equality comparisons you may need,
        // according to the instance variables:
	try {
	    return fo.getFileSystem ().getSystemName ().equals (other.fo.getFileSystem ().getSystemName ()) &&
		fo.getPackageNameExt ('/', '.').equals (other.fo.getPackageNameExt ('/', '.'));
	} catch (FileStateInvalidException fsie) {
	    if (Boolean.getBoolean ("netbeans.debug.exceptions"))
		fsie.printStackTrace ();
	    return false;
	}
    }

    // Also, this must be the same for equal compilers!
    public int hashCode () {
        return 1234 ^ fo.getPackageNameExt ('/', '.').hashCode ();
    }

    /*
    // Only needed if you wish to automatically break apart
    // these compilers into different groups:
    public Object compilerGroupKey () {
	List l = new ArrayList (2);
	l.add (super.compilerGroupKey ());
	l.add (someThingUniqueToMe);
	return l;
    }
    */

    public Class compilerGroupClass () {
            return OOURDCleanCompilerGroup.class;
    }

    public boolean isUpToDate () {
        // Just check if there is anything to clean.
        return FileUtil.findBrother (fo, "compiledExt") == null;
    }

    // For use by the compiler group:
    public FileObject getFileObject () {
        return fo;
    }
    
    public static void writeDBG(String zeile)
    {
       try
       {
//       PrintStream prS = new PrintStream(new FileOutputStream("c:\\log.txt",true));
//       prS.println(zeile); 
//       prS.close();
       }catch (Exception e){}
    }      
}
