
package org.netbeans.modules.openoffice;

import org.openide.actions.*;
import org.openide.compiler.CompilerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.*;
import org.openide.nodes.*;
import org.openide.text.EditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;


public class OOURDDataObject extends MultiDataObject {
  

    /** Create a new makefile object.
     * @param obj the makefile
     * @param loader the makefile loader
     * @throws DataObjectExistsException standard exception
     */
    public OOURDDataObject (final FileObject obj, final UniFileLoader loader)
    throws DataObjectExistsException {
        super (obj, loader);
        getCookieSet ().add (new CompilerSupport.Compile (getPrimaryEntry ()) {
                                 protected CompilerType defaultCompilerType () {
                                     return CompilerType.find (OOURDCompilerType.class);
                                 }
                             });
    }

    /** Create a makefile node.
     * @return the node
     */
    protected Node createNodeDelegate () {
        return new OOURDNode (this);
    }

    /** Get context help for the object/node.
     * @return general help
     */
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    /** OOURD Node implementation.
    * Leaf node, default action opens editor or instantiates template.
    * Icons redefined.
    */
    public static class OOURDNode extends DataNode {
        /** Icon base for the OOURDNode node */
        private static final String OOURD_ICON_BASE =
            "org/netbeans/modules/openoffice/urd";

        /** Create the node.
         * @param dob a data object
         */
        public OOURDNode (DataObject dob) {
            this (dob, Children.LEAF);
        }

        /** Create the node with special children.
         * @param dataObject the data object
         * @param ch children to use
         */
        public OOURDNode (DataObject dataObject, Children ch) {
            super (dataObject, ch);
            setIconBase (OOURD_ICON_BASE);
            setDefaultAction (SystemAction.get (CompileAction.class));
        }

    }

}
