/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: funcpage.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 21:29:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_FUNCPAGE_HXX
#define SC_FUNCPAGE_HXX

#ifndef SC_FUNCUTL_HXX
#include "funcutl.hxx"
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"		// ScAddress
#endif

#ifndef _STDCTRL_HXX //autogen
#include <svtools/stdctrl.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SVEDIT_HXX //autogen
#include <svtools/svmedit.hxx>
#endif

#ifndef _SV_TABPAGE_HXX //autogen
#include <vcl/tabpage.hxx>
#endif

#ifndef _SVSTDARR_STRINGS

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#endif

#ifndef _SV_TABCTRL_HXX //autogen
#include <vcl/tabctrl.hxx>
#endif

#ifndef SC_PARAWIN_HXX
#include "parawin.hxx"
#endif

#ifndef _SVTREEBOX_HXX //autogen
#include <svtools/svtreebx.hxx>
#endif

#ifndef SC_COMPILER_HXX
#include "compiler.hxx"
#endif

#ifndef SC_CELL_HXX
#include "cell.hxx"
#endif


class ScViewData;
class ScFuncName_Impl;
class ScDocument;
class ScFuncDesc;

//============================================================================

#define LRU_MAX 10

//============================================================================
class ScListBox : public ListBox
{
protected:

	virtual void	KeyInput( const KeyEvent& rKEvt );
	virtual long	PreNotify( NotifyEvent& rNEvt );

public:
					ScListBox( Window* pParent, WinBits nWinStyle = WB_BORDER );

					ScListBox( Window* pParent, const ResId& rResId );

};




//============================================================================
class ScFuncPage : public TabPage
{
private:

	Link			aDoubleClickLink;
	Link			aSelectionLink;
	FixedText		aFtCategory;
	ListBox			aLbCategory;
	FixedText		aFtFunction;
	ScListBox		aLbFunction;
	ImageButton		aIBFunction;

	const ScFuncDesc*	aLRUList[LRU_MAX];


					DECL_LINK( SelHdl, ListBox* );
					DECL_LINK( DblClkHdl, ListBox* );

protected:

	void			UpdateFunctionList();
	void			InitLRUList();


public:

					ScFuncPage( Window* pParent);

	void			SetCategory(USHORT nCat);
	void			SetFunction(USHORT nFunc);
	void			SetFocus();
	USHORT			GetCategory();
	USHORT			GetFunction();
	USHORT			GetFunctionEntryCount();

	USHORT			GetFuncPos(const ScFuncDesc*);
	const ScFuncDesc*	GetFuncDesc( USHORT nPos ) const;
	String			GetSelFunctionName() const;

	void            SetDoubleClickHdl( const Link& rLink ) { aDoubleClickLink = rLink; }
	const Link&     GetDoubleClickHdl() const { return aDoubleClickLink; }

	void            SetSelectHdl( const Link& rLink ) { aSelectionLink = rLink; }
	const Link&     GetSelectHdl() const { return aSelectionLink; }

};


#endif

