/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: datalog.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:31:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_DATALOG
#define _SCH_DATALOG

#include "memchrt.hxx"
#include <float.h>
#include <math.h>
#define SCH_DATALOG_ANY -1

class SchDataLogBook
{
	long* mpRowCoordinates;
	long* mpColCoordinates;

	long dummy;

	long mnRows;
	long mnCols;
	long mnColsInitial;
	long mnRowsInitial;

	long mnRowsAdded;
	long mnColsAdded;
	long mnRowsLeft;
	long mnColsLeft;

	BOOL mbValid;
	BOOL mbRowChanged;
	BOOL mbColChanged;
	BOOL mbGetCol;

	void IncreaseRowCount();
	void IncreaseColCount();

public:

	 void Reset();
	 SchDataLogBook(const SchMemChart& aMemChart);
	~SchDataLogBook();

	BOOL IsValid() const;

	BOOL IsChanged()    const;
	BOOL IsRowChanged() const;
	BOOL IsColChanged() const;


	void SetValid(BOOL bValid)  {mbValid=bValid;}

	long GetColCount()          {return mnCols;}
	long GetRowCount()          {return mnRows;}

	long GetColsAdded()         {return mnColsAdded;}
	long GetRowsAdded()         {return mnRowsAdded;}

	long GetColsInitial()       {return mnColsInitial;}
	long GetRowsInitial()       {return mnRowsInitial;}

	long GetCount()             {if(mbGetCol)return mnCols;return mnRows;}
	long GetAdded()             {if(mbGetCol)return mnColsAdded;return mnRowsAdded;}
	long GetInitial()           {if(mbGetCol)return mnColsInitial;return mnRowsInitial;}


	void DeleteRow(const long nRow);
	void DeleteCol(const long nCol);
	void InsertRow(const long nRow);
	void InsertCol(const long nCol);
	void SwapCols(long nCol1,long nCol2);
	void SwapRows(long nRow1,long nRow2);

	void SetColMode(const BOOL bCol){mbGetCol =  bCol;};
	void SetRowMode(const BOOL bCol){mbGetCol = !bCol;};


	//Get*Id MUSS ..._ANY fuer nicht existierende Elemente zurueckgeben:
	long GetColId(const long nCol) const
			{if(nCol<mnCols)return mpColCoordinates[nCol];return SCH_DATALOG_ANY;}
	long GetRowId(const long nRow) const
			{if(nRow<mnRows)return mpRowCoordinates[nRow];return SCH_DATALOG_ANY;}

	long GetId(const long n)
	{
		if(mbGetCol)return GetColId(n);
		return GetRowId(n);
	}
};

#endif
