/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ctxmenu.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:47:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CTXMENU_HXX
#define _CTXMENU_HXX

#ifndef _FASTFSYS_HXX
#include <fastfsys.hxx>
#endif

//************************************************************************
//* ImplSendToMenu
//************************************************************************

class ImplSendToMenu : public IfcContextMenu
{
public:
	virtual UINT32 GetItemCount();
	virtual BOOL GetMenuItem( UINT32 nIndex, MenuItem & rItem );
	virtual IfcContextMenu *GetSubMenu( UINT32 nIndex );
	virtual BOOL ExecuteCommand( String aCommand );

public:
	ImplSendToMenu( LPSHELLFOLDER, LPDATAOBJECT );
	virtual ~ImplSendToMenu();

protected:
	LPDATAOBJECT	m_pDataObject;

	// Instanzen der Quelle merken

	LPSHELLFOLDER	m_pSendToFolder;
	LPITEMIDLIST	m_pItems[2048];
	USHORT			m_nItems;
};


//************************************************************************
//* ImplContextMenu
//************************************************************************

class ImplContextMenu : public IfcContextMenu
{
public:
	virtual UINT32 GetItemCount();
	virtual BOOL GetMenuItem( UINT32 nIndex, MenuItem & rItem );
	virtual IfcContextMenu *GetSubMenu( UINT32 nIndex );
	virtual BOOL ExecuteCommand( String aCommand );

public:
	ImplContextMenu( LPCONTEXTMENU, LPDATAOBJECT = NULL, HMENU = NULL );
	virtual ~ImplContextMenu();

protected:
	LPCONTEXTMENU	m_pUIContextMenu;
	LPDATAOBJECT	m_pDataObject;
	HMENU			m_hMenu;
	BOOL			m_fValid;

	// Instanzen der Quelle merken

	friend class Folder;
};

//************************************************************************
//* ImplInternetExplorerMenu
//************************************************************************

class ImplInternetExplorer4Menu : public ImplContextMenu
{
public:
	ImplInternetExplorer4Menu( LPCONTEXTMENU pMenu, LPDATAOBJECT pData = NULL, HMENU hMenu = NULL ) :
	  ImplContextMenu( pMenu, pData, hMenu ) {}
	virtual BOOL ExecuteCommand( String aCommand );
	BOOL InvokeInternal( const String & crURL );
};

#endif // _CTXMENU_HXX
