/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: steps.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:30:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_STEPS_HXX
#define UDM_STEPS_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/entity.hxx>
	// COMPONENTS
	// PARAMETERS

//  The "standard" derivations of Step


namespace udm
{


class Step_onStruct : public Step
{
  public:
                        Step_onStruct(
                            member_id           i_nMemberId )
                            :   nMemberId(i_nMemberId) {}
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
    // DATA
    member_id           nMemberId;
};

class Step_onArray : public Step
{
  public:
                        Step_onArray(
                            uintt               i_nIndex )
                            :   nIndex(i_nIndex) {}
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
    // DATA
    uintt               nIndex;
};

class Step_onUintMap : public Step
{
  public:
                        Step_onUintMap(
                            uintt               i_nKey )
                            :   nKey(i_nKey) {}
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
    // DATA
    uintt               nKey;
};

class Step_onStringMap : public Step
{
  public:
                        Step_onStringMap(
                            const String &      i_sKey )
                            :   sKey(i_sKey) {}
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
    // DATA
    String              sKey;
};

/** @tpl ENTITY_SERVER
    Has to offer an

        Object operator( typename ENTITY_SERVER::id_type ) const;

    which returns an udm::Object with the udm::Data representation of the
    id stored in the ptr. ENTITY_SERVER::id_type has to be identical with
    typename TPtr<ID_TYPE>::id_type.
*/
template <class ENTITY_SERVER>
class Step_onPtr : public Step
{
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
};

/** @tpl TYPEINFO_SERVER
    Has to be identical which the template argument of
    the used class ::udm::TDynamic<> .
*/
template <class TYPEINFO_SERVER>
class Step_onDynamic : public Step
{
  private:
    virtual Object      op_FCall(
                            const Object &      i_rData) const;
};





// IMPLEMENTATION


template <class ENTITY_SERVER>
Object
Step_onPtr<ENTITY_SERVER>::op_FCall( const Object & i_rData ) const
{
    // KORR
    return Object();
}

template <class TYPEINFO_SERVER>
Object
Step_onDynamic<TYPEINFO_SERVER>::op_FCall( const Object & i_rData ) const
{
    // KORR
    return Object();
}



}   // namespace udm



#endif


