/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: passworddlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:26:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVT_FILEDLG_HXX
#include <svtools/filedlg.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef UUI_IDS_HRC
#include <ids.hrc>
#endif
#ifndef UUI_PASSWORDDLG_HRC
#include <passworddlg.hrc>
#endif
#ifndef UUI_PASSWORDDLG_HXX
#include <passworddlg.hxx>
#endif

// PasswordDialog---------------------------------------------------------

// -----------------------------------------------------------------------

IMPL_LINK( PasswordDialog, OKHdl_Impl, OKButton *, EMPTYARG )
{
	EndDialog( RET_OK );
	return 1;
}

// -----------------------------------------------------------------------

PasswordDialog::PasswordDialog
(
	Window*										pParent,
	::com::sun::star::task::PasswordRequestMode	aDialogMode,
	ResMgr*										pResMgr
) :

	ModalDialog( pParent, ResId( DLG_UUI_PASSWORD, pResMgr ) ),

	aFTPassword		( this, ResId( FT_PASSWORD ) ),
	aEDPassword		( this, ResId( ED_PASSWORD ) ),
	aOKBtn			( this, ResId( BTN_PASSWORD_OK ) ),
	aCancelBtn		( this, ResId( BTN_PASSWORD_CANCEL ) ),
	aHelpBtn		( this, ResId( BTN_PASSWORD_HELP ) ),
	nDialogMode		( aDialogMode ),
	pResourceMgr	( pResMgr )
{
	if( nDialogMode == ::com::sun::star::task::PasswordRequestMode_PASSWORD_REENTER )
	{
		String aErrorMsg( ResId( STR_ERROR_PASSWORD_WRONG, pResourceMgr ));
		ErrorBox aErrorBox( pParent, WB_OK, aErrorMsg );
		aErrorBox.Execute();
	}

	FreeResource();

	aOKBtn.SetClickHdl( LINK( this, PasswordDialog, OKHdl_Impl ) );
};

