/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpContentIdentifier.java,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:36:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.net.*;
import com.sun.star.ucb.*;

public class HelpContentIdentifier implements XContentIdentifier
{
  	private URL m_xURLIdent;
	private HelpURLParameter m_xParameter = null;
	private String _defaultLanguage = null;
	
	
  	public HelpContentIdentifier( String strIdent ) throws IllegalIdentifierException
  	{
    	try
    	{
      		m_xURLIdent = new URL( strIdent );
			m_xParameter = new HelpURLParameter( m_xURLIdent,null );
    	}
    	catch( MalformedURLException e )
    	{
      		throw new IllegalIdentifierException();
    	}
  	}


	// Accepts the external form of an URL;
  	public HelpContentIdentifier( String strIdent,String defaultLanguage ) throws IllegalIdentifierException
  	{
    	try
    	{
      		m_xURLIdent = new URL( strIdent );
			m_xParameter = new HelpURLParameter( m_xURLIdent,defaultLanguage );
    	}
    	catch( MalformedURLException e )
    	{
      		throw new IllegalIdentifierException();
    	}
  	}

	
	public HelpContentIdentifier( URL URLIdent,String defaultLanguage ) throws IllegalIdentifierException
  	{
		m_xURLIdent = URLIdent;
		m_xParameter = new HelpURLParameter( m_xURLIdent,defaultLanguage );
  	}


  	public String getContentIdentifier() throws com.sun.star.uno.RuntimeException
  	{
    	return m_xURLIdent.toExternalForm();
  	}
	
	
  	public String getContentProviderScheme() throws com.sun.star.uno.RuntimeException
  	{
    	return m_xURLIdent.getProtocol();
  	}
	

  	public HelpURLParameter getParameter()
  	{
    	return m_xParameter;
  	}


  	public int isEqualTo( HelpContentIdentifier p0 )
  	{
  		return m_xParameter.isEqualTo( p0.getParameter() );
  	}

}
