#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: aottarget.mk,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: kz $ $Date: 2006/07/19 09:52:58 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

#this generates .jar.so files into the local LIB dir from the global solver
#dir, so that would need to be resolved before making this a generic solution
#in solenv for all java build-time tools 

AOTTARGETN=$(BIN)$/$(AOTTARGET)

AOTFILES = $(foreach,i,$(NEWCLASS) $(LB)$/lib$(i:b).jar.so)

.IF "$(SYSTEM_DB)" == "YES"
AOTFILES+= $(LB)$/libdb.jar.so
$(AOTTARGETN) : $(LB)$/libdb.jar.so
.ENDIF

AOTLINKFLAGS=$(subst,.so, $(subst,$(LB)$/lib,-l $(AOTFILES)))

$(LB)$/lib%.jar.so : $(SOLARBINDIR)$/%.jar
	$(JAVAAOTCOMPILER) --classpath=. -shared -fPIC -Wl,-Bsymbolic -O2 \
	-fno-bounds-check -fno-store-check -findirect-dispatch -fjni -o $@ $<

$(LB)$/libdb.jar.so:
	$(JAVAAOTCOMPILER) --classpath=. -shared -fPIC -Wl,-Bsymbolic -O2 \
	-fno-bounds-check -fno-store-check -findirect-dispatch -fjni -o $(LB)$/libdb.jar.so $(DB_JAR)

$(AOTTARGETN) : $(JARTARGETN) $(AOTFILES)
	$(JAVAAOTCOMPILER) --main=$(AOTTARGET) -o $(BIN)$/$(AOTTARGET) \
		-Wl,-Bsymbolic -O2 --no-bounds-check -fno-store-check -findirect-dispatch -fjni \
		-Djavax.xml.parsers.SAXParserFactory=org.apache.xerces.jaxp.SAXParserFactoryImpl \
		-Djavax.xml.parsers.DocumentBuilderFactory=org.apache.xerces.jaxp.DocumentBuilderFactoryImpl \
		$(JAVACPS) $(CLASSPATH) $(JARTARGETN) -L$(LB) $(AOTLINKFLAGS)
