/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridwin3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:27:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_svx/svdoutl.hxx>
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <svtools/ptitem.hxx>

// auto strip #include "tabvwsh.hxx"
#include "gridwin.hxx"
#include "dbfunc.hxx"
// auto strip #include "viewdata.hxx"
#include "output.hxx"
#include "drawview.hxx"
#include "fupoor.hxx"

#include "drawutil.hxx"
#include "document.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

// -----------------------------------------------------------------------


//STRIP001 BOOL ScGridWindow::DrawMouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
//STRIP001 	if (pDraw && !pViewData->IsRefMode())
//STRIP001 	{
//STRIP001 		pDraw->SetWindow( this );
//STRIP001 		Point aLogicPos = PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 		if ( pDraw->IsDetectiveHit( aLogicPos ) )
//STRIP001 		{
//STRIP001 			//	auf Detektiv-Pfeilen gar nichts (Doppelklick wird bei ButtonUp ausgewertet)
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bRet = pDraw->MouseButtonDown( rMEvt );
//STRIP001 			if ( bRet )
//STRIP001 				UpdateStatusPosSize();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	bei rechter Taste Draw-Aktion abbrechen
//STRIP001 
//STRIP001 	ScDrawView* pDrView = pViewData->GetScDrawView();
//STRIP001 	if ( pDrView && !rMEvt.IsLeft() && !bRet )
//STRIP001 	{
//STRIP001 		pDrView->BrkAction();
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL ScGridWindow::DrawMouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
//STRIP001 	if (pDraw && !pViewData->IsRefMode())
//STRIP001 	{
//STRIP001 		pDraw->SetWindow( this );
//STRIP001 		bRet = pDraw->MouseButtonUp( rMEvt );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL ScGridWindow::DrawMouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
//STRIP001 	if (pDraw && !pViewData->IsRefMode())
//STRIP001 	{
//STRIP001 		pDraw->SetWindow( this );
//STRIP001 		BOOL bRet = pDraw->MouseMove( rMEvt );
//STRIP001 		if ( bRet )
//STRIP001 			UpdateStatusPosSize();
//STRIP001 		return bRet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetPointer( Pointer( POINTER_ARROW ) );
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }

/*N*/ void ScGridWindow::DrawEndAction()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetScDrawView();
/*N*/ 	if ( pDrView && pDrView->IsAction() )
/*?*/ 		pDrView->BrkAction();
/*N*/ 
/*N*/ 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
/*N*/ 	if (pDraw)
/*N*/ 		pDraw->StopDragTimer();
/*N*/ 
/*N*/ 	//	ReleaseMouse beim Aufruf
/*N*/ }

//STRIP001 BOOL ScGridWindow::DrawCommand(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetScDrawView();
//STRIP001 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
//STRIP001 	if (pDrView && pDraw && !pViewData->IsRefMode())
//STRIP001 	{
//STRIP001 		pDraw->SetWindow( this );
//STRIP001 		BYTE nUsed = pDraw->Command( rCEvt );
//STRIP001 		if( nUsed == SC_CMD_USED )
//STRIP001 			nButtonDown = 0;					// MouseButtonUp wird verschluckt...
//STRIP001 		if( nUsed || pDrView->IsAction() )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL ScGridWindow::DrawKeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetScDrawView();
//STRIP001 	FuPoor* pDraw = pViewData->GetView()->GetDrawFuncPtr();
//STRIP001 	if (pDrView && pDraw && !pViewData->IsRefMode())
//STRIP001 	{
//STRIP001 		pDraw->SetWindow( this );
//STRIP001 		BOOL bOldMarked = pDrView->HasMarkedObj();
//STRIP001 		if (pDraw->KeyInput( rKEvt ))
//STRIP001 		{
//STRIP001 			BOOL bLeaveDraw = FALSE;
//STRIP001 			BOOL bUsed = TRUE;
//STRIP001 			BOOL bNewMarked = pDrView->HasMarkedObj();
//STRIP001 			if ( !pViewData->GetView()->IsDrawSelMode() )
//STRIP001 				if ( !bNewMarked )
//STRIP001 				{
//STRIP001 					pViewData->GetViewShell()->SetDrawShell( FALSE );
//STRIP001 					bLeaveDraw = TRUE;
//STRIP001 					if ( !bOldMarked &&
//STRIP001 						rKEvt.GetKeyCode().GetCode() == KEY_DELETE )
//STRIP001 						bUsed = FALSE;					// nichts geloescht
//STRIP001 				}
//STRIP001 			if (!bLeaveDraw)
//STRIP001 				UpdateStatusPosSize();		// #108137# for moving/resizing etc. by keyboard
//STRIP001 			return bUsed;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*N*/ void ScGridWindow::DrawRedraw( ScOutputData& rOutputData, const Rectangle& rDrawingRect,
/*N*/ 									ScUpdateMode eMode, ULONG nLayer )
/*N*/ {
/*N*/ 	//!		eMode auswerten !!!
/*N*/ 
/*N*/ 	USHORT nObjectFlags = 0;
/*N*/ 	const ScViewOptions& rOpts = pViewData->GetOptions();
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_OLE ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_OLE;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_CHART ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_CHARTS;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_DRAW ) == VOBJ_MODE_SHOW )
/*N*/ 		nObjectFlags |=	SC_OBJECTS_DRAWING;
/*N*/ 
/*N*/ 	USHORT nDummyFlags = 0;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_OLE ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_OLE;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_CHART ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_CHARTS;
/*N*/ 	if ( rOpts.GetObjMode( VOBJ_TYPE_DRAW ) == VOBJ_MODE_DUMMY )
/*N*/ 		nDummyFlags |=	SC_OBJECTS_DRAWING;
/*N*/ 
/*N*/ 	if (nObjectFlags || nDummyFlags)
/*N*/ 	{
/*N*/ 		if ( eMode == SC_UPDATE_CHANGED )
/*N*/ 			rOutputData.DrawingSingle( (USHORT) nLayer, nObjectFlags, nDummyFlags );
/*N*/ 		else
				{DBG_BF_ASSERT(0, "STRIP");}  //STRIP001 /*?*/ 			rOutputData.DrawSelectiveObjects( (USHORT) nLayer, rDrawingRect,
//STRIP001 /*?*/ 												nObjectFlags, nDummyFlags );
/*N*/ 	}
/*N*/ }

/*N*/ void ScGridWindow::DrawSdrGrid( const Rectangle& rDrawingRect )
/*N*/ {
/*N*/ 	//	Draw-Gitterlinien
/*N*/ 
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if ( pDrView && pDrView->IsGridVisible() )
/*N*/ 	{
/*?*/ 		SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*?*/ 		DBG_ASSERT(pPV, "keine PageView");
/*?*/ 		if (pPV)
/*?*/ 		{
/*?*/          DBG_BF_ASSERT(0, "STRIP"); //STRIP001    SetLineColor(COL_GRAY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			pPV->DrawGrid( *this, rDrawingRect );
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ MapMode ScGridWindow::GetDrawMapMode( BOOL bForce )
/*N*/ {
/*N*/ 	MapMode aDrawMode = pViewData->GetLogicMode();
/*N*/ 
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if ( pDrView || bForce )
/*N*/ 	{
/*N*/ 		Fraction aScaleX;
/*N*/ 		Fraction aScaleY;
/*N*/ 		if (pDrView)
/*N*/ 			pDrView->GetScale( aScaleX, aScaleY );
/*N*/ 		else
/*N*/ 		{
/*?*/ 			ScDocument* pDoc = pViewData->GetDocument();
/*?*/ 			USHORT nTab = pViewData->GetTabNo();
/*?*/ 			USHORT nEndCol = 0;
/*?*/ 			USHORT nEndRow = 0;
/*?*/ 			pDoc->GetTableArea( nTab, nEndCol, nEndRow );
/*?*/ 			if (nEndCol<20) nEndCol = 20;
/*?*/ 			if (nEndRow<20) nEndRow = 20;
/*?*/ 			ScDrawUtil::CalcScale( pDoc, nTab, 0,0, nEndCol,nEndRow, this,
/*?*/ 									pViewData->GetZoomX(),pViewData->GetZoomY(),
/*?*/ 									pViewData->GetPPTX(),pViewData->GetPPTY(),
/*?*/ 									aScaleX,aScaleY );
/*N*/ 		}
/*N*/ 		aDrawMode.SetScaleX(aScaleX);
/*N*/ 		aDrawMode.SetScaleY(aScaleY);
/*N*/ 	}
/*N*/ 	aDrawMode.SetOrigin(Point());
/*N*/ 	aDrawMode.SetOrigin( PixelToLogic( pViewData->GetPixPos(eWhich), aDrawMode ) );
/*N*/ 
/*N*/ 	return aDrawMode;
/*N*/ }

//STRIP001 BOOL ScGridWindow::DrawBeforeScroll()
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 
//STRIP001 	BOOL bXor = FALSE;
//STRIP001 	if (pDrView)
//STRIP001 	{
//STRIP001 	    bXor=pDrView->IsShownXorVisible(this);
//STRIP001 	    if (bXor) pDrView->HideShownXor(this);
//STRIP001 	}
//STRIP001 	return bXor;
//STRIP001 }

//STRIP001 void ScGridWindow::DrawAfterScroll(BOOL bVal)
//STRIP001 {
//STRIP001 	Update();		// immer, damit das Verhalten mit/ohne DrawingLayer gleich ist
//STRIP001 
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 	if (pDrView)
//STRIP001 	{
//STRIP001 	    if (bVal)
//STRIP001     		pDrView->ShowShownXor(this);
//STRIP001 
//STRIP001 		OutlinerView* pOlView = pDrView->GetTextEditOutlinerView();
//STRIP001 		if (pOlView && pOlView->GetWindow() == this)
//STRIP001 			pOlView->ShowCursor(FALSE);					// ist beim Scrollen weggekommen
//STRIP001     }
//STRIP001 }

/*N*/ void ScGridWindow::DrawMarks()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 		pDrView->DrawMarks(this);
/*N*/ }

/*N*/ BOOL ScGridWindow::NeedDrawMarks()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	return pDrView && pDrView->IsMarkHdlShown() && pDrView->HasMarkedObj();
/*N*/ }

//STRIP001 void ScGridWindow::CreateAnchorHandle(SdrHdlList& rHdl, const ScAddress& rAddress)
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 	if (pDrView)
//STRIP001 	{
//STRIP001 		const ScViewOptions& rOpts = pViewData->GetOptions();
//STRIP001 		if(rOpts.GetOption( VOPT_ANCHOR ))
//STRIP001 		{
//STRIP001 			Point aPos = pViewData->GetScrPos( rAddress.Col(), rAddress.Row(), eWhich, TRUE );
//STRIP001 			aPos = PixelToLogic(aPos);
//STRIP001 			rHdl.AddHdl(new SdrHdl(aPos ,HDL_ANCHOR));
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridWindow::OutlinerViewPaint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 	if (pDrView && pDrView->GetTextEditOutlinerView())
//STRIP001 	{
//STRIP001 		Outliner* pOut = pDrView->GetTextEditOutliner();
//STRIP001 		ULONG nViewCount = pOut ? pOut->GetViewCount() : 0;
//STRIP001 		for (ULONG nView=0; nView<nViewCount; nView++)
//STRIP001 		{
//STRIP001 			OutlinerView* pOlView = pOut->GetView(nView);
//STRIP001 
//STRIP001 			if (pOlView && pOlView->GetWindow() == this)
//STRIP001 			{
//STRIP001 				BOOL bFrame = FALSE;
//STRIP001 				Rectangle aEditRect = pOlView->GetOutputArea();
//STRIP001 				SdrObject* pEditObj = GetEditObject();
//STRIP001 				if (pEditObj && pEditObj->ISA(SdrTextObj))
//STRIP001 				{
//STRIP001 					SdrTextObj* pTextObj = (SdrTextObj*)pEditObj;
//STRIP001 					Rectangle aMinRect;
//STRIP001 	                pTextObj->TakeTextEditArea(NULL,NULL,NULL,&aMinRect); // PageView Offset ist 0
//STRIP001 	                aEditRect.Union(aMinRect);
//STRIP001 	                bFrame = pTextObj->IsTextFrame();
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( aEditRect.IsOver( rRect ) )
//STRIP001 				{
//STRIP001 					ULONG nOldDrawMode = GetDrawMode();
//STRIP001 					if ( Application::GetSettings().GetStyleSettings().GetHighContrastMode() )
//STRIP001 					{
//STRIP001 						SetDrawMode( nOldDrawMode | DRAWMODE_SETTINGSLINE | DRAWMODE_SETTINGSFILL |
//STRIP001 											DRAWMODE_SETTINGSTEXT | DRAWMODE_SETTINGSGRADIENT );
//STRIP001 					}
//STRIP001 
//STRIP001 					Rectangle aEffRect = rRect.GetIntersection( aEditRect );
//STRIP001 					if (bFrame)
//STRIP001 					{
//STRIP001 						if ( pEditObj->GetLayer() ==SC_LAYER_INTERN )	// cell note?
//STRIP001 						{
//STRIP001 							//	#78828# always draw the edit background in case notes overlap
//STRIP001 							SetFillColor( pOlView->GetBackgroundColor() );
//STRIP001 							SetLineColor();
//STRIP001 							DrawRect( aEffRect );
//STRIP001 						}
//STRIP001 
//STRIP001 						//	RedrawOneLayer mit dem Text-Rechteck zeichnet nur die Outliner-View
//STRIP001 						//	und den Text-Rahmen (an den kommt man sonst von aussen nicht heran).
//STRIP001 
//STRIP001 						SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
//STRIP001 						DBG_ASSERT(pPV, "keine PageView");
//STRIP001 						if (pPV)
//STRIP001 						{
//STRIP001 							SdrLayerID nLayer = pEditObj ? pEditObj->GetLayer() : SC_LAYER_FRONT;
//STRIP001 							pPV->RedrawOneLayer( nLayer, aEffRect, this );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						SetFillColor( pOlView->GetBackgroundColor() );
//STRIP001 						SetLineColor();
//STRIP001 						DrawRect( aEffRect );
//STRIP001 						pOlView->Paint( aEffRect );
//STRIP001 					}
//STRIP001 
//STRIP001 					SetDrawMode( nOldDrawMode );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ SdrObject* ScGridWindow::GetEditObject()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 	{
/*N*/ 		OutlinerView* pOlView = pDrView->GetTextEditOutlinerView();
/*N*/ 		if (pOlView && pOlView->GetWindow() == this)
/*?*/ 			return pDrView->GetTextEditObject();
/*N*/ 	}
/*N*/ 
/*N*/ 	return NULL;
/*N*/ }

//STRIP001 void ScGridWindow::UpdateStatusPosSize()
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 	if (!pDrView)
//STRIP001 		return;			// shouldn't be called in that case
//STRIP001 
//STRIP001 	SfxItemSet aSet(pViewData->GetViewShell()->GetPool(), SID_ATTR_POSITION, SID_ATTR_SIZE);
//STRIP001 
//STRIP001 	//	Fill items for position and size:
//STRIP001 	//	#108137# show action rectangle during action,
//STRIP001 	//	position and size of selected object(s) if something is selected,
//STRIP001 	//	mouse position otherwise
//STRIP001 
//STRIP001 	BOOL bActionItem = FALSE;
//STRIP001 	if ( pDrView->IsAction() )				// action rectangle
//STRIP001 	{
//STRIP001 		Rectangle aRect;
//STRIP001 		pDrView->TakeActionRect( aRect );
//STRIP001 		if ( !aRect.IsEmpty() )
//STRIP001 		{
//STRIP001 			pDrView->GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 			aSet.Put( SfxPointItem( SID_ATTR_POSITION, aRect.TopLeft() ) );
//STRIP001 			aSet.Put( SvxSizeItem( SID_ATTR_SIZE,
//STRIP001 					Size( aRect.Right() - aRect.Left(), aRect.Bottom() - aRect.Top() ) ) );
//STRIP001 			bActionItem = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( !bActionItem )
//STRIP001 	{
//STRIP001 		if ( pDrView->HasMarkedObj() )		// selected objects
//STRIP001 		{
//STRIP001 			Rectangle aRect = pDrView->GetAllMarkedRect();
//STRIP001 			pDrView->GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 			aSet.Put( SfxPointItem( SID_ATTR_POSITION, aRect.TopLeft() ) );
//STRIP001 			aSet.Put( SvxSizeItem( SID_ATTR_SIZE,
//STRIP001 					Size( aRect.Right() - aRect.Left(), aRect.Bottom() - aRect.Top() ) ) );
//STRIP001 		}
//STRIP001 		else								// mouse position
//STRIP001 		{
//STRIP001 			Point aPos = PixelToLogic(aCurMousePos);
//STRIP001 			pDrView->GetPageViewPvNum(0)->LogicToPagePos(aPos);
//STRIP001 			aSet.Put( SfxPointItem( SID_ATTR_POSITION, aPos ) );
//STRIP001 			aSet.Put( SvxSizeItem( SID_ATTR_SIZE, Size( 0, 0 ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewData->GetBindings().SetState(aSet);
//STRIP001 }

//STRIP001 BOOL ScGridWindow::DrawHasMarkedObj()
//STRIP001 {
//STRIP001 	ScDrawView* p = pViewData->GetScDrawView();
//STRIP001 	return p ? p->HasMarkedObj() : FALSE;
//STRIP001 }

/*N*/ void ScGridWindow::DrawStartTimer()
/*N*/ {
/*N*/ 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
/*N*/ 	if (pDrView)
/*N*/ 	{
		/* jetzt in DrawMarks
		USHORT nWinNum = pDrView->FindWin(this);
	    if (nWinNum!=SDRVIEWWIN_NOTFOUND)
	        pDrView->AfterInitRedraw(nWinNum);
        */
/*N*/ 
/*N*/ 		pDrView->PostPaint();
/*N*/ 		pDrView->RestartAfterPaintTimer();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScGridWindow::DrawMarkDropObj( SdrObject* pObj )
//STRIP001 {
//STRIP001 	ScDrawView* pDrView = pViewData->GetView()->GetScDrawView();
//STRIP001 	if (pDrView)
//STRIP001 		pDrView->MarkDropObj(pObj);
//STRIP001 }



}
