/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabcont.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:34:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <tools/urlobj.hxx>

#include "tabcont.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "scresid.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
// auto strip #include "transobj.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

//==================================================================

/*N*/ ScTabControl::ScTabControl( Window* pParent, ScViewData* pData ) :
/*N*/ 			TabBar( pParent, WinBits( WB_BORDER | WB_3DLOOK | WB_SCROLL |
/*N*/ 									WB_RANGESELECT | WB_MULTISELECT | WB_DRAG | WB_SIZEABLE ) ),
/*N*/ 			DropTargetHelper( this ),
/*N*/ 			DragSourceHelper( this ),
/*N*/ 			pViewData( pData ),
/*N*/ 			bErrorShown( FALSE ),
/*N*/ 			bAddDown( FALSE )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 
/*N*/ 	String aString;
/*N*/ 	USHORT nCount = pDoc->GetTableCount();
/*N*/ 	for (USHORT i=0; i<nCount; i++)
/*N*/ 	{
/*N*/ 		if (pDoc->IsVisible(i))
/*N*/ 			if (pDoc->GetName(i,aString))
/*N*/ 				if ( pDoc->IsScenario(i) )
/*N*/ 					InsertPage( i+1, aString, TPB_SPECIAL );
/*N*/ 				else
/*N*/ 					InsertPage( i+1, aString );
/*N*/ 	}
/*N*/ 
/*N*/ 	SetCurPageId( pViewData->GetTabNo() + 1 );
/*N*/ 
/*N*/ 	SetSizePixel( Size(SC_TABBAR_DEFWIDTH, 0) );
/*N*/ 
/*N*/ 	SetSplitHdl( LINK( pViewData->GetView(), ScTabView, TabBarResize ) );
/*N*/ 
/*N*/ 	EnableEditMode();
/*N*/ }

/*N*/ __EXPORT ScTabControl::~ScTabControl()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScTabControl::GetMaxId() const
/*N*/ {
/*N*/ 	USHORT nVisCnt = GetPageCount();
/*N*/ 	if (nVisCnt)
/*N*/ 		return GetPageId(nVisCnt-1);
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//STRIP001 USHORT ScTabControl::GetPrivatDropPos(const Point& rPos )
//STRIP001 {
//STRIP001 	USHORT nPos = ShowDropPos(rPos);
//STRIP001 
//STRIP001 	USHORT nRealPos = nPos;
//STRIP001 
//STRIP001 	if(nPos !=0 )
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 
//STRIP001 		USHORT nCount = pDoc->GetTableCount();
//STRIP001 
//STRIP001 		USHORT nViewPos=0;
//STRIP001 		nRealPos = nCount;
//STRIP001 		for (USHORT i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			if (pDoc->IsVisible(i))
//STRIP001 			{
//STRIP001 				nViewPos++;
//STRIP001 				if(nViewPos==nPos)
//STRIP001 				{
//STRIP001 					USHORT j;
//STRIP001 					for (j=i+1; j<nCount; j++)
//STRIP001 					{
//STRIP001 						if (pDoc->IsVisible(j))
//STRIP001 						{
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					nRealPos =j;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nRealPos ;
//STRIP001 }

//STRIP001 void __EXPORT ScTabControl::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	bAddDown = FALSE;
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( !pScMod->IsModalMode() && !pScMod->IsFormulaMode() && !IsInEditMode() )
//STRIP001 	{
//STRIP001 		//	View aktivieren
//STRIP001 		pViewData->GetViewShell()->SetActive();			// Appear und SetViewFrame
//STRIP001 		pViewData->GetView()->ActiveGrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	//	#47745# Klick neben Tabellen -> neue Tabelle einfuegen (wie im Draw)
//STRIP001 	//	eine saubere linke Maustaste ohne verwaessernde Modifier (damit koennte
//STRIP001 	///	ja das Kontextmenue gemeint sein)
//STRIP001 	if ( rMEvt.IsLeft() && !rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift())
//STRIP001 	{
//STRIP001 		Point aPos = PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 		if ( GetPageId(aPos) == 0 )
//STRIP001 			bAddDown = TRUE;				// erst im ButtonUp, weil ein Dialog kommt
//STRIP001 	}
//STRIP001 
//STRIP001 	TabBar::MouseButtonDown( rMEvt );
//STRIP001 }

//STRIP001 void __EXPORT ScTabControl::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( bAddDown )
//STRIP001 	{
//STRIP001 		Point aPos = PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 		if ( GetPageId(aPos) == 0 )
//STRIP001 		{
//STRIP001 			SfxDispatcher* pDispatcher = pViewData->GetViewShell()->GetViewFrame()->GetDispatcher();
//STRIP001 			pDispatcher->Execute( FID_INS_TABLE, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	bAddDown = FALSE;
//STRIP001 	TabBar::MouseButtonUp( rMEvt );
//STRIP001 }

//STRIP001 void __EXPORT ScTabControl::Select()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	if ( pScMod->IsTableLocked() )		// darf jetzt nicht umgeschaltet werden ?
//STRIP001 	{
//STRIP001 		//	den alten Zustand des TabControls wiederherstellen:
//STRIP001 
//STRIP001 		for (i=0; i<nCount; i++)
//STRIP001 			SelectPage( i+1, rMark.GetTableSelect(i) );
//STRIP001 		SetCurPageId( pViewData->GetTabNo() + 1 );
//STRIP001 
//STRIP001 		Sound::Beep();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nCurId = GetCurPageId();
//STRIP001 	if (!nCurId) return;			// kann vorkommen, wenn bei Excel-Import alles versteckt ist
//STRIP001 	USHORT nPage = nCurId - 1;
//STRIP001 
//STRIP001 	// OLE-inplace deaktivieren
//STRIP001 	if ( nPage != pViewData->GetTabNo() )
//STRIP001 		pViewData->GetView()->DrawMarkListHasChanged();
//STRIP001 
//STRIP001 	//	InputEnterHandler nur wenn nicht Referenzeingabe
//STRIP001 
//STRIP001 	BOOL bRefMode = pScMod->IsFormulaMode();
//STRIP001 	if (!bRefMode)
//STRIP001 		pScMod->InputEnterHandler();
//STRIP001 
//STRIP001 	for (i=0; i<nCount; i++)
//STRIP001 		rMark.SelectTable( i, IsPageSelected(i+1) );

/*		Markierungen werden per Default nicht pro Tabelle gehalten
	USHORT nSelCnt = GetSelectPageCount();
	if (nSelCnt>1)
		pDoc->ExtendMarksFromTable( nPage );
*/

//STRIP001 	SfxDispatcher& rDisp = pViewData->GetDispatcher();
//STRIP001 	if (rDisp.IsLocked())
//STRIP001 		pViewData->GetView()->SetTabNo( nPage );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	Tabelle fuer Basic ist 1-basiert
//STRIP001 		SfxUInt16Item aItem( SID_CURRENTTAB, nPage + 1 );
//STRIP001 		rDisp.Execute( SID_CURRENTTAB, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 								&aItem, (void*) NULL );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxBindings& rBind = pViewData->GetBindings();
//STRIP001 	rBind.Invalidate( FID_FILL_TAB );
//STRIP001 
//STRIP001 	rBind.Invalidate( FID_INS_TABLE );
//STRIP001 	rBind.Invalidate( FID_TAB_APPEND );
//STRIP001 	rBind.Invalidate( FID_TAB_MOVE );
//STRIP001 	rBind.Invalidate( FID_TAB_RENAME );
//STRIP001 	rBind.Invalidate( FID_DELETE_TABLE );
//STRIP001 	rBind.Invalidate( FID_TABLE_SHOW );
//STRIP001 	rBind.Invalidate( FID_TABLE_HIDE );
//STRIP001 
//STRIP001 		//	SetReference nur wenn der Konsolidieren-Dialog offen ist
//STRIP001 		//	(fuer Referenzen ueber mehrere Tabellen)
//STRIP001 		//	bei anderen gibt das nur unnoetiges Gezappel
//STRIP001 
//STRIP001 	if ( bRefMode && pViewData->GetRefType() == SC_REFTYPE_REF )
//STRIP001 		if ( pViewData->GetViewShell()->GetViewFrame()->HasChildWindow(SID_OPENDLG_CONSOLIDATE) )
//STRIP001 		{
//STRIP001 			ScRange aRange(
//STRIP001 					pViewData->GetRefStartX(), pViewData->GetRefStartY(), pViewData->GetRefStartZ(),
//STRIP001 					pViewData->GetRefEndX(), pViewData->GetRefEndY(), pViewData->GetRefEndZ() );
//STRIP001 			pScMod->SetReference( aRange, pDoc, &rMark );
//STRIP001 			pScMod->EndReference();						// wegen Auto-Hide
//STRIP001 		}
//STRIP001 }

/*N*/ void ScTabControl::UpdateStatus()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark = pViewData->GetMarkData();
/*N*/ 	BOOL bActive = pViewData->IsActive();
/*N*/ 
/*N*/ 	USHORT nCount = pDoc->GetTableCount();
/*N*/ 	USHORT i;
/*N*/ 	String aString;
/*N*/ 	USHORT nMaxCnt = Max( nCount, GetMaxId() );
/*N*/ 
/*N*/ 	BOOL bModified = FALSE;										// Tabellen-Namen
/*N*/ 	for (i=0; i<nMaxCnt && !bModified; i++)
/*N*/ 	{
/*N*/ 		if (pDoc->IsVisible(i))
/*N*/ 			pDoc->GetName(i,aString);
/*N*/ 		else
/*N*/ 			aString.Erase();
/*N*/ 
/*N*/ 		if (GetPageText(i+1) != aString)
/*N*/ 			bModified = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bModified)
/*N*/ 	{
/*N*/ 		Clear();
/*N*/ 		for (i=0; i<nCount; i++)
/*N*/ 			if (pDoc->IsVisible(i))
/*N*/ 				if (pDoc->GetName(i,aString))
/*N*/ 				if ( pDoc->IsScenario(i) )
/*?*/ 					InsertPage( i+1, aString, TPB_SPECIAL );
/*N*/ 				else
/*N*/ 					InsertPage( i+1, aString );
/*N*/ 	}
/*N*/ 	SetCurPageId( pViewData->GetTabNo() + 1 );
/*N*/ 
/*N*/ 	if (bActive)
/*N*/ 	{
/*N*/ 		bModified = FALSE;											// Selektion
/*N*/ 		for (i=0; i<nMaxCnt && !bModified; i++)
/*N*/ 			if ( rMark.GetTableSelect(i) != IsPageSelected(i+1) )
/*N*/ 				bModified = TRUE;
/*N*/ 
/*N*/ 		if ( bModified )
/*?*/ 			for (i=0; i<nCount; i++)
/*?*/ 				SelectPage( i+1, rMark.GetTableSelect(i) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabControl::ActivateView(BOOL bActivate)
//STRIP001 {
//STRIP001 //	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 
//STRIP001 //	ResetMark direkt in TabView
//STRIP001 //	pDoc->ResetMark();
//STRIP001 
//STRIP001 	USHORT nCurId = GetCurPageId();
//STRIP001 	if (!nCurId) return;			// kann vorkommen, wenn bei Excel-Import alles versteckt ist
//STRIP001 	USHORT nPage = nCurId - 1;
//STRIP001 	USHORT nCount = GetMaxId();

	/*
	USHORT i;
	for (i=0; i<nCount; i++)
	{
		SelectPage( i+1, FALSE );
		if (bActivate)
			rMark.SelectTable( i, FALSE );
	}
	*/
//STRIP001 	if (bActivate)
//STRIP001 	{
//STRIP001 		SelectPage( nPage+1, TRUE );
//STRIP001 		rMark.SelectTable( nPage, TRUE );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }

//STRIP001 void __EXPORT ScTabControl::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	ScModule*		pScMod	 = SC_MOD();
//STRIP001 	ScTabViewShell* pViewSh  = pViewData->GetViewShell();
//STRIP001 	BOOL 			bDisable = pScMod->IsFormulaMode() || pScMod->IsModalMode();
//STRIP001 
//STRIP001 	// ViewFrame erstmal aktivieren (Bug 19493):
//STRIP001 	pViewSh->SetActive();
//STRIP001 
//STRIP001 	USHORT nCmd = rCEvt.GetCommand();
//STRIP001 	if ( nCmd == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		if (!bDisable)
//STRIP001 		{
//STRIP001 			//	nur eine Tabelle selektieren:
			/*
			USHORT nId = GetPageId( rCEvt.GetMousePosPixel() );
			if (nId)
			{
				SetCurPageId( nId );
				USHORT nCount = GetMaxId();

				for (USHORT i=1; i<=nCount; i++)
					SelectPage( i, i==nId );
				Select();
			}
			*/
//STRIP001 			//	Popup-Menu:
//STRIP001 			pViewSh->GetDispatcher()->ExecutePopup( ScResId(RID_POPUP_TAB) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabControl::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	BOOL bDisable = pScMod->IsFormulaMode() || pScMod->IsModalMode();
//STRIP001 
//STRIP001 	if (!bDisable)
//STRIP001 	{
//STRIP001 		Region aRegion( Rectangle(0,0,0,0) );
//STRIP001 		::com::mandEvent aCEvt( rPosPixel, COMMAND_STARTDRAG, TRUE );	// needed for StartDrag
//STRIP001 		if (TabBar::StartDrag( aCEvt, aRegion ))
//STRIP001 			DoDrag( aRegion );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabControl::DoDrag( const Region& rRegion )
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScMarkData aTabMark = pViewData->GetMarkData();
//STRIP001 	aTabMark.ResetMark();	// doesn't change marked table information
//STRIP001 	aTabMark.SetMarkArea( ScRange(0,0,nTab,MAXCOL,MAXROW,nTab) );
//STRIP001 
//STRIP001 	ScDocument* pClipDoc = new ScDocument( SCDOCMODE_CLIP );
//STRIP001 	pDoc->CopyToClip( 0,0, MAXCOL,MAXROW, FALSE, pClipDoc, FALSE, &aTabMark );
//STRIP001 
//STRIP001 	TransferableObjectDescriptor aObjDesc;
//STRIP001 	pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 	aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 	// maSize is set in ScTransferObj ctor
//STRIP001 
//STRIP001 	ScTransferObj* pTransferObj = new ScTransferObj( pClipDoc, aObjDesc );
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable> xTransferable( pTransferObj );
//STRIP001 
//STRIP001 	pTransferObj->SetDragSourceFlags( SC_DROP_TABLE );
//STRIP001 
//STRIP001 	pTransferObj->SetDragSource( pDocSh, aTabMark );
//STRIP001 
//STRIP001 	Window* pWindow = pViewData->GetActiveWin();
//STRIP001 	SC_MOD()->SetDragObject( pTransferObj, NULL );		// for internal D&D
//STRIP001 	pTransferObj->StartDrag( pWindow, DND_ACTION_COPYMOVE | DND_ACTION_LINK );
//STRIP001 }

//STRIP001 USHORT lcl_DocShellNr( ScDocument* pDoc )
//STRIP001 {
//STRIP001 	USHORT nShellCnt = 0;
//STRIP001 	SfxObjectShell* pShell = SfxObjectShell::GetFirst();
//STRIP001 	while ( pShell )
//STRIP001 	{
//STRIP001 		if ( pShell->Type() == TYPE(ScDocShell) )
//STRIP001 		{
//STRIP001 			if ( ((ScDocShell*)pShell)->GetDocument() == pDoc )
//STRIP001 				return nShellCnt;
//STRIP001 
//STRIP001 			++nShellCnt;
//STRIP001 		}
//STRIP001 		pShell = SfxObjectShell::GetNext( *pShell );
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ERROR("Dokument nicht gefunden");
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 sal_Int8 ScTabControl::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	EndSwitchPage();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	const ScDragData& rData = SC_MOD()->GetDragData();
//STRIP001 	if ( rData.pCellTransfer && ( rData.pCellTransfer->GetDragSourceFlags() & SC_DROP_TABLE ) &&
//STRIP001 			rData.pCellTransfer->GetSourceDocument() == pDoc )
//STRIP001 	{
//STRIP001 		// moving of tables within the document
//STRIP001 		USHORT nPos = GetPrivatDropPos( rEvt.maPosPixel );
//STRIP001 		HideDropPos();
//STRIP001 		if ( !pDoc->GetChangeTrack() && pDoc->IsDocEditable() )
//STRIP001 		{
//STRIP001 			//!	use table selection from the tab control where dragging was started?
//STRIP001 			pViewData->GetView()->MoveTable( lcl_DocShellNr(pDoc), nPos, rEvt.mnAction != DND_ACTION_MOVE );
//STRIP001 
//STRIP001 			rData.pCellTransfer->SetDragWasInternal();			// don't delete
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			Sound::Beep();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 sal_Int8 ScTabControl::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	if ( rEvt.mbLeaving )
//STRIP001 	{
//STRIP001 		EndSwitchPage();
//STRIP001 		HideDropPos();
//STRIP001 		return rEvt.mnAction;
//STRIP001 	}
//STRIP001 
//STRIP001 	const ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	const ScDragData& rData = SC_MOD()->GetDragData();
//STRIP001 	if ( rData.pCellTransfer && ( rData.pCellTransfer->GetDragSourceFlags() & SC_DROP_TABLE ) &&
//STRIP001 			rData.pCellTransfer->GetSourceDocument() == pDoc )
//STRIP001 	{
//STRIP001 		// moving of tables within the document
//STRIP001 		if ( !pDoc->GetChangeTrack() && pDoc->IsDocEditable() )
//STRIP001 		{
//STRIP001 			ShowDropPos( rEvt.maPosPixel );
//STRIP001 			return rEvt.mnAction;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else 					// switch sheets for all formats
//STRIP001 	{
//STRIP001 		SwitchPage( rEvt.maPosPixel );		// switch sheet after timeout
//STRIP001 		return 0;							// nothing can be dropped here
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 long ScTabControl::StartRenaming()
//STRIP001 {
//STRIP001 	if ( pViewData->GetDocument()->IsDocEditable() )
//STRIP001 		return TAB_RENAMING_YES;
//STRIP001 	else
//STRIP001 		return TAB_RENAMING_NO;
//STRIP001 }

//STRIP001 long ScTabControl::AllowRenaming()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 	DBG_ASSERT( pViewSh, "pViewData->GetViewShell()" );
//STRIP001 
//STRIP001 	long nRet = TAB_RENAMING_CANCEL;
//STRIP001 	USHORT nId = GetEditPageId();
//STRIP001 	if ( nId )
//STRIP001 	{
//STRIP001 		USHORT nTab = nId - 1;
//STRIP001 		String aNewName = GetEditText();
//STRIP001 		BOOL bDone = pViewSh->RenameTable( aNewName, nTab );
//STRIP001 		if ( bDone )
//STRIP001 			nRet = TAB_RENAMING_YES;
//STRIP001 		else if ( bErrorShown )
//STRIP001 		{
//STRIP001 			//	if the error message from this TabControl is currently visible,
//STRIP001 			//	don't end edit mode now, to avoid problems when returning to
//STRIP001 			//	the other call (showing the error) - this should not happen
//STRIP001 			DBG_ERROR("ScTabControl::AllowRenaming: nested calls");
//STRIP001 			nRet = TAB_RENAMING_NO;
//STRIP001 		}
//STRIP001 		else if ( Application::IsInModalMode() )
//STRIP001 		{
//STRIP001 			//	#73472# don't show error message above any modal dialog
//STRIP001 			//	instead cancel renaming without error message
//STRIP001 			nRet = TAB_RENAMING_CANCEL;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bErrorShown = TRUE;
//STRIP001 			pViewSh->ErrorMessage( STR_INVALIDTABNAME );
//STRIP001 			bErrorShown = FALSE;
//STRIP001 			nRet = TAB_RENAMING_NO;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 void ScTabControl::EndRenaming()
//STRIP001 {
//STRIP001 	if ( HasFocus() )
//STRIP001 		pViewData->GetView()->ActiveGrabFocus();
//STRIP001 }




}
