/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_AccessibleChartElement.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:08:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "AccessibleChartElement.hxx"

#ifndef _COM_SUN_STAR_AWT_XDEVICE_HPP_
#include <com/sun/star/awt/XDevice.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTOBJECT_HPP_
#include <com/sun/star/accessibility/AccessibleEventObject.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

// for SolarMutex
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _RTL_UUID_H_
#include <rtl/uuid.h>
#endif
#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include <cppuhelper/queryinterface.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef SVX_UNOFDESC_HXX
#include <bf_svx/unofdesc.hxx>
#endif
#ifndef _OUTLINER_HXX
#include <bf_svx/outliner.hxx>
#endif
#ifndef _SVDOUTL_HXX
#include <bf_svx/svdoutl.hxx>
#endif
#ifndef _SVDETC_HXX
#include <bf_svx/svdetc.hxx>
#endif
#ifndef _SVX_UNOSHAPE_HXX
#include <bf_svx/unoshape.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHVIEW_HXX
#include "schview.hxx"
#endif
#ifndef _SCH_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#ifndef _SCH_PROPERTYCHANGEHINT_HXX
#include "PropertyChangeHint.hxx"
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;

using ::rtl::OUString;
using ::osl::MutexGuard;
using ::osl::ClearableMutexGuard;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::Any;

using ::com::sun::star::drawing::XShape;

namespace accessibility
{

AccessibleChartElement::AccessibleChartElement(
    const AccessibleUniqueId & rId,
    AccessibleBase * pParent,
    bool bMayHaveChildren /* default: false */,
    bool bAlwaysTransparent /* default: false */) :

        AccessibleBase( rId, pParent, bMayHaveChildren ),

        m_pItemSet( 0 ),
        m_bAlwaysTransparent( bAlwaysTransparent ),
        m_bStateSetInitialized( false )
{
}

AccessibleChartElement::~AccessibleChartElement()
{
    OSL_ASSERT( CheckDisposeState( false /* don't throw exceptions */ ) );
    if( m_pItemSet )
        delete m_pItemSet;
}

bool AccessibleChartElement::NotifyEvent(
    EventType eType,
    const AccessibleUniqueId & rId,
    const SfxHint * pHint )
{
    if( GetId() == rId )
    {
        // event is addressed to this object

        ::com::sun::star::uno::Any aEmpty;
        ::com::sun::star::uno::Any aSelected;
        aSelected <<= AccessibleStateType::SELECTED;
        switch( eType )
        {
            case OBJECT_CHANGE:
                {
                    BroadcastAccEvent( AccessibleEventId::VISIBLE_DATA_CHANGED, aEmpty, aEmpty );
#if OSL_DEBUG_LEVEL > 1
                    OSL_TRACE(
                        ::rtl::OUStringToOString(
                            OUString( RTL_CONSTASCII_USTRINGPARAM(
                                          "Visible data event sent by: " )) +
                            const_cast< AccessibleChartElement * >( this )->getAccessibleName(),
                            RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                }
                break;

            case GOT_SELECTION:
                {
                    AddState( AccessibleStateType::SELECTED );
                    BroadcastAccEvent( AccessibleEventId::STATE_CHANGED, aSelected, aEmpty );

                    AddState( AccessibleStateType::FOCUSED );
                    aSelected <<= AccessibleStateType::FOCUSED;
                    BroadcastAccEvent( AccessibleEventId::STATE_CHANGED, aSelected, aEmpty, true );
#if OSL_DEBUG_LEVEL > 1
                    OSL_TRACE(
                        ::rtl::OUStringToOString(
                            OUString( RTL_CONSTASCII_USTRINGPARAM(
                                          "Selection acquired by: " )) +
                            const_cast< AccessibleChartElement * >( this )->getAccessibleName(),
                            RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                }
                break;

            case LOST_SELECTION:
                {
                    RemoveState( AccessibleStateType::SELECTED );
                    BroadcastAccEvent( AccessibleEventId::STATE_CHANGED, aEmpty, aSelected );

                    AddState( AccessibleStateType::FOCUSED );
                    aSelected <<= AccessibleStateType::FOCUSED;
                    BroadcastAccEvent( AccessibleEventId::STATE_CHANGED, aEmpty, aSelected, true );
#if OSL_DEBUG_LEVEL > 1
                    OSL_TRACE(
                        ::rtl::OUStringToOString(
                            OUString( RTL_CONSTASCII_USTRINGPARAM(
                                          "Selection lost by: " )) +
                            const_cast< AccessibleChartElement * >( this )->getAccessibleName(),
                            RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                }
                break;

            case PROPERTY_CHANGE:
                {
                    // refresh item set
                    if( pHint &&
                        pHint->ISA( SchPropertyChangeHint ))
                    {
                        SetItemSet( static_cast< const SchPropertyChangeHint * >( pHint )->
                                    GetItemSet() );
                    }
                    BroadcastAccEvent( AccessibleEventId::VISIBLE_DATA_CHANGED, aEmpty, aEmpty );
#if OSL_DEBUG_LEVEL > 1
                    OSL_TRACE(
                        ::rtl::OUStringToOString(
                            OUString( RTL_CONSTASCII_USTRINGPARAM(
                                          "Visible data event sent by: " )) +
                            const_cast< AccessibleChartElement * >( this )->getAccessibleName(),
                            RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                }
                break;
        }
        return true;
    }
    else
        // notify children
        return AccessibleBase::NotifyEvent( eType, rId, pHint );
}

SdrObject * AccessibleChartElement::GetDrawObject() const
{
    CheckDisposeState();

    SdrObject * pShape = NULL;

    ChartModel * pModel = GetChartModel();
    if( pModel != NULL )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        pShape = GetObjWithId( GetId().GetObjectId(), *pModel->GetPage( 0 ), 0, IM_DEEPWITHGROUPS );
        // \-- solar
    }

    return pShape;
}

void AccessibleChartElement::SetItemSet( const SfxItemSet & rNewItemSet )
{
    MutexGuard aGuard( GetMutex());

    // there is no public assignment operator
    if( m_pItemSet )
        delete m_pItemSet;

    m_pItemSet = new SfxItemSet( rNewItemSet );
}

const SfxItemSet * AccessibleChartElement::GetItemSet() const
{
    return m_pItemSet;
}

// ________ AccessibleChartElement::XInterface ________
Any SAL_CALL AccessibleChartElement::queryInterface( const uno::Type& aType )
    throw (uno::RuntimeException)
{
    Any aAny = AccessibleBase::queryInterface( aType );
	if( aAny.hasValue() )
		return aAny;

	return ::cppu::queryInterface(
		aType,
        static_cast< XAccessibleExtendedComponent * >( this )
        );
}

void SAL_CALL AccessibleChartElement::acquire()
    throw ()
{
    AccessibleBase::acquire();
}

void SAL_CALL AccessibleChartElement::release()
    throw ()
{
    AccessibleBase::release();
}

// ________ AccessibleChartElement::XTypeProvider ________
Sequence< uno::Type > SAL_CALL AccessibleChartElement::getTypes()
    throw (uno::RuntimeException)
{
    static Sequence< uno::Type > st_aTypeSequence;

    if( st_aTypeSequence.getLength() == 0 )
    {
        MutexGuard aGuard( GetMutex() );

        // check again with locked mutex
        if( st_aTypeSequence.getLength() == 0 )
        {
            st_aTypeSequence = AccessibleBase::getTypes();
            st_aTypeSequence.realloc( st_aTypeSequence.getLength() + 1 );
            st_aTypeSequence[ st_aTypeSequence.getLength() - 1 ] =
                ::getCppuType( (const Reference< XAccessibleExtendedComponent > *)0 );
        }
    }

    return st_aTypeSequence;
}

Sequence< sal_Int8 > SAL_CALL AccessibleChartElement::getImplementationId()
    throw (uno::RuntimeException)
{
	static Sequence< sal_Int8 > aId;
	if( aId.getLength() == 0 )
	{
		aId.realloc( 16 );
		rtl_createUuid( (sal_uInt8 *)aId.getArray(), 0, sal_True );
	}
	return aId;
}

// ________ AccessibleChartElement::XServiceInfo ________
OUString SAL_CALL AccessibleChartElement::getImplementationName()
    throw (uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccessibleChartElement" ));
}

Sequence< OUString > SAL_CALL AccessibleChartElement::getSupportedServiceNames()
    throw (uno::RuntimeException)
{
    Sequence< OUString > aResult = AccessibleBase::getSupportedServiceNames();
    aResult.realloc( aResult.getLength() + 1 );
    aResult[ aResult.getLength() - 1 ] =
        OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.chart.AccessibleChartElement" ));

    return aResult;
}

// ________ AccessibleChartElement::XComponent ________
void SAL_CALL AccessibleChartElement::dispose()
    throw (uno::RuntimeException)
{
    {
        // /--
        MutexGuard aGuard( GetMutex() );
        if( m_pItemSet )
            delete m_pItemSet;

        m_pItemSet = 0;
        // \--
    }

    AccessibleBase::dispose();
}

// ________ AccessibleChartElement::XAccessibleContext (overloaded) ________
OUString SAL_CALL AccessibleChartElement::getAccessibleDescription()
    throw (::com::sun::star::uno::RuntimeException)
{
    return getToolTipText();
}

OUString SAL_CALL AccessibleChartElement::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return getToolTipText();
}

Reference< XAccessibleStateSet > SAL_CALL AccessibleChartElement::getAccessibleStateSet()
    throw (uno::RuntimeException)
{
    if( ! m_bStateSetInitialized )
    {
        SchWindow * pWin = GetWindow();
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        if( ! m_bStateSetInitialized &&
            pWin )
        {
            SchViewShell * pViewShell = pWin->GetViewShell();
            if( pViewShell )
            {
                SchView * pView = pViewShell->GetView();
                if( pView )
                {
                    const SdrMarkList & rMarkList = pView->GetMarkList();
                    if( rMarkList.GetMarkCount() > 0 )
                    {
                        SdrObject * pObj = rMarkList.GetMark( 0 )->GetObj();
                        if( pObj == GetDrawObject() )
                        {
                            AddState( AccessibleStateType::SELECTED );
                            AddState( AccessibleStateType::FOCUSED );
                        }
                    }
                }
            }
            m_bStateSetInitialized = true;
        }
        // \-- solar
    }

    return AccessibleBase::getAccessibleStateSet();
}

// ________ AccessibleChartElement::XAccessibleExtendedComponent ________
Reference< awt::XFont > SAL_CALL AccessibleChartElement::getFont()
    throw (uno::RuntimeException)
{
    CheckDisposeState();

    Reference< awt::XFont > aFont;
    Window * pWin = GetWindow();

    if( pWin != NULL &&
        m_pItemSet != NULL )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        Reference< awt::XDevice > xDevice( pWin->GetComponentInterface(), uno::UNO_QUERY );
        if( xDevice.is())
        {
            awt::FontDescriptor aDescr;
            {
                // /--
                MutexGuard aGuard( GetMutex() );
                if( m_pItemSet != NULL )
                    SvxUnoFontDescriptor::FillFromItemSet( *m_pItemSet, aDescr );
                // \--
            }
            aFont = xDevice->getFont( aDescr );
        }
        // \-- solar
    }

    return aFont;
}

OUString SAL_CALL AccessibleChartElement::getTitledBorderText()
    throw (uno::RuntimeException)
{
    return OUString();
}

OUString SAL_CALL AccessibleChartElement::getToolTipText()
    throw (::com::sun::star::uno::RuntimeException)
{
    CheckDisposeState();

    ChartModel* pModel = NULL;
    SchWindow * pWin   = NULL;
    sal_uInt16 nObjectId = CHOBJID_ANY;

    {
        // /--
        MutexGuard aGuard( GetMutex());

        pModel = GetChartModel();
        pWin = GetWindow();
        nObjectId = GetId().GetObjectId();
        // \--
    }

    if( pModel != NULL &&
        pWin != NULL )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        return OUString( pWin->GetQuickHelpText( nObjectId, pModel, FALSE ));
        // \-- solar
    }
    else
        return OUString();
}


// ________ AccessibleChartElement::XAccessibleComponent ________

awt::Rectangle SAL_CALL AccessibleChartElement::getBounds()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    Rectangle aRect;
    awt::Point aOffset;

    SdrObject * pObj = GetDrawObject();
    if( pObj != NULL )
    {
        aRect = pObj->GetBoundRect();

        // change into pixel coordinates
        Window * pWin = GetWindow();
        if( pWin != NULL )
        {
            // /-- solar
            ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
            aRect = pWin->LogicToPixel( aRect );
            // \-- solar
        }

        // SdrObject::GetBoundRect() ist relative to the page, but we need a
        // value relative to the parent object
        awt::Point aParentLocOnScreen;
        uno::Reference< XAccessibleComponent > xParent( getAccessibleParent(), uno::UNO_QUERY );
        if( xParent.is() )
            aParentLocOnScreen = xParent->getLocationOnScreen();

        // aOffset = aParentLocOnScreen - GetUpperLeftOnScreen()
        awt::Point aULOnScreen = GetUpperLeftOnScreen();
        aOffset.X = aParentLocOnScreen.X - aULOnScreen.X;
        aOffset.Y = aParentLocOnScreen.Y - aULOnScreen.Y;
    }

    return awt::Rectangle( aRect.Left() - aOffset.X, aRect.Top() - aOffset.Y,
                           aRect.GetWidth(), aRect.GetHeight());
}

// the following interface is implemented in AccessibleBase, however it is also
// a (non-virtual) base class of XAccessibleExtendedComponent Thus these methods
// have to be overloaded and forwarded to AccessibleBase


// ________ AccessibleChartElement::XAccessibleComponent ________
sal_Bool SAL_CALL AccessibleChartElement::containsPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    return AccessibleBase::containsPoint( aPoint );
}

uno::Reference< XAccessible > SAL_CALL AccessibleChartElement::getAccessibleAtPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    return AccessibleBase::getAccessibleAtPoint( aPoint );
}

awt::Point SAL_CALL AccessibleChartElement::getLocation()
    throw (uno::RuntimeException)
{
    return AccessibleBase::getLocation();
}

awt::Point SAL_CALL AccessibleChartElement::getLocationOnScreen()
    throw (uno::RuntimeException)
{
    return AccessibleBase::getLocationOnScreen();
}

awt::Size SAL_CALL AccessibleChartElement::getSize()
    throw (uno::RuntimeException)
{
    return AccessibleBase::getSize();
}

void SAL_CALL AccessibleChartElement::grabFocus()
    throw (uno::RuntimeException)
{
    CheckDisposeState();

    SdrObject * pObj = GetDrawObject();
    SchWindow * pWin = GetWindow();

    if( pObj &&
        pWin )
	{
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        SchViewShell * pViewShell = pWin->GetViewShell();
        SchView * pView = pViewShell ? pViewShell->GetView() : 0;

        if( pViewShell &&
            pView )
        {
            SuspendSelectionChangeBroadcasting aGuard( pViewShell );
            pView->UnmarkAll ();
            pView->LeaveAllGroup ();

            pView->SetMarkHdlHidden( TRUE );
            pView->MarkObj( pObj, pView->GetPageViewPvNum( 0 ));
            pView->SetMarkHdlHidden( FALSE );
        }
        // \-- solar
	}
}

sal_Int32 SAL_CALL AccessibleChartElement::getForeground()
    throw (uno::RuntimeException)
{
    CheckDisposeState();

    // return the line color
    if( m_pItemSet )
    {
        // /--
        MutexGuard aGuard( GetMutex());
        if( m_pItemSet )
        {
            Color aCol( static_cast< const XColorItem & >( m_pItemSet->Get( XATTR_LINECOLOR )).GetValue() );

            // cast from ColorData (UINT32) to signed 32 bit integer
            return static_cast< sal_Int32 >( aCol.GetColor() );
        }
        // \--
    }

    return 0;
}

sal_Int32 SAL_CALL AccessibleChartElement::getBackground()
    throw (uno::RuntimeException)
{
    CheckDisposeState();
    sal_Int32 nColor = 0xffffff;

    if( m_pItemSet )
    {
        // /--
        ClearableMutexGuard aGuard( GetMutex() );
        if( m_pItemSet )
        {
            SfxItemSet aSet( *m_pItemSet );
            bool bIsTransparent = m_bAlwaysTransparent;
            aGuard.clear();
            // \-- 1st

            ChartModel * pModel = GetChartModel();
            if( pModel != NULL )
            {
                // /-- solar
                ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );

                Color aCol( COL_TRANSPARENT );
                if( ! bIsTransparent )
                    GetDraftFillColor( aSet, aCol );
                nColor = static_cast< sal_Int32 >( aCol.GetColor());

//                 if( nColor == COL_TRANSPARENT )
//                 {
//                     // if object is transparent
//                     Outliner * pOutliner = pModel->GetOutliner();
//                     if( pOutliner != NULL )
//                     {
//                         // cast from ColorData (UINT32) to signed 32 bit integer
//                         nColor = static_cast< sal_Int32 >( pOutliner->GetBackgroundColor().GetColor());
//                     }
//                 }
                // \-- solar
            }
        }
        // \-- 2nd
    }

    return nColor;
}

} // namespace accessibility
}
