/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_futransform.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:31:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {
//STRIP001 #include "futransform.hxx"
//STRIP001 
//STRIP001 // headers from chart
//STRIP001 #include "schview.hxx"
//STRIP001 #include "schresid.hxx"
//STRIP001 #include "strings.hrc"
//STRIP001 #include "chtmodel.hxx"
//STRIP001 #include "schgroup.hxx"
//STRIP001 #include "transform.hxx"
//STRIP001 
//STRIP001 // headers from other dlls
//STRIP001 #ifndef _E3D_POLYSC3D_HXX
//STRIP001 #include <bf_svx/polysc3d.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MSGBOX_HXX
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #include "undmovsize.hxx"
//STRIP001 #include "viewshel.hxx"
//STRIP001 #include "chtscene.hxx"
//STRIP001 
//STRIP001 TYPEINIT1( SchFuTransform, SchFuPoor );
//STRIP001 
//STRIP001 SchFuTransform::SchFuTransform(
//STRIP001     SchViewShell* pViewShell, SchWindow* pWindow, SchView* pView,
//STRIP001     ChartModel* pModel, SfxRequest& rRequest ) :
//STRIP001         SchFuPoor( pViewShell, pWindow, pView, pModel, rRequest )
//STRIP001 {
//STRIP001     if( pView->HasMarkedObj() )
//STRIP001     {
//STRIP001 		const SfxItemSet* pArgs = rRequest.GetArgs();
//STRIP001 
//STRIP001 		if( NULL == pArgs )
//STRIP001 		{
//STRIP001 			// item set for size and position
//STRIP001 			SfxItemSet aSet( pView->GetGeoAttrFromMarked() );
//STRIP001             aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_POS );
//STRIP001             aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );
//STRIP001 
//STRIP001 			const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 			SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001             bool bSizable = false;
//STRIP001             bool bRotatable = false;
//STRIP001 
//STRIP001 			Matrix4D	aUndoOldSceneMatrix;
//STRIP001 			SfxItemSet	aUndoItemSet(aSet);
//STRIP001 
//STRIP001             DBG_ASSERT( pObj, "Have Marked Object, but Object is NULL!" );
//STRIP001 
//STRIP001             UINT16 nObjId = CHOBJID_ANY;
//STRIP001             SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001             if( pObjId )
//STRIP001                 nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001             if( CHOBJID_DIAGRAM == nObjId )
//STRIP001             {
//STRIP001                 bSizable = true;
//STRIP001                 bRotatable = ( TRUE == pChDoc->Is3DChart() );
//STRIP001 				if(pObj&&pObj->ISA(ChartScene))
//STRIP001 					aUndoOldSceneMatrix = ((ChartScene*)pObj)->GetTransform();
//STRIP001             }
//STRIP001 
//STRIP001             SchTransformTabDialog aDlg = SchTransformTabDialog( NULL, &aSet, pView, bSizable, bRotatable );
//STRIP001             if( aDlg.Execute() != RET_OK )
//STRIP001                 return;
//STRIP001            
//STRIP001             rRequest.Done( *( aDlg.GetOutputItemSet() ) );
//STRIP001             pArgs = rRequest.GetArgs();
//STRIP001 
//STRIP001             // apply changed attributes only for ChartScene via DrawingLayer
//STRIP001             // necessary to get the new adjusted attributes
//STRIP001             if(pObj&&pObj->ISA(ChartScene)) 
//STRIP001             {
//STRIP001                 pView->SetGeoAttrToMarked( *pArgs );
//STRIP001                 pView->SetAttributes( *pArgs );
//STRIP001             }
//STRIP001 
//STRIP001 			//create undo action and use undo-action to perform the action itself
//STRIP001 			{
//STRIP001 				Rectangle aOldPosSize(0,0,0,0);
//STRIP001 				Rectangle aNewPosSize(0,0,0,0);
//STRIP001 				Rectangle aRotateDummy(0,0,0,0);
//STRIP001 				Matrix4D  aUndoNewSceneMatrix;
//STRIP001 
//STRIP001 				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aOldPosSize,aRotateDummy);
//STRIP001 				aUndoItemSet.Put(*pArgs);//overwrite old items with changed ones
//STRIP001 				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aNewPosSize,aRotateDummy);
//STRIP001 				
//STRIP001 				if(pObj&&pObj->ISA(ChartScene))
//STRIP001 				{
//STRIP001 					aUndoNewSceneMatrix = ((ChartScene*)pObj)->GetTransform();
//STRIP001 					aNewPosSize = pObj->GetSnapRect();
//STRIP001 				}
//STRIP001                 else if(pObj&&pObj->ISA(SchObjGroup)&&nObjId==CHOBJID_DIAGRAM)
//STRIP001                 {
//STRIP001                     aOldPosSize = pChDoc->GetChartRect();
//STRIP001                     aNewPosSize = CreateNewDiagrammRectangle(aNewPosSize, pObj->GetSnapRect(), pChDoc->GetChartRect());
//STRIP001                 }
//STRIP001 				
//STRIP001 
//STRIP001 				SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize( *pChDoc, nObjId
//STRIP001 					, aOldPosSize, aNewPosSize
//STRIP001 					, aUndoOldSceneMatrix, aUndoNewSceneMatrix );
//STRIP001 
//STRIP001                 //perform the action itself:
//STRIP001                 pUndo->Redo();
//STRIP001 
//STRIP001 
//STRIP001 				pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 					GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 			}
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 SchFuTransform::~SchFuTransform()
//STRIP001 {}
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function aktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SchFuTransform::Activate()
//STRIP001 {
//STRIP001 	SchFuPoor::Activate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function deaktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SchFuTransform::Deactivate()
//STRIP001 {
//STRIP001 	SchFuPoor::Deactivate();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function ResizeObject
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Point SchFuTransform::GetPoint( Rectangle aRect, RECT_POINT eRP )
//STRIP001 {
//STRIP001     switch( eRP )
//STRIP001 	{
//STRIP001 		case RP_LT: return Point( aRect.Left(), aRect.Top() );
//STRIP001 		case RP_MT: return Point( aRect.Center().X(), aRect.Top() );
//STRIP001 		case RP_RT: return Point( aRect.Right(), aRect.Top() );
//STRIP001 		case RP_LM: return Point( aRect.Left(), aRect.Center().Y() );
//STRIP001 		case RP_MM: return Point( aRect.Center().X(), aRect.Center().Y() );
//STRIP001 		case RP_RM: return Point( aRect.Right(), aRect.Center().Y() );
//STRIP001 		case RP_LB: return Point( aRect.Left(), aRect.Bottom() );
//STRIP001 		case RP_MB: return Point( aRect.Center().X(), aRect.Bottom() );
//STRIP001 		case RP_RB: return Point( aRect.Right(), aRect.Bottom() );
//STRIP001 	}
//STRIP001     return Point( 0, 0 );
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SchFuTransform::CreateNewDiagrammRectangle(const Rectangle& rNew, const Rectangle& rOld, const Rectangle& rOldChartRect)
//STRIP001 {
//STRIP001     //rNew is the new bound or snap rect
//STRIP001     //rOld is the old bound or snap rect (bound and snap rect should be ever identical for 2D Diagramms)
//STRIP001 	
//STRIP001     //remind differences between old ChartRect and old BoundRect:
//STRIP001 	Point aDifferenceLeftBottom = rOldChartRect.BottomLeft() - rOld.BottomLeft();
//STRIP001 	Point aDifferenceTopRight = rOldChartRect.TopRight() - rOld.TopRight();
//STRIP001 
//STRIP001     //take the new BoundRect
//STRIP001     Rectangle aRect(rNew);
//STRIP001     //add old differences to new BoundRect to receive the new ChartRect
//STRIP001 	aRect.Left() += aDifferenceLeftBottom.X();
//STRIP001 	aRect.Bottom() += aDifferenceLeftBottom.Y();
//STRIP001 	aRect.Right() += aDifferenceTopRight.X();
//STRIP001 	aRect.Top() += aDifferenceTopRight.Y();
//STRIP001     return aRect;
//STRIP001 }

}
