/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:36:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

// auto strip #ifndef _SVDOGRAF_HXX
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
#ifndef _ZOOMITEM_HXX
#include <bf_svx/zoomitem.hxx>
#endif
// auto strip #ifndef _EDITDATA_HXX
// auto strip #include <bf_svx/editdata.hxx>
// auto strip #endif
// auto strip #ifndef _SB_SBERRORS_HXX //autogen
// auto strip #include <basic/sberrors.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef SVX_XFILLIT0_HXX //autogen
// auto strip #include <bf_svx/xfillit0.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XFLCLIT_HXX //autogen
// auto strip #include <bf_svx/xflclit.hxx>
// auto strip #endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

// auto strip #ifndef _DATE_HXX
// auto strip #include <tools/date.hxx>
// auto strip #endif

// auto strip #ifndef _TOOLS_TIME_HXX
// auto strip #include <tools/time.hxx>
// auto strip #endif

#define ITEMID_FIELD	EE_FEATURE_FIELD
// auto strip #ifndef _SVX_FLDITEM_HXX //autogen
// auto strip #include <bf_svx/flditem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XLINEIT0_HXX //autogen
// auto strip #include <bf_svx/xlineit0.hxx>
// auto strip #endif
// auto strip #ifndef SVX_XFILLIT0_HXX //autogen
// auto strip #include <bf_svx/xfillit0.hxx>
// auto strip #endif

// auto strip #ifndef _SDOUTL_HXX //autogen
// auto strip #include <bf_svx/svdoutl.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_XLNWTIT_HXX
// auto strip #include <bf_svx/xlnwtit.hxx>
// auto strip #endif
#ifndef _SVDOATTR_HXX //autogen
#include <bf_svx/svdoattr.hxx>
#endif
// auto strip #ifndef _SVX_XLNSTWIT_HXX
// auto strip #include <bf_svx/xlnstwit.hxx>
// auto strip #endif
// auto strip #ifndef _SDTMFITM_HXX //autogen
// auto strip #include <bf_svx/sdtmfitm.hxx>
// auto strip #endif
// auto strip #ifndef _SDTAGITM_HXX //autogen
// auto strip #include <bf_svx/sdtagitm.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XLNEDWIT_HXX
// auto strip #include <bf_svx/xlnedwit.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLG_NAME_HXX
// auto strip #include <bf_svx/dlgname.hxx>
// auto strip #endif

#pragma hdrstop

#include "app.hrc"
#include "glob.hrc"
#include "helpids.h"
// auto strip #include "sdattr.hxx"
#include "drawview.hxx"
#include "sdwindow.hxx"
// auto strip #include "ins_page.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdpage.hxx"
//STRIP001 #include "preview.hxx"
// auto strip #include "fuscale.hxx"
#include "sdresid.hxx"
// auto strip #include "new_foil.hxx"
// auto strip #include "drviewsh.hxx"
#include "grviewsh.hxx"
// auto strip #include "unmodpg.hxx"
#include "fuslshow.hxx"
// auto strip #include "fuvect.hxx"
// auto strip #include "stlpool.hxx"

// #90356#
#ifndef _SD_OPTSITEM_HXX
#include "optsitem.hxx"
#endif
namespace binfilter {

/*************************************************************************
|*
|* modal dialog for #90356#
|*
\************************************************************************/

//STRIP001 class ImpUndoDeleteWarning : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 	FixedImage		maImage;
//STRIP001 	FixedText		maWarningFT;
//STRIP001 	CheckBox		maDisableCB;
//STRIP001 	OKButton		maYesBtn;
//STRIP001 	CancelButton	maNoBtn;
//STRIP001 
//STRIP001 public:
//STRIP001 	ImpUndoDeleteWarning(Window* pParent);
//STRIP001 	BOOL IsWarningDisabled() const { return maDisableCB.IsChecked(); }
//STRIP001 };
//STRIP001 
//STRIP001 ImpUndoDeleteWarning::ImpUndoDeleteWarning(Window* pParent) 
//STRIP001 :	ModalDialog(pParent, SdResId(RID_UNDO_DELETE_WARNING)),
//STRIP001 	maImage(this, SdResId(IMG_UNDO_DELETE_WARNING)),
//STRIP001 	maWarningFT(this, SdResId(FT_UNDO_DELETE_WARNING)),
//STRIP001 	maDisableCB(this, SdResId(CB_UNDO_DELETE_DISABLE)),
//STRIP001 	maYesBtn(this, SdResId(BTN_UNDO_DELETE_YES)),
//STRIP001 	maNoBtn(this, SdResId(BTN_UNDO_DELETE_NO))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SetHelpId( HID_SD_UNDODELETEWARNING_DLG );
//STRIP001 	maDisableCB.SetHelpId( HID_SD_UNDODELETEWARNING_CBX );
//STRIP001 
//STRIP001 	maYesBtn.SetText(Button::GetStandardText(BUTTON_YES));
//STRIP001 	maNoBtn.SetText(Button::GetStandardText(BUTTON_NO));
//STRIP001 	maImage.SetImage(WarningBox::GetStandardImage());
//STRIP001 
//STRIP001 	// #93721# Set focus to YES-Button
//STRIP001 	maYesBtn.GrabFocus();
//STRIP001 }


/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemporary(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// Waehrend einer Native-Diashow wird nichts ausgefuehrt!
/*?*/ 	if (pFuSlideShow && !pFuSlideShow->IsLivePresentation() &&
/*?*/ 		rReq.GetSlot() != SID_NAVIGATOR)
/*?*/ 	{
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		pFuActual->Deactivate();
/*N*/ 
/*N*/ 		if (pFuActual != pFuOld)
/*N*/ 		{
/*N*/ 			delete pFuActual;
/*N*/ 		}
/*N*/ 
/*N*/ 		pFuActual = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	// Slot wird gemapped (ToolboxImages/-Slots)
/*N*/ 	MapSlot( nSId );
/*N*/ 
/*N*/ 	switch ( nSId )
/*N*/ 	{
/*?*/ 		// Flaechen und Linien-Attribute:
/*?*/ 		// Sollten (wie StateMethode) eine eigene
/*?*/ 		// Execute-Methode besitzen
/*?*/ 		case SID_ATTR_FILL_STYLE:
/*?*/ 		case SID_ATTR_FILL_COLOR:
/*?*/ 		case SID_ATTR_FILL_GRADIENT:
/*?*/ 		case SID_ATTR_FILL_HATCH:
/*?*/ 		case SID_ATTR_FILL_BITMAP:
/*?*/ 		case SID_ATTR_FILL_SHADOW:
/*?*/ 
/*?*/ 		case SID_ATTR_LINE_STYLE:
/*?*/ 		case SID_ATTR_LINE_DASH:
/*?*/ 		case SID_ATTR_LINE_WIDTH:
/*?*/ 		case SID_ATTR_LINE_COLOR:
/*?*/ 		case SID_ATTR_LINEEND_STYLE:
/*?*/ 
/*?*/ 		case SID_ATTR_TEXT_FITTOSIZE:
/*?*/ 		{
/*?*/ 			if( rReq.GetArgs() )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BOOL bMergeUndo = FALSE;
//STRIP001 /*?*/ 				SfxUndoManager* pUndoMgr = pDocSh->GetUndoManager();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Anpassungen Start/EndWidth #63083#
//STRIP001 /*?*/ 				if(nSId == SID_ATTR_LINE_WIDTH)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrObject* pObj = NULL;
//STRIP001 /*?*/ 					const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 					ULONG nCount = rMarkList.GetMarkCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					INT32 nNewLineWidth = ((const XLineWidthItem&)rReq.GetArgs()->Get(XATTR_LINEWIDTH)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					for (ULONG i=0; i<nCount; i++)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxItemSet aAttr(pDoc->GetPool());
//STRIP001 /*?*/ 						pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 /*?*/ 						aAttr.Put(pObj->GetItemSet());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						INT32 nActLineWidth = ((const XLineWidthItem&)aAttr.Get(XATTR_LINEWIDTH)).GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if(nActLineWidth != nNewLineWidth)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							BOOL bSetItemSet(FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// #86265# do this for SFX_ITEM_DEFAULT and for SFX_ITEM_SET
//STRIP001 /*?*/ 							if(SFX_ITEM_DONTCARE != aAttr.GetItemState(XATTR_LINESTARTWIDTH))
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								INT32 nValAct = ((const XLineStartWidthItem&)aAttr.Get(XATTR_LINESTARTWIDTH)).GetValue();
//STRIP001 /*?*/ 								INT32 nValNew = nValAct + (((nNewLineWidth - nActLineWidth) * 15) / 10);
//STRIP001 /*?*/ 								if(nValNew < 0)
//STRIP001 /*?*/ 									nValNew = 0;
//STRIP001 /*?*/ 								bSetItemSet = TRUE;
//STRIP001 /*?*/ 								aAttr.Put(XLineStartWidthItem(nValNew));
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// #86265# do this for SFX_ITEM_DEFAULT and for SFX_ITEM_SET
//STRIP001 /*?*/ 							if(SFX_ITEM_DONTCARE != aAttr.GetItemState(XATTR_LINEENDWIDTH))
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								INT32 nValAct = ((const XLineEndWidthItem&)aAttr.Get(XATTR_LINEENDWIDTH)).GetValue();
//STRIP001 /*?*/ 								INT32 nValNew = nValAct + (((nNewLineWidth - nActLineWidth) * 15) / 10);
//STRIP001 /*?*/ 								if(nValNew < 0)
//STRIP001 /*?*/ 									nValNew = 0;
//STRIP001 /*?*/ 								bSetItemSet = TRUE;
//STRIP001 /*?*/ 								aAttr.Put(XLineEndWidthItem(nValNew));
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if(bSetItemSet)
//STRIP001 /*?*/ 								pObj->SetItemSet(aAttr);
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (nSId == SID_ATTR_FILL_SHADOW)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// Ggf. werden transparente Objekte wei gefuellt
//STRIP001 /*?*/ 					SdrObject* pObj = NULL;
//STRIP001 /*?*/ 					const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 					ULONG nCount = rMarkList.GetMarkCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					for (ULONG i=0; i<nCount; i++)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxItemSet aAttr(pDoc->GetPool());
//STRIP001 /*?*/ 						pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 /*?*/ 						aAttr.Put(pObj->GetItemSet());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						const XFillStyleItem& rFillStyle =
//STRIP001 /*?*/ 						 (const XFillStyleItem&) aAttr.Get(XATTR_FILLSTYLE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (rFillStyle.GetValue() == XFILL_NONE)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// Vorlage hat keine Fuellung,
//STRIP001 /*?*/ 							// daher hart attributieren: Fuellung setzen
//STRIP001 /*?*/ 							if (!bMergeUndo)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								bMergeUndo = TRUE;
//STRIP001 /*?*/ 								pUndoMgr->EnterListAction( String(), String() );
//STRIP001 /*?*/ 								pDrView->BegUndo();
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							pDrView->AddUndo(new SdrUndoAttrObj(*pObj));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							aAttr.Put(XFillStyleItem(XFILL_SOLID));
//STRIP001 /*?*/ 							aAttr.Put(XFillColorItem(String(), COL_WHITE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							pObj->SetItemSet(aAttr);
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (bMergeUndo)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->EndUndo();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pDrView->SetAttributes(*rReq.GetArgs());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bMergeUndo)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pUndoMgr->LeaveListAction();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				rReq.Done();
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				switch( rReq.GetSlot() )
/*?*/ 				{
/*?*/ 					case SID_ATTR_FILL_SHADOW:
/*?*/ 					case SID_ATTR_FILL_STYLE:
/*?*/ 					case SID_ATTR_FILL_COLOR:
/*?*/ 					case SID_ATTR_FILL_GRADIENT:
/*?*/ 					case SID_ATTR_FILL_HATCH:
/*?*/ 					case SID_ATTR_FILL_BITMAP:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_ATTRIBUTES_AREA, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 					case SID_ATTR_LINE_STYLE:
/*?*/ 					case SID_ATTR_LINE_DASH:
/*?*/ 					case SID_ATTR_LINE_WIDTH:
/*?*/ 					case SID_ATTR_LINE_COLOR:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_ATTRIBUTES_LINE, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 					case SID_ATTR_TEXT_FITTOSIZE:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_TEXTATTR_DLG, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HYPHENATION:
/*?*/ 		{
/*?*/ 			// const SfxPoolItem* pItem = rReq.GetArg( SID_HYPHENATION );
/*?*/ 			//  ^-- Soll so nicht benutzt werden (Defaults sind falsch) !
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG( rReq, pItem, SfxBoolItem, SID_HYPHENATION, FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( pItem )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxItemSet aSet( GetPool(), EE_PARA_HYPHENATE, EE_PARA_HYPHENATE );
//STRIP001 /*?*/ 				BOOL bValue = ( (const SfxBoolItem*) pItem)->GetValue();
//STRIP001 /*?*/ 				aSet.Put( SfxBoolItem( EE_PARA_HYPHENATE, bValue ) );
//STRIP001 /*?*/ 				pDrView->SetAttributes( aSet );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else // nur zum Test
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				DBG_ERROR(" Kein Wert fuer Silbentrennung!");
//STRIP001 /*?*/ 				SfxItemSet aSet( GetPool(), EE_PARA_HYPHENATE, EE_PARA_HYPHENATE );
//STRIP001 /*?*/ 				BOOL bValue = TRUE;
//STRIP001 /*?*/ 				aSet.Put( SfxBoolItem( EE_PARA_HYPHENATE, bValue ) );
//STRIP001 /*?*/ 				pDrView->SetAttributes( aSet );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERTPAGE:
/*?*/ 		case SID_INSERTPAGE_QUICK:
/*?*/ 		case SID_DUPLICATE_PAGE:
/*?*/ 		            {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 CreateOrDuplicatePage (rReq);
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MODIFYPAGE:
/*?*/ 		{
/*?*/ 			if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES ||
/*?*/ 				(ePageKind==PK_HANDOUT && eEditMode==EM_MASTERPAGE) )
/*?*/ 			{
/*?*/ 				if ( pDrView->IsTextEdit() )
/*?*/ 				{
/*?*/ 					pDrView->EndTextEdit();
/*?*/ 				}
/*?*/ 
/*?*/ 				USHORT nPage = aTabControl.GetCurPageId() - 1;
/*?*/ 				pActualPage = pDoc->GetSdPage(nPage, ePageKind);
/*?*/ 				SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
/*?*/ 				BYTE aBckgrnd = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRND)), FALSE);
/*?*/ 				BYTE aBckgrndObj = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRNDOBJ)), FALSE);
/*?*/ 				USHORT nPos = 0;
/*?*/ 				SetOfByte aVisibleLayers = pActualPage->GetMasterPageVisibleLayers(nPos);
/*?*/ 				BOOL bHandoutMode = FALSE;
/*?*/ 				SdPage* pHandoutMPage = NULL;
/*?*/ 				String aNewName;
/*?*/ 
/*?*/ 				// #95981#
/*?*/ 				String aOldName;
/*?*/ 
/*?*/ 				AutoLayout aNewAutoLayout;
/*?*/ 
/*?*/ 				// #95981#
/*?*/ 				AutoLayout aOldAutoLayout;
/*?*/ 				
/*?*/ 				BOOL bBVisible;
/*?*/ 				BOOL bBObjsVisible;
/*?*/ 				const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 
/*?*/ 				if (!pArgs || pArgs->Count() == 1 || pArgs->Count() == 2 )
/*?*/ 				{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					SfxItemSet aAttrSet( GetPool(), ATTR_PAGE_START, ATTR_PAGE_END );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// #95981# keep old name
//STRIP001 /*?*/ 					aOldName = pActualPage->GetName();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					aAttrSet.Put( SfxStringItem( ATTR_PAGE_NAME, aOldName ) );
//STRIP001 /*?*/ 					aAttrSet.Put( SfxBoolItem( ATTR_PAGE_BACKGROUND,
//STRIP001 /*?*/ 											   aVisibleLayers.IsSet(aBckgrnd) ) );
//STRIP001 /*?*/ 					aAttrSet.Put( SfxBoolItem( ATTR_PAGE_OBJECTS,
//STRIP001 /*?*/ 											   aVisibleLayers.IsSet(aBckgrndObj) ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					AutoLayout eNewAutoLayout = AUTOLAYOUT_NONE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( pArgs && pArgs->Count() == 2 )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SFX_REQUEST_ARG (rReq, pNewAutoLayout, SfxUInt32Item, ID_VAL_WHATLAYOUT, FALSE);
//STRIP001 /*?*/ 						eNewAutoLayout = (AutoLayout) pNewAutoLayout->GetValue ();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (ePageKind != PK_HANDOUT)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							eNewAutoLayout = pActualPage->GetAutoLayout();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							bHandoutMode = TRUE;
//STRIP001 /*?*/ 							pHandoutMPage = pDoc->GetMasterSdPage(0, PK_HANDOUT);
//STRIP001 /*?*/ 							eNewAutoLayout = pHandoutMPage->GetAutoLayout();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// #95981# keep old AutoLayout
//STRIP001 /*?*/ 					aOldAutoLayout = eNewAutoLayout;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					aAttrSet.Put( SfxAllEnumItem( ATTR_PAGE_LAYOUT, aOldAutoLayout ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SdNewFoilDlg* pDlg = new SdNewFoilDlg(pWindow, aAttrSet, ePageKind, pDocSh, TRUE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (pDlg->Execute() == RET_OK)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pDlg->GetAttr( aAttrSet );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						aNewName	   = ((const SfxStringItem &) aAttrSet.Get (ATTR_PAGE_NAME)).GetValue ();
//STRIP001 /*?*/ 						aNewAutoLayout = (AutoLayout) ((const SfxAllEnumItem &)
//STRIP001 /*?*/ 											 aAttrSet.Get (ATTR_PAGE_LAYOUT)).GetValue ();
//STRIP001 /*?*/ 						bBVisible	   = ((const SfxBoolItem &) aAttrSet.Get (ATTR_PAGE_BACKGROUND)).GetValue ();
//STRIP001 /*?*/ 						bBObjsVisible  = ((const SfxBoolItem &) aAttrSet.Get (ATTR_PAGE_OBJECTS)).GetValue ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						delete pDlg;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						// alles deselektieren, denn ein selektiertes Objekt
//STRIP001 /*?*/ 						// koennte gleich verschwinden
//STRIP001 /*?*/ 						pDrView->UnmarkAll();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SdPage* pPage = pDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 /*?*/ 						if (pDoc->GetSdPageCount(PK_STANDARD) == 1 &&
//STRIP001 /*?*/ 							pPage->GetAutoLayout() == AUTOLAYOUT_TITLE &&
//STRIP001 /*?*/ 							pPage->GetPresObjList()->Count() == 0)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// Nur eine Seite vorhanden
//STRIP001 /*?*/ 							pPage->SetAutoLayout(AUTOLAYOUT_NONE);
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						delete pDlg;
//STRIP001 /*?*/ 						rReq.Ignore ();
//STRIP001 /*?*/ 						Cancel ();
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 					}
/*?*/ 				}
/*?*/ 				else if (pArgs->Count() == 4)
/*?*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pNewName, SfxStringItem, ID_VAL_PAGENAME, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pNewAutoLayout, SfxUInt32Item, ID_VAL_WHATLAYOUT, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pBVisible, SfxBoolItem, ID_VAL_ISPAGEBACK, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pBObjsVisible, SfxBoolItem, ID_VAL_ISPAGEOBJ, FALSE);
/*?*/ 
/*?*/ 					if (CHECK_RANGE (AUTOLAYOUT_TITLE, (AutoLayout) pNewAutoLayout->GetValue (), AUTOLAYOUT_HANDOUT6))
/*?*/ 					{
/*?*/ 						aNewName		= pNewName->GetValue ();
/*?*/ 						aNewAutoLayout = (AutoLayout) pNewAutoLayout->GetValue ();
/*?*/ 						bBVisible		= pBVisible->GetValue ();
/*?*/ 						bBObjsVisible	= pBObjsVisible->GetValue ();
/*?*/ 					}
/*?*/ 					else
/*?*/ 					{
/*?*/ 						StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 						rReq.Ignore ();
/*?*/ 						Cancel ();
/*?*/ 						break;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 					rReq.Ignore ();
/*?*/ 					Cancel ();
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 				SdPage* pUndoPage =
/*?*/ 							bHandoutMode ? pHandoutMPage : pActualPage;
/*?*/ 
/*?*/ 				// #67720#
/*?*/ 				SfxUndoManager* pUndoManager = pDocSh->GetUndoManager();
/*?*/ 				DBG_ASSERT(pUndoManager, "No UNDO MANAGER ?!?");
/*?*/ 
/*?*/ 				// #90356#
/*?*/ 				sal_uInt16 nActionCount(pUndoManager->GetUndoActionCount());
/*?*/ 				sal_Bool bContinue(sal_True);
/*?*/ 
/*?*/ 				if(nActionCount)
/*?*/ 				{
/*?*/ 					// #90356# get SdOptions
/*?*/ 					SdOptions* pOptions = SD_MOD()->GetSdOptions(pDoc->GetDocumentType());
/*?*/ 					sal_Bool bShowDialog(pOptions->IsShowUndoDeleteWarning());
/*?*/ 
/*?*/ 					// #95981# If only name is changed do not show
/*?*/ 					// ImpUndoDeleteWarning dialog
/*?*/ 					if(bShowDialog)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 						sal_Bool bNameChanged(aNewName != aOldName);
//STRIP001 /*?*/ 						sal_Bool bLayoutChanged(aNewAutoLayout != aOldAutoLayout);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if(bNameChanged && !bLayoutChanged)
//STRIP001 /*?*/ 							bShowDialog = sal_False;
/*?*/ 					}
/*?*/ 
/*?*/ 					if(bShowDialog)
/*?*/ 					{
						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 						// ask user if he wants to loose UNDO stack
//STRIP001 /*?*/ 						ImpUndoDeleteWarning aUndoDeleteDlg(pWindow);
//STRIP001 /*?*/ 						
//STRIP001 /*?*/ 						if(BUTTONID_OK == aUndoDeleteDlg.Execute())
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pUndoManager->Clear();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							bContinue = sal_False;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						// #90356# write option flag back if change was done
//STRIP001 /*?*/ 						if(aUndoDeleteDlg.IsWarningDisabled())
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pOptions->SetShowUndoDeleteWarning(FALSE);
//STRIP001 /*?*/ 						}
/*?*/ 					}
/*?*/ 				}
/*?*/ 
/*?*/ 				if(bContinue)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ModifyPageUndoAction* pAction = new ModifyPageUndoAction(
//STRIP001 /*?*/ 						pUndoManager, pDoc, pUndoPage, aNewName, aNewAutoLayout, bBVisible, bBObjsVisible);
//STRIP001 /*?*/ 					pUndoManager->AddUndoAction(pAction);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );
//STRIP001 /*?*/ 					SdPreviewWin*	pPreviewWin = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// notify preview slide show are changes are to be done
//STRIP001 /*?*/ 					if( pPreviewChildWindow && ( ( pPreviewWin = (SdPreviewWin*) pPreviewChildWindow->GetWindow() ) != NULL ) )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						FuSlideShow* pShow = pPreviewWin->GetSlideShow();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if( pShow )
//STRIP001 /*?*/ 							pShow->InitPageModify();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (!bHandoutMode)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (pActualPage->GetName() != aNewName)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pActualPage->SetName(aNewName);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if (ePageKind == PK_STANDARD)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								SdPage* pNotesPage = pDoc->GetSdPage(nPage, PK_NOTES);
//STRIP001 /*?*/ 								pNotesPage->SetName(aNewName);
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pActualPage->SetAutoLayout(aNewAutoLayout, TRUE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						aBckgrnd = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRND)), FALSE);
//STRIP001 /*?*/ 						aBckgrndObj = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRNDOBJ)), FALSE);
//STRIP001 /*?*/ 						aVisibleLayers.Set(aBckgrnd, bBVisible);
//STRIP001 /*?*/ 						aVisibleLayers.Set(aBckgrndObj, bBObjsVisible);
//STRIP001 /*?*/ 						nPos = 0;
//STRIP001 /*?*/ 						pActualPage->SetMasterPageVisibleLayers(aVisibleLayers, nPos);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pHandoutMPage->SetAutoLayout(aNewAutoLayout, TRUE);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					GetViewFrame()->GetDispatcher()->Execute(SID_SWITCHPAGE,
//STRIP001 /*?*/ 										SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					BOOL bSetModified = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (pArgs && pArgs->Count() == 1)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						bSetModified = (BOOL) ((SfxBoolItem&) pArgs->Get(SID_MODIFYPAGE)).GetValue();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pDoc->SetChanged(bSetModified);
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_RENAMEPAGE:
/*?*/         {
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pDrView->EndTextEdit();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 USHORT nPageId = aTabControl.GetCurPageId();
//STRIP001 /*?*/                 SdPage* pCurrentPage = ( GetEditMode() == EM_PAGE )
//STRIP001 /*?*/                     ? pDoc->GetSdPage( nPageId - 1, GetPageKind() )
//STRIP001 /*?*/                     : pDoc->GetMasterSdPage( nPageId - 1, GetPageKind() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 String aTitle( SdResId( STR_TITLE_RENAMESLIDE ) );
//STRIP001 /*?*/                 String aDescr( SdResId( STR_DESC_RENAMESLIDE ) );
//STRIP001 /*?*/                 String aPageName = pCurrentPage->GetName();
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 SvxNameDialog aNameDlg( pWindow, aPageName, aDescr );
//STRIP001 /*?*/                 aNameDlg.SetText( aTitle );
//STRIP001 /*?*/                 aNameDlg.SetCheckNameHdl( LINK( this, SdDrawViewShell, RenameSlideHdl ), true );
//STRIP001 /*?*/                 aNameDlg.SetEditHelpId( HID_SD_NAMEDIALOG_PAGE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 if( aNameDlg.Execute() == RET_OK )
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     String aNewName;
//STRIP001 /*?*/                     aNameDlg.GetName( aNewName );
//STRIP001 /*?*/                     if( ! aNewName.Equals( aPageName ) )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         bool bResult = RenameSlide( nPageId, aNewName );
//STRIP001 /*?*/                         DBG_ASSERT( bResult, "Couldn't rename slide" );
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                 }
//STRIP001 /*?*/             }
//STRIP001 /*?*/             
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/         }
/*?*/         break;
/*?*/ 
/*?*/         case SID_RENAMEPAGE_QUICK:
/*?*/ 		{
/*?*/ 			if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES )
/*?*/ 			{
/*?*/ 				if ( pDrView->IsTextEdit() )
/*?*/ 				{
/*?*/ 					pDrView->EndTextEdit();
/*?*/ 				}
/*?*/ 
/*?*/ 				aTabControl.StartEditMode( aTabControl.GetCurPageId() );
/*?*/ 			}
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PAGESIZE :  // entweder dieses (kein menueeintrag o. ae. !!)
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 3)
/*?*/ 				{
						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pWidth, SfxUInt32Item, ID_VAL_PAGEWIDTH, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pHeight, SfxUInt32Item, ID_VAL_PAGEHEIGHT, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pScaleAll, SfxBoolItem, ID_VAL_SCALEOBJECTS, FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					Size aSize (pWidth->GetValue (), pHeight->GetValue ());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SetupPage (aSize, 0, 0, 0, 0, TRUE, FALSE, pScaleAll->GetValue ());
//STRIP001 /*?*/ 					rReq.Ignore ();
//STRIP001 /*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_PAGEMARGIN :  // oder dieses (kein menueeintrag o. ae. !!)
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 5)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG (rReq, pLeft, SfxUInt32Item, ID_VAL_PAGELEFT, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pRight, SfxUInt32Item, ID_VAL_PAGERIGHT, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pUpper, SfxUInt32Item, ID_VAL_PAGETOP, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pLower, SfxUInt32Item, ID_VAL_PAGEBOTTOM, FALSE);
//STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pScaleAll, SfxBoolItem, ID_VAL_SCALEOBJECTS, FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					Size aEmptySize (0, 0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SetupPage (aEmptySize, pLeft->GetValue (), pRight->GetValue (),
//STRIP001 /*?*/ 							   pUpper->GetValue (), pLower->GetValue (),
//STRIP001 /*?*/ 							   FALSE, TRUE, pScaleAll->GetValue ());
//STRIP001 /*?*/ 					rReq.Ignore ();
//STRIP001 /*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_ZOOMING :	// kein Menueintrag, sondern aus dem Zoomdialog generiert
/*?*/ 		{
/*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 1)
/*?*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pScale, SfxUInt32Item, ID_VAL_ZOOM, FALSE);
/*?*/ 					if (CHECK_RANGE (10, pScale->GetValue (), 1000))
/*?*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SetZoom (pScale->GetValue ());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 /*?*/ 						rBindings.Invalidate( SID_ATTR_ZOOM );
//STRIP001 /*?*/ 						rBindings.Invalidate( SID_ZOOM_IN );
//STRIP001 /*?*/ 						rBindings.Invalidate( SID_ZOOM_OUT );
/*?*/ 					}
/*?*/ 					else StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 
/*?*/ 					rReq.Ignore ();
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_ATTR_ZOOM:
/*?*/ 		{
/*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 			bZoomOnPage = FALSE;
/*?*/ 
/*?*/ 			if ( pArgs )
/*?*/ 			{
/*?*/ 				SvxZoomType eZT = ( ( const SvxZoomItem& ) pArgs->
/*?*/ 											Get( SID_ATTR_ZOOM ) ).GetType();
/*?*/ 				switch( eZT )
/*?*/ 				{
/*?*/ 					case SVX_ZOOM_PERCENT:
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SetZoom( (long) ( ( const SvxZoomItem& ) pArgs->
//STRIP001 /*?*/ 											Get( SID_ATTR_ZOOM ) ).GetValue() );
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_OPTIMAL:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_ALL,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_PAGEWIDTH:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE_WIDTH,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_WHOLEPAGE:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 				}
/*?*/ 				rReq.Ignore ();
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
//STRIP001 /*?*/ 				// hier den Zoom-Dialog oeffnen
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuScale( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CHANGEBEZIER:
/*?*/ 		case SID_CHANGEPOLYGON:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 				GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if( rReq.GetSlot() == SID_CHANGEBEZIER )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 					pDrView->ConvertMarkedToPathObj(FALSE);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if( pDrView->IsVectorizeAllowed() )
//STRIP001 /*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuVectorize( this, pWindow, pDrView, pDoc, rReq );
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 						pDrView->ConvertMarkedToPolyObj(FALSE);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Invalidate(SID_CHANGEBEZIER);
//STRIP001 /*?*/ 				Invalidate(SID_CHANGEPOLYGON);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT )
//STRIP001 /*?*/ 			{	// ggf. die richtige Editfunktion aktivieren
//STRIP001 /*?*/ 				GetViewFrame()->GetDispatcher()->Execute(SID_SWITCH_POINTEDIT,
//STRIP001 /*?*/ 										SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_CONTOUR:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 				GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pDrView->IsPresObjSelected() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 				pDrView->ConvertMarkedToPolyObj(TRUE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Invalidate(SID_CONVERT_TO_CONTOUR);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_METAFILE:
/*?*/ 		case SID_CONVERT_TO_BITMAP:
/*?*/ 		{
            // End text edit mode when it is active because the metafile or
            // bitmap that will be created does not support it.
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001             if ( pDrView->IsTextEdit() )
//STRIP001 			{
//STRIP001 				pDrView->EndTextEdit();
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001             }
//STRIP001 
//STRIP001 			if ( pDrView->IsPresObjSelected(true,true,true) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE) ) ).Execute();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				WaitObject aWait( (Window*)GetActiveWindow() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// switch on undo for the next operations
//STRIP001 /*?*/ 				pDrView->BegUndo(
//STRIP001 /*?*/ 					String(
//STRIP001 /*?*/ 					SdResId (nSId==SID_CONVERT_TO_METAFILE ? STR_UNDO_CONVERT_TO_METAFILE : STR_UNDO_CONVERT_TO_BITMAP)));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// create SdrGrafObj from metafile/bitmap
//STRIP001 /*?*/ 				Graphic aGraphic;
//STRIP001 /*?*/ 				switch (nSId)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					case SID_CONVERT_TO_METAFILE:
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						GDIMetaFile aMetaFile(pDrView->GetAllMarkedMetaFile ());
//STRIP001 /*?*/ 						aGraphic = Graphic(aMetaFile);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 					case SID_CONVERT_TO_BITMAP:
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Bitmap aBitmap (pDrView->GetAllMarkedBitmap ());
//STRIP001 /*?*/ 						aGraphic = Graphic(aBitmap);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SdrGrafObj* pGraphicObj = new SdrGrafObj (aGraphic);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// fit rectangle of graphic-object to  mark-rect
//STRIP001 /*?*/ 				Rectangle aAllMarkedRect;
//STRIP001 /*?*/ 				SdrMarkList aMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 				for (int i=0; i < (int) aMarkList.GetMarkCount(); i++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					aAllMarkedRect.Union ( aMarkList.GetMark(i)->GetObj()->GetBoundRect() );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				pGraphicObj->SetLogicRect (aAllMarkedRect);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// get page-view
//STRIP001 /*?*/ 				SdrPageView* pPageView = pDrView->GetMarkList().GetMark(0)->GetPageView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// delete marked objects
//STRIP001 /*?*/ 				pDrView->DeleteMarkedObj();	// #69979# delete the objects, not only the marked area
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// insert new object
//STRIP001 /*?*/ 				pDrView->InsertObject (pGraphicObj, *pPageView);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// switch off undo
//STRIP001 /*?*/ 				pDrView->EndUndo();
//STRIP001 /*?*/ 			}
		}
/*?*/ 
/*?*/ 		Cancel();
/*?*/ 
/*?*/ 		rReq.Done ();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SET_DEFAULT:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxItemSet* pSet = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (pDrView->IsTextEdit())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Outliner* pOutl = pDrView->GetTextEditOutliner();
//STRIP001 /*?*/ 				if (pOutl)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pOutl->RemoveFields(TRUE, (TypeId) SvxURLField::StaticType());
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pSet = new SfxItemSet( GetPool(), EE_ITEMS_START, EE_ITEMS_END );
//STRIP001 /*?*/ 				pDrView->SetAttributes( *pSet, TRUE );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 				ULONG nCount = rMarkList.GetMarkCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// In diese Liste werden fuer jedes Praesentationsobjekt ein SfxItemSet
//STRIP001 /*?*/ 				// der harten Attribute sowie der UserCall eingetragen, da diese beim nachfolgenden
//STRIP001 /*?*/ 				// pDrView->SetAttributes( *pSet, TRUE ) verloren gehen und spaeter restauriert
//STRIP001 /*?*/ 				// werden muessen
//STRIP001 /*?*/ 				List* pAttrList = new List();
//STRIP001 /*?*/ 				List* pPresObjList = ( (SdPage*) pDrView->GetPageViewPvNum(0)->GetPage() )
//STRIP001 /*?*/ 																	->GetPresObjList();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				for ( ULONG i = 0; i < nCount; i++ )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( pPresObjList->GetPos( pObj ) != LIST_ENTRY_NOTFOUND )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxItemSet* pSet = new SfxItemSet( pDoc->GetPool(), SDRATTR_TEXT_MINFRAMEHEIGHT, SDRATTR_TEXT_AUTOGROWHEIGHT, 0 );
//STRIP001 /*?*/ 						pSet->Put(pObj->GetItemSet());
//STRIP001 /*?*/ 						pAttrList->Insert( pSet, LIST_APPEND );
//STRIP001 /*?*/ 						pAttrList->Insert( pObj->GetUserCall(), LIST_APPEND );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pSet = new SfxItemSet( GetPool() );
//STRIP001 /*?*/ 				pDrView->SetAttributes( *pSet, TRUE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				ULONG j = 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				for ( i = 0; i < nCount; i++ )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SfxStyleSheet* pSheet = NULL;
//STRIP001 /*?*/ 					SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (pObj->GetObjIdentifier() == OBJ_TITLETEXT)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pSheet = pActualPage->GetStyleSheetForPresObj(PRESOBJ_TITLE);
//STRIP001 /*?*/ 						if (pSheet)
//STRIP001 /*?*/ 							pObj->SetStyleSheet(pSheet, FALSE);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else if(pObj->GetObjIdentifier() == OBJ_OUTLINETEXT)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						for (USHORT nLevel = 1; nLevel < 10; nLevel++)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pSheet = pActualPage->GetStyleSheetForPresObj( PRESOBJ_OUTLINE );
//STRIP001 /*?*/ 							DBG_ASSERT(pSheet, "Vorlage fuer Gliederungsobjekt nicht gefunden");
//STRIP001 /*?*/ 							if (pSheet)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								pObj->StartListening(*pSheet);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 								if( nLevel == 1 )
//STRIP001 /*?*/ 									// Textrahmen hoert auf StyleSheet der Ebene1
//STRIP001 /*?*/ 									pObj->NbcSetStyleSheet(pSheet, FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( pPresObjList->GetPos( pObj ) != LIST_ENTRY_NOTFOUND )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxItemSet* pSet = (SfxItemSet*) pAttrList->GetObject(j++);
//STRIP001 /*?*/ 						SdrObjUserCall* pUserCall = (SdrObjUserCall*) pAttrList->GetObject(j++);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( pSet && pSet->GetItemState( SDRATTR_TEXT_MINFRAMEHEIGHT ) == SFX_ITEM_ON )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pObj->SetItem(pSet->Get(SDRATTR_TEXT_MINFRAMEHEIGHT));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( pSet && pSet->GetItemState( SDRATTR_TEXT_AUTOGROWHEIGHT ) == SFX_ITEM_ON )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pObj->SetItem(pSet->Get(SDRATTR_TEXT_AUTOGROWHEIGHT));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if( pUserCall )
//STRIP001 /*?*/ 							pObj->SetUserCall( pUserCall );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						delete pSet;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				delete pAttrList;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			delete pSet;
//STRIP001 /*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_SNAPITEM:
/*?*/ 		{
/*?*/ 			SdrPageView* pPV;
/*?*/ 			Point	aMPos = pWindow->PixelToLogic( aMousePos );
/*?*/ 			USHORT	nHitLog = (USHORT) pWindow->PixelToLogic( Size( HITPIX, 0 ) ).Width();
/*?*/ 			USHORT	nHelpLine;
/*?*/ 
/*?*/ 			bMousePosFreezed = FALSE;
/*?*/ 
/*?*/ 			if( pDrView->PickHelpLine( aMPos, nHitLog, *pWindow, nHelpLine, pPV) )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pPV->DeleteHelpLine( nHelpLine );
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_PAGE:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DeleteActualPage();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_LAYER:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DeleteActualLayer();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ORIGINAL_SIZE:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->SetMarkedOriginalSize();
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done();
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			// switch Anweisung wegen CLOOKS aufgeteilt. Alle case-Anweisungen die
/*N*/ 			// eine Fu???? -Funktion aufrufen, sind in die Methode FuTemp01 (drviews8)
/*N*/ 			// gewandert.
/*N*/ 			FuTemp01(rReq);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		pFuActual->Activate();
/*N*/ 	}
/*N*/ }




/** This method consists basically of three parts:
    1. Process the arguments of the SFX request.
    2. Use the model to create a new page or duplicate an existing one.
    3. Update the tab control and switch to the new page.
*/
//STRIP001 void SdDrawViewShell::CreateOrDuplicatePage (SfxRequest& rReq)
//STRIP001 {
//STRIP001 	USHORT nSId = rReq.GetSlot();
//STRIP001     if (ePageKind == PK_STANDARD && eEditMode != EM_MASTERPAGE)
//STRIP001     {
//STRIP001         if ( pDrView->IsTextEdit() )
//STRIP001         {
//STRIP001             pDrView->EndTextEdit();
//STRIP001         }
//STRIP001 
//STRIP001         USHORT nPageCount = pDoc->GetSdPageCount(ePageKind);
//STRIP001         SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001         BYTE aBckgrnd = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRND)), FALSE);
//STRIP001         BYTE aBckgrndObj = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRNDOBJ)), FALSE);
//STRIP001         USHORT nPos = 0;
//STRIP001         SetOfByte aVisibleLayers = pActualPage->GetMasterPageVisibleLayers(nPos);
//STRIP001 
//STRIP001         String aStandardPageName;
//STRIP001         String aNotesPageName;
//STRIP001         AutoLayout eStandardLayout;
//STRIP001         AutoLayout eNotesLayout;
//STRIP001         BOOL bIsPageBack;
//STRIP001         BOOL bIsPageObj;
//STRIP001 
//STRIP001         // 1. Process the arguments.
//STRIP001         const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001         if (! pArgs)
//STRIP001         {
//STRIP001             SfxItemSet aAttrSet( GetPool(), ATTR_PAGE_START, ATTR_PAGE_END );
//STRIP001             String aStr;
//STRIP001             aAttrSet.Put( SfxStringItem( ATTR_PAGE_NAME, aStr ) );
//STRIP001             aAttrSet.Put( SfxBoolItem( ATTR_PAGE_BACKGROUND,
//STRIP001                               aVisibleLayers.IsSet(aBckgrnd) ) );
//STRIP001             aAttrSet.Put( SfxBoolItem( ATTR_PAGE_OBJECTS,
//STRIP001                               aVisibleLayers.IsSet(aBckgrndObj) ) );
//STRIP001 
//STRIP001             AutoLayout eAutoLayout = pActualPage->GetAutoLayout();
//STRIP001 
//STRIP001             if (eAutoLayout == AUTOLAYOUT_TITLE && pActualPage->GetPageNum() == 1)
//STRIP001             {
//STRIP001                 // 1.Seite ist TitelDia
//STRIP001                 eAutoLayout = AUTOLAYOUT_ENUM;
//STRIP001             }
//STRIP001 
//STRIP001             aAttrSet.Put( SfxAllEnumItem( ATTR_PAGE_LAYOUT,
//STRIP001 												  eAutoLayout ) );
//STRIP001 
//STRIP001             SdNewFoilDlg* pDlg = NULL;
//STRIP001             
//STRIP001             if (nSId == SID_INSERTPAGE && !this->ISA( SdGraphicViewShell ))
//STRIP001                 pDlg = new SdNewFoilDlg(pWindow, aAttrSet, ePageKind, pDocSh, FALSE);
//STRIP001 
//STRIP001             if (pDlg && pDlg->Execute () != RET_OK)
//STRIP001             {
//STRIP001                 Cancel();
//STRIP001                 
//STRIP001                 if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT )
//STRIP001                     GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 
//STRIP001                 delete pDlg;
//STRIP001                 rReq.Ignore ();
//STRIP001                 return;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // AutoLayouts muessen fertig sein
//STRIP001                 pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001                 if (pDlg)
//STRIP001                 {
//STRIP001                     pDlg->GetAttr( aAttrSet );
//STRIP001                 }
//STRIP001 
//STRIP001                 if (ePageKind == PK_NOTES)
//STRIP001                 {
//STRIP001                     aNotesPageName = ((const SfxStringItem &) aAttrSet.Get (ATTR_PAGE_NAME)).GetValue ();
//STRIP001                     eNotesLayout   = (AutoLayout) ((const SfxAllEnumItem &)
//STRIP001                         aAttrSet.Get (ATTR_PAGE_LAYOUT)).GetValue ();
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     aStandardPageName = ((const SfxStringItem &) aAttrSet.Get (ATTR_PAGE_NAME)).GetValue ();
//STRIP001                     eStandardLayout   = (AutoLayout) ((const SfxAllEnumItem &)
//STRIP001                         aAttrSet.Get (ATTR_PAGE_LAYOUT)).GetValue ();
//STRIP001                 }
//STRIP001 
//STRIP001                 bIsPageBack = ((const SfxBoolItem &) aAttrSet.Get (ATTR_PAGE_BACKGROUND)).GetValue ();
//STRIP001                 bIsPageObj	= ((const SfxBoolItem &) aAttrSet.Get (ATTR_PAGE_OBJECTS)).GetValue();
//STRIP001 
//STRIP001                 pDoc->SetChanged(TRUE);
//STRIP001             }
//STRIP001             
//STRIP001             delete pDlg;
//STRIP001         }
//STRIP001         else if (pArgs->Count () != 4)
//STRIP001         {
//STRIP001             Cancel();
//STRIP001 
//STRIP001             if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT )
//STRIP001                 GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 
//STRIP001             StarBASIC::FatalError (SbERR_WRONG_ARGS);
//STRIP001             rReq.Ignore ();
//STRIP001             return;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // AutoLayouts muessen fertig sein
//STRIP001             pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001             SFX_REQUEST_ARG (rReq, pPageName, SfxStringItem, ID_VAL_PAGENAME, FALSE);
//STRIP001             SFX_REQUEST_ARG (rReq, pLayout, SfxUInt32Item, ID_VAL_WHATLAYOUT, FALSE);
//STRIP001             SFX_REQUEST_ARG (rReq, pIsPageBack, SfxBoolItem, ID_VAL_ISPAGEBACK, FALSE);
//STRIP001             SFX_REQUEST_ARG (rReq, pIsPageObj, SfxBoolItem, ID_VAL_ISPAGEOBJ, FALSE);
//STRIP001 
//STRIP001             if (CHECK_RANGE (AUTOLAYOUT_TITLE, (AutoLayout) pLayout->GetValue (), AUTOLAYOUT_HANDOUT6))
//STRIP001             {
//STRIP001                 if (ePageKind == PK_NOTES)
//STRIP001                 {
//STRIP001                     aNotesPageName = pPageName->GetValue ();
//STRIP001                     eNotesLayout   = (AutoLayout) pLayout->GetValue ();
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     aStandardPageName = pPageName->GetValue ();
//STRIP001                     eStandardLayout   = (AutoLayout) pLayout->GetValue ();
//STRIP001                 }
//STRIP001 
//STRIP001                 bIsPageBack = pIsPageBack->GetValue ();
//STRIP001                 bIsPageObj	= pIsPageObj->GetValue ();
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 Cancel();
//STRIP001                 
//STRIP001                 if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT )
//STRIP001                     GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 
//STRIP001                 StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
//STRIP001                 rReq.Ignore ();
//STRIP001                 return;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // 2. Create a new page or duplicate an existing one.
//STRIP001         pDrView->BegUndo( String( SdResId(STR_INSERTPAGE) ) );
//STRIP001 
//STRIP001         USHORT nNewPageIndex;
//STRIP001         if ((nSId == SID_INSERTPAGE) || (nSId == SID_INSERTPAGE_QUICK))
//STRIP001             nNewPageIndex = pDoc->CreatePage (pActualPage, ePageKind,
//STRIP001                 aStandardPageName, aNotesPageName,
//STRIP001                 eStandardLayout, eNotesLayout,
//STRIP001                 bIsPageBack, bIsPageObj);
//STRIP001         else
//STRIP001             nNewPageIndex = pDoc->DuplicatePage (pActualPage, ePageKind,
//STRIP001                 aStandardPageName, aNotesPageName,
//STRIP001                 eStandardLayout, eNotesLayout,
//STRIP001                 bIsPageBack, bIsPageObj);
//STRIP001 
//STRIP001         pDrView->AddUndo (new SdrUndoNewPage (*pDoc->GetSdPage (nNewPageIndex, PK_STANDARD)));
//STRIP001         pDrView->AddUndo (new SdrUndoNewPage (*pDoc->GetSdPage (nNewPageIndex, PK_NOTES)));
//STRIP001                 
//STRIP001         pDrView->EndUndo();
//STRIP001 
//STRIP001         // 3. Update the tab control.
//STRIP001         aTabControl.Clear();
//STRIP001 
//STRIP001         SdPage* pPage;
//STRIP001         String aPageName;
//STRIP001         USHORT nPageCnt = pDoc->GetSdPageCount(ePageKind);
//STRIP001 
//STRIP001         for (USHORT i = 0; i < nPageCnt; i++)
//STRIP001         {
//STRIP001             pPage = pDoc->GetSdPage(i, ePageKind);
//STRIP001             
//STRIP001             aPageName = pPage->GetName();
//STRIP001             aTabControl.InsertPage(i + 1, aPageName);
//STRIP001         }
//STRIP001 
//STRIP001         aTabControl.SetCurPageId (nNewPageIndex + 1);
//STRIP001         
//STRIP001         GetViewFrame()->GetDispatcher()->Execute(SID_SWITCHPAGE,
//STRIP001             (rReq.IsSynchronCall() ? SFX_CALLMODE_SYNCHRON : SFX_CALLMODE_ASYNCHRON)
//STRIP001             | SFX_CALLMODE_RECORD);
//STRIP001     }
//STRIP001 
//STRIP001     Cancel();
//STRIP001     
//STRIP001     if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT )
//STRIP001         GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001     rReq.Done ();
//STRIP001 }
}
