/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accmgr.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:56:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include "accmgr.hxx"

// auto strip #ifndef _EVENT_HXX //autogen
// auto strip #include <vcl/event.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_AWT_KEYEVENT_HPP_
// auto strip #include <com/sun/star/awt/KeyEvent.hpp>
// auto strip #endif

#include <tools/rcid.h>
// auto strip #include <unotools/streamwrap.hxx>
// auto strip #include <comphelper/processfactory.hxx>
//#include <unotools/ucbstreamhelper.hxx>
//#include <tools/urlobj.hxx>
// auto strip #include <svtools/pathoptions.hxx>

//#include "mnumgr.hxx"
//#include "app.hxx"
//#include "sfxtypes.hxx"
// auto strip #include "bindings.hxx"
//#include "sfxresid.hxx"
#include "macrconf.hxx"
//#include "msgpool.hxx"
#include "dispatch.hxx"
#include "accel.hrc"
// auto strip #include "viewfrm.hxx"
// auto strip #include "module.hxx"
// auto strip #include "objface.hxx"
// auto strip #include "request.hxx"
#include "accelcfg.hxx"
namespace binfilter {

static const USHORT nVersion = 1;

//--------------------------------------------------------------------

/*N*/ SfxAcceleratorManager::SfxAcceleratorManager( SfxConfigManager* pMgr)
/*N*/     : SfxConfigItem( SFX_ITEMTYPE_ACCEL, pMgr ),
/*N*/ 	nIteratorPos(0),
/*N*/ 	pAccel(0),
/*N*/     pAccelCfg(0),
/*N*/ 	pResMgr(0)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/     Initialize();
/*N*/ }

/*N*/ SfxAcceleratorManager::SfxAcceleratorManager( const ResId& rResId, SfxConfigManager* pMgr )
/*N*/     : SfxConfigItem(rResId.GetId() == RID_DEFAULTACCEL ? SFX_ITEMTYPE_ACCEL : rResId.GetId(), pMgr )
/*N*/     , nIteratorPos(0)
/*N*/     , pAccel(0)
/*N*/     , pAccelCfg(0)
/*N*/     , pResMgr(rResId.GetResMgr())
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/     Initialize();
/*N*/ }

/*?*/ SfxAcceleratorManager::SfxAcceleratorManager( const SfxAcceleratorManager& rOther, SfxConfigManager* pMgr )
/*?*/     : SfxConfigItem( rOther.GetType(), pMgr )
/*?*/     , nIteratorPos(0)
/*?*/     , pAccel(0)
/*?*/     , pAccelCfg(0)
/*?*/     , pResMgr( rOther.pResMgr )
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/     Initialize();
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxAcceleratorManager::~SfxAcceleratorManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	Clear();
/*N*/ }

/*N*/ void SfxAcceleratorManager::Clear()
/*N*/ {
/*N*/ 	if ( pAccel )
/*N*/ 	{
/*N*/ 		USHORT nCount = pAccel->GetItemCount();
/*N*/ 		for ( USHORT nPos = 0; nPos < nCount; ++nPos )
/*N*/ 		{
/*N*/ 			USHORT nId = pAccel->GetItemId( nPos );
/*N*/ 			if ( SfxMacroConfig::IsMacroSlot( nId ) )
/*?*/ 				SFX_APP()->GetMacroConfig()->ReleaseSlotId(nId);
/*N*/ 		}
/*N*/ 
/*N*/ 		DELETEZ( pAccel );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
/*?*/         const SfxAcceleratorItemList& rItems = GetItems();
/*?*/         for ( p = rItems.begin(); p != rItems.end(); p++ )
/*?*/ 			if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
/*?*/ 				SFX_APP()->GetMacroConfig()->ReleaseSlotId(p->nId);
/*?*/ 		DELETEZ( pAccelCfg );
/*N*/ 	}
/*N*/ }

//====================================================================

/*?*/ SvStream& operator>>( SvStream &rStream, KeyCode& rVal )
/*?*/ {
/*?*/ 	USHORT nCode, nMod;
/*?*/ 	rStream >> nCode;
/*?*/ 	rStream >> nMod;
/*?*/ 
/*?*/ 	if( nCode == USHRT_MAX )
/*?*/ 		// virtuelle Taste
/*?*/ 		rVal = KeyCode( (KeyFuncType) nMod );
/*?*/ 	else
/*?*/ 		// normale Taste
/*?*/ 		rVal = KeyCode ( nCode, nMod );
/*?*/ 
/*?*/ 	return rStream;
/*?*/ }


//--------------------------------------------------------------------

// stream out a KeyCode

/*?*/ SvStream& operator<<( SvStream &rStream, const KeyCode& rVal )
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/ 
/*?*/ 	if( rVal.IsFunction() )
/*?*/     {
/*?*/ 		// write virtual key code, marked as USHRT_MAX
/*?*/ 		rStream << USHORT(USHRT_MAX) << USHORT( rVal.GetFunction() );
/*?*/         DBG_ERROR("Error: Function Key detected!");
/*?*/     }
/*?*/ 	else
/*?*/ 		// write normal key code
/*?*/ 		rStream << USHORT( rVal.GetCode() ) << USHORT( rVal.GetModifier() );
/*?*/ 	return rStream;
/*?*/ }


//====================================================================

// stores the configured accelerators to a stream

/*N*/ BOOL SfxAcceleratorManager::Store( SvStream& rStream )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	if ( pAccel )
//STRIP001 		Convert();
//STRIP001 
//STRIP001     const SfxAcceleratorItemList& rItems = GetItems();
//STRIP001 	USHORT nCount = rItems.size();
//STRIP001 	rStream << nVersion;
//STRIP001 	rStream << nCount;
//STRIP001     std::vector< SfxAcceleratorConfigItem>::const_iterator p;
//STRIP001     for ( p = rItems.begin(); p != rItems.end(); p++ )
//STRIP001 	{
//STRIP001         if ( p->nCode == 0 )
//STRIP001 			rStream << p->nId << KeyCode( p->nModifier );
//STRIP001         else
//STRIP001 			rStream << p->nId << KeyCode( p->nCode, p->nModifier );
//STRIP001 
//STRIP001 		if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
//STRIP001 			rStream << *(SFX_APP()->GetMacroConfig()->GetMacroInfo(p->nId));
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }


//--------------------------------------------------------------------
/*N*/ void SfxAcceleratorManager::UseDefault()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     BOOL bReconfigure = ( pAccel || pAccelCfg );
/*N*/ 	if ( bReconfigure )
/*N*/ 		Clear();
/*N*/ 
/*N*/     ResId aId( GetType() == SFX_ITEMTYPE_ACCEL ? RID_DEFAULTACCEL : GetType(), pResMgr );
/*N*/     aId.SetRT(RSC_ACCEL);
/*N*/ 
/*N*/     if ( Resource::GetResManager()->IsAvailable( aId ) )
/*N*/         pAccel =  new Accelerator( aId );
/*N*/     else
/*N*/         pAccelCfg = new SfxAcceleratorConfiguration;
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }


/*?*/ const SfxAcceleratorItemList& SfxAcceleratorManager::GetItems()
/*?*/ {
/*?*/     if ( pAccel )
/*?*/         Convert();
/*?*/ 
/*?*/     return pAccelCfg->GetItems();
/*?*/ }

//--------------------------------------------------------------------

/*?*/ USHORT SfxAcceleratorManager::GetId( const KeyCode &rKeyCode )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( pAccel )
//STRIP001         return pAccel->GetItemId( rKeyCode );
//STRIP001     else
//STRIP001     {
//STRIP001         sal_Int16 nCode, nModifier;
/*
        if( rKeyCode.IsFunction() )
        {
            nCode = 0;
            nModifier = rKeyCode.GetFunction();
        }
        else
*/
//STRIP001         {
//STRIP001             nCode = rKeyCode.GetCode();
//STRIP001             nModifier=rKeyCode.GetModifier();
//STRIP001         }
//STRIP001 
//STRIP001         const SfxAcceleratorItemList& rItems = GetItems();
//STRIP001         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
//STRIP001         for ( p = rItems.begin(); p != rItems.end(); p++ )
//STRIP001             if ( p->nCode == nCode && p->nModifier == nModifier )
//STRIP001                 return p->nId;
        return 0;
//STRIP001     }
/*?*/ }

//--------------------------------------------------------------------

// key code for a func-id

/*N*/ KeyCode SfxAcceleratorManager::GetKeyCode( USHORT nId )
/*N*/ {
/*N*/     if ( pAccel )
/*N*/         return pAccel->GetKeyCode( nId );
/*N*/     else
/*N*/     {
/*?*/         const SfxAcceleratorItemList& rItems = GetItems();
/*?*/ 
/*?*/         KeyCode aCode;
/*?*/         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
/*?*/         for ( p = rItems.begin(); p != rItems.end(); p++ )
/*?*/ 		{
/*?*/             if ( p->nId == nId )
/*?*/             {
/*?*/                 if ( p->nCode == 0 )
/*?*/                     return KeyCode( p->nModifier );
/*?*/                 else
/*?*/                     return KeyCode( p->nCode, p->nModifier );
/*?*/             }
/*?*/ 		}
/*?*/ 
/*?*/         return KeyCode();
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
// call this before reconfiguring
/*?*/ void SfxAcceleratorManager::Reset( USHORT nCount )
/*?*/ {
/*?*/ 	Clear();
/*?*/ 	pAccelCfg = new SfxAcceleratorConfiguration;
/*?*/ }

//--------------------------------------------------------------------

// call this after reconfiguring
/*?*/ void SfxAcceleratorManager::Reconfigure()
/*?*/ {
/*?*/ 	SetDefault(FALSE);
/*?*/ }

//--------------------------------------------------------------------

// append a new binding
/*?*/ void SfxAcceleratorManager::AppendItem( USHORT nId, const KeyCode& rKeyCode )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SfxAcceleratorConfigItem aItem;
//STRIP001     aItem.nId = nId;
//STRIP001     if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001         aItem.aCommand = SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL();
//STRIP001     else
//STRIP001     {
//STRIP001         aItem.aCommand = String::CreateFromAscii("slot:");
//STRIP001         aItem.aCommand += String::CreateFromInt32( nId );
//STRIP001     }
//STRIP001 
//STRIP001     aItem.nCode = rKeyCode.GetCode();
//STRIP001     if ( !aItem.nCode )
//STRIP001         aItem.nModifier = rKeyCode.GetFunction();
//STRIP001     else
//STRIP001         aItem.nModifier = rKeyCode.GetModifier();
//STRIP001     pAccelCfg->SetCommand( aItem );
/*?*/ }

// ------------------------------------------------------------------------

/*?*/ String SfxAcceleratorManager::GetStreamName() const
/*?*/ {
/*?*/     return SfxConfigItem::GetStreamName( GetType() );
/*?*/ }

/*?*/ BOOL SfxAcceleratorManager::Call(const KeyEvent& rEvnt, SfxBindings& rBind, BOOL bGlobal )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
//STRIP001     USHORT nId = 0;
//STRIP001     if ( pAccel )
//STRIP001     {
//STRIP001         nId = pAccel->GetItemId( rEvnt.GetKeyCode() );
//STRIP001         if ( !nId )
//STRIP001             return FALSE;
//STRIP001     }
//STRIP001     else if ( pAccelCfg )
//STRIP001     {
//STRIP001         const SfxAcceleratorItemList& rItems = GetItems();
//STRIP001 
//STRIP001         sal_Int16 nCode, nModifier;
//STRIP001         const KeyCode& rKeyCode = rEvnt.GetKeyCode();
//STRIP001 /*
//STRIP001         if( rKeyCode.IsFunction() )
//STRIP001         {
//STRIP001             nCode = USHORT(USHRT_MAX);
//STRIP001             nModifier = rKeyCode.GetFunction();
//STRIP001         }
//STRIP001         else
//STRIP001  */
//STRIP001         {
//STRIP001             nCode=rKeyCode.GetCode();
//STRIP001             nModifier=rKeyCode.GetModifier();
//STRIP001         }
//STRIP001 
//STRIP001         std::vector< SfxAcceleratorConfigItem>::const_iterator p;
//STRIP001         for ( p = rItems.begin(); p != rItems.end(); p++ )
//STRIP001             if ( p->nCode == nCode && p->nModifier == nModifier )
//STRIP001             {
//STRIP001                 nId = p->nId;
//STRIP001                 if ( p->aCommand.getLength() && ( p->aCommand.compareToAscii( "slot:", 5 ) != 0 ) )
//STRIP001                     return rBind.ExecuteCommand_Impl( p->aCommand );
//STRIP001                 break;
//STRIP001             }
//STRIP001     }
//STRIP001 
//STRIP001     //(mba/task): Hier muss abgefragt werden, ob denn gerade am aktuellen Document der Bindings Modalitt gegeben ist!
//STRIP001 	{
//STRIP001 		if ( bGlobal )
//STRIP001 		{
//STRIP001 			rBind.ExecuteGlobal_Impl( nId );
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// wegen OLE-InPlace und Container-KeyInput (SV liefert TRUE!)
//STRIP001             return rBind.Execute( nId );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
/*?*/ }

/*?*/ int SfxAcceleratorManager::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxAcceleratorManager::GetStreamName(), STREAM_STD_READ );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return ERR_READ;
//STRIP001     else
//STRIP001     {
//STRIP001     	BOOL bReconfigure = ( pAccel || pAccelCfg );
//STRIP001 		if ( bReconfigure )
//STRIP001 			Clear();
//STRIP001 
//STRIP001         pAccelCfg = new SfxAcceleratorConfiguration();
//STRIP001         if ( pAccelCfg->Load( *xStream ) )
//STRIP001         {
//STRIP001             SfxAcceleratorItemList& rItems = (SfxAcceleratorItemList&) GetItems();
//STRIP001             std::vector< SfxAcceleratorConfigItem>::iterator p;
//STRIP001             for ( p = rItems.begin(); p != rItems.end(); )
//STRIP001             {
//STRIP001                 if ( p->aCommand.compareToAscii( "slot:", 5 ) == 0 )
//STRIP001                 {
//STRIP001                     p->nId = (USHORT) p->aCommand.copy( 5 ).toInt32();
//STRIP001                     if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
//STRIP001                         // wrong configuration
//STRIP001                         rItems.erase(p);
//STRIP001                     else
//STRIP001                         p++;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     SfxMacroInfo aInfo( p->aCommand );
//STRIP001                     SFX_APP()->GetMacroConfig()->GetSlotId( &aInfo );
//STRIP001                     p->nId = aInfo.GetSlotId();
//STRIP001                     p++;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001 		else
//STRIP001         	return ERR_READ;
//STRIP001     }
//STRIP001 
//STRIP001 	SetDefault( FALSE );
//STRIP001 	return ERR_OK;
/*?*/ }

/*?*/ BOOL SfxAcceleratorManager::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
//STRIP001     if ( pAccel )
//STRIP001         Convert();
//STRIP001 
//STRIP001     SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxAcceleratorManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
//STRIP001     if ( xStream->GetError() )
//STRIP001         return FALSE;
//STRIP001     else
//STRIP001         return pAccelCfg->Commit( *xStream );
/*?*/ }

/*?*/ void SfxAcceleratorManager::Convert()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     DBG_ASSERT( pAccel && !pAccelCfg, "Wrong state of accelerator manager!" );
//STRIP001     if ( pAccel )
//STRIP001     {
//STRIP001         String aSlot = String::CreateFromAscii("slot:");
//STRIP001         USHORT nCount = pAccel->GetItemCount();
//STRIP001         SfxAcceleratorItemList aList;
//STRIP001         for ( USHORT nPos = 0; nPos < nCount; ++nPos )
//STRIP001         {
//STRIP001             USHORT nId = pAccel->GetItemId( nPos );
//STRIP001             KeyCode aKey = pAccel->GetItemKeyCode( nPos );
//STRIP001 
//STRIP001             SfxAcceleratorConfigItem aItem;
//STRIP001             aItem.nId = nId;
//STRIP001             if( aKey.IsFunction() )
//STRIP001             {
//STRIP001                 DBG_ERROR("Error: Function Key detected!");
//STRIP001                 aItem.nCode = 0;
//STRIP001                 aItem.nModifier = aKey.GetFunction();
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 aItem.nCode = aKey.GetCode();
//STRIP001                 aItem.nModifier = aKey.GetModifier();
//STRIP001             }
//STRIP001 
//STRIP001             if ( SfxMacroConfig::IsMacroSlot( nId ) )
//STRIP001                 aItem.aCommand = SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL();
//STRIP001             else
//STRIP001             {
//STRIP001                 aItem.aCommand = aSlot;
//STRIP001                 aItem.aCommand += String::CreateFromInt32( nId );
//STRIP001             }
//STRIP001 
//STRIP001             aList.push_back( aItem );
//STRIP001         }
//STRIP001 
//STRIP001         pAccelCfg = new SfxAcceleratorConfiguration;
//STRIP001         pAccelCfg->SetItems( aList, true );
//STRIP001         DELETEZ( pAccel );
//STRIP001     }
/*?*/ }

//--------------------------------------------------------------------
/*?*/ int SfxAcceleratorManager::Load(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	BOOL bReconfigure = ( pAccel || pAccelCfg );
//STRIP001 	if ( bReconfigure )
//STRIP001 		Clear();
//STRIP001 
//STRIP001     pAccelCfg = new SfxAcceleratorConfiguration;
//STRIP001 
//STRIP001 	USHORT nCount, nFileVersion;
//STRIP001 	rStream >> nFileVersion;
//STRIP001 	if(nFileVersion != nVersion)
//STRIP001 		return SfxConfigItem::WARNING_VERSION;
//STRIP001 
//STRIP001 	rStream >> nCount;
//STRIP001     SfxAcceleratorItemList aList;
//STRIP001     String aSlot = String::CreateFromAscii("slot:");
//STRIP001 	for ( USHORT nPos = 0; nPos<nCount; ++nPos )
//STRIP001 	{
//STRIP001         SfxAcceleratorConfigItem aItem;
//STRIP001 		KeyCode aKey;
//STRIP001 		rStream >> aItem.nId >> aKey;
//STRIP001 
//STRIP001 		if ( SfxMacroConfig::IsMacroSlot( aItem.nId ) )
//STRIP001 		{
//STRIP001 			SfxMacroInfo aInfo;
//STRIP001 			rStream >> aInfo;
//STRIP001 //            aItem.nId = aInfo.GetSlotId();
//STRIP001             aItem.nId = 0;
//STRIP001             aItem.aCommand = aInfo.GetURL();
//STRIP001 		}
//STRIP001 		else
//STRIP001         {
//STRIP001             aItem.aCommand = aSlot;
//STRIP001             aItem.aCommand += String::CreateFromInt32( aItem.nId );
//STRIP001         }
//STRIP001 
//STRIP001         if( aKey.IsFunction() )
//STRIP001         {
//STRIP001             DBG_ERROR("Error: Function Key detected!");
//STRIP001             aItem.nCode = 0;
//STRIP001             aItem.nModifier = aKey.GetFunction();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             aItem.nCode = aKey.GetCode();
//STRIP001             aItem.nModifier = aKey.GetModifier();
//STRIP001         }
//STRIP001 
//STRIP001         aList.push_back( aItem );
//STRIP001 	}
//STRIP001 
//STRIP001     pAccelCfg->SetItems( aList, true );
//STRIP001 	return SfxConfigItem::ERR_OK;
/*?*/ }

}
