/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slotserv.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:35:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXSLOTSERV_HXX
#define _SFXSLOTSERV_HXX

#include <tools/solar.h>
namespace binfilter {

class SfxSlot;

class SfxSlotServer
{
private:
	const SfxSlot*		_pSlot;
	USHORT				_nShellLevel;

public:
						SfxSlotServer( const SfxSlot &rSlot, USHORT nShell );
						SfxSlotServer();

	USHORT				GetShellLevel() const;
	void				SetShellLevel(USHORT nLevel) { _nShellLevel = nLevel; }
	void				SetSlot(const SfxSlot* pSlot) {
							_pSlot = pSlot;
						}
	const SfxSlot*		GetSlot() const;
	void				Invalidate() { _pSlot = 0; }
};

//--------------------------------------------------------------------

inline SfxSlotServer::SfxSlotServer( const SfxSlot &rSlot, USHORT nShell ):
	_pSlot( &rSlot),
	_nShellLevel( nShell )
{
}

//--------------------------------------------------------------------

inline SfxSlotServer::SfxSlotServer():
	_pSlot(0),
	_nShellLevel(0)
{
}

//--------------------------------------------------------------------

inline USHORT SfxSlotServer::GetShellLevel() const
{
	return _nShellLevel;
}

//--------------------------------------------------------------------

inline const SfxSlot* SfxSlotServer::GetSlot() const
{
	return _pSlot;
}


}//end of namespace binfilter
#endif
