/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxitem.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: kz $ $Date: 2006/01/05 17:51:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string>			// prevent conflict with STL includes

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
// auto strip #include <com/sun/star/frame/XFrame.hpp>
// auto strip #endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
// auto strip #ifndef _URLBMK_HXX //autogen
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #endif
// auto strip #ifndef _SV_TOOLBOX_HXX
// auto strip #include <vcl/toolbox.hxx>
// auto strip #endif

#include <svtools/imagemgr.hxx>
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #include <framework/addonmenu.hxx>
// auto strip #include <framework/addonsoptions.hxx>
#include <framework/menuconfiguration.hxx>
// auto strip #include <vcl/taskpanelist.hxx>

#ifndef INCLUDED_SVTOOLS_MENUOPTIONS_HXX
#include <svtools/menuoptions.hxx>
#endif
// auto strip #ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
// auto strip #include <svtools/miscopt.hxx>
// auto strip #endif

#pragma hdrstop

#include "tbxctrl.hxx"
// auto strip #include "mnumgr.hxx"
// auto strip #include "stbmgr.hxx"
#include "dispatch.hxx"
// auto strip #include "fltfnc.hxx"
// auto strip #include "msg.hxx"
#include "msgpool.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

// auto strip #include "statcach.hxx"
#include "viewfrm.hxx"
#include "arrdecl.hxx"
#include "sfxtypes.hxx"
#include "macrconf.hxx"
// auto strip #include "genlink.hxx"
// auto strip #include "sfxresid.hxx"
#include "toolbox.hrc"
#include "sfx.hrc"
// auto strip #include "module.hxx"
// auto strip #include "appdata.hxx"
// auto strip #include "docfile.hxx"
#include "docfac.hxx"
// auto strip #include "referers.hxx"
// auto strip #include "frmhtmlw.hxx"
// auto strip #include "app.hxx"
#include "unoctitm.hxx"
#include "helpid.hrc"
// auto strip #include "imagemgr.hxx"
// auto strip #include "workwin.hxx"
#include "imgmgr.hxx"
// auto strip #include "virtmenu.hxx"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;

//--------------------------------------------------------------------

static USHORT nLastId_Impl = SID_NEWDOCDIRECT;

//====================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL_ARG(SfxToolBoxControl, SfxStringItem, TRUE);
/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxAppToolBoxControl_Impl, SfxStringItem);
//STRIP001 /*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxDragToolBoxControl_Impl, SfxStringItem);
//STRIP001 /*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxHistoryToolBoxControl_Impl, SfxStringItem);
//STRIP001 /*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxReloadToolBoxControl_Impl, SfxBoolItem);
//STRIP001 /*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxAddonsToolBoxControl_Impl, SfxVoidItem);

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl::SfxToolBoxControl
/*N*/ (
/*N*/ 	USHORT          nId,
/*N*/ 	ToolBox&        rBox,
/*N*/ 	SfxBindings&    rBindings,
/*N*/ 	BOOL            bShowStringItems
/*N*/ )
/*N*/ :   SfxControllerItem(nId, rBindings),
/*N*/ 	pBox(&rBox),
/*N*/ 	bShowString(bShowStringItems),
/*N*/ 	pFact(0)
/*N*/ {
/*N*/ 	nSelectModifier = 0;
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_TOOLBOXCONFIG) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl::~SfxToolBoxControl()
/*N*/ {
/*N*/ 	if ( SfxMacroConfig::IsMacroSlot( GetId() ) )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GetMacroConfig()->ReleaseSlotId(GetId());
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl* SfxToolBoxControl::CreateControl( USHORT nId,
/*N*/ 		ToolBox *pBox, SfxBindings &rBindings, SfxModule *pMod )
/*N*/ {
/*N*/ 	SfxToolBoxControl *pCtrl;
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	if ( !pMod )
/*N*/ 	{
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxSlotPool *pSlotPool;
/*N*/ 	if ( pMod )
/*N*/ 		pSlotPool = pMod->GetSlotPool();
/*N*/ 	else
/*N*/ 		pSlotPool = &pApp->GetSlotPool();
/*N*/ 	TypeId aSlotType = pSlotPool->GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxTbxCtrlFactArr_Impl *pFactories = pMod->GetTbxCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxTbxCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 						   ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 					{
/*N*/ 						pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
/*N*/ 						pCtrl->pFact = rFactories[nFactory];
/*N*/ 						return pCtrl;
/*N*/ 					}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxTbxCtrlFactArr_Impl &rFactories = pApp->GetTbxCtrlFactories_Impl();
/*N*/ 
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 				   ( rFactories[nFactory]->nSlotId == nId) ) )
/*N*/ 			{
/*N*/ 				pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
/*N*/ 				pCtrl->pFact = rFactories[nFactory];
/*N*/ 				return pCtrl;
/*N*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	return new SfxToolBoxControl( nId, *pBox, rBindings );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nId,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( GetId() == nId, "strange SID" );
/*N*/ 	DBG_ASSERT( pBox != 0, "setting state to dangling ToolBox" );
/*N*/ 
/*N*/ 	if ( GetId() >= SID_OBJECTMENU0 && GetId() <= SID_OBJECTMENU_LAST )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// enabled/disabled-Flag pauschal korrigieren
/*N*/ 	pBox->EnableItem( GetId(), eState != SFX_ITEM_DISABLED );
/*N*/ 
/*N*/ 	USHORT nItemBits = pBox->GetItemBits( GetId() );
/*N*/ 	nItemBits &= ~TIB_CHECKABLE;
/*N*/ 	TriState eTri = STATE_NOCHECK;
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 		{
/*N*/ 			if ( pState->ISA(SfxBoolItem) )
/*N*/ 			{
/*N*/ 				// BoolItem fuer checken
/*N*/ 				if ( ((const SfxBoolItem*)pState)->GetValue() )
/*N*/ 					eTri = STATE_CHECK;
/*N*/ 				nItemBits |= TIB_CHECKABLE;
/*N*/ 			}
/*N*/ 			else if ( pState->ISA(SfxEnumItemInterface) &&
/*N*/ 				((SfxEnumItemInterface *)pState)->HasBoolValue())
/*N*/ 			{
/*N*/ 				// EnumItem wie Bool behandeln
/*N*/ 				if ( ((const SfxEnumItemInterface *)pState)->GetBoolValue() )
/*N*/ 					eTri = STATE_CHECK;
/*N*/ 				nItemBits |= TIB_CHECKABLE;
/*N*/ 			}
/*N*/ 			else if ( bShowString && pState->ISA(SfxStringItem) )
/*N*/ 				pBox->SetItemText(nId, ((const SfxStringItem*)pState)->GetValue() );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/         {
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/             nItemBits |= TIB_CHECKABLE;
/*N*/         }
/*N*/ 	}
/*N*/ 
/*N*/ 	pBox->SetItemState( GetId(), eTri );
/*N*/ 	pBox->SetItemBits( GetId(), nItemBits );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Select( USHORT nModifier )
/*N*/ {
/*N*/ 	nSelectModifier = nModifier;
/*N*/ 	Select( BOOL((nModifier & KEY_MOD1)!=0) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Select( BOOL bMod1 )
/*N*/ {
/*N*/ 	GetBindings().Execute( GetId(), 0, nSelectModifier );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxControl::DoubleClick()
/*?*/ {
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxControl::Click()
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxPopupWindowType SfxToolBoxControl::GetPopupWindowType() const
/*N*/ {
/*N*/ 	return SFX_POPUPWINDOW_NONE;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxPopupWindow* SfxToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	if ( GetId() >= SID_OBJECTMENU0 && GetId() <= SID_OBJECTMENU_LAST )
//STRIP001 	{
//STRIP001 		USHORT nConfigId;
//STRIP001 		PopupMenu *pPopup = SFX_APP()->GetMenuBarManager()->
//STRIP001 			GetObjectMenu( GetId(), nConfigId );
//STRIP001 		if ( pPopup )
//STRIP001 		{
//STRIP001 			Rectangle aItemRect( GetToolBox().GetItemRect(GetId()) );
//STRIP001 
//STRIP001 			Point aPos;
//STRIP001 			switch ( GetToolBox().GetAlign() )
//STRIP001 			{
//STRIP001 				case WINDOWALIGN_TOP:
//STRIP001 					aPos = aItemRect.BottomLeft();
//STRIP001 					break;
//STRIP001 
//STRIP001 				case WINDOWALIGN_BOTTOM:
//STRIP001 					aPos = aItemRect.TopLeft();
//STRIP001 					break;
//STRIP001 
//STRIP001 				case WINDOWALIGN_LEFT:
//STRIP001 					aPos = aItemRect.TopRight();
//STRIP001 					break;
//STRIP001 
//STRIP001 				case WINDOWALIGN_RIGHT:
//STRIP001 					aPos = aItemRect.TopLeft();
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			pPopup->Execute( pBox, aPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 SfxPopupWindow* SfxToolBoxControl::CreatePopupWindowCascading()
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ Window* SfxToolBoxControl::CreateItemWindow( Window * )
/*N*/ {
/*N*/ 	return 0;
/*N*/ }

/*?*/ SfxToolBoxControl* SfxToolBoxControl::ReInit_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 	USHORT nId = GetId();
//STRIP001 	SfxBindings& rBindings = GetBindings();
//STRIP001 	ToolBox *pBox = &GetToolBox();
//STRIP001 
//STRIP001 	// Test, welche ToolboxController-Factory im aktuellen Kontext einen
//STRIP001 	// Controller mit der Id dieses Controllers erzeugen k"onnte
//STRIP001 	SfxToolBoxControl *pCtrl = this;
//STRIP001 	SfxApplication *pApp = SFX_APP();
//STRIP001 	SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
//STRIP001 	SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
//STRIP001 	SfxSlotPool *pSlotPool;
//STRIP001 	if ( pMod )
//STRIP001 		pSlotPool = pMod->GetSlotPool();
//STRIP001 	else
//STRIP001 		pSlotPool = &pApp->GetSlotPool();
//STRIP001 	TypeId aSlotType = pSlotPool->GetSlotType(nId);
//STRIP001 	if ( aSlotType )
//STRIP001 	{
//STRIP001 		if ( pMod )
//STRIP001 		{
//STRIP001 			SfxTbxCtrlFactArr_Impl *pFactories = pMod->GetTbxCtrlFactories_Impl();
//STRIP001 			if ( pFactories )
//STRIP001 			{
//STRIP001 				SfxTbxCtrlFactArr_Impl &rFactories = *pFactories;
//STRIP001 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 						   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 					{
//STRIP001 						if ( pFact != rFactories[nFactory] )
//STRIP001 						{
//STRIP001 							// Es wurde eine Factory gefunden, und es ist eine
//STRIP001 							// andere als die dieses Controllers, d.h. durch
//STRIP001 							// einen Contextwechsel wurde auch der Controller
//STRIP001 							// ge"andert
//STRIP001 							pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
//STRIP001 							pCtrl->pFact = rFactories[nFactory];
//STRIP001 						}
//STRIP001 
//STRIP001 						// Die gefundene Factory ist die gleiche wie die dieses
//STRIP001 						// Controllers, d.h. es hat sich nichts ge"andert
//STRIP001 						return pCtrl;
//STRIP001 					}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxTbxCtrlFactArr_Impl &rFactories = pApp->GetTbxCtrlFactories_Impl();
//STRIP001 
//STRIP001 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 				   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 			{
//STRIP001 				if ( pFact != rFactories[nFactory] )
//STRIP001 				{
//STRIP001 					// Es wurde eine Factory gefunden, und es ist eine
//STRIP001 					// andere als die dieses Controllers, d.h. durch
//STRIP001 					// einen Contextwechsel wurde auch der Controller
//STRIP001 					// ge"andert
//STRIP001 					pCtrl = rFactories[nFactory]->pCtor( nId, *pBox, rBindings );
//STRIP001 					pCtrl->pFact = rFactories[nFactory];
//STRIP001 				}
//STRIP001 
//STRIP001 				// Die gefundene Factory ist die gleiche wie die dieses
//STRIP001 				// Controllers, d.h. es hat sich nichts ge"andert
//STRIP001 				return pCtrl;
//STRIP001 			}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Wenn der aktuelle Controller eine Factory hat, aber aktuell kein gefunden
//STRIP001 	// wird, mu\s dieser Controller durch einen StandardController ersetzt werden,
//STRIP001 	return pFact ? new SfxToolBoxControl( nId, *pBox, rBindings ) : this;
/*?*/ }

//--------------------------------------------------------------------

//STRIP001 BOOL SfxPopupWindow::Close()
//STRIP001 {
//STRIP001 /*?*/ 	bFloating = FALSE;
//STRIP001 /*?*/ 	FloatingWindow::Close();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	//if ( SFX_APP()->IsDowning() )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		Delete(0);
//STRIP001 /*?*/ 	}
//STRIP001 /*
//STRIP001 	else
//STRIP001 	{
//STRIP001 		UnBind();
//STRIP001         GetpApp()->PostUserEvent(LINK(this, SfxPopupWindow, Delete) , (void*)0);
//STRIP001 	}
//STRIP001 */
//STRIP001 /*?*/ 	return TRUE;
//STRIP001 /*?*/ }

//--------------------------------------------------------------------

//STRIP001 /*?*/ void SfxPopupWindow::PopupModeEnd()
//STRIP001 /*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	//! to allow PopupModeEndHdl to be called
//STRIP001 	FloatingWindow::PopupModeEnd();
//STRIP001 
//STRIP001 	if ( IsVisible() )
//STRIP001 	{
//STRIP001 		// wurde abgerissen
//STRIP001 		GetBindings().GetStateCache(GetId())->DeleteFloatingWindows();
//STRIP001 		bFloating = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Close();
//STRIP001 /*?*/ }

//--------------------------------------------------------------------

//STRIP001 /*?*/ void SfxPopupWindow::DeleteFloatingWindow()
//STRIP001 /*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( bFloating )
//STRIP001 	{
//STRIP001 		HACK(dieses muss via Parameter durchgereicht werden)
//STRIP001 		SfxPopupAction eAction = GetBindings().GetPopupAction_Impl();
//STRIP001 		switch ( eAction )
//STRIP001 		{
//STRIP001 			case SFX_POPUP_DELETE:
//STRIP001 				Hide();
//STRIP001 				Delete(0);
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_POPUP_HIDE:
//STRIP001             {
//STRIP001 				// hide popups by disabling the corresponding slot
//STRIP001                 SfxStateCache* pCache = GetBindings().GetStateCache( GetId() );
//STRIP001 
//STRIP001 				// invalidate cache so it will forward any state to controllers anyway
//STRIP001                 pCache->Invalidate( FALSE );
//STRIP001 
//STRIP001 				// set desired state, even if cache is marked "message dirty"
//STRIP001 				pCache->SetState(SFX_ITEM_DISABLED, 0, TRUE);
//STRIP001 				break;
//STRIP001             }
//STRIP001 			case SFX_POPUP_SHOW:
//STRIP001 			{
//STRIP001 				if ( GetParent() !=  SFX_APP()->GetTopWindow() )
//STRIP001 					SetParent( SFX_APP()->GetTopWindow() );
//STRIP001 
//STRIP001 				// Achtung: k"onnte wegen seines Kontextes unsichtbar sein!
//STRIP001 				SfxBindings &rBindings = GetBindings();
//STRIP001 				rBindings.Invalidate( GetId() );
//STRIP001 				rBindings.Update( GetId() );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 /*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxPopupWindow::SfxPopupWindow( USHORT nId, WinBits nBits, SfxBindings &rBindings ):
/*N*/ 	SfxControllerItem(nId, rBindings.GetSubBindings_Impl() ? *rBindings.GetSubBindings_Impl(TRUE) : rBindings ),
/*N*/ 	FloatingWindow( SFX_APP()->GetTopWindow(), nBits ),
/*N*/ 	bFloating(FALSE)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	bCascading = FALSE;
//STRIP001     rBindings.GetWorkWindow_Impl()->GetWindow()->GetSystemWindow()->GetTaskPaneList()->AddWindow( this );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxPopupWindow::SfxPopupWindow( USHORT nId, const ResId &rId, SfxBindings &rBindings ):
/*N*/ 	SfxControllerItem(nId, rBindings.GetSubBindings_Impl() ? *rBindings.GetSubBindings_Impl(TRUE) : rBindings ),
/*N*/ 	FloatingWindow( SFX_APP()->GetTopWindow(), rId ),
/*N*/ 	bFloating(FALSE)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	bCascading = FALSE;
//STRIP001     rBindings.GetWorkWindow_Impl()->GetWindow()->GetSystemWindow()->GetTaskPaneList()->AddWindow( this );
/*N*/ }

/*N*/ SfxPopupWindow::~SfxPopupWindow()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     GetBindings().GetWorkWindow_Impl()->GetWindow()->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( this );
/*N*/ }

//STRIP001 void SfxPopupWindow::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( bCascading == FALSE )
//STRIP001 		FloatingWindow::MouseMove( rMEvt );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// MouseMove-Event an die Children forwarden
//STRIP001 		Point       aPos = rMEvt.GetPosPixel();
//STRIP001 		Point       aScrPos = OutputToScreenPixel( aPos );
//STRIP001 		int i = 0;
//STRIP001 		Window* pWindow = GetChild( i );
//STRIP001 		while ( pWindow )
//STRIP001 		{
//STRIP001 			MouseEvent aMEvt( pWindow->ScreenToOutputPixel( aScrPos ),
//STRIP001 							  rMEvt.GetClicks(), rMEvt.GetMode(),
//STRIP001 							  rMEvt.GetButtons(), rMEvt.GetModifier() );
//STRIP001 			pWindow->MouseMove( rMEvt );
//STRIP001 			pWindow->Update();
//STRIP001 			i++;
//STRIP001 			pWindow = GetChild( i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxPopupWindow::StartCascading_Impl()
//STRIP001 {
//STRIP001 	bCascading= TRUE;
//STRIP001 }

//STRIP001 void SfxPopupWindow::EndCascading_Impl()
//STRIP001 {
//STRIP001 	bCascading = FALSE;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 SfxPopupWindow* SfxPopupWindow::Clone() const
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode mu\s "uberladen werden, um dieses Popup auch im
//STRIP001 	Presentations-Modus anzuzeigen. Sie wird gerufen, wenn ein Show()
//STRIP001 	sinnlos w"are, da der Parent nicht das Presentations-Window ist.
//STRIP001 	Beim neu erzeugen wird automatisch das neue Top-Window verwendet, so
//STRIP001 	da\s der Parent das Presentations-Window ist und das neue Popup somit
//STRIP001 	sichtbar ist.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxPopupWindow::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 								   const SfxPoolItem* pState )
//STRIP001 /*  [Bescheibung]
//STRIP001 
//STRIP001 	Siehe auch <SfxControllerItem::StateChanged()>. Au\serdem wird
//STRIP001 	bei eState==SFX_ITEM_DISABLED das Popup gehided und in allen anderen
//STRIP001 	F"allen, falls es floating ist, wieder angezeigt. Daher mu\s die
//STRIP001 	Basisklasse i.d.R. gerufen werden.
//STRIP001 
//STRIP001 	Es findet wegen des Parents eine Sonderbehandlung f"ur den
//STRIP001 	Presentationsmodus statt.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( SFX_ITEM_DISABLED == eState )
//STRIP001 	{
//STRIP001 		Hide();
//STRIP001 	}
//STRIP001 	else if ( bFloating )
//STRIP001 	{
//STRIP001 		Show( TRUE, SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxPopupWindow, Delete, void *, pvoid )
//STRIP001 {
//STRIP001 /*
//STRIP001 	if ( pvoid )
//STRIP001 	{
//STRIP001 		SfxBindings& rBindings = GetBindings();
//STRIP001 		rBindings.DENTERREGISTRATIONS();
//STRIP001 		SfxPopupWindow *pNew = Clone();
//STRIP001 		if ( pNew )
//STRIP001 		{
//STRIP001 			pNew->SetPosSizePixel( GetPosPixel(), GetSizePixel() );
//STRIP001 			pNew->bFloating = TRUE;
//STRIP001 			rBindings.DLEAVEREGISTRATIONS();
//STRIP001 			rBindings.Invalidate( GetId() );
//STRIP001 			rBindings.Update( GetId() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 */
//STRIP001 	if ( aDeleteLink.IsSet() )
//STRIP001 		aDeleteLink.Call( this );
//STRIP001 	delete this;
//STRIP001 	return 0;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxAppToolBoxControl_Impl::SfxAppToolBoxControl_Impl
/*N*/ (
/*N*/ 	USHORT nId, ToolBox& rBox, SfxBindings &rBindings
/*N*/ )
/*N*/ 	: SfxToolBoxControl( nId, rBox, rBindings )
/*N*/ 	, bBigImages( FALSE )
/*N*/     , pMenu( 0 )
/*N*/ {
/*N*/ 	aTimer.SetTimeout( 250 );
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SfxAppToolBoxControl_Impl, Timeout ) );
/*N*/     rBox.SetHelpId( nId, HID_TBXCONTROL_FILENEW );
/*N*/     rBox.SetItemBits( nId,  rBox.GetItemBits( nId ) | TIB_DROPDOWN);
/*N*/ 
/*N*/ 	// Determine the current background color of the menus
/*N*/ 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	m_bWasHiContrastMode	= rSettings.GetMenuColor().IsDark();
/*N*/ 	m_bShowMenuImages		= SvtMenuOptions().IsMenuIconsEnabled();
/*N*/ 
/*N*/     SetImage( String() );
/*N*/ }

/*N*/ SfxAppToolBoxControl_Impl::~SfxAppToolBoxControl_Impl()
/*N*/ {
/*N*/     delete pMenu;
/*N*/ }

//_____________________________________________________
/*
    it return the existing state of the given URL in the popupmenu of this toolbox control.

    If the given URL can be located as an action command of one menu item of the
    popup menu of this control, we return TRUE. Otherwhise we return FALSE.
    Further we return a fallback URL, in case we have to return FALSE. Because
    the outside code must select a valid item of the popup menu everytime ...
    and we define it here. By the way this m ethod was written to handle
    error situations gracefully. E.g. it can be called during creation time
    but then we have no valid menu. For this case we know another fallback URL.
    Then we return the private:factory/ URL of the default factory.

    @param  *pMenu
                pounts to the popup menu, on which item we try to locate the given URL
                Can be NULL! Search will be supressed then.

    @param  sURL
                the URL for searching

    @param  pFallback
                contains the fallback URL in case we return FALSE
                Must point to valid memory!

    @return TRUE - if URL could be located as an item of the popup menu.
            FALSE - otherwhise.
*/
/*N*/ BOOL Impl_ExistURLInMenu( const PopupMenu *pMenu     ,
/*N*/                           const String    &sURL      ,
/*N*/                                 String    *pFallback )
/*N*/ {
/*N*/     BOOL bValidFallback = FALSE;
/*N*/     if (pMenu && sURL.Len())
/*N*/     {
/*N*/         USHORT c = pMenu->GetItemCount();
/*N*/         for (USHORT p=0; p<c; ++p)
/*N*/         {
/*N*/             USHORT nId = pMenu->GetItemId(p);
/*N*/             String aCmd( pMenu->GetItemCommand(nId) );
/*N*/ 
/*N*/             if (!bValidFallback && aCmd.Len())
/*N*/             {
/*N*/                 *pFallback = aCmd;
/*N*/                 bValidFallback = TRUE;
/*N*/             }
/*N*/ 
/*N*/             if (sURL.Equals(aCmd))
/*N*/                 return TRUE;
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     if (!bValidFallback)
/*N*/     {
/*N*/ 		*pFallback  = DEFINE_CONST_UNICODE("private:factory/");
/*N*/         *pFallback += String::CreateFromAscii(SfxObjectFactory::GetDefaultFactory().GetShortName());
/*N*/     }
/*N*/ 
/*N*/     return FALSE;
/*N*/ }

/*N*/ void SfxAppToolBoxControl_Impl::SetImage( const String &rURL )
/*N*/ {
    /* We accept URL's here only, which exist as items of our internal popup menu.
       All other ones will be ignored and a fallback is used ... */
/*N*/     String aURL = rURL;
/*N*/     String sFallback;
/*N*/     BOOL bValid = Impl_ExistURLInMenu(pMenu,aURL,&sFallback);
/*N*/     if (!bValid)
/*N*/         aURL = sFallback;
/*N*/ 
/*N*/ 	BOOL bBig = ( SfxImageManager::GetCurrentSymbolsSize() == SFX_SYMBOLS_SIZE_LARGE );
/*N*/     GetToolBox().SetItemImage( GetId(),
/*N*/ 							   SvFileInformationManager::GetImage( INetURLObject( aURL ),
/*N*/ 							   bBig,
/*N*/ 								GetToolBox().GetBackground().GetColor().IsDark() ) );
/*N*/ 	aLastURL = aURL;
/*N*/ }

/*N*/ void SfxAppToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nId,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/     if ( pState && pState->ISA(SfxStringItem) )
/*N*/     {
/*N*/         // Important step for following SetImage() call!
/*N*/         // It needs the valid pMenu item to fullfill it's specification
/*N*/         // to check for supported URLs ...
/*N*/         if ( !pMenu )
/*N*/         {
/*N*/             Reference < ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
/*N*/             ::framework::MenuConfiguration aConf( aXMultiServiceFactory );
/*N*/             Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
/*N*/             pMenu = aConf.CreateBookmarkMenu( aXFrame, BOOKMARK_NEWMENU );
/*N*/         }
/*N*/         GetToolBox().EnableItem( GetId(), eState != SFX_ITEM_DISABLED );
/*N*/         SetImage(((const SfxStringItem*)pState)->GetValue());
/*N*/     }
/*N*/     else
/*N*/         SfxToolBoxControl::StateChanged( nId, eState, pState );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxAppToolBoxControl_Impl::Select( BOOL bMod1 )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	aTimer.Stop();
//STRIP001 
//STRIP001     if( aLastURL.Len() )
//STRIP001 	{
//STRIP001         if ( aLastURL.CompareToAscii( "slot:", 5 ) == COMPARE_EQUAL )
//STRIP001         {
//STRIP001             USHORT nId = (USHORT) aLastURL.Copy( 5 ).ToInt32();
//STRIP001             GetBindings().Execute( nId );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             SfxStringItem aName( SID_FILE_NAME, aLastURL );
//STRIP001             SfxStringItem aReferer( SID_REFERER, DEFINE_CONST_UNICODE(SFX_REFERER_NEWMENU) );
//STRIP001             SfxBoolItem aTemplate( SID_TEMPLATE, TRUE );
//STRIP001             SfxStringItem aTarget( SID_TARGETNAME, String::CreateFromAscii("_blank") );
//STRIP001 
//STRIP001             const SfxPoolItem* aItems[5];
//STRIP001             aItems[4] = 0;
//STRIP001             aItems[0] = &aName;
//STRIP001             aItems[1] = &aReferer;
//STRIP001             aItems[2] = &aTemplate;
//STRIP001             aItems[3] = &aTarget;
//STRIP001             GetBindings().Execute( SID_OPENDOC, aItems, 0, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001         }
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SfxToolBoxControl::Select( bMod1 );
/*?*/ }

//--------------------------------------------------------------------
/*?*/ long Select_Impl( void* pHdl, void* pVoid );


/*?*/ IMPL_LINK( SfxAppToolBoxControl_Impl, Activate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pMenu )
//STRIP001 	{
//STRIP001 		const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 		BOOL bIsHiContrastMode	= rSettings.GetMenuColor().IsDark();
//STRIP001 		BOOL bShowMenuImages	= SvtMenuOptions().IsMenuIconsEnabled();
//STRIP001 
//STRIP001 		if (( bIsHiContrastMode != m_bWasHiContrastMode ) ||
//STRIP001 			( bShowMenuImages	!= m_bShowMenuImages	)	 )
//STRIP001 		{
//STRIP001 			m_bWasHiContrastMode = bIsHiContrastMode;
//STRIP001 			m_bShowMenuImages	 = bShowMenuImages;
//STRIP001 
//STRIP001 			USHORT nCount = pMenu->GetItemCount();
//STRIP001 			for ( USHORT nSVPos = 0; nSVPos < nCount; nSVPos++ )
//STRIP001 			{
//STRIP001 				USHORT nId = pMenu->GetItemId( nSVPos );
//STRIP001 				if ( pMenu->GetItemType( nSVPos ) != MENUITEM_SEPARATOR )
//STRIP001 				{
//STRIP001 					if ( bShowMenuImages )
//STRIP001 					{
//STRIP001 						sal_Bool		bImageSet = sal_False;
//STRIP001 						::rtl::OUString aImageId;
//STRIP001 						::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 							(::framework::MenuConfiguration::Attributes*)pMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 						if ( pMenuAttributes )
//STRIP001 							aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 
//STRIP001 						if ( aImageId.getLength() > 0 )
//STRIP001 						{
//STRIP001                             Reference< ::com::sun::star::frame::XFrame > xFrame;
//STRIP001 							Image aImage = GetImage( xFrame, aImageId, FALSE, bIsHiContrastMode );
//STRIP001 							if ( !!aImage )
//STRIP001 							{
//STRIP001 								bImageSet = sal_True;
//STRIP001 								pMenu->SetItemImage( nId, aImage );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						String aCmd( pMenu->GetItemCommand( nId ) );
//STRIP001 						if ( !bImageSet && aCmd.Len() )
//STRIP001 						{
//STRIP001 							Image aImage = SvFileInformationManager::GetImage( aCmd, FALSE, bIsHiContrastMode );
//STRIP001 							if ( !!aImage )
//STRIP001 								pMenu->SetItemImage( nId, aImage );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pMenu->SetItemImage( nId, Image() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
/*?*/ 	return FALSE;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxAppToolBoxControl_Impl, Timeout, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxApplication* pApp = SFX_APP();
//STRIP001 	ToolBox& rBox = GetToolBox();
//STRIP001 	Rectangle aRect(  rBox.GetItemRect( GetId() ) );
//STRIP001 
//STRIP001 	USHORT nId = GetId();
//STRIP001 	BOOL bNew = FALSE;
//STRIP001 
//STRIP001     if ( !pMenu )
//STRIP001     {
//STRIP001         Reference < ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001         ::framework::MenuConfiguration aConf( aXMultiServiceFactory );
//STRIP001         Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001         pMenu = aConf.CreateBookmarkMenu( aXFrame, BOOKMARK_NEWMENU );
//STRIP001     }
//STRIP001 
//STRIP001 	if( pMenu )
//STRIP001 	{
//STRIP001         pMenu->SetSelectHdl( Link( &(this->GetBindings()), Select_Impl ) );
//STRIP001 		pMenu->SetActivateHdl( LINK( this, SfxAppToolBoxControl_Impl, Activate ));
//STRIP001 		rBox.SetItemDown( GetId(), TRUE );
//STRIP001         USHORT nSelected = pMenu->Execute( &rBox, aRect, POPUPMENU_EXECUTE_DOWN );
//STRIP001         if ( nSelected )
//STRIP001         {
//STRIP001             aLastURL = pMenu->GetItemCommand( nSelected );
//STRIP001             SetImage( pMenu->GetItemCommand( nSelected ) );
//STRIP001         }
//STRIP001 
//STRIP001         rBox.SetItemDown( GetId(), FALSE );
//STRIP001 	}
//STRIP001 
/*?*/ 	return 0;
/*?*/ }

//--------------------------------------------------------------------

/*?*/ void SfxAppToolBoxControl_Impl::Click( )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( GetId() == SID_NEWDOCDIRECT )
//STRIP001 		aTimer.Start();
//STRIP001 	else
//STRIP001 		Timeout(0);
/*?*/ }

//--------------------------------------------------------------------

//STRIP001 SfxAddonsToolBoxControl_Impl::SfxAddonsToolBoxControl_Impl
//STRIP001 (
//STRIP001 	USHORT nId, ToolBox& rBox, SfxBindings &rBindings
//STRIP001 )
//STRIP001 	: SfxToolBoxControl( nId, rBox, rBindings )
//STRIP001 	, bBigImages( FALSE )
//STRIP001     , pMenu( 0 )
//STRIP001 {
//STRIP001     rBox.SetItemBits( nId,  rBox.GetItemBits( nId ) | TIB_DROPDOWN);
//STRIP001 
//STRIP001 	// Determine the current background color of the menus
//STRIP001 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	m_bWasHiContrastMode	= rSettings.GetMenuColor().IsDark();
//STRIP001 	m_bShowMenuImages		= SvtMenuOptions().IsMenuIconsEnabled();
//STRIP001 }

//STRIP001 SfxAddonsToolBoxControl_Impl::~SfxAddonsToolBoxControl_Impl()
//STRIP001 {
//STRIP001     delete pMenu;
//STRIP001 }

//STRIP001 void SfxAddonsToolBoxControl_Impl::RefreshMenuImages( Menu* pSVMenu )
//STRIP001 {
//STRIP001 	framework::AddonsOptions	aAddonOptions;
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001 	USHORT nCount = pSVMenu->GetItemCount();
//STRIP001 	for ( USHORT nPos = 0; nPos < nCount; nPos++ )
//STRIP001 	{
//STRIP001 		USHORT nId = pSVMenu->GetItemId( nPos );
//STRIP001 		if ( pSVMenu->GetItemType( nPos ) != MENUITEM_SEPARATOR )
//STRIP001 		{
//STRIP001 			if ( m_bShowMenuImages )
//STRIP001 			{
//STRIP001 				sal_Bool		bImageSet = sal_False;
//STRIP001 				::rtl::OUString aImageId;
//STRIP001 
//STRIP001 				::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 					(::framework::MenuConfiguration::Attributes*)pSVMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 				if ( pMenuAttributes )
//STRIP001 					aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 
//STRIP001 				if ( aImageId.getLength() > 0 )
//STRIP001 				{
//STRIP001 					Image aImage = GetImage( aXFrame, aImageId, FALSE, m_bWasHiContrastMode );
//STRIP001 					if ( !!aImage )
//STRIP001 					{
//STRIP001 						bImageSet = sal_True;
//STRIP001 						pSVMenu->SetItemImage( nId, aImage );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( !bImageSet )
//STRIP001 				{
//STRIP001 					::rtl::OUString aMenuItemCommand = pSVMenu->GetItemCommand( nId );
//STRIP001 					Image aImage = GetImage( aXFrame, aMenuItemCommand, FALSE, m_bWasHiContrastMode );
//STRIP001 					if ( !aImage )
//STRIP001 						aImage = aAddonOptions.GetImageFromURL( aMenuItemCommand, FALSE, m_bWasHiContrastMode );
//STRIP001 
//STRIP001 					pSVMenu->SetItemImage( nId, aImage );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pSVMenu->SetItemImage( nId, Image() );
//STRIP001 
//STRIP001 			// Go recursive through the sub-menus
//STRIP001 			PopupMenu* pPopup = pSVMenu->GetPopupMenu( nId );
//STRIP001 			if ( pPopup )
//STRIP001 				RefreshMenuImages( pPopup );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void SfxAddonsToolBoxControl_Impl::StateChanged
//STRIP001 (
//STRIP001 	USHORT              nId,
//STRIP001 	SfxItemState        eState,
//STRIP001 	const SfxPoolItem*  pState
//STRIP001 )
//STRIP001 {
//STRIP001 	SfxToolBoxControl::StateChanged( nId, eState, pState );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxAddonsToolBoxControl_Impl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	SfxApplication* pApp = SFX_APP();
//STRIP001 	ToolBox& rBox = GetToolBox();
//STRIP001 	Rectangle aRect(  rBox.GetItemRect( GetId() ) );
//STRIP001 
//STRIP001 	USHORT nId = GetId();
//STRIP001 	BOOL bNew = FALSE;
//STRIP001 
//STRIP001     if ( !pMenu )
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001         PopupMenu* pSVMenu = framework::AddonMenuManager::CreateAddonMenu( aXFrame );
//STRIP001         RefreshMenuImages( pSVMenu );
//STRIP001 		pMenu = new SfxPopupMenuManager( pSVMenu, GetBindings() );
//STRIP001     }
//STRIP001 
//STRIP001 	if( pMenu )
//STRIP001 	{
//STRIP001 		const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 		BOOL bIsHiContrastMode	= rSettings.GetMenuColor().IsDark();
//STRIP001 		BOOL bShowMenuImages	= SvtMenuOptions().IsMenuIconsEnabled();
//STRIP001 
//STRIP001 		if (( bIsHiContrastMode != m_bWasHiContrastMode ) ||
//STRIP001 			( bShowMenuImages	!= m_bShowMenuImages	)	 )
//STRIP001 		{
//STRIP001 			m_bWasHiContrastMode = bIsHiContrastMode;
//STRIP001 			m_bShowMenuImages	 = bShowMenuImages;
//STRIP001 			RefreshMenuImages( pMenu->GetMenu()->GetSVMenu() );
//STRIP001 		}
//STRIP001 
//STRIP001 		rBox.SetItemDown( GetId(), TRUE );
//STRIP001         ((PopupMenu*)pMenu->GetMenu()->GetSVMenu())->Execute( &rBox, aRect, POPUPMENU_EXECUTE_DOWN );
//STRIP001         rBox.SetItemDown( GetId(), FALSE );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxAddonsToolBoxControl_Impl::Click( )
//STRIP001 {
//STRIP001 	SfxToolBoxControl::Click();
//STRIP001 }

//--------------------------------------------------------------------


//STRIP001 SfxDragToolBoxControl_Impl::SfxDragToolBoxControl_Impl
//STRIP001 (
//STRIP001 	USHORT nId, ToolBox& rBox, SfxBindings &rBindings
//STRIP001 )
//STRIP001 	:   SfxToolBoxControl( nId, rBox, rBindings )
//STRIP001 {
//STRIP001 }

//STRIP001 Window* SfxDragToolBoxControl_Impl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001     return new SfxDragButton_Impl( pParent, GetBindings() );
//STRIP001 }

//STRIP001 void SfxDragToolBoxControl_Impl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001     GetBindings().Execute( SID_CREATELINK, NULL, 0, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 }

//STRIP001 SfxDragButton_Impl::SfxDragButton_Impl( Window *pParent, SfxBindings& rBind  )
//STRIP001     : FixedImage( pParent )
//STRIP001     , pBindings( &rBind )
//STRIP001 {
//STRIP001 	SetBackground( pParent->GetBackground() );
//STRIP001 	Image aImage( SfxResId( RID_GREPIMAGE ) );
//STRIP001 	SetImage( aImage );
//STRIP001 	Size aSize( aImage.GetSizePixel() );
//STRIP001 	aSize.Width() += 6;
//STRIP001 	SetSizePixel( aSize );
//STRIP001 }

//STRIP001 void SfxDragButton_Impl::Command ( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	if( rCEvt.GetCommand() != COMMAND_STARTDRAG )
//STRIP001 		return;
//STRIP001  /*
//STRIP001 	SfxViewFrame *pViewFrame = SfxViewFrame::Current();
//STRIP001 	if ( pViewFrame )
//STRIP001 	{
//STRIP001         SfxFrame *pFrame = pBindings->GetDispatcher()->GetFrame()->GetFrame()->GetTopFrame();
//STRIP001 		SfxObjectShell* pSh = pFrame->GetCurrentDocument();
//STRIP001 		if( pSh && pSh->HasName() )
//STRIP001 		{
//STRIP001 			DragServer::Clear();
//STRIP001 			INetBookmark aBmk(
//STRIP001 				SfxFrameHTMLWriter::CreateURL( pFrame ),
//STRIP001 				pSh->GetTitle( SFX_TITLE_CAPTION ) );
//STRIP001 			aBmk.CopyDragServer();
//STRIP001 			Pointer aMovePtr = Pointer( POINTER_MOVEDATA );
//STRIP001 			Pointer aCopyPtr = Pointer( POINTER_COPYDATA );
//STRIP001 			Pointer aLinkPtr = Pointer( POINTER_LINKDATA );
//STRIP001 			ExecuteDrag( aMovePtr, aCopyPtr, aLinkPtr, DRAG_COPYABLE | DRAG_LINKABLE );
//STRIP001 		}
//STRIP001 	}
//STRIP001   */
//STRIP001 }
//STRIP001 
//STRIP001 void SfxDragButton_Impl::MouseMove( const MouseEvent& rEvt )
//STRIP001 {
//STRIP001 	SetPointer( Pointer( POINTER_HAND ) );
//STRIP001 }
//STRIP001 
//STRIP001 void SfxDragButton_Impl::MouseButtonDown( const MouseEvent& rEvt )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SfxHistoryToolBoxControl_Impl::SfxHistoryToolBoxControl_Impl( USHORT nId,
//STRIP001 		ToolBox& rBox, SfxBindings &rBindings )
//STRIP001   : SfxToolBoxControl( nId, rBox, rBindings )
//STRIP001 {
//STRIP001 	aTimer.SetTimeout( 250 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxHistoryToolBoxControl_Impl, Timeout ) );
//STRIP001 }
//STRIP001 
//STRIP001 void SfxHistoryToolBoxControl_Impl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	aTimer.Stop();
//STRIP001 	SfxToolBoxControl::Select( bMod1 );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SfxHistoryToolBoxControl_Impl, Timeout, Timer *, pTimer )
//STRIP001 {
//STRIP001 	ToolBox& rBox = GetToolBox();
//STRIP001 
//STRIP001 	rBox.SetItemDown( GetId(), TRUE );
//STRIP001 
//STRIP001 	SfxApplication* pApp = SFX_APP();
//STRIP001 	Rectangle aRect(  rBox.GetItemRect( GetId() ) );
//STRIP001 	aRect.SetPos( rBox.OutputToScreenPixel( aRect.TopLeft() ) );
//STRIP001 
//STRIP001     SfxFrame *pTop = GetBindings().GetDispatcher()->GetFrame()->GetFrame()->GetTopFrame();
//STRIP001 	if ( pTop->ExecuteHistoryMenu_Impl( GetId(), aRect, POPUPMENU_EXECUTE_UP ) )
//STRIP001 		rBox.SetItemDown( GetId(), FALSE );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void SfxHistoryToolBoxControl_Impl::Click( )
//STRIP001 {
//STRIP001 	aTimer.Start();
//STRIP001 	// SfxToolBoxControl::Click();
//STRIP001 }
//STRIP001 
//STRIP001 SfxReloadToolBoxControl_Impl::SfxReloadToolBoxControl_Impl( USHORT nId,
//STRIP001 		ToolBox& rBox, SfxBindings &rBindings )
//STRIP001   : SfxToolBoxControl( nId, rBox, rBindings )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void SfxReloadToolBoxControl_Impl::Select( USHORT nModifier )
//STRIP001 {
//STRIP001 	SfxBoolItem aItem( SID_RELOAD, TRUE );
//STRIP001 	const SfxPoolItem* aItems[2];
//STRIP001 	aItems[1] = 0;
//STRIP001 	aItems[0] = &aItem;
//STRIP001     GetBindings().Execute( GetId(),
//STRIP001 			aItems, nModifier, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 }
//STRIP001 
//STRIP001 SfxUnoToolBoxControl* SfxToolBoxControl::CreateControl( const String& rCmd,
//STRIP001 		USHORT nId, ToolBox *pBox, SfxBindings &rBindings )
//STRIP001 {
//STRIP001 	return new SfxUnoToolBoxControl( rCmd, nId, pBox, rBindings );
//STRIP001 }
//STRIP001 
//STRIP001 SfxUnoToolBoxControl::SfxUnoToolBoxControl( const String& rCmd, USHORT nId,
//STRIP001 	ToolBox *pBox, SfxBindings& rBindings )
//STRIP001 	: SfxToolBoxControl( nId, *pBox, rBindings )
//STRIP001 {
//STRIP001 	UnBind();
//STRIP001 	pUnoCtrl = new SfxUnoControllerItem( this, rBindings, rCmd );
//STRIP001 	pUnoCtrl->acquire();
//STRIP001 	pUnoCtrl->GetNewDispatch();
//STRIP001 }
//STRIP001 
//STRIP001 SfxUnoToolBoxControl::~SfxUnoToolBoxControl()
//STRIP001 {
//STRIP001 	pUnoCtrl->UnBind();
//STRIP001 	pUnoCtrl->release();
//STRIP001 }
//STRIP001 
//STRIP001 void SfxUnoToolBoxControl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	pUnoCtrl->Execute();
//STRIP001 }


}
