/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_viewsh.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:55:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _PLUGIN_HXX //autogen
// auto strip #include <so3/plugin.hxx>
// auto strip #endif
// auto strip #ifndef _APPLET_HXX //autogen
// auto strip #include <so3/applet.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
// auto strip #ifndef _SOERR_HXX //autogen
// auto strip #include <so3/soerr.hxx>
// auto strip #endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
// auto strip #ifndef _SFXECODE_HXX
// auto strip #include <svtools/sfxecode.hxx>
// auto strip #endif
// auto strip #ifndef _EHDL_HXX
// auto strip #include <svtools/ehdl.hxx>
// auto strip #endif

#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>
// auto strip #include <svtools/miscopt.hxx>
#ifndef INCLUDED_SVTOOLS_INTERNALOPTIONS_HXX
#include <svtools/internaloptions.hxx>
#endif

// auto strip #include <svtools/javaoptions.hxx>
// auto strip #include <basic/basmgr.hxx>
// auto strip #include <basic/sbuno.hxx>
// auto strip #include <framework/actiontriggerhelper.hxx>

#pragma hdrstop

// auto strip #include "viewsh.hxx"
#include "viewimp.hxx"

#include "sfxresid.hxx"
#include "request.hxx"
// auto strip #include "templdlg.hxx"
// auto strip #include "interno.hxx"
#include "printer.hxx"
#include "docfile.hxx"
#include "dispatch.hxx"
#include "arrdecl.hxx"
#include "ipenv.hxx"
// auto strip #include "accmgr.hxx"
#include "intfrm.hxx"
#include "docfac.hxx"
#include "view.hrc"
#include "mnumgr.hxx"
#include "virtmenu.hxx"
// auto strip #include "objuno.hxx"
#include "sfxlocal.hrc"
#include "frameobj.hxx"
#include "sfxbasecontroller.hxx"
#include "topfrm.hxx"
// auto strip #include "mailmodel.hxx"
#include "event.hxx"
// auto strip #include "appdata.hxx"
#include "fcontnr.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;

//=========================================================================
/*N*/ DBG_NAME(SfxViewShell)

#define SfxViewShell
#include "so3/staticbaseurl.hxx"
namespace binfilter {
#include "sfxslots.hxx"

//=========================================================================

/*N*/ SFX_IMPL_INTERFACE(SfxViewShell,SfxShell,SfxResId(0))
/*N*/ {
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SID_MAIL_CHILDWIN );
/*N*/ }

/*N*/ TYPEINIT2(SfxViewShell,SfxShell,SfxListener);

//--------------------------------------------------------------------

//STRIP001 ErrCode SfxViewShell::DirectLoad( SfxFrame* pFrame, SfxMedium& rMedium )
//STRIP001 {
//STRIP001 	return ERRCODE_SFX_FORCEDOCLOAD;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::ExecMisc_Impl( SfxRequest &rReq )
/*N*/ {
/*N*/ 	const USHORT nId = rReq.GetSlot();
/*N*/ 	switch( nId )
/*N*/ 	{
/*N*/ 		case SID_STYLE_FAMILY :
/*N*/ 		{
/*N*/ 			SFX_REQUEST_ARG(rReq, pItem, SfxUInt16Item, nId, FALSE);
/*N*/ 			if (pItem)
/*N*/ 				pImp->nFamily = pItem->GetValue();
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		case SID_STYLE_CATALOG:
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxTemplateCatalog aCatalog(
//STRIP001 /*?*/ 				SFX_APP()->GetTopWindow(), &GetViewFrame()->GetBindings());
//STRIP001 /*?*/ 			aCatalog.Execute();
//STRIP001 /*?*/             rReq.Ignore();
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*N*/ 
/*N*/ 		case SID_MAIL_SENDDOCASPDF:
/*N*/ 		case SID_MAIL_SENDDOC:
/*?*/             if ( SvtInternalOptions().MailUIEnabled() )
/*?*/             {
/*?*/                 GetViewFrame()->SetChildWindow( SID_MAIL_CHILDWIN, TRUE );
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxMailModel_Impl	aModel( &GetViewFrame()->GetBindings() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SFX_REQUEST_ARG(rReq, pMailSubject, SfxStringItem, SID_MAIL_SUBJECT, FALSE );
//STRIP001 /*?*/ 				if ( pMailSubject )
//STRIP001 /*?*/ 					aModel.SetSubject( pMailSubject->GetValue() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SFX_REQUEST_ARG(rReq, pMailRecipient, SfxStringItem, SID_MAIL_RECIPIENT, FALSE );
//STRIP001 /*?*/ 				if ( pMailRecipient )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					String aRecipient( pMailRecipient->GetValue() );
//STRIP001 /*?*/ 					String aMailToStr( String::CreateFromAscii( "mailto:" ));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( aRecipient.Search( aMailToStr ) == 0 )
//STRIP001 /*?*/ 						aRecipient = aRecipient.Erase( 0, aMailToStr.Len() );
//STRIP001 /*?*/ 					aModel.AddAddress( aRecipient, SfxMailModel_Impl::ROLE_TO );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxMailModel_Impl::SendMailResult eResult = SfxMailModel_Impl::SEND_MAIL_ERROR;
//STRIP001 /*?*/ 				if ( nId == SID_MAIL_SENDDOCASPDF )
//STRIP001 /*?*/ 					eResult = aModel.Send( SfxMailModel_Impl::TYPE_ASPDF );
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 					eResult = aModel.Send( SfxMailModel_Impl::TYPE_SELF );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( eResult == SfxMailModel_Impl::SEND_MAIL_ERROR )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					InfoBox aBox( SFX_APP()->GetTopWindow(), SfxResId( MSG_ERROR_SEND_MAIL ));
//STRIP001 /*?*/ 					aBox.Execute();
//STRIP001 /*?*/                     rReq.Ignore();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                     rReq.Done();
/*?*/ 			}
/*?*/ 
/*?*/ 			break;
/*?*/ 
/*?*/ 		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*?*/ 
/*?*/ 		case SID_PLUGINS_ACTIVE:
/*?*/ 		{
/*?*/ 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nId, FALSE);
/*?*/ 			BOOL bActive = pShowItem ? pShowItem->GetValue() : !pImp->bPlugInsActive;
/*?*/ 			// ggf. recorden
/*?*/ 			if ( !rReq.IsAPI() )
/*?*/ 				rReq.AppendItem( SfxBoolItem( nId, bActive ) );
/*?*/ 
/*?*/ 			// Jetzt schon DONE aufrufen, da die Argumente evtl. einen Pool
/*?*/ 			// benutzen, der demn"achst weg ist
/*?*/ 			rReq.Done(TRUE);
/*?*/ 
/*?*/ 			// ausfuehren
/*?*/ 			if ( !pShowItem || bActive != pImp->bPlugInsActive )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxFrame *pFrame = GetFrame()->GetTopFrame();
//STRIP001 /*?*/ 				if ( pFrame != GetFrame()->GetFrame() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// FramesetDocument
//STRIP001 /*?*/ 					SfxViewShell *pShell = pFrame->GetCurrentViewFrame()->GetViewShell();
//STRIP001 /*?*/ 					if ( pShell->GetInterface()->GetSlot( nId ) )
//STRIP001 /*?*/ 						pShell->ExecuteSlot( rReq );
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SfxFrameIterator aIter( *pFrame );
//STRIP001 /*?*/ 				while ( pFrame )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if ( pFrame->GetCurrentViewFrame() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxViewShell *pView = pFrame->GetCurrentViewFrame()->GetViewShell();
//STRIP001 /*?*/ 						if ( pView )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pView->pImp->bPlugInsActive = bActive;
//STRIP001 /*?*/ 							SfxInPlaceObject *pObj =
//STRIP001 /*?*/ 								pFrame->GetCurrentDocument()->GetInPlaceObject();
//STRIP001 /*?*/ 							if ( pObj )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								Rectangle aVisArea = pObj->GetVisArea();
//STRIP001 /*?*/ 								VisAreaChanged(aVisArea);
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( !pFrame->GetParentFrame() )
//STRIP001 /*?*/ 						pFrame = aIter.FirstFrame();
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						pFrame = aIter.NextFrame( *pFrame );
//STRIP001 /*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::GetState_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	for ( USHORT nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/ 	{
/*N*/ 		switch ( nSID )
/*N*/ 		{
/*N*/ 			case SID_STYLE_CATALOG:
/*N*/ 			{
/*N*/                 if ( !GetViewFrame()->KnowsChildWindow( SID_STYLE_DESIGNER ) )
/*?*/ 					rSet.DisableItem( nSID );
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// Printer-Funktionen
/*N*/ 			case SID_PRINTDOC:
/*N*/ 			case SID_PRINTDOCDIRECT:
/*N*/ 			case SID_SETUPPRINTER:
/*N*/ 			{
/*N*/ 				BOOL bEnabled = pImp->bCanPrint && !pImp->nPrinterLocks;
/*N*/ 				if ( bEnabled )
/*N*/ 				{
/*N*/ 					SfxPrinter *pPrinter = GetPrinter(FALSE);
/*N*/ 					bEnabled = !pPrinter || !pPrinter->IsPrinting();
/*N*/ 				}
/*N*/ 				if ( !bEnabled )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( SID_PRINTDOC );
/*?*/ 					rSet.DisableItem( SID_PRINTDOCDIRECT );
/*?*/ 					rSet.DisableItem( SID_SETUPPRINTER );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// Mail-Funktionen
/*N*/ 			case SID_MAIL_SENDDOCASPDF:
/*N*/ 			case SID_MAIL_SENDDOC:
/*N*/ 			{
/*?*/                 BOOL bEnable = !GetViewFrame()->HasChildWindow( SID_MAIL_CHILDWIN );
/*?*/ 				if ( !bEnable )
/*?*/ 					rSet.DisableItem( nSID );
/*?*/ 				else if ( nSID == SID_MAIL_SENDDOCASPDF )
/*?*/ 				{
/*?*/ 					SfxObjectShellRef xDocShell = GetViewFrame()->GetObjectShell();
/*?*/ 					if ( xDocShell.Is() )
/*?*/ 					{
/*?*/ 						// Get PDF Filter from container
/*?*/ 						SfxFactoryFilterContainer* pFilterContainer = xDocShell->GetFactory().GetFilterContainer();
/*?*/ 						if ( pFilterContainer )
/*?*/ 						{
/*?*/ 							String aPDFExtension = String::CreateFromAscii( ".pdf" );
/*?*/ 							const SfxFilter* pFilter = pFilterContainer->GetFilter4Extension( aPDFExtension, SFX_FILTER_EXPORT );
/*?*/ 							if ( pFilter != NULL )
/*?*/ 								break;
/*?*/ 						}
/*?*/ 					}
/*?*/ 
/*?*/ 					rSet.DisableItem( nSID );
/*?*/ 				}
/*?*/ 
/*?*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// PlugIns running
/*N*/ 			case SID_PLUGINS_ACTIVE:
/*N*/ 			{
/*?*/                 rSet.Put( SfxBoolItem( SID_PLUGINS_ACTIVE, !pImp->bPlugInsActive) );
/*?*/ 				break;
/*N*/ 			}
/*
			// SelectionText
			case SID_SELECTION_TEXT:
			{
				rSet.Put( SfxStringItem( SID_SELECTION_TEXT, GetSelectionText() ) );
				break;
			}

			// SelectionTextExt
			case SID_SELECTION_TEXT_EXT:
			{
				rSet.Put( SfxStringItem( SID_SELECTION_TEXT_EXT, GetSelectionText(TRUE) ) );
				break;
			}
*/
/*N*/ 			case SID_STYLE_FAMILY :
/*N*/ 			{
/*N*/ 				rSet.Put( SfxUInt16Item( SID_STYLE_FAMILY, pImp->nFamily ) );
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetZoomFactor( const Fraction &rZoomX,
/*N*/ 								  const Fraction &rZoomY )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_ASSERT( GetWindow(), "no window" );
//STRIP001 	MapMode aMap( GetWindow()->GetMapMode() );
//STRIP001 	aMap.SetScaleX( rZoomX );
//STRIP001 	aMap.SetScaleY( rZoomY );
//STRIP001 	GetWindow()->SetMapMode( aMap );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxInPlaceClient* SfxViewShell::CreateIPClient
//STRIP001 (
//STRIP001 	WorkWindow*     pTop,
//STRIP001 	WorkWindow*     pDoc,
//STRIP001 	Window*         pDraw
//STRIP001 )

/*  [Beschreibung]

	"Uber diese Factory-Methode erzeugt der SFx spezielle SfxShell-Instanzen,
	die als Stellvertreter f"ur InPlace-Objekte dienen. Solle  auf Callbacks
	dieser Stellvertreter reagiert werden, die dieses "uber eine eigene
	SfxInPlaceClient-Subklasse zu realisieren und diese Factory zu "uberladen.
*/

//STRIP001 {
//STRIP001 	HACK(kann raus)
//STRIP001 	return new SfxInPlaceClient( this, pDraw );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::UIActivate
//STRIP001 (
//STRIP001 	SvInPlaceObject*    pObj    // das Objekt, welched deaktiv wurde
//STRIP001 )

/*  [Beschreibung]

	Dieser Handler wird gerufen, wenn ein mit der Methode
	<SfxViewShell::DoVerb()> angesteuertes Objekt aktiviert
	wurde.

	Die Basisimplementation braucht nicht gerufen zu werden.


	[Querverweise]
	<SfxViewShell::UIDeactivate(SvInPlaceObject)>
*/

//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::UIDeactivate
//STRIP001 (
//STRIP001 	SvInPlaceObject*    pObj    // das Objekt, welched deaktiv wurde
//STRIP001 )

/*  [Beschreibung]

	Dieser Handler wird gerufen, wenn ein mit der Methode
	<SfxViewShell::DoVerb()> aktiviertes Objekt deaktiviert
	wurde. Dies kann von der Server-Applikation oder durch die Client-
	Applikation hervorgerufen worden sein.

	Die Basisimplementation braucht nicht gerufen zu werden.


	[Querverweise]
	<SfxViewShell::UIDeactivate(SvInPlaceObject)>
*/

//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 ErrCode	SfxViewShell::DoVerb
//STRIP001 (
//STRIP001 	SfxInPlaceClient*   pIPClient,  // zu aktivierender <SfxInPlaceClient>
//STRIP001 	long                nVerb       // auszuf"uhrendes Verb (default = 0)
//STRIP001 )

/*  [Beschreibung]

	[Beispiel]

	ErrCode SwView::DoVerb( SwSoNode *pSoNode, long nVerb )
	{
		SwIPClientRef xIPCli = (SwIPClient*)
				pViewSh->FindIPClient( pSoNode->GetObject() );
		if ( !xIPCli.Is() )
			xIPCli = new SwIPClient( pViewSh, pEditWin, .... );
		pSoNode->GetObject()->DoConnect( xIPCli );
		xIPCli->GetEnv()->SetObjArea( Rectangle( ... ) );
		...
		return DoVerb( xIPCli, nVerb );
	}
*/

//STRIP001 {
//STRIP001 	DBG_ASSERT( pIPClient->GetEmbedObj(), "DoVerb aber nicht connected?!" );
//STRIP001 
//STRIP001 	// falls neu, in Liste eintragen
//STRIP001 	// Passiert jetzt schon im Connect !
//STRIP001 //  if ( LIST_ENTRY_NOTFOUND == aIPClientList.GetPos( pIPClient ) )
//STRIP001 //      aIPClientList.Insert(pIPClient);
//STRIP001 
//STRIP001 	// und ab gehts (kein SetModified rufen, das mach das Obj schon selbst)
//STRIP001 	SfxErrorContext aEc( ERRCTX_SO_DOVERB, GetWindow(), RID_SO_ERRCTX );
//STRIP001     SvPersist* pPersist = GetObjectShell()->GetInPlaceObject();
//STRIP001     if ( !pPersist )
//STRIP001         pPersist = GetObjectShell();
//STRIP001     pPersist->StartActivation( pIPClient->GetEmbedObj() );
//STRIP001 	ErrCode nErr = pIPClient->GetEmbedObj()->DoVerb( nVerb );
//STRIP001 	if( nErr )
//STRIP001 		ErrorHandler::HandleError( nErr );
//STRIP001 	return nErr;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::FindIPClient
/*N*/ (
	SvEmbeddedObject*   pObj,           /*  <SfxInPlaceClient> f"ur dieses
											<SvEmbeddedObject> suchen */
	Window*             pObjParentWin   /*  SfxInPlaceClient, der in diesem
											Window dargestellt wird */
/*N*/ )   const

/*  [Beschreibung]

	Sucht nach einem exisitierenden SfxInPlaceClient f"ur das angegebene
	Objekt/Window-Paar.

	Wird keins gefunden, wird 0 zur"uckgegeben.


	[Querverweise]

	<SfxViewShell::DoVerb(SfxInPlaceClient*,long)>
*/

/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	if( !pObjParentWin )
/*N*/ 		pObjParentWin = GetWindow();
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		SfxInPlaceClient *pIPClient = (SfxInPlaceClient*) pClients->GetObject(n);
/*?*/ 		if ( pIPClient->GetEmbedObj() == pObj &&
/*?*/ 			 pIPClient->GetEnv()->GetEditWin() == pObjParentWin )
/*?*/ 			return pIPClient;
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::GetIPClient() const
/*N*/ {
/*N*/ 	return GetUIActiveClient();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::GetUIActiveClient() const
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	SvInPlaceClient *pIPClient=0;
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() )
/*?*/ 		{
/*?*/ 			if (aIPClient->GetProtocol().IsUIActive())
/*?*/ 			{
/*?*/ 				pIPClient = aIPClient;
/*?*/ 				break;
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return (SfxInPlaceClient*) pIPClient;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::Activate( BOOL bMDI )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	if ( bMDI )
/*N*/ 	{
/*N*/ 		SfxObjectShell *pSh = GetViewFrame()->GetObjectShell();
/*N*/ 		if ( pSh->GetModel().is() )
/*N*/ 			pSh->GetModel()->setCurrentController( GetViewFrame()->GetFrame()->GetController() );
/*N*/ 		if ( pSh && pSh->GetMedium() && pSh->GetMedium()->GetName().Len() )
/*N*/ 			so3::StaticBaseUrl::SetBaseURL( pSh->GetBaseURL() );
/*N*/ 		else
/*N*/ 		{
/*N*/             INetURLObject aObject( SvtPathOptions().GetWorkPath() );
/*N*/ 			aObject.setFinalSlash();
/*N*/ 			so3::StaticBaseUrl::SetBaseURL( aObject.GetMainURL( INetURLObject::NO_DECODE ) );
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxObjectShell::SetWorkingDocument( pSh );
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::Deactivate(BOOL bMDI)
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::AdjustPosSizePixel
//STRIP001 (
//STRIP001 	const Point&    rToolOffset,// linke obere Ecke der Tools im Frame-Window
//STRIP001 	const Size&     rSize       // gesamte zur Verf"ugung stehende Gr"o\se
//STRIP001 )

//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxViewShell, 0);
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::Move()

/*  [Beschreibung]

	Diese virtuelle Methode wird gerufen, wenn das Fenster, in dem die
	SfxViewShell dargestellt wird eine StarView-Move() Nachricht erh"alt.

	Die Basisimplementierung braucht nicht gerufen zu werden.


	[Anmerkung]

	Diese Methode kann dazu verwendet werden, eine Selektion abzubrechen,
	um durch das Moven des Fensters erzeugte Maus-Bewegungen anzufangen.

	Zur Zeit funktioniert die Benachrichtigung nicht In-Place.
*/

//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::OuterResizePixel
/*N*/ (
/*N*/ 	const Point&    rToolOffset,// linke obere Ecke der Tools im Frame-Window
/*N*/ 	const Size&     rSize       // gesamte zur Verf"ugung stehende Gr"o\se
/*N*/ )

/*  [Beschreibung]

	Diese Methode mu berladen werden, um auf "Anderungen der Gre
	der View zu reagieren. Dabei definieren wir die View als das Edit-Window
	zuz"uglich der um das Edit-Window angeordnenten Tools (z.B. Lineale).

	Das Edit-Window darf weder in Gr"o\se noch Position ver"andert werden.

	Die Vis-Area der SfxObjectShell, dessen Skalierung und Position
	d"urfen hier ver"andert werden. Der Hauptanwendungsfall ist dabei,
	das Ver"andern der Gr"o\se der Vis-Area.

	"Andert sich durch die neue Berechnung der Border, so mu\s dieser
	mit <SfxViewShell::SetBorderPixel(const SvBorder&)> gesetzt werden.
	Erst nach Aufruf von 'SetBorderPixel' ist das Positionieren von
	Tools erlaubt.


	[Beispiel]

	void AppViewSh::OuterViewResizePixel( const Point &rOfs, const Size &rSz )
	{
		// Tool-Positionen und Gr"o\sen von au\sen berechnen, NICHT setzen!
		// (wegen folgender Border-Berechnung)
		Point aHLinPos...; Size aHLinSz...;
		...

		// Border f"ur Tools passend zu rSize berechnen und setzen
		SvBorder aBorder...
		SetBorderPixel( aBorder ); // ab jetzt sind Positionierungen erlaubt

		// Tools anordnen
		pHLin->SetPosSizePixel( aHLinPos, aHLinSz );
		...
	}


	[Querverweise]

	<SfxViewShell::InnerResizePixel(const Point&,const Size& rSize)>
*/

/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	SetBorderPixel( SvBorder() );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::InnerResizePixel
//STRIP001 (
//STRIP001 	const Point&    rToolOffset,// linke obere Ecke der Tools im Frame-Window
//STRIP001 	const Size&     rSize       // dem Edit-Win zur Verf"ugung stehende Gr"o\se
//STRIP001 )

/*  [Beschreibung]

	Diese Methode mu berladen werden, um auf "Anderungen der Gre
	des Edit-Windows zu reagieren.

	Das Edit-Window darf weder in Gr"o\se noch Position ver"andert werden.
	Weder die Vis-Area der SfxObjectShell noch dessen Skalierung oder
	Position d"urfen ver"andert werden.

	"Andert sich durch die neue Berechnung der Border, so mu\s dieser
	mit <SfxViewShell::SetBorderPixel(const SvBorder&)> gesetzt werden.
	Erst nach Aufruf von 'SetBorderPixel' ist das Positionieren von
	Tools erlaubt.


	[Beispiel]

	void AppViewSh::InnerViewResizePixel( const Point &rOfs, const Size &rSz )
	{
		// Tool-Positionen und Gr"o\sen von innen berechnen, NICHT setzen!
		// (wegen folgender Border-Berechnung)
		Point aHLinPos...; Size aHLinSz...;
		...

		// Border f"ur Tools passend zu rSz berechnen und setzen
		SvBorder aBorder...
		SetBorderPixel( aBorder ); // ab jetzt sind Positionierungen erlaubt

		// Tools anordnen
		pHLin->SetPosSizePixel( aHLinPos, aHLinSz );
		...
	}


	[Querverweise]

	<SfxViewShell::OuterResizePixel(const Point&,const Size& rSize)>
*/

//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxViewShell, 0);
//STRIP001 	SetBorderPixel( SvBorder() );
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::InvalidateBorder()
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	DBG_ASSERT( GetViewFrame(), "SfxViewShell without SfxViewFrame" );
/*N*/ 
/*N*/ 	GetViewFrame()->InvalidateBorderImpl( this );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetBorderPixel( const SvBorder &rBorder )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	DBG_ASSERT( GetViewFrame(), "SfxViewShell without SfxViewFrame" );
/*N*/ 
/*N*/ 	GetViewFrame()->SetBorderPixelImpl( this, rBorder );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 const SvBorder& SfxViewShell::GetBorderPixel() const
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxViewShell, 0);
//STRIP001 	DBG_ASSERT( GetViewFrame(), "SfxViewShell without SfxViewFrame" );
//STRIP001 
//STRIP001 	return GetViewFrame()->GetBorderPixelImpl( this );
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetWindow
/*N*/ (
/*N*/ 	Window*     pViewPort   // Pointer auf das Datenfenster bzw. 0 im Destruktor
/*N*/ )

/*  [Beschreibung]

	Mit dieser Methode wird der SfxViewShell das Datenfenster mitgeteilt.
	Dieses wird f"ur den In-Place-Container und f"ur das korrekte
	Wiederherstellen des Focus ben"otigt.

	Selbst In-Place-aktiv ist das Umsetzen des ViewPort-Windows verboten.
*/

/*N*/ {
/*N*/ 	if( pWindow == pViewPort )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// ggf. vorhandene IP-Clients disconnecten
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( pClients )
/*N*/ 	{
/*N*/ 		SvInPlaceClientRef aIPClient;
/*N*/ 		USHORT nCount = (USHORT)pClients->Count();
/*N*/ 		for (USHORT n=0; n<nCount; n++)
/*N*/ 		{
/*?*/ 			// Da beim DisConnect der Client immer aus der Liste entfernt wird,
/*?*/ 			// immer das 0-te Element holen
/*?*/ 			aIPClient = pClients->GetObject(0);
/*?*/ 			if( aIPClient.Is() )
/*?*/ 			{
/*?*/ 				if (aIPClient->GetIPObj())
/*?*/ 				{
/*?*/ 					aIPClient->DoDisconnect();
/*?*/ 					aIPClient.Clear();
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// View-Port austauschen
/*N*/     BOOL bHadFocus = pWindow ? pWindow->HasChildPathFocus( TRUE ) : FALSE;
/*N*/ 	pWindow = pViewPort;
/*N*/ 
/*N*/     if( pWindow )
/*N*/     {
/*N*/         // Disable automatic GUI mirroring (right-to-left) for document windows
/*N*/         pWindow->EnableRTL( FALSE );
/*N*/     }
/*N*/ 
/*N*/     if ( bHadFocus && pWindow )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GrabFocus( pWindow );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 Size SfxViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxViewShell, 0);
//STRIP001 	DBG_ASSERT(pWindow, "Kein Fenster");
//STRIP001 /*
//STRIP001 	Rectangle aAppWinRect (	SfxApplicationWindow::Get()->GetClientAreaPixel() );
//STRIP001 	if ( aAppWinRect.IsEmpty() )
//STRIP001 		// Bei Hochfahren der Applikation ist die ClientArea noch
//STRIP001 		// nicht berechnet worden, wenn das erste Dokument erzeugt
//STRIP001 		// wird
//STRIP001 		aAppWinRect = Rectangle(Point(), Application::GetAppWindow()->GetOutputSizePixel());
//STRIP001 	else
//STRIP001 		aAppWinRect.Move( -aAppWinRect.Left(), -aAppWinRect.Top() );
//STRIP001 	Point aPoint( aAppWinRect.BottomRight() );
//STRIP001  */
//STRIP001 
//STRIP001     DBG_ERROR( "Useless call!" );
//STRIP001     return Size();
//STRIP001 }

//------------------------------------------------------------------------

/*N*/ SfxViewShell::SfxViewShell
/*N*/ (
	SfxViewFrame*   pViewFrame,     /*  <SfxViewFrame>, in dem diese View
										dargestellt wird */
	USHORT          nFlags          /*  siehe <SfxViewShell-Flags> */
/*N*/ )

/*N*/ :   SfxShell(this),
/*N*/     pImp( new SfxViewShell_Impl ),
/*N*/ #if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX
/*N*/ 	pIPClientList( 0 ),
/*N*/ #endif
/*N*/ 	pWindow(0),
/*N*/ 	pFrame(pViewFrame),
/*N*/ 	pSubShell(0),
/*N*/ 	bOptimizeEach(0 != (nFlags & SFX_VIEW_OPTIMIZE_EACH)),
/*N*/ 	bMaximizeFirst( 0 != (nFlags & SFX_VIEW_MAXIMIZE_FIRST) )
/*N*/ 	,bNoNewWindow( 0 != (nFlags & SFX_VIEW_NO_NEWWINDOW) )
/*N*/ {
/*N*/ 	DBG_CTOR(SfxViewShell, 0);
/*N*/ 
/*N*/     pImp->pController = 0;
/*N*/ 	pImp->bIsShowView =
/*N*/ 		!(SFX_VIEW_NO_SHOW == (nFlags & SFX_VIEW_NO_SHOW));
/*N*/ 	pImp->bUseObjectSize =
/*N*/ 		SFX_CREATE_MODE_EMBEDDED==pFrame->GetObjectShell()->GetCreateMode() &&
/*N*/ 		SFX_VIEW_OBJECTSIZE_EMBEDDED == (nFlags & SFX_VIEW_OBJECTSIZE_EMBEDDED);
/*N*/ 	pImp->bCanPrint = SFX_VIEW_CAN_PRINT == (nFlags & SFX_VIEW_CAN_PRINT);
/*N*/ 	pImp->bFrameSetImpl = nFlags & SFX_VIEW_IMPLEMENTED_AS_FRAMESET;
/*N*/ 	pImp->bHasPrintOptions =
/*N*/ 		SFX_VIEW_HAS_PRINTOPTIONS == (nFlags & SFX_VIEW_HAS_PRINTOPTIONS);
/*N*/ 	pImp->bPlugInsActive = TRUE;
/*N*/ 	pImp->bGotOwnerShip = FALSE;
/*N*/ 	if ( pFrame->GetParentViewFrame() )
/*?*/ 		pImp->bPlugInsActive = pFrame->GetParentViewFrame()->GetViewShell()->pImp->bPlugInsActive;
/*N*/ 	pImp->eScroll = SCROLLING_DEFAULT;
/*N*/ 	pImp->pSetDescr = NULL;
/*N*/ 	pImp->nPrinterLocks = 0;
/*N*/ 	pImp->pMenuBarResId = 0;
/*N*/ 	pImp->pAccelResId = 0;
/*N*/ 	pImp->pAccel = 0;
/*N*/ 	pImp->pMenu = 0;
/*N*/ 	pImp->bControllerSet = FALSE;
/*N*/     pImp->bOwnsMenu = TRUE;
/*N*/ 	pImp->nFamily = 0xFFFF;					// undefined, default set by TemplateDialog
/*N*/ 	SetMargin( pFrame->GetMargin_Impl() );
/*N*/ 
/*N*/ 	SetPool( &pViewFrame->GetObjectShell()->GetPool() );
/*N*/ 	StartListening(*SFX_APP());
/*N*/ 
/*N*/ 	// in Liste eintragen
/*N*/ 	const SfxViewShell *pThis = this; // wegen der kranken Array-Syntax
/*N*/ 	SfxViewShellArr_Impl &rViewArr = SFX_APP()->GetViewShells_Impl();
/*N*/ 	rViewArr.Insert(pThis, rViewArr.Count() );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxViewShell::~SfxViewShell()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxViewShell, 0);
/*N*/ 
/*N*/ 	// aus Liste austragen
/*N*/ 	const SfxViewShell *pThis = this;
/*N*/ 	SfxViewShellArr_Impl &rViewArr = SFX_APP()->GetViewShells_Impl();
/*N*/ 	rViewArr.Remove( rViewArr.GetPos(pThis) );
/*N*/ //	if ( GetViewFrame()->GetFrame()->GetFrameSet_Impl() == pImp->pSetDescr )
/*N*/ //		GetViewFrame()->GetFrame()->SetFrameSet_Impl( NULL );
/*N*/ //	delete pImp->pSetDescr;
/*N*/ 
/*N*/     if ( pImp->pMenu && pImp->bOwnsMenu )
/*N*/ 	{
/*N*/         SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetViewFrame()->GetTopViewFrame() );
/*N*/         SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
/*N*/         if ( pTop )
/*N*/         {
/*N*/             Menu* pMenu = pImp->pMenu->GetMenu()->GetSVMenu();
/*N*/             if ( pMenu == pTop->GetMenuBar_Impl() )
/*N*/                 pTop->SetMenuBar_Impl( 0 );
/*N*/         }
/*N*/ 
/*N*/         delete pImp->pMenu;
/*N*/ 	}
/*N*/ 
/*N*/     if ( pImp->pController )
/*N*/     {
/*N*/         pImp->pController->ReleaseShell_Impl();
/*N*/         pImp->pController->release();
/*N*/     }
/*N*/ 
/*N*/ 	delete pImp->pMenuBarResId;
/*N*/ 	delete pImp;
/*N*/ 
/*N*/ #if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX
/*N*/ 	delete pIPClientList;
/*N*/ #endif
/*N*/ }

//--------------------------------------------------------------------

/*N*/ USHORT SfxViewShell::PrepareClose
/*N*/ (
/*N*/ 	BOOL    bUI,     // TRUE: Dialoge etc. erlaubt, FALSE: silent-mode
/*N*/ 	BOOL bForBrowsing
/*N*/ )
/*N*/ {
/*N*/ 	SfxPrinter *pPrinter = GetPrinter();
/*N*/ 	if ( pPrinter && pPrinter->IsPrinting() )
/*N*/ 	{
/*?*/ 		if ( bUI )
/*?*/ 		{
/*?*/ 			InfoBox aInfoBox( &GetViewFrame()->GetWindow(), SfxResId( MSG_CANT_CLOSE ) );
/*?*/ 			aInfoBox.Execute();
/*?*/ 		}
/*?*/ 
/*?*/ 		return FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if( GetViewFrame()->IsInModalMode() )
/*N*/ 		return FALSE;
/*N*/ 
/*N*/ 	return TRUE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxViewShell* SfxViewShell::Current()
/*N*/ {
/*N*/     SfxViewFrame *pCurrent = SfxViewFrame::Current();
/*N*/     return pCurrent ? pCurrent->GetViewShell() : NULL;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SdrView* SfxViewShell::GetDrawView() const

/*	[Beschreibung]

	Diese virtuelle Methode mu\s von den Subklassen "uberladen werden, wenn
	der Property-Editor zur Verf"ugung stehen soll.

	Die Default-Implementierung liefert immer 0.
*/

//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 String SfxViewShell::GetSelectionText
//STRIP001 (
//STRIP001 	BOOL bCompleteWords		/* 	FALSE (default)
//STRIP001 								Nur der tats"achlich selektierte Text wird
//STRIP001 								zur"uckgegeben.
//STRIP001 
//STRIP001 								TRUE
//STRIP001 								Der selektierte Text wird soweit erweitert,
//STRIP001 								da\s nur ganze W"orter zur"uckgegeben werden.
//STRIP001 								Als Worttrenner gelten White-Spaces und die
//STRIP001 								Satzzeichen ?,;?sowie einfache und doppelte
//STRIP001 								Anf"uhrungszeichen.
//STRIP001 							*/
//STRIP001 )

/*  [Beschreibung]

	Diese Methode kann von Anwendungsprogrammierer "uberladen werden,
	um einen Text zur"uckzuliefern, der in der aktuellen Selektion
	steht. Dieser wird z.B. beim Versenden (email) verwendet.

	Mit bCompleteWords == TRUE ger"ufen, reicht z.B. auch der Cursor,
	der in einer URL steht, um die gesamte URL zu liefern.
*/

//STRIP001 {
//STRIP001 	return String();
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 BOOL SfxViewShell::HasSelection( BOOL ) const

/*  [Beschreibung]

	Mit dieser virtuellen Methode kann z.B. ein Dialog abfragen, ob in der
	aktuellen View etwas selektiert ist. Wenn der Parameter <BOOL> TRUE ist,
	wird abgefragt, ob Text selektiert ist.
*/

//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::SetSubShell( SfxShell *pShell )

/*  [Beschreibung]

	Mit dieser Methode kann eine Selektions- oder Cursor-Shell angemeldet
	werden, die automatisch unmittelbar nach der SfxViewShell auf den
	SfxDispatcher gepusht wird, und automatisch umittelbar vor ihr
	gepoppt wird.

	Ist die SfxViewShell-Instanz bereits gepusht, dann wird pShell
	sofort ebenfalls gepusht. Wird mit SetSubShell eine andere SfxShell
	Instanz angemeldet, als vorher angemeldet war, wird die zuvor angemeldete
	ggf. automatisch gepoppt. Mit pShell==0 kann daher die aktuelle
	Sub-Shell abgemeldet werden.
*/

//STRIP001 {
//STRIP001 	// ist diese ViewShell "uberhaupt aktiv?
//STRIP001 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
//STRIP001 	if ( pDisp->IsActive(*this) )
//STRIP001 	{
//STRIP001 		// Dispatcher updaten
//STRIP001 		if ( pSubShell )
//STRIP001 			pDisp->Pop(*pSubShell);
//STRIP001 		if ( pShell )
//STRIP001 			pDisp->Push(*pShell);
//STRIP001 		pDisp->Flush();
//STRIP001 	}
//STRIP001 
//STRIP001 	pSubShell = pShell;
//STRIP001 }

/*N*/ void SfxViewShell::AddSubShell( SfxShell& rShell )
/*N*/ {
/*N*/ 	pImp->aArr.Insert( &rShell, pImp->aArr.Count() );
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( pDisp->IsActive(*this) )
/*N*/ 	{
/*?*/ 		pDisp->Push(rShell);
/*?*/ 		pDisp->Flush();
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewShell::RemoveSubShell( SfxShell* pShell )
/*N*/ {
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( !pShell )
/*N*/ 	{
/*N*/ 		USHORT nCount = pImp->aArr.Count();
/*N*/ 		if ( pDisp->IsActive(*this) )
/*N*/ 		{
/*?*/ 			for ( USHORT n=nCount; n>0; n-- )
/*?*/ 				pDisp->Pop( *pImp->aArr[n-1] );
/*?*/ 			pDisp->Flush();
/*N*/ 		}
/*N*/ 
/*N*/ 		pImp->aArr.Remove(0, nCount);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		USHORT nPos = pImp->aArr.GetPos( pShell );
/*?*/ 		if ( nPos != 0xFFFF )
/*?*/ 		{
/*?*/ 			pImp->aArr.Remove( nPos );
/*?*/ 			if ( pDisp->IsActive(*this) )
/*?*/ 			{
/*?*/ 				pDisp->RemoveShell_Impl( *pShell );
/*?*/ 				pDisp->Flush();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

//STRIP001 SfxShell* SfxViewShell::GetSubShell( USHORT nNo )
//STRIP001 {
//STRIP001 	USHORT nCount = pImp->aArr.Count();
//STRIP001 	if ( nNo<nCount )
//STRIP001 		return pImp->aArr[nCount-nNo-1];
//STRIP001 	return NULL;
//STRIP001 }

/*N*/ void SfxViewShell::PushSubShells_Impl( BOOL bPush )
/*N*/ {
/*N*/ 	USHORT nCount = pImp->aArr.Count();
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( bPush )
/*N*/ 	{
/*N*/ 		for ( USHORT n=0; n<nCount; n++ )
/*N*/ 			pDisp->Push( *pImp->aArr[n] );
/*N*/ 
/*N*/ //		HACK(evtl. PushSubShells fuer SW virtuell machen oder im SW umbauen)
/*N*/ //		Notify( *this, SfxSimpleHint( SFX_HINT_RESERVED4 ) );
/*N*/ 	}
/*N*/ 	else if ( nCount )
/*N*/ 	{
/*N*/ 		pDisp->Pop( *pImp->aArr[0], SFX_SHELL_POP_UNTIL );
/*N*/ 
/*N*/ //		HACK(evtl. PushSubShells fuer SW virtuell machen oder im SW umbauen)
/*N*/ //		Notify( *this, SfxSimpleHint( SFX_HINT_RESERVED3 ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	pDisp->Flush();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::WriteUserData( String &, BOOL bBrowse )
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::ReadUserData(const String &, BOOL bBrowse )
//STRIP001 {
//STRIP001 }

//STRIP001 void SfxViewShell::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 }
/*N*/ void SfxViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse )
/*N*/ {
/*N*/ }


//--------------------------------------------------------------------
// returns the first shell of spec. type viewing the specified doc.

/*N*/ SfxViewShell* SfxViewShell::GetFirst
/*N*/ (
/*N*/ 	const TypeId*	pType,
/*N*/ 	BOOL			bOnlyVisible
/*N*/ )
/*N*/ {
/*N*/ 	SfxViewShellArr_Impl &rShells = SFX_APP()->GetViewShells_Impl();
/*N*/ 
/*N*/ 	// search for a SfxViewShell of the specified type
/*N*/ 	for ( USHORT nPos = 0; nPos < rShells.Count(); ++nPos )
/*N*/ 	{
/*N*/ 		SfxViewShell *pShell = rShells.GetObject(nPos);
/*N*/ 		if ( !pType || pShell->IsA(*pType) )
/*N*/ 			return pShell;
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------
// returns the next shell of spec. type viewing the specified doc.

/*N*/ SfxViewShell* SfxViewShell::GetNext
/*N*/ (
/*N*/ 	const SfxViewShell&	rPrev,
/*N*/ 	const TypeId*		pType,
/*N*/ 	BOOL				bOnlyVisible
/*N*/ )
/*N*/ {
/*N*/ 	SfxViewShellArr_Impl &rShells = SFX_APP()->GetViewShells_Impl();
/*N*/ 
/*N*/ 	// refind the specified predecessor
/*N*/ 	USHORT nPos;
/*N*/ 	for ( nPos = 0; nPos < rShells.Count(); ++nPos )
/*N*/ 		if ( rShells.GetObject(nPos) == &rPrev )
/*N*/ 			break;
/*N*/ 
/*N*/ 	// search for a Frame of the specified type
/*N*/ 	for ( ++nPos; nPos < rShells.Count(); ++nPos )
/*N*/ 	{
/*?*/ 		SfxViewShell *pShell = rShells.GetObject(nPos);
/*?*/ 		if ( !pType || pShell->IsA(*pType) )
/*?*/ 			return pShell;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SFX_NOTIFY( SfxBroadcaster& rBC,
/*N*/ 							const TypeId& rBCType,
/*N*/ 							const SfxHint& rHint,
/*N*/ 							const TypeId& rHintType )
/*N*/ {
/*N*/ //! (pb) do we need here new implementation?
///*N*/ #ifndef NOOLDSV
///*N*/ 	if ( rHint.ISA(SfxSysChangeHint) && SETTINGS_CHANGE_PRINTER ==
///*N*/ 		 ( (const SfxSysChangeHint &)rHint ).GetChangeType() )
///*N*/ 	{
///*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxPrinter *pPrinter = GetPrinter();
//STRIP001 /*?*/ 		if ( pPrinter && pPrinter->IsDefPrinter() )
//STRIP001 /*?*/ 			SetPrinter_Impl( new SfxPrinter(pPrinter->GetOptions().Clone()) );
///*N*/ 	}
///*N*/ #endif
/*N*/ 
/*N*/     if ( rHint.IsA(TYPE(SfxEventHint)) )
/*N*/     {
/*N*/         switch ( ((SfxEventHint&)rHint).GetEventId() )
/*N*/         {
/*N*/             case SFX_EVENT_LOADFINISHED:
/*N*/             {
/*?*/                 if ( GetController().is() )
/*?*/                 {
/*?*/                     SfxItemSet* pSet = GetObjectShell()->GetMedium()->GetItemSet();
/*?*/                     SFX_ITEMSET_ARG( pSet, pItem, SfxUsrAnyItem, SID_VIEW_DATA, sal_False );
/*?*/                     if ( pItem )
/*?*/                         pImp->pController->restoreViewData( pItem->GetValue() );
/*?*/                     pSet->ClearItem( SID_VIEW_DATA );
/*?*/                 }
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 FASTBOOL SfxViewShell::KeyInput( const KeyEvent &rKeyEvent )

/*  [Beschreibung]

	Diese Methode f"uhrt das KeyEvent 'rKeyEvent' "uber die an dieser
	SfxViewShell direkt oder indirekt (z.B. via Applikation) konfigurierten
	Tasten (Accelerator) aus.


	[R"uckgabewert]

	FASTBOOL                TRUE
							die Taste ist konfiguriert, der betreffende
							Handler wurde gerufen

							FALSE
							die Taste ist nicht konfiguriert, es konnte
							also kein Handler gerufen werden


	[Querverweise]
	<SfxApplication::KeyInput(const KeyEvent&)>
*/
//STRIP001 {
//STRIP001 	SfxAcceleratorManager* pAccMgr = GetAccMgr_Impl();
//STRIP001 	BOOL bRet = ( pAccMgr && pAccMgr->Call( rKeyEvent, GetViewFrame()->GetBindings(), FALSE ) );
//STRIP001 	if ( bRet )
//STRIP001 		return bRet;
//STRIP001 	else
//STRIP001 		bRet = SFX_APP()->GetAppAccel_Impl()->Call( rKeyEvent, GetViewFrame()->GetBindings(), FALSE );
//STRIP001 	if ( !bRet && rKeyEvent.GetKeyCode().GetCode() == KEY_ESCAPE )
//STRIP001 	{
//STRIP001         SfxTopViewFrame *pTop = PTR_CAST( SfxTopViewFrame, GetViewFrame()->GetTopViewFrame() );
//STRIP001         if ( pTop )
//STRIP001         {
//STRIP001             WorkWindow* pWork = (WorkWindow*) pTop->GetTopFrame_Impl()->GetTopWindow_Impl();
//STRIP001             if ( pWork && pWork->IsFullScreenMode() )
//STRIP001 			{
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute( SID_WIN_FULLSCREEN, SFX_CALLMODE_SLOT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 FASTBOOL SfxViewShell::GlobalKeyInput_Impl( const KeyEvent &rKeyEvent )
//STRIP001 {
//STRIP001 	SfxAcceleratorManager* pAccMgr = GetAccMgr_Impl();
//STRIP001     BOOL bRet = ( pAccMgr && pAccMgr->Call( rKeyEvent, GetViewFrame()->GetBindings(), TRUE ) );
//STRIP001     if ( !bRet )
//STRIP001         bRet = SFX_APP()->GetAppAccel_Impl()->Call( rKeyEvent, GetViewFrame()->GetBindings(), TRUE );
//STRIP001     return bRet;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::ShowCursor( FASTBOOL bOn )

/*  [Beschreibung]

	Diese Methode mu\s von Subklassen "uberladen werden, damit vom SFx
	aus der Cursor ein- und ausgeschaltet werden kann. Dies geschieht
	z.B. bei laufendem <SfxProgress>.
*/

/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::GotFocus() const

/*  [Beschreibung]

	Diese Methode mu\s vom Applikationsentwickler gerufen werden, wenn
	das Edit-Window den Focus erhalten hat. Der SFx hat so z.B. die
	M"oglichkeit, den Accelerator einzuschalten.


	[Anmerkung]

	<StarView> liefert leider keine M"oglichkeit, solche Events
	'von der Seite' einzuh"angen.
*/

/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 ErrCode SfxViewShell::DoVerb(long nVerb)

/*  [Beschreibung]

	Virtuelle Methode, um am selektierten Objekt ein Verb auszuf"uhren.
	Da dieses Objekt nur den abgeleiteten Klassen bekannt ist, mu DoVerb
	dort "uberlschrieben werden.

*/

//STRIP001 {
//STRIP001 	return ERRCODE_SO_NOVERBS;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DisconnectClients_Impl(SvInPlaceClient *pIP)

/*  [Beschreibung]

	Diese Methode dient dazu, bei UI-Aktivierung eins IPClients alle anderen
	noch bestehenden Verbindungen zu trennen.

*/

/*N*/ {
/*N*/ 
/*N*/ 	// SO2 stellt sicher, da\s nur ein Object gleichzeitig UI-aktiv ist.
/*N*/ 	// Aus Speicherplatzgr"unden werden aber alle Objekte, die nicht aktiv
/*N*/ 	// sind oder sein m"ussen, disconnected.
/*N*/ 
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/     for ( USHORT n=0; n < pClients->Count(); n++ )
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() && aIPClient != pIP && aIPClient->GetIPObj() &&
/*?*/ 				!(aIPClient->GetIPObj()->GetMiscStatus() & SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE) )
/*?*/             aIPClient->GetProtocol().Reset2Connect();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DisconnectAllClients()
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for ( USHORT n=0; n<pClients->Count(); )
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() && aIPClient->GetIPObj() )
/*?*/ 			aIPClient->DoDisconnect();
/*?*/ 		else
/*?*/ 			n++;
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::UseObjectSize() const
/*N*/ {
/*N*/ 	return pImp->bUseObjectSize;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::QueryObjAreaPixel( Rectangle& ) const
//STRIP001 {
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::AdjustVisArea(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	DBG_ASSERT (pFrame, "Kein Frame?");
//STRIP001 
//STRIP001 	SfxInPlaceObject *pObj = pFrame->GetObjectShell()->GetInPlaceObject();
//STRIP001 	if ( !pObj )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( UseObjectSize() )
//STRIP001 	{
//STRIP001 		Point aPos = rRect.TopLeft();
//STRIP001 		Size aSize = pObj->GetVisArea().GetSize();
//STRIP001 		pObj->SetVisArea( Rectangle(aPos, aSize) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pObj->SetVisArea( rRect );
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::VisAreaChanged(const Rectangle& rVisArea)
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		// Die Liste enth"alt alle connected clients
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 aIPClient = pClients->GetObject(n);
//STRIP001 /*?*/ 		if( aIPClient.Is() )
//STRIP001 /*?*/ 			CheckIPClient_Impl( aIPClient, rVisArea );
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::CheckIPClient_Impl( SvInPlaceClient *pIPClient,
//STRIP001 									   const Rectangle& rVisArea )
//STRIP001 {
//STRIP001 	if ( GetObjectShell()->IsInClose() )
//STRIP001 		return;
//STRIP001 
//STRIP001     BOOL bApplets = SvtJavaOptions().IsExecuteApplets();
//STRIP001 	BOOL bActive = pIPClient->IsInPlaceActive();
//STRIP001     BOOL bPlugIn = Application::IsRemoteServer() ? FALSE : SvtMiscOptions().IsPluginsEnabled();
//STRIP001 
//STRIP001 	SvAppletObjectRef aAppRef = pIPClient->GetIPObj();
//STRIP001 	SvPlugInObjectRef aPlugRef = pIPClient->GetIPObj();
//STRIP001     SfxFrameObjectRef aFrameRef = pIPClient->GetIPObj();
//STRIP001 
//STRIP001     if ( !pImp->bPlugInsActive && ( aPlugRef.Is() || aAppRef.Is() || aFrameRef.Is() ) )
//STRIP001 	{
//STRIP001 		if ( bActive )
//STRIP001 			pIPClient->GetProtocol().Reset2Open();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bAlwaysActive = ( pIPClient->GetIPObj()->GetMiscStatus() == SVOBJ_MISCSTATUS_ALWAYSACTIVATE );
//STRIP001 
//STRIP001 	if ( bAlwaysActive || rVisArea.IsOver( pIPClient->GetClientData()->GetObjArea()) )
//STRIP001 	{
//STRIP001 		// Der Client ist connected und sichtbar.
//STRIP001 		if ( bActive )
//STRIP001 		{
//STRIP001 			// Wenn er aktiv ist, mu\s er benachrichtigt werden.
//STRIP001 			pIPClient->GetEnv()->OutDevScaleChanged();
//STRIP001 
//STRIP001 			if ( aPlugRef.Is() )
//STRIP001 			{
//STRIP001 				// Plugins sind nur sichtbar, wenn das entsprechende
//STRIP001 				// flag auch angeschaltet ist
//STRIP001 				if ( !bPlugIn )
//STRIP001 				{
//STRIP001 					pIPClient->GetProtocol().Reset2Open();
//STRIP001 				}
//STRIP001 				else if ( aPlugRef->GetPlugInMode() == PLUGIN_FULL )
//STRIP001 				{
//STRIP001 					SetBorderPixel(SvBorder());
//STRIP001 					Window *pWin = GetWindow();
//STRIP001 					Size aSize = pWin->GetOutputSizePixel();
//STRIP001 					aSize = pWin->PixelToLogic(aSize);
//STRIP001 					Rectangle aRect = Rectangle ( pWin->PixelToLogic(Point()), aSize);
//STRIP001 					pIPClient->GetClientData()->SetObjArea(aRect);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if ( aAppRef.Is() && !bApplets )
//STRIP001 			{
//STRIP001 				// Java-Applets sind nicht aktiv, wenn Java in den
//STRIP001 				// Options ausgeschaltet wurde
//STRIP001 				pIPClient->GetProtocol().Reset2Open();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Ist er es nicht, aber da\s Object soll aktiv sein,
//STRIP001 			// wenn es sichtbar ist, mu\s das Object aktiviert werden;
//STRIP001 			// bei Plugins und Applets sind noch die Flags auszuwerten
//STRIP001 			if ( pIPClient->GetIPObj()->GetMiscStatus() &
//STRIP001 						SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE )
//STRIP001 			{
//STRIP001 				BOOL bActivate = TRUE;
//STRIP001 				if ( aPlugRef.Is() )
//STRIP001 					bActivate = bPlugIn;
//STRIP001 				else if ( aAppRef.Is() )
//STRIP001 					bActivate = bApplets;
//STRIP001 				if ( bActivate )
//STRIP001 					pIPClient->GetIPObj()->DoVerb(0);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( bActive )
//STRIP001 	{
//STRIP001 		// Wenn er aktiv ist, mu\s er benachrichtigt werden.
//STRIP001 		pIPClient->GetEnv()->OutDevScaleChanged();
//STRIP001 
//STRIP001 		// Ein nicht sichtbarer client soll disconnected werden, wenn
//STRIP001 		// er (nur) aktiv ist, wenn er sichtbar ist.
//STRIP001 		// Wenn er dann wieder sichtbar wird, mu\s die Applikation
//STRIP001 		// ihn connecten, damit er in der client list erscheint!
//STRIP001 
//STRIP001 		// Auf Wunsch von MB erst mal entfernt !!
//STRIP001 //				if ( pIPClient->GetIPObj()->GetMiscStatus() &
//STRIP001 //					SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE )
//STRIP001 //                pIPClient->DoDisconnect();
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 BOOL SfxViewShell::PlugInsActive() const
//STRIP001 {
//STRIP001 	return pImp->bPlugInsActive;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DiscardClients_Impl()

/*  [Beschreibung]

	Diese Methode dient dazu, vor dem Schlie\sen eines Dokuments das
	Speichern der Objekte zu verhindern, wenn der Benutzer Schlie\en ohne
	Speichern gew"ahlt hatte.
*/

/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() )
/*?*/ 		{
/*?*/ 			if (aIPClient->GetIPObj())
/*?*/ 			{
/*?*/ 				aIPClient->GetIPObj()->SetAutoSave(FALSE);
/*?*/ 				aIPClient->DoDisconnect();
/*?*/ 				aIPClient.Clear();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxScrollingMode SfxViewShell::GetScrollingMode() const
/*N*/ {
/*N*/ 	return pImp->eScroll;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::SetScrollingMode( SfxScrollingMode eMode )
//STRIP001 {
//STRIP001 	pImp->eScroll = eMode;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 SfxFrameSetDescriptor* SfxViewShell::GetFrameSet_Impl() const
//STRIP001 {
//STRIP001 	return pImp->pSetDescr;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxViewShell::SetFrameSet_Impl( SfxFrameSetDescriptor* pD )
//STRIP001 {
//STRIP001 //	delete pImp->pSetDescr;
//STRIP001 	pImp->pSetDescr = pD;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxObjectShell* SfxViewShell::GetObjectShell()
/*N*/ {
/*N*/ 	return GetViewFrame()->GetObjectShell();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ const Size& SfxViewShell::GetMargin() const
/*N*/ {
/*N*/ 	return pImp->aMargin;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetMargin( const Size& rSize )
/*N*/ {
/*N*/ 	// Der default-Margin wurde "geeicht" mit www.apple.com !!
/*N*/ 	Size aMargin = rSize;
/*N*/ 	if ( aMargin.Width() == -1 )
/*N*/ 		aMargin.Width() = DEFAULT_MARGIN_WIDTH;
/*N*/ 	if ( aMargin.Height() == -1 )
/*N*/ 		aMargin.Height() = DEFAULT_MARGIN_HEIGHT;
/*N*/ 
/*N*/ 	if ( aMargin != pImp->aMargin )
/*N*/ 	{
/*N*/ 		pImp->aMargin = aMargin;
/*N*/ 		MarginChanged();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::MarginChanged()
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::IsShowView_Impl() const
/*N*/ {
/*N*/ 	return pImp->bIsShowView;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxFrame* SfxViewShell::GetSmartSelf( SfxFrame* pSelf, SfxMedium& rMedium )
//STRIP001 {
//STRIP001 	return pSelf;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::IsImplementedAsFrameset_Impl( ) const
/*N*/ {
/*N*/ 	return pImp->bFrameSetImpl;
/*N*/ }

//------------------------------------------------------------------------

//STRIP001 void SfxViewShell::JumpToMark( const String& rMark )
//STRIP001 {
//STRIP001 	SfxStringItem aMarkItem( SID_JUMPTOMARK, rMark );
//STRIP001 	GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 			SID_JUMPTOMARK,
//STRIP001 			SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD,
//STRIP001 			&aMarkItem, 0L );
//STRIP001 }

//------------------------------------------------------------------------

#if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX

//STRIP001 void SfxViewShell::NewIPClient_Impl( SfxInPlaceClient *pIPClient )
//STRIP001 {
//STRIP001 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(TRUE);
//STRIP001 	pClients->Insert(pIPClient);
//STRIP001 }

//STRIP001 void SfxViewShell::IPClientGone_Impl( SfxInPlaceClient *pIPClient )
//STRIP001 {
//STRIP001 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(TRUE);
//STRIP001 	pClients->Remove(pIPClient);
//STRIP001 }

//STRIP001 SvInPlaceClientMemberList* SfxViewShell::GetIPClientList_Impl( BOOL bCreate ) const
//STRIP001 {
//STRIP001 	if ( !pIPClientList && bCreate )
//STRIP001 		( (SfxViewShell*) this )->pIPClientList = new SvInPlaceClientMemberList;
//STRIP001 	return pIPClientList;
//STRIP001 }

#endif

//STRIP001 void SfxViewShell::ReleaseMenuBar_Impl()
//STRIP001 {
//STRIP001     pImp->bOwnsMenu = FALSE;
//STRIP001 }

/*N*/ SfxMenuBarManager* SfxViewShell::GetMenuBar_Impl( BOOL bPlugin )
/*N*/ {
/*N*/ 	// get the accelerators
/*N*/ 	GetAccMgr_Impl();
/*N*/ 	if ( !pImp->pMenu )
/*N*/         pImp->pMenu = GetObjectShell()->CreateMenuBarManager_Impl( GetViewFrame() );
/*N*/ 	return pImp->pMenu;
/*N*/ }

/*N*/ SfxAcceleratorManager* SfxViewShell::GetAccMgr_Impl()
/*N*/ {
/*N*/ 	// all views of a document share the accelerators
/*N*/ #if SUPD>633
/*N*/     return GetObjectShell()->GetAccMgr_Impl();
/*N*/ #else
/*N*/     return GetObjectShell()->GetFactory().GetAccMgr_Impl();
/*N*/ #endif
/*N*/ }

/*
void SfxViewShell::SetMenuBar_Impl( const ResId& rId )
{
	if ( !pImp->pMenuBarResId ||
		rId.GetId() != pImp->pMenuBarResId->GetId() ||
		rId.GetResMgr() != pImp->pMenuBarResId->GetResMgr() )
	{
		DELETEZ( pImp->pMenuBarResId );

        if ( pImp->pMenu )
		{
            if ( pImp->bOwnsMenu )
            {
                SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetViewFrame()->GetTopViewFrame() );
                SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
                if ( pTop )
                {
                    Menu* pMenu = pImp->pMenu->GetMenu()->GetSVMenu();
                    if ( pMenu == pTop->GetMenuBar_Impl() )
                        pTop->SetMenuBar_Impl( 0 );
                }

                DELETEZ( pImp->pMenu );
            }
            else
                pImp->pMenu = NULL;
		}

		if ( rId.GetId() )
			pImp->pMenuBarResId = new ResId(rId);
	}
}
*/

/*N*/ void SfxViewShell::SetController( SfxBaseController* pController )
/*N*/ {
/*N*/     pImp->pController = pController;
/*N*/     pImp->pController->acquire();
/*N*/     pImp->bControllerSet = TRUE;
/*N*/ }

/*N*/ Reference < XController > SfxViewShell::GetController()
/*N*/ {
/*N*/     if ( !pImp->pController )
/*N*/         new SfxBaseController( this );
/*N*/     return pImp->pController;
/*N*/ }

//STRIP001 void SfxViewShell::AddContextMenuInterceptor_Impl( const REFERENCE< XCONTEXTMENUINTERCEPTOR >& xInterceptor )
//STRIP001 {
//STRIP001     pImp->aInterceptorContainer.addInterface( xInterceptor );
//STRIP001 }

//STRIP001 void SfxViewShell::RemoveContextMenuInterceptor_Impl( const REFERENCE< XCONTEXTMENUINTERCEPTOR >& xInterceptor )
//STRIP001 {
//STRIP001     pImp->aInterceptorContainer.removeInterface( xInterceptor );
//STRIP001 }

//STRIP001 ::cppu::OInterfaceContainerHelper& SfxViewShell::GetContextMenuInterceptors() const
//STRIP001 {
//STRIP001     return pImp->aInterceptorContainer;
//STRIP001 }

/*?*/ void Change( Menu* pMenu, SfxViewShell* pView )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
//STRIP001 	SfxDispatcher *pDisp = pView->GetViewFrame()->GetDispatcher();
//STRIP001 	USHORT nCount = pMenu->GetItemCount();
//STRIP001 	for ( USHORT nPos=0; nPos<nCount; ++nPos )
//STRIP001 	{
//STRIP001 		USHORT nId = pMenu->GetItemId(nPos);
//STRIP001 		String aCmd = pMenu->GetItemCommand(nId);
//STRIP001 		PopupMenu* pPopup = pMenu->GetPopupMenu(nId);
//STRIP001 		if ( nId < 5000 )
//STRIP001 		{
//STRIP001 			if ( aCmd.CompareToAscii(".uno:", 5) == 0 )
//STRIP001 			{
//STRIP001 		        SfxShell *pShell=0;
//STRIP001 		        USHORT nIdx;
//STRIP001 		        for (nIdx=0; (pShell=pDisp->GetShell(nIdx)); nIdx++)
//STRIP001 		        {
//STRIP001 		            const SfxInterface *pIFace = pShell->GetInterface();
//STRIP001 		            const SfxSlot* pSlot = pIFace->GetSlot( aCmd );
//STRIP001 		            if ( pSlot )
//STRIP001 		            {
//STRIP001 						pMenu->InsertItem( pSlot->GetSlotId(), pMenu->GetItemText( nId ), pMenu->GetItemBits( nId ), nPos );
//STRIP001 						pMenu->RemoveItem( nPos+1 );
//STRIP001 		                break;
//STRIP001 		            }
//STRIP001 		        }
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( pPopup )
//STRIP001 		{
//STRIP001 			Change( pPopup, pView );
//STRIP001 		}
//STRIP001 	}
/*?*/ }


//STRIP001 BOOL SfxViewShell::TryContextMenuInterception( Menu& rIn, Menu*& rpOut, ::com::sun::star::ui::ContextMenuExecuteEvent aEvent )
//STRIP001 {
//STRIP001     rpOut = NULL;
//STRIP001     BOOL bModified = FALSE;
//STRIP001 
//STRIP001     // create container from menu
//STRIP001     aEvent.ActionTriggerContainer = ::framework::ActionTriggerHelper::CreateActionTriggerContainerFromMenu( &rIn );
//STRIP001 
//STRIP001     // get selection from controller
//STRIP001     aEvent.Selection = ::com::sun::star::uno::Reference < ::com::sun::star::view::XSelectionSupplier > ( GetController(), ::com::sun::star::uno::UNO_QUERY );
//STRIP001 
//STRIP001     // call interceptors
//STRIP001     ::cppu::OInterfaceIteratorHelper aIt( pImp->aInterceptorContainer );
//STRIP001     while( aIt.hasMoreElements() )
//STRIP001     {
//STRIP001         try
//STRIP001         {
//STRIP001             ::com::sun::star::ui::ContextMenuInterceptorAction eAction =
//STRIP001                 ((::com::sun::star::ui::XContextMenuInterceptor*)aIt.next())->notifyContextMenuExecute( aEvent );
//STRIP001             switch ( eAction )
//STRIP001             {
//STRIP001                 case ::com::sun::star::ui::ContextMenuInterceptorAction_CANCELLED :
//STRIP001                     // interceptor does not want execution
//STRIP001                     return FALSE;
//STRIP001                     break;
//STRIP001                 case ::com::sun::star::ui::ContextMenuInterceptorAction_EXECUTE_MODIFIED :
//STRIP001                     // interceptor wants his modified menu to be executed
//STRIP001                     bModified = TRUE;
//STRIP001                     break;
//STRIP001                 case ::com::sun::star::ui::ContextMenuInterceptorAction_CONTINUE_MODIFIED :
//STRIP001                     // interceptor has modified menu, but allows for calling other interceptors
//STRIP001                     bModified = TRUE;
//STRIP001                     continue;
//STRIP001                     break;
//STRIP001                 case ::com::sun::star::ui::ContextMenuInterceptorAction_IGNORED :
//STRIP001                     // interceptor is indifferent
//STRIP001                     continue;
//STRIP001                     break;
//STRIP001                 default:
//STRIP001                     DBG_ERROR("Wrong return value of ContextMenuInterceptor!");
//STRIP001                     continue;
//STRIP001                     break;
//STRIP001             }
//STRIP001         }
//STRIP001         catch( ::com::sun::star::uno::RuntimeException& )
//STRIP001         {
//STRIP001             aIt.remove();
//STRIP001         }
//STRIP001 
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001     if ( bModified )
//STRIP001     {
//STRIP001         // container was modified, create a new window out of it
//STRIP001         rpOut = new PopupMenu;
//STRIP001         ::framework::ActionTriggerHelper::CreateMenuFromActionTriggerContainer( rpOut, aEvent.ActionTriggerContainer );
//STRIP001 
//STRIP001 		Change( rpOut, this );
//STRIP001 	}
//STRIP001 
//STRIP001     return TRUE;
//STRIP001 }

//STRIP001 void SfxViewShell::TakeOwnerShip_Impl()
//STRIP001 {
//STRIP001 	// currently there is only one reason to take OwnerShip: a hidden frame is printed
//STRIP001 	// so the ViewShell will check this on EndPrint (->prnmon.cxx)
//STRIP001 	pImp->bGotOwnerShip = TRUE;
//STRIP001 }

//STRIP001 BOOL SfxViewShell::GotOwnerShip_Impl()
//STRIP001 {
//STRIP001 	return pImp->bGotOwnerShip;
//STRIP001 }

//STRIP001 long SfxViewShell::HandleNotifyEvent_Impl( NotifyEvent& rEvent )
//STRIP001 {
//STRIP001 	if ( pImp->pController )
//STRIP001 		return pImp->pController->HandleEvent_Impl( rEvent );
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 BOOL SfxViewShell::HasKeyListeners_Impl()
//STRIP001 {
//STRIP001 	return pImp->pController ? pImp->pController->HasKeyListeners_Impl() : FALSE;
//STRIP001 }

//STRIP001 BOOL SfxViewShell::HasMouseClickListeners_Impl()
//STRIP001 {
//STRIP001 	return pImp->pController ? pImp->pController->HasMouseClickListeners_Impl() : FALSE;
//STRIP001 }

//STRIP001 void SfxViewShell::SetAdditionalPrintOptions( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rOpts )
//STRIP001 {
//STRIP001 	pImp->aPrintOpts = rOpts;
//STRIP001  	GetObjectShell()->Broadcast( SfxPrintingHint( -3, NULL, NULL, rOpts ) );
//STRIP001 }
}
