/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_edit.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:02:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
// auto strip #include <com/sun/star/accessibility/XAccessible.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTOBJECT_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventObject.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventId.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleStateType.hpp>
// auto strip #endif

// auto strip #ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
// auto strip #include <toolkit/helper/vclunohelper.hxx>
// auto strip #endif


#include "starmath.hrc"
#define ITEMID_FONT 		1
#define ITEMID_FONTHEIGHT	2
#define ITEMID_LRSPACE		3
#define ITEMID_WEIGHT		4


// auto strip #ifndef _SV_MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif
#ifndef _MyEDITVIEW_HXX //autogen
#include <bf_svx/editview.hxx>
#endif
#ifndef _MyEDITENG_HXX //autogen
#include <bf_svx/editeng.hxx>
#endif
// auto strip #ifndef _EDITSTAT_HXX //autogen
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #endif
// auto strip #ifndef _EEITEM_HXX //autogen
// auto strip #include <bf_svx/eeitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
// auto strip #ifndef _SVX_FHGTITEM_HXX //autogen
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_WGHTITEM_HXX //autogen
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMSET_HXX //autogen
// auto strip #include <svtools/itemset.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FONTITEM_HXX //autogen
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #endif


// auto strip #include "edit.hxx"
#include "view.hxx"
#include "document.hxx"
#include "config.hxx"
namespace binfilter {

#define SCROLL_LINE 		24

#define MINWIDTH		200
#define MINHEIGHT		200
#define MINSPLIT		40
#define SPLITTERWIDTH	2


using namespace ::com::sun::star::accessibility;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

////////////////////////////////////////


/*N*/ void SmGetLeftSelectionPart(const ESelection aSel,
/*N*/ 							USHORT &nPara, USHORT &nPos)
/*N*/ 	// returns paragraph number and position of the selections left part
/*N*/ {
/*N*/ 	// compare start and end of selection and use the one that comes first
/*N*/ 	if (	aSel.nStartPara <  aSel.nEndPara
/*N*/ 		||	aSel.nStartPara == aSel.nEndPara  &&  aSel.nStartPos < aSel.nEndPos)
/*?*/ 	{	nPara = aSel.nStartPara;
/*?*/ 		nPos  = aSel.nStartPos;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{	nPara = aSel.nEndPara;
/*N*/ 		nPos  = aSel.nEndPos;
/*N*/ 	}
/*N*/ }

////////////////////////////////////////

/*N*/ SmEditWindow::SmEditWindow( SmCmdBoxWindow &rMyCmdBoxWin ) :
//STRIP001 /*?*/     pAccessible         (0),
/*N*/     Window              (&rMyCmdBoxWin),
/*N*/     DropTargetHelper    ( this ),
/*N*/     rCmdBox             (rMyCmdBoxWin),
/*N*/ 	pEditView			(0),
/*N*/ 	pHScrollBar			(0),
/*N*/ 	pVScrollBar			(0),
/*N*/ 	pScrollBox			(0)
/*N*/ {
/*N*/ 	SetHelpId(HID_SMA_COMMAND_WIN_EDIT);
/*N*/ 	SetMapMode(MAP_PIXEL);
/*N*/
/*N*/     ApplyColorConfigValues( SM_MOD1()->GetColorConfig() );
/*N*/
/*N*/     // compare DataChanged
/*N*/ 	SetBackground( GetSettings().GetStyleSettings().GetWindowColor() );
/*N*/
/*N*/ 	aModifyTimer.SetTimeoutHdl(LINK(this, SmEditWindow, ModifyTimerHdl));
/*N*/ 	aModifyTimer.SetTimeout(2000);
/*N*/ 	aModifyTimer.Start();
/*N*/
/*N*/ 	aCursorMoveTimer.SetTimeoutHdl(LINK(this, SmEditWindow, CursorMoveTimerHdl));
/*N*/ 	aCursorMoveTimer.SetTimeout(500);
/*N*/
/*N*/     Show();
/*N*/ }


/*N*/ SmEditWindow::~SmEditWindow()
/*N*/ {
/*N*/ 	aCursorMoveTimer.Stop();
/*N*/ 	aModifyTimer.Stop();
/*N*/
/*N*/     if (pEditView)
/*N*/     {
/*N*/         EditEngine *pEditEngine = pEditView->GetEditEngine();
/*N*/         if (pEditEngine)
/*N*/         {
/*N*/             pEditEngine->SetStatusEventHdl( Link() );
/*N*/             pEditEngine->RemoveView( pEditView );
/*N*/         }
/*N*/     }
/*N*/ 	delete pEditView;
/*N*/ 	delete pHScrollBar;
/*N*/ 	delete pVScrollBar;
/*N*/ 	delete pScrollBox;
/*N*/
//STRIP001 /*N*/     if ( pAccessible)
//STRIP001 /*?*/         pAccessible->ClearWin();    // make Accessible defunctional
/*N*/     // Note: memory for pAccessible will be freed when the reference
/*N*/     // xAccessible is released.
/*N*/ }


//STRIP001 SmViewShell * SmEditWindow::GetView()
//STRIP001 {
//STRIP001     return rCmdBox.GetView();
//STRIP001 }


/*N*/ SmDocShell * SmEditWindow::GetDoc()
/*N*/ {
/*N*/     SmViewShell *pView = rCmdBox.GetView();
/*N*/     return pView ? pView->GetDoc() : 0;
/*N*/ }


/*N*/ EditEngine * SmEditWindow::GetEditEngine()
/*N*/ {
/*N*/     EditEngine *pEditEng = 0;
/*N*/     if (pEditView)
/*N*/         pEditEng = pEditView->GetEditEngine();
/*N*/     else
/*N*/     {
/*N*/         SmDocShell *pDoc = GetDoc();
/*N*/         if (pDoc)
/*N*/             pEditEng = &pDoc->GetEditEngine();
/*N*/     }
/*N*/     return pEditEng;
/*N*/ }


//STRIP001 SfxItemPool * SmEditWindow::GetEditEngineItemPool()
//STRIP001 {
//STRIP001     SmDocShell *pDoc = GetDoc();
//STRIP001     return pDoc ? &pDoc->GetEditEngineItemPool() : 0;
//STRIP001 }

/*N*/ void SmEditWindow::ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg )
/*N*/ {
/*N*/     // Note: SetBackground still done in SmEditWindow::DataChanged
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 	ColorData nVal = rColorCfg.GetColorValue(svtools::FONTCOLOR).nColor;
/*N*/ #endif
/*N*/     SetTextColor( rColorCfg.GetColorValue(svtools::FONTCOLOR).nColor );
/*N*/     Invalidate();
/*N*/ }

//STRIP001 void SmEditWindow::DataChanged( const DataChangedEvent& )
//STRIP001 {
//STRIP001     const StyleSettings aSettings( GetSettings().GetStyleSettings() );
//STRIP001
//STRIP001     ApplyColorConfigValues( SM_MOD1()->GetColorConfig() );
//STRIP001     SetBackground( aSettings.GetWindowColor() );
//STRIP001
//STRIP001     // edit fields in other Applications use this font instead of
//STRIP001     // the application font thus we use this one too
//STRIP001     SetPointFont( aSettings.GetFieldFont() /*aSettings.GetAppFont()*/ );
//STRIP001
//STRIP001     EditEngine  *pEditEngine = GetEditEngine();
//STRIP001     SfxItemPool *pEditEngineItemPool = GetEditEngineItemPool();
//STRIP001
//STRIP001 	if (pEditEngine && pEditEngineItemPool)
//STRIP001 	{
//STRIP001         //!
//STRIP001         //! see also SmDocShell::GetEditEngine() !
//STRIP001         //!
//STRIP001
//STRIP001 		pEditEngine->SetDefTab( USHORT( GetTextWidth( C2S("XXXX") ) ) );
//STRIP001
//STRIP001         USHORT aFntInfoId[3] = {
//STRIP001                 EE_CHAR_FONTINFO, EE_CHAR_FONTINFO_CJK, EE_CHAR_FONTINFO_CTL };
//STRIP001         for (int i = 0;  i < 3;  ++i)
//STRIP001         {
//STRIP001             const SfxPoolItem *pItem;
//STRIP001             if ((pItem = pEditEngineItemPool->GetPoolDefaultItem(  aFntInfoId[i] )))
//STRIP001             {
//STRIP001                 const SvxFontItem *pFntItem = ((const SvxFontItem *) pItem);
//STRIP001                 const Font &rFnt = aSettings.GetFieldFont();
//STRIP001                 SvxFontItem aFntItem( rFnt.GetFamily(), rFnt.GetName(),
//STRIP001                         rFnt.GetStyleName(), rFnt.GetPitch(),
//STRIP001                         pFntItem->GetCharSet(),
//STRIP001                         aFntInfoId[i] );
//STRIP001                 pEditEngineItemPool->SetPoolDefaultItem( aFntItem );
//STRIP001             }
//STRIP001         }
//STRIP001
//STRIP001         SvxFontHeightItem aItem( GetFont().GetSize().Height(), 100,
//STRIP001                                  EE_CHAR_FONTHEIGHT );
//STRIP001         pEditEngineItemPool->SetPoolDefaultItem( aItem );
//STRIP001         aItem.SetWhich( EE_CHAR_FONTHEIGHT_CJK );
//STRIP001         pEditEngineItemPool->SetPoolDefaultItem( aItem );
//STRIP001         aItem.SetWhich( EE_CHAR_FONTHEIGHT_CTL );
//STRIP001         pEditEngineItemPool->SetPoolDefaultItem( aItem );
//STRIP001
//STRIP001 		// forces new settings to be used
//STRIP001         // unfortunately this resets the whole edit engine
//STRIP001         // thus we need to save at least the text
//STRIP001         String aTxt( pEditEngine->GetText( LINEEND_LF ) );
//STRIP001 		pEditEngine->Clear();	//#77957 incorrect font size
//STRIP001         pEditEngine->SetText( aTxt );
//STRIP001 	}
//STRIP001
//STRIP001 	AdjustScrollBars();
//STRIP001 	Resize();
//STRIP001 }

/*N*/ IMPL_LINK( SmEditWindow, ModifyTimerHdl, Timer *, pTimer )
/*N*/ {
/*N*/ 	SmModule *pp = SM_MOD1();
/*N*/ 	if (pp->GetConfig()->IsAutoRedraw())
/*N*/ 		Flush();
/*N*/ 	aModifyTimer.Start();
/*N*/ 	return 0;
/*N*/ }


/*N*/ IMPL_LINK(SmEditWindow, CursorMoveTimerHdl, Timer *, pTimer)
/*N*/ 	// every once in a while check cursor position (selection) of edit
/*N*/ 	// window and if it has changed (try to) set the formula-cursor
/*N*/ 	// according to that.
/*N*/ {
/*N*/ 	ESelection	aNewSelection   (GetSelection());
/*N*/
/*N*/ 	if (!aNewSelection.IsEqual(aOldSelection))
/*N*/     {   SmViewShell *pView = rCmdBox.GetView();
/*N*/
/*N*/ 		if (pView)
/*N*/ 		{
/*N*/ 			// get row and column to look for
/*N*/ 			USHORT	nRow, nCol;
/*N*/ 			SmGetLeftSelectionPart(aNewSelection, nRow, nCol);
/*N*/ 			nRow++;
/*N*/ 			nCol++;
/*N*/
/*N*/ 			pView->GetGraphicWindow().SetCursorPos(nRow, nCol);
/*N*/
/*N*/ 			aOldSelection = aNewSelection;
/*N*/ 		}
/*N*/ 	}
/*N*/
/*N*/ 	return 0;
/*N*/ }


/*N*/ void SmEditWindow::Resize()
/*N*/ {
/*N*/ 	if (!pEditView)
/*N*/ 		CreateEditView();
/*N*/
/*N*/ 	if (pEditView)
/*N*/ 	{
/*N*/ 		pEditView->SetOutputArea(AdjustScrollBars());
/*N*/ 		pEditView->ShowCursor();
/*N*/
/*N*/         DBG_ASSERT( pEditView->GetEditEngine(), "EditEngine missing" );
/*N*/ 		const long nMaxVisAreaStart = pEditView->GetEditEngine()->GetTextHeight() -
/*N*/ 									  pEditView->GetOutputArea().GetHeight();
/*N*/ 		if (pEditView->GetVisArea().Top() > nMaxVisAreaStart)
/*N*/ 		{
/*?*/ 			Rectangle aVisArea(pEditView->GetVisArea() );
/*?*/ 			aVisArea.Top() = (nMaxVisAreaStart > 0 ) ? nMaxVisAreaStart : 0;
/*?*/ 			aVisArea.SetSize(pEditView->GetOutputArea().GetSize());
/*?*/ 			pEditView->SetVisArea(aVisArea);
/*?*/ 			pEditView->ShowCursor();
/*N*/ 		}
/*N*/ 		InitScrollBars();
/*N*/ 	}
/*N*/ 	Invalidate();
/*N*/ }

//STRIP001 void SmEditWindow::MouseButtonUp(const MouseEvent &rEvt)
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		pEditView->MouseButtonUp(rEvt);
//STRIP001 	else
//STRIP001 		Window::MouseButtonUp (rEvt);
//STRIP001
//STRIP001 	// ggf FormulaCursor neu positionieren
//STRIP001 	CursorMoveTimerHdl(&aCursorMoveTimer);
//STRIP001 }

//STRIP001 void SmEditWindow::MouseButtonDown(const MouseEvent &rEvt)
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		pEditView->MouseButtonDown(rEvt);
//STRIP001 	else
//STRIP001 		Window::MouseButtonDown (rEvt);
//STRIP001
//STRIP001 	GrabFocus();
//STRIP001 }

//STRIP001 void SmEditWindow::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	if (rCEvt.GetCommand() == COMMAND_CONTEXTMENU)
//STRIP001 	{
//STRIP001 		GetParent()->ToTop();
//STRIP001
//STRIP001         Point aPoint = rCEvt.GetMousePosPixel();
//STRIP001 		PopupMenu* pPopupMenu = new PopupMenu(SmResId(RID_COMMANDMENU));
//STRIP001
//STRIP001         // added for replaceability of context menus #96085, #93782
//STRIP001         Menu* pMenu = NULL;
//STRIP001         ::com::sun::star::ui::ContextMenuExecuteEvent aEvent;
//STRIP001         aEvent.SourceWindow = VCLUnoHelper::GetInterface( this );
//STRIP001         aEvent.ExecutePosition.X = aPoint.X();
//STRIP001         aEvent.ExecutePosition.Y = aPoint.Y();
//STRIP001         if ( GetView()->TryContextMenuInterception( *pPopupMenu, pMenu, aEvent ) )
//STRIP001         {
//STRIP001             if ( pMenu )
//STRIP001             {
//STRIP001                 delete pPopupMenu;
//STRIP001                 pPopupMenu = (PopupMenu*) pMenu;
//STRIP001             }
//STRIP001         }
//STRIP001
//STRIP001         pPopupMenu->SetSelectHdl(LINK(this, SmEditWindow, MenuSelectHdl));
//STRIP001
//STRIP001         pPopupMenu->Execute( this, aPoint );
//STRIP001 		delete pPopupMenu;
//STRIP001 	}
//STRIP001 	else if (pEditView)
//STRIP001 		pEditView->Command( rCEvt );
//STRIP001 	else
//STRIP001 		Window::Command (rCEvt);
//STRIP001 }

//STRIP001 IMPL_LINK_INLINE_START( SmEditWindow, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001     SmViewShell *pViewSh = rCmdBox.GetView();
//STRIP001 	if (pViewSh)
//STRIP001 		pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 				SID_INSERTCOMMAND, SFX_CALLMODE_STANDARD,
//STRIP001 				new SfxInt16Item(SID_INSERTCOMMAND, pMenu->GetCurItemId()), 0L);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmEditWindow, MenuSelectHdl, Menu *, pMenu )

/*N*/ void SmEditWindow::KeyInput(const KeyEvent& rKEvt)
/*N*/ {
//STRIP001 /*N*/ 	if (rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE)
//STRIP001 /*N*/ 	{
//STRIP001 /*?*/ 		BOOL bCallBase = TRUE;
//STRIP001 /*?*/ 		SfxViewShell* pViewShell = SfxViewShell::Current();
//STRIP001 /*?*/ 		if ( pViewShell && pViewShell->ISA(SmViewShell) )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SmDocShell* pDocSh = (SmDocShell*) pViewShell->GetViewFrame()->GetObjectShell();
//STRIP001 /*?*/ 			if (pDocSh)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 					/* fuert zum (sofortigen) Zerstoeren von this! */
//STRIP001 /*?*/ 				pDocSh->DoInPlaceActivate( FALSE );
//STRIP001 /*?*/ 				bCallBase = FALSE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		if ( bCallBase )
//STRIP001 /*?*/ 			Window::KeyInput( rKEvt );
//STRIP001 /*?*/ 	}
//STRIP001 /*N*/ 	else
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/        // Timer neu starten, um den Handler (auch bei laengeren Eingaben)
//STRIP001 /*N*/        // moeglichst nur einmal am Ende aufzurufen.
//STRIP001 /*N*/ 		aCursorMoveTimer.Start();
//STRIP001 /*N*/
//STRIP001 /*N*/         DBG_ASSERT( pEditView, "EditView missing (NULL pointer)" );
//STRIP001 /*N*/         if (!pEditView)
//STRIP001 /*?*/             CreateEditView();
//STRIP001 /*N*/ 		if ( !pEditView->PostKeyEvent(rKEvt) )
//STRIP001 /*N*/ 		{
//STRIP001 /*?*/ 			if ( !SfxViewShell::Current()->KeyInput(rKEvt) )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 					/* fuert bei F1 (Hilfe) zum Zerstoeren von this! */
//STRIP001 /*?*/ 				Flush();
//STRIP001 /*?*/ 				if ( aModifyTimer.IsActive() )
//STRIP001 /*?*/ 					aModifyTimer.Stop();
//STRIP001 /*?*/ 				Window::KeyInput(rKEvt);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				//SFX hat evtl. Slot an der View gecallt und dabei (wg. Hack
//STRIP001 /*?*/ 				//im SFX) den Focus auf die View gesetzt
//STRIP001 /*?*/ 				SfxViewShell* pVShell = SfxViewShell::Current();
//STRIP001 /*?*/ 				if ( pVShell && pVShell->ISA(SmViewShell) &&
//STRIP001 /*?*/ 					 ((SmViewShell*)pVShell)->GetGraphicWindow().HasFocus() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					GrabFocus();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		else
//STRIP001 /*N*/         {
//STRIP001 /*N*/             // have doc-shell modified only for formula input/change and not
//STRIP001 /*N*/             // cursor travelling and such things...
//STRIP001 /*N*/             SmDocShell *pDocShell = GetDoc();
//STRIP001 /*N*/             if (pDocShell)
//STRIP001 /*N*/                 pDocShell->SetModified( GetEditEngine()->IsModified() );
//STRIP001 /*N*/
//STRIP001 /*N*/             aModifyTimer.Start();
//STRIP001 /*N*/         }
//STRIP001 /*N*/ 	}
/*N*/ }

//STRIP001 void SmEditWindow::Paint(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	if (!pEditView)
//STRIP001 		CreateEditView();
//STRIP001 	pEditView->Paint(rRect);
//STRIP001 }

/*N*/ void SmEditWindow::CreateEditView()
/*N*/ {
//STRIP001 /*N*/     EditEngine *pEditEngine = GetEditEngine();
//STRIP001 /*N*/
//STRIP001 /*N*/     //! pEditEngine and pEditView may be 0.
//STRIP001 /*N*/     //! For example when the program is used by the document-converter
//STRIP001 /*N*/ 	if (!pEditView && pEditEngine)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		pEditView = new EditView( pEditEngine, this );
//STRIP001 /*N*/ 		pEditEngine->InsertView( pEditView );
//STRIP001 /*N*/
//STRIP001 /*N*/         if (!pVScrollBar)
//STRIP001 /*N*/             pVScrollBar = new ScrollBar(this, WinBits(WB_VSCROLL));
//STRIP001 /*N*/         if (!pHScrollBar)
//STRIP001 /*N*/             pHScrollBar = new ScrollBar(this, WinBits(WB_HSCROLL));
//STRIP001 /*N*/         if (!pScrollBox)
//STRIP001 /*N*/             pScrollBox  = new ScrollBarBox(this);
//STRIP001 /*N*/ 		pVScrollBar->SetScrollHdl(LINK(this, SmEditWindow, ScrollHdl));
//STRIP001 /*N*/ 		pHScrollBar->SetScrollHdl(LINK(this, SmEditWindow, ScrollHdl));
//STRIP001 /*N*/
//STRIP001 /*N*/ 		pEditView->SetOutputArea(AdjustScrollBars());
//STRIP001 /*N*/
//STRIP001 /*N*/ 		ESelection eSelection;
//STRIP001 /*N*/
//STRIP001 /*N*/ 		pEditView->SetSelection(eSelection);
//STRIP001 /*N*/ 		Update();
//STRIP001 /*N*/ 		pEditView->ShowCursor(TRUE, TRUE);
//STRIP001 /*N*/
//STRIP001 /*N*/ 		pEditEngine->SetStatusEventHdl( LINK(this, SmEditWindow, EditStatusHdl) );
//STRIP001 /*N*/ 		SetPointer(pEditView->GetPointer());
//STRIP001 /*N*/
//STRIP001 /*N*/ 		SetScrollBarRanges();
//STRIP001 /*N*/ 	}
/*N*/ }


/*N*/ IMPL_LINK( SmEditWindow, EditStatusHdl, EditStatus *, pStat )
/*N*/ {
/*N*/     if (!pEditView)
/*N*/ 		return 1;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SetScrollBarRanges();
/*N*/ 		return 0;
/*N*/ 	}
/*N*/ }

/*N*/ IMPL_LINK_INLINE_START( SmEditWindow, ScrollHdl, ScrollBar *, pScrollBar )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001
//STRIP001     DBG_ASSERT(pEditView, "EditView missing");
//STRIP001     if (pEditView)
//STRIP001     {
//STRIP001         pEditView->SetVisArea(Rectangle(Point(pHScrollBar->GetThumbPos(),
//STRIP001                                             pVScrollBar->GetThumbPos()),
//STRIP001                                         pEditView->GetVisArea().GetSize()));
//STRIP001         pEditView->Invalidate();
//STRIP001     }
/*N*/ 	return 0;
/*N*/ }
/*N*/ IMPL_LINK_INLINE_END( SmEditWindow, ScrollHdl, ScrollBar *, pScrollBar )

/*N*/ Rectangle SmEditWindow::AdjustScrollBars()
/*N*/ {
/*N*/ 	const Size aOut( GetOutputSizePixel() );
/*N*/ 	Point aPoint;
/*N*/ 	Rectangle aRect( aPoint, aOut );
/*N*/
/*N*/ 	if (pVScrollBar && pHScrollBar && pScrollBox)
/*N*/ 	{
/*N*/ 		const long nTmp = GetSettings().GetStyleSettings().GetScrollBarSize();
/*N*/ 		Point aPt( aRect.TopRight() ); aPt.X() -= nTmp -1L;
/*N*/ 		pVScrollBar->SetPosSizePixel( aPt, Size(nTmp, aOut.Height() - nTmp));
/*N*/
/*N*/ 		aPt = aRect.BottomLeft(); aPt.Y() -= nTmp - 1L;
/*N*/ 		pHScrollBar->SetPosSizePixel( aPt, Size(aOut.Width() - nTmp, nTmp));
/*N*/
/*N*/ 		aPt.X() = pHScrollBar->GetSizePixel().Width();
/*N*/ 		aPt.Y() = pVScrollBar->GetSizePixel().Height();
/*N*/ 		pScrollBox->SetPosSizePixel(aPt, Size(nTmp, nTmp ));
/*N*/
/*N*/ 		aRect.Right()  = aPt.X() - 2;
/*N*/ 		aRect.Bottom() = aPt.Y() - 2;
/*N*/ 	}
/*N*/ 	return aRect;
/*N*/ }

/*N*/ void SmEditWindow::SetScrollBarRanges()
/*N*/ {
/*N*/ 	// Extra-Methode, nicht InitScrollBars, da auch fuer EditEngine-Events.
/*N*/     EditEngine *pEditEngine = GetEditEngine();
/*N*/ 	if (pVScrollBar && pHScrollBar && pEditEngine && pEditView)
/*N*/ 	{
/*N*/ 		long nTmp = pEditEngine->GetTextHeight();
/*N*/ 		pVScrollBar->SetRange(Range(0, nTmp));
/*N*/ 		pVScrollBar->SetThumbPos(pEditView->GetVisArea().Top());
/*N*/
/*N*/ 		nTmp = pEditEngine->GetPaperSize().Width();
/*N*/ 		pHScrollBar->SetRange(Range(0,nTmp));
/*N*/ 		pHScrollBar->SetThumbPos(pEditView->GetVisArea().Left());
/*N*/ 	}
/*N*/ }

/*N*/ void SmEditWindow::InitScrollBars()
/*N*/ {
/*N*/     if (pVScrollBar && pHScrollBar && pScrollBox && pEditView)
/*N*/ 	{
/*N*/ 		const Size aOut( pEditView->GetOutputArea().GetSize() );
/*N*/ 		pVScrollBar->SetVisibleSize(aOut.Height());
/*N*/ 		pVScrollBar->SetPageSize(aOut.Height() * 8 / 10);
/*N*/ 		pVScrollBar->SetLineSize(aOut.Height() * 2 / 10);
/*N*/
/*N*/ 		pHScrollBar->SetVisibleSize(aOut.Width());
/*N*/ 		pHScrollBar->SetPageSize(aOut.Width() * 8 / 10);
/*N*/ 		pHScrollBar->SetLineSize(SCROLL_LINE );
/*N*/
/*N*/ 		SetScrollBarRanges();
/*N*/
/*N*/ 		pVScrollBar->Show();
/*N*/ 		pHScrollBar->Show();
/*N*/ 		pScrollBox->Show();
/*N*/ 	}
/*N*/ }


/*N*/ XubString SmEditWindow::GetText()
/*N*/ {
/*N*/ 	String aText;
/*N*/     EditEngine *pEditEngine = GetEditEngine();
/*N*/ 	DBG_ASSERT( pEditEngine, "EditEngine missing" );
/*N*/ 	if (pEditEngine)
/*N*/ 		aText = pEditEngine->GetText( LINEEND_LF );
/*N*/ 	return aText;
/*N*/ }


/*N*/ void SmEditWindow::SetText(const XubString& rText)
/*N*/ {
/*N*/     EditEngine *pEditEngine = GetEditEngine();
/*N*/ 	DBG_ASSERT( pEditEngine, "EditEngine missing" );
/*N*/ 	if (pEditEngine  &&  !pEditEngine->IsModified())
/*N*/ 	{
/*N*/ 		if (!pEditView)
/*?*/ 			CreateEditView();
/*N*/
/*N*/ 		ESelection eSelection = pEditView->GetSelection();
/*N*/
/*N*/ 		pEditEngine->SetText(rText);
/*N*/ 		pEditEngine->ClearModifyFlag();
/*N*/
/*N*/       //! Hier die Timer neu zu starten verhindert, dass die Handler fuer andere
/*N*/ 		//! (im Augenblick nicht mehr aktive) Math Tasks aufgerufen werden.
/*N*/ 		aModifyTimer.Start();
/*N*/ 		aCursorMoveTimer.Start();
/*N*/
/*N*/ 		pEditView->SetSelection(eSelection);
/*N*/ 	}
/*N*/ }


/*N*/ void SmEditWindow::GetFocus()
/*N*/ {
/*N*/ 	Window::GetFocus();
/*N*/
//STRIP001     if (xAccessible.is())
//STRIP001     {
//STRIP001         // Note: will implicitly send the AccessibleStateType::FOCUSED event
//STRIP001         ::accessibility::AccessibleTextHelper *pHelper = pAccessible->GetTextHelper();
//STRIP001         if (pHelper)
//STRIP001             pHelper->SetFocus( sal_True );
//STRIP001     }
//STRIP001
/*N*/     if (!pEditView)
/*N*/          CreateEditView();
/*N*/     EditEngine *pEditEngine = GetEditEngine();
/*N*/ 	if (pEditEngine)
/*N*/ 		pEditEngine->SetStatusEventHdl( LINK(this, SmEditWindow, EditStatusHdl) );
/*N*/ }


//STRIP001 void SmEditWindow::LoseFocus()
//STRIP001 {
//STRIP001     EditEngine *pEditEngine = GetEditEngine();
//STRIP001 	if (pEditEngine)
//STRIP001 		pEditEngine->SetStatusEventHdl( Link() );
//STRIP001
//STRIP001 	Window::LoseFocus();
//STRIP001
//STRIP001     if (xAccessible.is())
//STRIP001     {
//STRIP001         // Note: will implicitly send the AccessibleStateType::FOCUSED event
//STRIP001         ::accessibility::AccessibleTextHelper *pHelper = pAccessible->GetTextHelper();
//STRIP001         if (pHelper)
//STRIP001             pHelper->SetFocus( sal_False );
//STRIP001     }
//STRIP001 }


//STRIP001 BOOL SmEditWindow::IsAllSelected() const
//STRIP001 {
//STRIP001     BOOL bRes = FALSE;
//STRIP001     EditEngine *pEditEngine = ((SmEditWindow *) this)->GetEditEngine();
//STRIP001 	DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001     DBG_ASSERT( pEditEngine, "NULL pointer" );
//STRIP001     if (pEditEngine  &&  pEditView)
//STRIP001     {
//STRIP001         ESelection eSelection( pEditView->GetSelection() );
//STRIP001         INT32 nParaCnt = pEditEngine->GetParagraphCount();
//STRIP001         if (!(nParaCnt - 1))
//STRIP001         {
//STRIP001             String Text( pEditEngine->GetText( LINEEND_LF ) );
//STRIP001             bRes = !eSelection.nStartPos && (eSelection.nEndPos == Text.Len () - 1);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             bRes = !eSelection.nStartPara && (eSelection.nEndPara == nParaCnt - 1);
//STRIP001         }
//STRIP001     }
//STRIP001     return bRes;
//STRIP001 }

//STRIP001 void SmEditWindow::SelectAll()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001 	if (pEditView)
//STRIP001 	{
//STRIP001 		// 0xFFFF as last two parameters refers to the end of the text
//STRIP001 		pEditView->SetSelection( ESelection( 0, 0, 0xFFFF, 0xFFFF ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SmEditWindow::InsertCommand(USHORT Command)
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001     {
//STRIP001         //Anfang der Selektion merken und hinterher den Cursor daraufsetzen. Nur so
//STRIP001         //macht das SelNextMark() Sinn.
//STRIP001         ESelection aSelection = pEditView->GetSelection();
//STRIP001         aSelection.nEndPos  = aSelection.nStartPos;
//STRIP001         aSelection.nEndPara = aSelection.nStartPara;
//STRIP001
//STRIP001         DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001         String  aText = String(SmResId(Command));
//STRIP001         pEditView->InsertText(aText);
//STRIP001
//STRIP001         if (HasMark(aText))
//STRIP001         {   // set selection to next mark
//STRIP001             pEditView->SetSelection(aSelection);
//STRIP001             SelNextMark();
//STRIP001         }
//STRIP001         else
//STRIP001         {   // set selection after inserted text
//STRIP001             aSelection.nStartPos  =
//STRIP001             aSelection.nEndPos   += aText.Len();
//STRIP001             pEditView->SetSelection(aSelection);
//STRIP001         }
//STRIP001
//STRIP001         GrabFocus();
//STRIP001     }
//STRIP001 }

//STRIP001 void SmEditWindow::MarkError(const Point &rPos)
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001     {
//STRIP001         const int Col = rPos.X();
//STRIP001         const int Row = rPos.Y() - 1;
//STRIP001
//STRIP001         pEditView->SetSelection(ESelection (Row, Col - 1, Row, Col));
//STRIP001         GrabFocus();
//STRIP001     }
//STRIP001 }

//STRIP001 void SmEditWindow::SelNextMark()
//STRIP001 {
//STRIP001     EditEngine *pEditEngine = GetEditEngine();
//STRIP001 	DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001 	DBG_ASSERT( pEditEngine, "NULL pointer" );
//STRIP001     if (pEditEngine  &&  pEditView)
//STRIP001     {
//STRIP001         ESelection eSelection = pEditView->GetSelection();
//STRIP001         USHORT     Pos        = eSelection.nEndPos;
//STRIP001         String     aMark (C2S("<?>"));
//STRIP001         String     aText;
//STRIP001         USHORT     nCounts    = pEditEngine->GetParagraphCount();
//STRIP001
//STRIP001         while (eSelection.nEndPara < nCounts)
//STRIP001         {
//STRIP001             aText = pEditEngine->GetText( eSelection.nEndPara );
//STRIP001             Pos   = aText.Search(aMark, Pos);
//STRIP001
//STRIP001             if (Pos != STRING_NOTFOUND)
//STRIP001             {
//STRIP001                 pEditView->SetSelection(ESelection (eSelection.nEndPara, Pos, eSelection.nEndPara, Pos + 3));
//STRIP001                 break;
//STRIP001             }
//STRIP001
//STRIP001             Pos = 0;
//STRIP001             eSelection.nEndPara++;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 void SmEditWindow::SelPrevMark()
//STRIP001 {
//STRIP001     EditEngine *pEditEngine = GetEditEngine();
//STRIP001 	DBG_ASSERT( pEditEngine, "NULL pointer" );
//STRIP001 	DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001     if (pEditEngine  &&  pEditView)
//STRIP001     {
//STRIP001         ESelection eSelection = pEditView->GetSelection();
//STRIP001         USHORT     Pos        = STRING_NOTFOUND;
//STRIP001         xub_StrLen Max        = eSelection.nStartPos;
//STRIP001         String     Text( pEditEngine->GetText( eSelection.nStartPara ) );
//STRIP001         String     aMark (C2S("<?>"));
//STRIP001         USHORT     nCounts    = pEditEngine->GetParagraphCount();
//STRIP001
//STRIP001         do
//STRIP001         {
//STRIP001             USHORT Fnd = Text.Search(aMark, 0);
//STRIP001
//STRIP001             while ((Fnd < Max) && (Fnd != STRING_NOTFOUND))
//STRIP001             {
//STRIP001                 Pos = Fnd;
//STRIP001                 Fnd = Text.Search(aMark, Fnd + 1);
//STRIP001             }
//STRIP001
//STRIP001             if (Pos == STRING_NOTFOUND)
//STRIP001             {
//STRIP001                 eSelection.nStartPara--;
//STRIP001                 Text = pEditEngine->GetText( eSelection.nStartPara );
//STRIP001                 Max = Text.Len();
//STRIP001             }
//STRIP001         }
//STRIP001         while ((eSelection.nStartPara < nCounts) &&
//STRIP001             (Pos == STRING_NOTFOUND));
//STRIP001
//STRIP001         if (Pos != STRING_NOTFOUND)
//STRIP001         {
//STRIP001             pEditView->SetSelection(ESelection (eSelection.nStartPara, Pos, eSelection.nStartPara, Pos + 3));
//STRIP001         }
//STRIP001     }
//STRIP001 }

//STRIP001 BOOL SmEditWindow::HasMark(const String& rText) const
//STRIP001 	// returns true iff 'rText' contains a mark
//STRIP001 {
//STRIP001 	return rText.SearchAscii("<?>", 0) != STRING_NOTFOUND;
//STRIP001 }

//STRIP001 void SmEditWindow::MouseMove(const MouseEvent &rEvt)
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		pEditView->MouseMove(rEvt);
//STRIP001 }

//STRIP001 sal_Int8 SmEditWindow::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return pEditView ? /*pEditView->QueryDrop( rEvt )*/DND_ACTION_NONE: DND_ACTION_NONE;
//STRIP001 }

//STRIP001 sal_Int8 SmEditWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return pEditView ? /*pEditView->Drop( rEvt )*/DND_ACTION_NONE : DND_ACTION_NONE;
//STRIP001 }

/*N*/ ESelection SmEditWindow::GetSelection() const
/*N*/ {
/*N*/     // pointer may be 0 when reloading a document and the old view
/*N*/     // was already destroyed
/*N*/     //(DBG_ASSERT( pEditView, "NULL pointer" );
/*N*/ 	ESelection eSel;
/*N*/ 	if (pEditView)
/*N*/ 		eSel = pEditView->GetSelection();
/*N*/ 	return eSel;
/*N*/ }

//STRIP001 void SmEditWindow::SetSelection(const ESelection &rSel)
//STRIP001 {
//STRIP001 	DBG_ASSERT( pEditView, "NULL pointer" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->SetSelection(rSel);
//STRIP001 }

/*N*/ BOOL SmEditWindow::IsEmpty() const
/*N*/ {
/*N*/     EditEngine *pEditEngine = ((SmEditWindow *) this)->GetEditEngine();
/*N*/     return pEditEngine ? pEditEngine->GetTextLen() == 0 : FALSE;
/*N*/ }

/*N*/ BOOL SmEditWindow::IsSelected() const
/*N*/ {
/*N*/     return pEditView ? pEditView->HasSelection() : FALSE;
/*N*/ }

//STRIP001 void SmEditWindow::Cut()
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->Cut();
//STRIP001 }

//STRIP001 void SmEditWindow::Copy()
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->Copy();
//STRIP001 }

//STRIP001 void SmEditWindow::Paste()
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->Paste();
//STRIP001 }

//STRIP001 void SmEditWindow::Delete()
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->DeleteSelected();
//STRIP001 }

//STRIP001 void SmEditWindow::InsertText(const String& Text)
//STRIP001 {
//STRIP001     DBG_ASSERT( pEditView, "EditView missing" );
//STRIP001     if (pEditView)
//STRIP001         pEditView->InsertText(Text);
//STRIP001 }

/*N*/ void SmEditWindow::Flush()
/*N*/ {
/*N*/     EditEngine *pEditEngine = GetEditEngine();
/*N*/ 	if (pEditEngine  &&  pEditEngine->IsModified())
/*N*/ 	{
/*N*/ 		pEditEngine->ClearModifyFlag();
/*N*/         SmViewShell *pViewSh = rCmdBox.GetView();
/*N*/ 		if (pViewSh)
/*N*/ 			pViewSh->GetViewFrame()->GetDispatcher()->Execute(
/*N*/ 					SID_TEXT, SFX_CALLMODE_STANDARD,
/*N*/ 					new SfxStringItem(SID_TEXT, GetText()), 0L);
/*N*/ 	}
/*N*/
/*N*/ 	if (aCursorMoveTimer.IsActive())
/*N*/ 	{
/*N*/ 		aCursorMoveTimer.Stop();
/*N*/ 		// ggf noch die (neue) FormulaCursor Position setzen
/*N*/ 		CursorMoveTimerHdl(&aCursorMoveTimer);
/*N*/ 	}
/*N*/ }


//STRIP001 void SmEditWindow::DeleteEditView( SmViewShell &rView )
//STRIP001 {
//STRIP001     if (pEditView)
//STRIP001     {
//STRIP001         EditEngine *pEditEngine = pEditView->GetEditEngine();
//STRIP001         if (pEditEngine)
//STRIP001         {
//STRIP001             pEditEngine->SetStatusEventHdl( Link() );
//STRIP001             pEditEngine->RemoveView( pEditView );
//STRIP001         }
//STRIP001         delete pEditView;
//STRIP001         pEditView = 0;
//STRIP001     }
//STRIP001 }


//STRIP001 uno::Reference< XAccessible > SmEditWindow::CreateAccessible()
//STRIP001 {
//STRIP001     if (!pAccessible)
//STRIP001     {
//STRIP001         pAccessible = new SmEditAccessible( this );
//STRIP001         xAccessible = pAccessible;
//STRIP001         pAccessible->Init();
//STRIP001     }
//STRIP001     return xAccessible;
//STRIP001 }

}
