/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx__contdlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:33:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SOT_FACTORY_HXX
// auto strip #include <sot/factory.hxx>
// auto strip #endif
// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SALBTYPE_HXX
// auto strip #include <vcl/salbtype.hxx>		// FRound
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #include <svtools/miscopt.hxx>

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOOBJECTS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV
#define _XOUTBMP_STATICS_ONLY

// auto strip #include "dialmgr.hxx"
// auto strip #include "xoutbmp.hxx"
#include "dialogs.hrc"
#include "svxids.hrc"
#include "contdlg.hxx"
// auto strip #include "contimp.hxx"
#include "contdlg.hrc"
// auto strip #include "contwnd.hxx"
// auto strip #include "svdtrans.hxx"
// auto strip #include "svdopath.hxx"
// auto strip #include "dlgutil.hxx"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

/******************************************************************************/

//STRIP001 inline String GetUnitString( long nVal_100, FieldUnit eFieldUnit, sal_Unicode cSep )
//STRIP001 {
//STRIP001 	String aVal = UniString::CreateFromInt32( MetricField::ConvertValue( nVal_100, 2, MAP_100TH_MM, eFieldUnit ) );
//STRIP001 
//STRIP001 	while( aVal.Len() < 3 )
//STRIP001 		aVal.Insert( sal_Unicode('0'), 0 );
//STRIP001 
//STRIP001 	aVal.Insert( cSep, aVal.Len() - 2 );
//STRIP001 	aVal += sal_Unicode(' ');
//STRIP001 	aVal += SdrFormatter::GetUnitStr( eFieldUnit );
//STRIP001 
//STRIP001 	return aVal;
//STRIP001 }


/******************************************************************************/


/*N*/ SFX_IMPL_FLOATINGWINDOW( SvxContourDlgChildWindow, SID_CONTOUR_DLG );


/******************************************************************************/


/*************************************************************************
|*
|* ControllerItem
|*
\************************************************************************/

//STRIP001 SvxContourDlgItem::SvxContourDlgItem( USHORT nId, SvxSuperContourDlg& rContourDlg, SfxBindings& rBindings ) :
//STRIP001 			SfxControllerItem   ( nId, rBindings ),
//STRIP001 			rDlg				( rContourDlg )
//STRIP001 {
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxContourDlgItem::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if ( pItem && ( SID_CONTOUR_EXEC == nSID ) )
//STRIP001 	{
//STRIP001 		const SfxBoolItem* pStateItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 
//STRIP001 		DBG_ASSERT( pStateItem || pItem == 0, "SfxBoolItem erwartet");
//STRIP001 
//STRIP001 		rDlg.SetExecState( !pStateItem->GetValue() );
//STRIP001 	}
//STRIP001 }


/******************************************************************************/


/*************************************************************************
|*
|* Contour-Float
|*
\************************************************************************/

/*N*/ SvxContourDlgChildWindow::SvxContourDlgChildWindow( Window* pParent, USHORT nId,
/*N*/ 													SfxBindings* pBindings, SfxChildWinInfo* pInfo ) :
/*N*/ 			SfxChildWindow( pParent, nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SvxSuperContourDlg* pDlg = new SvxSuperContourDlg( pBindings, this, pParent, CONT_RESID( RID_SVXDLG_CONTOUR ) );
//STRIP001     pWindow = pDlg;
//STRIP001 
//STRIP001 	if ( pInfo->nFlags & SFX_CHILDWIN_ZOOMIN )
//STRIP001 		pDlg->RollUp();
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001     pDlg->Initialize( pInfo );
/*N*/ }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxContourDlgChildWindow::UpdateContourDlg( const Graphic& rGraphic, BOOL bGraphicLinked,
//STRIP001 												 const PolyPolygon* pPolyPoly, void* pEditingObj )
//STRIP001 {
//STRIP001 	if ( SfxViewFrame::Current() &&
//STRIP001 		 SfxViewFrame::Current()->HasChildWindow( SvxContourDlgChildWindow::GetChildWindowId() ) )
//STRIP001 		SVXCONTOURDLG()->Update( rGraphic, bGraphicLinked, pPolyPoly, pEditingObj );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SvxContourDlg::SvxContourDlg( SfxBindings* pBindings, SfxChildWindow* pCW,
//STRIP001 							  Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	SfxFloatingWindow	( pBindings, pCW, pParent, rResId )
//STRIP001 
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SvxContourDlg::~SvxContourDlg()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 PolyPolygon SvxContourDlg::CreateAutoContour( const Graphic& rGraphic,
//STRIP001 											  const Rectangle* pRect,
//STRIP001 											  const ULONG nFlags )
//STRIP001 {
//STRIP001 	Bitmap	aBmp;
//STRIP001 	ULONG	nContourFlags = XOUTBMP_CONTOUR_HORZ;
//STRIP001 
//STRIP001 	if ( rGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 	{
//STRIP001 		if( rGraphic.IsAnimated() )
//STRIP001 		{
//STRIP001 			VirtualDevice		aVDev;
//STRIP001 			MapMode				aTransMap;
//STRIP001 			PolyPolygon			aAnimPolyPoly;
//STRIP001 			const Animation		aAnim( rGraphic.GetAnimation() );
//STRIP001 			const Size&			rSizePix = aAnim.GetDisplaySizePixel();
//STRIP001 			const USHORT		nCount = aAnim.Count();
//STRIP001 
//STRIP001 			if ( aVDev.SetOutputSizePixel( rSizePix ) )
//STRIP001 			{
//STRIP001 				aVDev.SetLineColor( Color( COL_BLACK ) );
//STRIP001 				aVDev.SetFillColor( Color( COL_BLACK ) );
//STRIP001 
//STRIP001 				for( USHORT i = 0; i < nCount; i++ )
//STRIP001 				{
//STRIP001 					const AnimationBitmap& rStepBmp = aAnim.Get( i );
//STRIP001 
//STRIP001 					// Polygonausgabe an die richtige Stelle schieben;
//STRIP001 					// dies ist der Offset des Teilbildes innerhalb
//STRIP001 					// der Gesamtanimation
//STRIP001 					aTransMap.SetOrigin( Point( rStepBmp.aPosPix.X(), rStepBmp.aPosPix.Y() ) );
//STRIP001 					aVDev.SetMapMode( aTransMap );
//STRIP001 					aVDev.DrawPolyPolygon( CreateAutoContour( rStepBmp.aBmpEx, pRect, nFlags ) );
//STRIP001 				}
//STRIP001 
//STRIP001 				aTransMap.SetOrigin( Point() );
//STRIP001 				aVDev.SetMapMode( aTransMap );
//STRIP001 				aBmp = aVDev.GetBitmap( Point(), rSizePix );
//STRIP001 				aBmp.Convert( BMP_CONVERSION_1BIT_THRESHOLD );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( rGraphic.IsTransparent() )
//STRIP001 			aBmp = rGraphic.GetBitmapEx().GetMask();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBmp = rGraphic.GetBitmap();
//STRIP001 			nContourFlags |= XOUTBMP_CONTOUR_EDGEDETECT;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( rGraphic.GetType() != GRAPHIC_NONE )
//STRIP001 	{
//STRIP001         const Graphic   aTmpGrf( rGraphic.GetGDIMetaFile().GetMonochromeMtf( Color( COL_BLACK ) ) );
//STRIP001         VirtualDevice	aVDev;
//STRIP001         Size			aSizePix( aVDev.LogicToPixel( aTmpGrf.GetPrefSize(), aTmpGrf.GetPrefMapMode() ) );
//STRIP001 
//STRIP001 		if( aSizePix.Width() && aSizePix.Height() && ( aSizePix.Width() > 512 || aSizePix.Height() > 512 ) )
//STRIP001 		{
//STRIP001 			double fWH = (double) aSizePix.Width() / aSizePix.Height();
//STRIP001 
//STRIP001 			if( fWH <= 1.0 )
//STRIP001 				aSizePix.Width() = FRound( ( aSizePix.Height() = 512 ) * fWH );
//STRIP001 			else
//STRIP001 				aSizePix.Height() = FRound( ( aSizePix.Width() = 512 ) / fWH );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aVDev.SetOutputSizePixel( aSizePix ) )
//STRIP001         {
//STRIP001 			const Point aPt;
//STRIP001             aTmpGrf.Draw( &aVDev, aPt, aSizePix );
//STRIP001             aBmp = aVDev.GetBitmap( aPt, aSizePix );
//STRIP001         }
//STRIP001 
//STRIP001 		nContourFlags |= XOUTBMP_CONTOUR_EDGEDETECT;
//STRIP001 	}
//STRIP001 
//STRIP001 	aBmp.SetPrefSize( rGraphic.GetPrefSize() );
//STRIP001 	aBmp.SetPrefMapMode( rGraphic.GetPrefMapMode() );
//STRIP001 
//STRIP001 	return PolyPolygon( XOutBitmap::GetCountour( aBmp, nContourFlags, 128, pRect ) );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxContourDlg::ScaleContour( PolyPolygon& rContour, const Graphic& rGraphic,
//STRIP001 								  const MapUnit eUnit, const Size& rDisplaySize )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rGraphic.GetType() != GRAPHIC_NONE, "Graphic is not valid!" );
//STRIP001 
//STRIP001 	OutputDevice*	pOutDev = Application::GetDefaultDevice();
//STRIP001 	const MapMode	aDispMap( eUnit );
//STRIP001 	const MapMode	aGrfMap( rGraphic.GetPrefMapMode() );
//STRIP001 	const Size		aGrfSize( rGraphic.GetPrefSize() );
//STRIP001 	double			fScaleX;
//STRIP001 	double			fScaleY;
//STRIP001 	Size			aOrgSize;
//STRIP001 	Point			aNewPoint;
//STRIP001 	BOOL			bPixelMap = aGrfMap.GetMapUnit() == MAP_PIXEL;
//STRIP001 
//STRIP001 	if ( bPixelMap )
//STRIP001 		aOrgSize = pOutDev->PixelToLogic( aGrfSize, aDispMap );
//STRIP001 	else
//STRIP001 		aOrgSize = pOutDev->LogicToLogic( aGrfSize, aGrfMap, aDispMap );
//STRIP001 
//STRIP001 	if ( aOrgSize.Width() && aOrgSize.Height() )
//STRIP001 	{
//STRIP001 		fScaleX = (double) rDisplaySize.Width() / aOrgSize.Width();
//STRIP001 		fScaleY = (double) rDisplaySize.Height() / aOrgSize.Height();
//STRIP001 
//STRIP001 		for ( USHORT j = 0, nPolyCount = rContour.Count(); j < nPolyCount; j++ )
//STRIP001 		{
//STRIP001 			Polygon& rPoly = rContour[ j ];
//STRIP001 
//STRIP001 			for ( USHORT i = 0, nCount = rPoly.GetSize(); i < nCount; i++ )
//STRIP001 			{
//STRIP001 				if ( bPixelMap )
//STRIP001 					aNewPoint = pOutDev->PixelToLogic( rPoly[ i ], aDispMap  );
//STRIP001 				else
//STRIP001 					aNewPoint = pOutDev->LogicToLogic( rPoly[ i ], aGrfMap, aDispMap  );
//STRIP001 
//STRIP001 				rPoly[ i ] = Point( FRound( aNewPoint.X() * fScaleX ), FRound( aNewPoint.Y() * fScaleY ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Durchschleifen an SuperClass; keine virt. Methoden, um
|* bei IF-Aenderungen nicht inkompatibel zu werden
|*
\************************************************************************/

//STRIP001 void SvxContourDlg::SetExecState( BOOL bEnable )
//STRIP001 {
//STRIP001 	pSuperClass->SetExecState( bEnable );
//STRIP001 }

//STRIP001 void SvxContourDlg::SetGraphic( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	pSuperClass->SetGraphic( rGraphic );
//STRIP001 }

//STRIP001 void SvxContourDlg::SetGraphicLinked( BOOL bGraphicLinked )
//STRIP001 {
//STRIP001 	pSuperClass->SetGraphicLinked( bGraphicLinked );
//STRIP001 }

//STRIP001 const Graphic& SvxContourDlg::GetGraphic() const
//STRIP001 {
//STRIP001 	return pSuperClass->GetGraphic();
//STRIP001 }

//STRIP001 BOOL SvxContourDlg::IsGraphicChanged() const
//STRIP001 {
//STRIP001 	return pSuperClass->IsGraphicChanged();
//STRIP001 }

//STRIP001 void SvxContourDlg::SetPolyPolygon( const PolyPolygon& rPolyPoly )
//STRIP001 {
//STRIP001 	pSuperClass->SetPolyPolygon( rPolyPoly );
//STRIP001 }

//STRIP001 PolyPolygon SvxContourDlg::GetPolyPolygon()
//STRIP001 {
//STRIP001 	return pSuperClass->GetPolyPolygon( TRUE );
//STRIP001 }

//STRIP001 void SvxContourDlg::SetEditingObject( void* pObj )
//STRIP001 {
//STRIP001 	pSuperClass->SetEditingObject( pObj );
//STRIP001 }

//STRIP001 const void* SvxContourDlg::GetEditingObject() const
//STRIP001 {
//STRIP001 	return pSuperClass->GetEditingObject();
//STRIP001 }

//STRIP001 void SvxContourDlg::Update( const Graphic& rGraphic, BOOL bGraphicLinked,
//STRIP001 							const PolyPolygon* pPolyPoly, void* pEditingObj )
//STRIP001 {
//STRIP001 	pSuperClass->Update( rGraphic, bGraphicLinked, pPolyPoly, pEditingObj );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SvxSuperContourDlg::SvxSuperContourDlg( SfxBindings *pBindings, SfxChildWindow *pCW,
//STRIP001 										Window* pParent, const ResId& rResId ) :
//STRIP001 		SvxContourDlg		( pBindings, pCW, pParent, rResId ),
//STRIP001 		aContourItem		( SID_CONTOUR_EXEC, *this, *pBindings ),
//STRIP001 		aTbx1				( this, ResId( TBX1 ) ),
//STRIP001 		aMtfTolerance		( this, ResId( MTF_TOLERANCE ) ),
//STRIP001 		aContourWnd			( this, ResId( CTL_CONTOUR) ),
//STRIP001 		aStbStatus			( this, WB_BORDER | WB_3DLOOK | WB_LEFT ),
//STRIP001 		nGrfChanged			( 0UL ),
//STRIP001 		pCheckObj			( NULL ),
//STRIP001 		bExecState			( FALSE ),
//STRIP001 		bGraphicLinked		( FALSE ),
//STRIP001 		maImageList			( SVX_RES( CD_IMAPDLG ) ),
//STRIP001 		maImageListH		( SVX_RES( CDH_IMAPDLG ) )
//STRIP001 {
//STRIP001 	ApplyImageList();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SvxContourDlg::SetSuperClass( *this );
//STRIP001 
//STRIP001 	aContourWnd.SetMousePosLink( LINK( this, SvxSuperContourDlg, MousePosHdl ) );
//STRIP001 	aContourWnd.SetGraphSizeLink( LINK( this, SvxSuperContourDlg, GraphSizeHdl ) );
//STRIP001 	aContourWnd.SetUpdateLink( LINK( this, SvxSuperContourDlg, StateHdl ) );
//STRIP001 	aContourWnd.SetPipetteHdl( LINK( this, SvxSuperContourDlg, PipetteHdl ) );
//STRIP001 	aContourWnd.SetPipetteClickHdl( LINK( this, SvxSuperContourDlg, PipetteClickHdl ) );
//STRIP001 	aContourWnd.SetWorkplaceClickHdl( LINK( this, SvxSuperContourDlg, WorkplaceClickHdl ) );
//STRIP001 
//STRIP001 	const Size	    aTbxSize( aTbx1.CalcWindowSizePixel() );
//STRIP001 	Point		    aPos( aTbx1.GetPosPixel() );
//STRIP001   	SvtMiscOptions  aMiscOptions;
//STRIP001 
//STRIP001     aMiscOptions.AddListener( LINK( this, SvxSuperContourDlg, MiscHdl ) );
//STRIP001 
//STRIP001     aTbx1.SetOutStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 	aTbx1.SetSizePixel( aTbxSize );
//STRIP001 	aTbx1.SetSelectHdl( LINK( this, SvxSuperContourDlg, Tbx1ClickHdl ) );
//STRIP001 
//STRIP001 	aPos.X() += aTbxSize.Width() + LogicToPixel( Size( 3, 0 ), MapMode( MAP_APPFONT ) ).Width();
//STRIP001 	aMtfTolerance.SetPosPixel( aPos );
//STRIP001 	aMtfTolerance.SetValue( 10L );
//STRIP001 
//STRIP001 	SetMinOutputSizePixel( aLastSize = GetOutputSizePixel() );
//STRIP001 
//STRIP001 	aStbStatus.InsertItem( 1, 130, SIB_LEFT | SIB_IN | SIB_AUTOSIZE );
//STRIP001 	aStbStatus.InsertItem( 2, 10 + GetTextWidth( String::CreateFromAscii( " 9999,99 cm / 9999,99 cm " ) ), SIB_CENTER | SIB_IN );
//STRIP001 	aStbStatus.InsertItem( 3, 10 + GetTextWidth( String::CreateFromAscii( " 9999,99 cm x 9999,99 cm " ) ), SIB_CENTER | SIB_IN );
//STRIP001 	aStbStatus.InsertItem( 4, 20, SIB_CENTER | SIB_IN );
//STRIP001 
//STRIP001 	Resize();
//STRIP001 
//STRIP001 	aUpdateTimer.SetTimeout( 100 );
//STRIP001 	aUpdateTimer.SetTimeoutHdl( LINK( this, SvxSuperContourDlg, UpdateHdl ) );
//STRIP001 
//STRIP001 	aCreateTimer.SetTimeout( 50 );
//STRIP001 	aCreateTimer.SetTimeoutHdl( LINK( this, SvxSuperContourDlg, CreateHdl ) );
//STRIP001 }


/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//STRIP001 SvxSuperContourDlg::~SvxSuperContourDlg()
//STRIP001 {
//STRIP001 }


/*************************************************************************
|*
|* Resize-Methode
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::Resize()
//STRIP001 {
//STRIP001 	SfxFloatingWindow::Resize();
//STRIP001 
//STRIP001 	Size aMinSize( GetMinOutputSizePixel() );
//STRIP001 	Size aNewSize( GetOutputSizePixel() );
//STRIP001 
//STRIP001 	if ( aNewSize.Height() >= aMinSize.Height() )
//STRIP001 	{
//STRIP001 		Size	aSize( aStbStatus.GetSizePixel() );
//STRIP001 		Point	aPoint( 0, aNewSize.Height() - aSize.Height() );
//STRIP001 
//STRIP001 		// StatusBar positionieren
//STRIP001 		aStbStatus.SetPosSizePixel( aPoint, Size( aNewSize.Width(), aSize.Height() ) );
//STRIP001 		aStbStatus.Show();
//STRIP001 
//STRIP001 		// EditWindow positionieren
//STRIP001 		aSize.Width() = aNewSize.Width() - 18;
//STRIP001 		aSize.Height() = aPoint.Y() - aContourWnd.GetPosPixel().Y() - 6;
//STRIP001 		aContourWnd.SetSizePixel( aSize );
//STRIP001 
//STRIP001 		aLastSize = aNewSize;
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Close-Methode
|*
\************************************************************************/

//STRIP001 BOOL SvxSuperContourDlg::Close()
//STRIP001 {
//STRIP001 	BOOL bRet = TRUE;
//STRIP001 
//STRIP001 	if ( aTbx1.IsItemEnabled( TBI_APPLY ) )
//STRIP001 	{
//STRIP001 		QueryBox	aQBox( this, WB_YES_NO_CANCEL | WB_DEF_YES,
//STRIP001 						   String( CONT_RESID( STR_CONTOURDLG_MODIFY ) ) );
//STRIP001 		const long	nRet = aQBox.Execute();
//STRIP001 
//STRIP001 		if ( nRet == RET_YES )
//STRIP001 		{
//STRIP001 			SfxBoolItem aBoolItem( SID_CONTOUR_EXEC, TRUE );
//STRIP001 			GetBindings().GetDispatcher()->Execute(
//STRIP001 				SID_CONTOUR_EXEC, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aBoolItem, 0L );
//STRIP001 		}
//STRIP001 		else if ( nRet == RET_CANCEL )
//STRIP001 			bRet = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bRet ? SfxFloatingWindow::Close() : FALSE );
//STRIP001 }


/*************************************************************************
|*
|* Enabled oder disabled alle Controls
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::SetExecState( BOOL bEnable )
//STRIP001 {
//STRIP001 	bExecState = bEnable;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::SetGraphic( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	aUndoGraphic = aRedoGraphic = Graphic();
//STRIP001 	aGraphic = rGraphic;
//STRIP001 	nGrfChanged = 0UL;
//STRIP001 	aContourWnd.SetGraphic( aGraphic );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::SetPolyPolygon( const PolyPolygon& rPolyPoly )
//STRIP001 {
//STRIP001 	DBG_ASSERT(  aContourWnd.GetGraphic().GetType() != GRAPHIC_NONE, "Graphic must've been set first!" );
//STRIP001 
//STRIP001 	PolyPolygon		aPolyPoly( rPolyPoly );
//STRIP001 	const MapMode	aMap100( MAP_100TH_MM );
//STRIP001 	const MapMode	aGrfMap( aGraphic.GetPrefMapMode() );
//STRIP001 	OutputDevice*	pOutDev = Application::GetDefaultDevice();
//STRIP001 	BOOL			bPixelMap = aGrfMap.GetMapUnit() == MAP_PIXEL;
//STRIP001 
//STRIP001 	for ( USHORT j = 0, nPolyCount = aPolyPoly.Count(); j < nPolyCount; j++ )
//STRIP001 	{
//STRIP001 		Polygon& rPoly = aPolyPoly[ j ];
//STRIP001 
//STRIP001 		for ( USHORT i = 0, nCount = rPoly.GetSize(); i < nCount; i++ )
//STRIP001 		{
//STRIP001 			Point& rPt = rPoly[ i ];
//STRIP001 
//STRIP001 			if ( !bPixelMap )
//STRIP001 				rPt = pOutDev->LogicToPixel( rPt, aGrfMap );
//STRIP001 
//STRIP001 			rPt = pOutDev->PixelToLogic( rPt, aMap100 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aContourWnd.SetPolyPolygon( aPolyPoly );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 PolyPolygon SvxSuperContourDlg::GetPolyPolygon( BOOL bRescaleToGraphic )
//STRIP001 {
//STRIP001 	PolyPolygon	aRetPolyPoly( aContourWnd.GetPolyPolygon() );
//STRIP001 
//STRIP001 	if ( bRescaleToGraphic )
//STRIP001 	{
//STRIP001 		const MapMode	aMap100( MAP_100TH_MM );
//STRIP001 		const MapMode	aGrfMap( aGraphic.GetPrefMapMode() );
//STRIP001 		OutputDevice*	pOutDev = Application::GetDefaultDevice();
//STRIP001 		BOOL			bPixelMap = aGrfMap.GetMapUnit() == MAP_PIXEL;
//STRIP001 
//STRIP001 		for ( USHORT j = 0, nPolyCount = aRetPolyPoly.Count(); j < nPolyCount; j++ )
//STRIP001 		{
//STRIP001 			Polygon& rPoly = aRetPolyPoly[ j ];
//STRIP001 
//STRIP001 			for ( USHORT i = 0, nCount = rPoly.GetSize(); i < nCount; i++ )
//STRIP001 			{
//STRIP001 				Point& rPt = rPoly[ i ];
//STRIP001 
//STRIP001 				rPt = pOutDev->LogicToPixel( rPt, aMap100  );
//STRIP001 
//STRIP001 				if ( !bPixelMap )
//STRIP001 					rPt = pOutDev->PixelToLogic( rPt, aGrfMap  );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aRetPolyPoly;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::Update( const Graphic& rGraphic, BOOL bGraphicLinked,
//STRIP001 								 const PolyPolygon* pPolyPoly, void* pEditingObj )
//STRIP001 {
//STRIP001 	aUpdateGraphic = rGraphic;
//STRIP001 	bUpdateGraphicLinked = bGraphicLinked;
//STRIP001 	pUpdateEditingObject = pEditingObj;
//STRIP001 
//STRIP001 	if ( pPolyPoly )
//STRIP001 		aUpdatePolyPoly = *pPolyPoly;
//STRIP001 	else
//STRIP001 		aUpdatePolyPoly = PolyPolygon();
//STRIP001 
//STRIP001 	aUpdateTimer.Start();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 BOOL SvxSuperContourDlg::IsUndoPossible() const
//STRIP001 {
//STRIP001 	return aUndoGraphic.GetType() != GRAPHIC_NONE;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 BOOL SvxSuperContourDlg::IsRedoPossible() const
//STRIP001 {
//STRIP001 	return aRedoGraphic.GetType() != GRAPHIC_NONE;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::DoAutoCreate()
//STRIP001 {
//STRIP001 	aCreateTimer.Start();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxSuperContourDlg::ReducePoints( const long nTol )
//STRIP001 {
//STRIP001 	PolyPolygon aPolyPoly( GetPolyPolygon( FALSE ) );
//STRIP001 
//STRIP001 	if ( aPolyPoly.Count() )
//STRIP001 	{
//STRIP001 		const MapMode	aMapMode( MAP_100TH_MM );
//STRIP001 		const long		nTol2 = nTol * nTol;
//STRIP001 		Polygon&		rPoly = aPolyPoly[ 0 ];
//STRIP001 		OutputDevice*	pOutDev = Application::GetDefaultDevice();
//STRIP001 		Point			aPtPix;
//STRIP001 		const USHORT	nSize = rPoly.GetSize();
//STRIP001 		USHORT			nCounter = 0;
//STRIP001 
//STRIP001 		if ( nSize )
//STRIP001 			aPtPix = pOutDev->LogicToPixel( rPoly[ 0 ], aMapMode );
//STRIP001 
//STRIP001 		for( USHORT i = 1; i < nSize; i++ )
//STRIP001 		{
//STRIP001 			const Point&	rNewPt = rPoly[ i ];
//STRIP001 			const Point		aNewPtPix( pOutDev->LogicToPixel( rNewPt, aMapMode ) );
//STRIP001 
//STRIP001 			const long nDistX = aNewPtPix.X() - aPtPix.X();
//STRIP001 			const long nDistY = aNewPtPix.Y() - aPtPix.Y();
//STRIP001 
//STRIP001 			if( ( nDistX * nDistX + nDistY * nDistY ) >= nTol2 )
//STRIP001 			{
//STRIP001 				rPoly[ ++nCounter ] = rNewPt;
//STRIP001 				aPtPix = aNewPtPix;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		rPoly.SetSize( nCounter );
//STRIP001 		aContourWnd.SetPolyPolygon( aPolyPoly );
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Click-Hdl fuer ToolBox
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, Tbx1ClickHdl, ToolBox*, pTbx )
//STRIP001 {
//STRIP001 	USHORT nNewItemId = pTbx->GetCurItemId();
//STRIP001 
//STRIP001 	switch( pTbx->GetCurItemId() )
//STRIP001 	{
//STRIP001 		case( TBI_APPLY ):
//STRIP001 		{
//STRIP001 			SfxBoolItem aBoolItem( SID_CONTOUR_EXEC, TRUE );
//STRIP001 			GetBindings().GetDispatcher()->Execute(
//STRIP001 				SID_CONTOUR_EXEC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aBoolItem, 0L );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_WORKPLACE ):
//STRIP001 		{
//STRIP001 			if ( aTbx1.IsItemChecked( TBI_WORKPLACE ) )
//STRIP001 			{
//STRIP001 				QueryBox aQBox( this, WB_YES_NO | WB_DEF_NO, String( CONT_RESID( STR_CONTOURDLG_WORKPLACE ) ) );
//STRIP001 
//STRIP001 				if ( !aContourWnd.IsContourChanged() || ( aQBox.Execute() == RET_YES ) )
//STRIP001 					aContourWnd.SetWorkplaceMode( TRUE );
//STRIP001 				else
//STRIP001 					aTbx1.CheckItem( TBI_WORKPLACE, FALSE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aContourWnd.SetWorkplaceMode( FALSE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_SELECT ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			aContourWnd.SetEditMode( TRUE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_RECT ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			aContourWnd.SetObjKind( OBJ_RECT );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_CIRCLE ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			aContourWnd.SetObjKind( OBJ_CIRC );
//STRIP001 
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLY ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			aContourWnd.SetObjKind( OBJ_POLY );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_FREEPOLY ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			aContourWnd.SetObjKind( OBJ_FREEFILL );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYEDIT ):
//STRIP001 			aContourWnd.SetPolyEditMode( pTbx->IsItemChecked( TBI_POLYEDIT ) ? SID_BEZIER_MOVE : 0 );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYMOVE ):
//STRIP001 			aContourWnd.SetPolyEditMode( SID_BEZIER_MOVE );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYINSERT ):
//STRIP001 			aContourWnd.SetPolyEditMode( SID_BEZIER_INSERT );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYDELETE ):
//STRIP001 			aContourWnd.GetSdrView()->DeleteMarkedPoints();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_UNDO ):
//STRIP001 		{
//STRIP001 			nGrfChanged = nGrfChanged ? nGrfChanged-- : 0UL;
//STRIP001 			aRedoGraphic = aGraphic;
//STRIP001 			aGraphic = aUndoGraphic;
//STRIP001 			aUndoGraphic = Graphic();
//STRIP001 			aContourWnd.SetGraphic( aGraphic, FALSE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_REDO ):
//STRIP001 		{
//STRIP001 			nGrfChanged++;
//STRIP001 			aUndoGraphic = aGraphic;
//STRIP001 			aGraphic = aRedoGraphic;
//STRIP001 			aRedoGraphic = Graphic();
//STRIP001 			aContourWnd.SetGraphic( aGraphic, FALSE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_AUTOCONTOUR ):
//STRIP001 			aCreateTimer.Start();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_PIPETTE ):
//STRIP001 		{
//STRIP001 			BOOL bPipette = aTbx1.IsItemChecked( TBI_PIPETTE );
//STRIP001 
//STRIP001 			if ( !bPipette )
//STRIP001 				aStbStatus.Invalidate();
//STRIP001 			else if ( bGraphicLinked )
//STRIP001 			{
//STRIP001 				QueryBox aQBox( this, WB_YES_NO | WB_DEF_YES, String( CONT_RESID( STR_CONTOURDLG_LINKED ) ) );
//STRIP001 
//STRIP001 				if ( aQBox.Execute() != RET_YES )
//STRIP001 				{
//STRIP001 					aTbx1.CheckItem( TBI_PIPETTE, bPipette = FALSE );
//STRIP001 					aStbStatus.Invalidate();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			aContourWnd.SetPipetteMode( bPipette );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, MousePosHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	const FieldUnit eFieldUnit = GetModuleFieldUnit();
//STRIP001 	const Point& rMousePos = pWnd->GetMousePos();
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const sal_Unicode cSep = aLocaleWrapper.getNumDecimalSep().GetChar(0);
//STRIP001 
//STRIP001 	aStr.Assign( GetUnitString( rMousePos.X(), eFieldUnit, cSep ) );
//STRIP001 	aStr.Append( String::CreateFromAscii( " / " ) );
//STRIP001 	aStr.Append( GetUnitString( rMousePos.Y(), eFieldUnit, cSep ) );
//STRIP001 
//STRIP001 	aStbStatus.SetItemText( 2, aStr );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, GraphSizeHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	const FieldUnit eFieldUnit = GetModuleFieldUnit();
//STRIP001 	const Size& rSize = pWnd->GetGraphicSize();
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const sal_Unicode cSep = aLocaleWrapper.getNumDecimalSep().GetChar(0);
//STRIP001 
//STRIP001 	aStr.Assign( GetUnitString( rSize.Width(), eFieldUnit, cSep ) );
//STRIP001 	aStr.Append( String::CreateFromAscii( " x " ) );
//STRIP001 	aStr.Append( GetUnitString( rSize.Height(), eFieldUnit, cSep ) );
//STRIP001 
//STRIP001 	aStbStatus.SetItemText( 3, aStr );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, UpdateHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	aUpdateTimer.Stop();
//STRIP001 
//STRIP001 	if ( pUpdateEditingObject != pCheckObj )
//STRIP001 	{
//STRIP001 		if( !GetEditingObject() )
//STRIP001 			aContourWnd.GrabFocus();
//STRIP001 
//STRIP001 		SetGraphic( aUpdateGraphic );
//STRIP001 		SetPolyPolygon( aUpdatePolyPoly );
//STRIP001 		SetEditingObject( pUpdateEditingObject );
//STRIP001 		bGraphicLinked = bUpdateGraphicLinked;
//STRIP001 
//STRIP001 		aUpdateGraphic = Graphic();
//STRIP001 		aUpdatePolyPoly = PolyPolygon();
//STRIP001 		bUpdateGraphicLinked = FALSE;
//STRIP001 
//STRIP001 		aContourWnd.GetSdrModel()->SetChanged( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	GetBindings().Invalidate( SID_CONTOUR_EXEC );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, CreateHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	aCreateTimer.Stop();
//STRIP001 
//STRIP001 	const Rectangle	aWorkRect = aContourWnd.LogicToPixel( aContourWnd.GetWorkRect(), MapMode( MAP_100TH_MM ) );
//STRIP001 	const Graphic&	rGraphic = aContourWnd.GetGraphic();
//STRIP001 	const BOOL		bValid = aWorkRect.Left() != aWorkRect.Right() && aWorkRect.Top() != aWorkRect.Bottom();
//STRIP001 
//STRIP001 	EnterWait();
//STRIP001 	SetPolyPolygon( CreateAutoContour( rGraphic, bValid ? &aWorkRect : NULL ) );
//STRIP001 	LeaveWait();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, StateHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	const SdrObject*	pObj = pWnd->GetSelectedSdrObject();
//STRIP001 	const SdrView*		pView = pWnd->GetSdrView();
//STRIP001 	const BOOL			bPolyEdit = ( pObj != NULL ) && pObj->ISA( SdrPathObj );
//STRIP001 	const BOOL			bDrawEnabled = !( bPolyEdit && aTbx1.IsItemChecked( TBI_POLYEDIT ) );
//STRIP001 	const BOOL			bPipette = aTbx1.IsItemChecked( TBI_PIPETTE );
//STRIP001 	const BOOL			bWorkplace = aTbx1.IsItemChecked( TBI_WORKPLACE );
//STRIP001 	const BOOL			bDontHide = !( bPipette || bWorkplace );
//STRIP001 	const BOOL			bBitmap = pWnd->GetGraphic().GetType() == GRAPHIC_BITMAP;
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_APPLY, bDontHide && bExecState && pWnd->IsChanged() );
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_WORKPLACE, !bPipette && bDrawEnabled );
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_SELECT, bDontHide && bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_RECT, bDontHide && bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_CIRCLE, bDontHide && bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_POLY, bDontHide && bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_FREEPOLY, bDontHide && bDrawEnabled );
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_POLYEDIT, bDontHide && bPolyEdit );
//STRIP001 	aTbx1.EnableItem( TBI_POLYMOVE, bDontHide && !bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_POLYINSERT, bDontHide && !bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_POLYDELETE, bDontHide && !bDrawEnabled && pView->IsDeleteMarkedPointsPossible() );
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_AUTOCONTOUR, bDontHide && bDrawEnabled );
//STRIP001 	aTbx1.EnableItem( TBI_PIPETTE, !bWorkplace && bDrawEnabled && bBitmap );
//STRIP001 
//STRIP001 	aTbx1.EnableItem( TBI_UNDO, bDontHide && IsUndoPossible() );
//STRIP001 	aTbx1.EnableItem( TBI_REDO, bDontHide && IsRedoPossible() );
//STRIP001 
//STRIP001 	if ( bPolyEdit )
//STRIP001 	{
//STRIP001 		USHORT nId = 0;
//STRIP001 
//STRIP001 		switch( pWnd->GetPolyEditMode() )
//STRIP001 		{
//STRIP001 			case( SID_BEZIER_MOVE ): nId = TBI_POLYMOVE; break;
//STRIP001 			case( SID_BEZIER_INSERT ): nId = TBI_POLYINSERT; break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		aTbx1.CheckItem( nId, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTbx1.CheckItem( TBI_POLYEDIT, FALSE );
//STRIP001 		aTbx1.CheckItem( TBI_POLYMOVE, TRUE );
//STRIP001 		aTbx1.CheckItem( TBI_POLYINSERT, FALSE );
//STRIP001 		pWnd->SetPolyEditMode( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, PipetteHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	const Color& rOldLineColor = aStbStatus.GetLineColor();
//STRIP001 	const Color& rOldFillColor = aStbStatus.GetFillColor();
//STRIP001 
//STRIP001 	Rectangle		aRect( aStbStatus.GetItemRect( 4 ) );
//STRIP001 	const Color&	rColor = pWnd->GetPipetteColor();
//STRIP001 
//STRIP001 	aStbStatus.SetLineColor( rColor );
//STRIP001 	aStbStatus.SetFillColor( rColor );
//STRIP001 
//STRIP001 	aRect.Left() += 4;
//STRIP001 	aRect.Top() += 4;
//STRIP001 	aRect.Right() -= 4;
//STRIP001 	aRect.Bottom() -= 4;
//STRIP001 
//STRIP001 	aStbStatus.DrawRect( aRect );
//STRIP001 
//STRIP001 	aStbStatus.SetLineColor( rOldLineColor );
//STRIP001 	aStbStatus.SetFillColor( rOldFillColor );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, PipetteClickHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	if ( pWnd->IsClickValid() )
//STRIP001 	{
//STRIP001 		Bitmap			aMask;
//STRIP001 		const Color&	rColor = pWnd->GetPipetteColor();
//STRIP001 		Bitmap*			pMask = NULL;
//STRIP001 
//STRIP001 		EnterWait();
//STRIP001 
//STRIP001 		if( aGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 		{
//STRIP001 			Bitmap		aBmp( aGraphic.GetBitmap() );
//STRIP001 			const long	nTol = aMtfTolerance.GetValue() * 255L / 100L;
//STRIP001 
//STRIP001 			aMask = aBmp.CreateMask( rColor, nTol );
//STRIP001 
//STRIP001 			if( aGraphic.IsTransparent() )
//STRIP001 				aMask.CombineSimple( aGraphic.GetBitmapEx().GetMask(), BMP_COMBINE_OR );
//STRIP001 
//STRIP001 			if( !!aMask )
//STRIP001 			{
//STRIP001 				QueryBox	aQBox( this, WB_YES_NO | WB_DEF_YES, String( CONT_RESID( STR_CONTOURDLG_NEWPIPETTE ) ) );
//STRIP001 				BOOL		bNewContour;
//STRIP001 
//STRIP001 				aRedoGraphic = Graphic();
//STRIP001 				aUndoGraphic = aGraphic;
//STRIP001 				aGraphic = Graphic( BitmapEx( aBmp, aMask ) );
//STRIP001 				nGrfChanged++;
//STRIP001 
//STRIP001 				bNewContour = ( aQBox.Execute() == RET_YES );
//STRIP001 				pWnd->SetGraphic( aGraphic, bNewContour );
//STRIP001 
//STRIP001 				if( bNewContour )
//STRIP001 					aCreateTimer.Start();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 	aTbx1.CheckItem( TBI_PIPETTE, FALSE );
//STRIP001 	pWnd->SetPipetteMode( FALSE );
//STRIP001 	aStbStatus.Invalidate();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, WorkplaceClickHdl, ContourWindow*, pWnd )
//STRIP001 {
//STRIP001 	aTbx1.CheckItem( TBI_WORKPLACE, FALSE );
//STRIP001 	aTbx1.CheckItem( TBI_SELECT, TRUE );
//STRIP001 	pWnd->SetWorkplaceMode( FALSE );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//STRIP001 void SvxSuperContourDlg::ApplyImageList()
//STRIP001 {
//STRIP001 	bool bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 
//STRIP001     ImageList& rImgLst = bHighContrast ? maImageListH : maImageList;
//STRIP001 
//STRIP001 	aTbx1.SetImageList( rImgLst );
//STRIP001 }

//STRIP001 void SvxSuperContourDlg::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxFloatingWindow::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxSuperContourDlg, MiscHdl, void*, p )
//STRIP001 {
//STRIP001    	SvtMiscOptions aMiscOptions;
//STRIP001     aTbx1.SetOutStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 
//STRIP001     return 0L;
//STRIP001 }

}
