/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmctrler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:41:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#define USE_PROPERTY_HELPER

#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _SVX_FMCTRLER_HXX
#include "fmctrler.hxx"
#endif
// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
// auto strip #ifndef _SVX_FMURL_HXX
// auto strip #include "fmurl.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include "fmshell.hxx"
// auto strip #endif
// auto strip #ifndef SVX_FORM_CONFIRMDELETE_HXX
// auto strip #include "confirmdelete.hxx"
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
// auto strip #include <com/sun/star/beans/NamedValue.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_ROWCHANGEACTION_HPP_
// auto strip #include <com/sun/star/sdb/RowChangeAction.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_COLUMNVALUE_HPP_
// auto strip #include <com/sun/star/sdbc/ColumnValue.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
#include <com/sun/star/form/XLoadable.hpp>
#endif

// auto strip #ifndef _COM_SUN_STAR_AWT_XCOMBOBOX_HPP_
// auto strip #include <com/sun/star/awt/XComboBox.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XCHECKBOX_HPP_
// auto strip #include <com/sun/star/awt/XCheckBox.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XLISTBOX_HPP_
// auto strip #include <com/sun/star/awt/XListBox.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_FOCUSCHANGEREASON_HPP_
// auto strip #include <com/sun/star/awt/FocusChangeReason.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif


#ifndef _COM_SUN_STAR_FORM_XRESET_HPP_
#include <com/sun/star/form/XReset.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_FORM_TABULATORCYCLE_HPP_
// auto strip #include <com/sun/star/form/TabulatorCycle.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XBOUNDCONTROL_HPP_
// auto strip #include <com/sun/star/form/XBoundControl.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
// auto strip #include <com/sun/star/beans/PropertyAttribute.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XVCLWINDOWPEER_HPP_
// auto strip #include <com/sun/star/awt/XVclWindowPeer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HPP_
// auto strip #include <com/sun/star/form/XBoundComponent.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_SDB_XINTERACTIONSUPPLYPARAMETERS_HPP_
#include <com/sun/star/sdb/XInteractionSupplyParameters.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_SDB_PARAMETERSREQUEST_HPP_
// auto strip #include <com/sun/star/sdb/ParametersRequest.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
// auto strip #include <com/sun/star/task/XInteractionHandler.hpp>
// auto strip #endif

// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif

// auto strip #ifndef _SV_SVAPP_HXX //autogen
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <svdpagv.hxx>
// auto strip #endif

#ifndef _SVX_FMSHIMP_HXX
#include <fmshimp.hxx>
#endif

// auto strip #ifndef _SVX_FMVIEW_HXX
// auto strip #include <fmview.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen wg. RET_YES
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFX_BINDINGS_HXX
#include <bf_sfx2/bindings.hxx>
#endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_DIALMGR_HXX
// auto strip #include "dialmgr.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMPROP_HXX
// auto strip #include "fmprop.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include "fmservs.hxx"
// auto strip #endif

// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_UNO3_HXX_
// auto strip #include <comphelper/uno3.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROPERTY_AGGREGATION_HXX_
// auto strip #include <comphelper/propagg.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_ENUMHELPER_HXX_
// auto strip #include <comphelper/enumhelper.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_SEQUENCE_HXX_
// auto strip #include <comphelper/sequence.hxx>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
// auto strip #include <cppuhelper/queryinterface.hxx>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
// auto strip #include <cppuhelper/typeprovider.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_EXTRACT_HXX_
// auto strip #include <comphelper/extract.hxx>
// auto strip #endif
// auto strip #ifndef _TOOLKIT_UNOHLP_HXX
// auto strip #include <toolkit/helper/vclunohelper.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_SEQUENCE_HXX_
// auto strip #include <comphelper/sequence.hxx>
// auto strip #endif
#ifndef _COMPHELPER_INTERACTION_HXX_
#include <comphelper/interaction.hxx>
#endif
#ifndef _TOOLKIT_CONTROLS_UNOCONTROL_HXX_
#include <toolkit/controls/unocontrol.hxx>
#endif

#ifndef _COMPHELPER_CONTAINER_HXX_
#include <comphelper/container.hxx>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::comphelper;
using namespace ::connectivity;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::connectivity::simple;

extern sal_uInt16 AutoSlotMap[];

//==================================================================
// FmXAutoControl
//==================================================================
class OParameterContinuation : public OInteraction< XInteractionSupplyParameters >
{
    Sequence< PropertyValue >       m_aValues;

public:
    OParameterContinuation() { }

//STRIP001     Sequence< PropertyValue >   getValues() const { return m_aValues; }

// XInteractionSupplyParameters
//STRIP001     virtual void SAL_CALL setParameters( const Sequence< PropertyValue >& _rValues ) throw(RuntimeException);
};

//------------------------------------------------------------------
//STRIP001 void SAL_CALL OParameterContinuation::setParameters( const Sequence< PropertyValue >& _rValues ) throw(RuntimeException)
//STRIP001 {
//STRIP001     m_aValues = _rValues;
//STRIP001 }

//==================================================================
// FmXAutoControl
//==================================================================
struct FmFieldInfo
{
    ::rtl::OUString       aFieldName;
    Reference< XPropertySet >   xField;
    Reference< ::com::sun::star::awt::XTextComponent >  xText;

    FmFieldInfo(const Reference< XPropertySet >& _xField, const Reference< ::com::sun::star::awt::XTextComponent >& _xText)
        :xField(_xField)
        ,xText(_xText)
    {xField->getPropertyValue(FM_PROP_NAME) >>= aFieldName;}
};

//==================================================================
// FmXAutoControl
//==================================================================
class FmXAutoControl: public UnoControl

{
    friend Reference< XInterface > SAL_CALL FmXAutoControl_NewInstance_Impl();

public:
    FmXAutoControl(){}

//STRIP001     virtual ::rtl::OUString GetComponentServiceName() {return ::rtl::OUString::createFromAscii("Edit");}
//STRIP001     virtual void SAL_CALL createPeer( const Reference< ::com::sun::star::awt::XToolkit > & rxToolkit, const Reference< ::com::sun::star::awt::XWindowPeer >  & rParentPeer ) throw( ::com::sun::star::uno::RuntimeException );

protected:
//STRIP001     virtual void ImplSetPeerProperty( const ::rtl::OUString& rPropName, const Any& rVal );
};

//------------------------------------------------------------------------------
//STRIP001 void FmXAutoControl::createPeer( const Reference< ::com::sun::star::awt::XToolkit > & rxToolkit, const Reference< ::com::sun::star::awt::XWindowPeer >  & rParentPeer ) throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 {
//STRIP001     UnoControl::createPeer( rxToolkit, rParentPeer );
//STRIP001 
//STRIP001     Reference< ::com::sun::star::awt::XTextComponent >  xText(getPeer() , UNO_QUERY);
//STRIP001     if (xText.is())
//STRIP001     {
//STRIP001         xText->setText(::rtl::OUString(SVX_RES(RID_STR_AUTOFIELD)));
//STRIP001         xText->setEditable(sal_False);
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXAutoControl::ImplSetPeerProperty( const ::rtl::OUString& rPropName, const Any& rVal )
//STRIP001 {
//STRIP001     // these properties are ignored
//STRIP001     if (rPropName == FM_PROP_TEXT)
//STRIP001         return;
//STRIP001 
//STRIP001     UnoControl::ImplSetPeerProperty( rPropName, rVal );
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormController, OnTimeout, void*, EMPTYTAG)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     activateTabOrder();
//STRIP001     return 1;
/*N*/ }

/*************************************************************************/

//------------------------------------------------------------------
/*N*/ Reference< XInterface > SAL_CALL
/*N*/     FmXFormController_NewInstance_Impl(const Reference< ::com::sun::star::lang::XMultiServiceFactory > & _rxORB)
/*N*/ {
/*N*/     return *(new FmXFormController(_rxORB));
/*N*/ }

//------------------------------------------------------------------
/*N*/ namespace fmctrlr
/*N*/ {
/*N*/ 	const ::rtl::OUString& getDataModeIdentifier()
/*N*/ 	{
/*N*/ 		static ::rtl::OUString s_sDataModeIdentifier = DATA_MODE;
/*N*/ 		return s_sDataModeIdentifier;
/*N*/ 	}
/*N*/ }
using namespace fmctrlr;

DBG_NAME( FmXFormController )
//------------------------------------------------------------------
/*N*/ FmXFormController::FmXFormController(const Reference< ::com::sun::star::lang::XMultiServiceFactory > & _rxORB,
/*N*/ 									 FmFormView* _pView, Window* _pWindow, const UniString& _sDispatchPrefix)
/*N*/ 				  :FmXFormController_BASE1(m_aMutex)
/*N*/ 				  ,OPropertySetHelper(FmXFormController_BASE1::rBHelper)
/*N*/ 				  ,OSQLParserClient(_rxORB)
/*N*/ 				  ,m_xORB(_rxORB)
/*N*/ 				  ,m_aActivateListeners(m_aMutex)
/*N*/ 				  ,m_aModifyListeners(m_aMutex)
/*N*/ 				  ,m_aErrorListeners(m_aMutex)
/*N*/ 				  ,m_aDeleteListeners(m_aMutex)
/*N*/ 				  ,m_aRowSetApproveListeners(m_aMutex)
/*N*/ 				  ,m_aParameterListeners(m_aMutex)
/*N*/ 				  ,m_pView(_pView)
/*N*/ 				  ,m_pWindow(_pWindow)
/*N*/ 				  ,m_bDBConnection(sal_False)
/*N*/ 				  ,m_bCycle(sal_False)
/*N*/ 				  ,m_bCanUpdate(sal_False)
/*N*/ 				  ,m_bCanInsert(sal_False)
/*N*/ 				  ,m_bModified(sal_False)
/*N*/ 				  ,m_nLoadEvent( 0 )
/*N*/ 				  ,m_bCommitLock(sal_False)
/*N*/ 				  ,m_bCurrentRecordModified(sal_False)
/*N*/ 				  ,m_bCurrentRecordNew(sal_False)
/*N*/ 				  ,m_bLocked(sal_False)
/*N*/ 				  ,m_aMode(getDataModeIdentifier())
/*N*/ 				  ,m_bFiltering(sal_False)
/*N*/ 				  ,m_bAttachEvents(sal_True)
/*N*/ 				  ,m_bDetachEvents(sal_True)
/*N*/ 				  ,m_nCurrentFilterPosition(0)
/*N*/ 				  ,m_sDispatchPrefix(_sDispatchPrefix)
/*N*/ 				  ,m_nUpdateDispatcherEvent(0)
/*N*/ 				  ,m_nToggleEvent(0)
/*N*/ {
/*N*/ 	DBG_CTOR( FmXFormController, NULL );
/*N*/ 
/*N*/ 	::comphelper::increment(m_refCount);
/*N*/ 	{
/*N*/ 		m_xAggregate = Reference< XAggregation > (m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.awt.TabController")), UNO_QUERY);
/*N*/ 		DBG_ASSERT(m_xAggregate.is(), "FmXFormController::FmXFormController : could not create my aggregate !");
/*N*/ 		m_xTabController = Reference< ::com::sun::star::awt::XTabController > (m_xAggregate, UNO_QUERY);
/*N*/ 	}
/*N*/ 	if ( m_xAggregate.is() )
/*N*/ 		m_xAggregate->setDelegator(*this);
/*N*/ 
/*N*/     ::comphelper::decrement(m_refCount);
/*N*/ 
/*N*/     m_aInsertTimer.SetTimeout(500);
/*N*/     m_aInsertTimer.SetTimeoutHdl(LINK(this,FmXFormController,OnTimeout));
/*N*/ }

//------------------------------------------------------------------
/*N*/ FmXFormController::~FmXFormController()
/*N*/ {
/*N*/     if( m_nLoadEvent )
/*?*/         Application::RemoveUserEvent( m_nLoadEvent );
/*N*/ 
/*N*/     if (m_nToggleEvent)
/*?*/         Application::RemoveUserEvent( m_nToggleEvent );
/*N*/ 
/*N*/     if (m_nUpdateDispatcherEvent)
/*?*/         Application::RemoveUserEvent(m_nUpdateDispatcherEvent);
/*N*/ 
/*N*/     if (m_aInsertTimer.IsActive())
/*?*/         m_aInsertTimer.Stop();
/*N*/ 
/*N*/     // Freigeben der Aggregation
/*N*/     if (m_xAggregate.is())
/*N*/     {
/*?*/         Reference< XInterface >  xInt;
/*?*/         m_xAggregate->setDelegator(xInt);
/*N*/     }
/*N*/ 
/*N*/ 	DBG_DTOR( FmXFormController, NULL );
/*N*/ }

// -----------------------------------------------------------------------------
using namespace ::cppu;
using namespace ::osl;

/*N*/ void SAL_CALL FmXFormController::acquire() throw ()
/*N*/ {
/*N*/     FmXFormController_BASE1::acquire();
/*N*/ }
// -----------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::release() throw ()
/*N*/ {
/*N*/     FmXFormController_BASE1::release();
/*N*/ }
// -----------------------------------------------------------------------------
// XUnoTunnel
/*N*/ Sequence< sal_Int8 > FmXFormController::getUnoTunnelImplementationId()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< sal_Int8 > aSequence; return aSequence;//STRIP001 
//STRIP001     static OImplementationId * pId = 0;
//STRIP001     if (! pId)
//STRIP001     {
//STRIP001         MutexGuard aGuard( Mutex::getGlobalMutex() );
//STRIP001         if (! pId)
//STRIP001         {
//STRIP001             static OImplementationId aId;
//STRIP001             pId = &aId;
//STRIP001         }
//STRIP001     }
//STRIP001     return pId->getImplementationId();
/*N*/ }
//------------------------------------------------------------------------------
/*?*/ sal_Int64 SAL_CALL FmXFormController::getSomething(Sequence<sal_Int8> const& rId)throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001     if (rId.getLength() == 16 && 0 == rtl_compareMemory(getUnoTunnelImplementationId().getConstArray(),  rId.getConstArray(), 16 ) )
//STRIP001         return (sal_Int64)this;
//STRIP001 
//STRIP001     return sal_Int64();
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< Type > SAL_CALL FmXFormController::getTypes(  ) throw(RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< Type > aType; return aType;//STRIP001 
//STRIP001     return comphelper::concatSequences(FmXFormController_BASE1::getTypes(),FmXFormController_BASE2::getTypes(),FmXFormController_BASE3::getTypes());
/*N*/ }
//------------------------------------------------------------------
/*N*/ Any SAL_CALL FmXFormController::queryAggregation( const Type& _rType ) throw(RuntimeException)
/*N*/ {
/*N*/     Any aRet = FmXFormController_BASE1::queryAggregation(_rType);
/*N*/     if(!aRet.hasValue())
/*N*/     {
/*?*/         aRet = OPropertySetHelper::queryInterface(_rType);
/*?*/         if(!aRet.hasValue())
/*?*/         {
/*?*/             aRet = FmXFormController_BASE2::queryInterface(_rType);
/*?*/             if(!aRet.hasValue())
/*?*/                 aRet = FmXFormController_BASE3::queryInterface(_rType);
/*N*/         }
/*N*/     }
/*N*/     if(aRet.hasValue())
/*N*/         return aRet;
/*?*/     return m_xAggregate->queryAggregation(_rType);
/*N*/ }

// ::com::sun::star::lang::XServiceInfo
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::supportsService(const ::rtl::OUString& ServiceName) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001     Sequence< ::rtl::OUString> aSNL(static_getSupportedServiceNames());
//STRIP001     const ::rtl::OUString * pArray = aSNL.getConstArray();
//STRIP001     for( sal_Int32 i = 0; i < aSNL.getLength(); i++ )
//STRIP001         if( pArray[i] == ServiceName )
//STRIP001             return sal_True;
//STRIP001     return sal_False;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::rtl::OUString SAL_CALL FmXFormController::getImplementationName() throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return ::rtl::OUString::createFromAscii("STRIP") ;//STRIP001     return ::rtl::OUString::createFromAscii("com.sun.star.form.FmXFormController");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Sequence< ::rtl::OUString> SAL_CALL FmXFormController::getSupportedServiceNames(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP");Sequence< ::rtl::OUString> aSequence; return aSequence;//STRIP001     return static_getSupportedServiceNames();
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveReset(const ::com::sun::star::lang::EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/     return sal_True;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::resetted(const ::com::sun::star::lang::EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     ::osl::MutexGuard aGuard(m_aMutex);
//STRIP001     if (getCurrentControl().is() &&  (getCurrentControl()->getModel() == rEvent.Source))
//STRIP001         m_bModified = sal_False;
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< ::rtl::OUString> FmXFormController::static_getSupportedServiceNames(void)
/*N*/ {
/*N*/     static Sequence< ::rtl::OUString> aServices;
/*N*/     if (!aServices.getLength())
/*N*/     {
/*N*/         aServices.realloc(2);
/*N*/         aServices.getArray()[0] = ::rtl::OUString::createFromAscii("com.sun.star.form.FormController");
/*N*/         aServices.getArray()[1] = ::rtl::OUString::createFromAscii("com.sun.star.awt.control.TabController");
/*N*/     }
/*N*/     return aServices;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::setCurrentFilterPosition(sal_Int32 nPos)
//STRIP001 {
//STRIP001 	DBG_ASSERT(nPos < (sal_Int32)m_aFilters.size(), "Invalid Position");
//STRIP001 
//STRIP001     if (nPos != m_nCurrentFilterPosition)
//STRIP001     {
//STRIP001         m_nCurrentFilterPosition = nPos;
//STRIP001 
//STRIP001         // reset the text for all controls
//STRIP001         for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
//STRIP001              iter != m_aFilterControls.end(); iter++)
//STRIP001                  (*iter).first->setText(::rtl::OUString());
//STRIP001 
//STRIP001         if (nPos != -1)
//STRIP001         {
//STRIP001             // set the text for all filters
//STRIP001 			OSL_ENSURE(m_aFilters.size() > m_nCurrentFilterPosition && m_nCurrentFilterPosition >= 0,"m_nCurrentFilterPosition too big");
//STRIP001             FmFilterRow& rRow = m_aFilters[m_nCurrentFilterPosition];
//STRIP001             for (FmFilterRow::const_iterator iter2 = rRow.begin();
//STRIP001                  iter2 != rRow.end(); iter2++)
//STRIP001             {
//STRIP001                 (*iter2).first->setText((*iter2).second);
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }

// OPropertySetHelper
//------------------------------------------------------------------------------
/*?*/ sal_Bool FmXFormController::convertFastPropertyValue( Any & rConvertedValue, Any & rOldValue,
/*?*/                                             sal_Int32 nHandle, const Any& rValue )
/*?*/                 throw( ::com::sun::star::lang::IllegalArgumentException )
/*?*/ {
/*?*/     return sal_False;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::setFastPropertyValue_NoBroadcast( sal_Int32 nHandle, const Any& rValue )
/*?*/                          throw( ::com::sun::star::uno::Exception )
/*?*/ {
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::getFastPropertyValue( Any& rValue, sal_Int32 nHandle ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     switch (nHandle)
//STRIP001     {
//STRIP001         case FM_ATTR_FILTER_CRITERIA:
//STRIP001         {
//STRIP001             ::rtl::OUString aFilter;
//STRIP001 			OStaticDataAccessTools aStaticTools;
//STRIP001             Reference<XConnection> xConnection(aStaticTools.getRowSetConnection(Reference< XRowSet>(m_xModelAsIndex, UNO_QUERY)));
//STRIP001             if (xConnection.is())
//STRIP001             {
//STRIP001                 Reference< ::com::sun::star::sdbc::XDatabaseMetaData> xMetaData(xConnection->getMetaData());
//STRIP001                 Reference< ::com::sun::star::util::XNumberFormatsSupplier> xFormatSupplier( aStaticTools.getNumberFormats(xConnection, sal_True));
//STRIP001                 Reference< ::com::sun::star::util::XNumberFormatter> xFormatter(m_xORB
//STRIP001                                 ->createInstance(::rtl::OUString::createFromAscii("com.sun.star.util.NumberFormatter")), UNO_QUERY);
//STRIP001                 xFormatter->attachNumberFormatsSupplier(xFormatSupplier);
//STRIP001 
//STRIP001                 Reference< ::com::sun::star::sdbcx::XColumnsSupplier> xSupplyCols(m_xModelAsIndex, UNO_QUERY);
//STRIP001                 Reference< ::com::sun::star::container::XNameAccess> xFields(xSupplyCols->getColumns(), UNO_QUERY);
//STRIP001 
//STRIP001                 ::rtl::OUString aQuote( xMetaData->getIdentifierQuoteString() );
//STRIP001 
//STRIP001                     // now add the filter rows
//STRIP001                 for (FmFilterRows::const_iterator i = m_aFilters.begin(); i != m_aFilters.end(); ++i)
//STRIP001                 {
//STRIP001                     ::rtl::OUString aTest, aErrorMsg, aCriteria;
//STRIP001                     const FmFilterRow& rRow = *i;
//STRIP001 
//STRIP001                     if (!rRow.empty())
//STRIP001                     {
//STRIP001                         if (aFilter.getLength())
//STRIP001                             aFilter += ::rtl::OUString::createFromAscii(" OR ");
//STRIP001 
//STRIP001                         aFilter += ::rtl::OUString::createFromAscii("(");
//STRIP001                         for (FmFilterRow::const_iterator j = rRow.begin(); j != rRow.end(); j++)
//STRIP001                         {
//STRIP001                             // get the field of the controls map
//STRIP001                             Reference< ::com::sun::star::awt::XTextComponent > xText = (*j).first;
//STRIP001                             Reference< XPropertySet> xField = (*m_aFilterControls.find(xText)).second;
//STRIP001                             DBG_ASSERT(xField.is(), "NoField found");
//STRIP001                             if (j != rRow.begin())
//STRIP001                                 aFilter += ::rtl::OUString::createFromAscii(" AND ");
//STRIP001 
//STRIP001                             aTest = (*j).second;
//STRIP001                             aErrorMsg = ::rtl::OUString();
//STRIP001                             ::rtl::Reference< ISQLParseNode > xParseNode = predicateTree(aErrorMsg, aTest, xFormatter, xField);
//STRIP001                             if (xParseNode.is())
//STRIP001                             {
//STRIP001                                 aCriteria = ::rtl::OUString();
//STRIP001 								// don't use a parse context here, we need it unlocalized
//STRIP001                                 xParseNode->parseNodeToStr(aCriteria, xMetaData,NULL);
//STRIP001                                 aFilter += aCriteria;
//STRIP001                             }
//STRIP001                         }
//STRIP001                         aFilter += ::rtl::OUString::createFromAscii(")");
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             rValue <<= ::rtl::OUString(aFilter);
//STRIP001         }   break;
//STRIP001     }
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ Reference< XPropertySetInfo >  FmXFormController::getPropertySetInfo() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); Reference< XPropertySetInfo > aReference; return aReference;//STRIP001     static Reference< XPropertySetInfo >  xInfo( createPropertySetInfo( getInfoHelper() ) );
//STRIP001     return xInfo;
/*?*/ }

//------------------------------------------------------------------------------
#define DECL_PROP_CORE(varname, type) \
pDesc[nPos++] = Property(FM_PROP_##varname, FM_ATTR_##varname, ::getCppuType((const type*)0),


#define DECL_PROP1(varname, type, attrib1)  \
    DECL_PROP_CORE(varname, type) PropertyAttribute::attrib1)

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::fillProperties(
/*?*/         Sequence< Property >& /* [out] */ _rProps,
/*?*/         Sequence< Property >& /* [out] */ _rAggregateProps
/*?*/         ) const
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     _rProps.realloc(1);
//STRIP001     sal_Int32 nPos = 0;
//STRIP001     Property* pDesc = _rProps.getArray();
//STRIP001     DECL_PROP1(FILTER_CRITERIA, ::rtl::OUString, READONLY);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::cppu::IPropertyArrayHelper& FmXFormController::getInfoHelper()
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return *getArrayHelper();//STRIP001     return *getArrayHelper();
/*?*/ }

// ::com::sun::star::container::XElementAccess
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::hasElements(void) throw( RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP"); } return NULL;
//STRIP001 /*?*/ ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 /*?*/     return !m_aChilds.empty();
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Type SAL_CALL  FmXFormController::getElementType(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001     return ::getCppuType((const Reference< ::com::sun::star::form::XFormController>*)0);
/*?*/ 
/*?*/ }

// ::com::sun::star::container::XEnumerationAccess
//------------------------------------------------------------------------------
/*?*/ Reference< ::com::sun::star::container::XEnumeration > SAL_CALL  FmXFormController::createEnumeration(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
/*?*/ //STRIP001     return new ::comphelper::OEnumerationByIndex(this);
/*?*/ }

// ::com::sun::star::container::XIndexAccess
//------------------------------------------------------------------------------
/*?*/ sal_Int32 SAL_CALL FmXFormController::getCount(void) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
//STRIP001 /*?*/ 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     return m_aChilds.size();
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Any SAL_CALL FmXFormController::getByIndex(sal_Int32 Index) throw( ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException, RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); Any a; return a;
//STRIP001 /*?*/ 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 	if (Index < 0 ||
//STRIP001 		Index >= (sal_Int32)m_aChilds.size())
//STRIP001 		throw ::com::sun::star::lang::IndexOutOfBoundsException();
//STRIP001 
//STRIP001     return makeAny(m_aChilds[Index]);
//STRIP001     //  , ::getCppuType((const ::com::sun::star::form::XFormController*)0));
/*?*/ }

//-----------------------------------------------------------------------------
//STRIP001 void FmXFormController::addChild(FmXFormController* pChild)
//STRIP001 {
//STRIP001     Reference< ::com::sun::star::form::XFormController >  xController(pChild);
//STRIP001     m_aChilds.push_back(xController);
//STRIP001     pChild->setParent(static_cast< ::com::sun::star::form::XFormController* >(this));
//STRIP001 
//STRIP001     Reference< ::com::sun::star::form::XFormComponent >  xForm(pChild->getModel(), UNO_QUERY);
//STRIP001 
//STRIP001     // search the position of the model within the form
//STRIP001     sal_uInt32 nPos = m_xModelAsIndex->getCount();
//STRIP001     Reference< ::com::sun::star::form::XFormComponent > xTemp;
//STRIP001     for( ; nPos; )
//STRIP001     {
//STRIP001         m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
//STRIP001         if ((::com::sun::star::form::XFormComponent*)xForm.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
//STRIP001         {
//STRIP001             Reference< XInterface >  xIfc(xController, UNO_QUERY);
//STRIP001             m_xModelAsManager->attach( nPos, xIfc, makeAny( xController) );
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//  EventListener
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::disposing(const ::com::sun::star::lang::EventObject& e) throw( RuntimeException )
/*N*/ {
/*N*/     // Ist der Container disposed worden
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/     Reference< ::com::sun::star::awt::XControlContainer >  xContainer(e.Source, UNO_QUERY);
/*N*/     if (xContainer.is())
/*N*/     {
/*N*/         setContainer(Reference< ::com::sun::star::awt::XControlContainer > ());
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         // ist ein Control disposed worden
/*N*/         Reference< ::com::sun::star::awt::XControl >  xControl(e.Source, UNO_QUERY);
/*N*/         if (xControl.is())
/*N*/         {
/*?*/             if (getContainer().is())
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                 removeControl(xControl);
/*N*/         }
/*N*/     }
/*N*/ }

// OComponentHelper
//-----------------------------------------------------------------------------
/*N*/ void FmXFormController::disposing(void)
/*N*/ {
/*N*/     ::com::sun::star::lang::EventObject aEvt(static_cast< ::com::sun::star::form::XFormController* >(this));
/*N*/     // noch aktiv ?
/*N*/     if (m_xActiveControl.is())
/*N*/     {
/*?*/         NOTIFY_LISTENERS(m_aActivateListeners, ::com::sun::star::form::XFormControllerListener, formDeactivated, aEvt);
/*N*/     }
/*N*/ 
/*N*/     m_aActivateListeners.disposeAndClear(aEvt);
/*N*/     m_aModifyListeners.disposeAndClear(aEvt);
/*N*/     m_aErrorListeners.disposeAndClear(aEvt);
/*N*/     m_aDeleteListeners.disposeAndClear(aEvt);
/*N*/     m_aRowSetApproveListeners.disposeAndClear(aEvt);
/*N*/     m_aParameterListeners.disposeAndClear(aEvt);
/*N*/ 
/*N*/ 	removeBoundFieldListener();
/*N*/ 	stopFiltering();
/*N*/ 
/*N*/     m_aFilters.clear();
/*N*/ 
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     m_xActiveControl  = m_xCurrentControl = NULL;
/*N*/ 
/*N*/     for (FmFormControllers::const_iterator i = m_aChilds.begin();
/*N*/         i != m_aChilds.end(); i++)
/*N*/     {
/*N*/         // search the position of the model within the form
/*?*/         Reference< ::com::sun::star::form::XFormComponent >  xForm((*i)->getModel(), UNO_QUERY);
/*?*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*?*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*?*/         for( ; nPos; )
/*?*/         {
/*?*/ 
/*?*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*?*/             if ((::com::sun::star::form::XFormComponent*)xForm.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*?*/             {
/*?*/                 Reference< XInterface >  xIfc(*i, UNO_QUERY);
/*?*/                 m_xModelAsManager->detach( nPos, xIfc);
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         Reference< ::com::sun::star::lang::XComponent > (*i, UNO_QUERY)->dispose();
/*N*/     }
/*N*/     m_aChilds.clear();
/*N*/ 
/*N*/     if (m_bDBConnection)
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/         unload();
/*N*/ 
/*N*/     setContainer(Reference< ::com::sun::star::awt::XControlContainer > ());
/*N*/     setModel(Reference< ::com::sun::star::awt::XTabControllerModel > ());
/*N*/     setParent(Reference< XInterface > ());
/*N*/ 
/*N*/     ::comphelper::disposeComponent(m_xComposer);
/*N*/ 
/*N*/     // the following members shouldn't be set to NULL
/*N*/     // Freigeben der Aggregation
/*N*/     if (m_xAggregate.is())
/*N*/     {
/*N*/         Reference< XInterface >  xInt;
/*N*/         m_xAggregate->setDelegator(xInt);
/*N*/     }
/*N*/     m_xAggregate        = NULL;
/*N*/     m_xTabController    = NULL;
/*N*/     m_xORB              = NULL;
/*N*/ 
/*N*/     m_bDBConnection = sal_False;
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::propertyChange(const PropertyChangeEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if ( evt.PropertyName == FM_PROP_BOUNDFIELD )
//STRIP001     {
//STRIP001 		Reference<XPropertySet> xOldBound;
//STRIP001 		evt.OldValue >>= xOldBound;
//STRIP001 		if ( !xOldBound.is() && evt.NewValue.hasValue() )
//STRIP001 		{
//STRIP001 			Reference< ::com::sun::star::awt::XControlModel > xControlModel(evt.Source,UNO_QUERY);
//STRIP001 			Reference< ::com::sun::star::awt::XControl > xControl = findControl(m_aControls,xControlModel,sal_False,sal_False);
//STRIP001 			if ( xControl.is() )
//STRIP001 			{
//STRIP001 				startControlListening(xControl);
//STRIP001 				Reference<XPropertySet> xProp(xControlModel,UNO_QUERY);
//STRIP001 				if ( xProp.is() )
//STRIP001 					xProp->removePropertyChangeListener(FM_PROP_BOUNDFIELD, this);
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001 		sal_Bool bModifiedChanged = (evt.PropertyName == FM_PROP_ISMODIFIED);
//STRIP001 		sal_Bool bNewChanged = (evt.PropertyName == FM_PROP_ISNEW);
//STRIP001 		if (bModifiedChanged || bNewChanged)
//STRIP001 		{
//STRIP001 			::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 			if (bModifiedChanged)
//STRIP001 				m_bCurrentRecordModified = ::comphelper::getBOOL(evt.NewValue);
//STRIP001 			else
//STRIP001 				m_bCurrentRecordNew = ::comphelper::getBOOL(evt.NewValue);
//STRIP001 
//STRIP001 			// toggle the locking
//STRIP001 			if (m_bLocked != determineLockState())
//STRIP001 			{
//STRIP001 				m_bLocked = !m_bLocked;
//STRIP001 				setLocks();
//STRIP001 				if (isListeningForChanges())
//STRIP001 					startListening();
//STRIP001 				else
//STRIP001 					stopListening();
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bNewChanged && m_pView)
//STRIP001 			{
//STRIP001 				if (m_nToggleEvent)
//STRIP001 					Application::RemoveUserEvent( m_nToggleEvent );
//STRIP001 				m_nToggleEvent = Application::PostUserEvent( LINK(this, FmXFormController,
//STRIP001 														OnToggleAutoFields) );
//STRIP001 			}
//STRIP001 
//STRIP001 			if (!m_bCurrentRecordModified)
//STRIP001 				m_bModified = sal_False;
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::toggleAutoFields(sal_Bool bAutoFields)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!m_pView)
//STRIP001     {
//STRIP001         DBG_ERROR("FmXFormController::toggleAutoFields : you can't call toggleAutoFields when no view exists !");
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001 
//STRIP001     // Austauschen der Kontrols fuer das aktuelle Formular
//STRIP001     Sequence < Reference< ::com::sun::star::awt::XControl >  > aControls(m_aControls);
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     SdrPageView* pCurPageView = m_pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001     sal_uInt16 nPos = pCurPageView ? pCurPageView->GetWinList().Find((OutputDevice*)m_pView->GetActualOutDev()) : SDRPAGEVIEWWIN_NOTFOUND;
//STRIP001     if (nPos == SDRPAGEVIEWWIN_NOTFOUND)
//STRIP001         return;
//STRIP001 
//STRIP001     // the control we have to activate after replacement
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xNewActiveControl;
//STRIP001     if (bAutoFields)
//STRIP001     {
//STRIP001         // as we don't want new controls to be attached to the scripting environment
//STRIP001         // we change attach flags
//STRIP001         m_bAttachEvents = sal_False;
//STRIP001         for (sal_Int32 i = aControls.getLength(); i > 0;)
//STRIP001         {
//STRIP001             const Reference< ::com::sun::star::awt::XControl > & xControl = pControls[--i];
//STRIP001             if (xControl.is())
//STRIP001             {
//STRIP001                 Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001                 if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001                 {
//STRIP001                     // does the model use a bound field ?
//STRIP001                     Reference< XPropertySet >  xField;
//STRIP001                     xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 
//STRIP001                     // is it a autofield?
//STRIP001                     if (xField.is() && ::comphelper::hasProperty(FM_PROP_AUTOINCREMENT, xField) &&
//STRIP001                         ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_AUTOINCREMENT)))
//STRIP001                     {
//STRIP001                         const SdrPageViewWinRec& rWR = pCurPageView->GetWinList()[nPos];
//STRIP001                         const SdrUnoControlList& rControlList = rWR.GetControlList();
//STRIP001                         sal_uInt16 nCtrlNum = rControlList.Find(xControl);
//STRIP001                         if (nCtrlNum != SDRUNOCONTROL_NOTFOUND)
//STRIP001                         {
//STRIP001                             // ok create an autocontrol
//STRIP001                             SdrUnoControlRec& rControlRec = (SdrUnoControlRec&)rControlList[nCtrlNum];
//STRIP001                             FmXAutoControl* pAutoControl = new FmXAutoControl();
//STRIP001                             Reference< ::com::sun::star::awt::XControl >  xNewControl(pAutoControl);
//STRIP001 
//STRIP001                             // setting the focus if the current control
//STRIP001                             // is the active one
//STRIP001                             if ((::com::sun::star::awt::XControl*)m_xActiveControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001                             {
//STRIP001                                 xNewActiveControl = xNewControl;
//STRIP001                                 m_xActiveControl = m_xCurrentControl = NULL;
//STRIP001                             }
//STRIP001                             else if ((::com::sun::star::awt::XControl*)m_xCurrentControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001                                 m_xCurrentControl = xNewControl;
//STRIP001 
//STRIP001                             rControlRec.ReplaceControl(xNewControl);
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         m_bAttachEvents = sal_True;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         m_bDetachEvents = sal_False;
//STRIP001         for (sal_Int32 i = aControls.getLength(); i > 0;)
//STRIP001         {
//STRIP001             const Reference< ::com::sun::star::awt::XControl > & xControl = pControls[--i];
//STRIP001             if (xControl.is())
//STRIP001             {
//STRIP001                 Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001                 if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001                 {
//STRIP001                     // does the model use a bound field ?
//STRIP001                     Reference< XPropertySet >  xField;
//STRIP001                     xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 
//STRIP001                     // is it a autofield?
//STRIP001                     if (xField.is() && ::comphelper::hasProperty(FM_PROP_AUTOINCREMENT, xField) &&
//STRIP001                         ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_AUTOINCREMENT)))
//STRIP001                     {
//STRIP001                         const SdrPageViewWinRec& rWR = pCurPageView->GetWinList()[nPos];
//STRIP001                         const SdrUnoControlList& rControlList = rWR.GetControlList();
//STRIP001                         sal_uInt16 nCtrlNum = rControlList.Find(xControl);
//STRIP001                         if (nCtrlNum != SDRUNOCONTROL_NOTFOUND)
//STRIP001                         {
//STRIP001                             // Zuruecksetzen des Controls auf das Defaultcontrol
//STRIP001                             SdrUnoControlRec& rControlRec = (SdrUnoControlRec&)rControlList[nCtrlNum];
//STRIP001                             ::rtl::OUString aServiceName = ::comphelper::getString(xSet->getPropertyValue(FM_PROP_DEFAULTCONTROL));
//STRIP001                             Reference< ::com::sun::star::awt::XControl >  xNewControl(m_xORB->createInstance(aServiceName), UNO_QUERY);
//STRIP001 
//STRIP001                             // setting the focus if the current control
//STRIP001                             // is the active one
//STRIP001                             if ((::com::sun::star::awt::XControl*)m_xActiveControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001                             {
//STRIP001                                 xNewActiveControl = xNewControl;
//STRIP001                                 m_xActiveControl = m_xCurrentControl = NULL;
//STRIP001                             }
//STRIP001                             else if ((::com::sun::star::awt::XControl*)m_xCurrentControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001                                 m_xCurrentControl = xNewControl;
//STRIP001 
//STRIP001                             rControlRec.ReplaceControl(xNewControl);
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         m_bDetachEvents = sal_True;
//STRIP001     }
//STRIP001 
//STRIP001     // set the focus async if possible
//STRIP001     // setting the focus to the replacing control
//STRIP001     Reference< ::com::sun::star::awt::XWindow >  xWindow(xNewActiveControl, UNO_QUERY);
//STRIP001     if (xWindow.is())
//STRIP001         xWindow->setFocus();
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormController, OnToggleAutoFields, void*, EMPTYARG)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_nToggleEvent = 0;
//STRIP001     toggleAutoFields(m_bCurrentRecordNew);
//STRIP001     return 1L;
//STRIP001 }

// ::com::sun::star::awt::XTextListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::textChanged(const ::com::sun::star::awt::TextEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (m_bFiltering)
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xText(e.Source,UNO_QUERY);
//STRIP001         ::rtl::OUString aText = xText->getText();
//STRIP001 
//STRIP001         // Suchen der aktuellen Row
//STRIP001 		OSL_ENSURE(m_aFilters.size() < m_nCurrentFilterPosition && m_nCurrentFilterPosition >= 0,"m_nCurrentFilterPosition too big");
//STRIP001 		if ( m_nCurrentFilterPosition >= 0 && m_nCurrentFilterPosition < m_aFilters.size() )
//STRIP001 		{
//STRIP001 			FmFilterRow& rRow = m_aFilters[m_nCurrentFilterPosition];
//STRIP001 
//STRIP001 			// do we have a new filter
//STRIP001 			if (aText.getLength())
//STRIP001 				rRow[xText] = aText;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// do we have the control in the row
//STRIP001 				FmFilterRow::iterator iter = rRow.find(xText);
//STRIP001 				// erase the entry out of the row
//STRIP001 				if (iter != rRow.end())
//STRIP001 					rRow.erase(iter);
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001     else if (!m_bModified)
//STRIP001         onModify( e.Source );
/*?*/ }

// ::com::sun::star::awt::XItemListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::itemStateChanged(const ::com::sun::star::awt::ItemEvent& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!m_bModified)
//STRIP001 		onModify( rEvent.Source );
/*?*/ }

// XModificationBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addModifyListener(const Reference< ::com::sun::star::util::XModifyListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aModifyListeners.addInterface( l );
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::removeModifyListener(const Reference< ::com::sun::star::util::XModifyListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aModifyListeners.removeInterface( l );
/*?*/ }

// XModificationListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::modified(const EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!m_bModified)
//STRIP001 		onModify( rEvent.Source );
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::onModify( const Reference< XInterface >& _rxControl )
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!m_bModified)
//STRIP001     {
//STRIP001         ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001         m_bModified = sal_True;
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	Reference< XControl > xSourceControl(_rxControl, UNO_QUERY);
//STRIP001 	if	(xSourceControl.get() != m_xCurrentControl.get())
//STRIP001 	{	// let this control grab the focus
//STRIP001 		// (this case may happen if somebody moves the scroll wheel of the mouse over a control
//STRIP001 		// which does not have the focus)
//STRIP001 		// 85511 - 29.05.2001 - frank.schoenheit@germany.sun.com
//STRIP001 		Reference< XWindow > xControlWindow(_rxControl, UNO_QUERY);
//STRIP001 		if (xControlWindow.is())
//STRIP001 			xControlWindow->setFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	EventObject aEvt(static_cast<cppu::OWeakObject*>(this));
//STRIP001 	NOTIFY_LISTENERS(m_aModifyListeners, XModifyListener, modified, aEvt);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormController::determineLockState() const
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // a.) in filter mode we are always locked
//STRIP001     // b.) if we have no valid model or our model (a result set) is not alive -> we're locked
//STRIP001     // c.) if we are inserting everything is OK and we are not locked
//STRIP001     // d.) if are not updatable or on invalid position
//STRIP001     Reference< ::com::sun::star::sdbc::XResultSet >  xResultSet(m_xModelAsIndex, UNO_QUERY);
//STRIP001     if (m_bFiltering || !xResultSet.is() || !isRowSetAlive(xResultSet))
//STRIP001         return sal_True;
//STRIP001     else
//STRIP001         return (m_bCanInsert && m_bCurrentRecordNew) ? sal_False
//STRIP001         :  xResultSet->isBeforeFirst() || xResultSet->isAfterLast() || xResultSet->rowDeleted() || !m_bCanUpdate;
//STRIP001 }

//  FocusListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::focusGained(const ::com::sun::star::awt::FocusEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xControl(e.Source, UNO_QUERY);
//STRIP001 
//STRIP001     if (m_bDBConnection)
//STRIP001     {
//STRIP001         // do we need to keep the locking of the commit
//STRIP001         // we hold the lock as long as the control differs from the current
//STRIP001         // otherwhise we disabled the lock
//STRIP001         m_bCommitLock = m_bCommitLock && (::com::sun::star::awt::XControl*)xControl.get() != (::com::sun::star::awt::XControl*)m_xCurrentControl.get();
//STRIP001         if (m_bCommitLock)
//STRIP001             return;
//STRIP001 
//STRIP001         // when do we have to commit a value to form or a filter
//STRIP001         // a.) if the current value is modified
//STRIP001         // b.) there must be a current control
//STRIP001         // c.) and it must be different from the new focus owning control or
//STRIP001         // d.) the focus is moving around (so we have only one control)
//STRIP001 
//STRIP001         if ((m_bModified || m_bFiltering) &&
//STRIP001             m_xCurrentControl.is() &&
//STRIP001             ((xControl.get() != m_xCurrentControl.get()) ||
//STRIP001              ((e.FocusFlags & ::com::sun::star::awt::FocusChangeReason::AROUND) && (m_bCycle || m_bFiltering)))
//STRIP001             )
//STRIP001         {
//STRIP001             // check the old control if the content is ok
//STRIP001 #if (OSL_DEBUG_LEVEL > 1) || DBG_UTIL
//STRIP001 			Reference< ::com::sun::star::form::XBoundControl >  xLockingTest(m_xCurrentControl, UNO_QUERY);
//STRIP001 			sal_Bool bControlIsLocked = xLockingTest.is() && xLockingTest->getLock();
//STRIP001 			DBG_ASSERT(!bControlIsLocked, "FmXFormController::focusLost : I'm modified and the current control is locked ? How this ?");
//STRIP001 			// normalerweise sollte ein gelocktes Control nicht modified sein, also muss wohl mein bModified aus einem anderen Kontext
//STRIP001 			// gesetzt worden sein, was ich nicht verstehen wuerde ...
//STRIP001 #endif
//STRIP001 			DBG_ASSERT(m_xCurrentControl.is(), "kein CurrentControl gesetzt");
//STRIP001 			// zunaechst das Control fragen ob es das IFace unterstuetzt
//STRIP001 			Reference< XBoundComponent >  xBound(m_xCurrentControl, UNO_QUERY);
//STRIP001 			if (!xBound.is() && m_xCurrentControl.is())
//STRIP001 				xBound  = Reference< XBoundComponent > (m_xCurrentControl->getModel(), UNO_QUERY);
//STRIP001 
//STRIP001 			// lock if we lose the focus during commit
//STRIP001 			m_bCommitLock = sal_True;
//STRIP001 
//STRIP001 			// Commit nicht erfolgreich, Focus zuruecksetzen
//STRIP001 			if (xBound.is() && !xBound->commit())
//STRIP001 			{
//STRIP001 				// the commit failed and we don't commit again until the current control
//STRIP001 				// which couldn't be commit gains the focus again
//STRIP001 				Reference< ::com::sun::star::awt::XWindow >  xWindow(m_xCurrentControl, UNO_QUERY);
//STRIP001 				if (xWindow.is())
//STRIP001 					xWindow->setFocus();
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				m_bModified = sal_False;
//STRIP001 				m_bCommitLock = sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!m_bFiltering && m_bCycle && (e.FocusFlags & ::com::sun::star::awt::FocusChangeReason::AROUND) && m_xCurrentControl.is())
//STRIP001 		{
//STRIP001 			if (e.FocusFlags & ::com::sun::star::awt::FocusChangeReason::FORWARD)
//STRIP001 				FmXFormShell::CanMoveRight((::com::sun::star::form::XFormController*)this) && FmXFormShell::MoveRight((::com::sun::star::form::XFormController*)this);
//STRIP001 			else // backward
//STRIP001 				FmXFormShell::CanMoveLeft((::com::sun::star::form::XFormController*)this) && FmXFormShell::MoveLeft((::com::sun::star::form::XFormController*)this);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Immer noch ein und dasselbe Control
//STRIP001 	if	(	(m_xActiveControl.get() == xControl.get())
//STRIP001 		&&	(xControl.get() == m_xCurrentControl.get())
//STRIP001 		)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xCurrentControl.is(), "Kein CurrentControl selektiert");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Bool bActivated = !m_xActiveControl.is() && xControl.is();
//STRIP001 
//STRIP001 	m_xActiveControl  = xControl;
//STRIP001 	m_xCurrentControl = xControl;
//STRIP001 
//STRIP001 	DBG_ASSERT(m_xCurrentControl.is(), "Kein CurrentControl selektiert");
//STRIP001 
//STRIP001 	if (bActivated)
//STRIP001 		onActivate();
//STRIP001 
//STRIP001 	if (m_bDBConnection && !m_bFiltering && m_pView)
//STRIP001 		m_pView->GetFormShell()->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(AutoSlotMap);
//STRIP001 
//STRIP001 	if (m_xCurrentControl.is())
//STRIP001 	{
//STRIP001 		// Control erhaelt Focus, dann eventuell in den sichtbaren Bereich
//STRIP001 		Reference< ::com::sun::star::awt::XWindow >  xWindow(xControl, UNO_QUERY);
//STRIP001 		if (xWindow.is() && m_pView && m_pWindow)
//STRIP001 		{
//STRIP001 			::com::sun::star::awt::Rectangle aRect = xWindow->getPosSize();
//STRIP001 			::Rectangle aNewRect(aRect.X,aRect.Y,aRect.X+aRect.Width,aRect.Y+aRect.Height);
//STRIP001 			aNewRect = m_pWindow->PixelToLogic(aNewRect);
//STRIP001 			m_pView->MakeVisible(aNewRect, *m_pWindow);
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::onActivate()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // benachrichtigen, dass form activiert
//STRIP001     ::com::sun::star::lang::EventObject aEvt;
//STRIP001     aEvt.Source = *this;
//STRIP001     NOTIFY_LISTENERS(m_aActivateListeners, ::com::sun::star::form::XFormControllerListener, formActivated, aEvt);
//STRIP001 
//STRIP001     // verschicken ob modified
//STRIP001     if (m_bModified)
//STRIP001     {
//STRIP001         NOTIFY_LISTENERS(m_aModifyListeners, ::com::sun::star::util::XModifyListener, modified, aEvt);
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::focusLost(const ::com::sun::star::awt::FocusEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xControl(e.Source, UNO_QUERY);
//STRIP001     Reference< ::com::sun::star::awt::XWindowPeer >  xNext(e.NextFocus, UNO_QUERY);
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xNextControl = isInList(xNext);
//STRIP001     if (!xNextControl.is())
//STRIP001     {
//STRIP001         m_xActiveControl = NULL;
//STRIP001         ::com::sun::star::lang::EventObject aEvt;
//STRIP001         aEvt.Source = *this;
//STRIP001         NOTIFY_LISTENERS(m_aActivateListeners, ::com::sun::star::form::XFormControllerListener, formDeactivated, aEvt);
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::setModel(const Reference< ::com::sun::star::awt::XTabControllerModel > & Model) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::setModel : invalid aggregate !");
/*N*/ 
/*N*/     // disconnect from the old model
/*N*/     if (m_xModelAsIndex.is())
/*N*/     {
/*N*/         if (m_bDBConnection)
/*N*/         {
/*N*/             // we are currently working on the model
/*?*/             ::com::sun::star::lang::EventObject aEvt(m_xModelAsIndex);
/*?*/             unloaded(aEvt);
/*N*/         }
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xForm(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xForm.is())
/*N*/             xForm->removeLoadListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::sdb::XSQLErrorBroadcaster >  xBroadcaster(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xBroadcaster.is())
/*N*/             xBroadcaster->removeSQLErrorListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XDatabaseParameterBroadcaster >  xParamBroadcaster(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xParamBroadcaster.is())
/*N*/             xParamBroadcaster->removeParameterListener(this);
/*N*/     }
/*N*/ 
/*N*/     // set the new model wait for the load event
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->setModel(Model);
/*N*/     m_xModelAsIndex = Reference< ::com::sun::star::container::XIndexAccess > (Model, UNO_QUERY);
/*N*/     m_xModelAsManager = Reference< ::com::sun::star::script::XEventAttacherManager > (Model, UNO_QUERY);
/*N*/ 
/*N*/     // only if both ifaces exit, the controller will work successful
/*N*/     if (!m_xModelAsIndex.is() || !m_xModelAsManager.is())
/*N*/     {
/*N*/         m_xModelAsManager = NULL;
/*N*/         m_xModelAsIndex = NULL;
/*N*/     }
/*N*/ 
/*N*/     if (m_xModelAsIndex.is())
/*N*/     {
/*N*/         // adding load and ui interaction listeners
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xForm(Model, UNO_QUERY);
/*N*/         if (xForm.is())
/*N*/             xForm->addLoadListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::sdb::XSQLErrorBroadcaster >  xBroadcaster(Model, UNO_QUERY);
/*N*/         if (xBroadcaster.is())
/*N*/             xBroadcaster->addSQLErrorListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XDatabaseParameterBroadcaster >  xParamBroadcaster(Model, UNO_QUERY);
/*N*/         if (xParamBroadcaster.is())
/*N*/             xParamBroadcaster->addParameterListener(this);
/*N*/ 
/*N*/         // well, is the database already loaded?
/*N*/         // then we have to simulate a load event
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xCursor(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xCursor.is() && xCursor->isLoaded())
/*N*/         {
/*?*/             ::com::sun::star::lang::EventObject aEvt(xCursor);
/*?*/             loaded(aEvt);
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XTabControllerModel >  FmXFormController::getModel() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::getModel : invalid aggregate !");
/*N*/     if (!m_xTabController.is())
/*?*/         return Reference< ::com::sun::star::awt::XTabControllerModel > ();
/*N*/     return m_xTabController->getModel();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::addToEventAttacher(const Reference< ::com::sun::star::awt::XControl > & xControl)
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     // anmelden beim Eventattacher
/*N*/     Reference< ::com::sun::star::form::XFormComponent >  xComp(xControl->getModel(), UNO_QUERY);
/*N*/     if (xComp.is() && m_xModelAsIndex.is())
/*N*/     {
/*N*/         // Und die Position des ControlModel darin suchen
/*N*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*N*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*N*/         for( ; nPos; )
/*N*/         {
/*N*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*N*/             if ((::com::sun::star::form::XFormComponent*)xComp.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*N*/             {
/*N*/                 Reference< XInterface >  xIfc(xControl, UNO_QUERY);
/*N*/                 m_xModelAsManager->attach( nPos, xIfc, makeAny(xControl) );
/*N*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::removeFromEventAttacher(const Reference< ::com::sun::star::awt::XControl > & xControl)
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     // abmelden beim Eventattacher
/*N*/     Reference< ::com::sun::star::form::XFormComponent >  xComp(xControl->getModel(), UNO_QUERY);
/*N*/     if ( xComp.is() && m_xModelAsIndex.is() )
/*N*/     {
/*N*/         // Und die Position des ControlModel darin suchen
/*N*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*N*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*N*/         for( ; nPos; )
/*N*/         {
/*N*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*N*/             if ((::com::sun::star::form::XFormComponent*)xComp.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*N*/             {
/*N*/                 Reference< XInterface >  xIfc(xControl, UNO_QUERY);
/*N*/                 m_xModelAsManager->detach( nPos, xIfc );
/*N*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::setContainer(const Reference< ::com::sun::star::awt::XControlContainer > & xContainer) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     Reference< ::com::sun::star::awt::XTabControllerModel >  xTabModel(getModel());
/*N*/     DBG_ASSERT(xTabModel.is() || !xContainer.is(), "No Model defined");
/*N*/         // if we have a new container we need a model
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::setContainer : invalid aggregate !");
/*N*/ 
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     Reference< ::com::sun::star::container::XContainer >  xCurrentContainer;
/*N*/     if (m_xTabController.is())
/*N*/         xCurrentContainer = Reference< ::com::sun::star::container::XContainer > (m_xTabController->getContainer(), UNO_QUERY);
/*N*/     if (xCurrentContainer.is())
/*N*/     {
/*N*/         xCurrentContainer->removeContainerListener(this);
/*N*/ 
/*N*/         if (m_aInsertTimer.IsActive())
/*?*/             m_aInsertTimer.Stop();
/*N*/ 
/*N*/         // bei den Controls abmelden
/*N*/         sal_Int32 nCount = m_aControls.getLength();
/*N*/         const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
/*N*/ 
/*N*/         // clear the filter map
/*N*/         for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
/*N*/              iter != m_aFilterControls.end(); ++iter)
/*?*/             (*iter).first->removeTextListener(this);
/*N*/ 
/*N*/         m_aFilterControls.clear();
/*N*/ 
/*N*/         // einsammeln der Controls
/*N*/         for (sal_Int32 i = 0; i < nCount; ++i, ++pControls)
/*N*/         {
/*N*/             // bei jedem Control als FocusListener anmelden
/*N*/             Reference< ::com::sun::star::awt::XWindow >  xWindow(*pControls, UNO_QUERY);
/*N*/             if (xWindow.is())
/*N*/             {
/*N*/                 xWindow->removeFocusListener(this);
/*N*/ 
/*N*/                 // abmelden beim Eventattacher
/*N*/                 removeFromEventAttacher(*pControls);
/*N*/             }
/*N*/ 
/*N*/             Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(*pControls, UNO_QUERY);
/*N*/             if (xInterception.is())
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                 deleteInterceptor(xInterception);
/*N*/ 
/*N*/             if (pControls->is())
/*N*/             {
/*N*/                 Reference< ::com::sun::star::form::XReset >  xControlReset((*pControls)->getModel(), UNO_QUERY);
/*N*/                 if (xControlReset.is())
/*N*/                     xControlReset->removeResetListener((::com::sun::star::form::XResetListener*)this);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         // Datenbank spezifische Dinge vornehmen
/*N*/         if (m_bDBConnection && isListeningForChanges())
/*?*/			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/             stopListening();
/*N*/ 
/*N*/         m_aControls = Sequence< Reference< ::com::sun::star::awt::XControl > >();
/*N*/     }
/*N*/ 
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->setContainer(xContainer);
/*N*/ 
/*N*/     // Welche Controls gehoeren zum Container ?
/*N*/     if (xContainer.is() && xTabModel.is())
/*N*/     {
/*N*/         Sequence< Reference< ::com::sun::star::awt::XControlModel > > aModels = xTabModel->getControlModels();
/*N*/         const Reference< ::com::sun::star::awt::XControlModel > * pModels = aModels.getConstArray();
/*N*/         Sequence< Reference< ::com::sun::star::awt::XControl > > xCtrls = xContainer->getControls();
/*N*/ 
/*N*/         sal_Int32 nCount = aModels.getLength();
/*N*/         m_aControls = Sequence< Reference< ::com::sun::star::awt::XControl > >( nCount );
/*N*/         Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getArray();
/*N*/ 
/*N*/         // einsammeln der Controls
/*N*/         sal_Int32 i, j;
/*N*/         for (i = 0, j = 0; i < nCount; ++i )
/*N*/         {
/*N*/             Reference< ::com::sun::star::awt::XControlModel >  xCtrlModel = pModels[i];
/*N*/             // Zum Model passendes Control suchen
/*N*/             Reference< ::com::sun::star::awt::XControl >  xCtrl = findControl( xCtrls, xCtrlModel,sal_False );
/*N*/             if (xCtrl.is())
/*N*/             {
/*N*/                 pControls[j++] = xCtrl;
/*N*/ 
/*N*/                 // bei jedem Control als FocusListener anmelden
/*N*/                 Reference< ::com::sun::star::awt::XWindow >  xWindow(xCtrl, UNO_QUERY);
/*N*/                 if (xWindow.is())
/*N*/                 {
/*N*/                     xWindow->addFocusListener(this);
/*N*/                     // anmelden beim Eventattacher
/*N*/                     addToEventAttacher(xCtrl);
/*N*/                 }
/*N*/ 
/*N*/                 // add a dispatch interceptor to the control (if supported)
/*N*/                 Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(xCtrl, UNO_QUERY);
/*N*/                 if (xInterception.is())
/*?*/					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                     createInterceptor(xInterception);
/*N*/ 
/*N*/                 // we want to know about the reset of the the model of our controls
/*N*/                 // (for correctly resetting m_bModified)
/*N*/                 Reference< ::com::sun::star::form::XReset >  xControlReset(xCtrl->getModel(), UNO_QUERY);
/*N*/                 if (xControlReset.is())
/*N*/                     xControlReset->addResetListener((::com::sun::star::form::XResetListener*)this);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         // nicht fuer jedes Model ein Control
/*N*/         if (j != i)
/*N*/             m_aControls.realloc(j);
/*N*/ 
/*N*/         // am Container horchen
/*N*/         Reference< ::com::sun::star::container::XContainer >  xNewContainer(xContainer, UNO_QUERY);
/*N*/         if (xNewContainer.is())
/*N*/             xNewContainer->addContainerListener(this);
/*N*/ 
/*N*/         // Datenbank spezifische Dinge vornehmen
/*N*/         if (m_bDBConnection)
/*N*/         {
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/             m_bLocked = determineLockState();
//STRIP001 /*?*/             setLocks();
//STRIP001 /*?*/             if (!isLocked())
//STRIP001 /*?*/                 startListening();
/*N*/         }
/*N*/     }
/*N*/     // befinden sich die Controls in der richtigen Reihenfolge
/*N*/     m_bControlsSorted = sal_True;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XControlContainer >  FmXFormController::getContainer() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::getContainer : invalid aggregate !");
/*N*/     if (!m_xTabController.is())
/*?*/         return Reference< ::com::sun::star::awt::XControlContainer > ();
/*N*/     return m_xTabController->getContainer();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< Reference< ::com::sun::star::awt::XControl > > FmXFormController::getControls(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     if (!m_bControlsSorted)
/*N*/     {
/*?*/         Reference< ::com::sun::star::awt::XTabControllerModel >  xModel = getModel();
/*?*/         if (!xModel.is())
/*?*/             return m_aControls;
/*?*/ 
/*?*/         Sequence< Reference< ::com::sun::star::awt::XControlModel > > aControlModels = xModel->getControlModels();
/*?*/         const Reference< ::com::sun::star::awt::XControlModel > * pModels = aControlModels.getConstArray();
/*?*/         sal_Int32 nModels = aControlModels.getLength();
/*?*/ 
/*?*/         Sequence< Reference< ::com::sun::star::awt::XControl > > aNewControls(nModels);
/*?*/ 
/*?*/         Reference< ::com::sun::star::awt::XControl > * pControls = aNewControls.getArray();
/*?*/         Reference< ::com::sun::star::awt::XControlModel >  xCtrlModel;
/*?*/         Reference< ::com::sun::star::awt::XControl >  xCtrl;
/*?*/ 
/*?*/         // Umsortieren der Controls entsprechend der TabReihenfolge
/*?*/         for (sal_Int32 i = 0, j = 0; i < nModels; i++)
/*?*/         {
/*?*/             xCtrlModel = pModels[i];
/*?*/ 
/*?*/             // Zum Model passendes Control suchen
/*?*/             xCtrl = findControl(m_aControls, xCtrlModel);
/*?*/             if (xCtrl.is())
/*?*/                 pControls[j++] = xCtrl;
/*?*/         }
/*?*/         m_aControls = aNewControls;
/*?*/         m_bControlsSorted = sal_True;
/*N*/     }
/*N*/     return m_aControls;
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::autoTabOrder() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     DBG_ASSERT(m_xTabController.is(), "FmXFormController::autoTabOrder : invalid aggregate !");
//STRIP001     if (m_xTabController.is())
//STRIP001         m_xTabController->autoTabOrder();
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::activateTabOrder() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::activateTabOrder : invalid aggregate !");
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->activateTabOrder();
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::setControlLock(const Reference< ::com::sun::star::awt::XControl > & xControl)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     sal_Bool bLocked = isLocked();
//STRIP001 
//STRIP001     // es wird gelockt
//STRIP001     // a.) wenn der ganze Datensatz gesperrt ist
//STRIP001     // b.) wenn das zugehoerige Feld gespeert ist
//STRIP001     Reference< ::com::sun::star::form::XBoundControl >  xBound(xControl, UNO_QUERY);
//STRIP001     if (xBound.is() && ((bLocked && bLocked != xBound->getLock() ||
//STRIP001                          !bLocked)))    // beim entlocken immer einzelne Felder ueberprfen
//STRIP001     {
//STRIP001         // gibt es eine Datenquelle
//STRIP001         Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001         if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001         {
//STRIP001             // wie sieht mit den Properties ReadOnly und Enable aus
//STRIP001             sal_Bool bTouch = sal_True;
//STRIP001             if (::comphelper::hasProperty(FM_PROP_ENABLED, xSet))
//STRIP001                 bTouch = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ENABLED));
//STRIP001             if (::comphelper::hasProperty(FM_PROP_READONLY, xSet))
//STRIP001                 bTouch = !::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_READONLY));
//STRIP001 
//STRIP001             if (bTouch)
//STRIP001             {
//STRIP001                 Reference< XPropertySet >  xField;
//STRIP001                 xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001                 if (xField.is())
//STRIP001                 {
//STRIP001                     if (bLocked)
//STRIP001                         xBound->setLock(bLocked);
//STRIP001                     else
//STRIP001                     {
//STRIP001                         try
//STRIP001                         {
//STRIP001                             Any aVal = xField->getPropertyValue(FM_PROP_ISREADONLY);
//STRIP001                             if (aVal.hasValue() && ::comphelper::getBOOL(aVal))
//STRIP001                                 xBound->setLock(sal_True);
//STRIP001                             else
//STRIP001                                 xBound->setLock(bLocked);
//STRIP001                         }
//STRIP001                         catch(...)
//STRIP001                         {
//STRIP001                         }
//STRIP001 
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::setLocks()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // alle Controls, die mit einer Datenquelle verbunden sind locken/unlocken
//STRIP001     sal_Int32 nLength = m_aControls.getLength();
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     for (sal_Int32 i = 0; i < nLength; i++)
//STRIP001         setControlLock(pControls[i]);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::startControlListening(const Reference< ::com::sun::star::awt::XControl > & xControl)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // jetzt anmelden bei gebundenen feldern
//STRIP001     sal_Bool bModifyListening = sal_False;
//STRIP001     Reference< ::com::sun::star::form::XBoundComponent >  xBound(xControl, UNO_QUERY);
//STRIP001     if (xBound.is()) // gebundene Controls,
//STRIP001         bModifyListening = sal_True;
//STRIP001     else
//STRIP001     {
//STRIP001         xBound = Reference< ::com::sun::star::form::XBoundComponent > (xControl->getModel(), UNO_QUERY);
//STRIP001 
//STRIP001         // gibt es eine Datenquelle
//STRIP001         Reference< XPropertySet >  xSet(xBound, UNO_QUERY);
//STRIP001         if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001         {
//STRIP001             Reference< XPropertySet >  xField;
//STRIP001             xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001             bModifyListening = (xField.is());
//STRIP001 			if ( !bModifyListening )
//STRIP001 				xSet->addPropertyChangeListener( FM_PROP_BOUNDFIELD, this );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // kuenstliches while
//STRIP001     while (bModifyListening)
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::util::XModifyBroadcaster >  xMod(xControl, UNO_QUERY);
//STRIP001         if (xMod.is())
//STRIP001         {
//STRIP001             xMod->addModifyListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         // alle die Text um vorzeitig ein modified zu erkennen
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001         if (xText.is())
//STRIP001         {
//STRIP001             xText->addTextListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XCheckBox >  xBox(xControl, UNO_QUERY);
//STRIP001         if (xBox.is())
//STRIP001         {
//STRIP001             xBox->addItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XComboBox >  xCbBox(xControl, UNO_QUERY);
//STRIP001         if (xCbBox.is())
//STRIP001         {
//STRIP001             xCbBox->addItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XListBox >  xListBox(xControl, UNO_QUERY);
//STRIP001         if (xListBox.is())
//STRIP001         {
//STRIP001             xListBox->addItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::stopControlListening(const Reference< ::com::sun::star::awt::XControl > & xControl)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 //  Reference< ::com::sun::star::data::XDatabaseCursor >  xCursor(getModel(), UNO_QUERY);
//STRIP001     sal_Bool bModifyListening = sal_False;
//STRIP001 
//STRIP001     Reference< ::com::sun::star::form::XBoundComponent >  xBound(xControl, UNO_QUERY);
//STRIP001     if (xBound.is()) // gebundene Controls,
//STRIP001         bModifyListening = sal_True;
//STRIP001     else
//STRIP001     {
//STRIP001         xBound = Reference< ::com::sun::star::form::XBoundComponent > (xControl->getModel(), UNO_QUERY);
//STRIP001         // gibt es eine Datenquelle
//STRIP001         Reference< XPropertySet >  xSet(xBound, UNO_QUERY);
//STRIP001         if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001         {
//STRIP001             Reference< XPropertySet >  xField;
//STRIP001             xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001             bModifyListening = (xField.is());
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // kuenstliches while
//STRIP001     while (bModifyListening)
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::util::XModifyBroadcaster >  xMod(xControl, UNO_QUERY);
//STRIP001         if (xMod.is())
//STRIP001         {
//STRIP001             xMod->removeModifyListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001         // alle die Text um vorzeitig ein modified zu erkennen
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001         if (xText.is())
//STRIP001         {
//STRIP001             xText->removeTextListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XCheckBox >  xBox(xControl, UNO_QUERY);
//STRIP001         if (xBox.is())
//STRIP001         {
//STRIP001             xBox->removeItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XComboBox >  xCbBox(xControl, UNO_QUERY);
//STRIP001         if (xCbBox.is())
//STRIP001         {
//STRIP001             xCbBox->removeItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::awt::XListBox >  xListBox(xControl, UNO_QUERY);
//STRIP001         if (xListBox.is())
//STRIP001         {
//STRIP001             xListBox->removeItemListener(this);
//STRIP001             break;
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::startListening()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_bModified  = sal_False;
//STRIP001 
//STRIP001     // jetzt anmelden bei gebundenen feldern
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     for (sal_Int32 i = 0; i < m_aControls.getLength(); i++ )
//STRIP001         startControlListening(pControls[i]);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::stopListening()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_bModified  = sal_False;
//STRIP001 
//STRIP001     // jetzt anmelden bei gebundenen feldern
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     for (sal_Int32 i = 0; i < m_aControls.getLength(); i++ )
//STRIP001         stopControlListening(pControls[i]);
//STRIP001 }


//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XControl >  FmXFormController::findControl(Sequence< Reference< ::com::sun::star::awt::XControl > >& rCtrls, const Reference< ::com::sun::star::awt::XControlModel > & xCtrlModel ,sal_Bool _bRemove,sal_Bool _bOverWrite) const
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT( xCtrlModel.is(), "findControl - welches ?!" );
/*N*/ 
/*N*/     Reference< ::com::sun::star::awt::XControl > * pCtrls = rCtrls.getArray();
/*N*/     Reference< ::com::sun::star::awt::XControlModel >  xModel;
/*N*/     for ( sal_Int32 i = 0, nCount = rCtrls.getLength(); i < nCount; ++i )
/*N*/     {
/*N*/         // #66449# Speicherueberschreiber durch folgende Zeile
/*N*/         // Reference< ::com::sun::star::awt::XControlModel >  xModel(pCtrls[i].is() ? pCtrls[i]->getModel() : Reference< ::com::sun::star::awt::XControlModel > ());
/*N*/         if (pCtrls[i].is())
/*N*/         {
/*N*/             xModel = pCtrls[i]->getModel();
/*N*/             if ((::com::sun::star::awt::XControlModel*)xModel.get() == (::com::sun::star::awt::XControlModel*)xCtrlModel.get())
/*N*/             {
/*N*/                 Reference< ::com::sun::star::awt::XControl >  xCtrl( pCtrls[i] );
/*N*/ 				if ( _bRemove )
/*N*/ 					::comphelper::removeElementAt(rCtrls, i);
/*N*/ 				else if ( _bOverWrite )
/*N*/ 					pCtrls[i] = Reference< ::com::sun::star::awt::XControl >();
/*N*/                 return xCtrl;
/*N*/             }
/*N*/         }
/*N*/     }
/*?*/     return Reference< ::com::sun::star::awt::XControl > ();
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::insertControl(const Reference< ::com::sun::star::awt::XControl > & xControl)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_bControlsSorted = sal_False;
//STRIP001     m_aControls.realloc(m_aControls.getLength() + 1);
//STRIP001     m_aControls.getArray()[m_aControls.getLength() - 1] = xControl;
//STRIP001 
//STRIP001     Reference< ::com::sun::star::awt::XWindow >  xWindow(xControl, UNO_QUERY);
//STRIP001     if (xWindow.is())
//STRIP001     {
//STRIP001         xWindow->addFocusListener(this);
//STRIP001         // register at the Eventattacher but not in filter mode
//STRIP001         if (m_bAttachEvents)
//STRIP001             addToEventAttacher(xControl);
//STRIP001     }
//STRIP001 
//STRIP001     Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(xControl, UNO_QUERY);
//STRIP001     if (xInterception.is())
//STRIP001         createInterceptor(xInterception);
//STRIP001 
//STRIP001     if (xControl.is())
//STRIP001     {
//STRIP001         // we want to know about the reset of the the model of our controls
//STRIP001         // (for correctly resetting m_bModified)
//STRIP001         Reference< ::com::sun::star::form::XReset >  xControlReset(xControl->getModel(), UNO_QUERY);
//STRIP001         if (xControlReset.is())
//STRIP001             xControlReset->addResetListener((::com::sun::star::form::XResetListener*)this);
//STRIP001     }
//STRIP001 
//STRIP001     if (m_bDBConnection && !m_bFiltering)
//STRIP001         setControlLock(xControl);
//STRIP001 
//STRIP001     if (isListeningForChanges() && m_bAttachEvents)
//STRIP001         startControlListening(xControl);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::removeControl(const Reference< ::com::sun::star::awt::XControl > & xControl)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 	const Reference< ::com::sun::star::awt::XControl > * pCtrls = m_aControls.getArray();
//STRIP001 	sal_Int32 nCount = m_aControls.getLength();
//STRIP001 	for ( sal_uInt32 i = 0; i < (sal_uInt32)nCount; i++ )
//STRIP001 	{
//STRIP001 		if ((::com::sun::star::awt::XControl*)xControl.get() == (::com::sun::star::awt::XControl*)pCtrls[i].get())
//STRIP001 		{
//STRIP001 			::comphelper::removeElementAt(m_aControls, i);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (m_aFilterControls.size())
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001 		FmFilterControls::iterator iter = m_aFilterControls.find(xText);
//STRIP001 		if (iter != m_aFilterControls.end())
//STRIP001 			m_aFilterControls.erase(iter);
//STRIP001 	}
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::awt::XWindow >  xWindow(xControl, UNO_QUERY);
//STRIP001 	if (xWindow.is())
//STRIP001 	{
//STRIP001 		xWindow->removeFocusListener(this);
//STRIP001 		if (m_bDetachEvents)
//STRIP001 			removeFromEventAttacher(xControl);
//STRIP001 	}
//STRIP001 
//STRIP001 	Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(xControl, UNO_QUERY);
//STRIP001 	if (xInterception.is())
//STRIP001 		deleteInterceptor(xInterception);
//STRIP001 
//STRIP001 	if (xControl.is())
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::form::XReset >  xControlReset(xControl->getModel(), UNO_QUERY);
//STRIP001 		if (xControlReset.is())
//STRIP001 			xControlReset->removeResetListener((::com::sun::star::form::XResetListener*)this);
//STRIP001 	}
//STRIP001 
//STRIP001     if (isListeningForChanges() && m_bDetachEvents)
//STRIP001         stopControlListening(xControl);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormController, OnUpdateDispatchers, void*, EMPTYARG)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_nUpdateDispatcherEvent = 0;
//STRIP001     DBG_ASSERT(m_aControlDispatchInterceptors.size(), "FmXFormController::OnUpdateDispatchers : not intercepting any control dispatches !");
//STRIP001 
//STRIP001     Reference< ::com::sun::star::frame::XModel >  xFrameModel = getXModel(getModel());
//STRIP001     Reference< ::com::sun::star::frame::XController >  xFrameController = xFrameModel.is() ? xFrameModel->getCurrentController() : Reference< ::com::sun::star::frame::XController > ();
//STRIP001     Reference< ::com::sun::star::frame::XFrame >  xFrame = xFrameController.is() ? xFrameController->getFrame() : Reference< ::com::sun::star::frame::XFrame > ();
//STRIP001 
//STRIP001     if (!xFrame.is())
//STRIP001     {   // same as in interceptedQueryDispatch, try again
//STRIP001 		if ( m_aControlDispatchInterceptors.size() )
//STRIP001 			m_nUpdateDispatcherEvent = Application::PostUserEvent(LINK(this, FmXFormController, OnUpdateDispatchers));
//STRIP001         return 0L;
//STRIP001     }
//STRIP001 
//STRIP001     // go through all controls we're intercepting and re-register as interceptor
//STRIP001     // (this should cause them to request the dispatches again)
//STRIP001     Interceptors aTemp = m_aControlDispatchInterceptors;
//STRIP001     for (   ConstInterceptorsIterator aIter = aTemp.begin();
//STRIP001             aIter < aTemp.end();
//STRIP001             ++aIter
//STRIP001         )
//STRIP001     {
//STRIP001         FmXDispatchInterceptorImpl* pInterceptor = *aIter;
//STRIP001         pInterceptor->acquire();
//STRIP001         Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xIntercepted = pInterceptor->getIntercepted();
//STRIP001         deleteInterceptor(xIntercepted);
//STRIP001         createInterceptor(xIntercepted);
//STRIP001         pInterceptor->release();
//STRIP001     }
//STRIP001 
//STRIP001     return 0L;
//STRIP001 }

// ::com::sun::star::form::XLoadListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::loaded(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
//STRIP001 	OSL_ENSURE( rEvent.Source == m_xModelAsIndex, "FmXFormController::loaded: where did this come from?" );
//STRIP001 
//STRIP001 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     Reference< ::com::sun::star::sdbc::XRowSet >  xForm(rEvent.Source, UNO_QUERY);
//STRIP001     // do we have a connected data source
//STRIP001 	OStaticDataAccessTools aStaticTools;
//STRIP001     if (xForm.is() && aStaticTools.getRowSetConnection(xForm).is())
//STRIP001     {
//STRIP001         Reference< XPropertySet >  xSet(xForm, UNO_QUERY);
//STRIP001         if (xSet.is())
//STRIP001         {
//STRIP001             Any aVal        = xSet->getPropertyValue(FM_PROP_CYCLE);
//STRIP001             sal_Int32 aVal2;
//STRIP001             ::cppu::enum2int(aVal2,aVal);
//STRIP001             m_bCycle        = !aVal.hasValue() || aVal2 == ::com::sun::star::form::TabulatorCycle_RECORDS;
//STRIP001             m_bCanUpdate    = aStaticTools.canUpdate(xSet);
//STRIP001             m_bCanInsert    = aStaticTools.canInsert(xSet);
//STRIP001             m_bCurrentRecordModified = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001             m_bCurrentRecordNew      = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 
//STRIP001 			startFormListening( xSet, sal_False );
//STRIP001 
//STRIP001             // set the locks for the current controls
//STRIP001             if (getContainer().is())
//STRIP001             {
//STRIP001                 if (m_nLoadEvent)
//STRIP001                     Application::RemoveUserEvent( m_nLoadEvent );
//STRIP001                 m_nLoadEvent = Application::PostUserEvent( LINK(this, FmXFormController,
//STRIP001                                             OnLoad) );
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             m_bCanInsert = m_bCanUpdate = m_bCycle = sal_False;
//STRIP001             m_bCurrentRecordModified = sal_False;
//STRIP001             m_bCurrentRecordNew = sal_False;
//STRIP001             m_bLocked = sal_False;
//STRIP001         }
//STRIP001         m_bDBConnection = sal_True;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         m_bDBConnection = sal_False;
//STRIP001         m_bCanInsert = m_bCanUpdate = m_bCycle = sal_False;
//STRIP001         m_bCurrentRecordModified = sal_False;
//STRIP001         m_bCurrentRecordNew = sal_False;
//STRIP001         m_bLocked = sal_False;
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormController, OnLoad, void*, EMPTYARG)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_nLoadEvent = 0;
//STRIP001     m_bLocked = determineLockState();
//STRIP001 
//STRIP001     setLocks();
//STRIP001 
//STRIP001     if (!m_bLocked)
//STRIP001         startListening();
//STRIP001 
//STRIP001     // just one exception toggle the auto values
//STRIP001     if (m_bCurrentRecordNew && m_pView)
//STRIP001         toggleAutoFields(sal_True);
//STRIP001 
//STRIP001     return 1L;
//STRIP001 }

//STRIP001 //------------------------------------------------------------------------------
/*?*/ void FmXFormController::unloaded(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // not interested in ...
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::reloading(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     // do the same like in unloading
//STRIP001     // just one exception toggle the auto values
//STRIP001     if (m_nToggleEvent)
//STRIP001     {
//STRIP001         Application::RemoveUserEvent( m_nToggleEvent );
//STRIP001         m_nToggleEvent = 0;
//STRIP001     }
//STRIP001     unload();
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::reloaded(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     loaded(aEvent);
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::unloading(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ //STRIP001     unload();
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::unload() throw( RuntimeException )
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     if (m_nLoadEvent)
//STRIP001     {
//STRIP001         Application::RemoveUserEvent( m_nLoadEvent );
//STRIP001         m_nLoadEvent = 0;
//STRIP001     }
//STRIP001 
//STRIP001     // be sure not to have autofields
//STRIP001     if (m_bCurrentRecordNew && m_pView)
//STRIP001         toggleAutoFields(sal_False);
//STRIP001 
//STRIP001 	// remove bound field listing again
//STRIP001 	removeBoundFieldListener();
//STRIP001 	
//STRIP001     if (m_bDBConnection && isListeningForChanges())
//STRIP001         stopListening();
//STRIP001 
//STRIP001     Reference< XPropertySet >  xSet( m_xModelAsIndex, UNO_QUERY );
//STRIP001     if ( m_bDBConnection && xSet.is() )
//STRIP001 		stopFormListening( xSet, sal_False );
//STRIP001 
//STRIP001     m_bDBConnection = sal_False;
//STRIP001     m_bCanInsert = m_bCanUpdate = m_bCycle = sal_False;
//STRIP001     m_bCurrentRecordModified = m_bCurrentRecordNew = m_bLocked = sal_False;
//STRIP001 }
// -----------------------------------------------------------------------------
/*?*/ void FmXFormController::removeBoundFieldListener()
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
//STRIP001 	const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     for (sal_Int32 i = 0; i < m_aControls.getLength(); ++i,++pControls )
//STRIP001     {
//STRIP001 		Reference<XPropertySet> xProp(*pControls,UNO_QUERY);
//STRIP001 		if ( xProp.is() )
//STRIP001 			xProp->removePropertyChangeListener(FM_PROP_BOUNDFIELD, this);
//STRIP001 	}
/*?*/ }
//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::startFormListening( const Reference< XPropertySet >& _rxForm, sal_Bool _bPropertiesOnly )
//STRIP001 {
//STRIP001     if ( m_bCanInsert || m_bCanUpdate )   // form can be modified
//STRIP001     {
//STRIP001         _rxForm->addPropertyChangeListener( FM_PROP_ISNEW, this );
//STRIP001         _rxForm->addPropertyChangeListener( FM_PROP_ISMODIFIED, this );
//STRIP001 
//STRIP001 		if ( !_bPropertiesOnly )
//STRIP001 		{
//STRIP001 			// set the Listener for UI interaction
//STRIP001 			Reference< XRowSetApproveBroadcaster > xApprove( _rxForm, UNO_QUERY );
//STRIP001 			if ( xApprove.is() )
//STRIP001 				xApprove->addRowSetApproveListener( this );
//STRIP001 
//STRIP001 			// listener for row set changes
//STRIP001 			Reference< XRowSet > xRowSet( _rxForm, UNO_QUERY );
//STRIP001 			if ( xRowSet.is() )
//STRIP001 				xRowSet->addRowSetListener( this );
//STRIP001 		}
//STRIP001     }
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::stopFormListening( const Reference< XPropertySet >& _rxForm, sal_Bool _bPropertiesOnly )
//STRIP001 {
//STRIP001     if ( m_bCanInsert || m_bCanUpdate )
//STRIP001     {
//STRIP001         _rxForm->removePropertyChangeListener( FM_PROP_ISNEW, this );
//STRIP001         _rxForm->removePropertyChangeListener( FM_PROP_ISMODIFIED, this );
//STRIP001 
//STRIP001 		if ( !_bPropertiesOnly )
//STRIP001 		{
//STRIP001 			Reference< XRowSetApproveBroadcaster > xApprove( _rxForm, UNO_QUERY );
//STRIP001 			if (xApprove.is())
//STRIP001 				xApprove->removeRowSetApproveListener(this);
//STRIP001 
//STRIP001 			Reference< XRowSet > xRowSet( _rxForm, UNO_QUERY );
//STRIP001 			if ( xRowSet.is() )
//STRIP001 				xRowSet->removeRowSetListener( this );
//STRIP001 		}
//STRIP001     }
//STRIP001 }

// ::com::sun::star::sdbc::XRowSetListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::cursorMoved(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // toggle the locking ?
//STRIP001     if (m_bLocked != determineLockState())
//STRIP001     {
//STRIP001         ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001         m_bLocked = !m_bLocked;
//STRIP001         setLocks();
//STRIP001         if (isListeningForChanges())
//STRIP001             startListening();
//STRIP001         else
//STRIP001             stopListening();
//STRIP001     }
//STRIP001 
//STRIP001 	// neither the current control nor the current record are modified anymore
//STRIP001 	m_bCurrentRecordModified = m_bModified = sal_False;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::rowChanged(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/     // not interested in ...
/*?*/ }
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::rowSetChanged(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/     // not interested in ...
/*?*/ }


// ::com::sun::star::container::XContainerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementInserted(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xControl;
//STRIP001     evt.Element >>= xControl;
//STRIP001     if (!xControl.is())
//STRIP001         return;
//STRIP001 
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     Reference< ::com::sun::star::form::XFormComponent >  xModel(xControl->getModel(), UNO_QUERY);
//STRIP001     if (xModel.is() && m_xModelAsIndex == xModel->getParent())
//STRIP001     {
//STRIP001         insertControl(xControl);
//STRIP001 
//STRIP001         if (m_aInsertTimer.IsActive())
//STRIP001             m_aInsertTimer.Stop();
//STRIP001 
//STRIP001         m_aInsertTimer.Start();
//STRIP001     }
//STRIP001     // are we in filtermode and a ::com::sun::star::util::XModeSelector has inserted an element
//STRIP001     else if (m_bFiltering && Reference< ::com::sun::star::util::XModeSelector > (evt.Source, UNO_QUERY).is())
//STRIP001     {
//STRIP001         xModel = Reference< ::com::sun::star::form::XFormComponent > (evt.Source, UNO_QUERY);
//STRIP001         if (xModel.is() && m_xModelAsIndex == xModel->getParent())
//STRIP001         {
//STRIP001             Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001             if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001             {
//STRIP001                 // does the model use a bound field ?
//STRIP001                 Reference< XPropertySet >  xField;
//STRIP001                 xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 
//STRIP001                 Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001                 // may we filter the field?
//STRIP001                 if (xText.is() && xField.is() && ::comphelper::hasProperty(FM_PROP_SEARCHABLE, xField) &&
//STRIP001                     ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_SEARCHABLE)))
//STRIP001                 {
//STRIP001                     m_aFilterControls[xText] = xField;
//STRIP001                     xText->addTextListener(this);
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementReplaced(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 
//STRIP001     // Remove the control
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xReplControl;
//STRIP001     evt.ReplacedElement >>= xReplControl;
//STRIP001     Reference< ::com::sun::star::form::XFormComponent >  xModel(xReplControl->getModel(), UNO_QUERY);
//STRIP001     if (xModel.is() && m_xModelAsIndex == xModel->getParent())
//STRIP001         removeControl(xReplControl);
//STRIP001     else if (m_aFilterControls.size())
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xText(xReplControl, UNO_QUERY);
//STRIP001         FmFilterControls::iterator iter = m_aFilterControls.find(xText);
//STRIP001         if (iter != m_aFilterControls.end())
//STRIP001             m_aFilterControls.erase(iter);
//STRIP001     }
//STRIP001 
//STRIP001     // Add the new one
//STRIP001     elementInserted(evt);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementRemoved(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xControl;
//STRIP001     evt.Element >>= xControl;
//STRIP001     if (!xControl.is())
//STRIP001         return;
//STRIP001 
//STRIP001     Reference< ::com::sun::star::form::XFormComponent >  xModel(xControl->getModel(), UNO_QUERY);
//STRIP001     if (xModel.is() && m_xModelAsIndex == xModel->getParent())
//STRIP001     {
//STRIP001         removeControl(xControl);
//STRIP001         // TabOrder nicht neu berechnen, da das intern schon funktionieren mu!
//STRIP001     }
//STRIP001     else if (m_aFilterControls.size())
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001         FmFilterControls::iterator iter = m_aFilterControls.find(xText);
//STRIP001         if (iter != m_aFilterControls.end())
//STRIP001             m_aFilterControls.erase(iter);
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 Reference< ::com::sun::star::awt::XControl >  FmXFormController::isInList(const Reference< ::com::sun::star::awt::XWindowPeer > & xPeer) const
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pCtrls = m_aControls.getConstArray();
//STRIP001 
//STRIP001     sal_uInt32 nCtrls = m_aControls.getLength();
//STRIP001     for ( sal_uInt32 n = 0; n < nCtrls && xPeer.is(); n++ )
//STRIP001     {
//STRIP001         if (pCtrls[n].is())
//STRIP001         {
//STRIP001             Reference< ::com::sun::star::awt::XVclWindowPeer >  xCtrlPeer(pCtrls[n]->getPeer(), UNO_QUERY);
//STRIP001             if ((::com::sun::star::awt::XWindowPeer*)xCtrlPeer.get() == (::com::sun::star::awt::XWindowPeer*)xPeer.get() || xCtrlPeer->isChild(xPeer))
//STRIP001                 return pCtrls[n];
//STRIP001         }
//STRIP001     }
//STRIP001     return Reference< ::com::sun::star::awt::XControl > ();
//STRIP001 }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::activateFirst() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     DBG_ASSERT(m_xTabController.is(), "FmXFormController::activateFirst : invalid aggregate !");
//STRIP001     if (m_xTabController.is())
//STRIP001         m_xTabController->activateFirst();
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::activateLast() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     DBG_ASSERT(m_xTabController.is(), "FmXFormController::activateLast : invalid aggregate !");
//STRIP001     if (m_xTabController.is())
//STRIP001         m_xTabController->activateLast();
/*?*/ }

// ::com::sun::star::form::XFormController
//------------------------------------------------------------------------------
/*N*/ Reference< XControl> SAL_CALL FmXFormController::getCurrentControl(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/ 	return m_xCurrentControl;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::addActivateListener(const Reference< XFormControllerListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/ 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/ 	m_aActivateListeners.addInterface(l);
/*N*/ }
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::removeActivateListener(const Reference< XFormControllerListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 	m_aActivateListeners.removeInterface(l);
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::setFilter(vector<FmFieldInfo>& rFieldInfos)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 	// create the composer
//STRIP001 	Reference< XRowSet > xForm(m_xModelAsIndex, UNO_QUERY);
//STRIP001 	Reference< XConnection > xConnection(OStaticDataAccessTools().getRowSetConnection(xForm));
//STRIP001 	if (xForm.is())
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::sdb::XSQLQueryComposerFactory >  xFactory(xConnection, UNO_QUERY);
//STRIP001 		if (xFactory.is())
//STRIP001 		{
//STRIP001 			m_xComposer = xFactory->createQueryComposer();
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Reference< XPropertySet >  xSet(xForm, UNO_QUERY);
//STRIP001 				::rtl::OUString	aStatement	= ::comphelper::getString(xSet->getPropertyValue(FM_PROP_ACTIVECOMMAND));
//STRIP001 				::rtl::OUString aFilter		= ::comphelper::getString(xSet->getPropertyValue(FM_PROP_FILTER_CRITERIA));
//STRIP001 				m_xComposer->setQuery(aStatement);
//STRIP001 				m_xComposer->setFilter(aFilter);
//STRIP001 			}
//STRIP001 			catch(const Exception&)
//STRIP001 			{
//STRIP001 				DBG_ERROR("Exception occured!");
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (m_xComposer.is())
//STRIP001 	{
//STRIP001 		Sequence < PropertyValue> aLevel;
//STRIP001 		Sequence< Sequence < PropertyValue > > aFilterRows = m_xComposer->getStructuredFilter();
//STRIP001 
//STRIP001 		// ok, we recieve the list of filters as sequence of fieldnames, value
//STRIP001 		// now we have to transform the fieldname into UI names, that could be a label of the field or
//STRIP001 		// a aliasname or the fieldname itself
//STRIP001 
//STRIP001 		// first adjust the field names if necessary
//STRIP001 		Reference< ::com::sun::star::container::XNameAccess> xQueryColumns = Reference< ::com::sun::star::sdbcx::XColumnsSupplier >
//STRIP001 											(m_xComposer, UNO_QUERY)->getColumns();
//STRIP001 
//STRIP001 		for (vector<FmFieldInfo>::iterator iter = rFieldInfos.begin();
//STRIP001 			iter != rFieldInfos.end(); iter++)
//STRIP001 		{
//STRIP001 			if ( xQueryColumns->hasByName((*iter).aFieldName) ) 
//STRIP001 			{
//STRIP001 				if ( (xQueryColumns->getByName((*iter).aFieldName) >>= (*iter).xField) && (*iter).xField.is() )
//STRIP001 					(*iter).xField->getPropertyValue(FM_PROP_REALNAME) >>= (*iter).aFieldName;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::sdbc::XDatabaseMetaData> xMetaData(xConnection->getMetaData());
//STRIP001 		// now transfer the filters into Value/TextComponent pairs
//STRIP001 		::comphelper::UStringMixEqual aCompare(xMetaData->storesMixedCaseQuotedIdentifiers());
//STRIP001 
//STRIP001 		// need to parse criteria localized
//STRIP001 		OStaticDataAccessTools aStaticTools;
//STRIP001 		Reference< ::com::sun::star::util::XNumberFormatsSupplier> xFormatSupplier( aStaticTools.getNumberFormats(xConnection, sal_True));
//STRIP001         Reference< ::com::sun::star::util::XNumberFormatter> xFormatter(m_xORB
//STRIP001                         ->createInstance(::rtl::OUString::createFromAscii("com.sun.star.util.NumberFormatter")), UNO_QUERY);
//STRIP001         xFormatter->attachNumberFormatsSupplier(xFormatSupplier);
//STRIP001 		::com::sun::star::lang::Locale aAppLocale = Application::GetSettings().GetUILocale();
//STRIP001 		LocaleDataWrapper aLocaleWrapper(m_xORB,aAppLocale);
//STRIP001 
//STRIP001 		// retrieving the filter
//STRIP001 		const Sequence < PropertyValue >* pRow = aFilterRows.getConstArray();
//STRIP001 		for (sal_Int32 i = 0, nLen = aFilterRows.getLength(); i < nLen; ++i)
//STRIP001 		{
//STRIP001 			FmFilterRow aRow;
//STRIP001 
//STRIP001 			// search a field for the given name
//STRIP001 			const PropertyValue* pRefValues = pRow[i].getConstArray();
//STRIP001 			for (sal_Int32 j = 0, nLen1 = pRow[i].getLength(); j < nLen1; j++)
//STRIP001 			{
//STRIP001 				// look for the text component
//STRIP001 				Reference< XPropertySet > xField;
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Reference< XPropertySet > xSet;
//STRIP001 					::rtl::OUString aRealName;
//STRIP001 
//STRIP001 					// first look with the given name
//STRIP001 					if (xQueryColumns->hasByName(pRefValues[j].Name))
//STRIP001 					{
//STRIP001 						xQueryColumns->getByName(pRefValues[j].Name) >>= xSet;
//STRIP001 
//STRIP001 						// get the RealName
//STRIP001 						xSet->getPropertyValue(::rtl::OUString::createFromAscii("RealName")) >>= aRealName;
//STRIP001 
//STRIP001 						// compare the condition field name and the RealName
//STRIP001 						if (aCompare(aRealName, pRefValues[j].Name))
//STRIP001 							xField = xSet;
//STRIP001 					}
//STRIP001 					if (!xField.is())
//STRIP001 					{
//STRIP001 						// no we have to check every column to find the realname
//STRIP001 						Reference< ::com::sun::star::container::XIndexAccess > xColumnsByIndex(xQueryColumns, UNO_QUERY);
//STRIP001 						for (sal_Int32 n = 0, nCount = xColumnsByIndex->getCount(); n < nCount; n++)
//STRIP001 						{
//STRIP001 							xColumnsByIndex->getByIndex(n) >>= xSet;
//STRIP001 							xSet->getPropertyValue(::rtl::OUString::createFromAscii("RealName")) >>= aRealName;
//STRIP001 							if (aCompare(aRealName, pRefValues[j].Name))
//STRIP001 							{
//STRIP001 								// get the column by its alias
//STRIP001 								xField = xSet;
//STRIP001 								break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					if (!xField.is())
//STRIP001 						continue;
//STRIP001 				}
//STRIP001 				catch (const Exception&)
//STRIP001 				{
//STRIP001 					continue;
//STRIP001 				}
//STRIP001 
//STRIP001 				// find the text component
//STRIP001 				for (vector<FmFieldInfo>::iterator iter = rFieldInfos.begin();
//STRIP001 					iter != rFieldInfos.end(); iter++)
//STRIP001 				{
//STRIP001 					// we found the field so insert a new entry to the filter row
//STRIP001 					if ((*iter).xField == xField)
//STRIP001 					{
//STRIP001 						// do we already have the control ?
//STRIP001 						if (aRow.find((*iter).xText) != aRow.end())
//STRIP001 						{
//STRIP001 							::rtl::OUString aCompText = aRow[(*iter).xText];
//STRIP001 							aCompText += ::rtl::OUString::createFromAscii(" ");
//STRIP001 							::rtl::OString aVal = m_xParser->getContext().getIntlKeywordAscii(OParseContext::KEY_AND);
//STRIP001 							aCompText += ::rtl::OUString(aVal.getStr(),aVal.getLength(),RTL_TEXTENCODING_ASCII_US);
//STRIP001 							aCompText += ::rtl::OUString::createFromAscii(" ");
//STRIP001 							aCompText += ::comphelper::getString(pRefValues[j].Value);
//STRIP001 							aRow[(*iter).xText] = aCompText;
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							::rtl::OUString sPredicate,sErrorMsg;
//STRIP001 							pRefValues[j].Value >>= sPredicate;
//STRIP001 							::rtl::Reference< ISQLParseNode > xParseNode = predicateTree(sErrorMsg, sPredicate, xFormatter, xField);
//STRIP001                             if ( xParseNode.is() )
//STRIP001                             {
//STRIP001 								::rtl::OUString sCriteria;
//STRIP001 								xParseNode->parseNodeToPredicateStr( sCriteria
//STRIP001 																	,xMetaData
//STRIP001 																	,xFormatter
//STRIP001 																	,xField
//STRIP001 																	,aAppLocale
//STRIP001 																	,(sal_Char)aLocaleWrapper.getNumDecimalSep().GetChar(0)
//STRIP001 																	,getParseContext());
//STRIP001                                 aRow[(*iter).xText] = sCriteria;
//STRIP001                             }
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (aRow.empty())
//STRIP001 				continue;
//STRIP001 
//STRIP001 			m_aFilters.push_back(aRow);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// now set the filter controls
//STRIP001 	for (vector<FmFieldInfo>::iterator iter = rFieldInfos.begin();
//STRIP001 		 iter != rFieldInfos.end(); iter++)
//STRIP001 	{
//STRIP001 		m_aFilterControls[(*iter).xText] = (*iter).xField;
//STRIP001 	}
//STRIP001 
//STRIP001 	// add an empty row
//STRIP001 	m_aFilters.push_back(FmFilterRow());
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::startFiltering()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!m_pView)
//STRIP001     {
//STRIP001         DBG_ERROR("FmXFormController::startFiltering : you can't filter if you created me as service !");
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001 	OStaticDataAccessTools aStaticTools;
//STRIP001     Reference< XConnection >  xConnection( aStaticTools.getRowSetConnection( Reference< XRowSet >( m_xModelAsIndex, UNO_QUERY ) ) );
//STRIP001 	if ( !xConnection.is() )
//STRIP001 		// nothing to do - can't filter a form which is not connected
//STRIP001 		// 98023 - 19.03.2002 - fs@openoffice.org
//STRIP001 		return;
//STRIP001 
//STRIP001     // stop listening for controls
//STRIP001     if (isListeningForChanges())
//STRIP001         stopListening();
//STRIP001 
//STRIP001     m_bFiltering = sal_True;
//STRIP001 
//STRIP001     // as we don't want new controls to be attached to the scripting environment
//STRIP001     // we change attach flags
//STRIP001     m_bAttachEvents = sal_False;
//STRIP001 
//STRIP001     // Austauschen der Kontrols fuer das aktuelle Formular
//STRIP001     Sequence < Reference< ::com::sun::star::awt::XControl >  > aControls(m_aControls);
//STRIP001     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001     SdrPageView* pCurPageView = m_pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001     // the control we have to activate after replacement
//STRIP001     Reference< ::com::sun::star::awt::XControl >  xNewActiveControl;
//STRIP001     Reference< ::com::sun::star::sdbc::XDatabaseMetaData >  xMetaData(xConnection->getMetaData());
//STRIP001     Reference< ::com::sun::star::util::XNumberFormatsSupplier >  xFormatSupplier = aStaticTools.getNumberFormats(xConnection, sal_True);
//STRIP001     Reference< ::com::sun::star::util::XNumberFormatter >  xFormatter(m_xORB
//STRIP001                         ->createInstance(::rtl::OUString::createFromAscii("com.sun.star.util.NumberFormatter")), UNO_QUERY);
//STRIP001     xFormatter->attachNumberFormatsSupplier(xFormatSupplier);
//STRIP001 
//STRIP001     // structure for storing the field info
//STRIP001     vector<FmFieldInfo> aFieldInfos;
//STRIP001 
//STRIP001     sal_uInt16 nPos = pCurPageView ? pCurPageView->GetWinList().Find((OutputDevice*)m_pView->GetActualOutDev()) : SDRPAGEVIEWWIN_NOTFOUND;
//STRIP001     if (nPos != SDRPAGEVIEWWIN_NOTFOUND)
//STRIP001     {
//STRIP001         for (sal_Int32 i = aControls.getLength(); i > 0;)
//STRIP001         {
//STRIP001             const Reference< ::com::sun::star::awt::XControl > & xControl = pControls[--i];
//STRIP001             if (xControl.is())
//STRIP001             {
//STRIP001                 // no events for the control anymore
//STRIP001                 removeFromEventAttacher(xControl);
//STRIP001 
//STRIP001                 // do we have a mode selector
//STRIP001                 Reference< ::com::sun::star::util::XModeSelector >  xSelector(xControl, UNO_QUERY);
//STRIP001                 if (xSelector.is())
//STRIP001                 {
//STRIP001                     xSelector->setMode(FILTER_MODE);
//STRIP001 
//STRIP001                     // listening for new controls of the selector
//STRIP001                     Reference< ::com::sun::star::container::XContainer >  xContainer(xSelector, UNO_QUERY);
//STRIP001                     if (xContainer.is())
//STRIP001                         xContainer->addContainerListener(this);
//STRIP001 
//STRIP001                     Reference< ::com::sun::star::container::XEnumerationAccess >  xElementAccess(xSelector, UNO_QUERY);
//STRIP001                     if (xElementAccess.is())
//STRIP001                     {
//STRIP001                         Reference< ::com::sun::star::container::XEnumeration >  xEnumeration(xElementAccess->createEnumeration());
//STRIP001                         Reference< ::com::sun::star::awt::XControl >  xControl;
//STRIP001                         while (xEnumeration->hasMoreElements())
//STRIP001                         {
//STRIP001                             xEnumeration->nextElement() >>= xControl;
//STRIP001                             if (xControl.is())
//STRIP001                             {
//STRIP001                                 Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001                                 if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001                                 {
//STRIP001                                     // does the model use a bound field ?
//STRIP001                                     Reference< XPropertySet >  xField;
//STRIP001                                     xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 
//STRIP001                                     Reference< ::com::sun::star::awt::XTextComponent >  xText(xControl, UNO_QUERY);
//STRIP001                                     // may we filter the field?
//STRIP001                                     if (xText.is() && xField.is() && ::comphelper::hasProperty(FM_PROP_SEARCHABLE, xField) &&
//STRIP001                                         ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_SEARCHABLE)))
//STRIP001                                     {
//STRIP001                                         aFieldInfos.push_back(FmFieldInfo(xField, xText));
//STRIP001                                         xText->addTextListener(this);
//STRIP001                                     }
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                     continue;
//STRIP001                 }
//STRIP001 
//STRIP001                 Reference< XPropertySet >  xModel( xControl->getModel(), UNO_QUERY );
//STRIP001                 if (xModel.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xModel))
//STRIP001                 {
//STRIP001                     // does the model use a bound field ?
//STRIP001                     Any aVal = xModel->getPropertyValue(FM_PROP_BOUNDFIELD);
//STRIP001                     Reference< XPropertySet >  xField;
//STRIP001                     aVal >>= xField;
//STRIP001 
//STRIP001                     // may we filter the field?
//STRIP001 
//STRIP001                     if (xField.is() && ::comphelper::hasProperty(FM_PROP_SEARCHABLE, xField) &&
//STRIP001                         ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_SEARCHABLE)))
//STRIP001                     {
//STRIP001                         const SdrPageViewWinRec& rWR = pCurPageView->GetWinList()[nPos];
//STRIP001                         const SdrUnoControlList& rControlList = rWR.GetControlList();
//STRIP001                         sal_uInt16 nCtrlNum = rControlList.Find(xControl);
//STRIP001                         if (nCtrlNum != SDRUNOCONTROL_NOTFOUND)
//STRIP001                         {
//STRIP001                             // Setzen des FilterControls
//STRIP001                             SdrUnoControlRec& rControlRec = (SdrUnoControlRec&)rControlList[nCtrlNum];
//STRIP001 
//STRIP001 							// create a filter control
//STRIP001 							Sequence< Any > aCreationArgs( 3 );
//STRIP001 							aCreationArgs[ 0 ] <<= NamedValue( ::rtl::OUString::createFromAscii( "MessageParent" ), makeAny( VCLUnoHelper::GetInterface( m_pWindow ) ) );
//STRIP001 							aCreationArgs[ 1 ] <<= NamedValue( ::rtl::OUString::createFromAscii( "NumberFormatter" ), makeAny( xFormatter ) );
//STRIP001 							aCreationArgs[ 2 ] <<= NamedValue( ::rtl::OUString::createFromAscii( "ControlModel" ), makeAny( xModel ) );
//STRIP001 							Reference< XControl > xFilterControl(
//STRIP001 								m_xORB->createInstanceWithArguments(
//STRIP001 									::rtl::OUString::createFromAscii( "com.sun.star.form.control.FilterControl" ),
//STRIP001 									aCreationArgs
//STRIP001 								),
//STRIP001 								UNO_QUERY
//STRIP001 							);
//STRIP001 							DBG_ASSERT( xFilterControl.is(), "FmXFormController::startFiltering: could not create a filter control!" );
//STRIP001 
//STRIP001                             Reference< XTextComponent >  xText( xFilterControl, UNO_QUERY );
//STRIP001 
//STRIP001                             // merken in der Map
//STRIP001                             aFieldInfos.push_back(FmFieldInfo(xField, xText));
//STRIP001                             xText->addTextListener(this);
//STRIP001 
//STRIP001                             // setting the focus if the current control
//STRIP001                             // is the active one
//STRIP001                             if (m_xActiveControl.get() == xControl.get())
//STRIP001                             {
//STRIP001                                 xNewActiveControl = xFilterControl;
//STRIP001                                 m_xActiveControl = m_xCurrentControl = NULL;
//STRIP001                             }
//STRIP001                             else if (m_xCurrentControl.get() == xControl.get())
//STRIP001                                 m_xCurrentControl = xFilterControl;
//STRIP001 
//STRIP001                             rControlRec.ReplaceControl( xFilterControl );
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     // abmelden vom EventManager
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // we have all filter controls now, so the next step is to read the filters from the form
//STRIP001     // resolve all aliases and set the current filter to the according structure
//STRIP001     setFilter(aFieldInfos);
//STRIP001 
//STRIP001     // setting the focus to the replacing control
//STRIP001     Reference< ::com::sun::star::awt::XWindow >  xWindow(xNewActiveControl, UNO_QUERY);
//STRIP001     if (xWindow.is())
//STRIP001         xWindow->setFocus();
//STRIP001 
//STRIP001     Reference< XPropertySet > xSet( m_xModelAsIndex, UNO_QUERY );
//STRIP001 	if ( xSet.is() )
//STRIP001 		stopFormListening( xSet, sal_True );
//STRIP001 
//STRIP001     // set the text for all filters
//STRIP001 	OSL_ENSURE(m_aFilters.size() > m_nCurrentFilterPosition && m_nCurrentFilterPosition >= 0,"m_nCurrentFilterPosition too big");
//STRIP001 	if ( m_nCurrentFilterPosition >= 0 && m_nCurrentFilterPosition < m_aFilters.size() )
//STRIP001 	{
//STRIP001 		FmFilterRow& rRow = m_aFilters[m_nCurrentFilterPosition];
//STRIP001 		for (FmFilterRow::const_iterator iter2 = rRow.begin();
//STRIP001 			iter2 != rRow.end(); iter2++)
//STRIP001 		{
//STRIP001 			(*iter2).first->setText((*iter2).second);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     // lock all controls which are not used for filtering
//STRIP001     m_bLocked = determineLockState();
//STRIP001     setLocks();
//STRIP001     m_bAttachEvents = sal_True;
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::stopFiltering()
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/ 	if ( !m_bFiltering ) // #104693# OJ
/*N*/ 	{	// nothing to do
/*N*/ 		return;
/*N*/ 	}
/*?*/ DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/     if (!m_pView)
//STRIP001 /*?*/     {
//STRIP001 /*?*/         DBG_ERROR("FmXFormController::startFiltering : you can't filter if you created me as service !");
//STRIP001 /*?*/         return;
//STRIP001 /*?*/     }
//STRIP001 /*?*/ 
//STRIP001 /*?*/     m_bFiltering = sal_False;
//STRIP001 /*?*/     m_bDetachEvents = sal_False;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     ::comphelper::disposeComponent(m_xComposer);
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // Austauschen der Kontrols fuer das aktuelle Formular
//STRIP001 /*?*/     Sequence < Reference< ::com::sun::star::awt::XControl >  > aControls(m_aControls);
//STRIP001 /*?*/     const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
//STRIP001 /*?*/     SdrPageView* pCurPageView = m_pView->GetPageViewPvNum(0);
//STRIP001 /*?*/     sal_uInt16 nPos = pCurPageView ? pCurPageView->GetWinList().Find((OutputDevice*)m_pView->GetActualOutDev()) : SDRPAGEVIEWWIN_NOTFOUND;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // the control we have to activate after replacement
//STRIP001 /*?*/     Reference< ::com::sun::star::awt::XControl >  xNewActiveControl;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // clear the filter control map
//STRIP001 /*?*/     for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
//STRIP001 /*?*/          iter != m_aFilterControls.end(); iter++)
//STRIP001 /*?*/          (*iter).first->removeTextListener(this);
//STRIP001 /*?*/ 
//STRIP001 /*?*/     m_aFilterControls.clear();
//STRIP001 /*?*/ 
//STRIP001 /*?*/     if (nPos != SDRPAGEVIEWWIN_NOTFOUND)
//STRIP001 /*?*/     {
//STRIP001 /*?*/         for (sal_Int32 i = aControls.getLength(); i > 0;)
//STRIP001 /*?*/         {
//STRIP001 /*?*/             const Reference< ::com::sun::star::awt::XControl > & xControl = pControls[--i];
//STRIP001 /*?*/             if (xControl.is())
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 // now enable eventhandling again
//STRIP001 /*?*/                 addToEventAttacher(xControl);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 Reference< ::com::sun::star::util::XModeSelector >  xSelector(xControl, UNO_QUERY);
//STRIP001 /*?*/                 if (xSelector.is())
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     xSelector->setMode(DATA_MODE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     // listening for new controls of the selector
//STRIP001 /*?*/                     Reference< ::com::sun::star::container::XContainer >  xContainer(xSelector, UNO_QUERY);
//STRIP001 /*?*/                     if (xContainer.is())
//STRIP001 /*?*/                         xContainer->removeContainerListener(this);
//STRIP001 /*?*/                     continue;
//STRIP001 /*?*/                 }
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 Reference< XPropertySet >  xSet(xControl->getModel(), UNO_QUERY);
//STRIP001 /*?*/                 if (xSet.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     // does the model use a bound field ?
//STRIP001 /*?*/                     Reference< XPropertySet >  xField;
//STRIP001 /*?*/                     xSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     // may we filter the field?
//STRIP001 /*?*/                     if (xField.is() && ::comphelper::hasProperty(FM_PROP_SEARCHABLE, xField) &&
//STRIP001 /*?*/                         ::comphelper::getBOOL(xField->getPropertyValue(FM_PROP_SEARCHABLE)))
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         const SdrPageViewWinRec& rWR = pCurPageView->GetWinList()[nPos];
//STRIP001 /*?*/                         const SdrUnoControlList& rControlList = rWR.GetControlList();
//STRIP001 /*?*/                         sal_uInt16 nCtrlNum = rControlList.Find(xControl);
//STRIP001 /*?*/                         if (nCtrlNum != SDRUNOCONTROL_NOTFOUND)
//STRIP001 /*?*/                         {
//STRIP001 /*?*/                             // Zuruecksetzen des Controls auf das Defaultcontrol
//STRIP001 /*?*/                             SdrUnoControlRec& rControlRec = (SdrUnoControlRec&)rControlList[nCtrlNum];
//STRIP001 /*?*/                             ::rtl::OUString aServiceName = ::comphelper::getString(xSet->getPropertyValue(FM_PROP_DEFAULTCONTROL));
//STRIP001 /*?*/                             Reference< ::com::sun::star::awt::XControl >  xNewControl(m_xORB->createInstance(aServiceName), UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                             // setting the focus if the current control
//STRIP001 /*?*/                             // is the active one
//STRIP001 /*?*/                             if ((::com::sun::star::awt::XControl*)m_xActiveControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001 /*?*/                             {
//STRIP001 /*?*/                                 xNewActiveControl = xNewControl;
//STRIP001 /*?*/                                 m_xActiveControl = m_xCurrentControl = NULL;
//STRIP001 /*?*/                             }
//STRIP001 /*?*/                             else if ((::com::sun::star::awt::XControl*)m_xCurrentControl.get() == (::com::sun::star::awt::XControl*)xControl.get())
//STRIP001 /*?*/                                 m_xCurrentControl = xNewControl;
//STRIP001 /*?*/ 
//STRIP001 /*?*/                             rControlRec.ReplaceControl(xNewControl);
//STRIP001 /*?*/                         }
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                 }
//STRIP001 /*?*/             }
//STRIP001 /*?*/         }
//STRIP001 /*?*/     }
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // setting the focus to the replacing control
//STRIP001 /*?*/     Reference< ::com::sun::star::awt::XWindow >  xWindow(xNewActiveControl, UNO_QUERY);
//STRIP001 /*?*/     if (xWindow.is())
//STRIP001 /*?*/         xWindow->setFocus();
//STRIP001 /*?*/ 
//STRIP001 /*?*/     Reference< XPropertySet >  xSet( m_xModelAsIndex, UNO_QUERY );
//STRIP001 /*?*/     if ( xSet.is() )
//STRIP001 /*?*/ 		startFormListening( xSet, sal_True );
//STRIP001 /*?*/ 
//STRIP001 /*?*/     m_bDetachEvents = sal_True;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     m_aFilters.clear();
//STRIP001 /*?*/     m_nCurrentFilterPosition = 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // release the locks if possible
//STRIP001 /*?*/     // lock all controls which are not used for filtering
//STRIP001 /*?*/     m_bLocked = determineLockState();
//STRIP001 /*?*/     setLocks();
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // restart listening for control modifications
//STRIP001 /*?*/     if (isListeningForChanges())
//STRIP001 /*?*/         startListening();
/*N*/ }

// ::com::sun::star::util::XModeSelector
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::setMode(const ::rtl::OUString& Mode) throw( ::com::sun::star::lang::NoSupportException, RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001 
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (!supportsMode(Mode))
//STRIP001         throw ::com::sun::star::lang::NoSupportException();
//STRIP001 
//STRIP001     if (Mode == m_aMode)
//STRIP001         return;
//STRIP001 
//STRIP001     m_aMode = Mode;
//STRIP001 
//STRIP001     if (Mode == FILTER_MODE)
//STRIP001         startFiltering();
//STRIP001     else
//STRIP001         stopFiltering();
//STRIP001 
//STRIP001     for (FmFormControllers::const_iterator i = m_aChilds.begin();
//STRIP001         i != m_aChilds.end(); ++i)
//STRIP001     {
//STRIP001 		Reference< ::com::sun::star::util::XModeSelector > xMode(*i, UNO_QUERY);
//STRIP001 		if ( xMode.is() )
//STRIP001 			xMode->setMode(Mode);
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::rtl::OUString SAL_CALL FmXFormController::getMode(void) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); ::rtl::OUString a; return a;
//STRIP001 /*?*/ ::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     return m_aMode;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Sequence< ::rtl::OUString > SAL_CALL FmXFormController::getSupportedModes(void) throw( RuntimeException )
/*?*/ {
/*?*/     DBG_BF_ASSERT(0, "STRIP"); Sequence< ::rtl::OUString > aModes; return aModes;//STRIP001 OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     static Sequence< ::rtl::OUString > aModes;
//STRIP001     if (!aModes.getLength())
//STRIP001     {
//STRIP001         aModes.realloc(2);
//STRIP001         ::rtl::OUString* pModes = aModes.getArray();
//STRIP001         pModes[0] = DATA_MODE;
//STRIP001         pModes[1] = FILTER_MODE;
//STRIP001     }
//STRIP001     return aModes;
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL FmXFormController::supportsMode(const ::rtl::OUString& Mode) throw( RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     Sequence< ::rtl::OUString > aModes(getSupportedModes());
//STRIP001     const ::rtl::OUString* pModes = aModes.getConstArray();
//STRIP001     for (sal_Int32 i = aModes.getLength(); i > 0; )
//STRIP001     {
//STRIP001         if (pModes[--i] == Mode)
//STRIP001             return sal_True;
//STRIP001     }
//STRIP001     return sal_False;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 Window* FmXFormController::getDialogParentWindow()
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     Window* pParent = m_pWindow;
//STRIP001     if (!pParent)
//STRIP001     {
//STRIP001         Reference< ::com::sun::star::awt::XControlContainer >  xContainer = getContainer();
//STRIP001         Reference< ::com::sun::star::awt::XControl >  xCtrl(xContainer, UNO_QUERY);
//STRIP001         if (xCtrl.is())
//STRIP001         {
//STRIP001             Reference< ::com::sun::star::awt::XWindowPeer >  xPeer(xCtrl->getPeer(), UNO_QUERY);
//STRIP001             if (xPeer.is())
//STRIP001                 pParent = VCLUnoHelper::GetWindow(xPeer);
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return pParent;
//STRIP001 }
// ::com::sun::star::sdb::XRowSetApproveListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveRowChange(const ::com::sun::star::sdb::RowChangeEvent& aEvent) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aRowSetApproveListeners);
//STRIP001     sal_Bool bValid = sal_True;
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::sdb::RowChangeEvent aEvt(aEvent);
//STRIP001         aEvt.Source = *this;
//STRIP001         bValid = ((::com::sun::star::sdb::XRowSetApproveListener*)aIter.next())->approveRowChange(aEvt);
//STRIP001     }
//STRIP001 
//STRIP001     if (bValid && (
//STRIP001         aEvent.Action == ::com::sun::star::sdb::RowChangeAction::INSERT ||
//STRIP001         aEvent.Action == ::com::sun::star::sdb::RowChangeAction::UPDATE))
//STRIP001     {
//STRIP001         if (m_pView)
//STRIP001         {   // we're working for a FormView
//STRIP001             if (!(m_pWindow || (m_pView->GetActualOutDev() == (const OutputDevice*)m_pWindow ||
//STRIP001                 !m_pView->GetActualOutDev() && m_pWindow->IsActive())))
//STRIP001                 // we're not active
//STRIP001                 return sal_True;
//STRIP001         }
//STRIP001         // default handling
//STRIP001         // check Values on NULL and required flag
//STRIP001         Reference< ::com::sun::star::sdbcx::XColumnsSupplier >  xSupplyCols(aEvent.Source, UNO_QUERY);
//STRIP001         Reference< ::com::sun::star::container::XEnumerationAccess >  xEnumAccess;
//STRIP001         if (xSupplyCols.is())
//STRIP001             xEnumAccess = Reference< ::com::sun::star::container::XEnumerationAccess > (xSupplyCols->getColumns(),UNO_QUERY);
//STRIP001 
//STRIP001         if (!xSupplyCols.is() || !xEnumAccess.is())
//STRIP001         {
//STRIP001             DBG_ERROR("FmXFormController::approveRowChange : source is no columns supplier or columns aren't enumerable !");
//STRIP001             // can't do anything here ...
//STRIP001             return sal_True;
//STRIP001         }
//STRIP001 
//STRIP001         Reference< ::com::sun::star::container::XEnumeration >  xEnumeration = xEnumAccess->createEnumeration();
//STRIP001         Reference< XPropertySet >  xFieldSet;
//STRIP001         while (xEnumeration->hasMoreElements())
//STRIP001         {
//STRIP001             xEnumeration->nextElement() >>= xFieldSet;
//STRIP001             Reference< ::com::sun::star::sdb::XColumn >  xColumn(xFieldSet, UNO_QUERY);
//STRIP001             if (!xFieldSet.is() || !xColumn.is())
//STRIP001             {
//STRIP001                 DBG_ERROR("FmXFormController::approveRowChange : invalid field !");
//STRIP001                 continue;
//STRIP001             }
//STRIP001 
//STRIP001             sal_Bool bRequired = ::comphelper::getINT32(xFieldSet->getPropertyValue(FM_PROP_ISNULLABLE)) == ::com::sun::star::sdbc::ColumnValue::NO_NULLS;
//STRIP001             if (!bRequired)
//STRIP001                 continue;
//STRIP001 
//STRIP001             sal_Bool bAutoIncrement = ::comphelper::getBOOL(xFieldSet->getPropertyValue(FM_PROP_AUTOINCREMENT));
//STRIP001             if (bAutoIncrement)
//STRIP001                 continue;
//STRIP001 
//STRIP001             ::rtl::OUString aFieldName(::comphelper::getString(xFieldSet->getPropertyValue(FM_PROP_NAME)));
//STRIP001 
//STRIP001             if (!xColumn->getString().getLength() && xColumn->wasNull())
//STRIP001             {
//STRIP001                 Sequence< Reference< ::com::sun::star::awt::XControl > > aControls(getControls());
//STRIP001                 sal_Int32 nLength = aControls.getLength();
//STRIP001                 sal_Int32 i(0);
//STRIP001                 const Reference< ::com::sun::star::awt::XControl > * pControls = aControls.getConstArray();
//STRIP001                 for (; i < nLength; i++)
//STRIP001                 {
//STRIP001                     if (pControls[i].is())
//STRIP001                     {
//STRIP001                         Reference< XPropertySet >  xModel(pControls[i]->getModel(), UNO_QUERY);
//STRIP001                         if (xModel.is())
//STRIP001                         {
//STRIP001                             if (::comphelper::hasProperty(FM_PROP_CONTROLSOURCE, xModel))
//STRIP001                             {
//STRIP001                                 ::rtl::OUString aName = ::comphelper::getString(xModel->getPropertyValue(FM_PROP_CONTROLSOURCE));
//STRIP001                                 if (aName == aFieldName)    // Control gefunden
//STRIP001                                     break;
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 String aMsg(SVX_RES(RID_ERR_FIELDREQUIRED));
//STRIP001                 aMsg.SearchAndReplace('#', aFieldName.getStr());
//STRIP001 
//STRIP001 				SQLContext aError;
//STRIP001 				aError.Message = String(SVX_RES(RID_STR_WRITEERROR));
//STRIP001 				aError.Details = aMsg;
//STRIP001 				displayException(aError, getDialogParentWindow());
//STRIP001 
//STRIP001                 if ( i < nLength)
//STRIP001                 {
//STRIP001                     Reference< ::com::sun::star::awt::XWindow >  xWindow(pControls[i], UNO_QUERY);
//STRIP001                     xWindow->setFocus();
//STRIP001                 }
//STRIP001                 return sal_False;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     return bValid;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveCursorMove(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aRowSetApproveListeners);
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::lang::EventObject aEvt(event);
//STRIP001         aEvt.Source = *this;
//STRIP001         return ((::com::sun::star::sdb::XRowSetApproveListener*)aIter.next())->approveCursorMove(aEvt);
//STRIP001     }
//STRIP001 
//STRIP001     return sal_True;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveRowSetChange(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;	
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aRowSetApproveListeners);
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::lang::EventObject aEvt(event);
//STRIP001         aEvt.Source = *this;
//STRIP001         return ((::com::sun::star::sdb::XRowSetApproveListener*)aIter.next())->approveRowSetChange(aEvt);
//STRIP001     }
//STRIP001 
//STRIP001     return sal_True;
/*?*/ }

// ::com::sun::star::sdb::XRowSetApproveBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addRowSetApproveListener(const Reference< ::com::sun::star::sdb::XRowSetApproveListener > & _rxListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aRowSetApproveListeners.addInterface(_rxListener);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeRowSetApproveListener(const Reference< ::com::sun::star::sdb::XRowSetApproveListener > & _rxListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aRowSetApproveListeners.removeInterface(_rxListener);
/*?*/ }

// ::com::sun::star::form::XErrorListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::errorOccured(const ::com::sun::star::sdb::SQLErrorEvent& aEvent) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (m_pView)
//STRIP001     {   // we're working for a FormView
//STRIP001         if (!(m_pWindow || (m_pView->GetActualOutDev() == (const OutputDevice*)m_pWindow ||
//STRIP001             !m_pView->GetActualOutDev() && m_pWindow->IsActive())))
//STRIP001             // we're not active
//STRIP001             return;
//STRIP001     }
//STRIP001 
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aErrorListeners);
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::sdb::SQLErrorEvent aEvt(aEvent);
//STRIP001         aEvt.Source = *this;
//STRIP001         ((::com::sun::star::sdb::XSQLErrorListener*)aIter.next())->errorOccured(aEvt);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         displayException(aEvent);
//STRIP001     }
/*?*/ }

// ::com::sun::star::form::XErrorBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addSQLErrorListener(const Reference< ::com::sun::star::sdb::XSQLErrorListener > & aListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aErrorListeners.addInterface(aListener);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeSQLErrorListener(const Reference< ::com::sun::star::sdb::XSQLErrorListener > & aListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
//STRIP001 	::osl::MutexGuard aGuard( m_aMutex );
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aErrorListeners.removeInterface(aListener);
/*?*/ }

// ::com::sun::star::form::XDatabaseParameterBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addParameterListener(const Reference< ::com::sun::star::form::XDatabaseParameterListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aParameterListeners.addInterface(aListener);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeParameterListener(const Reference< ::com::sun::star::form::XDatabaseParameterListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aParameterListeners.removeInterface(aListener);
/*?*/ }

// ::com::sun::star::form::XDatabaseParameterListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveParameter(const ::com::sun::star::form::DatabaseParameterEvent& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (m_pView)
//STRIP001     {   // we're working for a FormView
//STRIP001         if (!(m_pWindow || (m_pView->GetActualOutDev() == (const OutputDevice*)m_pWindow ||
//STRIP001             !m_pView->GetActualOutDev() && m_pWindow->IsActive())))
//STRIP001             // we're not active
//STRIP001             return sal_True;
//STRIP001     }
//STRIP001 
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aParameterListeners);
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::form::DatabaseParameterEvent aEvt(aEvent);
//STRIP001         aEvt.Source = *this;
//STRIP001         return ((::com::sun::star::form::XDatabaseParameterListener*)aIter.next())->approveParameter(aEvt);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // default handling: instantiate an interaction handler and let it handle the parameter request
//STRIP001         try
//STRIP001         {
//STRIP001             // two continuations allowed: OK and Cancel
//STRIP001             OParameterContinuation* pParamValues = new OParameterContinuation;
//STRIP001             OInteractionAbort* pAbort = new OInteractionAbort;
//STRIP001             // the request
//STRIP001             ParametersRequest aRequest;
//STRIP001             aRequest.Parameters = aEvent.Parameters;
//STRIP001             aRequest.Connection = OStaticDataAccessTools().getRowSetConnection(Reference< XRowSet >(aEvent.Source, UNO_QUERY));
//STRIP001             OInteractionRequest* pParamRequest = new OInteractionRequest(makeAny(aRequest));
//STRIP001             Reference< XInteractionRequest > xParamRequest(pParamRequest);
//STRIP001             // some knittings
//STRIP001             pParamRequest->addContinuation(pParamValues);
//STRIP001             pParamRequest->addContinuation(pAbort);
//STRIP001 
//STRIP001             // create the handler, let it handle the request
//STRIP001             Reference< XInteractionHandler > xHandler(m_xORB->createInstance(SRV_SDB_INTERACTION_HANDLER), UNO_QUERY);
//STRIP001             if (xHandler.is())
//STRIP001             {
//STRIP001                 ::vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001                 xHandler->handle(xParamRequest);
//STRIP001             }
//STRIP001 
//STRIP001             if (!pParamValues->wasSelected())
//STRIP001                 // canceled
//STRIP001                 return sal_False;
//STRIP001 
//STRIP001             // transfer the values into the parameter supplier
//STRIP001             Sequence< PropertyValue > aFinalValues = pParamValues->getValues();
//STRIP001             if (aFinalValues.getLength() != aRequest.Parameters->getCount())
//STRIP001             {
//STRIP001                 DBG_ERROR("FmXFormController::approveParameter: the InteractionHandler returned nonsense!");
//STRIP001                 return sal_False;
//STRIP001             }
//STRIP001             const PropertyValue* pFinalValues = aFinalValues.getConstArray();
//STRIP001             for (sal_Int32 i=0; i<aFinalValues.getLength(); ++i, ++pFinalValues)
//STRIP001             {
//STRIP001                 Reference< XPropertySet > xParam;
//STRIP001                 ::cppu::extractInterface(xParam, aRequest.Parameters->getByIndex(i));
//STRIP001                 if (xParam.is())
//STRIP001                 {
//STRIP001 #ifdef DBG_UTIL
//STRIP001                     ::rtl::OUString sName;
//STRIP001                     xParam->getPropertyValue(FM_PROP_NAME) >>= sName;
//STRIP001                     DBG_ASSERT(sName.equals(pFinalValues->Name), "FmXFormController::approveParameter: suspicious value names!");
//STRIP001 #endif
//STRIP001                     try { xParam->setPropertyValue(FM_PROP_VALUE, pFinalValues->Value); }
//STRIP001                     catch(Exception&)
//STRIP001                     {
//STRIP001                         DBG_ERROR("FmXFormController::approveParameter: setting one of the properties failed!");
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         catch(Exception&)
//STRIP001         {
//STRIP001             DBG_ERROR("FmXFormController::approveParameter: caught an Exception (tried to let the InteractionHandler handle it)!");
//STRIP001         }
//STRIP001     }
//STRIP001     return sal_True;
/*?*/ }

// ::com::sun::star::form::XConfirmDeleteBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addConfirmDeleteListener(const Reference< ::com::sun::star::form::XConfirmDeleteListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aDeleteListeners.addInterface(aListener);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeConfirmDeleteListener(const Reference< ::com::sun::star::form::XConfirmDeleteListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     m_aDeleteListeners.removeInterface(aListener);
/*?*/ }

// ::com::sun::star::form::XConfirmDeleteListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::confirmDelete(const ::com::sun::star::sdb::RowChangeEvent& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP");  return NULL;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     if (m_pView)
//STRIP001     {   // we're working for a FormView
//STRIP001         if (!(m_pWindow || (m_pView->GetActualOutDev() == (const OutputDevice*)m_pWindow ||
//STRIP001             !m_pView->GetActualOutDev() && m_pWindow->IsActive())))
//STRIP001             // we're not active
//STRIP001             return sal_True;
//STRIP001     }
//STRIP001 
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter(m_aDeleteListeners);
//STRIP001     if (aIter.hasMoreElements())
//STRIP001     {
//STRIP001         ::com::sun::star::sdb::RowChangeEvent aEvt(aEvent);
//STRIP001         aEvt.Source = *this;
//STRIP001         return ((::com::sun::star::form::XConfirmDeleteListener*)aIter.next())->confirmDelete(aEvt);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // default handling
//STRIP001         UniString aTitle;
//STRIP001         sal_Int32 nLength = aEvent.Rows;
//STRIP001         if (nLength > 1)
//STRIP001         {
//STRIP001             aTitle = SVX_RES(RID_STR_DELETECONFIRM_RECORDS);
//STRIP001             aTitle.SearchAndReplace('#', String::CreateFromInt32(nLength));
//STRIP001         }
//STRIP001         else
//STRIP001             aTitle = SVX_RES(RID_STR_DELETECONFIRM_RECORD);
//STRIP001 
//STRIP001 		ConfirmDeleteDialog aDlg(getDialogParentWindow(), aTitle);
//STRIP001         return RET_YES == aDlg.Execute();
//STRIP001     }
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Reference< ::com::sun::star::frame::XDispatch >
/*?*/ FmXFormController::interceptedQueryDispatch(sal_uInt16 _nId, const ::com::sun::star::util::URL& aURL,
/*?*/                                             const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags)
/*?*/                                             throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); Reference< ::com::sun::star::frame::XDispatch >  xReturn; return xReturn;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     Reference< ::com::sun::star::frame::XDispatch >  xReturn;
//STRIP001     // dispatches handled by ourself
//STRIP001     if (aURL.Complete == FMURL_CONFIRM_DELETION)
//STRIP001 		xReturn = static_cast<XDispatch*>(this);
//STRIP001 
//STRIP001     // dispatches of FormSlot-URLs we have to translate
//STRIP001     if (!xReturn.is() && aURL.Complete.indexOf(FMURL_FORMSLOTS_PREFIX) == 0)
//STRIP001     {   // TODO : use an ::com::sun::star::util::URLTransformer to split this ::com::sun::star::util::URL and do a real (safe) check
//STRIP001 
//STRIP001         // get the frame we're residing in
//STRIP001         Reference< ::com::sun::star::frame::XModel >  xFrameModel = getXModel(getModel());
//STRIP001         Reference< ::com::sun::star::frame::XController >  xFrameController = xFrameModel.is() ? xFrameModel->getCurrentController() : Reference< ::com::sun::star::frame::XController > ();
//STRIP001         Reference< ::com::sun::star::frame::XFrame >  xFrame = xFrameController.is() ? xFrameController->getFrame() : Reference< ::com::sun::star::frame::XFrame > ();
//STRIP001 
//STRIP001         if (!xFrame.is())
//STRIP001         {
//STRIP001             // bad timing : somebody requested a dispatch, but the model we belong to is not attached to a controller, yet
//STRIP001             // (or the controller isn't attached to a frame). This sometimes happens if a document is opened read-only.
//STRIP001             // As we have no chance to get the "attached" event for the model/controller/frame, we have no chance
//STRIP001             // to refresh the dispatchers later as response to such an event.
//STRIP001             // So we simply try it asynchron until we have that frame.
//STRIP001             if (!m_nUpdateDispatcherEvent)
//STRIP001                 m_nUpdateDispatcherEvent = Application::PostUserEvent(LINK(this, FmXFormController, OnUpdateDispatchers));
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // translate the ::com::sun::star::util::URL : the new ::com::sun::star::util::URL is the old one with a mark : the "path" to our model within it's hierarchy
//STRIP001             DBG_ASSERT(aURL.Mark.getLength() == 0, "FmXFormController::interceptedQueryDispatch : the ::com::sun::star::util::URL shouldn't have a mark !");
//STRIP001             ::rtl::OUString sNewMark;
//STRIP001             ::rtl::OUString sCurrentPath;
//STRIP001             // collect the relative indicies of my model, it's parent, it's parent's parent ..., separate them with a '\'
//STRIP001             Reference< ::com::sun::star::container::XChild >  xChild(getModel(), UNO_QUERY);
//STRIP001             Reference< ::com::sun::star::container::XIndexAccess >  xParent;
//STRIP001             if (xChild.is())
//STRIP001                 ::comphelper::query_interface(xChild->getParent(), xParent);
//STRIP001 
//STRIP001 
//STRIP001             while (xChild.is() && xParent.is())
//STRIP001             {
//STRIP001                 sal_Int32 nPos = getElementPos(xParent, xChild);
//STRIP001 
//STRIP001                 sCurrentPath = ::rtl::OUString::valueOf(nPos);
//STRIP001                 if (sNewMark.getLength())
//STRIP001                 {
//STRIP001                     sCurrentPath += ::rtl::OUString::createFromAscii("\\");
//STRIP001                     sNewMark = sCurrentPath + sNewMark;
//STRIP001                 }
//STRIP001                 else
//STRIP001                     sNewMark = sCurrentPath;
//STRIP001 
//STRIP001                 ::comphelper::query_interface((Reference<XInterface>)xParent, xChild);
//STRIP001 
//STRIP001                 if (xChild.is())
//STRIP001                     ::comphelper::query_interface(xChild->getParent(), xParent);
//STRIP001 
//STRIP001             }
//STRIP001 
//STRIP001             ::com::sun::star::util::URL aNewUrl = aURL;
//STRIP001             // and prepend our dispatch prefix
//STRIP001             ::rtl::OUString aMark = m_sDispatchPrefix;
//STRIP001             aMark += ::rtl::OUString::createFromAscii("\\");
//STRIP001             aMark += sNewMark;
//STRIP001 
//STRIP001             // assemble the new url
//STRIP001             Reference< ::com::sun::star::util::XURLTransformer >  xTransformer(m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer") ), UNO_QUERY);
//STRIP001             if (xTransformer.is())
//STRIP001             {
//STRIP001                 xTransformer->parseStrict(aNewUrl);
//STRIP001                 aNewUrl.Mark = aMark;
//STRIP001                 xTransformer->assemble(aNewUrl);
//STRIP001                 DBG_ASSERT(aNewUrl.Complete.getLength(), "FmXFormController::interceptedQueryDispatch : transformation of the ::com::sun::star::util::URL failed !");
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 DBG_ERROR("FmXFormController::interceptedQueryDispatch : could not create a com.sun.star.util.URLTransformer !");
//STRIP001                 // do it manually ... the service would probably do the same, but to be sure we gave it a chance before doing it ourself
//STRIP001                 aNewUrl.Complete += ::rtl::OUString::createFromAscii("#");
//STRIP001                 aNewUrl.Complete += aNewUrl.Mark;
//STRIP001             }
//STRIP001 
//STRIP001             Reference< ::com::sun::star::frame::XDispatchProvider >  xDispProv(xFrame, UNO_QUERY);
//STRIP001             if (xDispProv.is())
//STRIP001                 xReturn = xDispProv->queryDispatch(aNewUrl, aTargetFrameName, nSearchFlags);
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // no more to offer
//STRIP001     return xReturn;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::dispatch( const URL& _rURL, const Sequence< PropertyValue >& _rArgs ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(sal_False, "FmXFormController::dispatch: never to be called!");
//STRIP001 	// we use the dispatch mechanism only for exposing the XConfirmDeleteListener interface
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addStatusListener( const Reference< XStatusListener >& _rxListener, const URL& _rURL ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     if (_rURL.Complete == FMURL_CONFIRM_DELETION)
//STRIP001 	{
//STRIP001 		if (_rxListener.is())
//STRIP001 		{	// send an initial statusChanged event
//STRIP001 			FeatureStateEvent aEvent;
//STRIP001 			aEvent.FeatureURL = _rURL;
//STRIP001 			aEvent.IsEnabled = sal_True;
//STRIP001 			_rxListener->statusChanged(aEvent);
//STRIP001 			// and don't add the listener at all (the status will never change)
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		OSL_ENSURE(sal_False, "FmXFormController::addStatusListener: invalid (unsupported) URL!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeStatusListener( const Reference< XStatusListener >& _rxListener, const URL& _rURL ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(_rURL.Complete == FMURL_CONFIRM_DELETION, "FmXFormController::removeStatusListener: invalid (unsupported) URL!");
//STRIP001 	// we never really added the listener, so we don't need to remove it
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 Reference< ::com::sun::star::frame::XDispatchProviderInterceptor >  FmXFormController::createInterceptor(const Reference< ::com::sun::star::frame::XDispatchProviderInterception > & _xInterception)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001 #if DBG_UTIL
//STRIP001     // check if we already have a interceptor for the given object
//STRIP001     for (   ConstInterceptorsIterator aIter = m_aControlDispatchInterceptors.begin();
//STRIP001             aIter != m_aControlDispatchInterceptors.end();
//STRIP001             ++aIter
//STRIP001         )
//STRIP001     {
//STRIP001         if ((*aIter)->getIntercepted() == _xInterception)
//STRIP001             DBG_ERROR("FmXFormController::createInterceptor : we already do intercept this objects dispatches !");
//STRIP001     }
//STRIP001 #endif
//STRIP001 
//STRIP001     ::rtl::OUString sInterceptorScheme(RTL_CONSTASCII_USTRINGPARAM("*"));
//STRIP001     FmXDispatchInterceptorImpl* pInterceptor = new FmXDispatchInterceptorImpl(_xInterception, this, 0, Sequence< ::rtl::OUString >(&sInterceptorScheme, 1));
//STRIP001     pInterceptor->acquire();
//STRIP001     m_aControlDispatchInterceptors.insert(m_aControlDispatchInterceptors.end(), pInterceptor);
//STRIP001 
//STRIP001     return (::com::sun::star::frame::XDispatchProviderInterceptor*)pInterceptor;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormController::deleteInterceptor(const Reference< ::com::sun::star::frame::XDispatchProviderInterception > & _xInterception)
//STRIP001 {
//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
//STRIP001     // search the interceptor responsible for the given object
//STRIP001     InterceptorsIterator aIter;
//STRIP001     for (   aIter = m_aControlDispatchInterceptors.begin();
//STRIP001             aIter != m_aControlDispatchInterceptors.end();
//STRIP001             ++aIter
//STRIP001         )
//STRIP001     {
//STRIP001         if ((*aIter)->getIntercepted() == _xInterception)
//STRIP001             break;
//STRIP001     }
//STRIP001     if (aIter == m_aControlDispatchInterceptors.end())
//STRIP001     {
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     // log off the interception from it's interception object
//STRIP001     FmXDispatchInterceptorImpl* pInterceptorImpl = *aIter;
//STRIP001     pInterceptorImpl->dispose();
//STRIP001     pInterceptorImpl->release();
//STRIP001 
//STRIP001     // remove the interceptor from our array
//STRIP001     m_aControlDispatchInterceptors.erase(aIter);
//STRIP001 
//STRIP001     if ( !m_aControlDispatchInterceptors.size() && m_nUpdateDispatcherEvent)
//STRIP001 	{
//STRIP001         Application::RemoveUserEvent( m_nUpdateDispatcherEvent );
//STRIP001 		m_nUpdateDispatcherEvent = 0;
//STRIP001 	}
//STRIP001 }




}
