/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_drawsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:31:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop


// auto strip #ifndef _SVDVIEW_HXX //autogen
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOTEXT_HXX //autogen
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SVX_FONTWORK_HXX //autogen
#include <bf_svx/fontwork.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SFXOBJFACE_HXX //autogen
#include <bf_sfx2/objface.hxx>
#endif
// auto strip #ifndef _SFXITEMITER_HXX //autogen
// auto strip #include <svtools/itemiter.hxx>
// auto strip #endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
// auto strip #ifndef _SVX_SRCHITEM_HXX
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XFTSFIT_HXX //autogen
// auto strip #include <bf_svx/xftsfit.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif


// auto strip #include "swundo.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #include "wrtsh.hxx"
#include "cmdid.h"
#include "globals.hrc"
#include "helpid.h"
#include "popup.hrc"
#include "shells.hrc"
// auto strip #include "drwbassh.hxx"
#include "drawsh.hxx"

#define SwDrawShell
#include "itemdef.hxx"
namespace binfilter {
#include "swslots.hxx"


/*N*/ SFX_IMPL_INTERFACE(SwDrawShell, SwDrawBaseShell, SW_RES(STR_SHELLNAME_DRAW))
/*N*/ {
//STRIP001 /*N*/ 	SFX_POPUPMENU_REGISTRATION(SW_RES(MN_DRAW_POPUPMENU));
//STRIP001 /*N*/ 	SFX_OBJECTBAR_REGISTRATION(SFX_OBJECTBAR_OBJECT, SW_RES(RID_DRAW_TOOLBOX));
/*N*/ 	SFX_OBJECTMENU_REGISTRATION(SID_OBJECTMENU0, SW_RES(MN_OBJECTMENU_DRAW));
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(SvxFontWorkChildWindow::GetChildWindowId());
/*N*/ }

//STRIP001 TYPEINIT1(SwDrawShell,SwDrawBaseShell)

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void SwDrawShell::Execute(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell			&rSh = GetShell();
//STRIP001 	SdrView				*pSdrView = rSh.GetDrawView();
//STRIP001 	const SfxItemSet	*pArgs = rReq.GetArgs();
//STRIP001 	SfxBindings			&rBnd  = GetView().GetViewFrame()->GetBindings();
//STRIP001 	USHORT				 nSlotId = rReq.GetSlot();
//STRIP001 	BOOL				 bChanged = pSdrView->GetModel()->IsChanged();
//STRIP001 
//STRIP001 	pSdrView->GetModel()->SetChanged(FALSE);
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	if(pArgs)
//STRIP001 		pArgs->GetItemState(nSlotId, FALSE, &pItem);
//STRIP001 
//STRIP001 	BOOL bMirror = TRUE, bTopParam = TRUE, bBottomParam = TRUE;
//STRIP001 
//STRIP001 	switch (nSlotId)
//STRIP001 	{
//STRIP001 		case SID_OBJECT_ROTATE:
//STRIP001 			if (rSh.IsObjSelected() && pSdrView->IsRotateAllowed())
//STRIP001 			{
//STRIP001 				if (GetView().IsDrawRotate())
//STRIP001 					rSh.SetDragMode(SDRDRAG_MOVE);
//STRIP001 				else
//STRIP001 					rSh.SetDragMode(SDRDRAG_ROTATE);
//STRIP001 
//STRIP001 				GetView().FlipDrawRotate();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_BEZIER_EDIT:
//STRIP001 			if (GetView().IsDrawRotate())
//STRIP001 			{
//STRIP001 				rSh.SetDragMode(SDRDRAG_MOVE);
//STRIP001 				GetView().FlipDrawRotate();
//STRIP001 			}
//STRIP001 			GetView().FlipDrawSelMode();
//STRIP001 			pSdrView->SetFrameDragSingles(GetView().IsDrawSelMode());
//STRIP001 			GetView().AttrChangedNotify(&rSh); // Shellwechsel...
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_OBJECT_HELL:
//STRIP001 			if (rSh.IsObjSelected())
//STRIP001 			{
//STRIP001 				rSh.StartUndo( UNDO_START );
//STRIP001 				SetWrapMode(FN_FRAME_WRAPTHRU_TRANSP);
//STRIP001 				rSh.SelectionToHell();
//STRIP001 				rSh.EndUndo( UNDO_END );
//STRIP001 				rBnd.Invalidate(SID_OBJECT_HEAVEN);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_OBJECT_HEAVEN:
//STRIP001 			if (rSh.IsObjSelected())
//STRIP001 			{
//STRIP001 				rSh.StartUndo( UNDO_START );
//STRIP001 				SetWrapMode(FN_FRAME_WRAPTHRU);
//STRIP001 				rSh.SelectionToHeaven();
//STRIP001 				rSh.EndUndo( UNDO_END );
//STRIP001 				rBnd.Invalidate(SID_OBJECT_HELL);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_TOOL_HIERARCHIE:
//STRIP001 			if (rSh.IsObjSelected())
//STRIP001 			{
//STRIP001 				rSh.StartUndo( UNDO_START );
//STRIP001 				if (rSh.GetLayerId() == 0)
//STRIP001 				{
//STRIP001 					SetWrapMode(FN_FRAME_WRAPTHRU);
//STRIP001 					rSh.SelectionToHeaven();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SetWrapMode(FN_FRAME_WRAPTHRU_TRANSP);
//STRIP001 					rSh.SelectionToHell();
//STRIP001 				}
//STRIP001 				rSh.EndUndo( UNDO_END );
//STRIP001 				rBnd.Invalidate( SID_OBJECT_HELL, SID_OBJECT_HEAVEN, 0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case FN_FLIP_HORZ_GRAFIC:
//STRIP001 			bMirror = FALSE;
//STRIP001 			/* no break */
//STRIP001         case FN_FLIP_VERT_GRAFIC:
//STRIP001 			rSh.MirrorSelection( bMirror );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_FONTWORK:
//STRIP001 		{
//STRIP001             FieldUnit eMetric = ::GetDfltMetric(0 != PTR_CAST(SwWebView, &rSh.GetView()));
//STRIP001             SW_MOD()->PutItem(SfxUInt16Item(SID_ATTR_METRIC, eMetric));
//STRIP001             SfxViewFrame* pVFrame = GetView().GetViewFrame();
//STRIP001 			if (pArgs)
//STRIP001 			{
//STRIP001 				pVFrame->SetChildWindow(SvxFontWorkChildWindow::GetChildWindowId(),
//STRIP001 					((const SfxBoolItem&)(pArgs->Get(SID_FONTWORK))).GetValue());
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pVFrame->ToggleChildWindow( SvxFontWorkChildWindow::GetChildWindowId() );
//STRIP001 			pVFrame->GetBindings().Invalidate(SID_FONTWORK);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ASSERT(!this, "falscher Dispatcher");
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	if (pSdrView->GetModel()->IsChanged())
//STRIP001 		rSh.SetModified();
//STRIP001 	else if (bChanged)
//STRIP001 		pSdrView->GetModel()->SetChanged(TRUE);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/



//STRIP001 void SwDrawShell::GetState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	SdrView* pSdrView = rSh.GetDrawViewWithValidMarkList();
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	BOOL bProtected = rSh.IsSelObjProtected(FLYPROTECT_CONTENT);
//STRIP001 
//STRIP001 	if (!bProtected)	// Im Parent nachsehen
//STRIP001 		bProtected |= rSh.IsSelObjProtected( (FlyProtectType)(FLYPROTECT_CONTENT|FLYPROTECT_PARENT) ) != 0;
//STRIP001 
//STRIP001 	while( nWhich )
//STRIP001 	{
//STRIP001 		switch( nWhich )
//STRIP001 		{
//STRIP001 			case SID_OBJECT_HELL:
//STRIP001 				if ( !rSh.IsObjSelected() || rSh.GetLayerId() == 0 || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_OBJECT_HEAVEN:
//STRIP001 				if ( !rSh.IsObjSelected() || rSh.GetLayerId() == 1 || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FN_TOOL_HIERARCHIE:
//STRIP001 				if ( !rSh.IsObjSelected() || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_OBJECT_ROTATE:
//STRIP001 			{
//STRIP001 				const BOOL bIsRotate = GetView().IsDrawRotate();
//STRIP001 				if ( !bIsRotate && !pSdrView->IsRotateAllowed() || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				else
//STRIP001 					rSet.Put( SfxBoolItem( nWhich, bIsRotate ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_BEZIER_EDIT:
//STRIP001 				if (!Disable(rSet, nWhich))
//STRIP001 					rSet.Put( SfxBoolItem( nWhich, !GetView().IsDrawSelMode()));
//STRIP001 			break;
//STRIP001 
//STRIP001 			case FN_FLIP_HORZ_GRAFIC:
//STRIP001 				if ( !pSdrView->IsMirrorAllowed() || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case FN_FLIP_VERT_GRAFIC:
//STRIP001 				if ( !pSdrView->IsMirrorAllowed() || bProtected )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_FONTWORK:
//STRIP001 			{
//STRIP001 				if (bProtected)
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					const USHORT nId = SvxFontWorkChildWindow::GetChildWindowId();
//STRIP001 					rSet.Put(SfxBoolItem( nWhich , GetView().GetViewFrame()->HasChildWindow(nId)));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/



//STRIP001 SwDrawShell::SwDrawShell(SwView &rView) :
//STRIP001 	SwDrawBaseShell(rView)
//STRIP001 {
//STRIP001 	SetHelpId(SW_DRAWSHELL);
//STRIP001 	SetName(String::CreateFromAscii("Draw"));
//STRIP001 }

/*************************************************************************
|*
|* SfxRequests fuer FontWork bearbeiten
|*
\************************************************************************/



//STRIP001 void SwDrawShell::ExecFormText(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	SdrView*	pDrView = rSh.GetDrawView();
//STRIP001 	BOOL		bChanged = pDrView->GetModel()->IsChanged();
//STRIP001 	pDrView->GetModel()->SetChanged(FALSE);
//STRIP001 
//STRIP001 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 
//STRIP001 	if ( rMarkList.GetMarkCount() == 1 && rReq.GetArgs() )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rSet = *rReq.GetArgs();
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 		if ( pDrView->IsTextEdit() )
//STRIP001 		{
//STRIP001 			pDrView->EndTextEdit( TRUE );
//STRIP001 			GetView().AttrChangedNotify(&rSh);
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rSet.GetItemState(XATTR_FORMTXTSTDFORM, TRUE, &pItem) ==
//STRIP001 			 SFX_ITEM_SET &&
//STRIP001 			((const XFormTextStdFormItem*) pItem)->GetValue() != XFTFORM_NONE )
//STRIP001 		{
//STRIP001 
//STRIP001 			const USHORT nId = SvxFontWorkChildWindow::GetChildWindowId();
//STRIP001 
//STRIP001 			SvxFontWorkDialog* pDlg = (SvxFontWorkDialog*)(GetView().GetViewFrame()->
//STRIP001 										GetChildWindow(nId)->GetWindow());
//STRIP001 
//STRIP001 			pDlg->CreateStdFormObj(*pDrView, *pDrView->GetPageViewPvNum(0),
//STRIP001 									rSet, *rMarkList.GetMark(0)->GetObj(),
//STRIP001 								   ((const XFormTextStdFormItem*) pItem)->
//STRIP001 								   GetValue());
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pDrView->SetAttributes(rSet);
//STRIP001 	}
//STRIP001 	if (pDrView->GetModel()->IsChanged())
//STRIP001 		rSh.SetModified();
//STRIP001 	else
//STRIP001 		if (bChanged)
//STRIP001 			pDrView->GetModel()->SetChanged(TRUE);
//STRIP001 }

/*************************************************************************
|*
|* Statuswerte fuer FontWork zurueckgeben
|*
\************************************************************************/



//STRIP001 void SwDrawShell::GetFormTextState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	SdrView* pDrView = rSh.GetDrawView();
//STRIP001 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 	const SdrObject* pObj = NULL;
//STRIP001 	SvxFontWorkDialog* pDlg = NULL;
//STRIP001 
//STRIP001 	const USHORT nId = SvxFontWorkChildWindow::GetChildWindowId();
//STRIP001 
//STRIP001 	SfxViewFrame* pVFrame = GetView().GetViewFrame();
//STRIP001 	if ( pVFrame->HasChildWindow(nId) )
//STRIP001 		pDlg = (SvxFontWorkDialog*)(pVFrame->GetChildWindow(nId)->GetWindow());
//STRIP001 
//STRIP001 	if ( rMarkList.GetMarkCount() == 1 )
//STRIP001 		pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 	if ( pObj == NULL || !pObj->ISA(SdrTextObj) ||
//STRIP001 		!((SdrTextObj*) pObj)->HasText() )
//STRIP001 	{
//STRIP001 #define	XATTR_ANZ 12
//STRIP001 		static const USHORT nXAttr[ XATTR_ANZ ] =
//STRIP001 		{
//STRIP001 			XATTR_FORMTXTSTYLE, XATTR_FORMTXTADJUST, XATTR_FORMTXTDISTANCE,
//STRIP001 			XATTR_FORMTXTSTART, XATTR_FORMTXTMIRROR, XATTR_FORMTXTSTDFORM,
//STRIP001 			XATTR_FORMTXTHIDEFORM, XATTR_FORMTXTOUTLINE, XATTR_FORMTXTSHADOW,
//STRIP001 			XATTR_FORMTXTSHDWCOLOR, XATTR_FORMTXTSHDWXVAL, XATTR_FORMTXTSHDWYVAL
//STRIP001 		};
//STRIP001 		for( USHORT i = 0; i < XATTR_ANZ; )
//STRIP001 			rSet.DisableItem( nXAttr[ i++ ] );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pDlg )
//STRIP001 			pDlg->SetColorTable(OFF_APP()->GetStdColorTable());
//STRIP001 
//STRIP001 		pDrView->GetAttributes( rSet );
//STRIP001 	}
//STRIP001 }




}
