/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_textsh.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:35:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#define _SW_FRMVALID_HXX
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _UIPARAM_HXX
#include <uiparam.hxx>
#endif

// auto strip #include <svtools/globalnameitem.hxx>

// auto strip #ifndef __RSC //autogen
// auto strip #include <tools/errinf.hxx>
// auto strip #endif
// auto strip #ifndef _SVDVIEW_HXX //autogen
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
// auto strip #ifndef _OFF_APP_HXX //autogen
// auto strip #include <bf_offmgr/app.hxx>
// auto strip #endif
// auto strip #ifndef _PLUGIN_HXX //autogen wg. SvPlugInObject
// auto strip #include <so3/plugin.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPTITEM_HXX //autogen
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
// auto strip #ifndef _SFXMSG_HXX //autogen
// auto strip #include <bf_sfx2/msg.hxx>
// auto strip #endif
// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_FCONTNR_HXX //autogen
// auto strip #include <bf_sfx2/fcontnr.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_HLNKITEM_HXX //autogen
// auto strip #include <bf_svx/hlnkitem.hxx>
// auto strip #endif
#ifndef _SBASLTID_HRC //autogen
#include <bf_offmgr/sbasltid.hrc>
#endif
// auto strip #ifndef _SVX_SRCHITEM_HXX //autogen
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_CHARMAP_HXX //autogen
// auto strip #include <bf_svx/charmap.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_DOCFILT_HACK_HXX //autogen
// auto strip #include <bf_sfx2/docfilt.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef SVTOOLS_URIHELPER_HXX
// auto strip #include <svtools/urihelper.hxx>
// auto strip #endif
// auto strip #ifndef __SBX_SBXVARIABLE_HXX //autogen
// auto strip #include <svtools/sbxvar.hxx>
// auto strip #endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_OPAQITEM_HXX //autogen
// auto strip #include <bf_svx/opaqitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FONTITEM_HXX //autogen
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ADJITEM_HXX //autogen
// auto strip #include <bf_svx/adjitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BOXITEM_HXX //autogen
// auto strip #include <bf_svx/boxitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SIZEITEM_HXX //autogen
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #endif
// auto strip #ifndef _MySVXACORR_HXX
// auto strip #include <bf_svx/svxacorr.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SCRIPTTYPEITEM_HXX
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #endif
// auto strip #ifndef _FILTER_HXX //autogen
// auto strip #include <svtools/filter.hxx>
// auto strip #endif
// auto strip #ifndef SMDLL_HXX
// auto strip #include <bf_starmath/smdll0.hxx>
// auto strip #endif
// auto strip #ifndef _SCHDLL0_HXX
// auto strip #include <bf_sch/schdll0.hxx>
// auto strip #endif
// auto strip #ifndef _SCH_DLL_HXX
// auto strip #include <bf_sch/schdll.hxx>
// auto strip #endif
// auto strip #ifndef _SCH_MEMCHRT_HXX
// auto strip #include <bf_sch/memchrt.hxx>
// auto strip #endif
#ifndef _SVX_HTMLMODE_HXX
#include <bf_svx/htmlmode.hxx>
#endif
// auto strip #ifndef _SVX_PFILEDLG_HXX //autogen wg. SvxPluginFileDlg
// auto strip #include <bf_svx/pfiledlg.hxx>
// auto strip #endif
// auto strip #ifndef _OFA_HTMLCFG_HXX //autogen
// auto strip #include <bf_offmgr/htmlcfg.hxx>
// auto strip #endif
// auto strip #ifndef _OFAACCFG_HXX //autogen
// auto strip #include <bf_offmgr/ofaaccfg.hxx>
// auto strip #endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HDL_
#include <com/sun/star/i18n/TransliterationModules.hdl>
#endif

// auto strip #ifndef _SWWDOCSH_HXX //autogen
// auto strip #include <wdocsh.hxx>
// auto strip #endif
// auto strip #ifndef _FMTINFMT_HXX //autogen
// auto strip #include <fmtinfmt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTCLDS_HXX //autogen
// auto strip #include <fmtclds.hxx>
// auto strip #endif
// auto strip #ifndef _FMTSRND_HXX //autogen
// auto strip #include <fmtsrnd.hxx>
// auto strip #endif
// auto strip #ifndef _FMTFSIZE_HXX //autogen
// auto strip #include <fmtfsize.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
// auto strip #ifndef _FRMMGR_HXX
// auto strip #include <frmmgr.hxx>
// auto strip #endif
#ifndef _TEXTSH_HXX
#include <textsh.hxx>
#endif
// auto strip #ifndef _INSTABLE_HXX
// auto strip #include <instable.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX
// auto strip #include <frmfmt.hxx>
// auto strip #endif
// auto strip #ifndef _TABLEMGR_HXX
// auto strip #include <tablemgr.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx>		// fuer Undo-IDs
// auto strip #endif
// auto strip #ifndef _SHELLIO_HXX
// auto strip #include <shellio.hxx>
// auto strip #endif
// auto strip #ifndef _FRMDLG_HXX
// auto strip #include <frmdlg.hxx>
// auto strip #endif
#ifndef _USRPREF_HXX
#include <usrpref.hxx>
#endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
// auto strip #ifndef _TBLAFMT_HXX
// auto strip #include <tblafmt.hxx>
// auto strip #endif
// auto strip #ifndef _INSRULE_HXX
// auto strip #include <insrule.hxx>
// auto strip #endif
// auto strip #ifndef _CAPTION_HXX
// auto strip #include <caption.hxx>
// auto strip #endif
// auto strip #ifndef _IDXMRK_HXX
// auto strip #include <idxmrk.hxx>
// auto strip #endif
// auto strip #ifndef _POOLFMT_HXX
// auto strip #include <poolfmt.hxx>
// auto strip #endif
// auto strip #ifndef _BREAKIT_HXX
// auto strip #include <breakit.hxx>
// auto strip #endif
// auto strip #ifndef _CRSSKIP_HXX
// auto strip #include <crsskip.hxx>
// auto strip #endif
// auto strip #ifndef _MODOPT_HXX //autogen
// auto strip #include <modcfg.hxx>
// auto strip #endif
#ifndef _COLUMN_HXX
#include <column.hxx>
#endif
// auto strip #ifndef _EDTWIN_HXX
// auto strip #include <edtwin.hxx>
// auto strip #endif
#ifndef _SHELLS_HRC
#include <shells.hrc>
#endif
#ifndef _POPUP_HRC
#include <popup.hrc>
#endif
#ifndef _SWERROR_H
#include <swerror.h>
#endif

#define SwTextShell
#define Paragraph
#define HyphenZone
#define TextFont
#define DropCap
#ifndef _ITEMDEF_HXX
#include <itemdef.hxx>
#endif

#include "so3/staticbaseurl.hxx"
namespace binfilter {
#ifndef _SWSLOTS_HXX
#include <swslots.hxx>
#endif
#define C2S(cChar) UniString::CreateFromAscii(cChar)

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ SFX_IMPL_INTERFACE(SwTextShell, SwBaseShell, SW_RES(STR_SHELLNAME_TEXT))
/*N*/ {
/*N*/ 	SFX_POPUPMENU_REGISTRATION(SW_RES(MN_TEXT_POPUPMENU));
//STRIP001 /*N*/ 	SFX_OBJECTBAR_REGISTRATION(SFX_OBJECTBAR_OBJECT, SW_RES(RID_TEXT_TOOLBOX));
/*N*/ 	SFX_OBJECTMENU_REGISTRATION(SID_OBJECTMENU0, SW_RES(MN_OBJECTMENU_TEXT));
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(FN_EDIT_FORMULA);
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(SID_INSERT_DIAGRAM);
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(FN_INSERT_FIELD);
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(FN_INSERT_IDX_ENTRY_DLG);
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION(FN_INSERT_AUTH_ENTRY_DLG);
/*N*/     SFX_CHILDWINDOW_REGISTRATION(SID_RUBY_DIALOG);
/*N*/ }



/*N*/ TYPEINIT1(SwTextShell,SwBaseShell)



//STRIP001 void SwTextShell::ExecInsert(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 
//STRIP001 	ASSERT( !rSh.IsObjSelected() && !rSh.IsFrmSelected(),
//STRIP001 			"Falsche Shell auf dem Dispatcher" );
//STRIP001 
//STRIP001 	const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	if(pArgs)
//STRIP001 		pArgs->GetItemState(nSlot, FALSE, &pItem );
//STRIP001 
//STRIP001 	switch( nSlot )
//STRIP001 	{
//STRIP001     case FN_INSERT_STRING:
//STRIP001 		if( pItem )
//STRIP001 			rSh.InsertByWord(((const SfxStringItem *)pItem)->GetValue());
//STRIP001     break;
//STRIP001     case FN_INSERT_SOFT_HYPHEN:
//STRIP001 		if( CHAR_SOFTHYPHEN != rSh.SwCrsrShell::GetChar( TRUE, 0 ) &&
//STRIP001 			CHAR_SOFTHYPHEN != rSh.SwCrsrShell::GetChar( TRUE, -1 ))
//STRIP001 			rSh.Insert( String( CHAR_SOFTHYPHEN ) );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case FN_INSERT_HARDHYPHEN:
//STRIP001 	case FN_INSERT_HARD_SPACE:
//STRIP001 		{
//STRIP001 			sal_Unicode cIns = FN_INSERT_HARD_SPACE == nSlot ? CHAR_HARDBLANK
//STRIP001 															 : CHAR_HARDHYPHEN;
//STRIP001 
//STRIP001     		SvxAutoCorrect* pACorr = OFF_APP()->GetAutoCorrConfig()->GetAutoCorrect();
//STRIP001 	        if( pACorr && pACorr->IsAutoCorrFlag( CptlSttSntnc | CptlSttWrd |
//STRIP001 								ChgFractionSymbol | ChgOrdinalNumber |
//STRIP001                                 ChgToEnEmDash | SetINetAttr | Autocorrect ))
//STRIP001 				rSh.AutoCorrect( *pACorr, cIns );
//STRIP001 			else
//STRIP001 				rSh.Insert( String( cIns ) );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case FN_INSERT_BREAK:
//STRIP001 		rSh.SplitNode();
//STRIP001         rReq.Done();
//STRIP001 	break;
//STRIP001 	case FN_INSERT_PAGEBREAK:
//STRIP001 		rSh.InsertPageBreak();
//STRIP001         rReq.Done();
//STRIP001 	break;
//STRIP001 	case FN_INSERT_LINEBREAK:
//STRIP001 		rSh.InsertLineBreak();
//STRIP001         rReq.Done();
//STRIP001 	break;
//STRIP001 	case FN_INSERT_COLUMN_BREAK:
//STRIP001 		rSh.InsertColumnBreak();
//STRIP001         rReq.Done();
//STRIP001 	break;
//STRIP001 	case SID_HYPERLINK_SETLINK:
//STRIP001 		if (pItem)
//STRIP001 			InsertHyperlink(*((const SvxHyperlinkItem *)pItem));
//STRIP001         rReq.Done();
//STRIP001 		break;
//STRIP001 	case  SID_INSERT_SOUND:
//STRIP001 	case  SID_INSERT_VIDEO:
//STRIP001 	{
//STRIP001 		SvxPluginFileDlg aDlg( &GetView().GetViewFrame()->GetWindow(), nSlot );
//STRIP001 		aDlg.SetContext( nSlot == SID_INSERT_SOUND? sfx2::FileDialogHelper::SW_INSERT_SOUND : sfx2::FileDialogHelper::SW_INSERT_VIDEO );
//STRIP001 
//STRIP001 		if ( ERRCODE_NONE == aDlg.Execute() )
//STRIP001 		{
//STRIP001 			// URL ermitteln
//STRIP001 			String aStrURL( aDlg.GetPath() );
//STRIP001 			aStrURL = so3::StaticBaseUrl::SmartRelToAbs( aStrURL );
//STRIP001 
//STRIP001 			INetURLObject* pURL = new INetURLObject();
//STRIP001 			pURL->SetSmartProtocol( INET_PROT_FILE );
//STRIP001 
//STRIP001 			if ( pURL->SetURL( aStrURL, INetURLObject::WAS_ENCODED ) )
//STRIP001 			{
//STRIP001 				SvFactory * pFactory = SvPlugInObject::ClassFactory();
//STRIP001 				SvStorageRef aStor = new SvStorage( aEmptyStr, STREAM_STD_READWRITE );
//STRIP001 				SvPlugInObjectRef xObj = &pFactory->CreateAndInit( *pFactory, aStor );
//STRIP001 				xObj->SetPlugInMode( (USHORT)PLUGIN_EMBEDED );
//STRIP001 				xObj->SetURL( *pURL );
//STRIP001 				SvPlugInObject* pObj = &xObj;
//STRIP001 				SvInPlaceObjectRef *pxIns = new SvInPlaceObjectRef(pObj);
//STRIP001 				rSh.Insert( pxIns, 0, TRUE, nSlot);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001 	case SID_INSERT_OBJECT:
//STRIP001 	case SID_INSERT_PLUGIN:
//STRIP001 	case SID_INSERT_APPLET:
//STRIP001 	case SID_INSERT_FLOATINGFRAME:
//STRIP001 	{
//STRIP001         SFX_REQUEST_ARG( rReq, pNameItem, SfxGlobalNameItem, SID_INSERT_OBJECT, sal_False );
//STRIP001 		SvGlobalName *pName = NULL;
//STRIP001 		SvGlobalName aName;
//STRIP001 		if ( pNameItem )
//STRIP001 		{
//STRIP001 			aName = pNameItem->GetValue();
//STRIP001 			pName = &aName;
//STRIP001 		}
//STRIP001 
//STRIP001 		DBG_ASSERT( !pNameItem || nSlot == SID_INSERT_OBJECT, "Superfluous argument!" );
//STRIP001 		rSh.Insert( (SvInPlaceObjectRef*)0, pName, TRUE, nSlot);
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	case SID_INSERT_DIAGRAM:
//STRIP001 		{
//STRIP001 			SvtModuleOptions aMOpt;
//STRIP001 			if ( !aMOpt.IsChart() )
//STRIP001 				break;
//STRIP001 			if(!rReq.IsAPI())
//STRIP001 			{
//STRIP001 				SfxViewFrame* pVFrame = GetView().GetViewFrame();
//STRIP001 				pVFrame->ToggleChildWindow( SID_INSERT_DIAGRAM );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const SwFrmFmt* pTFmt = rSh.GetTableFmt();
//STRIP001 				if( pTFmt && !rSh.IsTblComplexForChart() )
//STRIP001 				{
//STRIP001 					SchMemChart* pData = 0;
//STRIP001 					rSh.UpdateChartData( pTFmt->GetName(), pData );
//STRIP001 
//STRIP001 					SwTableFUNC( &rSh, FALSE ).InsertChart( *pData );
//STRIP001 					rSh.LaunchOLEObj();
//STRIP001 
//STRIP001 					delete pData;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rSh.Insert( 0, SCH_MOD()->pSchChartDocShellFactory );
//STRIP001 				}
//STRIP001 				SvInPlaceObjectRef xOLE = rSh.GetOLEObj();
//STRIP001 				if(pItem && xOLE.Is())
//STRIP001 				{
//STRIP001 					Size aSize(((SvxSizeItem*)pItem)->GetSize());
//STRIP001 					aSize = OutputDevice::LogicToLogic
//STRIP001 									( aSize, MapMode( MAP_TWIP ), MapMode( MAP_100TH_MM ) );
//STRIP001 
//STRIP001 					if(aSize.Width() > MINLAY&& aSize.Height()> MINLAY)
//STRIP001 					{
//STRIP001 						Rectangle aRect = xOLE->GetVisArea();
//STRIP001 						aRect.SetSize(aSize);
//STRIP001 						xOLE->SetVisArea( aRect );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case FN_INSERT_SMA:
//STRIP001 		{
//STRIP001 			rSh.Insert( 0, SM_MOD()->pSmDocShellFactory );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case FN_INSERT_TABLE:
//STRIP001 		if( !rSh.GetTableFmt() && !(rSh.GetFrmType(0,TRUE) & FRMTYPE_FOOTNOTE))
//STRIP001 		{
//STRIP001 			SwView &rView = GetView(); // Da GetView() nach Shellwechsel nicht mehr geht
//STRIP001 			BOOL bHTMLMode = 0 != (::binfilter::GetHtmlMode(rView.GetDocShell())&HTMLMODE_ON);
//STRIP001 			BOOL bCallEndUndo = FALSE;
//STRIP001 
//STRIP001 			if( !pArgs && rSh.IsSelection() && !rSh.IsInClickToEdit() )
//STRIP001 			{
//STRIP001 				const SwModuleOptions* pModOpt = SW_MOD()->GetModuleConfig();
//STRIP001 				USHORT nInsTblFlags = pModOpt->GetInsTblFlags(bHTMLMode);
//STRIP001 
//STRIP001 				rSh.StartUndo(UNDO_INSTABLE);
//STRIP001 				bCallEndUndo = TRUE;
//STRIP001 
//STRIP001 				BOOL bInserted = rSh.TextToTable('\t', HORI_FULL, nInsTblFlags);
//STRIP001 				rSh.EnterStdMode();
//STRIP001 				if (bInserted)
//STRIP001 					rView.AutoCaption(TABLE_CAP);
//STRIP001                 rReq.Done();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				USHORT nCols = 0;
//STRIP001 				USHORT nRows = 0;
//STRIP001 				USHORT nInsTblFlags = ALL_TBL_INS_ATTR;
//STRIP001                 String aTableName, aAutoName;
//STRIP001 				SwTableAutoFmt* pTAFmt = 0;
//STRIP001 
//STRIP001 				if( pArgs && pArgs->Count() >= 2 )
//STRIP001 				{
//STRIP001                     SFX_REQUEST_ARG( rReq, pName, SfxStringItem, FN_INSERT_TABLE, sal_False );
//STRIP001                     SFX_REQUEST_ARG( rReq, pCols, SfxUInt16Item, SID_ATTR_TABLE_COLUMN, sal_False );
//STRIP001                     SFX_REQUEST_ARG( rReq, pRows, SfxUInt16Item, SID_ATTR_TABLE_ROW, sal_False );
//STRIP001                     SFX_REQUEST_ARG( rReq, pFlags, SfxInt32Item, FN_PARAM_1, sal_False );
//STRIP001                     SFX_REQUEST_ARG( rReq, pAuto, SfxStringItem, FN_PARAM_2, sal_False );
//STRIP001 
//STRIP001                     if ( pName )
//STRIP001                         aTableName = pName->GetValue();
//STRIP001                     if ( pCols )
//STRIP001                         nCols = pCols->GetValue();
//STRIP001                     if ( pRows )
//STRIP001                         nRows = pRows->GetValue();
//STRIP001                     if ( pAuto )
//STRIP001                     {
//STRIP001                         aAutoName = pAuto->GetValue();
//STRIP001                         if ( aAutoName.Len() )
//STRIP001                         {
//STRIP001                             SwTableAutoFmtTbl aTableTbl;
//STRIP001                             aTableTbl.Load();
//STRIP001                             for ( USHORT n=0; n<aTableTbl.Count(); n++ )
//STRIP001                             {
//STRIP001                                 if ( aTableTbl[n]->GetName() == aAutoName )
//STRIP001                                 {
//STRIP001                                     pTAFmt = new SwTableAutoFmt( *aTableTbl[n] );
//STRIP001                                     break;
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001 
//STRIP001                     if ( pFlags )
//STRIP001                         nInsTblFlags = (USHORT) pFlags->GetValue();
//STRIP001                     else
//STRIP001                     {
//STRIP001                         const SwModuleOptions* pModOpt = SW_MOD()->GetModuleConfig();
//STRIP001                         nInsTblFlags = pModOpt->GetInsTblFlags(bHTMLMode);
//STRIP001                     }
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !nCols || !nRows )
//STRIP001 				{
//STRIP001 					SwInsTableDlg *pDlg = new SwInsTableDlg(rView);
//STRIP001 					if( RET_OK == pDlg->Execute() )
//STRIP001 					{
//STRIP001                         pDlg->GetValues( aTableName, nRows, nCols, nInsTblFlags, aAutoName, pTAFmt );
//STRIP001 					}
//STRIP001                     else
//STRIP001                         rReq.Ignore();
//STRIP001 					delete pDlg;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( nCols && nRows )
//STRIP001 				{
//STRIP001                     // record before shell change
//STRIP001                     rReq.AppendItem( SfxStringItem( FN_INSERT_TABLE, aTableName ) );
//STRIP001                     if ( aAutoName.Len() )
//STRIP001                         rReq.AppendItem( SfxStringItem( FN_PARAM_2, aAutoName ) );
//STRIP001                     rReq.AppendItem( SfxUInt16Item( SID_ATTR_TABLE_COLUMN, nCols ) );
//STRIP001                     rReq.AppendItem( SfxUInt16Item( SID_ATTR_TABLE_ROW, nRows ) );
//STRIP001                     rReq.AppendItem( SfxInt32Item( FN_PARAM_1, (sal_Int32) nInsTblFlags ) );
//STRIP001                     rReq.Done();
//STRIP001 
//STRIP001 					rSh.StartUndo(UNDO_INSTABLE);
//STRIP001 					bCallEndUndo = TRUE;
//STRIP001 
//STRIP001 					rSh.StartAllAction();
//STRIP001 					if( rSh.HasSelection() )
//STRIP001 						rSh.DelRight();
//STRIP001 
//STRIP001 					rSh.InsertTable( nRows, nCols, HORI_FULL, nInsTblFlags, pTAFmt );
//STRIP001 					rSh.MoveTable( fnTablePrev, fnTableStart );
//STRIP001 
//STRIP001 					if( aTableName.Len() && !rSh.GetTblStyle( aTableName ) )
//STRIP001 						rSh.GetTableFmt()->SetName( aTableName );
//STRIP001 
//STRIP001 					rSh.EndAllAction();
//STRIP001 					rView.AutoCaption(TABLE_CAP);
//STRIP001 				}
//STRIP001 				delete pTAFmt;
//STRIP001 			}
//STRIP001 			if( bCallEndUndo )
//STRIP001 				rSh.EndUndo(UNDO_INSTABLE);	// wegen moegl. Shellwechsel
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case FN_INSERT_FRAME_INTERACT_NOCOL:
//STRIP001 	case FN_INSERT_FRAME_INTERACT:
//STRIP001 	{
//STRIP001         USHORT nCols = 1;
//STRIP001         BOOL bModifier1 = rReq.GetModifier() == KEY_MOD1;
//STRIP001         if(pArgs)
//STRIP001         {
//STRIP001             if(FN_INSERT_FRAME_INTERACT_NOCOL != nSlot &&
//STRIP001                 pArgs->GetItemState(SID_ATTR_COLUMNS, FALSE, &pItem) == SFX_ITEM_SET)
//STRIP001                 nCols = ((SfxUInt16Item *)pItem)->GetValue();
//STRIP001             if(pArgs->GetItemState(SID_MODIFIER, FALSE, &pItem) == SFX_ITEM_SET)
//STRIP001                 bModifier1 |= KEY_MOD1 == ((SfxUInt16Item *)pItem)->GetValue();
//STRIP001         }
//STRIP001         if(bModifier1 )
//STRIP001         {
//STRIP001             SwEditWin& rEdtWin = GetView().GetEditWin();
//STRIP001             Size aWinSize = rEdtWin.GetSizePixel();
//STRIP001             Point aStartPos(aWinSize.Width()/2, aWinSize.Height() / 2);
//STRIP001             aStartPos = rEdtWin.PixelToLogic(aStartPos);
//STRIP001             aStartPos.X() -= 8 * MM50;
//STRIP001             aStartPos.Y() -= 4 * MM50;
//STRIP001             Size aSize(16 * MM50, 8 * MM50);
//STRIP001             GetShell().StartAllAction();
//STRIP001             SwFlyFrmAttrMgr aMgr( TRUE, GetShellPtr(), FRMMGR_TYPE_TEXT );
//STRIP001             if(nCols > 1)
//STRIP001             {
//STRIP001                 SwFmtCol aCol;
//STRIP001                 aCol.Init( nCols, aCol.GetGutterWidth(), aCol.GetWishWidth() );
//STRIP001                 aMgr.SetCol( aCol );
//STRIP001             }
//STRIP001             aMgr.InsertFlyFrm(FLY_AT_CNTNT, aStartPos, aSize);
//STRIP001             GetShell().EndAllAction();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             GetView().InsFrmMode(nCols);
//STRIP001         }
//STRIP001         rReq.Ignore();
//STRIP001     }
//STRIP001 	break;
//STRIP001 	case FN_INSERT_FRAME:
//STRIP001 	{
//STRIP001 		const int nSel = rSh.GetSelectionType();
//STRIP001 
//STRIP001 		BOOL bSingleCol = FALSE;
//STRIP001 		if( 0!= PTR_CAST(SwWebDocShell, GetView().GetDocShell()) )
//STRIP001 		{
//STRIP001 			OfaHtmlOptions* pHtmlOpt = OFF_APP()->GetHtmlOptions();
//STRIP001 			USHORT nExport = pHtmlOpt->GetExportMode();
//STRIP001 			if( HTML_CFG_MSIE == nExport ||
//STRIP001 				HTML_CFG_HTML32 == nExport ||
//STRIP001 				HTML_CFG_MSIE_40 == nExport ||
//STRIP001 				HTML_CFG_HTML32 == nExport )
//STRIP001 			{
//STRIP001 				bSingleCol = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 		// Rahmen neu anlegen
//STRIP001 		SwFlyFrmAttrMgr aMgr( TRUE, GetShellPtr(), FRMMGR_TYPE_TEXT );
//STRIP001         if(pArgs)
//STRIP001         {
//STRIP001             Size aSize(aMgr.GetSize());
//STRIP001             aSize.Width() = GetShell().GetAnyCurRect(RECT_PAGE_PRT).Width();
//STRIP001             Point aPos = aMgr.GetPos();
//STRIP001             RndStdIds eAnchor = FLY_AT_CNTNT;
//STRIP001             if(pArgs->GetItemState(nSlot, FALSE, &pItem) == SFX_ITEM_SET)
//STRIP001                 eAnchor = (RndStdIds)((SfxUInt16Item *)pItem)->GetValue();
//STRIP001             if(pArgs->GetItemState(FN_PARAM_1, FALSE, &pItem)  == SFX_ITEM_SET)
//STRIP001                 aPos = ((SfxPointItem *)pItem)->GetValue();
//STRIP001             if(pArgs->GetItemState(FN_PARAM_2, FALSE, &pItem)  == SFX_ITEM_SET)
//STRIP001                 aSize = ((SvxSizeItem *)pItem)->GetSize();
//STRIP001             if(pArgs->GetItemState(SID_ATTR_COLUMNS, FALSE, &pItem)  == SFX_ITEM_SET)
//STRIP001             {
//STRIP001                 USHORT nCols = ((SfxUInt16Item *)pItem)->GetValue();
//STRIP001                 if( !bSingleCol && 1 < nCols )
//STRIP001                 {
//STRIP001                     SwFmtCol aFmtCol;
//STRIP001                     aFmtCol.Init( nCols , (rReq.IsAPI() ? 0
//STRIP001                                         : DEF_GUTTER_WIDTH), USHRT_MAX );
//STRIP001                     aMgr.SetCol(aFmtCol);
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             GetShell().StartAllAction();
//STRIP001 
//STRIP001             aMgr.InsertFlyFrm(eAnchor, aPos, aSize);
//STRIP001 
//STRIP001             GetShell().EndAllAction();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             static USHORT __READONLY_DATA aFrmAttrRange[] =
//STRIP001             {
//STRIP001                 RES_FRMATR_BEGIN,       RES_FRMATR_END-1,
//STRIP001                 SID_ATTR_BORDER_INNER,  SID_ATTR_BORDER_INNER,
//STRIP001                 FN_GET_PRINT_AREA,      FN_GET_PRINT_AREA,
//STRIP001                 SID_ATTR_PAGE_SIZE,     SID_ATTR_PAGE_SIZE,
//STRIP001                 FN_SET_FRM_NAME,        FN_SET_FRM_NAME,
//STRIP001                 SID_HTML_MODE,          SID_HTML_MODE,
//STRIP001                 0
//STRIP001             };
//STRIP001 
//STRIP001             SfxItemSet aSet(GetPool(), aFrmAttrRange );
//STRIP001             aSet.Put(SfxUInt16Item(SID_HTML_MODE, ::binfilter::GetHtmlMode(GetView().GetDocShell())));
//STRIP001             const SwRect &rPg = GetShell().GetAnyCurRect(RECT_PAGE);
//STRIP001             SwFmtFrmSize aFrmSize(ATT_VAR_SIZE, rPg.Width(), rPg.Height());
//STRIP001             aFrmSize.SetWhich(GetPool().GetWhich(SID_ATTR_PAGE_SIZE));
//STRIP001             aSet.Put(aFrmSize);
//STRIP001 
//STRIP001             const SwRect &rPr = GetShell().GetAnyCurRect(RECT_PAGE_PRT);
//STRIP001             SwFmtFrmSize aPrtSize(ATT_VAR_SIZE, rPr.Width(), rPr.Height());
//STRIP001             aPrtSize.SetWhich(GetPool().GetWhich(FN_GET_PRINT_AREA));
//STRIP001             aSet.Put(aPrtSize);
//STRIP001 
//STRIP001             aSet.Put(aMgr.GetAttrSet());
//STRIP001             aSet.SetParent( aMgr.GetAttrSet().GetParent() );
//STRIP001 
//STRIP001             // Minimalgroesse in Spalten lschen
//STRIP001             SvxBoxInfoItem aBoxInfo((SvxBoxInfoItem &)aSet.Get(SID_ATTR_BORDER_INNER));
//STRIP001             const SvxBoxItem& rBox = (const SvxBoxItem&)aSet.Get(RES_BOX);
//STRIP001             aBoxInfo.SetMinDist(FALSE);
//STRIP001             aBoxInfo.SetDefDist(rBox.GetDistance(BOX_LINE_LEFT));
//STRIP001             aSet.Put(aBoxInfo);
//STRIP001 
//STRIP001             FieldUnit eMetric = ::GetDfltMetric(0 != PTR_CAST(SwWebDocShell, GetView().GetDocShell()));
//STRIP001             SW_MOD()->PutItem(SfxUInt16Item(SID_ATTR_METRIC, eMetric));
//STRIP001             SwFrmDlg* pDlg = new SwFrmDlg(GetView().GetViewFrame(), &GetView().GetViewFrame()->GetWindow(), aSet, TRUE);
//STRIP001 
//STRIP001             if(pDlg->Execute() && pDlg->GetOutputItemSet())
//STRIP001             {
//STRIP001                 GetShell().StartAllAction();
//STRIP001                 GetShell().StartUndo(UNDO_INSERT);
//STRIP001 
//STRIP001                 const SfxItemSet* pOutSet = pDlg->GetOutputItemSet();
//STRIP001                 aMgr.SetAttrSet(*pOutSet);
//STRIP001 
//STRIP001                 // beim ClickToEditFeld erst die Selektion loeschen
//STRIP001                 if( GetShell().IsInClickToEdit() )
//STRIP001                     GetShell().DelRight();
//STRIP001 
//STRIP001                 aMgr.InsertFlyFrm();
//STRIP001 
//STRIP001                 ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                         GetView().GetViewFrame()->GetBindings().GetRecorder();
//STRIP001                 if ( xRecorder.is() )
//STRIP001                 {
//STRIP001                     //FN_INSERT_FRAME
//STRIP001                     USHORT nAnchor = (USHORT)aMgr.GetAnchor();
//STRIP001                         rReq.AppendItem(SfxUInt16Item(nSlot, nAnchor));
//STRIP001                         rReq.AppendItem(SfxPointItem(FN_PARAM_1, GetShell().GetObjAbsPos()));
//STRIP001                         rReq.AppendItem(SvxSizeItem(FN_PARAM_2, GetShell().GetObjSize()));
//STRIP001                     rReq.Done();
//STRIP001                 }
//STRIP001 
//STRIP001                 GetView().AutoCaption(FRAME_CAP);
//STRIP001                 GetShell().EndUndo(UNDO_INSERT);
//STRIP001                 GetShell().EndAllAction();
//STRIP001             }
//STRIP001 
//STRIP001             DELETEZ(pDlg);
//STRIP001         }
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	case FN_INSERT_HRULER:
//STRIP001 	{
//STRIP001 		String sPath;
//STRIP001 		BOOL bSimpleLine = FALSE;
//STRIP001 		BOOL bRet = FALSE;
//STRIP001 		Window* pParent = GetView().GetWindow();
//STRIP001         if ( pItem )
//STRIP001         {
//STRIP001             sPath = ((SfxStringItem*)pItem)->GetValue();
//STRIP001             SFX_REQUEST_ARG( rReq, pSimple, SfxBoolItem, FN_PARAM_1 , sal_False );
//STRIP001             if ( pSimple )
//STRIP001                 bSimpleLine = pSimple->GetValue();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             SwInsertGrfRulerDlg* pDlg = new SwInsertGrfRulerDlg(pParent);
//STRIP001             // MessageBox fuer fehlende Grafiken
//STRIP001             if(!pDlg->HasImages())
//STRIP001                 InfoBox( pParent, SW_RES(MSG_NO_RULER)).Execute();
//STRIP001             if(RET_OK == pDlg->Execute())
//STRIP001             {
//STRIP001                 sPath = pDlg->GetGraphicName();
//STRIP001                 bSimpleLine = pDlg->IsSimpleLine();
//STRIP001             }
//STRIP001 
//STRIP001             delete pDlg;
//STRIP001             rReq.AppendItem( SfxStringItem( FN_INSERT_HRULER, sPath ) );
//STRIP001             rReq.AppendItem( SfxBoolItem( FN_PARAM_1, bSimpleLine ) );
//STRIP001         }
//STRIP001 
//STRIP001 		rSh.StartAllAction();
//STRIP001 		rSh.StartUndo(UIUNDO_INSERT_RULER);
//STRIP001 		if(bSimpleLine)
//STRIP001 		{
//STRIP001 			if(!(rSh.IsSttOfPara() && rSh.IsEndOfPara())) // kein leerer Absatz?
//STRIP001 				rSh.SplitNode( FALSE, FALSE ); // dann Platz schaffen
//STRIP001 			rSh.SplitNode( FALSE, FALSE );
//STRIP001 			rSh.Left(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 			rSh.SetTxtFmtColl( rSh.GetTxtCollFromPool( RES_POOLCOLL_HTML_HR ));
//STRIP001 			rSh.Right(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 		else if(sPath.Len())
//STRIP001 		{
//STRIP001 			if (!pFrmMgr)
//STRIP001 				pFrmMgr = new SwFlyFrmAttrMgr( TRUE, &rSh, FRMMGR_TYPE_GRF );
//STRIP001 			// am FrmMgr muessen die richtigen Parameter eingestellt werden
//STRIP001 
//STRIP001 			pFrmMgr->SetAnchor(FLY_IN_CNTNT);
//STRIP001 
//STRIP001 			rSh.SplitNode( FALSE, FALSE );
//STRIP001 			rSh.SplitNode( FALSE, FALSE );
//STRIP001 			rSh.Left(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 			rSh.SetAttr(SvxAdjustItem(SVX_ADJUST_CENTER,RES_PARATR_ADJUST ));
//STRIP001 			if(GRFILTER_OK == InsertGraphic(sPath, aEmptyStr, TRUE, 0, 0 ))
//STRIP001 				bRet = TRUE;
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			rSh.Right(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 			DELETEZ(pFrmMgr);
//STRIP001 		}
//STRIP001 		rSh.EndAllAction();
//STRIP001 		rSh.EndUndo(UIUNDO_INSERT_RULER);
//STRIP001 		rReq.SetReturnValue(SfxBoolItem(nSlot, bRet));
//STRIP001         rReq.Done();
//STRIP001 	}
//STRIP001 	break;
//STRIP001 	case FN_FORMAT_COLUMN :
//STRIP001 	{
//STRIP001 		SwColumnDlg* pColDlg = new SwColumnDlg(GetView().GetWindow(), rSh);
//STRIP001 		pColDlg->Execute();
//STRIP001 		delete pColDlg;
//STRIP001 	}
//STRIP001 	break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		ASSERT( !this, "falscher Dispatcher" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 }



/*N*/ void SwTextShell::StateInsert( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	USHORT nHtmlMode = ::binfilter::GetHtmlMode(GetView().GetDocShell());
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	SwWrtShell &rSh = GetShell();
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	SvtModuleOptions aMOpt;
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*?*/ 			case SID_INSERT_SOUND:
/*?*/ 			case SID_INSERT_VIDEO:
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( GetShell().IsSelFrmMode() ||
//STRIP001 /*?*/ 					 !SvxPluginFileDlg::IsAvailable( nWhich ) ||
//STRIP001 /*?*/ 					 SFX_CREATE_MODE_EMBEDDED == GetView().GetDocShell()->GetCreateMode() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					rSet.DisableItem( nWhich );
//STRIP001 /*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_INSERT_DIAGRAM:
/*?*/ 				if( !aMOpt.IsChart() )
/*?*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			case FN_INSERT_SMA:
/*?*/ 				if( FN_INSERT_SMA == nWhich && !aMOpt.IsMath() )
/*?*/ 				{
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			case SID_INSERT_FLOATINGFRAME:
/*?*/ 			case SID_INSERT_OBJECT:
/*?*/ 			case SID_INSERT_PLUGIN:
/*?*/ 			case SID_INSERT_APPLET:
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxObjectCreateMode eMode =
//STRIP001 /*?*/ 									GetView().GetDocShell()->GetCreateMode();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if(
//STRIP001 /*?*/ #ifndef SOLAR_JAVA
//STRIP001 /*?*/ 					nWhich == SID_INSERT_APPLET ||
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 					eMode == SFX_CREATE_MODE_EMBEDDED ||
//STRIP001 /*?*/ 					(nWhich == SID_INSERT_DIAGRAM && rSh.IsCrsrInTbl() &&
//STRIP001 /*?*/ 					 rSh.IsTblComplexForChart() &&
//STRIP001 /*?*/ 					 !GetView().GetViewFrame()->GetChildWindow(
//STRIP001 /*?*/ 							SID_INSERT_DIAGRAM)) )
//STRIP001 /*?*/ 					rSet.DisableItem( nWhich );
//STRIP001 /*?*/ 				else if( GetShell().IsSelFrmMode())
//STRIP001 /*?*/ 					rSet.DisableItem( nWhich );
//STRIP001 /*?*/ 				else if(SID_INSERT_FLOATINGFRAME == nWhich && nHtmlMode&HTMLMODE_ON)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					OfaHtmlOptions* pHtmlOpt = OFF_APP()->GetHtmlOptions();
//STRIP001 /*?*/ 					USHORT nExport = pHtmlOpt->GetExportMode();
//STRIP001 /*?*/ 					if(HTML_CFG_MSIE_40 != nExport && HTML_CFG_WRITER != nExport )
//STRIP001 /*?*/ 						rSet.DisableItem(nWhich);
//STRIP001 /*?*/ 				}
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case FN_INSERT_FRAME_INTERACT_NOCOL :
/*?*/ 			case FN_INSERT_FRAME_INTERACT:
/*?*/ 			{
/*?*/ 				if ( GetShell().IsSelFrmMode() ||
/*?*/ 					(0 != (nHtmlMode & HTMLMODE_ON) && 0 == (nHtmlMode & HTMLMODE_SOME_ABS_POS)))
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case SID_HYPERLINK_GETLINK:
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxItemSet aSet(GetPool(), RES_TXTATR_INETFMT, RES_TXTATR_INETFMT);
//STRIP001 /*?*/ 					rSh.GetAttr( aSet );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SvxHyperlinkItem aHLinkItem;
//STRIP001 /*?*/ 					const SfxPoolItem* pItem;
//STRIP001 /*?*/ 					if(SFX_ITEM_SET == aSet.GetItemState(RES_TXTATR_INETFMT, FALSE, &pItem))
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						const SwFmtINetFmt* pINetFmt = (const SwFmtINetFmt*)pItem;
//STRIP001 /*?*/ 						aHLinkItem.SetURL(pINetFmt->GetValue());
//STRIP001 /*?*/ 						aHLinkItem.SetTargetFrame(pINetFmt->GetTargetFrame());
//STRIP001 /*?*/ 						aHLinkItem.SetIntName(pINetFmt->GetName());
//STRIP001 /*?*/ 						const SvxMacro *pMacro = pINetFmt->GetMacro( SFX_EVENT_MOUSEOVER_OBJECT );
//STRIP001 /*?*/ 						if( pMacro )
//STRIP001 /*?*/ 							aHLinkItem.SetMacro(HYPERDLG_EVENT_MOUSEOVER_OBJECT, *pMacro);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pMacro = pINetFmt->GetMacro( SFX_EVENT_MOUSECLICK_OBJECT );
//STRIP001 /*?*/ 						if( pMacro )
//STRIP001 /*?*/ 							aHLinkItem.SetMacro(HYPERDLG_EVENT_MOUSECLICK_OBJECT, *pMacro);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pMacro = pINetFmt->GetMacro( SFX_EVENT_MOUSEOUT_OBJECT );
//STRIP001 /*?*/ 						if( pMacro )
//STRIP001 /*?*/ 							aHLinkItem.SetMacro(HYPERDLG_EVENT_MOUSEOUT_OBJECT, *pMacro);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						// Text des Links besorgen
//STRIP001 /*?*/ 						rSh.StartAction();
//STRIP001 /*?*/ 						rSh.CreateCrsr();
//STRIP001 /*?*/ 						rSh.SwCrsrShell::SelectTxtAttr(RES_TXTATR_INETFMT,TRUE);
//STRIP001 /*?*/ 						String sLinkName = rSh.GetSelTxt();
//STRIP001 /*?*/ 						aHLinkItem.SetName(sLinkName);
//STRIP001 /*?*/ 						aHLinkItem.SetInsertMode(HLINK_FIELD);
//STRIP001 /*?*/ 						rSh.DestroyCrsr();
//STRIP001 /*?*/ 						rSh.EndAction();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						String sReturn = rSh.GetSelTxt();
//STRIP001 /*?*/ 						sReturn.Erase(255);
//STRIP001 /*?*/ 						sReturn.EraseTrailingChars();
//STRIP001 /*?*/ 						aHLinkItem.SetName(sReturn);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					aHLinkItem.SetInsertMode((SvxLinkInsertMode)(aHLinkItem.GetInsertMode() |
//STRIP001 /*?*/ 						((nHtmlMode & HTMLMODE_ON) != 0 ? HLINK_HTMLMODE : 0)));
//STRIP001 /*?*/ 					aHLinkItem.SetMacroEvents (	HYPERDLG_EVENT_MOUSEOVER_OBJECT|
//STRIP001 /*?*/ 								HYPERDLG_EVENT_MOUSECLICK_OBJECT | HYPERDLG_EVENT_MOUSEOUT_OBJECT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					rSet.Put(aHLinkItem);
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FN_INSERT_FRAME:
/*?*/ 				if(rSh.IsSelFrmMode())
/*?*/ 				{
/*?*/ 					const int nSel = rSh.GetSelectionType();
/*?*/ 					if( (SwWrtShell::SEL_GRF | SwWrtShell::SEL_OLE ) & nSel )
/*?*/ 						rSet.DisableItem(nWhich);
/*?*/ 				}
/*?*/ 			break;
/*?*/ 			case FN_INSERT_HRULER :
/*?*/ 				if(rSh.IsReadOnlyAvailable() && rSh.HasReadonlySel() )
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void  SwTextShell::ExecDelete(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	switch( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case FN_DELETE_SENT:
//STRIP001 			if( rSh.IsTableMode() )
//STRIP001 			{
//STRIP001 				rSh.DeleteRow();
//STRIP001 				rSh.EnterStdMode();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rSh.DelToEndOfSentence();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_BACK_SENT:
//STRIP001 			rSh.DelToStartOfSentence();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_WORD:
//STRIP001 			rSh.DelNxtWord();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_BACK_WORD:
//STRIP001 			rSh.DelPrvWord();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_LINE:
//STRIP001 			rSh.DelToEndOfLine();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_BACK_LINE:
//STRIP001 			rSh.DelToStartOfLine();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_PARA:
//STRIP001 			rSh.DelToEndOfPara();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_BACK_PARA:
//STRIP001 			rSh.DelToStartOfPara();
//STRIP001 			break;
//STRIP001 		case FN_DELETE_WHOLE_LINE:
//STRIP001 			rSh.DelLine();
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			ASSERT(!this, "falscher Dispatcher");
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwTextShell::ExecTransliteration( SfxRequest & rReq )
//STRIP001 {
//STRIP001 	using namespace ::com::sun::star::i18n;
//STRIP001 	{
//STRIP001 		sal_uInt32 nMode = 0;
//STRIP001 
//STRIP001 		switch( rReq.GetSlot() )
//STRIP001 		{
//STRIP001 		case SID_TRANSLITERATE_UPPER:
//STRIP001 			nMode = TransliterationModules_LOWERCASE_UPPERCASE;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_LOWER:
//STRIP001 			nMode = TransliterationModules_UPPERCASE_LOWERCASE;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 			nMode = TransliterationModules_FULLWIDTH_HALFWIDTH;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 			nMode = TransliterationModules_HALFWIDTH_FULLWIDTH;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 			nMode = TransliterationModules_KATAKANA_HIRAGANA;
//STRIP001 			break;
//STRIP001 		case SID_TRANSLITERATE_KATAGANA:
//STRIP001 			nMode = TransliterationModules_HIRAGANA_KATAKANA;
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ASSERT(!this, "falscher Dispatcher");
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nMode )
//STRIP001 			GetShell().TransliterateText( nMode );
//STRIP001 	}
//STRIP001 }


/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/



/*N*/ SwTextShell::SwTextShell(SwView &rView) :
/*N*/     SwBaseShell(rView)//STRIP001 , pPostItFldMgr( 0 )
/*N*/ {
/*N*/ 	SetName(String::CreateFromAscii("Text"));
/*N*/ 	SetHelpId(SW_TEXTSHELL);
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ SwTextShell::~SwTextShell()
/*N*/ {
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SwTextShell::InsertSymbol( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001     if( pArgs )
//STRIP001         pArgs->GetItemState(GetPool().GetWhich(FN_INSERT_SYMBOL), FALSE, &pItem);
//STRIP001 
//STRIP001     String aChars, aFontName;
//STRIP001     if ( pItem )
//STRIP001     {
//STRIP001         aChars = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001         const SfxPoolItem* pFtItem = NULL;
//STRIP001         pArgs->GetItemState( GetPool().GetWhich(FN_PARAM_1), FALSE, &pFtItem);
//STRIP001         const SfxStringItem* pFontItem = PTR_CAST( SfxStringItem, pFtItem );
//STRIP001         if ( pFontItem )
//STRIP001             aFontName = pFontItem->GetValue();
//STRIP001     }
//STRIP001 
//STRIP001 	SwWrtShell &rSh = GetShell();
//STRIP001 	SfxItemSet aSet( GetPool(), RES_CHRATR_FONT, RES_CHRATR_FONT,
//STRIP001 								RES_CHRATR_CJK_FONT, RES_CHRATR_CJK_FONT,
//STRIP001 								RES_CHRATR_CTL_FONT, RES_CHRATR_CTL_FONT,
//STRIP001 								0 );
//STRIP001 	rSh.GetAttr( aSet );
//STRIP001 	USHORT nScript = rSh.GetScriptType();
//STRIP001 
//STRIP001 	SvxFontItem aFont;
//STRIP001 	{
//STRIP001 		SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONT, *aSet.GetPool() );
//STRIP001 		aSetItem.GetItemSet().Put( aSet, FALSE );
//STRIP001 		const SfxPoolItem* pI = aSetItem.GetItemOfScript( nScript );
//STRIP001 		if( pI )
//STRIP001 			aFont = *(SvxFontItem*)pI;
//STRIP001 		else
//STRIP001 			aFont = (SvxFontItem&)aSet.Get( GetWhichOfScript(
//STRIP001 						RES_CHRATR_FONT,
//STRIP001                         GetI18NScriptTypeOfLanguage( (USHORT)GetAppLanguage() ) ));
//STRIP001 	}
//STRIP001 
//STRIP001     Font aNewFont(aFontName, Size(1,1)); // Size nur wg. CTOR
//STRIP001     if( !aChars.Len() )
//STRIP001 	{
//STRIP001 		// Eingestellten Font als Default
//STRIP001         SvxCharacterMap* pDlg = new SvxCharacterMap( &GetView().GetViewFrame()->GetWindow(), FALSE );
//STRIP001 		Font aDlgFont( pDlg->GetCharFont() );
//STRIP001 		SwViewOption aOpt(*GetShell().GetViewOptions());
//STRIP001 		String sSymbolFont = aOpt.GetSymbolFont();
//STRIP001         if( !aFontName.Len() && sSymbolFont.Len() )
//STRIP001 			aDlgFont.SetName(sSymbolFont);
//STRIP001 		else
//STRIP001 			aDlgFont.SetName( aFont.GetFamilyName() );
//STRIP001 
//STRIP001 		pDlg->SetCharFont( aDlgFont );
//STRIP001 
//STRIP001 		if( RET_OK == pDlg->Execute() )
//STRIP001 		{
//STRIP001 			aChars = pDlg->GetCharacters();
//STRIP001 			aNewFont = pDlg->GetCharFont();
//STRIP001 			aOpt.SetSymbolFont(aNewFont.GetName());
//STRIP001 			SW_MOD()->ApplyUsrPref(aOpt, &GetView());
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bFontChanged = FALSE;
//STRIP001 	if( aChars.Len() )
//STRIP001 	{
//STRIP001 		rSh.StartAllAction();
//STRIP001 
//STRIP001 		// Selektierten Inhalt loeschen
//STRIP001 		rSh.StartUndo( UNDO_INSERT );
//STRIP001 		if ( rSh.HasSelection() )
//STRIP001 		{
//STRIP001 			rSh.DelRight();
//STRIP001 			aSet.ClearItem();
//STRIP001 			rSh.GetAttr( aSet );
//STRIP001 
//STRIP001 			SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONT, *aSet.GetPool() );
//STRIP001 			aSetItem.GetItemSet().Put( aSet, FALSE );
//STRIP001 			const SfxPoolItem* pI = aSetItem.GetItemOfScript( nScript );
//STRIP001 			if( pI )
//STRIP001 				aFont = *(SvxFontItem*)pI;
//STRIP001 			else
//STRIP001 				aFont = (SvxFontItem&)aSet.Get( GetWhichOfScript(
//STRIP001 							RES_CHRATR_FONT,
//STRIP001                             GetI18NScriptTypeOfLanguage( (USHORT)GetAppLanguage() ) ));
//STRIP001 		}
//STRIP001 
//STRIP001 		// Zeichen einfuegen
//STRIP001 		rSh.Insert( aChars );
//STRIP001 
//STRIP001         // #108876# a font attribute has to be set always due to a guessed script type  
//STRIP001      if( aNewFont.GetName().Len() )
//STRIP001 		{
//STRIP001 			bFontChanged = TRUE;
//STRIP001 			SvxFontItem aNewFontItem( aFont );
//STRIP001 			aNewFontItem.GetFamilyName() = aNewFont.GetName();
//STRIP001 			aNewFontItem.GetFamily()	 = aNewFont.GetFamily();
//STRIP001 			aNewFontItem.GetPitch() 	 = aNewFont.GetPitch();
//STRIP001 			aNewFontItem.GetCharSet()	 = aNewFont.GetCharSet();
//STRIP001 
//STRIP001 			nScript = pBreakIt->GetAllScriptsOfText( aChars );
//STRIP001 			if( SCRIPTTYPE_LATIN & nScript )
//STRIP001 				aSet.Put( aNewFontItem, RES_CHRATR_FONT);
//STRIP001 			if( SCRIPTTYPE_ASIAN & nScript )
//STRIP001 				aSet.Put( aNewFontItem, RES_CHRATR_CJK_FONT );
//STRIP001 			if( SCRIPTTYPE_COMPLEX & nScript )
//STRIP001 				aSet.Put( aNewFontItem, RES_CHRATR_CTL_FONT );
//STRIP001 
//STRIP001 			rSh.SetMark();
//STRIP001 			rSh.ExtendSelection( FALSE, aChars.Len() );
//STRIP001 			rSh.SetAttr( aSet, SETATTR_DONTEXPAND | SETATTR_NOFORMATATTR );
//STRIP001 			if( !rSh.IsCrsrPtAtEnd() )
//STRIP001 				rSh.SwapPam();
//STRIP001 			rSh.ClearMark();
//STRIP001 			rSh.UpdateAttr();
//STRIP001             aFont = aNewFontItem;
//STRIP001 		}
//STRIP001 
//STRIP001 		rSh.EndAllAction();
//STRIP001 		rSh.EndUndo( UNDO_INSERT );
//STRIP001 
//STRIP001         if ( aChars.Len() )
//STRIP001         {
//STRIP001             rReq.AppendItem( SfxStringItem( GetPool().GetWhich(FN_INSERT_SYMBOL), aChars ) );
//STRIP001             rReq.AppendItem( SfxStringItem( FN_PARAM_1, aNewFont.GetName() ) );
//STRIP001             rReq.Done();
//STRIP001         }
//STRIP001     }
//STRIP001 }


}
