/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_viewstat.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:52:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _COM_SUN_STAR_LINGUISTIC2_XTHESAURUS_HPP_
// auto strip #include <com/sun/star/linguistic2/XThesaurus.hpp>
// auto strip #endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif
//#ifndef _TWAIN_HXX //autogen
//#include <svtools/twain.hxx>
//#endif
// auto strip #ifndef _SFX_OBJITEM_HXX //autogen
// auto strip #include <bf_sfx2/objitem.hxx>
// auto strip #endif
#ifndef _SVT_IMAGEITM_HXX
#include <svtools/imageitm.hxx>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
// auto strip #ifndef _SVX_PROTITEM_HXX //autogen
// auto strip #include <bf_svx/protitem.hxx>
// auto strip #endif
#ifndef _SVXLINKMGR_HXX
#include <bf_svx/linkmgr.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX
#include <bf_svx/langitem.hxx>
#endif
#ifndef _SVX_BRSHITEM_HXX //autogen
#include <bf_svx/brshitem.hxx>
#endif
#ifndef _SVX_HTMLMODE_HXX //autogen
#include <bf_svx/htmlmode.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <bf_svx/unolingu.hxx>
#endif
#ifndef _SFXMSGPOOL_HXX
#include <bf_sfx2/msgpool.hxx>
#endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif

// auto strip #ifndef _REDLENUM_HXX
// auto strip #include <redlenum.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
// auto strip #ifndef _BASESH_HXX
// auto strip #include <basesh.hxx>
// auto strip #endif
#ifndef _UITOOL_HXX
#include <uitool.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
// auto strip #ifndef _TABLEMGR_HXX
// auto strip #include <tablemgr.hxx>
// auto strip #endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
#ifndef _SWGLOBDOCSH_HXX //autogen
#include <globdoc.hxx>
#endif
#ifndef _DOC_HXX //autogen
#include <doc.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
namespace binfilter {

using namespace ::com::sun::star;
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ void SwView::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	sal_uInt16 nWhich = aIter.FirstWhich();
/*N*/ 	sal_uInt16 eFrmType = FRMTYPE_NONE;
/*N*/ 	int bGetFrmType = sal_False;
/*N*/ 	sal_Bool bWeb = 0 != PTR_CAST(SwWebView, this);
/*N*/ 
/*N*/ 	while(nWhich)
/*N*/ 	{
/*N*/ 		switch(nWhich)
/*N*/ 		{
/*?*/ 			case FN_EDIT_LINK_DLG:
/*?*/ 				if( !pWrtShell->GetLinkManager().GetLinks().Count()	)
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 				else if( pWrtShell->IsSelFrmMode() &&
/*?*/ 							pWrtShell->IsSelObjProtected(FLYPROTECT_CONTENT))
/*?*/ 						rSet.DisableItem(nWhich);
/*?*/ 				break;
/*N*/ 
/*N*/ 			case FN_INSERT_CAPTION:
/*N*/ 			{
/*N*/ 				// Captions gibt's fuer Grafiken, OLE-Objekte, Rahmen und Tabellen
/*N*/ 				if( !bGetFrmType )
/*N*/ 					eFrmType = pWrtShell->GetFrmType(0,sal_True), bGetFrmType = sal_True;
/*N*/ 				if (! ( ((eFrmType & FRMTYPE_FLY_ANY) && nSelectionType != SwWrtShell::SEL_DRW_TXT)||
/*N*/ 						nSelectionType & SwWrtShell::SEL_TBL ||
/*N*/ 						nSelectionType & SwWrtShell::SEL_DRW) )
/*N*/ 					rSet.DisableItem(nWhich);
/*N*/ 				else if( pWrtShell->IsTableMode() )
/*?*/ 					rSet.DisableItem(nWhich);
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*?*/ 			case FN_EDIT_FOOTNOTE:
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( !pWrtShell->GetCurFtn() )
//STRIP001 /*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			}
/*?*/ 			break;
/*?*/ 
/*?*/ 			case FN_CHANGE_PAGENUM:
/*?*/ 			{
/*?*/ 				sal_uInt16 nType = pWrtShell->GetFrmType(0,sal_True);
/*?*/ 				if( ( FRMTYPE_FLY_ANY | FRMTYPE_HEADER | FRMTYPE_FOOTER |
/*?*/ 					  FRMTYPE_FOOTNOTE | FRMTYPE_DRAWOBJ ) & nType )
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 				else
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 rSet.Put(SfxUInt16Item(nWhich, pWrtShell->GetPageOffset()));
/*?*/ 			}
/*?*/ 			break;
/*N*/ 			case SID_PRINTDOC:
/*N*/ 			case SID_PRINTDOCDIRECT:
/*N*/ 				GetSlotState( nWhich, SfxViewShell::GetInterface(),	&rSet );
/*N*/ 			break;
/*?*/ 			case SID_ATTR_PAGE:
/*?*/ 			case SID_ATTR_PAGE_SIZE:
/*?*/ 			case SID_ATTR_PAGE_PAPERBIN:
/*?*/ 			case RES_PAPER_BIN:
/*?*/ 			case FN_PARAM_FTN_INFO:
/*?*/ 			{
/*?*/ 				const sal_uInt16 nCurIdx = pWrtShell->GetCurPageDesc();
/*?*/ 				const SwPageDesc& rDesc = pWrtShell->GetPageDesc( nCurIdx );
/*?*/ 				::binfilter::PageDescToItemSet( rDesc, rSet);
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case RES_BACKGROUND:
/*?*/ 			case SID_ATTR_BRUSH:
/*?*/ 			{
/*?*/ 				const sal_uInt16 nCurIdx = pWrtShell->GetCurPageDesc();
/*?*/ 				const SwPageDesc& rDesc = pWrtShell->GetPageDesc( nCurIdx );
/*?*/ 				const SwFrmFmt& rMaster = rDesc.GetMaster();
/*?*/ 				const SvxBrushItem& rBrush = (const SvxBrushItem&)
/*?*/ 									rMaster.GetAttr(RES_BACKGROUND, sal_True);
/*?*/ 				rSet.Put(rBrush);
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case SID_CLEARHISTORY:
/*?*/ 			{
/*?*/ 				rSet.Put(SfxBoolItem(nWhich, pWrtShell->GetUndoIds() != 0));
/*?*/ 			}
/*?*/ 			break;
/*N*/ 			case SID_UNDO:
/*N*/ 			{
/*N*/ 				//JP 21.07.98: Bug 53429 - die muss noch nicht vorhanden sein
/*N*/ 				// 				also lasse sie mal anlegen:
/*N*/ 				if( !pShell )
/*N*/ 					SelectShell();
/*N*/ 
/*N*/ 				const SfxPoolItem* pState = pShell->GetSlotState(SID_UNDO);
/*N*/ 				if(pState)
/*N*/ 					rSet.Put(*pState);
/*N*/ 				else
/*N*/ 					rSet.DisableItem(nWhich);
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case FN_INSERT_CTRL:
/*N*/             {
/*N*/                 SfxImageItem aImgItem(nWhich, bWeb ? SwView::nWebInsertCtrlState : SwView::nInsertCtrlState);
/*N*/                 SfxSlotPool& rPool = SFX_APP()->GetSlotPool( GetViewFrame() );
/*N*/                 const SfxSlot* pSlot = rPool.GetSlot( aImgItem.GetValue() );
/*N*/                 if(pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ))
/*N*/                 {
/*?*/                     if(pWrtShell->IsInVerticalText())
/*?*/                         aImgItem.SetRotation(2700);
/*?*/ #ifdef BIDI
/*?*/                     if(pWrtShell->IsInRightToLeftText())
/*?*/                         aImgItem.SetMirrored(TRUE);
/*?*/ #endif
/*N*/                 }
/*N*/                 rSet.Put(aImgItem);
/*N*/             }
/*N*/             break;
/*N*/ 			case FN_INSERT_OBJ_CTRL:
/*N*/ 			if(bWeb)
/*?*/ 				rSet.DisableItem(nWhich);
/*N*/ 			else
/*N*/             {
/*N*/                 SfxImageItem aImgItem(nWhich, SwView::nInsertObjectCtrlState);
/*N*/                 SfxSlotPool& rPool = SFX_APP()->GetSlotPool( GetViewFrame() );
/*N*/                 const SfxSlot* pSlot = rPool.GetSlot( aImgItem.GetValue() );
/*N*/                 if(pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ))
/*N*/                 {
/*?*/                     if(pWrtShell->IsInVerticalText())
/*?*/                         aImgItem.SetRotation(2700);
/*?*/ #ifdef BIDI
/*?*/                     if(pWrtShell->IsInRightToLeftText())
/*?*/                         aImgItem.SetMirrored(TRUE);
/*?*/ #endif
/*N*/                 }
/*N*/                 rSet.Put(aImgItem);
/*N*/             }
/*N*/ 			break;
/*?*/ 			case FN_UPDATE_TOX:
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(!pWrtShell->GetTOXCount())
//STRIP001 /*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			break;
/*?*/ 			case FN_EDIT_CURRENT_TOX:
/*?*/ 			case FN_UPDATE_CUR_TOX:
/*?*/             {
/*?*/                 const SwTOXBase* pBase = 0;
/*?*/                 if(0 == (pBase = pWrtShell->GetCurTOX()) ||
/*?*/                     (FN_EDIT_CURRENT_TOX == nWhich && pBase->IsTOXBaseInReadonly()))
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/             }
/*?*/             break;
/*?*/ 			case SID_TWAIN_SELECT:
/*?*/ 			case SID_TWAIN_TRANSFER:
/*?*/ #if defined WIN || defined WNT || defined UNX
/*?*/ 			{
/*?*/ 				if(!SW_MOD()->GetScannerManager().is())
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			}
/*?*/ #endif
/*?*/ 			break;
/*?*/ 			case RES_PARATR_TABSTOP:
/*?*/ 			case SID_ATTR_DEFTABSTOP:
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SvxTabStopItem& rDefTabs =
//STRIP001 /*?*/ 					(const SvxTabStopItem&)pWrtShell->
//STRIP001 /*?*/ 										GetDefault(RES_PARATR_TABSTOP);
//STRIP001 /*?*/ 				rSet.Put( SfxUInt16Item( nWhich,
//STRIP001 /*?*/ 												(sal_uInt16)::binfilter::GetTabDist(rDefTabs)));
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case SID_ATTR_LANGUAGE:
/*?*/ 			{
/*?*/ 				rSet.Put((const SvxLanguageItem&)
/*?*/ 					pWrtShell->GetDefault(RES_CHRATR_LANGUAGE), SID_ATTR_LANGUAGE);
/*?*/ 			}
/*?*/ 			break;
/*?*/ 			case RES_CHRATR_CJK_LANGUAGE:
/*?*/ 				rSet.Put((const SvxLanguageItem&)
/*?*/ 					pWrtShell->GetDefault(RES_CHRATR_CJK_LANGUAGE), RES_CHRATR_CJK_LANGUAGE);
/*?*/ 			break;
/*?*/ 			case RES_CHRATR_CTL_LANGUAGE:
/*?*/ 				rSet.Put((const SvxLanguageItem&)
/*?*/ 					pWrtShell->GetDefault(RES_CHRATR_CTL_LANGUAGE), RES_CHRATR_CTL_LANGUAGE);
/*?*/ 			break;
/*?*/ 			case FN_INSERT_FOOTER:
/*?*/ 			case FN_INSERT_HEADER:
/*?*/ 				if(!pWrtShell->IsBrowseMode())
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 				else
						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 					rSet.Put(SfxBoolItem(nWhich,
//STRIP001 /*?*/ 						nWhich == FN_INSERT_HEADER ?
//STRIP001 /*?*/ 							pWrtShell->IsHeadInBrowse() :
//STRIP001 /*?*/ 								pWrtShell->IsFootInBrowse()));
/*?*/ 			break;
/*N*/ 			case FN_HYPHENATE_OPT_DLG:
/*N*/ 			{
/*N*/ 				sal_Bool bCheck = sal_False;
/*N*/ 
/*N*/ 				if (pWrtShell->GetSelectionType() & (SwWrtShell::SEL_DRW_TXT|SwWrtShell::SEL_DRW))
						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 					bCheck = IsDrawTextHyphenate();
/*N*/ 				rSet.Put(SfxBoolItem(nWhich, bCheck));
/*N*/ 			}
/*N*/ 			break;
/*?*/ 		case FN_REDLINE_ON:
/*?*/             if( !pWrtShell->GetDoc()->GetRedlinePasswd().getLength() &&
/*?*/                 pWrtShell->IsInsMode() )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 rSet.Put( SfxBoolItem( nWhich,
//STRIP001 /*?*/ 					(pWrtShell->GetRedlineMode() & REDLINE_ON) != 0));
/*?*/ 			}
/*?*/ 			else
/*?*/ 				rSet.DisableItem( nWhich );
/*?*/ 			break;
/*?*/         case FN_REDLINE_PROTECT :
/*?*/         {
/*?*/             rSet.Put( SfxBoolItem( nWhich, pWrtShell->GetDoc()->GetRedlinePasswd().getLength() > 0 ) );
/*?*/         }
/*?*/         break;
/*?*/ 		case FN_REDLINE_SHOW:
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 sal_uInt16 nMask = REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE;
//STRIP001 /*?*/ 				rSet.Put( SfxBoolItem( nWhich,
//STRIP001 /*?*/ 					(pWrtShell->GetRedlineMode() & nMask) == nMask ));
/*?*/ 			}
/*?*/ 			break;
/*N*/ 		case SID_GALLERY :
/*N*/ 		case FN_REDLINE_ACCEPT:
/*N*/ 			{
/*N*/ 				SfxViewFrame* pVFrame = GetViewFrame();
/*N*/ 				if (pVFrame->KnowsChildWindow(nWhich))
/*N*/ 					rSet.Put(SfxBoolItem( nWhich, pVFrame->HasChildWindow(nWhich)));
/*N*/ 				else
/*N*/ 					rSet.DisableItem(nWhich);
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		case FN_THESAURUS_DLG:
/*N*/ 			{
/*N*/ 				SwWrtShell  &rSh = GetWrtShell();
/*N*/ 				if (2 <= rSh.GetCrsrCnt())	// multi selection?
/*?*/ 					rSet.DisableItem(nWhich);
/*N*/ 				else
/*N*/ 				{
/*N*/ 					LanguageType nLang = rSh.GetCurLang();
/*N*/ 
/*N*/ 					// disable "Thesaurus" (menu entry and key shortcut) if the
/*N*/ 					// language is not supported (by default it is enabled)
						/*N*/ 					uno::Reference< linguistic2::XThesaurus >  xThes( ::binfilter::GetThesaurus() );
/*N*/ 					if (!xThes.is() || nLang == LANGUAGE_NONE ||
/*N*/ 						!xThes->hasLocale( SvxCreateLocale( nLang ) ))
/*N*/ 						rSet.DisableItem(nWhich);
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		case SID_HANGUL_HANJA_CONVERSION:
/*N*/             {
/*N*/                 if (!SvtCJKOptions().IsAnyEnabled())
/*N*/                     rSet.DisableItem(nWhich);
/*N*/             }
/*N*/             break;
/*?*/ 			case SID_MAIL_SCROLLBODY_PAGEDOWN:
/*?*/ 				{
/*?*/ 					long nBottom = pWrtShell->GetDocSize().Height() + DOCUMENTBORDER;
/*?*/ 					long nAct = GetVisArea().Bottom();
/*?*/ 					rSet.Put(SfxBoolItem(SID_MAIL_SCROLLBODY_PAGEDOWN, nAct < nBottom ));
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_DOCUMENT_COMPARE:
/*?*/ 			case SID_DOCUMENT_MERGE:
/*?*/ 				if( GetDocShell()->IsA( SwGlobalDocShell::StaticType() ) ||
/*?*/ //					pWrtShell->IsAnySectionInDoc( sal_True, sal_True, sal_True )||
/*?*/ 					(SID_DOCUMENT_MERGE == nWhich && pWrtShell->GetDoc()->GetRedlinePasswd().getLength()))
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			break;
/*N*/             case  SID_VIEW_DATA_SOURCE_BROWSER:
/*N*/                 rSet.Put( SfxBoolItem( nWhich, GetViewFrame()->HasChildWindow( SID_BROWSER ) ) );
/*N*/             break;
/*?*/             case SID_READONLY_MODE:
/*?*/                 rSet.Put(SfxBoolItem(nWhich,
/*?*/                     pWrtShell->HasReadonlySel()||GetDocShell()->IsReadOnly()));
/*?*/             break;
/*N*/             case SID_IMAGE_ORIENTATION:
/*N*/             {
/*N*/                 SfxImageItem aImageItem(nWhich);
/*N*/                 if(pWrtShell->IsInVerticalText())
/*?*/                     aImageItem.SetRotation( 2700 );
/*N*/ #ifdef BIDI
/*N*/                 if(pWrtShell->IsInRightToLeftText())
/*?*/                     aImageItem.SetMirrored( TRUE );
/*N*/ #endif
/*N*/                 rSet.Put(aImageItem);
/*N*/             }
/*N*/             break;
/*N*/ 			  case FN_INSERT_FIELD_DATA_ONLY :
/*N*/                 if(!bInMailMerge && !GetViewFrame()->HasChildWindow(nWhich))
/*N*/                     rSet.DisableItem(nWhich);
/*N*/             break;
/*N*/         }
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }


/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ void SwView::GetDrawState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	sal_Bool bWeb = 0 != PTR_CAST(SwWebView, this);
/*N*/ 
/*N*/ 	for( sal_uInt16 nWhich = aIter.FirstWhich(); nWhich;
/*N*/ 											nWhich = aIter.NextWhich() )
/*N*/ 		switch(nWhich)
/*N*/ 		{
/*N*/ 		case SID_INSERT_DRAW:
/*N*/ 			if(bWeb)
/*?*/ 				rSet.DisableItem(nWhich);
/*N*/ 			else
/*N*/ 			{
/*N*/ 				SfxAllEnumItem aEnum(SID_INSERT_DRAW, nDrawSfxId);
/*N*/ 				if ( !SvtLanguageOptions().IsVerticalTextEnabled() )
/*N*/ 				{
/*N*/ 					aEnum.DisableValue( SID_DRAW_CAPTION_VERTICAL );
/*N*/ 					aEnum.DisableValue( SID_DRAW_TEXT_VERTICAL );
/*N*/ 				}
/*N*/ 				rSet.Put(aEnum);
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_SHOW_HIDDEN:
/*N*/ 		case SID_SHOW_FORMS:
/*?*/ 			rSet.DisableItem( nWhich );
/*?*/ 			// rSet.Put( SfxBoolItem(nWhich,sal_True ));
/*?*/ 			break;
/*N*/ 
/*N*/ 		case SID_DRAW_TEXT_MARQUEE:
/*?*/ 			if (::binfilter::GetHtmlMode(GetDocShell()) & HTMLMODE_SOME_STYLES)
/*?*/ 				rSet.Put( SfxBoolItem(nWhich, nDrawSfxId == nWhich));
/*?*/ 			else
/*?*/ 				rSet.DisableItem(nWhich);
/*?*/ 			break;
/*?*/ 		case SID_OBJECT_SELECT:
/*?*/ 			rSet.Put( SfxBoolItem(nWhich, nDrawSfxId == nWhich ||
/*?*/ 										  nFormSfxId == nWhich));
/*N*/ 			break;
/*N*/ 		}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ sal_Bool SwView::HasUIFeature( sal_uInt32 nFeature )
/*N*/ {
/*N*/ 	return pWrtShell->IsLabelDoc();
/*N*/ }

}
