/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_dlgass.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:49:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_PRESENTATION_CLICKACTION_HPP_
#include <com/sun/star/presentation/ClickAction.hpp>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_LSTBOX_HXX	// class ListBox
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_COMBOBOX_HXX //class ComboBox
#include <vcl/combobox.hxx>
#endif

#ifndef _SFXDOCTEMPL_HXX // class SfxDocumentTemplate
#include <bf_sfx2/doctempl.hxx>
#endif
#ifndef _SFXLSTNER_HXX // class SfxListener
#include <svtools/lstner.hxx>
#endif

#ifndef _SFXDOCINF_HXX // SfxDocumentInfo
#include <bf_sfx2/docinf.hxx>
#endif

#ifndef _SFX_OBJSH_HXX // SfxObjectShell
#include <bf_sfx2/objsh.hxx>
#endif

#ifndef _EHDL_HXX // SfxErrorContext
#include <svtools/ehdl.hxx>
#endif

#ifndef _SFXECODE_HXX //ERRCTX_SFX_LOADTEMPLATE
#include <svtools/sfxecode.hxx>
#endif

#ifndef _URLOBJ_HXX // INetURLObject
#include <tools/urlobj.hxx>
#endif

#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif

#ifndef _SD_FADEDEF_H // enum FadeSpeed
#include <fadedef.h>
#endif

#ifndef _SFXSIDS_HRC //autogen
#include <bf_sfx2/sfxsids.hrc>
#endif

#ifndef _UNDO_HXX // class SfxUndoManager
#include <svtools/undo.hxx>
#endif

#ifndef _SD_DOCSHELL_HXX
#include "docshell.hxx"
#endif

#ifndef _SV_GDIMTF_HXX //autogen
#include <vcl/gdimtf.hxx>
#endif

#ifndef _SD_DOCPREV_HXX_
#include "docprev.hxx"
#endif

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif

#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

#ifndef _SFXREQUEST_HXX
#include <bf_sfx2/request.hxx>
#endif

#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif

#ifndef INCLUDED_SVTOOLS_HISTORYOPTIONS_HXX
#include <svtools/historyoptions.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#include "sdpage.hxx"
#include "helpids.h"
#include "assclass.hxx"
#include "dlgass.hrc"
#include "dlgass.hxx"
#include "dlgctrls.hxx"
#include "strings.hrc"
#include "dlgassim.hxx"
#include "TemplateScanner.hxx"
#include "WindowUpdater.hxx"

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::binfilter::sd;


//STRIP001 void InterpolateFixedBitmap( FixedBitmap * pBitmap )
//STRIP001 {
//STRIP001 	Bitmap aBmp( pBitmap->GetBitmap() );
//STRIP001 	Size aSize = pBitmap->GetSizePixel();
//STRIP001 	aBmp.Scale( aSize, BMP_SCALE_INTERPOLATE );
//STRIP001 	pBitmap->SetBitmap( aBmp );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ====================================================================
//STRIP001 // ====================================================================
//STRIP001 
//STRIP001 UINT32 PageHelpIds[] =
//STRIP001 {
//STRIP001 	HID_SD_AUTOPILOT_PAGE1,
//STRIP001 	HID_SD_AUTOPILOT_PAGE2,
//STRIP001 	HID_SD_AUTOPILOT_PAGE3,
//STRIP001 	HID_SD_AUTOPILOT_PAGE4,
//STRIP001 	HID_SD_AUTOPILOT_PAGE5
//STRIP001 };
//STRIP001 
//STRIP001 // ====================================================================
//STRIP001 
//STRIP001 class PasswordEntry
//STRIP001 {
//STRIP001 public:
//STRIP001 	String m_aPassword;
//STRIP001 	String m_aPath;
//STRIP001 };
//STRIP001 
//STRIP001 DECLARE_LIST( PasswordEntryList, PasswordEntry * )//STRIP008 ;
//STRIP001 
//STRIP001 // ====================================================================
//STRIP001 
//STRIP001 class AssistentDlgImpl : public SfxListener
//STRIP001 {
//STRIP001 public:
//STRIP001 	AssistentDlgImpl( Window* pWindow, const Link& rFinishLink, BOOL bAutoPilot  );
//STRIP001 	~AssistentDlgImpl();
//STRIP001 
//STRIP001     /// Local mutex used to serialize concurrent method calls.
//STRIP001     ::osl::Mutex m_aMutex;
//STRIP001 
//STRIP001 	SfxObjectShellLock GetDocument();
//STRIP001 
//STRIP001 	/** closes the current preview docshell */
//STRIP001 	void CloseDocShell();
//STRIP001 
//STRIP001 	/**	Extract form the history list of recently used files the impress
//STRIP001 		files and insert them into a listbox.
//STRIP001 	*/
//STRIP001 	void	ScanDocmenu			(void);
//STRIP001     /**	Flag that is set to TRUE after the recently used files have been
//STRIP001         scanned.
//STRIP001 	*/
//STRIP001 	BOOL m_bRecentDocumentsReady;
//STRIP001 
//STRIP001 	/**	When the list of templates has not been scanned already this is done
//STRIP001         when this method is called.  That includes requesting the whole list
//STRIP001         of templates from UCB and extracting from that list the impress
//STRIP001         templates and layouts and storing them for later use in
//STRIP001         <member>m_aPresentList</member>.  Note that the first call to this
//STRIP001         method after installing a new Office may take some time.
//STRIP001 	*/
//STRIP001 	void ProvideTemplates (void);
//STRIP001 
//STRIP001 	/**	This method transfers the template folders from the template scanner
//STRIP001 		to the internal structures of this class.  On termination it sets
//STRIP001 		the flag <member>m_bTemplatesReady</member> to <TRUE/> to indicate
//STRIP001 		that the templates are available.
//STRIP001         @param rTemplateFolders
//STRIP001             This is a list of template folders.  This method takes ownership
//STRIP001             of the supplied entries by removing them from the list and
//STRIP001             transferring them to an internal structure.
//STRIP001 	*/
//STRIP001 	void TemplateScanDone (std::vector<TemplateDir*>& rTemplateFolders);
//STRIP001 
//STRIP001 	/**	Flag that is set to TRUE after the impress templates have been
//STRIP001         scanned.
//STRIP001 	*/
//STRIP001 	BOOL m_bTemplatesReady;
//STRIP001 
//STRIP001     /** Flag used to prevent nested or concurrent calls to the
//STRIP001         <member>UpdatePreview</memember> method.  A <TRUE/> value indicates
//STRIP001         that a preview update is currently active.
//STRIP001     */
//STRIP001     BOOL m_bPreviewUpdating;
//STRIP001 
//STRIP001 	Window* m_pWindow;
//STRIP001 
//STRIP001 	void SavePassword( SfxObjectShellLock xDoc, const String& rPath );
//STRIP001 	void RestorePassword( SfxItemSet* pSet, const String& rPath );
//STRIP001 	String GetPassword( const String rPath );
//STRIP001 	void DeletePassords();
//STRIP001 
//STRIP001 	PasswordEntryList m_aPasswordList;
//STRIP001 
//STRIP001 	String m_aDocFile;
//STRIP001 	String m_aLayoutFile;
//STRIP001 
//STRIP001 	String GetDocFileName();
//STRIP001 	String GetLayoutFileName();
//STRIP001 
//STRIP001 	///	List of URLs of recently used impress files.
//STRIP001 	std::vector<String*> m_aOpenFilesList;
//STRIP001 
//STRIP001 	///	List of folders containing data about impress templates.
//STRIP001 	std::vector<TemplateDir*> m_aPresentList;
//STRIP001 
//STRIP001 	///	Currently selected template folder.
//STRIP001 	TemplateDir* m_pTemplateRegion;
//STRIP001 
//STRIP001 	///	Currently selected layout folder.
//STRIP001 	TemplateDir* m_pLayoutRegion;
//STRIP001 
//STRIP001 	// preview
//STRIP001 	BOOL m_bUserDataDirty;
//STRIP001 	Timer m_aPrevTimer;
//STRIP001 	Timer m_aEffectPrevTimer;
//STRIP001 	Timer m_aUpdatePageListTimer;
//STRIP001 	Timer m_aStartScanTimer;
//STRIP001 
//STRIP001 	SfxObjectShellLock xDocShell;
//STRIP001 
//STRIP001     ::std::auto_ptr<WindowUpdater> mpWindowUpdater;
//STRIP001 
//STRIP001 	BOOL m_bPreview;
//STRIP001 	USHORT m_nShowPage;
//STRIP001 	BOOL m_bDocPreview;
//STRIP001 
//STRIP001 	ULONG m_nTemplate;
//STRIP001 
//STRIP001 	String m_aPageListFile;
//STRIP001 
//STRIP001 	void UpdatePreview( BOOL bDocPreview );
//STRIP001 	void UpdatePageList();
//STRIP001 	void UpdateUserData();
//STRIP001 
//STRIP001 	BOOL IsOwnFormat( const String& rPath );
//STRIP001 
//STRIP001 	// dlg status
//STRIP001 	void EndDialog( long nResult = 0 );
//STRIP001 
//STRIP001 	void SetStartType( StartType eType );
//STRIP001 	StartType GetStartType();
//STRIP001 
//STRIP001 	void SelectTemplateRegion( const String& rRegion );
//STRIP001 	void SelectLayoutRegion( const String& rRegion );
//STRIP001 
//STRIP001 	void UpdatePage();
//STRIP001 	void ChangePage();
//STRIP001 	void LeavePage();
//STRIP001 
//STRIP001 	DECL_LINK( StartScanHdl, void * );
//STRIP001 	DECL_LINK( SelectFileHdl, ListBox * );
//STRIP001 	DECL_LINK( SelectRegionHdl, ListBox * );
//STRIP001 	DECL_LINK( UpdatePreviewHdl, void * );
//STRIP001 	DECL_LINK( UpdatePageListHdl, void * );
//STRIP001 	DECL_LINK( StartTypeHdl, RadioButton * );
//STRIP001 	DECL_LINK( SelectTemplateHdl, ListBox * );
//STRIP001 	DECL_LINK( NextPageHdl, PushButton * );
//STRIP001 	DECL_LINK( LastPageHdl, PushButton * );
//STRIP001 	DECL_LINK( PreviewFlagHdl, CheckBox * );
//STRIP001 	DECL_LINK( EffectPreviewHdl, Button * );
//STRIP001 	DECL_LINK( SelectLayoutHdl, ListBox * );
//STRIP001 	DECL_LINK( PageSelectHdl, Control * );
//STRIP001 	DECL_LINK( PresTypeHdl, RadioButton * );
//STRIP001 	DECL_LINK( UpdateUserDataHdl, Edit* );
//STRIP001 	DECL_LINK( SelectEffectHdl, void* );
//STRIP001 
//STRIP001 	// Common
//STRIP001 	Assistent			m_aAssistentFunc;
//STRIP001 	CheckBox			m_aPreviewFlag;
//STRIP001 	CheckBox			m_aStartWithFlag;
//STRIP001 	HelpButton			m_aHelpButton;
//STRIP001 	CancelButton		m_aCancelButton;
//STRIP001 	PushButton			m_aLastPageButton;
//STRIP001 	PushButton			m_aNextPageButton;
//STRIP001 	OKButton			m_aFinishButton;
//STRIP001 	SdDocPreviewWin		m_aPreview;
//STRIP001 
//STRIP001 	// Seite 1
//STRIP001 	FixedBitmap*		m_pPage1FB;
//STRIP001 	FixedLine*			m_pPage1ArtFL;
//STRIP001 	RadioButton*		m_pPage1EmptyRB;
//STRIP001 	RadioButton*		m_pPage1TemplateRB;
//STRIP001 	ListBox*			m_pPage1RegionLB;
//STRIP001 	ListBox*			m_pPage1TemplateLB;
//STRIP001 	RadioButton*		m_pPage1OpenRB;
//STRIP001 	ListBox*			m_pPage1OpenLB;
//STRIP001 
//STRIP001 	// Seite 2
//STRIP001 	FixedBitmap*		m_pPage2FB;
//STRIP001 	FixedLine*			m_pPage2LayoutFL;
//STRIP001 	ListBox*			m_pPage2RegionLB;
//STRIP001 	ListBox*			m_pPage2LayoutLB;
//STRIP001 	FixedLine*			m_pPage2OutTypesFL;
//STRIP001 	RadioButton*		m_pPage2Medium1RB;
//STRIP001 	RadioButton*		m_pPage2Medium2RB;
//STRIP001 	RadioButton*		m_pPage2Medium3RB;
//STRIP001 	RadioButton*		m_pPage2Medium4RB;
//STRIP001 	RadioButton*		m_pPage2Medium5RB;
//STRIP001 
//STRIP001 	// Seite 3
//STRIP001 	FixedBitmap*		m_pPage3FB;
//STRIP001 	FixedLine*			m_pPage3EffectFL;
//STRIP001 	FixedText*			m_pPage3EffectFT;
//STRIP001 	FadeEffectLB*		m_pPage3EffectLB;
//STRIP001 	FixedText*			m_pPage3SpeedFT;
//STRIP001 	ListBox*			m_pPage3SpeedLB;
//STRIP001 	FixedLine*			m_pPage3PresTypeFL;
//STRIP001 	RadioButton*		m_pPage3PresTypeLiveRB;
//STRIP001 	RadioButton*		m_pPage3PresTypeKioskRB;
//STRIP001 	FixedText*			m_pPage3PresTimeFT;
//STRIP001 	TimeField*			m_pPage3PresTimeTMF;
//STRIP001 	FixedText*			m_pPage3BreakFT;
//STRIP001 	TimeField*			m_pPage3BreakTMF;
//STRIP001 	CheckBox*			m_pPage3LogoCB;
//STRIP001 
//STRIP001 	// Seite 4
//STRIP001 	FixedBitmap*		m_pPage4FB;
//STRIP001 	FixedLine*			m_pPage4PersonalFL;
//STRIP001 	FixedText*			m_pPage4AskNameFT;
//STRIP001 	Edit*				m_pPage4AskNameEDT;
//STRIP001 	FixedText*			m_pPage4AskTopicFT;
//STRIP001 	Edit*				m_pPage4AskTopicEDT;
//STRIP001 	FixedText*			m_pPage4AskInfoFT;
//STRIP001 	MultiLineEdit*		m_pPage4AskInfoEDT;
//STRIP001 
//STRIP001 	// Seite 5
//STRIP001 	FixedBitmap*		m_pPage5FB;
//STRIP001 	FixedText*			m_pPage5PageListFT;
//STRIP001 	SdPageListControl*	m_pPage5PageListCT;
//STRIP001 	CheckBox*			m_pPage5SummaryCB;
//STRIP001 
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 // ====================================================================
//STRIP001 
//STRIP001 AssistentDlgImpl::AssistentDlgImpl( Window* pWindow, const Link& rFinishLink, BOOL bAutoPilot ) :
//STRIP001 	m_aFinishButton(pWindow,SdResId(BUT_FINISH)),
//STRIP001 	m_aHelpButton(pWindow,SdResId(BUT_HELP)),
//STRIP001 	m_aCancelButton(pWindow,SdResId(BUT_CANCEL)),
//STRIP001 	m_aNextPageButton(pWindow,SdResId(BUT_NEXT)),
//STRIP001 	m_aLastPageButton(pWindow,SdResId(BUT_LAST)),
//STRIP001 	m_aPreviewFlag(pWindow,SdResId(CB_PREVIEW)),
//STRIP001 	m_aPreview(pWindow,SdResId(CT_PREVIEW)),
//STRIP001 	m_aStartWithFlag(pWindow,SdResId(CB_STARTWITH)),
//STRIP001 //	m_aBitmap(pWindow,SdResId(PAGE1_BMP)),
//STRIP001 	m_pTemplateRegion(NULL),
//STRIP001 	m_pLayoutRegion(NULL),
//STRIP001 	m_bPreview(TRUE),
//STRIP001 	m_bDocPreview(FALSE),
//STRIP001 	m_nShowPage(0),
//STRIP001 //	m_aPageListFile('?'),
//STRIP001 	m_bUserDataDirty(FALSE),
//STRIP001 	m_aAssistentFunc(5),
//STRIP001 	xDocShell (NULL),
//STRIP001     mpWindowUpdater (new WindowUpdater())
//STRIP001 {
//STRIP001 	m_aPageListFile += sal_Unicode('?'),
//STRIP001     m_bRecentDocumentsReady = FALSE;
//STRIP001 	m_bTemplatesReady = FALSE;
//STRIP001     m_bPreviewUpdating = FALSE;
//STRIP001 
//STRIP001 	m_pWindow = pWindow;
//STRIP001 
//STRIP001 	if(bAutoPilot)
//STRIP001 		m_aStartWithFlag.Hide();
//STRIP001 	else
//STRIP001 		m_aAssistentFunc.InsertControl(1, &m_aStartWithFlag );
//STRIP001 
//STRIP001 	//page1 wird initialisiert und an die Assistentenfunktionalitaet
//STRIP001 	//uebergeben
//STRIP001 	m_aAssistentFunc.InsertControl(1, &m_aPreview );
//STRIP001 	m_aAssistentFunc.InsertControl(1, &m_aPreviewFlag );
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1FB = new FixedBitmap(pWindow,SdResId(FB_PAGE1)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1ArtFL = new FixedLine(pWindow,SdResId(FL_PAGE1_ARTGROUP)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1EmptyRB=new RadioButton(pWindow,SdResId(RB_PAGE1_EMPTY)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1TemplateRB=new RadioButton(pWindow,SdResId(RB_PAGE1_TEMPLATE)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1OpenRB=new RadioButton(pWindow,SdResId(RB_PAGE1_OPEN)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1RegionLB = new ListBox(pWindow,SdResId(LB_PAGE1_REGION)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1TemplateLB=new ListBox(pWindow,SdResId(LB_PAGE1_TEMPLATES)));
//STRIP001 	m_aAssistentFunc.InsertControl(1,
//STRIP001 		m_pPage1OpenLB=new ListBox(pWindow,SdResId(LB_PAGE1_OPEN)));
//STRIP001 
//STRIP001 	// links&handler
//STRIP001 	m_pPage1RegionLB->SetSelectHdl(LINK(this,AssistentDlgImpl,SelectRegionHdl));
//STRIP001 	m_pPage1RegionLB->SetDropDownLineCount( 6 );
//STRIP001 	m_pPage1TemplateLB->SetSelectHdl(LINK(this,AssistentDlgImpl,SelectTemplateHdl));
//STRIP001 	m_pPage1TemplateLB->InsertEntry(String(SdResId(STR_ISLOADING)));
//STRIP001 
//STRIP001 	m_pPage1EmptyRB->SetClickHdl(LINK(this,AssistentDlgImpl,StartTypeHdl));
//STRIP001 	m_pPage1TemplateRB->SetClickHdl(LINK(this,AssistentDlgImpl,StartTypeHdl));
//STRIP001 	m_pPage1OpenRB->SetClickHdl(LINK(this,AssistentDlgImpl,StartTypeHdl));
//STRIP001 	m_pPage1OpenLB->SetSelectHdl(LINK(this,AssistentDlgImpl,SelectFileHdl));
//STRIP001 	m_pPage1OpenLB->SetDoubleClickHdl(rFinishLink);
//STRIP001 	m_pPage1OpenLB->InsertEntry(String(SdResId(STR_WIZARD_POSITION)));
//STRIP001 
//STRIP001 	// Seite 2
//STRIP001 	m_aAssistentFunc.InsertControl(2, &m_aPreview );
//STRIP001 	m_aAssistentFunc.InsertControl(2, &m_aPreviewFlag );
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2FB = new FixedBitmap(pWindow,SdResId(FB_PAGE2)));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2LayoutFL = new FixedLine( pWindow, SdResId(FL_PAGE2_LAYOUT) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2RegionLB = new ListBox(pWindow,SdResId(LB_PAGE2_REGION) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2LayoutLB = new ListBox(pWindow,SdResId(LB_PAGE2_LAYOUT) ));
//STRIP001 
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2OutTypesFL = new FixedLine( pWindow, SdResId(FL_PAGE2_OUTPUTTYPES) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2Medium5RB = new RadioButton( pWindow, SdResId(RB_PAGE2_MEDIUM5) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2Medium3RB = new RadioButton( pWindow, SdResId(RB_PAGE2_MEDIUM3) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2Medium4RB = new RadioButton( pWindow, SdResId(RB_PAGE2_MEDIUM4) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2Medium1RB = new RadioButton( pWindow, SdResId(RB_PAGE2_MEDIUM1) ));
//STRIP001 	m_aAssistentFunc.InsertControl(2,
//STRIP001 		m_pPage2Medium2RB = new RadioButton( pWindow, SdResId(RB_PAGE2_MEDIUM2) ));
//STRIP001 	m_pPage2Medium5RB->Check();
//STRIP001 
//STRIP001 	m_pPage2RegionLB->SetSelectHdl(LINK(this,AssistentDlgImpl,SelectRegionHdl));
//STRIP001 	m_pPage2RegionLB->SetDropDownLineCount( 6 );
//STRIP001 	m_pPage2LayoutLB->SetSelectHdl(LINK(this,AssistentDlgImpl,SelectLayoutHdl));
//STRIP001 	m_pPage2LayoutLB->InsertEntry(String(SdResId(STR_ISLOADING)));
//STRIP001 
//STRIP001 	// Seite 3
//STRIP001 	m_aAssistentFunc.InsertControl(3, &m_aPreview );
//STRIP001 	m_aAssistentFunc.InsertControl(3, &m_aPreviewFlag );
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3FB = new FixedBitmap(pWindow,SdResId(FB_PAGE3)));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3EffectFL = new FixedLine( pWindow, SdResId(FL_PAGE3_EFFECT) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3EffectFT = new FixedText( pWindow, SdResId(FT_PAGE3_EFFECT) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3EffectLB = new FadeEffectLB( pWindow, SdResId(LB_PAGE3_EFFECT) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3SpeedFT = new FixedText( pWindow, SdResId(FT_PAGE3_SPEED) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3SpeedLB = new FadeEffectLB( pWindow, SdResId(LB_PAGE3_SPEED) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3PresTypeFL = new FixedLine( pWindow, SdResId(FL_PAGE3_PRESTYPE) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3PresTypeLiveRB = new RadioButton( pWindow, SdResId(RB_PAGE3_LIVE) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3PresTypeKioskRB = new RadioButton( pWindow, SdResId(RB_PAGE3_KIOSK) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3PresTimeFT = new FixedText( pWindow, SdResId( FT_PAGE3_TIME) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3PresTimeTMF = new TimeField( pWindow, SdResId( TMF_PAGE3_TIME) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3BreakFT = new FixedText( pWindow, SdResId( FT_PAGE3_BREAK) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3BreakTMF = new TimeField( pWindow, SdResId( TMF_PAGE3_BREAK) ));
//STRIP001 	m_aAssistentFunc.InsertControl(3,
//STRIP001 		m_pPage3LogoCB = new CheckBox( pWindow, SdResId( CB_PAGE3_LOGO) ));
//STRIP001 
//STRIP001 	m_pPage3EffectLB->Fill();
//STRIP001 	m_pPage3EffectLB->SelectEffect( presentation::FadeEffect_NONE );
//STRIP001 	m_pPage3EffectLB->SetSelectHdl( LINK(this,AssistentDlgImpl,SelectEffectHdl ));
//STRIP001 	m_pPage3EffectLB->SetDropDownLineCount( 12 );
//STRIP001 
//STRIP001 	m_pPage3SpeedLB->InsertEntry( String( SdResId(STR_SLOW) ));
//STRIP001 	m_pPage3SpeedLB->InsertEntry( String( SdResId(STR_MEDIUM) ));
//STRIP001 	m_pPage3SpeedLB->InsertEntry( String( SdResId(STR_FAST) ));
//STRIP001 	m_pPage3SpeedLB->SetDropDownLineCount( 3 );
//STRIP001 	m_pPage3SpeedLB->SetSelectHdl( LINK(this,AssistentDlgImpl,SelectEffectHdl ));
//STRIP001 	m_pPage3SpeedLB->SelectEntryPos( 1 );
//STRIP001 
//STRIP001 	m_pPage3PresTypeLiveRB->Check();
//STRIP001 	m_pPage3PresTypeLiveRB->SetClickHdl( LINK(this,AssistentDlgImpl, PresTypeHdl ));
//STRIP001 	m_pPage3PresTypeKioskRB->SetClickHdl( LINK(this,AssistentDlgImpl, PresTypeHdl ));
//STRIP001 	m_pPage3PresTimeTMF->SetFormat( TIMEF_SEC );
//STRIP001 	m_pPage3PresTimeTMF->SetTime( Time( 0, 0, 10 ) );
//STRIP001 	m_pPage3BreakTMF->SetFormat( TIMEF_SEC );
//STRIP001 	m_pPage3BreakTMF->SetTime( Time( 0, 0, 10 ) );
//STRIP001 	m_pPage3LogoCB->Check();
//STRIP001 
//STRIP001 	// set cursor in timefield
//STRIP001 	Edit *pEditPage3PresTimeTMF = m_pPage3PresTimeTMF->GetField();
//STRIP001 	Edit *pEditPage3BreakTMF = m_pPage3BreakTMF->GetField();
//STRIP001 	Selection aSel1( pEditPage3PresTimeTMF->GetMaxTextLen(), pEditPage3PresTimeTMF->GetMaxTextLen() );
//STRIP001 	Selection aSel2( pEditPage3BreakTMF->GetMaxTextLen(), pEditPage3BreakTMF->GetMaxTextLen() );
//STRIP001 	pEditPage3PresTimeTMF->SetSelection( aSel1 );
//STRIP001 	pEditPage3BreakTMF->SetSelection( aSel2 );
//STRIP001 
//STRIP001 	// Seite 4
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4FB = new FixedBitmap(pWindow,SdResId(FB_PAGE4)));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4PersonalFL = new FixedLine( pWindow, SdResId(FL_PAGE4_PERSONAL) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskNameFT   = new FixedText( pWindow, SdResId(FT_PAGE4_ASKNAME) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskNameEDT  = new Edit( pWindow, SdResId(EDT_PAGE4_ASKNAME) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskTopicFT= new FixedText( pWindow, SdResId(FT_PAGE4_ASKTOPIC) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskTopicEDT = new Edit( pWindow, SdResId(EDT_PAGE4_ASKTOPIC) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskInfoFT   = new FixedText( pWindow, SdResId(FT_PAGE4_ASKINFORMATION) ));
//STRIP001 	m_aAssistentFunc.InsertControl(4,
//STRIP001 		m_pPage4AskInfoEDT  = new MultiLineEdit( pWindow, SdResId(EDT_PAGE4_ASKINFORMATION) ));
//STRIP001 
//STRIP001 	m_pPage4AskNameEDT->SetModifyHdl(LINK(this,AssistentDlgImpl,UpdateUserDataHdl));
//STRIP001 	m_pPage4AskTopicEDT->SetModifyHdl(LINK(this,AssistentDlgImpl,UpdateUserDataHdl));
//STRIP001 	m_pPage4AskInfoEDT->SetModifyHdl(LINK(this,AssistentDlgImpl,UpdateUserDataHdl));
//STRIP001 
//STRIP001 	// page 5
//STRIP001 	m_aAssistentFunc.InsertControl(5, &m_aPreview );
//STRIP001 	m_aAssistentFunc.InsertControl(5, &m_aPreviewFlag );
//STRIP001 	m_aAssistentFunc.InsertControl(5,
//STRIP001 		m_pPage5FB = new FixedBitmap(pWindow,SdResId(FB_PAGE5)));
//STRIP001 	m_aAssistentFunc.InsertControl(5,
//STRIP001 		m_pPage5PageListFT = new FixedText( pWindow, SdResId( FT_PAGE5_PAGELIST ) ));
//STRIP001 	m_aAssistentFunc.InsertControl(5,
//STRIP001 		m_pPage5PageListCT = new SdPageListControl( pWindow, SdResId( CT_PAGE5_PAGELIST ) ));
//STRIP001 	m_aAssistentFunc.InsertControl(5,
//STRIP001 		m_pPage5SummaryCB  = new CheckBox( pWindow, SdResId( CB_PAGE5_SUMMARY ) ));
//STRIP001 
//STRIP001 	m_pPage5PageListCT->SetSelectHdl(LINK(this,AssistentDlgImpl, PageSelectHdl));
//STRIP001 
//STRIP001 	// generell
//STRIP001 	if( !SfxApplication::IsPlugin() )
//STRIP001 	{
//STRIP001 		InterpolateFixedBitmap( m_pPage1FB );
//STRIP001 		InterpolateFixedBitmap( m_pPage2FB );
//STRIP001 		InterpolateFixedBitmap( m_pPage3FB );
//STRIP001 		InterpolateFixedBitmap( m_pPage4FB );
//STRIP001 		InterpolateFixedBitmap( m_pPage5FB );
//STRIP001 	}
//STRIP001 
//STRIP001 	m_aLastPageButton.SetClickHdl(LINK(this,AssistentDlgImpl, LastPageHdl ));
//STRIP001 	m_aNextPageButton.SetClickHdl(LINK(this,AssistentDlgImpl, NextPageHdl ));
//STRIP001 	m_aPreviewFlag.Check( m_bPreview );
//STRIP001 	m_aPreviewFlag.SetClickHdl(LINK(this, AssistentDlgImpl, PreviewFlagHdl ));
//STRIP001 	m_aPreview.SetClickHdl(LINK(this,AssistentDlgImpl, EffectPreviewHdl ));
//STRIP001 
//STRIP001 	//setzt die Ausgangsseite
//STRIP001 	m_aAssistentFunc.GotoPage(1);
//STRIP001 	m_aLastPageButton.Disable();
//STRIP001 
//STRIP001 	m_aPrevTimer.SetTimeout( 200 );
//STRIP001 	m_aPrevTimer.SetTimeoutHdl( LINK( this, AssistentDlgImpl, UpdatePreviewHdl));
//STRIP001 
//STRIP001 	m_aEffectPrevTimer.SetTimeout( 50 );
//STRIP001 	m_aEffectPrevTimer.SetTimeoutHdl( LINK( this, AssistentDlgImpl, EffectPreviewHdl ));
//STRIP001 
//STRIP001 	m_aUpdatePageListTimer.SetTimeout( 50 );
//STRIP001 	m_aUpdatePageListTimer.SetTimeoutHdl( LINK( this, AssistentDlgImpl, UpdatePageListHdl));
//STRIP001 
//STRIP001 	SetStartType( ST_EMPTY );
//STRIP001 
//STRIP001 	ChangePage();
//STRIP001 
//STRIP001     mpWindowUpdater->RegisterWindow (&m_aPreview);
//STRIP001 
//STRIP001 	UpdatePreview( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 AssistentDlgImpl::~AssistentDlgImpl()
//STRIP001 {
//STRIP001 	CloseDocShell();
//STRIP001 
//STRIP001 	DeletePassords();
//STRIP001 
//STRIP001 	//	Delete the template file infos.
//STRIP001 	std::vector<TemplateDir*>::iterator	I;
//STRIP001 	std::vector<TemplateEntry*>::iterator	J;
//STRIP001 	for (I=m_aPresentList.begin(); I!=m_aPresentList.end(); I++)
//STRIP001 	{
//STRIP001 		for (J=(*I)->m_aEntries.begin(); J!=(*I)->m_aEntries.end(); J++)
//STRIP001 			delete (*J);
//STRIP001 		delete (*I);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Seite 1
//STRIP001 	delete m_pPage1FB;
//STRIP001 	delete m_pPage1ArtFL;
//STRIP001 	delete m_pPage1EmptyRB;
//STRIP001 	delete m_pPage1TemplateRB;
//STRIP001 	delete m_pPage1TemplateLB;
//STRIP001 	delete m_pPage1RegionLB;
//STRIP001 	delete m_pPage1OpenRB;
//STRIP001 	delete m_pPage1OpenLB;
//STRIP001 
//STRIP001 	// Seite 2
//STRIP001 	delete m_pPage2FB;
//STRIP001 	delete m_pPage2LayoutFL;
//STRIP001 	delete m_pPage2RegionLB;
//STRIP001 	delete m_pPage2LayoutLB;
//STRIP001 	delete m_pPage2OutTypesFL;
//STRIP001 	delete m_pPage2Medium1RB;
//STRIP001 	delete m_pPage2Medium2RB;
//STRIP001 	delete m_pPage2Medium3RB;
//STRIP001 	delete m_pPage2Medium4RB;
//STRIP001 	delete m_pPage2Medium5RB;
//STRIP001 
//STRIP001 	// Seite 3
//STRIP001 	delete m_pPage3FB;
//STRIP001 	delete m_pPage3EffectFL;
//STRIP001 	delete m_pPage3EffectFT;
//STRIP001 	delete m_pPage3EffectLB;
//STRIP001 	delete m_pPage3SpeedFT;
//STRIP001 	delete m_pPage3SpeedLB;
//STRIP001 	delete m_pPage3PresTypeFL;
//STRIP001 	delete m_pPage3PresTypeLiveRB;
//STRIP001 	delete m_pPage3PresTypeKioskRB;
//STRIP001 	delete m_pPage3PresTimeFT;
//STRIP001 	delete m_pPage3PresTimeTMF;
//STRIP001 	delete m_pPage3BreakFT;
//STRIP001 	delete m_pPage3BreakTMF;
//STRIP001 	delete m_pPage3LogoCB;
//STRIP001 
//STRIP001 	// Seite 4
//STRIP001 	delete m_pPage4FB;
//STRIP001 	delete m_pPage4PersonalFL;
//STRIP001 	delete m_pPage4AskNameFT;
//STRIP001 	delete m_pPage4AskNameEDT;
//STRIP001 	delete m_pPage4AskTopicFT;
//STRIP001 	delete m_pPage4AskTopicEDT;
//STRIP001 	delete m_pPage4AskInfoFT;
//STRIP001 	delete m_pPage4AskInfoEDT;
//STRIP001 
//STRIP001 	// Seite 5
//STRIP001 	delete m_pPage5FB;
//STRIP001 	delete m_pPage5PageListFT;
//STRIP001 	delete m_pPage5PageListCT;
//STRIP001 	delete m_pPage5SummaryCB;
//STRIP001 
//STRIP001 	//	Delete the file history list.
//STRIP001 	std::vector<String*>::iterator	I2;
//STRIP001 	for (I2=m_aOpenFilesList.begin(); I2!=m_aOpenFilesList.end(); I2++)
//STRIP001 		delete *I2;
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::CloseDocShell()
//STRIP001 {
//STRIP001 	if(xDocShell.Is())
//STRIP001 	{
//STRIP001 		//uno::Reference< lang::XComponent > xModel( xDocShell->GetModel(), uno::UNO_QUERY );
//STRIP001 		uno::Reference< util::XCloseable > xCloseable( xDocShell->GetModel(), uno::UNO_QUERY );
//STRIP001 		//if( xModel.is() )
//STRIP001 		if( xCloseable.is() )
//STRIP001 		{
//STRIP001 			xCloseable->close( sal_True );
//STRIP001 			xDocShell = NULL;
//STRIP001 			//xModel->dispose();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			xDocShell->DoClose();
//STRIP001 			xDocShell = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::EndDialog( long nResult )
//STRIP001 {
//STRIP001 	m_pWindow = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void	AssistentDlgImpl::ScanDocmenu	(void)
//STRIP001 {
//STRIP001     if( m_bRecentDocumentsReady )
//STRIP001         return;
//STRIP001 
//STRIP001 	uno::Sequence<uno::Sequence<beans::PropertyValue> > aHistory =
//STRIP001 		SvtHistoryOptions().GetList (ePICKLIST);
//STRIP001 
//STRIP001     uno::Reference< lang::XMultiServiceFactory > xFactory( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001     uno::Reference< container::XNameAccess > xFilterFactory( xFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.FilterFactory" ) ) ), uno::UNO_QUERY );
//STRIP001 
//STRIP001 	sal_uInt32 nCount = aHistory.getLength();
//STRIP001 	for (sal_uInt32 nItem=0; nItem<nCount; ++nItem)
//STRIP001 	{
//STRIP001 		//	Get the current history item's properties.
//STRIP001 		uno::Sequence<beans::PropertyValue> aPropertySet = aHistory[nItem];
//STRIP001 		::rtl::OUString	sURL;
//STRIP001 		::rtl::OUString	sFilter;
//STRIP001 		::rtl::OUString	sTitle;
//STRIP001 		::rtl::OUString	sPassword;
//STRIP001 		sal_uInt32 nPropertyCount = aPropertySet.getLength();
//STRIP001 		for (sal_uInt32 nProperty=0; nProperty<nPropertyCount; ++nProperty)
//STRIP001 			if (aPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_URL)
//STRIP001 				aPropertySet[nProperty].Value >>= sURL;
//STRIP001 			else if (aPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_FILTER)
//STRIP001 				aPropertySet[nProperty].Value >>= sFilter;
//STRIP001 			else if (aPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_TITLE)
//STRIP001 				aPropertySet[nProperty].Value >>= sTitle;
//STRIP001 			else if (aPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_PASSWORD)
//STRIP001 				aPropertySet[nProperty].Value >>= sPassword;
//STRIP001 
//STRIP001 		//	If the entry is an impress file then insert it into the
//STRIP001 		//	history list and the list box.
//STRIP001         uno::Any aFilterPropSet = xFilterFactory->getByName( sFilter );
//STRIP001         uno::Sequence< beans::PropertyValue > lProps;
//STRIP001         aFilterPropSet >>= lProps;
//STRIP001 
//STRIP001         sal_Int32 nCount = lProps.getLength();
//STRIP001         ::rtl::OUString sFactoryName;
//STRIP001         for( sal_Int32 i=0; i<nCount; ++i )
//STRIP001         {
//STRIP001             if( lProps[i].Name.compareToAscii( "DocumentService" ) == 0 &&
//STRIP001                 (lProps[i].Value >>= sFactoryName) &&
//STRIP001                 sFactoryName.compareToAscii( "com.sun.star.presentation.PresentationDocument" ) == 0 )
//STRIP001             {
//STRIP001                 // yes, it's an impress document
//STRIP001                 INetURLObject aURL;
//STRIP001                 aURL.SetSmartURL (sURL);
//STRIP001                 aURL.SetPass (sPassword);
//STRIP001                 m_aOpenFilesList.push_back (new String (aURL.GetMainURL( INetURLObject::NO_DECODE )));
//STRIP001                 m_pPage1OpenLB->InsertEntry (sTitle);
//STRIP001                 break;
//STRIP001             }
//STRIP001 		}
//STRIP001 	}
//STRIP001     m_bRecentDocumentsReady = TRUE;
//STRIP001     try
//STRIP001     {
//STRIP001         UpdatePreview(TRUE);
//STRIP001     }
//STRIP001     catch (uno::RuntimeException& e)
//STRIP001     {
//STRIP001         // Ignore all exceptions.
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void AssistentDlgImpl::ProvideTemplates (void)
//STRIP001 {
//STRIP001     if ( ! m_bTemplatesReady)
//STRIP001     {
//STRIP001         TemplateScanner aScanner;
//STRIP001         aScanner.Scan ();
//STRIP001         TemplateScanDone (aScanner.GetFolderList());
//STRIP001 
//STRIP001         try
//STRIP001         {
//STRIP001             UpdatePreview(TRUE);
//STRIP001         }
//STRIP001         catch (uno::RuntimeException& e)
//STRIP001         {
//STRIP001             // Ignore all exceptions.
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::TemplateScanDone (
//STRIP001     std::vector<TemplateDir*>& rTemplateFolder)
//STRIP001 {
//STRIP001 	//	This method is called from a thread.  Therefore we get the solar mutex.
//STRIP001 	::vos::OGuard aGuard (Application::GetSolarMutex());
//STRIP001 
//STRIP001     // Copy the contents of the given template folders to a local list.
//STRIP001     m_aPresentList.swap (rTemplateFolder);
//STRIP001 
//STRIP001 	//	Fill in the list box on the first page.
//STRIP001 	int nFirstEntry = 0;
//STRIP001 	m_pPage1RegionLB->Clear();
//STRIP001 	std::vector<TemplateDir*>::iterator	I;
//STRIP001 	int	i;
//STRIP001 	for (i=0,I=m_aPresentList.begin(); I!=m_aPresentList.end(); I++,i++)
//STRIP001 	{
//STRIP001 		TemplateDir * pDir = *I;
//STRIP001 		//HACK! presnt directory is always initially selected.
//STRIP001 		if (pDir->m_aUrl.SearchAscii ("presnt") != STRING_NOTFOUND)
//STRIP001 			nFirstEntry = i;
//STRIP001 
//STRIP001 		m_pPage1RegionLB->InsertEntry (pDir->m_aRegion);
//STRIP001 	}
//STRIP001 	m_pPage1RegionLB->SelectEntryPos (nFirstEntry);
//STRIP001 	m_pPage1RegionLB->Update();
//STRIP001 	SelectTemplateRegion (m_pPage1RegionLB->GetSelectEntry());
//STRIP001 
//STRIP001 	//	Fill in the list box on the second page.
//STRIP001 	nFirstEntry = 0;
//STRIP001 	m_pPage2RegionLB->Clear();
//STRIP001 	for (i=0,I=m_aPresentList.begin(); I!=m_aPresentList.end(); I++,i++)
//STRIP001 	{
//STRIP001 		TemplateDir * pDir = *I;
//STRIP001 		//HACK! layout directory is always initially selected.
//STRIP001 		if (pDir->m_aUrl.SearchAscii ("layout") != STRING_NOTFOUND)
//STRIP001 			nFirstEntry = i;
//STRIP001 
//STRIP001 		m_pPage2RegionLB->InsertEntry (pDir->m_aRegion);
//STRIP001 	}
//STRIP001 	m_pPage2RegionLB->SelectEntryPos (nFirstEntry);
//STRIP001 	m_pPage2RegionLB->Update();
//STRIP001 	SelectLayoutRegion (m_pPage2RegionLB->GetSelectEntry());
//STRIP001 
//STRIP001 	//	Make the changes visible.
//STRIP001 	m_bTemplatesReady = TRUE;
//STRIP001 	if (m_pWindow)
//STRIP001 		UpdatePage();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 // ********************************************************************
//STRIP001 // Status Methoden
//STRIP001 // ********************************************************************
//STRIP001 
//STRIP001 void AssistentDlgImpl::SetStartType( StartType eType )
//STRIP001 {
//STRIP001 	m_pPage1EmptyRB->SetState( eType == ST_EMPTY );
//STRIP001 	m_pPage1TemplateRB->SetState( eType == ST_TEMPLATE );
//STRIP001 	m_pPage1OpenRB->SetState( eType == ST_OPEN );
//STRIP001 	m_aNextPageButton.Enable( eType != ST_OPEN );
//STRIP001 
//STRIP001 	m_pPage1RegionLB->Show(eType == ST_TEMPLATE);
//STRIP001 	m_pPage1TemplateLB->Show(eType == ST_TEMPLATE);
//STRIP001 	m_pPage1OpenLB->Show(eType == ST_OPEN);
//STRIP001 }
//STRIP001 
//STRIP001 StartType AssistentDlgImpl::GetStartType()
//STRIP001 {
//STRIP001 	if( m_pPage1EmptyRB->IsChecked() )
//STRIP001 		return ST_EMPTY;
//STRIP001 	else if( m_pPage1TemplateRB->IsChecked() )
//STRIP001 		return ST_TEMPLATE;
//STRIP001 	else
//STRIP001 		return ST_OPEN;
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlgImpl::GetDocFileName()
//STRIP001 {
//STRIP001 	String aTitle;
//STRIP001 	if(m_pWindow)
//STRIP001 	{
//STRIP001 		aTitle = m_pWindow->GetText();
//STRIP001 		USHORT nPos = aTitle.Search(sal_Unicode('('));
//STRIP001 		if(nPos != STRING_NOTFOUND)
//STRIP001 			aTitle.Erase( nPos-1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	String aDocFile;
//STRIP001 	if( GetStartType() == ST_TEMPLATE )
//STRIP001 	{
//STRIP001 		const USHORT nEntry = m_pPage1TemplateLB->GetSelectEntryPos();
//STRIP001 		TemplateEntry* pEntry = NULL;
//STRIP001 		if(nEntry != (USHORT)-1)
//STRIP001 			pEntry = m_pTemplateRegion->m_aEntries[nEntry];
//STRIP001 
//STRIP001 		if(pEntry)
//STRIP001 		{
//STRIP001 			aDocFile = pEntry->m_aPath;
//STRIP001 
//STRIP001 			aTitle.AppendAscii( RTL_CONSTASCII_STRINGPARAM(  " (" ) );
//STRIP001 			aTitle.Append( pEntry->m_aTitle );
//STRIP001 			aTitle.Append( sal_Unicode(')') );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( GetStartType() == ST_OPEN )
//STRIP001 	{
//STRIP001 		const USHORT nEntry = m_pPage1OpenLB->GetSelectEntryPos();
//STRIP001 		if(nEntry != (USHORT)-1 && nEntry > 0)
//STRIP001 			aDocFile = *m_aOpenFilesList[nEntry-1];
//STRIP001 	}
//STRIP001 
//STRIP001 	if(m_pWindow)
//STRIP001 		m_pWindow->SetText(aTitle);
//STRIP001 
//STRIP001 	return aDocFile;
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlgImpl::GetLayoutFileName()
//STRIP001 {
//STRIP001 	String aFile;
//STRIP001 	const USHORT nEntry = m_pPage2LayoutLB->GetSelectEntryPos();
//STRIP001 	TemplateEntry* pEntry = NULL;
//STRIP001 	if(nEntry != (USHORT)-1 && nEntry > 0)
//STRIP001 		pEntry = m_pLayoutRegion->m_aEntries[nEntry-1];
//STRIP001 
//STRIP001 	if(pEntry)
//STRIP001 		aFile = pEntry->m_aPath;
//STRIP001 
//STRIP001 	return aFile;
//STRIP001 }
//STRIP001 
//STRIP001 SfxObjectShellLock AssistentDlgImpl::GetDocument()
//STRIP001 {
//STRIP001 //	m_bPreview = FALSE;		// Document nicht anzeigen
//STRIP001 	UpdatePreview(FALSE);	// aber komplett laden
//STRIP001 	UpdatePageList();
//STRIP001 
//STRIP001 	SfxObjectShell* pShell = xDocShell;
//STRIP001 	SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 	SdDrawDocument* pDoc = pDocShell?pDocShell->GetDoc():NULL;
//STRIP001 
//STRIP001 	if(pDoc)
//STRIP001 	{
//STRIP001 		const USHORT nPageCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		BOOL bKiosk = m_pPage3PresTypeKioskRB->IsChecked();
//STRIP001 		UINT32 nNewTime = (UINT32)m_pPage3PresTimeTMF->GetTime().GetMSFromTime() / 1000;
//STRIP001 		if(bKiosk)
//STRIP001 		{
//STRIP001 			pDoc->SetPresEndless(bKiosk);
//STRIP001 			pDoc->SetPresPause( (UINT32)m_pPage3BreakTMF->GetTime().GetMSFromTime() / 1000 );
//STRIP001 			pDoc->SetPresShowLogo( m_pPage3LogoCB->IsChecked() );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nPgAbsNum = 0;
//STRIP001 		USHORT nPgRelNum = 0;
//STRIP001 		while( nPgAbsNum < nPageCount )
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage( nPgRelNum, PK_STANDARD );
//STRIP001 			if( m_pPage5PageListCT->IsPageChecked(nPgAbsNum) )
//STRIP001 			{
//STRIP001 				pPage->SetFadeEffect( m_pPage3EffectLB->GetSelectedEffect() );
//STRIP001 				pPage->SetFadeSpeed( (FadeSpeed)m_pPage3SpeedLB->GetSelectEntryPos() );
//STRIP001 				if(bKiosk)
//STRIP001 				{
//STRIP001 					pPage->SetPresChange( PRESCHANGE_AUTO );
//STRIP001 					pPage->SetTime(nNewTime);
//STRIP001 				}
//STRIP001 				nPgRelNum++;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// diese Seite loeschen
//STRIP001 				pDoc->DeletePage( (nPgRelNum << 1) + 2 ); // Notizseite loeschen
//STRIP001 				pDoc->DeletePage( (nPgRelNum << 1) + 1 );	// Seite loeschen
//STRIP001 			}
//STRIP001 
//STRIP001 			nPgAbsNum++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DBG_ERROR("Keine Vorlage fuer den Autopiloten? [CL]");
//STRIP001 
//STRIP001 	SfxObjectShellLock xRet = xDocShell;
//STRIP001 	xDocShell = NULL;
//STRIP001 
//STRIP001 	return xRet;
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::LeavePage()
//STRIP001 {
//STRIP001 	USHORT nPage = m_aAssistentFunc.GetCurrentPage();
//STRIP001 
//STRIP001 	if( nPage == 4 && m_bUserDataDirty )
//STRIP001 		m_aPrevTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::ChangePage()
//STRIP001 {
//STRIP001 	m_aNextPageButton.Enable(!m_aAssistentFunc.IsLastPage());
//STRIP001 	m_aLastPageButton.Enable(!m_aAssistentFunc.IsFirstPage());
//STRIP001 
//STRIP001 	USHORT nPage = m_aAssistentFunc.GetCurrentPage();
//STRIP001 
//STRIP001 	if( m_pWindow )
//STRIP001 		m_pWindow->SetHelpId( PageHelpIds[nPage-1]);
//STRIP001 
//STRIP001 	UpdatePage();
//STRIP001 
//STRIP001 	if( m_aNextPageButton.IsEnabled() )
//STRIP001 		m_aNextPageButton.GrabFocus();
//STRIP001 	else
//STRIP001 		m_aFinishButton.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::UpdatePage()
//STRIP001 {
//STRIP001 	USHORT nPage = m_aAssistentFunc.GetCurrentPage();
//STRIP001 
//STRIP001 	switch(nPage)
//STRIP001 	{
//STRIP001 	case 1:
//STRIP001 		{
//STRIP001 			// Elemente auf der ersten Seite abhaengig vom Starttype Zeigen
//STRIP001 			SetStartType( GetStartType() );
//STRIP001 			m_pPage1TemplateRB->Enable(TRUE /*m_bTemplatesReady*/);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	case 2:
//STRIP001 		{
//STRIP001 			m_pPage2RegionLB->Enable(m_bTemplatesReady);
//STRIP001 			m_pPage2LayoutLB->Enable(m_bTemplatesReady);
//STRIP001 
//STRIP001 			if( GetStartType() != ST_EMPTY )
//STRIP001 			{
//STRIP001 				m_pPage2Medium5RB->Enable( TRUE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				m_pPage2Medium5RB->Enable( FALSE );
//STRIP001 				if(m_pPage2Medium5RB->IsChecked())
//STRIP001 					m_pPage2Medium1RB->Check();
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	case 5:
//STRIP001 		{
//STRIP001 			if(m_bDocPreview || m_aPageListFile != m_aDocFile)
//STRIP001 				m_pPage5PageListCT->Clear();
//STRIP001 
//STRIP001 			m_aUpdatePageListTimer.Start();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	case 3:
//STRIP001 		{
//STRIP001 			if(GetStartType() != ST_TEMPLATE)
//STRIP001 				m_aNextPageButton.Disable();
//STRIP001 
//STRIP001 			BOOL bKiosk = m_pPage3PresTypeKioskRB->IsChecked();
//STRIP001 			m_pPage3PresTimeFT->Enable(bKiosk);
//STRIP001 			m_pPage3BreakFT->Enable(bKiosk);
//STRIP001 			m_pPage3PresTimeTMF->Enable(bKiosk);
//STRIP001 			m_pPage3BreakTMF->Enable(bKiosk);
//STRIP001 			m_pPage3LogoCB->Enable(bKiosk);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ********************************************************************
//STRIP001 // UI-Handler
//STRIP001 // ********************************************************************
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, SelectRegionHdl, ListBox *, pLB )
//STRIP001 {
//STRIP001 	if( pLB == m_pPage1RegionLB )
//STRIP001 	{
//STRIP001 		SelectTemplateRegion( pLB->GetSelectEntry() );
//STRIP001 		SetStartType( ST_TEMPLATE );
//STRIP001 		m_pPage2Medium5RB->Check();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SelectLayoutRegion( pLB->GetSelectEntry() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, SelectEffectHdl, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	m_aEffectPrevTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, EffectPreviewHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if(m_bPreview && xDocShell.Is() )
//STRIP001 		m_aPreview.ShowEffect( m_pPage3EffectLB->GetSelectedEffect(), (FadeSpeed)m_pPage3SpeedLB->GetSelectEntryPos() );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, PreviewFlagHdl, CheckBox *, EMPTYARG )
//STRIP001 
//STRIP001 {
//STRIP001 	if( m_aPreviewFlag.IsChecked() != m_bPreview )
//STRIP001 	{
//STRIP001 		m_bPreview = m_aPreviewFlag.IsChecked();
//STRIP001 		UpdatePreview(TRUE);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, SelectTemplateHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	SetStartType( ST_TEMPLATE );
//STRIP001 	m_pPage2Medium5RB->Check();
//STRIP001 	m_pPage2LayoutLB->SelectEntryPos(0);
//STRIP001 	m_aPrevTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, SelectLayoutHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	m_aPrevTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, SelectFileHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	SetStartType( ST_OPEN );
//STRIP001 	m_aPrevTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, PageSelectHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPage = m_pPage5PageListCT->GetSelectedPage();
//STRIP001 	if( m_nShowPage != nPage )
//STRIP001 	{
//STRIP001 		m_nShowPage = nPage;
//STRIP001 		UpdatePreview(FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, UpdatePageListHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdatePageList();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, UpdatePreviewHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdatePreview( TRUE );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, StartTypeHdl, RadioButton *, pButton )
//STRIP001 {
//STRIP001 	StartType eType = pButton == m_pPage1EmptyRB?ST_EMPTY:pButton == m_pPage1TemplateRB?ST_TEMPLATE:ST_OPEN;
//STRIP001 
//STRIP001 	if(eType == ST_TEMPLATE)
//STRIP001         ProvideTemplates();
//STRIP001     else if(eType == ST_OPEN)
//STRIP001         ScanDocmenu();
//STRIP001 
//STRIP001 	SetStartType( eType );
//STRIP001 
//STRIP001 	if(eType == ST_TEMPLATE)
//STRIP001 	{
//STRIP001 		m_pPage1TemplateLB->SelectEntryPos(0);
//STRIP001 		m_pPage2Medium5RB->Check();
//STRIP001 	}
//STRIP001 	else if(eType == ST_OPEN)
//STRIP001 		m_pPage1OpenLB->SelectEntryPos(0);
//STRIP001 
//STRIP001 	m_aPrevTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, NextPageHdl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001     // When changing from the first to the second page make sure that the
//STRIP001     // templates are present.
//STRIP001 	if (m_aAssistentFunc.GetCurrentPage() == 1)
//STRIP001         ProvideTemplates();
//STRIP001 
//STRIP001     // Change to the next page.
//STRIP001 	LeavePage();
//STRIP001 	m_aAssistentFunc.NextPage();
//STRIP001 	ChangePage();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, LastPageHdl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	LeavePage();
//STRIP001 	m_aAssistentFunc.PreviousPage();
//STRIP001 	ChangePage();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, PresTypeHdl, RadioButton*, pButton )
//STRIP001 {
//STRIP001 	if(m_aDocFile.Len() == 0)
//STRIP001 		m_aNextPageButton.Disable();
//STRIP001 
//STRIP001 	BOOL bKiosk = m_pPage3PresTypeKioskRB->IsChecked();
//STRIP001 	m_pPage3PresTimeFT->Enable(bKiosk);
//STRIP001 	m_pPage3BreakFT->Enable(bKiosk);
//STRIP001 	m_pPage3PresTimeTMF->Enable(bKiosk);
//STRIP001 	m_pPage3BreakTMF->Enable(bKiosk);
//STRIP001 	m_pPage3LogoCB->Enable(bKiosk);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlgImpl, UpdateUserDataHdl, Edit*, EMPTYARG )
//STRIP001 {
//STRIP001 	m_bUserDataDirty = TRUE;
//STRIP001 	String aTopic = m_pPage4AskTopicEDT->GetText();
//STRIP001 	String aName  = m_pPage4AskNameEDT->GetText();
//STRIP001 	String aInfo  = m_pPage4AskInfoEDT->GetText();
//STRIP001 
//STRIP001 	if(aTopic.Len() == 0 && aName.Len() == 0 && aInfo.Len() == 0)
//STRIP001 		m_aDocFile.Erase();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ********************************************************************
//STRIP001 // ********************************************************************
//STRIP001 
//STRIP001 void AssistentDlgImpl::SelectTemplateRegion( const String& rRegion )
//STRIP001 {
//STRIP001 	m_pPage1TemplateLB->Clear();
//STRIP001 	std::vector<TemplateDir*>::iterator	I;
//STRIP001 	for (I=m_aPresentList.begin(); I!=m_aPresentList.end(); I++)
//STRIP001 	{
//STRIP001 		TemplateDir * pDir = *I;
//STRIP001 		m_pTemplateRegion = *I;
//STRIP001 		if (pDir->m_aRegion.Equals( rRegion ) )
//STRIP001 		{
//STRIP001 			std::vector<TemplateEntry*>::iterator	J;
//STRIP001 			for (J=pDir->m_aEntries.begin(); J!=pDir->m_aEntries.end(); J++)
//STRIP001 				m_pPage1TemplateLB->InsertEntry ((*J)->m_aTitle);
//STRIP001 			m_pPage1TemplateLB->Update();
//STRIP001 			if(GetStartType() == ST_TEMPLATE)
//STRIP001 			{
//STRIP001 				m_pPage1TemplateLB->SelectEntryPos( 0 );
//STRIP001 				SelectTemplateHdl(NULL);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::SelectLayoutRegion( const String& rRegion )
//STRIP001 {
//STRIP001 	m_pPage2LayoutLB->Clear();
//STRIP001 	m_pPage2LayoutLB->InsertEntry(String(SdResId(STR_WIZARD_ORIGINAL)));
//STRIP001 	std::vector<TemplateDir*>::iterator	I;
//STRIP001 	for (I=m_aPresentList.begin(); I!=m_aPresentList.end(); I++)
//STRIP001 	{
//STRIP001 		TemplateDir * pDir = *I;
//STRIP001 		m_pLayoutRegion = *I;
//STRIP001 
//STRIP001 		if (pDir->m_aRegion.Equals (rRegion))
//STRIP001 		{
//STRIP001 			std::vector<TemplateEntry*>::iterator	J;
//STRIP001 			for (J=pDir->m_aEntries.begin(); J!=pDir->m_aEntries.end(); J++)
//STRIP001 				m_pPage2LayoutLB->InsertEntry ((*J)->m_aTitle);
//STRIP001 			m_pPage2LayoutLB->Update();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::UpdateUserData()
//STRIP001 {
//STRIP001 	String aTopic = m_pPage4AskTopicEDT->GetText();
//STRIP001 	String aName  = m_pPage4AskNameEDT->GetText();
//STRIP001 	String aInfo  = m_pPage4AskInfoEDT->GetText();
//STRIP001 
//STRIP001 	SfxObjectShell* pShell = xDocShell;
//STRIP001 	SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 	SdDrawDocument* pDoc = pDocShell?pDocShell->GetDoc():NULL;
//STRIP001 	SdPage* pPage = pDoc?pDoc->GetSdPage(0, PK_STANDARD):NULL;
//STRIP001 
//STRIP001 	if(pPage && ( aTopic.Len() != 0 || aName.Len() != 0 || aInfo.Len() != 0 ) )
//STRIP001 	{
//STRIP001 		if( pPage->GetAutoLayout() == AUTOLAYOUT_NONE )
//STRIP001 			pPage->SetAutoLayout(AUTOLAYOUT_TITLE, TRUE);
//STRIP001 
//STRIP001 		SdrObject* pObj;
//STRIP001 		SdrObjKind eSdrObjKind;
//STRIP001 		String aEmptyString;
//STRIP001 		USHORT nIndex;
//STRIP001 		List* pPresObjList;
//STRIP001 
//STRIP001 		pPresObjList=pPage->GetPresObjList();
//STRIP001 		for(nIndex=0;nIndex<pPresObjList->Count();nIndex++)
//STRIP001 		{
//STRIP001 			pObj=(SdrObject*)pPresObjList->GetObject(nIndex);
//STRIP001 			if (pObj && pObj->GetObjInventor() == SdrInventor)
//STRIP001 			{
//STRIP001 				eSdrObjKind=(SdrObjKind)pObj->GetObjIdentifier();
//STRIP001 				if(eSdrObjKind==OBJ_TITLETEXT)
//STRIP001 				{
//STRIP001 					if ( aTopic.Len() )
//STRIP001 					{
//STRIP001 						pPage->SetObjText( (SdrTextObj*)pObj, NULL, PRESOBJ_TITLE, aTopic );
//STRIP001 						pObj->NbcSetStyleSheet( pPage->GetStyleSheetForPresObj( PRESOBJ_TITLE ), TRUE );
//STRIP001 						pObj->SetEmptyPresObj(FALSE);
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( aName.Len() || aInfo.Len() )
//STRIP001 				{
//STRIP001 					String aStrTmp( aName );
//STRIP001 					aStrTmp.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "\n\n" ) );
//STRIP001 					aStrTmp.Append( aInfo );
//STRIP001 
//STRIP001 					if (eSdrObjKind == OBJ_OUTLINETEXT)
//STRIP001 					{
//STRIP001 						pPage->SetObjText( (SdrTextObj*) pObj, NULL, PRESOBJ_OUTLINE, aStrTmp );
//STRIP001 						pObj->NbcSetStyleSheet( pPage->GetStyleSheetForPresObj( PRESOBJ_OUTLINE ), TRUE );
//STRIP001 						pObj->SetEmptyPresObj(FALSE);
//STRIP001 					}
//STRIP001 					else if (eSdrObjKind == OBJ_TEXT)
//STRIP001 					{
//STRIP001 						pPage->SetObjText( (SdrTextObj*) pObj, NULL, PRESOBJ_TEXT, aStrTmp );
//STRIP001 						pObj->NbcSetStyleSheet( pPage->GetStyleSheetForPresObj( PRESOBJ_TEXT ), TRUE );
//STRIP001 						pObj->SetEmptyPresObj(FALSE);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_bUserDataDirty = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::UpdatePageList()
//STRIP001 {
//STRIP001 	if(m_bDocPreview || !m_bPreview)
//STRIP001 		UpdatePreview(FALSE);
//STRIP001 	else if(m_aPageListFile == m_aDocFile)
//STRIP001 		return;
//STRIP001 
//STRIP001 	m_aPageListFile = m_aDocFile;
//STRIP001 
//STRIP001 	SfxObjectShell* pShell = xDocShell;
//STRIP001 	SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 	SdDrawDocument* pDoc = pDocShell?pDocShell->GetDoc():NULL;
//STRIP001 
//STRIP001 	m_pPage5PageListCT->Clear();
//STRIP001 
//STRIP001 	if(pDoc)
//STRIP001 		m_pPage5PageListCT->Fill(pDoc);
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::UpdatePreview( BOOL bDocPreview )
//STRIP001 {
//STRIP001     // Guard against multiple concurrent execution to this method caused either
//STRIP001     // by calls from different threads or recursion.
//STRIP001     ::osl::MutexGuard aGuard (m_aMutex);
//STRIP001     if (m_bPreviewUpdating)
//STRIP001         return;
//STRIP001     m_bPreviewUpdating = TRUE;
//STRIP001 
//STRIP001 	if(!m_bPreview && bDocPreview)
//STRIP001 	{
//STRIP001 		m_aPreview.Invalidate();
//STRIP001 		m_aPreview.SetObjectShell(0);
//STRIP001         m_bPreviewUpdating = FALSE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	String aDocFile = GetDocFileName();
//STRIP001 	String aLayoutFile = GetLayoutFileName();
//STRIP001 	String aEmptyStr;
//STRIP001 
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	ULONG lErr;
//STRIP001 	BOOL bChangeMaster = aLayoutFile.Len() != 0;
//STRIP001 
//STRIP001 	if( aDocFile.Len() == 0 )
//STRIP001 	{
//STRIP001 		if( !xDocShell.Is() || m_aDocFile.Len() != 0 ||
//STRIP001 			(m_aDocFile.Len() == 0 && m_aLayoutFile.Len() != 0 && aLayoutFile.Len() == 0 ))
//STRIP001 		{
//STRIP001 			CloseDocShell();
//STRIP001 
//STRIP001 			SdDrawDocShell* pNewDocSh;
//STRIP001 			xDocShell = pNewDocSh = new SdDrawDocShell(SFX_CREATE_MODE_STANDARD, FALSE);
//STRIP001 			pNewDocSh->DoInitNew(NULL);
//STRIP001 			SdDrawDocument* pDoc = pNewDocSh->GetDoc();
//STRIP001 			pDoc->CreateFirstPages();
//STRIP001 			pDoc->StopWorkStartupDelay();
//STRIP001 			m_bDocPreview = FALSE;
//STRIP001 
//STRIP001 			m_aDocFile = aDocFile;
//STRIP001 			m_bUserDataDirty = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bChangeMaster = (aLayoutFile.Len() != 0) && (m_aLayoutFile != aLayoutFile);
//STRIP001 	}
//STRIP001 	else if( aDocFile == m_aDocFile && ( m_bDocPreview == bDocPreview || bDocPreview ) )
//STRIP001 	{
//STRIP001 		if( aLayoutFile != m_aLayoutFile )
//STRIP001 		{
//STRIP001 			SfxObjectShell* pShell = xDocShell;
//STRIP001 			SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 			SfxUndoManager* pUndoMgr = pDocShell?pDocShell->GetUndoManager():NULL;
//STRIP001 			if(pUndoMgr)
//STRIP001 				pUndoMgr->Undo();
//STRIP001 			m_bUserDataDirty = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bChangeMaster = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		CloseDocShell();
//STRIP001 
//STRIP001 		Window *pParent = Application::GetDefDialogParent();
//STRIP001 		Application::SetDefDialogParent( m_pWindow );
//STRIP001 
//STRIP001 		SfxErrorContext eEC(ERRCTX_SFX_LOADTEMPLATE,m_pWindow);
//STRIP001 
//STRIP001 		SfxItemSet* pSet = new SfxAllItemSet( pSfxApp->GetPool() );
//STRIP001 		if(IsOwnFormat(aDocFile))
//STRIP001 		{
//STRIP001 			pSet->Put( SfxBoolItem( SID_TEMPLATE, TRUE ) );
//STRIP001 			if(bDocPreview)
//STRIP001 				pSet->Put( SfxBoolItem( SID_PREVIEW, TRUE ) );
//STRIP001 			RestorePassword( pSet, aDocFile );
//STRIP001             if( lErr = pSfxApp->LoadTemplate( xDocShell, aDocFile, TRUE, pSet ) )
//STRIP001 				ErrorHandler::HandleError(lErr);
//STRIP001 			else
//STRIP001 				SavePassword( xDocShell, aDocFile );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxObjectShell* pShell = NULL;
//STRIP001 
//STRIP001 			const String aTargetStr( RTL_CONSTASCII_USTRINGPARAM("_default") );
//STRIP001 
//STRIP001 			SfxRequest aReq( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, SFX_APP()->GetPool() );
//STRIP001 			aReq.AppendItem( SfxStringItem( SID_FILE_NAME, aDocFile ));
//STRIP001 			aReq.AppendItem( SfxStringItem( SID_REFERER, aEmptyStr ) );
//STRIP001 	        aReq.AppendItem( SfxStringItem( SID_TARGETNAME, aTargetStr ) );
//STRIP001 			aReq.AppendItem( SfxBoolItem( SID_VIEW, FALSE ) );
//STRIP001 			aReq.AppendItem( SfxBoolItem( SID_PREVIEW, bDocPreview ) );
//STRIP001 
//STRIP001 			const SfxObjectShellItem* pRet = (SfxObjectShellItem*)
//STRIP001 				SFX_APP()->ExecuteSlot( aReq );
//STRIP001 
//STRIP001 			if( pRet && pRet->GetObjectShell() )
//STRIP001 				xDocShell = pRet->GetObjectShell();
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		Application::SetDefDialogParent( pParent );
//STRIP001 
//STRIP001 		m_nShowPage = 0;
//STRIP001 		m_bDocPreview = bDocPreview;
//STRIP001 		m_aDocFile = aDocFile;
//STRIP001 		m_bUserDataDirty = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(bChangeMaster && (aLayoutFile != m_aDocFile))
//STRIP001 	{
//STRIP001 		// Layoutvorlage laden
//STRIP001 		SfxObjectShellLock xLayoutDocShell;
//STRIP001 		SfxErrorContext eEC(ERRCTX_SFX_LOADTEMPLATE,m_pWindow);
//STRIP001 		SfxItemSet* pSet = new SfxAllItemSet( pSfxApp->GetPool() );
//STRIP001 
//STRIP001 		Window *pParent = Application::GetDefDialogParent();
//STRIP001 		Application::SetDefDialogParent( m_pWindow );
//STRIP001 
//STRIP001 		if(IsOwnFormat(aLayoutFile))
//STRIP001 		{
//STRIP001 			pSet->Put( SfxBoolItem( SID_TEMPLATE, TRUE ) );
//STRIP001 			pSet->Put( SfxBoolItem( SID_PREVIEW, TRUE ) );
//STRIP001 
//STRIP001 			RestorePassword( pSet, aLayoutFile );
//STRIP001             if( lErr = pSfxApp->LoadTemplate( xLayoutDocShell, aLayoutFile, TRUE, pSet ) )
//STRIP001 				ErrorHandler::HandleError(lErr);
//STRIP001 			SavePassword( xLayoutDocShell, aLayoutFile );
//STRIP001 		}
//STRIP001 
//STRIP001 		Application::SetDefDialogParent( pParent );
//STRIP001 
//STRIP001 		// die Implementierung ermitteln
//STRIP001 		SfxObjectShell* pShell = xDocShell;
//STRIP001 		SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 		SdDrawDocument* pDoc = pDocShell?pDocShell->GetDoc():NULL;
//STRIP001 
//STRIP001 		pShell = xLayoutDocShell;
//STRIP001 		pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 		SdDrawDocument* pLayoutDoc = pDocShell?pDocShell->GetDoc():NULL;
//STRIP001 
//STRIP001 		if( pDoc && pLayoutDoc )
//STRIP001 			pDoc->SetMasterPage(0, aEmptyStr, pLayoutDoc, TRUE,  FALSE );
//STRIP001 		else
//STRIP001 			DBG_ERROR("Keine gueltigen Impress Documente fuer die Preview? [CL]");
//STRIP001 		m_bUserDataDirty = TRUE;
//STRIP001 	}
//STRIP001 	m_aLayoutFile = aLayoutFile;
//STRIP001 
//STRIP001 	if(m_bUserDataDirty)
//STRIP001 		UpdateUserData();
//STRIP001 
//STRIP001 	if ( !xDocShell.Is() || !m_bPreview )
//STRIP001 		m_aPreview.SetObjectShell( 0 );
//STRIP001 	else
//STRIP001 		m_aPreview.SetObjectShell( xDocShell, m_nShowPage );
//STRIP001     
//STRIP001     m_bPreviewUpdating = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::SavePassword( SfxObjectShellLock xDoc, const String& rPath )
//STRIP001 {
//STRIP001 	if(xDoc.Is())
//STRIP001 	{
//STRIP001 		SfxMedium * pMedium = xDoc->GetMedium();
//STRIP001 		if(pMedium && pMedium->IsStorage())
//STRIP001 		{
//STRIP001 			SfxItemSet * pSet = pMedium->GetItemSet();
//STRIP001 //		    const SfxPoolItem *pItem = 0;
//STRIP001 //			if( pSet->GetItemState(SID_PASSWORD, TRUE, &pItem) == SFX_ITEM_SET )
//STRIP001 //			{
//STRIP001 //				String aPass( ((const SfxStringItem*)pItem)->GetValue());
//STRIP001 			SvStorage* pStorage = pMedium->GetStorage();
//STRIP001 			if(pStorage)
//STRIP001 			{
//STRIP001 
//STRIP001 				String aPass( pStorage->GetKey(), RTL_TEXTENCODING_ASCII_US );
//STRIP001 
//STRIP001 				if(aPass.Len() == 0)
//STRIP001 					return;
//STRIP001 
//STRIP001 				PasswordEntry* pEntry = m_aPasswordList.First();
//STRIP001 				while(pEntry)
//STRIP001 				{
//STRIP001 					if(pEntry->m_aPath == rPath)
//STRIP001 						break;
//STRIP001 
//STRIP001 					pEntry = m_aPasswordList.Next();
//STRIP001 
//STRIP001 				}
//STRIP001 
//STRIP001 				if(pEntry == NULL)
//STRIP001 				{
//STRIP001 					pEntry = new PasswordEntry();
//STRIP001 					pEntry->m_aPath = rPath;
//STRIP001 					m_aPasswordList.Insert( pEntry );
//STRIP001 				}
//STRIP001 
//STRIP001 				if(pEntry)
//STRIP001 					pEntry->m_aPassword = aPass;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::RestorePassword( SfxItemSet* pSet, const String& rPath )
//STRIP001 {
//STRIP001 	String aPassword( GetPassword( rPath ) );
//STRIP001 
//STRIP001 	if(aPassword.Len())
//STRIP001 		pSet->Put( SfxStringItem( SID_PASSWORD, aPassword ) );
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlgImpl::GetPassword( const String rPath )
//STRIP001 {
//STRIP001 	PasswordEntry* pEntry = m_aPasswordList.First();
//STRIP001 	while(pEntry)
//STRIP001 	{
//STRIP001 		if(pEntry->m_aPath == rPath)
//STRIP001 			return pEntry->m_aPassword;
//STRIP001 
//STRIP001 		pEntry = m_aPasswordList.Next();
//STRIP001 	}
//STRIP001 
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 void AssistentDlgImpl::DeletePassords()
//STRIP001 {
//STRIP001 	PasswordEntry* pEntry = m_aPasswordList.First();
//STRIP001 	while(pEntry)
//STRIP001 	{
//STRIP001 		delete pEntry;
//STRIP001 		pEntry = m_aPasswordList.Next();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 BOOL AssistentDlgImpl::IsOwnFormat( const String& rPath )
//STRIP001 {
//STRIP001 	INetURLObject	aURL( rPath );
//STRIP001 	String			aExt( aURL.GetFileExtension() );
//STRIP001 
//STRIP001 	DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	return !aExt.EqualsIgnoreCaseAscii( "ppt" );
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////
//STRIP001 
//STRIP001 AssistentDlg::AssistentDlg(Window* pParent, BOOL bAutoPilot) :
//STRIP001 	ModalDialog(pParent,SdResId(DLG_ASS))
//STRIP001 {
//STRIP001 	Link aFinishLink = LINK(this,AssistentDlg, FinishHdl);
//STRIP001 	m_pImpl = new AssistentDlgImpl( this, aFinishLink, bAutoPilot );
//STRIP001 
//STRIP001 	//Buttonbelegung
//STRIP001 	m_pImpl->m_aFinishButton.SetClickHdl(LINK(this,AssistentDlg,FinishHdl));
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( AssistentDlg, FinishHdl, OKButton *, EMPTYARG )
//STRIP001 {
//STRIP001     if( GetStartType() == ST_OPEN )
//STRIP001 	{
//STRIP001         //if we do not have a file here asked for one before ending the dialog
//STRIP001         String aFileToOpen = GetDocPath();
//STRIP001 		if(aFileToOpen.Len() == 0)
//STRIP001 		{
//STRIP001             sfx2::FileDialogHelper aFileDlg( WB_OPEN, SdDrawDocShell::Factory() );
//STRIP001             
//STRIP001 			if ( aFileDlg.Execute() == ERRCODE_NONE )
//STRIP001 				aFileToOpen = aFileDlg.GetPath();
//STRIP001             if( aFileToOpen.Len() == 0)
//STRIP001                 return 1;
//STRIP001             else
//STRIP001             {
//STRIP001                 //add the selected file to the recent-file-listbox and select the new entry
//STRIP001                 //this is necessary for 'GetDocPath()' returning the selected file after end of dialog
//STRIP001                 
//STRIP001                 INetURLObject aURL;
//STRIP001                 aURL.SetSmartURL(aFileToOpen);
//STRIP001                 m_pImpl->m_aOpenFilesList.push_back (new String (aURL.GetMainURL( INetURLObject::NO_DECODE )));
//STRIP001                 USHORT nNewPos = m_pImpl->m_pPage1OpenLB->InsertEntry(aURL.getName());
//STRIP001                 m_pImpl->m_pPage1OpenLB->SelectEntryPos(nNewPos);
//STRIP001             }
//STRIP001 		}
//STRIP001     }

//STRIP001 	//Ende
//STRIP001 	m_pImpl->EndDialog(RET_OK);
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 AssistentDlg::~AssistentDlg()
//STRIP001 {
//STRIP001 	delete m_pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SfxObjectShellLock AssistentDlg::GetDocument()
//STRIP001 {
//STRIP001 	return m_pImpl->GetDocument();
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlg::GetTopic() const
//STRIP001 {
//STRIP001 	return m_pImpl->m_pPage4AskTopicEDT->GetText();
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlg::GetUserName() const
//STRIP001 {
//STRIP001 	return m_pImpl->m_pPage4AskNameEDT->GetText();
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlg::GetInformation() const
//STRIP001 {
//STRIP001 	return m_pImpl->m_pPage4AskInfoEDT->GetText();
//STRIP001 }
//STRIP001 
//STRIP001 OutputType AssistentDlg::GetOutputMedium() const
//STRIP001 {
//STRIP001 	if(m_pImpl->m_pPage2Medium1RB->IsChecked())
//STRIP001 		return OUTPUT_PRESENTATION;
//STRIP001 	else if(m_pImpl->m_pPage2Medium2RB->IsChecked())
//STRIP001 		return OUTPUT_SLIDE;
//STRIP001 	else if(m_pImpl->m_pPage2Medium3RB->IsChecked())
//STRIP001 		return OUTPUT_OVERHEAD;
//STRIP001 	else if(m_pImpl->m_pPage2Medium4RB->IsChecked())
//STRIP001 		return OUTPUT_PAGE;
//STRIP001 	else
//STRIP001 		return OUTPUT_ORIGINAL;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL AssistentDlg::IsSummary() const
//STRIP001 {
//STRIP001 	return m_pImpl->m_pPage5SummaryCB->IsChecked();
//STRIP001 }
//STRIP001 
//STRIP001 StartType AssistentDlg::GetStartType() const
//STRIP001 {
//STRIP001 	return m_pImpl->GetStartType();
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlg::GetDocPath() const
//STRIP001 {
//STRIP001 	return m_pImpl->GetDocFileName();
//STRIP001 }
//STRIP001 
//STRIP001 BOOL AssistentDlg::GetStartWithFlag() const
//STRIP001 {
//STRIP001 	return !m_pImpl->m_aStartWithFlag.IsChecked();
//STRIP001 }
//STRIP001 
//STRIP001 BOOL AssistentDlg::IsDocEmpty() const
//STRIP001 {
//STRIP001 	return m_pImpl->GetDocFileName().Len() == 0 &&
//STRIP001 		   m_pImpl->GetLayoutFileName().Len() == 0;
//STRIP001 }
//STRIP001 
//STRIP001 String AssistentDlg::GetPassword()
//STRIP001 {
//STRIP001 	return m_pImpl->GetPassword( m_pImpl->m_aDocFile );
//STRIP001 }

}
