/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_undel.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:43:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _UNOTOOLS_CHARCLASS_HXX
// auto strip #include <unotools/charclass.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BRKITEM_HXX //autogen
// auto strip #include <bf_svx/brkitem.hxx>
// auto strip #endif
// auto strip #ifndef _FMTPDSC_HXX //autogen
// auto strip #include <fmtpdsc.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
// auto strip #ifndef _POOLFMT_HXX
// auto strip #include <poolfmt.hxx>
// auto strip #endif
#ifndef _MVSAVE_HXX
#include <mvsave.hxx>
#endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
namespace binfilter {

//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }


// DELETE

/*N*/ SwUndoDelete::SwUndoDelete( SwPaM& rPam, BOOL bFullPara )
/*N*/ 	: SwUndo(UNDO_DELETE), SwUndRng( rPam ),
/*N*/ 	pMvStt( 0 ), pSttStr(0), pEndStr(0), nNode( 0 ), nSectDiff( 0 ),
/*N*/ 	pRedlData( 0 ), pRedlSaveData( 0 )
/*N*/ {
/*N*/ 	bMvAroundSectNd = bSectNdFnd = bGroup = bBackSp = bTblDelLastNd =
/*N*/ 		bResetPgDesc = bResetPgBrk = FALSE;
/*N*/ 
/*N*/ 	bDelFullPara = bFullPara;
/*N*/ 
/*N*/ 	SwDoc * pDoc = rPam.GetDoc();
/*N*/ #ifdef COMPACT
/*N*/ 	pDoc->DelUndoGroups();
/*N*/ #endif
/*N*/ 
/*N*/ 	if( !pDoc->IsIgnoreRedline() && pDoc->GetRedlineTbl().Count() )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pRedlSaveData = new SwRedlineSaveDatas;
//STRIP001 /*?*/ 		if( !FillSaveData( rPam, *pRedlSaveData ))
//STRIP001 /*?*/ 			delete pRedlSaveData, pRedlSaveData = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	if( !pHistory )
/*N*/ 		pHistory = new SwHistory;
/*N*/ 
/*N*/ 	// loesche erstmal alle Fussnoten
/*N*/ 	const SwPosition *pStt = rPam.Start(),
/*N*/ 					*pEnd = rPam.GetPoint() == pStt
/*N*/ 						? rPam.GetMark()
/*N*/ 						: rPam.GetPoint();
/*N*/ 
/*N*/ 	if( bDelFullPara )
/*N*/ 	{
/*N*/ 		ASSERT( rPam.HasMark(), "PaM ohne Mark" );
/*N*/ 		DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint(),
/*N*/ 						DelCntntType(DELCNT_ALL | DELCNT_CHKNOCNTNT) );
/*N*/ 
/*N*/ 		BOOL bDoesUndo = pDoc->DoesUndo();
/*N*/ 		pDoc->DoUndo( FALSE );
/*N*/ 		_DelBookmarks( pStt->nNode, pEnd->nNode );
/*N*/ 		pDoc->DoUndo( bDoesUndo );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
/*N*/ 	nSetPos = pHistory ? pHistory->Count() : 0;
/*N*/ 
/*N*/ 	// wurde schon was geloescht ??
/*N*/ 	nNdDiff = nSttNode - pStt->nNode.GetIndex();
/*N*/ 
/*N*/ 	bJoinNext = !bFullPara && pEnd == rPam.GetPoint();
/*N*/ 	bBackSp = !bFullPara && !bJoinNext;
/*N*/ 
/*N*/ 	SwTxtNode *pSttTxtNd = 0, *pEndTxtNd = 0;
/*N*/ 	if( !bFullPara )
/*N*/ 	{
/*N*/ 		pSttTxtNd = pStt->nNode.GetNode().GetTxtNode();
/*N*/ 		pEndTxtNd = nSttNode == nEndNode
/*N*/ 					? pSttTxtNd
/*N*/ 					: pEnd->nNode.GetNode().GetTxtNode();
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bMoveNds = *pStt == *pEnd      // noch ein Bereich vorhanden ??
/*N*/ 				? FALSE
/*N*/ 				: SaveCntnt( pStt, pEnd, pSttTxtNd, pEndTxtNd );
/*N*/ 
/*N*/ 	if( pSttTxtNd && pEndTxtNd && pSttTxtNd != pEndTxtNd )
/*N*/ 	{
/*N*/ 		// zwei unterschiedliche TextNodes, also speicher noch die
/*N*/ 		// TextFormatCollection fuers
/*?*/ 		pHistory->Add( pSttTxtNd->GetTxtColl(),pStt->nNode.GetIndex(), ND_TEXTNODE );
/*?*/ 		pHistory->Add( pEndTxtNd->GetTxtColl(),pEnd->nNode.GetIndex(), ND_TEXTNODE );
/*?*/ 
/*?*/ 		if( !bJoinNext )	 	// Selection von Unten nach Oben
/*?*/ 		{
/*?*/ 			// Beim JoinPrev() werden die AUTO-PageBreak's richtig
/*?*/ 			// kopiert. Um diese beim Undo wieder herzustellen, muss das
/*?*/ 			// Auto-PageBreak aus dem EndNode zurueckgesetzt werden.
/*?*/ 			// - fuer die PageDesc, ColBreak dito !
/*?*/ 			if( pEndTxtNd->GetpSwAttrSet() )
/*?*/ 			{
/*?*/ 				SwRegHistory aRegHist( *pEndTxtNd, pHistory );
/*?*/ 				if( SFX_ITEM_SET == pEndTxtNd->GetpSwAttrSet()->GetItemState(
/*?*/ 						RES_BREAK, FALSE ) )
/*?*/ 					pEndTxtNd->ResetAttr( RES_BREAK );
/*?*/ 				if( pEndTxtNd->GetpSwAttrSet() &&
/*?*/ 					SFX_ITEM_SET == pEndTxtNd->GetpSwAttrSet()->GetItemState(
/*?*/ 						RES_PAGEDESC, FALSE ) )
/*?*/ 					pEndTxtNd->ResetAttr( RES_PAGEDESC );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 

	// verschiebe jetzt noch den PaM !!!
	// der SPoint steht am Anfang der SSelection
/*N*/ 	if( pEnd == rPam.GetPoint() && pSttTxtNd )
/*N*/ 		rPam.Exchange();
/*N*/ 
/*N*/ 	if( !pSttTxtNd && !pEndTxtNd )
/*N*/ 		rPam.GetPoint()->nNode--;
/*N*/ 	rPam.DeleteMark();			// der SPoint ist aus dem Bereich
/*N*/ 
/*N*/ 	if( !pEndTxtNd )
/*N*/ 		nEndCntnt = 0;
/*N*/ 	if( !pSttTxtNd )
/*N*/ 		nSttCntnt = 0;
/*N*/ 
/*N*/ 	if( bMoveNds )		// sind noch Nodes zu verschieben ?
/*N*/ 	{
/*N*/ 		// verschiebe jetzt den Rest, also die vollstaendigen Nodes
/*N*/ 		// ACHTUNG: pStt und pEnd koennen durch die Pam-Korrektur schon
/*N*/ 		// ungueltig sein !!
/*N*/ 		int nNdOff = 0;
/*N*/ 		if( pSttTxtNd && ( pEndTxtNd || pSttTxtNd->GetTxt().Len() ))
/*N*/ 			nNdOff++;
/*N*/ 
/*N*/ 		SwNodeRange aRg( pDoc->GetNodes(), nSttNode - nNdDiff + nNdOff,
/*N*/ 						 pDoc->GetNodes(), nEndNode - nNdDiff );
/*N*/ 		if( !bFullPara && !pEndTxtNd &&
/*N*/ 			&aRg.aEnd.GetNode() != &pDoc->GetNodes().GetEndOfContent() )
/*?*/ 			aRg.aEnd++;
/*N*/ 
/*N*/ 		SwNodes& rNds = (SwNodes&)*pDoc->GetUndoNds();
/*N*/ 		SwNodes& rDocNds = pDoc->GetNodes();
/*N*/ 		nNode = rNds.GetEndOfContent().GetIndex();
/*N*/ 
/*N*/ 		// habe wir SectionNodes (Start/Ende) als 1. oder letzten
/*N*/ 		// Nodes in der Selection ?
/*N*/ 		SwNode* pTmpNd;
/*N*/ 		if( bJoinNext )		// Selektion von oben -> unten
/*N*/ 		{
/*N*/ 			// Bedingung: - SectionNode und dessen Ende ist der naechste Node
/*N*/ 			//			  - EndNode einer Section und der Start steht ausserhalb
/*?*/ 			if( pSttTxtNd && pEndTxtNd )
/*?*/ 			{
/*?*/ 				// am Ende erfolgt ein JoinNext, teste auf leere Sections
/*?*/ 				// Bedingung: - hinter dem EndTextNode steht ein SectionEndNd
/*?*/ 				//				dessen Start im Bereich liegt
/*?*/ 				//			  - SectionSttNd und der Start steht ausserhalb
/*?*/ 				if( aRg.aEnd.GetIndex()+1 < rDocNds.Count() &&
/*?*/ 					( (pTmpNd = rDocNds[ aRg.aEnd.GetIndex()+1 ])->IsEndNode()
/*?*/ 					&& pTmpNd->FindStartNode()->IsSectionNode()
/*?*/ 					&& pTmpNd->StartOfSectionIndex() >= aRg.aStart.GetIndex())
/*?*/ 				)
/*?*/ 				{
/*?*/ 					aRg.aEnd++;
/*?*/ 					bSectNdFnd = TRUE;
/*?*/ 				}
/*?*/ 				else if( ((pTmpNd = rDocNds[ aRg.aEnd.GetIndex()-1 ])->IsSectionNode()
/*?*/ 						&& pTmpNd->EndOfSectionIndex()-1 == aRg.aEnd.GetIndex())
/*?*/ 					|| ( pTmpNd->IsEndNode() &&
/*?*/ 					pTmpNd->FindStartNode()->IsSectionNode() &&
/*?*/ 					pTmpNd->FindStartNode()->GetIndex() < aRg.aStart.GetIndex())
/*?*/ 					)
/*?*/ 				{
/*?*/ 					aRg.aEnd++;
/*?*/ 					bSectNdFnd = TRUE;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			while( aRg.aEnd.GetIndex() < rDocNds.Count()-1 &&
/*?*/ 				// entstehen leere Sections ???
/*?*/ 				( (pTmpNd = &aRg.aEnd.GetNode())->IsEndNode() &&
/*?*/ 				pTmpNd->FindStartNode()->IsSectionNode() &&
/*?*/ 				pTmpNd->FindStartNode()->GetIndex()+1 >= aRg.aStart.GetIndex())
/*?*/ 				)
/*?*/ 			{
/*?*/ 				aRg.aEnd++;
/*?*/ 				bSectNdFnd = TRUE;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			if( pSttTxtNd && pEndTxtNd )
/*N*/ 			{
/*N*/ 				// am Ende erfolgt ein JoinPrev, teste auf leere Sections
/*N*/ 				// Bedingung: - vor dem StartTextNode steht ein SectionSttNd
/*N*/ 				//				dessen Ende im Bereich liegt
/*N*/ 				//			  - SectionEndNd und der Start steht ausserhalb
/*N*/ 				if( 2 < aRg.aStart.GetIndex() &&
/*N*/ 					( (pTmpNd = rDocNds[ aRg.aStart.GetIndex()-2 ])
/*N*/ 						->IsSectionNode() &&
/*N*/ 					pTmpNd->EndOfSectionIndex() < aRg.aEnd.GetIndex())
/*N*/ 				)
/*N*/ 				{
/*?*/ 					aRg.aStart = *pTmpNd;
/*?*/ 					bSectNdFnd = TRUE;
/*?*/ 					nSectDiff++;
/*N*/ 				}
/*N*/ 				else if( aRg.aStart.GetIndex() &&
/*N*/ 					((pTmpNd = &aRg.aStart.GetNode())->IsSectionNode()
/*N*/ 					&& pTmpNd->EndOfSectionIndex() > aRg.aEnd.GetIndex() ) ||
/*N*/ 					(pTmpNd->IsEndNode() && pTmpNd->FindStartNode()->IsSectionNode() &&
/*N*/ 					pTmpNd->FindStartNode()->GetIndex() < aRg.aStart.GetIndex() )
/*N*/ 					)
/*N*/ 				{
/*N*/ 					aRg.aStart--;
/*N*/ 					bSectNdFnd = TRUE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			while( 1 < aRg.aStart.GetIndex() &&
/*N*/ 				// entstehen leere Sections ???
/*N*/ 				( (pTmpNd = rDocNds[ aRg.aStart.GetIndex()-1 ])->IsSectionNode() &&
/*N*/ 				pTmpNd->EndOfSectionIndex() < aRg.aEnd.GetIndex())
/*N*/ 				)
/*N*/ 			{
/*?*/ 				aRg.aStart--;
/*?*/ 				bSectNdFnd = TRUE;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
		// ein Index auf den Start-/End-ContentNode, der mit verschoben wird,
		// um wieder an der Position eine Kopie anzulegen.
/*N*/ 		if( bSectNdFnd && ( bJoinNext ? pEndTxtNd : pSttTxtNd ))
/*N*/ 		{
/*N*/ 			if( bJoinNext )
/*N*/ 			{
/*?*/ 				SwNodeRange aMvRg( *pEndTxtNd, 0, *pEndTxtNd, 1 );
/*?*/ 				rDocNds.MakeTxtNode( aMvRg.aStart, pEndTxtNd->GetTxtColl() );
/*?*/ 				rDocNds._MoveNodes( aMvRg, rDocNds, aRg.aStart );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				SwNodeRange aMvRg( *pSttTxtNd, 0, *pSttTxtNd, 1 );
/*N*/ 				SwNode* pNew = rDocNds.MakeTxtNode( aMvRg.aEnd,
/*N*/ 											pSttTxtNd->GetTxtColl() );
/*N*/ 				if( nSectDiff )
/*N*/ 				{
/*?*/ 					aMvRg.aEnd--;
/*?*/ 					rDocNds._MoveNodes( aMvRg, rDocNds, aRg.aEnd );
/*?*/ 					aRg.aEnd--;
/*N*/ 				}
/*N*/ 				else
/*N*/ 					aRg.aStart = *pNew;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		rDocNds._MoveNodes( aRg, rNds, SwNodeIndex( rNds.GetEndOfContent() ));
/*N*/ 		pMvStt = new SwNodeIndex( rNds, nNode );
/*N*/ 		bMvAroundSectNd = FALSE;
/*N*/ 
/*N*/ 		if( !bSectNdFnd )
/*N*/ 		{
/*N*/ 			nSectDiff = aRg.aEnd.GetIndex() - aRg.aStart.GetIndex();
/*N*/ 			bMvAroundSectNd = 0 != nSectDiff;
/*N*/ 		}
/*N*/ 
/*N*/ 		nNode = rNds.GetEndOfContent().GetIndex() - nNode;		// Differenz merken !
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nNode = 0;		// kein Node verschoben -> keine Differenz zum Ende
/*N*/ 
/*N*/ 	// wurden davor noch Nodes geloescht ?? (FootNotes haben ContentNodes!)
/*N*/ 	if( !pSttTxtNd && !pEndTxtNd )
/*N*/ 	{
/*N*/ 		nNdDiff = nSttNode - rPam.GetPoint()->nNode.GetIndex() - (bFullPara ? 0 : 1);
/*N*/ 		rPam.Move( fnMoveForward, fnGoNode );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nNdDiff = nSttNode - rPam.GetPoint()->nNode.GetIndex();
/*N*/ 	if( bSectNdFnd )
/*N*/ 		nNdDiff -= nSectDiff;
/*N*/ 
/*N*/ 	if( !rPam.GetNode()->IsCntntNode() )
/*N*/ 		rPam.GetPoint()->nContent.Assign( 0, 0 );
/*N*/ 
/*N*/ 	// wird die History ueberhaupt benoetigt ??
/*N*/ 	if( pHistory && !pHistory->Count() )
/*N*/ 		DELETEZ( pHistory );
/*N*/ }

/*N*/ BOOL SwUndoDelete::SaveCntnt( const SwPosition* pStt, const SwPosition* pEnd,
/*N*/ 					SwTxtNode* pSttTxtNd, SwTxtNode* pEndTxtNd )
/*N*/ {
/*N*/ 	ULONG nNdIdx = pStt->nNode.GetIndex();
/*N*/ 	// 1 - kopiere den Anfang in den Start-String
/*N*/ 	if( pSttTxtNd )
/*N*/ 	{
/*N*/ 		BOOL bOneNode = nSttNode == nEndNode;
/*N*/ 		xub_StrLen nLen = bOneNode ? nEndCntnt - nSttCntnt
/*N*/ 								: pSttTxtNd->GetTxt().Len() - nSttCntnt;
/*N*/ 		SwRegHistory aRHst( *pSttTxtNd, pHistory );
/*N*/ 		// immer alle TextAttribute sichern; ist fuers Undo mit voll-
/*N*/ 		// staendiger Attributierung am besten, wegen den evt.
/*N*/ 		// Ueberlappenden Bereichen von An/Aus.
/*N*/ 		pHistory->CopyAttr( pSttTxtNd->GetpSwpHints(), nNdIdx,
/*N*/ 							0, pSttTxtNd->GetTxt().Len(), TRUE );
/*N*/ 		if( !bOneNode && pSttTxtNd->GetpSwAttrSet() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 	pHistory->CopyFmtAttr( *pSttTxtNd->GetpSwAttrSet(), nNdIdx );
/*N*/ 
/*N*/ 		// die Laenge kann sich veraendert haben (!!Felder!!)
/*N*/ 		nLen = ( bOneNode ? pEnd->nContent.GetIndex() : pSttTxtNd->GetTxt().Len() )
/*N*/ 				- pStt->nContent.GetIndex();
/*N*/ 
/*N*/ 		// loesche jetzt noch den Text (alle Attribut-Aenderungen kommen in
/*N*/ 		// die Undo-History
/*N*/ 		pSttStr = (String*)new String( pSttTxtNd->GetTxt().Copy( nSttCntnt, nLen ));
/*N*/ 		pSttTxtNd->Erase( pStt->nContent, nLen );
/*N*/ 		if( pSttTxtNd->GetpSwpHints() )
/*N*/ 			pSttTxtNd->GetpSwpHints()->DeRegister();
/*N*/ 
/*N*/ 		if( bOneNode )
/*N*/ 			return FALSE;           // keine Nodes mehr verschieben
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 	// 2 - kopiere das Ende in den End-String
/*N*/ 	if( pEndTxtNd )
/*N*/ 	{
/*N*/ 		SwIndex aEndIdx( pEndTxtNd );
/*N*/ 		nNdIdx = pEnd->nNode.GetIndex();
/*N*/ 		SwRegHistory aRHst( *pEndTxtNd, pHistory );

		// immer alle TextAttribute sichern; ist fuers Undo mit voll-
		// staendiger Attributierung am besten, wegen den evt.
		// Ueberlappenden Bereichen von An/Aus.
/*N*/ 		pHistory->CopyAttr( pEndTxtNd->GetpSwpHints(), nNdIdx, 0,
/*N*/ 							pEndTxtNd->GetTxt().Len(), TRUE );
/*N*/ 
/*N*/ 		if( pEndTxtNd->GetpSwAttrSet() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pHistory->CopyFmtAttr( *pEndTxtNd->GetpSwAttrSet(), nNdIdx );

		// loesche jetzt noch den Text (alle Attribut-Aenderungen kommen in
		// die Undo-History
/*N*/ 		pEndStr = (String*)new String( pEndTxtNd->GetTxt().Copy( 0,
/*N*/ 									pEnd->nContent.GetIndex() ));
/*N*/ 		pEndTxtNd->Erase( aEndIdx, pEnd->nContent.GetIndex() );
/*N*/ 		if( pEndTxtNd->GetpSwpHints() )
/*?*/ 			pEndTxtNd->GetpSwpHints()->DeRegister();
/*N*/ 	}

	// sind es nur zwei Nodes, dann ist schon alles erledigt.
/*N*/ 	if( ( pSttTxtNd || pEndTxtNd ) && nSttNode + 1 == nEndNode )
/*N*/ 		return FALSE;           // keine Nodes mehr verschieben

/*N*/ 	return TRUE;                // verschiebe die dazwischen liegenden Nodes
/*N*/ }


/*N*/ BOOL SwUndoDelete::CanGrouping( SwDoc* pDoc, const SwPaM& rDelPam )
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	// ist das Undo groesser als 1 Node ? (sprich: Start und EndString)
//STRIP001 	if( pSttStr ? !pSttStr->Len() || pEndStr : TRUE )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	// es kann nur das Loeschen von einzelnen char's zusammengefasst werden
//STRIP001 	if( nSttNode != nEndNode || ( !bGroup && nSttCntnt+1 != nEndCntnt ))
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	const SwPosition *pStt = rDelPam.Start(),
//STRIP001 					*pEnd = rDelPam.GetPoint() == pStt
//STRIP001 						? rDelPam.GetMark()
//STRIP001 						: rDelPam.GetPoint();
//STRIP001 
//STRIP001 	if( pStt->nNode != pEnd->nNode ||
//STRIP001 		pStt->nContent.GetIndex()+1 != pEnd->nContent.GetIndex() ||
//STRIP001 		pEnd->nNode != nSttNode )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	// untercheide zwischen BackSpace und Delete. Es muss dann das
//STRIP001 	// Undo-Array unterschiedlich aufgebaut werden !!
//STRIP001 	if( pEnd->nContent == nSttCntnt )
//STRIP001 	{
//STRIP001 		if( bGroup && !bBackSp ) return FALSE;
//STRIP001 		bBackSp = TRUE;
//STRIP001 	}
//STRIP001 	else if( pStt->nContent == nSttCntnt )
//STRIP001 	{
//STRIP001 		if( bGroup && bBackSp ) return FALSE;
//STRIP001 		bBackSp = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	// sind die beiden Nodes (Nodes-/Undo-Array) ueberhaupt TextNodes?
//STRIP001 	SwTxtNode * pDelTxtNd = pStt->nNode.GetNode().GetTxtNode();
//STRIP001 	if( !pDelTxtNd ) return FALSE;
//STRIP001 
//STRIP001 	xub_StrLen nUChrPos = bBackSp ? 0 : pSttStr->Len()-1;
//STRIP001 	sal_Unicode cDelChar = pDelTxtNd->GetTxt().GetChar( pStt->nContent.GetIndex() );
//STRIP001 	CharClass& rCC = GetAppCharClass();
//STRIP001 	if( ( CH_TXTATR_BREAKWORD == cDelChar && CH_TXTATR_INWORD == cDelChar ) ||
//STRIP001 		rCC.isLetterNumeric( String( cDelChar ), 0 ) !=
//STRIP001 		rCC.isLetterNumeric( *pSttStr, nUChrPos ) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	{
//STRIP001 		SwRedlineSaveDatas* pTmpSav = new SwRedlineSaveDatas;
//STRIP001 		if( !FillSaveData( rDelPam, *pTmpSav, FALSE ))
//STRIP001 			delete pTmpSav, pTmpSav = 0;
//STRIP001 
//STRIP001 		BOOL bOk = ( !pRedlSaveData && !pTmpSav ) ||
//STRIP001 				   ( pRedlSaveData && pTmpSav &&
//STRIP001 				SwUndo::CanRedlineGroup( *pRedlSaveData, *pTmpSav, bBackSp ));
//STRIP001 		delete pTmpSav;
//STRIP001 		if( !bOk )
//STRIP001 			return FALSE;
//STRIP001 
//STRIP001 		pDoc->DeleteRedline( rDelPam, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ok, die beiden 'Deletes' koennen zusammen gefasst werden, also
//STRIP001 	// 'verschiebe' das enstprechende Zeichen
//STRIP001 	if( bBackSp )
//STRIP001 		nSttCntnt--;    // BackSpace: Zeichen in Array einfuegen !!
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nEndCntnt++;    // Delete: Zeichen am Ende anhaengen
//STRIP001 		nUChrPos++;
//STRIP001 	}
//STRIP001 	pSttStr->Insert( cDelChar, nUChrPos );
//STRIP001 	pDelTxtNd->Erase( pStt->nContent, 1 );
//STRIP001 
//STRIP001 	bGroup = TRUE;
/*N*/ 	return TRUE;
/*N*/ }



/*N*/ SwUndoDelete::~SwUndoDelete()
/*N*/ {
/*N*/ 	delete pSttStr;
/*N*/ 	delete pEndStr;
/*N*/ 	if( pMvStt )		// loesche noch den Bereich aus dem UndoNodes Array
/*N*/ 	{
/*N*/ 		// Insert speichert den Inhalt in der IconSection
/*N*/ 		pMvStt->GetNode().GetNodes().Delete( *pMvStt, nNode );
/*N*/ 		delete pMvStt;
/*N*/ 	}
//STRIP001 /*?*/ 	delete pRedlData;
/*N*/ 	delete pRedlSaveData;
/*N*/ }



//STRIP001 void SwUndoDelete::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rUndoIter.GetDoc();
//STRIP001 	BOOL bUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	ULONG nCalcStt = nSttNode - nNdDiff;
//STRIP001 	if( bSectNdFnd )
//STRIP001 		nCalcStt -= nSectDiff;
//STRIP001 	SwNodeIndex aIdx( pDoc->GetNodes(), nCalcStt );
//STRIP001 
//STRIP001 	// SectionNodes blieben stehen und es wurde danach zusammengefasst
//STRIP001 	if( bMvAroundSectNd && !bJoinNext && pSttStr && pEndStr )
//STRIP001 		pDoc->GetNodes().GoNext( &aIdx );
//STRIP001 	SwNode* pInsNd = &aIdx.GetNode();
//STRIP001 
//STRIP001 	{		// Block, damit der SwPosition beim loeschen vom Node
//STRIP001 			// abgemeldet ist
//STRIP001 		SwPosition aPos( aIdx );
//STRIP001 		if( !bDelFullPara )
//STRIP001 		{
//STRIP001 			if( pInsNd->IsTableNode() )
//STRIP001 			{
//STRIP001 				pInsNd = pDoc->GetNodes().MakeTxtNode( aIdx,
//STRIP001 						(SwTxtFmtColl*)pDoc->GetDfltTxtFmtColl() );
//STRIP001 				aIdx--;
//STRIP001 				aPos.nNode = aIdx;
//STRIP001 				aPos.nContent.Assign( pInsNd->GetCntntNode(), nSttCntnt );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( pInsNd->IsCntntNode() )
//STRIP001 					aPos.nContent.Assign( (SwCntntNode*)pInsNd, nSttCntnt );
//STRIP001 #ifndef PRODUCT
//STRIP001 				else
//STRIP001 					ASSERT( bSectNdFnd, "vor welchen Node kopieren?" );
//STRIP001 #endif
//STRIP001 				if( !bTblDelLastNd )
//STRIP001 					pInsNd = 0;			// Node nicht loeschen !!
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pInsNd = 0;			// Node nicht loeschen !!
//STRIP001 
//STRIP001 		SwNodes* pUNds = (SwNodes*)pDoc->GetUndoNds();
//STRIP001 		BOOL bNodeMove = 0 != nNode;
//STRIP001 
//STRIP001 		// damit nicht die Attribute aus dem "Start"-Node kopiert werden,
//STRIP001 		// splitte erstmal den Node (wenn noetig)
//STRIP001 		if( bSectNdFnd )
//STRIP001 		{
//STRIP001 			if( bJoinNext )
//STRIP001 				aPos.nNode++;
//STRIP001 		}
//STRIP001 		else if( pEndStr )
//STRIP001 		{
//STRIP001 			// alle Attribute verwerfen, wurden alle gespeichert!
//STRIP001 			SwTxtNode* pTxtNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 			if( pTxtNd && pTxtNd->GetpSwAttrSet() )
//STRIP001 				pTxtNd->ResetAllAttr();
//STRIP001 
//STRIP001 			if( pTxtNd->GetpSwpHints() )
//STRIP001 				pTxtNd->ClearSwpHintsArr( FALSE );
//STRIP001 
//STRIP001 			if( pSttStr )
//STRIP001 			{
//STRIP001 				pDoc->SplitNode( aPos );
//STRIP001 				pTxtNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 				if( bMvAroundSectNd )
//STRIP001 				{
//STRIP001 					// leider muessen wir den Node noch verschieben
//STRIP001 					SwNodeIndex aMvIdx( pDoc->GetNodes(), ( bJoinNext
//STRIP001 							? nEndNode - nNdDiff - nNode + nSectDiff + 1
//STRIP001 							: nCalcStt )
//STRIP001 							);
//STRIP001 					if( bJoinNext )
//STRIP001 						aPos.nNode++; 		// auf den naechsten
//STRIP001 					SwNodeRange aRg( aPos.nNode, -1, aPos.nNode );
//STRIP001 					pDoc->GetNodes()._MoveNodes( aRg, pDoc->GetNodes(), aMvIdx, TRUE );
//STRIP001 
//STRIP001 					if( !bJoinNext )
//STRIP001 						aPos.nNode = aMvIdx;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			pTxtNd->Insert( *pEndStr, aPos.nContent, INS_NOHINTEXPAND );
//STRIP001 			if( !bNodeMove && pSttStr )
//STRIP001 				aPos.nNode = nSttNode - nNdDiff;
//STRIP001 		}
//STRIP001 		else if( pSttStr && bNodeMove )
//STRIP001 		{
//STRIP001 			SwTxtNode * pNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 			if( pNd )
//STRIP001 			{
//STRIP001 				if( nSttCntnt < pNd->GetTxt().Len() )
//STRIP001 					pDoc->SplitNode( aPos );
//STRIP001 				else
//STRIP001 					aPos.nNode++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		if( bNodeMove )
//STRIP001 		{
//STRIP001 			SwNodeRange aRg( *pMvStt, 0, *pMvStt, nNode );
//STRIP001 			SwNodeIndex aPrevIdx( aPos.nNode, -1 );
//STRIP001 			pUNds->_Copy( aRg, aPos.nNode );
//STRIP001 
//STRIP001 			// SectionNode-Modus und von unten nach oben selektiert:
//STRIP001 			//	-> im EndNode steht noch der Rest vom Join => loeschen
//STRIP001 			if( bSectNdFnd )
//STRIP001 			{
//STRIP001 				SwPosition aSpPos( bJoinNext ? aPrevIdx : aPos.nNode );
//STRIP001 				if( !bJoinNext && !nSectDiff )		// move to next content node
//STRIP001 					pDoc->GetNodes().GoNext( &aSpPos.nNode );
//STRIP001 
//STRIP001 				aSpPos.nContent.Assign( aSpPos.nNode.GetNode().GetCntntNode(),
//STRIP001 										nSttCntnt );
//STRIP001 				pDoc->SplitNode( aSpPos );
//STRIP001 				if( bJoinNext )
//STRIP001 				{
//STRIP001 					aPrevIdx = aPos.nNode;
//STRIP001 					if( aPrevIdx.GetNode().IsEndNode() &&
//STRIP001 						aPrevIdx.GetNode().FindStartNode()->IsSectionNode() )
//STRIP001 						// used for Buf #70454#
//STRIP001 						pDoc->GetNodes().GoNext( &aPrevIdx );
//STRIP001 					else
//STRIP001 						// used for Buf #73345#
//STRIP001 						pDoc->GetNodes().GoPrevious( &aPrevIdx );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aPrevIdx++;
//STRIP001 					if( nSectDiff )
//STRIP001 						aPrevIdx++;
//STRIP001 					aSpPos.nNode--;
//STRIP001 				}
//STRIP001 				SwNodeRange aMvRg( aSpPos.nNode, 0, aSpPos.nNode, 1 );
//STRIP001 				pDoc->GetNodes()._MoveNodes( aMvRg, pDoc->GetNodes(),
//STRIP001 											aPrevIdx );
//STRIP001 				pDoc->GetNodes().Delete( aPrevIdx, 1 );
//STRIP001 
//STRIP001 				if( pEndStr )
//STRIP001 				{
//STRIP001 					aPos.nNode = nEndNode - nNdDiff;	// am Anfang manipulieren
//STRIP001 					SwTxtNode * pTxtNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 					if( pTxtNd->GetpSwAttrSet() )
//STRIP001 						pTxtNd->ResetAllAttr();
//STRIP001 
//STRIP001 					aPos.nContent.Assign( pTxtNd, 0 );
//STRIP001 					pTxtNd->Insert( *pEndStr, aPos.nContent, INS_NOHINTEXPAND );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			aPos.nNode = nSttNode - nNdDiff;	// am Anfang manipulieren
//STRIP001 		}
//STRIP001 		if( pSttStr )
//STRIP001 		{
//STRIP001 			SwTxtNode * pTxtNd = aPos.nNode.GetNode().GetTxtNode();
//STRIP001 			// wenn mehr als ein Node geloescht wurde, dann wurden auch
//STRIP001 			// alle "Node"-Attribute gespeichert
//STRIP001 			if( pTxtNd->GetpSwAttrSet() && bNodeMove && !pEndStr )
//STRIP001 				pTxtNd->ResetAllAttr();
//STRIP001 
//STRIP001 			if( pTxtNd->GetpSwpHints() )
//STRIP001 				pTxtNd->ClearSwpHintsArr( FALSE );
//STRIP001 
//STRIP001 			// SectionNode-Modus und von oben nach unten selektiert:
//STRIP001 			//	-> im StartNode steht noch der Rest vom Join => loeschen
//STRIP001 			aPos.nContent.Assign( pTxtNd, nSttCntnt );
//STRIP001 			pTxtNd->Insert( *pSttStr, aPos.nContent, INS_NOHINTEXPAND );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pHistory )
//STRIP001 		{
//STRIP001 			pHistory->TmpRollback( pDoc, nSetPos, FALSE );
//STRIP001 			if( nSetPos )		// es gab Fussnoten/FlyFrames
//STRIP001 			{
//STRIP001 				// gibts ausser diesen noch andere ?
//STRIP001 				if( nSetPos < pHistory->Count() )
//STRIP001 				{
//STRIP001 					// dann sicher die Attribute anderen Attribute
//STRIP001 					SwHistory aHstr;
//STRIP001 					aHstr.Move( 0, pHistory, nSetPos );
//STRIP001 					pHistory->Rollback( pDoc );
//STRIP001 					pHistory->Move( 0, &aHstr );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pHistory->Rollback( pDoc );
//STRIP001 					DELETEZ( pHistory );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bResetPgDesc || bResetPgBrk )
//STRIP001 		{
//STRIP001 			USHORT nStt = bResetPgDesc ? RES_PAGEDESC : RES_BREAK;
//STRIP001 			USHORT nEnd = bResetPgBrk ? RES_BREAK : RES_PAGEDESC;
//STRIP001 
//STRIP001 			SwNode* pNode = pDoc->GetNodes()[ nEndNode + 1 ];
//STRIP001 			if( pNode->IsCntntNode() )
//STRIP001 				((SwCntntNode*)pNode)->ResetAttr( nStt, nEnd );
//STRIP001 			else if( pNode->IsTableNode() )
//STRIP001 				((SwTableNode*)pNode)->GetTable().GetFrmFmt()->ResetAttr( nStt, nEnd );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// den temp. eingefuegten Node noch loeschen !!
//STRIP001 	if( pInsNd )
//STRIP001 		pDoc->GetNodes().Delete( aIdx, 1 );
//STRIP001 
//STRIP001 	if( pRedlSaveData )
//STRIP001 		SetSaveData( *pDoc, *pRedlSaveData );
//STRIP001 
//STRIP001 	pDoc->DoUndo( bUndo );			// Undo wieder einschalten
//STRIP001 	SetPaM( rUndoIter, TRUE );
//STRIP001 }

//STRIP001 void SwUndoDelete::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.SetUpdateAttr( TRUE );
//STRIP001 
//STRIP001 	SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 	SwDoc& rDoc = *rPam.GetDoc();
//STRIP001 
//STRIP001 	SetPaM( rPam );
//STRIP001 
//STRIP001 	if( pRedlSaveData )
//STRIP001 		rDoc.DeleteRedline( rPam, FALSE );
//STRIP001 
//STRIP001 	if( !bDelFullPara )
//STRIP001 	{
//STRIP001 		SwUndRng aTmpRng( rPam );
//STRIP001 		RemoveIdxFromRange( rPam, FALSE );
//STRIP001 		aTmpRng.SetPaM( rPam );
//STRIP001 
//STRIP001 		if( !bJoinNext )			// Dann Selektion von unten nach oben
//STRIP001 			rPam.Exchange();		// wieder herstellen!
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pHistory )		// wurden Attribute gesichert ?
//STRIP001 	{
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 		SwHistory aHstr;
//STRIP001 		aHstr.Move( 0, pHistory );
//STRIP001 
//STRIP001 		if( bDelFullPara )
//STRIP001 		{
//STRIP001 			ASSERT( rPam.HasMark(), "PaM ohne Mark" );
//STRIP001 			DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint(),
//STRIP001 							DelCntntType(DELCNT_ALL | DELCNT_CHKNOCNTNT) );
//STRIP001 
//STRIP001 			_DelBookmarks( rPam.GetMark()->nNode, rPam.GetPoint()->nNode );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
//STRIP001 		nSetPos = pHistory ? pHistory->Count() : 0;
//STRIP001 
//STRIP001 		pHistory->Move( nSetPos, &aHstr );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( bDelFullPara )
//STRIP001 		{
//STRIP001 			ASSERT( rPam.HasMark(), "PaM ohne Mark" );
//STRIP001 			DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint(),
//STRIP001 							DelCntntType(DELCNT_ALL | DELCNT_CHKNOCNTNT) );
//STRIP001 
//STRIP001 			_DelBookmarks( rPam.GetMark()->nNode, rPam.GetPoint()->nNode );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
//STRIP001 		nSetPos = pHistory ? pHistory->Count() : 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pSttStr && !pEndStr )
//STRIP001 	{
//STRIP001 		SwNodeIndex& rSttIdx = ( bDelFullPara || bJoinNext )
//STRIP001 									? rPam.GetMark()->nNode
//STRIP001 									: rPam.GetPoint()->nNode;
//STRIP001 		SwTableNode* pTblNd = rSttIdx.GetNode().GetTableNode();
//STRIP001 		if( pTblNd )
//STRIP001 		{
//STRIP001 			if( bTblDelLastNd )
//STRIP001 			{
//STRIP001 				// dann am Ende wieder einen Node einfuegen
//STRIP001 				const SwNodeIndex aTmpIdx( *pTblNd->EndOfSectionNode(), 1 );
//STRIP001 				rDoc.GetNodes().MakeTxtNode( aTmpIdx,
//STRIP001 						rDoc.GetTxtCollFromPool( RES_POOLCOLL_STANDARD ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			SwCntntNode* pNextNd = rDoc.GetNodes()[
//STRIP001 					pTblNd->EndOfSectionIndex()+1 ]->GetCntntNode();
//STRIP001 			if( pNextNd )
//STRIP001 			{
//STRIP001 				SwFrmFmt* pTableFmt = pTblNd->GetTable().GetFrmFmt();
//STRIP001 				const SfxPoolItem *pItem;
//STRIP001 				if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_PAGEDESC,
//STRIP001 					FALSE, &pItem ) )
//STRIP001 					pNextNd->SetAttr( *pItem );
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == pTableFmt->GetItemState( RES_BREAK,
//STRIP001 					FALSE, &pItem ) )
//STRIP001 					pNextNd->SetAttr( *pItem );
//STRIP001 			}
//STRIP001 			pTblNd->DelFrms();
//STRIP001 		}
//STRIP001 
//STRIP001 		rDoc.GetNodes().Delete( rSttIdx, nEndNode - nSttNode );
//STRIP001 
//STRIP001 		rPam.DeleteMark();
//STRIP001 		// setze den Cursor immer in einen ContentNode !!
//STRIP001 		if( !rPam.Move( fnMoveBackward, fnGoCntnt ) &&
//STRIP001 			!rPam.Move( fnMoveForward, fnGoCntnt ) )
//STRIP001 			rPam.GetPoint()->nContent.Assign( rPam.GetCntntNode(), 0 );
//STRIP001 	}
//STRIP001 	else if( bDelFullPara )
//STRIP001 	{
//STRIP001 		// der Pam wurde am Point( == Ende) um eins erhoeht, um einen
//STRIP001 		// Bereich fuers Undo zu haben. Der muss jetzt aber wieder entfernt
//STRIP001 		// werden!!!
//STRIP001 		rPam.End()->nNode--;
//STRIP001 		if( rPam.GetPoint()->nNode == rPam.GetMark()->nNode )
//STRIP001 			*rPam.GetMark() = *rPam.GetPoint();
//STRIP001 		rDoc.DelFullPara( rPam );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rDoc.DeleteAndJoin( rPam );
//STRIP001 }

//STRIP001 void SwUndoDelete::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( UNDO_DELETE == rUndoIter.GetLastUndoId() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 	SwDoc& rDoc = *rPam.GetDoc();
//STRIP001 	BOOL bGroupUndo = rDoc.DoesGroupUndo();
//STRIP001 	rDoc.DoGroupUndo( FALSE );
//STRIP001 	if( !rPam.HasMark() )
//STRIP001 	{
//STRIP001 		rPam.SetMark();
//STRIP001 		rPam.Move( fnMoveForward, fnGoCntnt );
//STRIP001 	}
//STRIP001 	if( bDelFullPara )
//STRIP001 		rDoc.DelFullPara( rPam );
//STRIP001 	else
//STRIP001 		rDoc.DeleteAndJoin( rPam );
//STRIP001 	rDoc.DoGroupUndo( bGroupUndo );
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 }


}
