/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_workctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:28:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
// auto strip #ifndef _SVX_HTMLMODE_HXX //autogen
// auto strip #include <bf_svx/htmlmode.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <bf_sfx2/bindings.hxx>
#endif


#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
// auto strip #ifndef _INITUI_HXX
// auto strip #include <initui.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSHDL_HXX
// auto strip #include <gloshdl.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSSARY_HXX
// auto strip #include <glossary.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSDOC_HXX
// auto strip #include <glosdoc.hxx>
// auto strip #endif
// auto strip #ifndef _GLOSLST_HXX
// auto strip #include <gloslst.hxx>
// auto strip #endif
// auto strip #ifndef _TBXMGR_HXX
// auto strip #include <tbxmgr.hxx>
// auto strip #endif
#ifndef _WORKCTRL_HXX
#include <workctrl.hxx>
#endif
#ifndef _WORKCTRL_HRC
#include <workctrl.hrc>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _HELPID_H
#include <helpid.h>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _WRTSH_HXX //autogen
// auto strip #include <wrtsh.hxx>
// auto strip #endif
#ifndef _SVT_IMAGEITM_HXX
#include <svtools/imageitm.hxx>
#endif
// auto strip #ifndef _SV_LSTBOX_HXX 
// auto strip #include <vcl/lstbox.hxx>
// auto strip #endif
#ifndef _SFXIMGMGR_HXX
#include <bf_sfx2/imgmgr.hxx>
#endif
namespace binfilter {

//JP 14.01.99: Size Abpruefung
#define NAVI_ENTRIES 20
#if NAVI_ENTRIES != NID_COUNT
#error SwScrollNaviPopup-CTOR static Array falsche Size. Wurden neue IDs zugefuegt ??
#endif


/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SwTbxInsertCtrl, SfxImageItem);
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SwTbxAutoTextCtrl, SfxBoolItem );

/**********************************************************************

**********************************************************************/
/*N*/ SwTbxInsertCtrl::SwTbxInsertCtrl( USHORT nId,
/*N*/ 									ToolBox& rTbx,
/*N*/ 									SfxBindings& rBind ) :
/*N*/ 		SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 		nLastSlotId(FN_INSERT_CTRL == nId ? FN_INSERT_TABLE : SID_INSERT_DIAGRAM)
/*N*/ {
/*N*/     sal_Bool bHighContrast = rTbx.GetDisplayBackground().GetColor().IsDark();
/*N*/     Image aImage = GetBindings().GetImageManager()->GetImage( nLastSlotId, bHighContrast, SW_MOD() );
/*N*/ 	rTbx.SetItemImage(GetId(), aImage);
/*N*/ }
/**********************************************************************

**********************************************************************/
/*N*/ SwTbxInsertCtrl::~SwTbxInsertCtrl()
/*N*/ {
/*N*/ }

/**********************************************************************

**********************************************************************/


/*N*/ void SwTbxInsertCtrl::StateChanged( USHORT nSID,
/*N*/ 									  SfxItemState eState,
/*N*/ 									  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	GetToolBox().EnableItem( nId, (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/ 
/*N*/ 	if( eState == SFX_ITEM_AVAILABLE )
/*N*/ 	{
/*N*/         const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
/*N*/         if(pItem)
/*N*/ 		{
/*N*/ 			nLastSlotId = pItem->GetValue();
/*N*/ 			if( nLastSlotId )
/*N*/ 				nId = nLastSlotId;
/*N*/ 
/*N*/             BOOL bHiContrast = GetToolBox().GetDisplayBackground().GetColor().IsDark();
/*N*/             Image aImage = GetBindings().GetImageManager()->GetImage( nId, bHiContrast, SW_MOD() );
/*N*/             ToolBox& rBox = GetToolBox();
/*N*/             rBox.SetItemImage(GetId(), aImage);
/*N*/             rBox.SetItemImageMirrorMode( GetId(), FALSE );
/*N*/ 			rBox.SetItemImageAngle( GetId(), pItem->GetRotation() );
/*N*/             rBox.SetItemImageMirrorMode( GetId(), pItem->IsMirrored() );
/*N*/         }
/*N*/ 	}
/*N*/ 
/*N*/ }
/**********************************************************************

**********************************************************************/


//STRIP001 SfxPopupWindow* SwTbxInsertCtrl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	USHORT nWinResId, nTbxResId;
//STRIP001 	if(GetId() == FN_INSERT_CTRL)
//STRIP001 	{
//STRIP001 		nWinResId = RID_INSERT_CTRL;
//STRIP001 		nTbxResId = TBX_INSERT;
//STRIP001 	}
//STRIP001 	else /* FN_INSERT_OBJ_CTRL */
//STRIP001 	{
//STRIP001 		nWinResId = RID_INSERT_OBJ_CTRL;
//STRIP001 		nTbxResId = TBX_OBJ_INSERT;
//STRIP001 	}
//STRIP001 
//STRIP001 	WindowAlign eAlign = WINDOWALIGN_TOP;
//STRIP001 	if(GetToolBox().IsHorizontal())
//STRIP001 		eAlign = WINDOWALIGN_LEFT;
//STRIP001 	SwPopupWindowTbxMgr *pWin = new SwPopupWindowTbxMgr( GetId(),
//STRIP001 									eAlign,
//STRIP001 									SW_RES(nWinResId),
//STRIP001 									SW_RES(nTbxResId),
//STRIP001 									GetBindings());
//STRIP001 
//STRIP001 	pWin->StartPopupMode(&GetToolBox(), TRUE);
//STRIP001 	pWin->StartSelection();
//STRIP001 	pWin->Show();
//STRIP001 	return pWin;
//STRIP001 
//STRIP001 }

/**********************************************************************

**********************************************************************/


//STRIP001 SfxPopupWindowType	SwTbxInsertCtrl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return nLastSlotId ? SFX_POPUPWINDOW_ONTIMEOUT : SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }


/**********************************************************************

**********************************************************************/


//STRIP001 void SwTbxInsertCtrl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	if(nLastSlotId)
//STRIP001         GetBindings().Execute(nLastSlotId);
//STRIP001 }

/**********************************************************************

**********************************************************************/


/*N*/ SwTbxAutoTextCtrl::SwTbxAutoTextCtrl( USHORT nId,
/*N*/ 									ToolBox& rTbx,
/*N*/ 									SfxBindings& rBind ) :
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 	pView(0),
/*N*/ 	pPopup(0)
/*N*/ {
/*N*/ }
/**********************************************************************

**********************************************************************/


/*N*/ SwTbxAutoTextCtrl::~SwTbxAutoTextCtrl()
/*N*/ {
/*N*/ 	DelPopup();
/*N*/ }

/**********************************************************************

**********************************************************************/


//STRIP001 SfxPopupWindow* SwTbxAutoTextCtrl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	pView = ::GetActiveView();
//STRIP001 	if(pView && !pView->GetDocShell()->IsReadOnly() &&
//STRIP001 	   !pView->GetWrtShell().HasReadonlySel() )
//STRIP001 	{
//STRIP001 		ToolBox& rBox = GetToolBox();
//STRIP001 
//STRIP001         Rectangle aItemRect( rBox.GetItemRect( GetId() ) );
//STRIP001         Point aPt(rBox.OutputToScreenPixel(aItemRect.TopLeft()));
//STRIP001         aPt.X() += aItemRect.GetWidth()/2;
//STRIP001         aPt.Y() += aItemRect.GetHeight()/2;
//STRIP001         if(pView)
//STRIP001 		{
//STRIP001 			Link aLnk = LINK(this, SwTbxAutoTextCtrl, PopupHdl);
//STRIP001 
//STRIP001 			if (GetId() == FN_INSERT_FIELD_CTRL)
//STRIP001 			{
//STRIP001 				pPopup = new PopupMenu(SW_RES(RID_INSERT_FIELD_CTRL));
//STRIP001 				pPopup->SetSelectHdl(aLnk);
//STRIP001 
//STRIP001 				if (::binfilter::GetHtmlMode(pView->GetDocShell()) & HTMLMODE_ON)
//STRIP001 				{
//STRIP001 					pPopup->RemoveItem(pPopup->GetItemPos(FN_INSERT_FLD_PGCOUNT));
//STRIP001 					pPopup->RemoveItem(pPopup->GetItemPos(FN_INSERT_FLD_TOPIC));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pPopup = new PopupMenu;
//STRIP001 				SwGlossaryList* pGlossaryList = ::GetGlossaryList();
//STRIP001 				USHORT nGroupCount = pGlossaryList->GetGroupCount();
//STRIP001 				for(USHORT i = 1; i <= nGroupCount; i++)
//STRIP001 				{
//STRIP001 					// Gruppenname mit Pfad-Extension besorgen
//STRIP001 					String sTitle;
//STRIP001 					String sGroupName = pGlossaryList->GetGroupName(i - 1, FALSE, &sTitle);
//STRIP001 					USHORT nBlockCount = pGlossaryList->GetBlockCount(i -1);
//STRIP001 					if(nBlockCount)
//STRIP001 					{
//STRIP001 						USHORT nIndex = 100 * (i);
//STRIP001 						// aber ohne extension einfuegen
//STRIP001 						pPopup->InsertItem( i, sTitle);//sGroupName.GetToken(0, GLOS_DELIM));
//STRIP001 						PopupMenu* pSub = new PopupMenu;
//STRIP001 						pSub->SetSelectHdl(aLnk);
//STRIP001 						pPopup->SetPopupMenu(i, pSub);
//STRIP001 						for(USHORT j = 0; j < nBlockCount; j++)
//STRIP001 						{
//STRIP001 							String sEntry;
//STRIP001 							String sLongName(pGlossaryList->GetBlockName(i - 1, j, sEntry));
//STRIP001 							sEntry.AppendAscii(" - ");
//STRIP001 							sEntry += sLongName;
//STRIP001 							pSub->InsertItem(++nIndex, sEntry);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		ToolBox* pToolBox = &GetToolBox();
//STRIP001 		USHORT nId = GetId();
//STRIP001 		pToolBox->SetItemDown( nId, TRUE );
//STRIP001 		pPopup->Execute( pToolBox, pToolBox->ScreenToOutputPixel( aPt ) );
//STRIP001 		pToolBox->SetItemDown( nId, FALSE );
//STRIP001 	}
//STRIP001 	GetToolBox().EndSelection();
//STRIP001 	DelPopup();
//STRIP001 	return 0;
//STRIP001 
//STRIP001 }


/**********************************************************************

**********************************************************************/


//STRIP001 SfxPopupWindowType SwTbxAutoTextCtrl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONTIMEOUT;
//STRIP001 }

/**********************************************************************

**********************************************************************/


/*N*/ void SwTbxAutoTextCtrl::StateChanged( USHORT nSID,
/*N*/ 											  SfxItemState eState,
/*N*/ 											  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	GetToolBox().EnableItem( GetId(), (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/ 	if(FN_INSERT_FIELD_CTRL == nSID && eState >= SFX_ITEM_DEFAULT)
/*N*/ 	{
/*N*/ 		GetToolBox().CheckItem( GetId(), ((SfxBoolItem*)pState)->GetValue() );
/*N*/ 	}
/*N*/ }

/**********************************************************************

**********************************************************************/


//STRIP001 IMPL_LINK(SwTbxAutoTextCtrl, PopupHdl, PopupMenu*, pMenu)
//STRIP001 {
//STRIP001 	int nId = pMenu->GetCurItemId();
//STRIP001 
//STRIP001 	if (GetId() == FN_INSERT_FIELD_CTRL)
//STRIP001 	{
//STRIP001         GetBindings().Execute(nId);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nBlock = nId/100;
//STRIP001 
//STRIP001 		SwGlossaryList* pGlossaryList = ::GetGlossaryList();
//STRIP001 		String sShortName;
//STRIP001 		String sGroup = pGlossaryList->GetGroupName(nBlock - 1, FALSE);
//STRIP001 		String sLongName(pGlossaryList->GetBlockName(nBlock - 1, nId - (100 * nBlock) - 1, sShortName));
//STRIP001 
//STRIP001 		SwGlossaryHdl* pGlosHdl = pView->GetGlosHdl();
//STRIP001 		SwGlossaryDlg::SetActGroup(sGroup);
//STRIP001 		pGlosHdl->SetCurGroup(sGroup, TRUE);
//STRIP001 		pGlosHdl->InsertGlossary(sShortName);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/**********************************************************************

**********************************************************************/


/*N*/ void SwTbxAutoTextCtrl::DelPopup()
/*N*/ {
/*N*/ 	if(pPopup)
/*N*/ 	{
/*?*/ 		if (GetId() != FN_INSERT_FIELD_CTRL)
/*?*/ 		{
/*?*/ 			for( USHORT i = 0; i < pPopup->GetItemCount(); i ++ )
/*?*/ 			{
/*?*/ 				PopupMenu* pSubPopup = pPopup->GetPopupMenu(pPopup->GetItemId(i));
/*?*/ 				delete pSubPopup;
/*?*/ 			}
/*?*/ 		}
/*?*/ 		delete pPopup;
/*?*/ 		pPopup = 0;
/*?*/ 	}
/*N*/ }

/*-----------------19.02.97 10.52-------------------
	Navigations-Popup
--------------------------------------------------*/
// determine the order of the toolbox items
static USHORT __READONLY_DATA aNavigationInsertIds[ NAVI_ENTRIES ] =
{
    // -- first line
    NID_TBL,
    NID_FRM,
    NID_GRF,
    NID_OLE,
    NID_PGE,
    NID_OUTL,
    NID_MARK,
    NID_DRW,
    NID_CTRL,
    NID_PREV,
    // -- second line
    NID_REG,
    NID_BKM,
    NID_SEL,
    NID_FTN,
    NID_POSTIT,
    NID_SRCH_REP,
    NID_INDEX_ENTRY,
    NID_TABLE_FORMULA,
    NID_TABLE_FORMULA_ERROR,
    NID_NEXT
};

//STRIP001 SwScrollNaviPopup::SwScrollNaviPopup( USHORT nId,
//STRIP001 								SfxBindings & rBnd)
//STRIP001     : SfxPopupWindow(nId, SW_RES(RID_SCROLL_NAVIGATION_WIN), rBnd),
//STRIP001     aToolBox(this, 0),
//STRIP001     aSeparator(this, ResId(FL_SEP)),
//STRIP001     aInfoField(this, ResId(FI_INFO)),
//STRIP001 	aIList(ResId(IL_VALUES)),
//STRIP001     aIListH(ResId(ILH_VALUES)),
//STRIP001 	nFwdId(FN_START_OF_NEXT_PAGE),
//STRIP001 	nBackId(FN_START_OF_PREV_PAGE)
//STRIP001 {
//STRIP001     aToolBox.SetHelpId(HID_NAVI_VS);
//STRIP001     aToolBox.SetLineCount( 2 );
//STRIP001     aToolBox.SetOutStyle(TOOLBOX_STYLE_FLAT);
//STRIP001     for(USHORT i = 0; i < NID_COUNT; i++)
//STRIP001 	{
//STRIP001         USHORT nId = aNavigationInsertIds[i];
//STRIP001         String sText;
//STRIP001         ToolBoxItemBits  nTbxBits = 0;
//STRIP001         if((NID_PREV != nId) && (NID_NEXT != nId))
//STRIP001         {
//STRIP001             // -2, there's no string for Next/Prev
//STRIP001             USHORT nResStr = ST_TBL - 2 + nId - NID_START;
//STRIP001             sText = String(ResId(nResStr));
//STRIP001             nTbxBits = TIB_CHECKABLE;
//STRIP001         }
//STRIP001         aToolBox.InsertItem(nId, sText, nTbxBits);
//STRIP001     }
//STRIP001     ApplyImageList();
//STRIP001     aToolBox.InsertBreak(NID_COUNT/2);
//STRIP001     // don't call it before!
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     // these are global strings
//STRIP001 	for( i = 0; i < 2 * NID_COUNT; i++)
//STRIP001 	{
//STRIP001 		sQuickHelp[i] = String(SW_RES(STR_IMGBTN_START + i));
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aImgSize = aIList.GetImageSize();
//STRIP001 	aImgSize.Width() += 5;
//STRIP001 	aImgSize.Height() += 5;
//STRIP001     Size aSz = aToolBox.CalcWindowSizePixel(2);
//STRIP001     aToolBox.SetPosSizePixel( Point(), aSz );
//STRIP001     USHORT nItemId = SwView::GetMoveType();
//STRIP001     aInfoField.SetText(aToolBox.GetItemText(nItemId));
//STRIP001     aToolBox.CheckItem( nItemId, sal_True );
//STRIP001     Size aFTSize(aInfoField.GetSizePixel());
//STRIP001     Size aSepSize(aSeparator.GetSizePixel());
//STRIP001     aSepSize.Width() = aSz.Width();
//STRIP001 
//STRIP001     aSz.Height() += aFTSize.Height() + aSepSize.Height();
//STRIP001     aInfoField.SetPosSizePixel(
//STRIP001         Point(0, aSz.Height() - aFTSize.Height()), Size(aSz.Width(), aFTSize.Height()));
//STRIP001 
//STRIP001     aSeparator.SetSizePixel(aSepSize);
//STRIP001     aSeparator.SetPosPixel(Point(0, aSz.Height() - aFTSize.Height() - aSepSize.Height()));
//STRIP001 
//STRIP001     SetOutputSizePixel(aSz);
//STRIP001     aToolBox.SetSelectHdl(LINK(this, SwScrollNaviPopup, SelectHdl));
//STRIP001     aToolBox.StartSelection();
//STRIP001     aToolBox.Show();
//STRIP001 }
/*-----------------19.02.97 12.45-------------------

--------------------------------------------------*/

//STRIP001 SwScrollNaviPopup::~SwScrollNaviPopup()
//STRIP001 {
//STRIP001 }
/* -----------------------------08.05.2002 14:00------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwScrollNaviPopup::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }
/* -----------------------------08.05.2002 14:02------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwScrollNaviPopup::ApplyImageList()
//STRIP001 {
//STRIP001     ImageList& rImgLst = aToolBox.GetDisplayBackground().GetColor().IsDark() ?
//STRIP001         aIListH : aIList;
//STRIP001     for(USHORT i = 0; i < NID_COUNT; i++)
//STRIP001 	{
//STRIP001         USHORT nId = aNavigationInsertIds[i];
//STRIP001         aToolBox.SetItemImage(nId, rImgLst.GetImage(nId));
//STRIP001     }
//STRIP001 }
/*-----------------19.02.97 13.58-------------------

--------------------------------------------------*/

//STRIP001 SfxPopupWindow* SwScrollNaviPopup::Clone() const
//STRIP001 {
//STRIP001     return new SwScrollNaviPopup(GetId(), ( SfxBindings & ) GetBindings());
//STRIP001 }

/*-----------------19.02.97 14.10-------------------

--------------------------------------------------*/

//STRIP001 IMPL_LINK(SwScrollNaviPopup, SelectHdl, ToolBox*, pSet)
//STRIP001 {
//STRIP001     USHORT nSet = pSet->GetCurItemId();
//STRIP001 	if( nSet != NID_PREV && nSet != NID_NEXT )
//STRIP001 	{
//STRIP001 		SwView::SetMoveType(nSet);
//STRIP001         aToolBox.SetItemText(NID_NEXT, sQuickHelp[nSet - NID_START]);
//STRIP001         aToolBox.SetItemText(NID_PREV, sQuickHelp[nSet - NID_START + NID_COUNT]);
//STRIP001         aInfoField.SetText(aToolBox.GetItemText(nSet));
//STRIP001         //check the current button only
//STRIP001         for(USHORT i = 0; i < NID_COUNT; i++)
//STRIP001         {
//STRIP001             USHORT nItemId = aToolBox.GetItemId( i );
//STRIP001             aToolBox.CheckItem( nItemId, nItemId == nSet );
//STRIP001         }
//STRIP001     }
//STRIP001 	else
//STRIP001 	{
//STRIP001         const SfxPoolItem* aItems[2];
//STRIP001         SfxBoolItem aNext(FN_SCROLL_NEXT_PREV, NID_NEXT == nSet);
//STRIP001         aItems[0] = &aNext;
//STRIP001         aItems[1] = NULL;
//STRIP001         GetBindings().ExecuteSynchron(FN_SCROLL_NEXT_PREV,aItems, 0L);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
/*-----------------23.02.97 18.21-------------------

--------------------------------------------------*/

//STRIP001 void SwScrollNaviToolBox::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     ToolBox::MouseButtonUp(rMEvt);
//STRIP001 	if ( ((SwScrollNaviPopup*)GetParent())->IsInPopupMode() )
//STRIP001 		((SwScrollNaviPopup*)GetParent())->EndPopupMode( FLOATWIN_POPUPMODEEND_CLOSEALL );
//STRIP001 }

/*-----------------20.06.97 13:28-------------------

--------------------------------------------------*/
//STRIP001 void  SwScrollNaviToolBox::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 	USHORT nMoveType = SwView::GetMoveType();
//STRIP001 	SetItemText(NID_NEXT, SwScrollNaviPopup::GetQuickHelpText(TRUE));
//STRIP001 	SetItemText(NID_PREV, SwScrollNaviPopup::GetQuickHelpText(FALSE));
//STRIP001     ToolBox::RequestHelp( rHEvt );
//STRIP001 
//STRIP001 }

/*-----------------20.06.97 13:41-------------------

--------------------------------------------------*/
//STRIP001 String	SwScrollNaviPopup::GetQuickHelpText(BOOL bNext)
//STRIP001 {
//STRIP001 	USHORT nResId = STR_IMGBTN_START;
//STRIP001 	nResId += SwView::GetMoveType() - NID_START;
//STRIP001 	if(!bNext)
//STRIP001 		nResId += NID_COUNT;
//STRIP001 	return String(SW_RES(nResId));
//STRIP001 }
/* -----------------------------05.09.2002 13:53------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwNaviImageButton::Click()
//STRIP001 {
//STRIP001     SfxBindings& rBind = SfxViewFrame::Current()->GetBindings();
//STRIP001     rBind.ENTERREGISTRATIONS();
//STRIP001     pPopup = new
//STRIP001         SwScrollNaviPopup(FN_SCROLL_NAVIGATION,
//STRIP001                         rBind);
//STRIP001     rBind.LEAVEREGISTRATIONS();
//STRIP001     Point aPos = OutputToScreenPixel(Point(0,0));
//STRIP001     Rectangle aRect(aPos, GetSizePixel());
//STRIP001     pPopup->StartPopupMode(aRect, FLOATWIN_POPUPMODE_LEFT|FLOATWIN_POPUPMODE_ALLOWTEAROFF);
//STRIP001 }
/*-----------------21.02.97 09:41-------------------

--------------------------------------------------*/

//STRIP001 void SwHlpImageButton::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 
//STRIP001 	SetQuickHelpText(SwScrollNaviPopup::GetQuickHelpText(!bUp));
//STRIP001 
//STRIP001 	ImageButton::RequestHelp(rHEvt);
//STRIP001 }

/*-----------------25.02.97 12:38-------------------

--------------------------------------------------*/

//STRIP001 /*N*/ SwNaviImageButton::SwNaviImageButton(Window* pParent) :
//STRIP001 /*N*/ 			ImageButton(pParent, SW_RES(BTN_NAVI)), pPopup(0),
//STRIP001 /*N*/ 			aImage(ResId(IMG_BTN)),
//STRIP001 /*N*/             aImageH(ResId(IMG_BTN_H)),
//STRIP001 /*N*/             sQuickText(ResId(ST_QUICK))
//STRIP001 /*N*/ {
//STRIP001 /*N*/ 	FreeResource();
//STRIP001 /*N*/ 	SetStyle(GetStyle()|WB_NOPOINTERFOCUS);
//STRIP001 /*N*/ 	SetQuickHelpText(sQuickText);
//STRIP001 /*N*/     SetImage( GetDisplayBackground().GetColor().IsDark() ? aImageH : aImage);
//STRIP001 /*N*/ }
/* -----------------------------2002/07/05 9:41-------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwNaviImageButton::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             SetImage( GetDisplayBackground().GetColor().IsDark() ? aImageH : aImage);
//STRIP001 
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }
/* -----------------26.11.2002 09:28-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 class SwZoomBox_Impl : public ComboBox
//STRIP001 {
//STRIP001     USHORT          nSlotId;
//STRIP001     SfxBindings&    rBindings;
//STRIP001     BOOL            bRelease;
//STRIP001 public:
//STRIP001     SwZoomBox_Impl( Window* pParent, USHORT nSlot, SfxBindings& rBind );
//STRIP001     ~SwZoomBox_Impl();
//STRIP001 
//STRIP001 protected:
//STRIP001     virtual void    Select();
//STRIP001     virtual long    Notify( NotifyEvent& rNEvt );
//STRIP001 
//STRIP001     void ReleaseFocus();
//STRIP001 
//STRIP001 };
/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 SwZoomBox_Impl::SwZoomBox_Impl( Window* pParent, USHORT nSlot, SfxBindings& rBind ):
//STRIP001     ComboBox(pParent, SW_RES(RID_PVIEW_ZOOM_LB)),
//STRIP001     nSlotId(nSlot),
//STRIP001     rBindings(rBind),
//STRIP001     bRelease(TRUE)
//STRIP001 {
//STRIP001     EnableAutocomplete( FALSE );
//STRIP001     USHORT aZoomValues[] = 
//STRIP001     {   25, 50, 75, 100, 150, 200 };
//STRIP001     for(USHORT i = 0; i < sizeof(aZoomValues)/sizeof(USHORT); i++)
//STRIP001     {
//STRIP001         String sEntry = String::CreateFromInt32(aZoomValues[i]);
//STRIP001         sEntry += '%';
//STRIP001         InsertEntry(sEntry);
//STRIP001     }                                        
//STRIP001 }
/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 SwZoomBox_Impl::~SwZoomBox_Impl()
//STRIP001 {}        
/* -----------------26.11.2002 09:34-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 void    SwZoomBox_Impl::Select()
//STRIP001 {
//STRIP001     if ( !IsTravelSelect() )
//STRIP001     {
//STRIP001         String sEntry(GetText());
//STRIP001         sEntry.EraseAllChars( '%' );
//STRIP001         USHORT nZoom = (USHORT)sEntry.ToInt32();
//STRIP001         if(nZoom < MINZOOM)
//STRIP001             nZoom = MINZOOM;
//STRIP001         if(nZoom > MAXZOOM)
//STRIP001             nZoom = MAXZOOM;
//STRIP001         SfxUInt16Item aItem( nSlotId, nZoom );
//STRIP001         rBindings.GetDispatcher()->Execute(
//STRIP001             nSlotId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001         ReleaseFocus();
//STRIP001     }
//STRIP001 }            
/* -----------------02.12.2002 07:49-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 long SwZoomBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001     long nHandled = 0;
//STRIP001 
//STRIP001     if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001     {
//STRIP001         USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
//STRIP001 
//STRIP001         switch ( nCode )
//STRIP001         {
//STRIP001             case KEY_RETURN:
//STRIP001             case KEY_TAB:
//STRIP001             {
//STRIP001                 if ( KEY_TAB == nCode )
//STRIP001                     bRelease = FALSE;
//STRIP001                 else
//STRIP001                     nHandled = 1;
//STRIP001                 Select();
//STRIP001                 break;
//STRIP001             }
//STRIP001 
//STRIP001             case KEY_ESCAPE:
//STRIP001                 SetText( GetSavedValue() );
//STRIP001                 ReleaseFocus();
//STRIP001                 break;
//STRIP001         }
//STRIP001     }
//STRIP001     else if ( EVENT_LOSEFOCUS == rNEvt.GetType() )
//STRIP001     {
//STRIP001         Window* pFocusWin = Application::GetFocusWindow();
//STRIP001         if ( !HasFocus() && GetSubEdit() != pFocusWin )
//STRIP001             SetText( GetSavedValue() );
//STRIP001     }
//STRIP001 
//STRIP001     return nHandled ? nHandled : ComboBox::Notify( rNEvt );
//STRIP001 }
/* -----------------02.12.2002 07:51-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 void SwZoomBox_Impl::ReleaseFocus()
//STRIP001 {
//STRIP001     if ( !bRelease )
//STRIP001     {
//STRIP001         bRelease = TRUE;
//STRIP001         return;
//STRIP001     }
//STRIP001     SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 
//STRIP001     if ( pCurSh )
//STRIP001     {
//STRIP001         Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001         if ( pShellWnd )
//STRIP001             pShellWnd->GrabFocus();
//STRIP001     }
//STRIP001 }

/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SwPreviewZoomControl, SfxUInt16Item);

/*N*/ SwPreviewZoomControl::SwPreviewZoomControl( USHORT nId,
/*N*/                                     ToolBox& rTbx,
/*N*/                                     SfxBindings& rBind ) :
/*N*/         SfxToolBoxControl( nId, rTbx, rBind )
/*N*/ {
/*N*/ }
/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
/*N*/ SwPreviewZoomControl::~SwPreviewZoomControl()
/*N*/ {
/*N*/ }    
/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 void SwPreviewZoomControl::StateChanged( USHORT nSID,
//STRIP001                                               SfxItemState eState,
//STRIP001                                               const SfxPoolItem* pState )
//STRIP001 {
//STRIP001     USHORT nId = GetId();
//STRIP001     GetToolBox().EnableItem( nId, (GetItemState(pState) != SFX_ITEM_DISABLED) );
//STRIP001     SwZoomBox_Impl* pBox = (SwZoomBox_Impl*)GetToolBox().GetItemWindow( GetId() );
//STRIP001     if(SFX_ITEM_AVAILABLE <= eState)
//STRIP001     {        
//STRIP001         String sZoom(String::CreateFromInt32(((const SfxUInt16Item*)pState)->GetValue()));
//STRIP001         sZoom += '%';
//STRIP001         pBox->SetText(sZoom);
//STRIP001         pBox->SaveValue();
//STRIP001     }
//STRIP001 }    
/* -----------------26.11.2002 09:29-----------------
 * 
 * --------------------------------------------------*/
//STRIP001 Window* SwPreviewZoomControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001     SwZoomBox_Impl* pRet = new SwZoomBox_Impl(pParent, GetId(), GetBindings());
//STRIP001     return pRet;
//STRIP001 }


}
