/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_gdisurface.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:28:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_GDISURFACE_HXX
#define _DXCANVAS_GDISURFACE_HXX

#include <dx_winstuff.hxx>
#include <dx_surface.hxx>

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

namespace dxcanvas
{
	/* Definition of GdiSurface interface */     
    class GdiSurface : public Surface
    {
    public:
        GdiSurface( const SurfaceGraphicsSharedPtr& rGraphics );
        
        virtual ~GdiSurface();

        /** Request a Gdiplus::Graphics by means of a SurfaceGraphics
            for this surface

        	The Graphics is wrapped in a RAII class, which
        	transparently handles resource release when getting
        	destroyed.

        	@return a SurfaceGraphics for this surface, which might be
        	non-functional if something went wrong.
         */
        virtual SurfaceGraphicsSharedPtr getGraphics();

    private:
        SurfaceGraphicsSharedPtr	mpGraphics;
    };

    typedef ::boost::shared_ptr< GdiSurface > 	GdiSurfaceSharedPtr;

}

#endif /* _DXCANVAS_GDISURFACE_HXX */
