/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FStatement.hxx,v $
 *
 *  $Revision: 1.21 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:09:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_FILE_OSTATEMENT_HXX_
#define _CONNECTIVITY_FILE_OSTATEMENT_HXX_

#ifndef _COM_SUN_STAR_SDBC_XSTATEMENT_HPP_
#include <com/sun/star/sdbc/XStatement.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XWARNINGSSUPPLIER_HPP_
#include <com/sun/star/sdbc/XWarningsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XMULTIPLERESULTS_HPP_
#include <com/sun/star/sdbc/XMultipleResults.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XBATCHEXECUTION_HPP_
#include <com/sun/star/sdbc/XBatchExecution.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCLOSEABLE_HPP_
#include <com/sun/star/sdbc/XCloseable.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_SQLWARNING_HPP_
#include <com/sun/star/sdbc/SQLWarning.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCANCELLABLE_HPP_
#include <com/sun/star/util/XCancellable.hpp>
#endif
#ifndef _COMPHELPER_PROPERTY_ARRAY_HELPER_HXX_
#include <comphelper/proparrhlp.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE3_HXX_
#include <cppuhelper/compbase3.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _CONNECTIVITY_COMMONTOOLS_HXX_
#include "connectivity/CommonTools.hxx"
#endif
#ifndef _CONNECTIVITY_FILE_OCONNECTION_HXX_
#include "file/FConnection.hxx"
#endif
#ifndef _LIST_
#include <list>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COMPHELPER_PROPERTYCONTAINER_HXX_
#include <comphelper/propertycontainer.hxx>
#endif
#ifndef _CONNECTIVITY_FILE_FANALYZER_HXX_
#include "file/fanalyzer.hxx"
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#define SQL_COLUMN_NOTFOUND STRING_NOTFOUND

namespace connectivity
{
	namespace file
	{
		class OResultSet;
		class OFileTable;
        typedef ::cppu::WeakComponentImplHelper3<   ::com::sun::star::sdbc::XWarningsSupplier,
                                                    ::com::sun::star::util::XCancellable,
                                                    ::com::sun::star::sdbc::XCloseable> OStatement_BASE;

		//**************************************************************
		//************ Class: java.sql.Statement
		//**************************************************************
		class OStatement_Base		:	public	comphelper::OBaseMutex,
										public	OStatement_BASE,
										public	::comphelper::OPropertyContainer,
										public	::comphelper::OPropertyArrayUsageHelper<OStatement_Base>

		{
		protected:
			::std::vector<sal_Int32>					m_aColMapping; // pos 0 is unused so we don't have to decrement 1 everytime
			::std::vector<sal_Int32>					m_aParameterIndexes; // maps the parameter index to column index
			::std::vector<sal_Int32>					m_aOrderbyColumnNumber;
			::std::vector<sal_Int16>					m_aOrderbyAscending;

			::com::sun::star::sdbc::SQLWarning                                           m_aLastWarning;
			::com::sun::star::uno::WeakReference< ::com::sun::star::sdbc::XResultSet>    m_xResultSet;   // The last ResultSet created
			::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData> m_xDBMetaData;
			::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess>	 m_xColNames; // table columns															//  for this Statement
		

			connectivity::OSQLParser					m_aParser;
			connectivity::OSQLParseTreeIterator			m_aSQLIterator;

			OConnection*								m_pConnection;// The owning Connection object
			connectivity::OSQLParseNode*				m_pParseTree;
			OSQLAnalyzer*								m_pSQLAnalyzer; //the sql analyzer used by the resultset

			::std::vector<sal_Int32>*					m_pEvaluationKeySet;

			OFileTable*									m_pTable;		// the current table
			OValueRefRow								m_aSelectRow;
			OValueRefRow								m_aRow;
			OValueRefRow								m_aEvaluateRow; // contains all values of a row
			ORefAssignValues							m_aAssignValues; // needed for insert,update and parameters
																	// to compare with the restrictions

			::rtl::OUString								m_aCursorName;
			sal_Int32									m_nMaxFieldSize;
			sal_Int32									m_nMaxRows;
			sal_Int32									m_nQueryTimeOut;
			sal_Int32									m_nFetchSize;
			sal_Int32									m_nResultSetType;
			sal_Int32									m_nFetchDirection;
			sal_Int32									m_nResultSetConcurrency;
			sal_Bool									m_bEscapeProcessing;
			
		protected:
			// initialize the column index map (mapping select columns to table columns)
			void createColumnMapping();
			// searches the statement for sort criteria
			void anylizeSQL();
			void setOrderbyColumn( connectivity::OSQLParseNode* pColumnRef,
									 connectivity::OSQLParseNode* pAscendingDescending);
			
			virtual void initializeResultSet(OResultSet* _pResult);
			// create the analyzer
			virtual OSQLAnalyzer* createAnalyzer();

            void reset () throw( ::com::sun::star::sdbc::SQLException);
            void clearMyResultSet () throw( ::com::sun::star::sdbc::SQLException);
            void setWarning (const  ::com::sun::star::sdbc::SQLWarning &ex) throw( ::com::sun::star::sdbc::SQLException);
			sal_Int32 getPrecision ( sal_Int32 sqlType);

			void disposeResultSet();
			void GetAssignValues();
			void SetAssignValue(const String& aColumnName,
								   const String& aValue,
								   BOOL bSetNull = FALSE,
								   UINT32 nParameter=SQL_NO_PARAMETER);
			void ParseAssignValues(	const ::std::vector< String>& aColumnNameList,
									connectivity::OSQLParseNode* pRow_Value_Constructor_Elem,xub_StrLen nIndex);

			virtual void parseParamterElem(const String& _sColumnName,OSQLParseNode* pRow_Value_Constructor_Elem);
			// factory method for resultset's
			virtual OResultSet* createResultSet() = 0;
			// OPropertyArrayUsageHelper
			virtual ::cppu::IPropertyArrayHelper* createArrayHelper( ) const;
			// OPropertySetHelper
			virtual ::cppu::IPropertyArrayHelper & SAL_CALL getInfoHelper();
			virtual ~OStatement_Base();
		public:
			connectivity::OSQLParseNode* getParseTree() const { return m_pParseTree;}

			::cppu::OBroadcastHelper& rBHelper;
			OStatement_Base(OConnection* _pConnection );

			OConnection* getOwnConnection() const { return m_pConnection;}

			using OStatement_BASE::operator ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >;
			
			virtual void construct(const ::rtl::OUString& sql)  throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);

			// OComponentHelper
			virtual void SAL_CALL disposing(void);
			// XInterface
            //      virtual void SAL_CALL release() throw(::com::sun::star::uno::RuntimeException) = 0;
			virtual void SAL_CALL acquire() throw();
			// XInterface
            virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType ) throw(::com::sun::star::uno::RuntimeException);
			//XTypeProvider
            virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw(::com::sun::star::uno::RuntimeException);

			// XPropertySet
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException);
			// XWarningsSupplier
            virtual ::com::sun::star::uno::Any SAL_CALL getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			// XCancellable
            virtual void SAL_CALL cancel(  ) throw(::com::sun::star::uno::RuntimeException);
			// XCloseable
            virtual void SAL_CALL close(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
		};

		class OStatement_BASE2 :	public OStatement_Base,
									public connectivity::OSubComponent<OStatement_BASE2, OStatement_BASE>

		{
			friend class connectivity::OSubComponent<OStatement_BASE2, OStatement_BASE>;
		public:
			OStatement_BASE2(OConnection* _pConnection ) :  OStatement_Base(_pConnection ),
									connectivity::OSubComponent<OStatement_BASE2, OStatement_BASE>((::cppu::OWeakObject*)_pConnection, this){}
			// OComponentHelper
			virtual void SAL_CALL disposing(void);
			// XInterface
            virtual void SAL_CALL release() throw();
		};

		typedef ::cppu::ImplHelper2< ::com::sun::star::sdbc::XStatement,::com::sun::star::lang::XServiceInfo > OStatement_XStatement;
		class OStatement :	public OStatement_BASE2,
							public OStatement_XStatement
		{
		protected:
			// factory method for resultset's
			virtual OResultSet* createResultSet();
		public:
			// ein Konstruktor, der fuer das Returnen des Objektes benoetigt wird:
			OStatement( OConnection* _pConnection) : OStatement_BASE2( _pConnection){}
			DECLARE_SERVICE_INFO();

            virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType ) throw(::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL acquire() throw();
            virtual void SAL_CALL release() throw();

			// XStatement
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet > SAL_CALL executeQuery( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException) ;
            virtual sal_Int32 SAL_CALL executeUpdate( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException) ;
            virtual sal_Bool SAL_CALL execute( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException) ;
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > SAL_CALL getConnection(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException) ;
		};
	}
}
#endif // _CONNECTIVITY_FILE_OSTATEMENT_HXX_

