/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudraw.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:22:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>
#ifndef _SVDOCIRC_HXX
#include <svx/svdocirc.hxx>
#endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
#include "schresid.hxx"
#include "objid.hxx"
#include "fudraw.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#include "schgroup.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "datapoin.hxx"
#include <svx/svxids.hrc>
#include "undmovsize.hxx"
#include "undmovpieseg.hxx"

TYPEINIT1(SchFuDraw, SchFuPoor);


/*************************************************************************
|*
|* Basisklasse fuer alle Drawmodul-spezifischen Funktionen
|*
\************************************************************************/

SchFuDraw::SchFuDraw(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
			   ChartModel* pDoc, SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq),
	aNewPointer(POINTER_ARROW),
	aOldPointer(POINTER_ARROW),
	bMBDown(FALSE)
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuDraw::~SchFuDraw()
{
	pView->BrkAction();
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL SchFuDraw::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FALSE;

    // guard object to suspend sending broadcasts
    SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );

    switch (rKEvt.GetKeyCode().GetCode())
	{
		case KEY_ESCAPE:
			if (!pView->IsTextEdit())
				if (pView->IsAction())
				{
					pView->BrkAction();
					bReturn = TRUE;
				}
				else if (pView->AreObjectsMarked())
				{
					pView->UnmarkAll();
					pView->SetDragMode( SDRDRAG_MOVE );		// #67766# remove rotation handle
					bReturn = TRUE;
				}
			break;

		case KEY_DELETE:
		case KEY_BACKSPACE:
			if (!pView->IsAction() && !pView->IsTextEdit())
			{
				if (!pView->DeleteMarkedObjects
								(String(SchResId(STR_UNDO_DELETE))))
					InfoBox(&pViewShell->GetViewFrame()->GetWindow(),
							String(SchResId(STR_ACTION_NOTPOSSIBLE))).Execute();
				bReturn = TRUE;
			}
			break;

        case KEY_TAB:
            bReturn = MarkChartObject( rKEvt.GetKeyCode().IsShift()
                                       ? lcl_SELECT_PREVIOUS
                                       : lcl_SELECT_NEXT );
            break;

        case KEY_HOME:
            bReturn = MarkChartObject( lcl_SELECT_FIRST );
            break;

        case KEY_END:
            bReturn = MarkChartObject( lcl_SELECT_LAST );
            break;

        case KEY_LEFT:
        case KEY_RIGHT:
        case KEY_UP:
        case KEY_DOWN:
            {
                lcl_Movement_Direction eDir = lcl_MOVE_LEFT;
                switch( rKEvt.GetKeyCode().GetCode() )
                {
                    case KEY_LEFT:  eDir = lcl_MOVE_LEFT;  break;
                    case KEY_RIGHT: eDir = lcl_MOVE_RIGHT; break;
                    case KEY_UP:    eDir = lcl_MOVE_UP;    break;
                    case KEY_DOWN:  eDir = lcl_MOVE_DOWN;  break;
                }

                // together with 'Alt' move by one pixel
                // otherwise move by 100 units (unit: 100th mm => 1mm)
                if( rKEvt.GetKeyCode().IsMod2() )
                    bReturn = MoveMarkedObject( eDir, 1, true );
                else
                    bReturn = MoveMarkedObject( eDir, 100, false );
            }
            break;

        case KEY_F2:
            {
                // text edit for titles
                const SdrMarkList & rMarkList = pView->GetMarkedObjectList();

                if( rMarkList.GetMarkCount() > 0 )
                {
                    // in the chart you can only select one object (probably a
                    // group) at once
                    SdrObject *   pObj = rMarkList.GetMark( 0 )->GetObj();
                    if( pObj->ISA( SdrTextObj ))
                    {
                        SfxUInt16Item aItem( SID_TEXTEDIT, 2 );
                        pViewShell->GetViewFrame()->GetDispatcher()->
                            Execute( SID_TEXTEDIT, SFX_CALLMODE_ASYNCHRON |
                                     SFX_CALLMODE_RECORD, &aItem, 0L );
                        bReturn = TRUE;
                    }
                }
            }
            break;

        case KEY_F3:
            // Ctrl-F3: leave group
            if( rKEvt.GetKeyCode().IsMod1())
            {
                pView->LeaveOneGroup();
                AdjustHandles( GetCurrentlyMarkedObject() );
                bReturn = TRUE;
            }
            else
            {
                // F3: enter group
                if( MayEnterGroup() )
                {
                    pView->EnterMarkedGroup();
                    bReturn = MarkChartObject( lcl_SELECT_FIRST );
                }
            }
            break;

        case KEY_ADD:
        case KEY_SUBTRACT:
            // try resizing the current object
            if( rKEvt.GetKeyCode().IsMod2())
                bReturn = ResizeMarkedObject( KEY_ADD == rKEvt.GetKeyCode().GetCode()
                                              ?  2
                                              : -2,
                                              true );
            else
                bReturn = ResizeMarkedObject( KEY_ADD == rKEvt.GetKeyCode().GetCode()
                                              ?  200
                                              : -200,
                                              false );

            // if this didn't work try moving a pie
            if( ! bReturn )
            {
                if( rKEvt.GetKeyCode().IsMod2() )
                    bReturn = MovePieSegment( KEY_ADD == rKEvt.GetKeyCode().GetCode(), 1 );
                else
                    bReturn = MovePieSegment( KEY_ADD == rKEvt.GetKeyCode().GetCode(), 5 );
            }
            break;
    }

    if (!bReturn)
		bReturn = SchFuPoor::KeyInput(rKEvt);
	else
		pWindow->ReleaseMouse();

	return bReturn;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseButtonDown(const MouseEvent& rMEvt)
{
	aMDPos = pWindow->PixelToLogic(rMEvt.GetPosPixel());

	ForcePointer(&rMEvt);

	return FALSE;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseMove(const MouseEvent& rMEvt)
{
	ForcePointer(&rMEvt);

	return FALSE;
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL SchFuDraw::MouseButtonUp(const MouseEvent& rMEvt)
{
	ForcePointer(&rMEvt);

	return SchFuPoor::MouseButtonUp (rMEvt);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuDraw::Activate()
{
	SchFuPoor::Activate();

	ForcePointer();
}

/*************************************************************************
|*
|* Maus-Pointer umschalten
|* FG: Bisher (8.3.97) gab es nur einen einzigen Mousepointer und den
|*     brauchte man daher auch nie umschalten. Ab jetzt gibt es auch
|*     Mousepointer die ein Resize andeuten.
|*
\************************************************************************/

void SchFuDraw::ForcePointer(const MouseEvent* pMEvt)
{
	if (pMEvt != NULL)
	{
		USHORT nModifier = 0;
		BOOL bLeftDown = FALSE;
		BOOL bAllowChange=TRUE;
		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();

		Point aPnt(pWindow->PixelToLogic(pMEvt->GetPosPixel()));
		nModifier = pMEvt->GetModifier();
		bLeftDown = pMEvt->IsLeft();

		Pointer aPointer = pView->GetPreferedPointer(aPnt, pWindow,
														  nModifier, bLeftDown);
		if( aPointer.GetStyle() == POINTER_TEXT )
		{
			SdrObject*   pObj = NULL;
			SdrPageView* pPV  = pView->GetPageViewPvNum (0);

			pView->PickObj(aMDPos,nHitLog,pObj,pPV);

			if(pObj)
			{

				SchObjectId* pId = GetObjectId(*pObj);
				if (pId)switch(pId->GetObjId())
				{

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB :
					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
						break;
					default:
						bAllowChange=FALSE;
					break;
				}
			}
		}
		if( aPointer.GetStyle() == POINTER_MOVE )
		{
			SdrObject*   pObj = NULL;
			SdrPageView* pPV  = pView->GetPageViewPvNum (0);

			pView->PickObj(aMDPos,nHitLog,pObj,pPV);

			if(pObj)
			{
				SchObjectId* pId = GetObjectId(*pObj);
				if (pId)switch(pId->GetObjId())
				{

					case CHOBJID_LEGEND_SYMBOL_ROW:
					case CHOBJID_LEGEND_SYMBOL_COL:
						aPointer=Pointer(POINTER_ARROW);
						break;
					default:
					break;
				}
			}
		}

        // there is no point-editing in a chart
        if( aPointer.GetStyle() == POINTER_MOVEPOINT )
        {
            aPointer = Pointer( POINTER_ARROW );
        }


		switch(aPointer.GetStyle())
		{
		case POINTER_DRAW_BEZIER:
		case POINTER_HAND:
		case POINTER_MOVEBEZIERWEIGHT:
			 bAllowChange=FALSE;
		default: break;
		}

		if(bAllowChange)
			pWindow->SetPointer(aPointer);
	}
}

/*************************************************************************
|*
|* Reaktion auf Doppelklick
|*
\************************************************************************/

void SchFuDraw::DoubleClick()
{
	if (pView->AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = pView->GetMarkedObjectList();

		if (rMarkList.GetMarkCount() == 1)
		{
			SdrObject   *pObj   = rMarkList.GetMark(0)->GetObj();
			SchObjectId *pObjId = GetObjectId(*pObj);

			if (pObjId)
			{
				USHORT nId = 0;
				switch( pObjId->GetObjId() )
				{
					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
					case CHOBJID_TITLE_MAIN :
					case CHOBJID_TITLE_SUB :
						nId = SID_TEXTEDIT;
						break;

					case CHOBJID_DIAGRAM_FLOOR :
						nId = SID_DIAGRAM_FLOOR;
						break;

					case CHOBJID_DIAGRAM_WALL :
					case CHOBJID_DIAGRAM :
						if (pChDoc->IsAxisChart () && !pChDoc->IsNetChart ()) nId = SID_DIAGRAM_WALL;
						break;

					case CHOBJID_LEGEND :
						nId = SID_LEGEND;
						break;

					case CHOBJID_DIAGRAM_X_GRID_MAIN :
					case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_X_MAIN;
						break;

					case CHOBJID_DIAGRAM_X_GRID_HELP :
					case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_X_HELP;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_MAIN :
					case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_Y_MAIN;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_HELP :
					case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_Y_HELP;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_MAIN :
					case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
						nId = SID_DIAGRAM_GRID_Z_MAIN;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_HELP :
					case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
						nId = SID_DIAGRAM_GRID_Z_HELP;
						break;

					case CHOBJID_DIAGRAM_X_AXIS :
						nId = SID_DIAGRAM_AXIS_X;
						break;

					case CHOBJID_DIAGRAM_Y_AXIS :
						nId = SID_DIAGRAM_AXIS_Y;
						break;

					case CHOBJID_DIAGRAM_Z_AXIS :
						nId = SID_DIAGRAM_AXIS_Z;
						break;

					case CHOBJID_DIAGRAM_A_AXIS :
						nId = SID_DIAGRAM_AXIS_A;
						break;

					case CHOBJID_DIAGRAM_B_AXIS :
						nId = SID_DIAGRAM_AXIS_B;
						break;

					case CHOBJID_DIAGRAM_C_AXIS :
						nId = SID_DIAGRAM_AXIS_C;
						break;

					case CHOBJID_DIAGRAM_AREA:
					case CHOBJID_AREA :
						nId = SID_DIAGRAM_AREA;
						break;

					case CHOBJID_DIAGRAM_DATA :
					case CHOBJID_DIAGRAM_SPECIAL_GROUP :
					case CHOBJID_DIAGRAM_ROWGROUP :
					case CHOBJID_DIAGRAM_ROWSLINE :
					case CHOBJID_LEGEND_SYMBOL_ROW :
					case CHOBJID_LEGEND_SYMBOL_COL :
						nId = SID_DATA_ROW_POINT;
						break;

					case CHOBJID_DIAGRAM_STATISTICS_GROUP :
						nId = SID_DIAGRAM_ERROR;
						break;

					case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
						nId = SID_DIAGRAM_STOCK_LOSS;
						break;
					case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
						nId = SID_DIAGRAM_STOCK_PLUS;
						break;
					//case CHOBJID_DIAGRAM_STOCKLINE:
					case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
						nId = SID_DIAGRAM_STOCK_LINE;
						break;

					case CHOBJID_DIAGRAM_AVERAGEVALUE :
						nId = SID_DIAGRAM_AVERAGEVALUE;
						break;

					case CHOBJID_DIAGRAM_REGRESSION :
						nId = SID_DIAGRAM_REGRESSION;
						break;

					default :
						nId = 0;
						break;

				}

				if( nId > 0 )
					pViewShell->GetViewFrame()->GetDispatcher()->Execute(nId, SFX_CALLMODE_ASYNCHRON);
			}
		}
	}
}

// ========================================
// Methods for selecting and moving objects
// with the keyboard
// ========================================

BOOL SchFuDraw::MarkChartObject( lcl_Selection_Direction eDirection, int nDepth, bool bEnterDiagram )
{
    BOOL bInvertNavigation = FALSE;
    BOOL bInRange = TRUE;

    // avoid infinite loop
    // a depth up to 3 may happen regularly
    // (next => first => validity check: next)
    DBG_ASSERT( nDepth < 3, "There seem to be no valid objects in the current group" );
    if( nDepth >= 3 )
        return FALSE;

    pView->SetMarkHdlHidden( TRUE );

    switch( eDirection )
    {
        case  lcl_SELECT_NEXT:
            // if diagram is selected then enter it
            if( bEnterDiagram )
            {
                SdrObject* pObj = GetCurrentlyMarkedObject();
                if( pObj )
                {
                    // enter group rather than selecting next top-level object
                    // when currently the diagram is selected
                    UINT16 nObjId = CHOBJID_ANY;
                    SchObjectId * pObjId = GetObjectId( *pObj );
                    if( pObjId &&
                        CHOBJID_DIAGRAM == pObjId->GetObjId())
                    {
                        pView->EnterMarkedGroup();
                        MarkChartObject( lcl_SELECT_FIRST, nDepth + 1, false );
                        break;
                    }
                }
            }

            // select next valid object
            do
            {
                bInRange = pView->MarkNextObj( bInvertNavigation );
            }
            while( bInRange && ! ValidObjectSelected() );

            // if there is no next object go back to the first one
            // except if we are in the diagram, then leave group and
            // select the next object after the diagram
            if( ! bInRange )
            {
                SdrObject* pObj = GetCurrentlyMarkedObject();
                if( pObj )
                {
                    pObj = pObj->GetUpGroup();
                    if( pObj )
                    {
                        UINT16 nObjId = CHOBJID_ANY;
                        SchObjectId * pObjId = GetObjectId( *pObj );
                        if( pObjId &&
                            CHOBJID_DIAGRAM == pObjId->GetObjId())
                        {
                            pView->LeaveOneGroup();
                            // select next element after diagram
                            MarkChartObject( lcl_SELECT_NEXT, nDepth + 1, false );
                            break;
                        }
                    }
                }
                MarkChartObject( lcl_SELECT_FIRST, nDepth + 1 );
            }
            break;
        case lcl_SELECT_PREVIOUS:
            // select previous valid object
            do
            {
                bInRange = pView->MarkNextObj( ! bInvertNavigation );
            }
            while( bInRange && ! ValidObjectSelected() );

            // if we reach the diagram then enter it and select the
            // last group member
            if( bEnterDiagram )
            {
                SdrObject* pObj = GetCurrentlyMarkedObject();
                if( pObj )
                {
                    UINT16 nObjId = CHOBJID_ANY;
                    SchObjectId * pObjId = GetObjectId( *pObj );
                    if( pObjId &&
                        CHOBJID_DIAGRAM == pObjId->GetObjId())
                    {
                        pView->EnterMarkedGroup();
                        MarkChartObject( lcl_SELECT_LAST, nDepth + 1, false );
                        break;
                    }
                }
            }

            // if there is no previous object go forward to the last
            // one except if we are in the diagram, then leave group
            // so that the diagram gets selected
            if( ! bInRange )
            {
                SdrObject* pObj = GetCurrentlyMarkedObject();
                pObj = pObj->GetUpGroup();
                if( pObj )
                {
                    UINT16 nObjId = CHOBJID_ANY;
                    SchObjectId * pObjId = GetObjectId( *pObj );
                    if( pObjId &&
                        CHOBJID_DIAGRAM == pObjId->GetObjId())
                    {
                        // select diagram
                        pView->LeaveOneGroup();
                        AdjustHandles( GetCurrentlyMarkedObject() );
                        break;
                    }
                }
                MarkChartObject( lcl_SELECT_LAST, nDepth + 1 );
            }
            break;
        case lcl_SELECT_LAST:
            // got to last object
            while( pView->MarkNextObj( bInvertNavigation ));
            // go back to first valid one
            if( ! ValidObjectSelected() )
                MarkChartObject( lcl_SELECT_PREVIOUS, nDepth + 1 );
            break;
        case lcl_SELECT_FIRST:
            // go to first object
            while( pView->MarkNextObj( ! bInvertNavigation ));
            // advance to first valid one
            if( ! ValidObjectSelected() )
                MarkChartObject( lcl_SELECT_NEXT, nDepth + 1 );
            break;
    }

    pView->SetMarkHdlHidden( FALSE );
    return TRUE;
}

bool SchFuDraw::ValidObjectSelected()
{
    SdrObject* pObj = GetCurrentlyMarkedObject();
    
    if( NULL == pObj )
        return false;

    UINT16 nObjId = CHOBJID_ANY;
    SchObjectId * pObjId = GetObjectId( *pObj );
    if( pObjId )
        nObjId = pObjId->GetObjId();

    bool bResult = ! ( ( CHOBJID_ANY == nObjId )
                       || ( CHOBJID_DIAGRAM_DESCRGROUP == nObjId )
                       || ( CHOBJID_DIAGRAM_ROWSLINE  == nObjId ) );

    if( bResult )
    {
        if( pObj->IsGroupObject() &&
            ! pObj->ISA( E3dCompoundObject ) &&
            0 == pObj->GetSubList()->GetObjCount())
        {
            bResult = false;
        }
        else
        {
            AdjustHandles( pObj );
        }
    }
    return bResult;
}

void SchFuDraw::AdjustHandles( SdrObject* pObj )
{
    if( NULL == pObj )
        return;

    if( pObj->ISA( E3dObject ) &&
        pView->GetDragMode() == SDRDRAG_ROTATE )
    {
        pView->SetDragMode( SDRDRAG_MOVE );
    }

    UINT16 nObjId = CHOBJID_ANY;
    SchObjectId * pObjId = GetObjectId( *pObj );
    if( pObjId )
        nObjId = pObjId->GetObjId();

    BOOL bMarkGroupMembers =
        ( ( nObjId == CHOBJID_DIAGRAM_ROWGROUP )
          || ( CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP <= nObjId
               && nObjId <= CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP )
          || ( CHOBJID_DIAGRAM_X_AXIS <= nObjId
               && nObjId <= CHOBJID_DIAGRAM_Z_AXIS )
          || ( CHOBJID_DIAGRAM_A_AXIS <= nObjId
               && nObjId <= CHOBJID_DIAGRAM_C_AXIS )
          || pObj->ISA( E3dCompoundObject ));

    if( pView->IsFrameHandles() == bMarkGroupMembers )
    {
        pView->SetFrameDragSingles( ! bMarkGroupMembers );
        pView->SetMarkHdlHidden( TRUE );
        pView->SetMarkHdlHidden( FALSE );
    }
}

BOOL SchFuDraw::MoveMarkedObject( lcl_Movement_Direction eDirection, long nAmount, bool bPixel  )
{
    BOOL bResult = FALSE;
    SdrObject* pObj = GetCurrentlyMarkedObject();

    if( NULL != pObj )
    {
        SchObjectId * pObjId = GetObjectId( *pObj );

        bool bMayMove = ! pObj->IsMoveProtect();

        // dragging of pie segments
        if( bMayMove &&
            pObjId && CHOBJID_DIAGRAM_DATA == pObjId->GetObjId() &&
            pChDoc && pChDoc->IsPieChart() &&
            ! pChDoc->Is3DChart() &&
            pObj->ISA( SdrCircObj ))
        {
            // emulate pie dragging like in drag method
            // one press moves SCH_PIE_DRAG_AMOUNT percent
            SdrCircObj* pPie = static_cast< SdrCircObj* >( pObj );

            // determine angle of the bisector of the segment
            long nStartAngle = pPie->GetStartWink(),
                nEndAngle = pPie->GetEndWink();
            if( nStartAngle > nEndAngle )
                nEndAngle += 36000;
            long nAngle = (nStartAngle + nEndAngle) / 2;

            // direction in which to move
            bool bOut =true;
            switch( eDirection )
            {
                case lcl_MOVE_LEFT:
                case lcl_MOVE_RIGHT:
                    if( 9000 <= nAngle && nAngle <= 27000 )
                        bOut = ( lcl_MOVE_LEFT == eDirection );
                    else
                        bOut = ( lcl_MOVE_RIGHT == eDirection );
                    break;
                case lcl_MOVE_UP:
                case lcl_MOVE_DOWN:
                    if( 0 <= nAngle && nAngle <= 18000 )
                        bOut = ( lcl_MOVE_UP == eDirection );
                    else
                        bOut = ( lcl_MOVE_DOWN == eDirection );
                    break;
            }
            bResult = MovePieSegment( bOut, ( bPixel ? nAmount : nAmount / 20 ));
        }
        else if( bMayMove )
        {
            long nShiftX = 0;
            long nShiftY = 0;

            long nAmountX = nAmount;
            long nAmountY = nAmount;

            if( bPixel )
            {
                Size aPixelSize = pWindow->PixelToLogic( Size( nAmount, nAmount ));
                nAmountX = aPixelSize.Width();
                nAmountY = aPixelSize.Height();
            }

            switch( eDirection )
            {
                case lcl_MOVE_LEFT:
                    nShiftX -= nAmountX;
                    break;
                case lcl_MOVE_RIGHT:
                    nShiftX += nAmountX;
                break;
                case lcl_MOVE_UP:
                    nShiftY -= nAmountY;
                    break;
                case lcl_MOVE_DOWN:
                    nShiftY += nAmountY;
                    break;
            }
            Rectangle aNewBoundRect( pObj->GetCurrentBoundRect() );
            aNewBoundRect.Move( nShiftX, nShiftY );
            if( pView->GetWorkArea().IsInside( aNewBoundRect ))
            {
				//create undo
				if( pObjId )
				{
					UINT16 nUndoObjId(pObjId->GetObjId());
					Rectangle aOldUndoRect(pObj->GetCurrentBoundRect());
					Rectangle aNewUndoRect(aNewBoundRect);

					SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize(
							*pChDoc, nUndoObjId, aOldUndoRect, aNewUndoRect );
					pUndo->SetCommentTemplate(STR_UNDO_MOVE);
					pViewShell->GetViewFrame()->GetObjectShell()->
						GetUndoManager()->AddUndoAction(pUndo);
				}

                Size aDist( nShiftX, nShiftY );
                pObj->Move( aDist );

                ApplyMoveResizeChanges();
                bResult = TRUE;
            }
        }
    }

    return bResult;
}

BOOL SchFuDraw::ResizeMarkedObject( long nAmount, bool bPixel )
{
    BOOL bResult = FALSE;

    SdrObject* pObj = GetCurrentlyMarkedObject();
    if( NULL != pObj )
    {
        SchObjectId * pObjId = GetObjectId( *pObj );
        if( pObjId && CHOBJID_DIAGRAM == pObjId->GetObjId())
        {
            long nAmountX = nAmount;
            long nAmountY = nAmount;

            if( bPixel )
            {
                Size aPixelSize = pWindow->PixelToLogic( Size( nAmount, nAmount ));
                nAmountX = aPixelSize.Width();
                nAmountY = aPixelSize.Height();
            }

            Rectangle aRect = pObj->GetSnapRect();
            Size aSize = aRect.GetSize();
            long nWidth = aSize.getWidth();
            long nHeight = aSize.getHeight();
            double fAspect = (double)nWidth / (double)nHeight;

            if( fAspect >= 1.0 )
                nAmountY = (long)((double)nAmountX / fAspect);
            else
                nAmountX = (long)((double)nAmountY * fAspect);

            if( 0 != nAmountX &&
                0 != nAmountY )
            {
                aSize.setWidth( nWidth + nAmountX );
                aSize.setHeight( nHeight + nAmountY );
                aRect.SetSize( aSize );

                aRect.Move( - nAmountX / 2, - nAmountY / 2 );

				//create undo
				{
					UINT16 nUndoObjId(pObjId->GetObjId());
					Rectangle aOldUndoRect(pObj->GetSnapRect());
					Rectangle aNewUndoRect(aRect);

					SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize(
							*pChDoc, CHOBJID_DIAGRAM
							, aOldUndoRect, aNewUndoRect );
					pUndo->SetCommentTemplate(STR_UNDO_RESIZE);
					pViewShell->GetViewFrame()->GetObjectShell()->
						GetUndoManager()->AddUndoAction(pUndo);
				}

                pObj->SetSnapRect( aRect );
                ApplyMoveResizeChanges();
                bResult = TRUE;
            }
        }
    }
    return bResult;
}

BOOL SchFuDraw::MovePieSegment( bool bOut, long nAmount )
{
    BOOL bResult = FALSE;
    SdrObject* pObj = GetCurrentlyMarkedObject();

    if( NULL != pObj )
    {
        SchObjectId * pObjId = GetObjectId( *pObj );

        // dragging of pie segments
        if( ! pObj->IsMoveProtect() &&
            pObjId && CHOBJID_DIAGRAM_DATA == pObjId->GetObjId() &&
            pChDoc && pChDoc->IsPieChart() &&
            ! pChDoc->Is3DChart())
        {
            SchDataPoint* pPoint = GetDataPoint( *pObj );
            DBG_ASSERT( pPoint, "Pie has no data point user data" );

            if( pPoint )
            {
                long nCol = pPoint->GetCol();
                long nOldSegOf = pChDoc->PieSegOfs( nCol );
                long nNewSegOf = nOldSegOf;

                if( bOut )
                    nNewSegOf += nAmount;
                else
                    nNewSegOf -= nAmount;

                // bound value
                if( nNewSegOf < 0)
                    nNewSegOf = 0;
                else if( nNewSegOf > 100 )
                    nNewSegOf = 100;

                // change offset
                if( nOldSegOf != nNewSegOf )
                {
                    pChDoc->SetPieSegOfs( nCol, nNewSegOf );
                    pChDoc->BuildChart( FALSE );

                    // remark pie object
                    SdrPageView* pPV  = pView->GetPageViewPvNum (0);
                    if( pPV )
                    {
                        pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage( 0 ), 0, IM_DEEPWITHGROUPS ), pPV );
                        pView->EnterMarkedGroup();
                        pView->MarkObj( pChDoc->GetDataPointObj( nCol, 0 ), pPV );
                    }
                    bResult = TRUE;

					//create undo
					{
						SfxUndoAction* pUndo = new SchUndoMovePieSeg( *pChDoc, nCol
									, nOldSegOf, nNewSegOf );
						pViewShell->GetViewFrame()->GetObjectShell()->
								GetUndoManager()->AddUndoAction(pUndo);
					}
                }
            }
        }
    }
    return bResult;
}

bool SchFuDraw::MayEnterGroup()
{
    bool bResult = false;

    // get object and id
    SdrObject* pObj = GetCurrentlyMarkedObject();
    
    if( NULL != pObj )
    {
        UINT16 nObjId = CHOBJID_ANY;
        SchObjectId * pObjId = GetObjectId( *pObj );
        if( pObjId )
            nObjId = pObjId->GetObjId();

        if( CHOBJID_ANY != nObjId )
        {
            // now allow entering for certain elements
            switch( nObjId )
            {
                case CHOBJID_DIAGRAM:
                case CHOBJID_DIAGRAM_ROWGROUP:
                case CHOBJID_LEGEND:
                    bResult = true;
                    break;
            }
        }
    }

    return bResult;
}

SdrObject* SchFuDraw::GetCurrentlyMarkedObject()
{
    SdrObject* pObj = NULL;
    if( pView )
    {
        const SdrMarkList & rMarkList = pView->GetMarkedObjectList();
        if( rMarkList.GetMarkCount() > 0 )
            pObj = rMarkList.GetMark( 0 )->GetObj();
    }

    return pObj;
}

void SchFuDraw::ApplyMoveResizeChanges()
{
    SdrObject* pObj = GetCurrentlyMarkedObject();

    if( pChDoc &&
        pView )
    {
        pChDoc->SetUseRelativePositions( TRUE );
        if( pObj->ISA( SchObjGroup ) )
        {
            SchObjGroup* pGrp = static_cast< SchObjGroup* >( pObj );
            pGrp->SetGroupMoved( TRUE );
            if( SchObjGroup::DIAGRAM == pGrp->GetGroupType())
            {
                pChDoc->BuildChart( FALSE );
                // remark diagram object
                SdrPageView* pPV  = pView->GetPageViewPvNum( 0 );
                pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage( 0 ), 0, IM_DEEPWITHGROUPS ), pPV );
            }
        }
        else if( pObj->ISA( SdrTextObj ))
        {
            UINT16 nObjId = CHOBJID_ANY;
            SchObjectId * pObjId = GetObjectId( *pObj );
            if( pObjId )
                nObjId = pObjId->GetObjId();

            if( CHOBJID_ANY != nObjId )
                pChDoc->SetHasBeenMoved( nObjId, TRUE );
        }
    }
}
