/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undgraut.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:58:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UNDGRAUT_HXX
#define _SCH_UNDGRAUT_HXX

#include "chtmodel.hxx"
#include "schundo.hxx"

/*************************************************************************
|*
|* Undo fuer Diagramm-Autopilot
|*
\************************************************************************/

class SchUndoDiagramAutoPilot : public SchUndoAction
{
private:
	SvxChartStyle eOldStyle;
//	long nOldGapWidth;
//	long nOldOverlap;
	long* pOldPieSegOfs;
	short nOldPieSegCount;
	BOOL bOldShowMainTitle;
	String aOldMainTitle;
	BOOL bOldShowSubTitle;
	String aOldSubTitle;
	BOOL bOldShowXAxisTitle;
	String aOldXAxisTitle;
	BOOL bOldShowYAxisTitle;
	String aOldYAxisTitle;
	BOOL bOldShowZAxisTitle;
	String aOldZAxisTitle;
	BOOL bOldShowXAxis;
	BOOL bOldShowXGridMain;
	BOOL bOldShowXGridHelp;
	BOOL bOldShowXDescr;
	BOOL bOldShowYAxis;
	BOOL bOldShowYGridMain;
	BOOL bOldShowYGridHelp;
	BOOL bOldShowYDescr;
	BOOL bOldShowZAxis;
	BOOL bOldShowZGridMain;
	BOOL bOldShowZGridHelp;
	BOOL bOldShowZDescr;
	BOOL bOldSwitchData;
	SvxChartLegendPos eOldLegendPos;

	SvxChartStyle eNewStyle;
//	long nNewGapWidth;
//	long nNewOverlap;
	long* pNewPieSegOfs;
	long nNewPieSegCount;
	BOOL bNewShowMainTitle;
	String aNewMainTitle;
	BOOL bNewShowSubTitle;
	String aNewSubTitle;
	BOOL bNewShowXAxisTitle;
	String aNewXAxisTitle;
	BOOL bNewShowYAxisTitle;
	String aNewYAxisTitle;
	BOOL bNewShowZAxisTitle;
	String aNewZAxisTitle;
	BOOL bNewShowXAxis;
	BOOL bNewShowXGridMain;
	BOOL bNewShowXGridHelp;
	BOOL bNewShowXDescr;
	BOOL bNewShowYAxis;
	BOOL bNewShowYGridMain;
	BOOL bNewShowYGridHelp;
	BOOL bNewShowYDescr;
	BOOL bNewShowZAxis;
	BOOL bNewShowZGridMain;
	BOOL bNewShowZGridHelp;
	BOOL bNewShowZDescr;
	BOOL bNewSwitchData;
	BOOL bNewShowLegend;

public:
	TYPEINFO();

	SchUndoDiagramAutoPilot(ChartModel& rChDoc,
							SvxChartStyle eOldStl,/* long nOldGap,
							long nOldOver, */long* pOldSegOfs,
							short nOldSegCount,
							BOOL bOldShowMain, const String& rOldMain,
							BOOL bOldShowSub, const String& rOldSub,
							BOOL bOldShowXAxis, const String& rOldXAxis,
							BOOL bOldShowYAxis, const String& rOldYAxis,
							BOOL bOldShowZAxis, const String& rOldZAxis,
							BOOL bOldXAxis, BOOL bOldXGridMain,
							BOOL bOldXGridHelp, BOOL bOldXDescr,
							BOOL bOldYAxis, BOOL bOldYGridMain,
							BOOL bOldYGridHelp, BOOL bOldYDescr,
							BOOL bOldZAxis, BOOL bOldZGridMain,
							BOOL bOldZGridHelp, BOOL bOldZDescr,
							BOOL bOldSwitch, SvxChartLegendPos eOldLegPos,
							SvxChartStyle eNewStl,/* long nNewGap,
							long nNewOver, */long* pNewSegOfs,
							short nNewSegCount,
							BOOL bNewShowMain, const String& rNewMain,
							BOOL bNewShowSub, const String& rNewSub,
							BOOL bNewShowXAxis, const String& rNewXAxis,
							BOOL bNewShowYAxis, const String& rNewYAxis,
							BOOL bNewShowZAxis, const String& rNewZAxis,
							BOOL bNewXAxis, BOOL bNewXGridMain,
							BOOL bNewXGridHelp, BOOL bNewXDescr,
							BOOL bNewYAxis, BOOL bNewYGridMain,
							BOOL bNewYGridHelp, BOOL bNewYDescr,
							BOOL bNewZAxis, BOOL bNewZGridMain,
							BOOL bNewZGridHelp, BOOL bNewZDescr,
							BOOL bNewSwitch, BOOL bNewLegend) :
		SchUndoAction(rChDoc),
		eOldStyle(eOldStl),
//		nOldGapWidth(nOldGap),
//		nOldOverlap(nOldOver),
		pOldPieSegOfs(pOldSegOfs),
		nOldPieSegCount(nOldSegCount),
		bOldShowMainTitle(bOldShowMain),
		aOldMainTitle(rOldMain),
		bOldShowSubTitle(bOldShowSub),
		aOldSubTitle(rOldSub),
		bOldShowXAxisTitle(bOldShowXAxis),
		aOldXAxisTitle(rOldXAxis),
		bOldShowYAxisTitle(bOldShowYAxis),
		aOldYAxisTitle(rOldYAxis),
		bOldShowZAxisTitle(bOldShowZAxis),
		aOldZAxisTitle(rOldZAxis),
		bOldShowXAxis(bOldXAxis),
		bOldShowXGridMain(bOldXGridMain),
		bOldShowXGridHelp(bOldXGridHelp),
		bOldShowXDescr(bOldXDescr),
		bOldShowYAxis(bOldYAxis),
		bOldShowYGridMain(bOldYGridMain),
		bOldShowYGridHelp(bOldYGridHelp),
		bOldShowYDescr(bOldYDescr),
		bOldShowZAxis(bOldZAxis),
		bOldShowZGridMain(bOldZGridMain),
		bOldShowZGridHelp(bOldZGridHelp),
		bOldShowZDescr(bOldZDescr),
		bOldSwitchData(bOldSwitch),
		eOldLegendPos(eOldLegPos),
		eNewStyle(eNewStl),
//		nNewGapWidth(nNewGap),
//		nNewOverlap(nNewOver),
		pNewPieSegOfs(pNewSegOfs),
		nNewPieSegCount(nNewSegCount),
		bNewShowMainTitle(bNewShowMain),
		aNewMainTitle(rNewMain),
		bNewShowSubTitle(bNewShowSub),
		aNewSubTitle(rNewSub),
		bNewShowXAxisTitle(bNewShowXAxis),
		aNewXAxisTitle(rNewXAxis),
		bNewShowYAxisTitle(bNewShowYAxis),
		aNewYAxisTitle(rNewYAxis),
		bNewShowZAxisTitle(bNewShowZAxis),
		aNewZAxisTitle(rNewZAxis),
		bNewShowXAxis(bNewXAxis),
		bNewShowXGridMain(bNewXGridMain),
		bNewShowXGridHelp(bNewXGridHelp),
		bNewShowXDescr(bNewXDescr),
		bNewShowYAxis(bNewYAxis),
		bNewShowYGridMain(bNewYGridMain),
		bNewShowYGridHelp(bNewYGridHelp),
		bNewShowYDescr(bNewYDescr),
		bNewShowZAxis(bNewZAxis),
		bNewShowZGridMain(bNewZGridMain),
		bNewShowZGridHelp(bNewZGridHelp),
		bNewShowZDescr(bNewZDescr),
		bNewSwitchData(bNewSwitch),
		bNewShowLegend(bNewLegend) {}
	virtual ~SchUndoDiagramAutoPilot();

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;
};

#endif	// _SCH_UNDGRAUT_HXX

