/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbedctrl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:13:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFX_TBEDCTRL_HXX
#define _SFX_TBEDCTRL_HXX

// includes *****************************************************************


#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#include "tbxctrl.hxx"

class Accelerator;


class SfxFrameEdit_Impl : public Edit
{
	USHORT			nId;
	String			aContent;

	virtual void	KeyInput( const KeyEvent& rKeyEvent );
	virtual void	LoseFocus();

public:
					SfxFrameEdit_Impl( Window* pParent, USHORT nSlotId );
	void			SetContent( const String& rContent );
};

class SfxFrameEditToolBoxControl_Impl : public SfxToolBoxControl
{
private:
	SfxFrameEdit_Impl* GetEdit() const
					{ return (SfxFrameEdit_Impl*) GetToolBox().GetItemWindow( GetId() ); }

public:

					SFX_DECL_TOOLBOX_CONTROL();
					SfxFrameEditToolBoxControl_Impl( USHORT nSlotId, USHORT nId, ToolBox& rBox );

	virtual Window* CreateItemWindow( Window* pParent );
	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
};

class SfxFrameNumericField_Impl : public NumericField
{
	String			aCurTxt;

protected:
	virtual void 	Modify();
	void    		GetFocus_Impl();
	void    		LoseFocus_Impl();
	void			KeyInput_Impl( const KeyEvent& rKEvt );
	virtual long	Notify( NotifyEvent& rEvt );
	virtual void    Down();
	virtual void    Up();
	void			Execute();

public:
					SfxFrameNumericField_Impl( Window* pParent,
						WinBits nBits = WB_BORDER | WB_SPIN | WB_REPEAT );
					~SfxFrameNumericField_Impl();
};

class SfxFrameSpacingControl_Impl : public SfxToolBoxControl
{
public:
					SFX_DECL_TOOLBOX_CONTROL();
					SfxFrameSpacingControl_Impl( USHORT nSlotId, USHORT nId, ToolBox& rBox );
	virtual Window* CreateItemWindow( Window* pParent );
	virtual void	StateChanged( USHORT nSID, SfxItemState eState,	const SfxPoolItem* pState );
};


#endif
