/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: contenv.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:25:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif
#ifndef _PSEUDO_HXX //autogen
#include <so3/pseudo.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _IPMENU_HXX //autogen
#include <so3/ipmenu.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#include <svtools/menuoptions.hxx>
#include <com/sun/star/frame/XLayoutManager.hpp>
#include <com/sun/star/frame/XInplaceLayout.hpp>

#ifndef GCC
#pragma hdrstop
#endif

#include "app.hxx"
#include "virtmenu.hxx"
#include "mnumgr.hxx"
#include "stbmgr.hxx"
#include "viewsh.hxx"
#include "dispatch.hxx"
#include "contenv.hxx"
#include "workwin.hxx"
#include "viewfrm.hxx"
#include "appdata.hxx"
#include "docfile.hxx"
#include "topfrm.hxx"
#include "objsh.hxx"

#include <com/sun/star/uno/Reference.hxx>
#include <com/sun/star/frame/XFrame.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/frame/XLayoutManager.hpp>

using namespace com::sun::star::uno;
using namespace com::sun::star;

//=========================================================================

MenuBar * SfxContainerEnv_Impl::QueryMenu
(
	USHORT * pCount0,
	USHORT * pCount1,
	USHORT * pCount2
)
{

	if( !pMenuBar )
	{
        MenuBar*       pAppBar = 0;
        SfxWorkWindow* pWork = pFrame->GetFrame()->GetWorkWindow_Impl();

        if ( pWork )
        {
            SystemWindow* pSysWin = pWork->GetTopWindow();
            if ( pSysWin )
                pAppBar = new MenuBar( *(MenuBar*)pSysWin->GetMenuBar() );
        }

/*

        SfxMenuBarManager *pMMgr = pFrame->GetViewShell()->GetMenuBar_Impl();
        SfxVirtualMenu *pAppMenu = pMMgr->GetMenu();
		MenuBar *pAppBar;

#ifdef OS2
		pAppBar = new MenuBar( *(MenuBar*) pAppMenu->GetSVMenu() );
#else
		pAppBar = (MenuBar*) pAppMenu->GetSVMenu();
#endif
*/
		// Bereich 1: das Datei-Menue
		USHORT nStart0 = 0, nCount0 = 1;

		// Bereich 2: haben wir nicht
		USHORT nStart1 = 0, nCount1 = 0;

		// Bereich 3: das Fenstermenue
		USHORT nPos = pAppBar->GetItemPos( SID_MDIWINDOWLIST );
        if ( nPos == MENU_ITEM_NOTFOUND )
        {
            // We have to search for the unique .uno command now!
            for ( USHORT n = 0; n < pAppBar->GetItemCount(); n++ )
            {
                USHORT nId = pAppBar->GetItemId( n );
                String aCommand = pAppBar->GetItemCommand( nId );
                if ( aCommand.EqualsAscii( ".uno:WindowList" ))
                {
                    nPos = n;
                    break;
                }
            }
        }

		// Die Menue-Konfiguration mu\s sicherstellen, da\s vor dem Dateimenue
		// nichts steht und da\s Datei - und Fenstermenue nicht wegkonfiguriert
		// werden k"onnen !
		// OLE im PlugIn geht davon aus, da\s vom Container genau zwei Menues,
		// Datei und Fenster, an der 1. und einer beliebigen anderen Position
		// im InPlaceMenu stammen.
		DBG_ASSERT( nPos != MENU_ITEM_NOTFOUND, "Wer hat das MDI-Menue geklaut ?!");
		USHORT nStart2 = nPos, nCount2 = 1;

/*
		pAppMenu->InitPopup(0);
		pAppMenu->InitPopup(nStart2);
*/
		pMenuBar = new SvInPlaceMenuBar( pAppBar, nStart0, nCount0, nStart1, nCount1, nStart2, nCount2 );

/*
		if ( pMMgr->GetMenu() )
			pMenuBar->SetSelectHdl( LINK( pMMgr->GetMenu(), SfxVirtualMenu, Select ) );
		else
        		pMenuBar->SetSelectHdl( LINK( pMMgr, SfxMenuManager, Select ) );
*/
		if( SvtMenuOptions().IsEntryHidingEnabled() == sal_False )
			pMenuBar->SetMenuFlags( pMenuBar->GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES );
	}

	return pMenuBar->GetBlocks( pCount0, pCount1, pCount2 );
}

//-------------------------------------------------------------------------
void SfxContainerEnv_Impl::SetInPlaceMenu( MenuBar * pMenu, BOOL bSet )
{
//  DV the rvp office now is started with -appserver -bean
//	if ( SFX_APP()->Get_Impl()->bBean )
//		return;

#if 0
	// the new API should be used to set the menu bar for UI activated object
    SfxTopViewFrame *pTop= PTR_CAST( SfxTopViewFrame, pFrame->GetTopViewFrame() );
    if ( pTop )
    {
        Reference< com::sun::star::beans::XPropertySet > xPropSet( pTop->GetTopFrame_Impl()->GetFrameInterface(), UNO_QUERY );
//        Reference< com::sun::star::beans::XPropertySet > xPropSet( pFrame->GetBindings().GetActiveFrame(), UNO_QUERY );
        Reference< ::com::sun::star::frame::XLayoutManager > xLayoutManager;

	    if ( xPropSet.is() )
	    {
		    Any aValue = xPropSet->getPropertyValue( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "LayoutManager" )));
		    aValue >>= xLayoutManager;
        }

        Reference< ::com::sun::star::frame::XInplaceLayout > xInplaceLayout( xLayoutManager, UNO_QUERY );
        if ( xInplaceLayout.is() )
        {
            if ( bSet )
                xInplaceLayout->setInplaceMenuBar( (sal_Int64)pMenu );
            else
                xInplaceLayout->resetInplaceMenuBar();
        }
    }
#endif
/*
	SfxApplication *pSfxApp = SFX_APP();
	if( !bSet)
	{
		// AppMenue wieder zur"ucksetzen
        //pMenu = (MenuBar*) pFrame->GetViewShell()->GetMenuBar_Impl()->GetMenu()->GetSVMenu();
        pFrame->GetViewShell()->GetMenuBar_Impl();
    }

    SfxTopViewFrame *pTop= PTR_CAST( SfxTopViewFrame, pFrame->GetTopViewFrame() );
    if ( pTop )
        pTop->GetTopFrame_Impl()->SetMenuBar_Impl( pMenu );
*/
}

//-------------------------------------------------------------------------

void SfxContainerEnv_Impl::MenuReleased()
{
	DELETEZ( pMenuBar );
}

//-------------------------------------------------------------------------

SfxContainerEnv_Impl::~SfxContainerEnv_Impl()
{
}

//-------------------------------------------------------------------------

SfxContainerEnv_Impl::SfxContainerEnv_Impl
(
	SfxInPlaceClient* 	pClient,
	SfxViewFrame*		pViewFrame,
	WorkWindow*			pTopWin,
	Window* 			pEditWin
)
:	SvContainerEnvironment( pClient, pTopWin,
//			(WorkWindow*) &( pViewFrame->GetParentViewFrame_Impl() ?
//			pViewFrame->GetParentViewFrame_Impl() :
//			pViewFrame->GetTopViewFrame() )->GetWindow(),
			(WorkWindow*) &pViewFrame->GetWindow(),
			pEditWin ? pEditWin : pViewFrame->GetViewShell()->GetWindow() ),
	pFrame( pViewFrame ),
	pMenuBar( 0 )
{
}

//-------------------------------------------------------------------------

BOOL SfxContainerEnv_Impl::SetStatusText( const String & rText )
{
	if( GetParent() )
		return SvContainerEnvironment::SetStatusText( rText );
	else
	{
		if ( rText.Len() )
			pFrame->ShowStatusText( rText );
		else
			pFrame->HideStatusText();
	}
	return TRUE;
}

//-------------------------------------------------------------------------
void SfxContainerEnv_Impl::ShowDocument
(
	const INetURLObject & rURL,
	const XubString & rFrame
)
{
	SfxStringItem aReferer( SID_REFERER, pFrame->GetObjectShell()->GetMedium()->GetName() );
	SfxStringItem aName( SID_FILE_NAME, rURL.GetMainURL( INetURLObject::NO_DECODE ) );
	SfxStringItem aTarget( SID_TARGETNAME, rFrame );
	SfxBoolItem aCreateView( SID_OPEN_NEW_VIEW, TRUE );
	SfxFrameItem aFrame( SID_DOCFRAME, pFrame );

    SFX_APP()->GetAppDispatcher_Impl()->Execute( SID_OPENDOC,
			SFX_CALLMODE_ASYNCHRON, &aFrame, &aReferer,
			&aName, &aCreateView, &aTarget, 0L );
}

//-------------------------------------------------------------------------

BOOL SfxContainerEnv_Impl::DispatchAccel( const KeyCode &rKeyCode )
{
	// zum Glueck wird das char (1. Parameter) nicht benoetigt
    return pFrame->GetViewShell()->KeyInput( KeyEvent( 0, rKeyCode ) );
}

//-------------------------------------------------------------------------

void SfxContainerEnv_Impl::RequestObjAreaPixel( const Rectangle & rObjRect )
{
	SfxRectangleItem *pRet, aReq( SID_OBJECTRESIZE, rObjRect );

	// gewuenschte Groesse erfragen
	SfxDispatcher * pDispat = pFrame->GetDispatcher();
	const SfxPoolItem *pBaseRet = pDispat->Execute( SID_OBJECTRESIZE,
			SFX_CALLMODE_SYNCHRON, &aReq, 0L, 0L );
	pRet = PTR_CAST( SfxRectangleItem, pBaseRet );
	if( pRet )
		((SfxInPlaceClient *)GetIPClient())->RequestObjAreaPixel( pRet->GetValue() );
	else
		((SfxInPlaceClient *)GetIPClient())->RequestObjAreaPixel( rObjRect );
}

//-------------------------------------------------------------------------

void SfxContainerEnv_Impl::UIToolsShown( BOOL bShow )
{
    SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl( pFrame );
    uno::Reference < beans::XPropertySet > xFrame( pFrame->GetFrame()->GetFrameInterface(), uno::UNO_QUERY );
    uno::Reference< ::com::sun::star::frame::XLayoutManager > xMyMan;
    uno::Any aAny = xFrame->getPropertyValue( ::rtl::OUString::createFromAscii("LayoutManager") );
    aAny >>= xMyMan;

	if ( bShow )
	{
		// Gleich zeigt ein Objekt seine UITools an; jetzt mu\s ich meine
		// Tools wegnehmen
		pFrame->GetBindings().HidePopups(TRUE);
        USHORT nVis = SFX_VISIBILITY_UNVISIBLE;
		pWorkWin->SetObjectBarVisibility_Impl( nVis );
        pFrame->GetDispatcher()->Update_Impl( TRUE );
        pWorkWin->Lock_Impl(TRUE);
        //pWorkWin->UpdateObjectBars_Impl();
        xMyMan->setVisible( sal_False );
        xMyMan->lock();
	}
	else
	{
        xMyMan->unlock();
        xMyMan->setVisible( sal_True );

		// Das Objekt hat seine UITools weggenommen, jetzt kommen meine wieder.
		// Dabei setzt die Applikation den App-Border, da es kein UI-aktives
		// Objekt im aktiven Dokument gibt.
		//	(->SfxAppWindow::ArrangeChilds_Impl())
        pWorkWin->Lock_Impl(FALSE);
        pWorkWin->SetObjectBarVisibility_Impl( SFX_VISIBILITY_STANDARD );

		// Wenn ich gerade am sterben bin und mein ViewFrame noch der aktive ist,
		// brauche ich kein Update zu machen, da das dann beim Austragen oder
		// Wechseln des ViewFrames ohnehin geschieht (weniger Zappeln)
		if ( !pFrame->GetFrame()->IsClosing_Impl() ||
			SFX_APP()->GetViewFrame() != pFrame )
				pFrame->GetDispatcher()->Update_Impl( TRUE );
//				pWorkWin->UpdateObjectBars_Impl();

		pFrame->GetBindings().HidePopups(FALSE);
	}
}

BOOL SfxContainerEnv_Impl::SetTopToolSpacePixel( const SvBorder & rInner )
{
	if( !GetIPClient() || GetIPClient()->Owner() )
	{
		if( RequestTopToolSpacePixel( rInner ) )
		{
            if ( pFrame->GetFrame()->OwnsBindings_Impl() )
			{
				SvBorder aBorder( GetTopBorder() );
				aBorder += rInner;
				pFrame->GetFrame()->SetToolSpaceBorderPixel_Impl( aBorder );
			}
			else
			{
				return FALSE;
			}

			return TRUE;

			// Sind Top- und EditWin unterschiedlich, dann muss das EditWin
			// neu angeordnet werden. Dies muss von dem abgeleiteten
			// Environment geleistet werden.
			// Sind sie gleich, kann die Anordnung automatisch geschehen
			return GetEditWin() == GetTopWin();
		}
		return FALSE;
	}
	else
	{
		return SvContainerEnvironment::SetTopToolSpacePixel( rInner );
	}

	return FALSE;
}

