/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: runthrd.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:03:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _VOS_RUNTHRD_HXX_
#define _VOS_RUNTHRD_HXX_

#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#	include <vos/thread.hxx>
#endif
#ifndef _VOS_REF_HXX_
#	include <vos/ref.hxx>
#endif
#ifndef _VOS_EXECABL_HXX_
#	include <vos/execabl.hxx>
#endif
#ifndef _VOS_OBSERVER_HXX_
#	include <vos/observer.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif

// *******************************************************************************

/** OExecutableThread

	A thread used to execute an IExecutable-Object.
	In case you want to notify someone when the
	IExecutable-Object has terminated, you can specify
	an IObserver, whose notify()-method will be called
	with the notify-code: 

	@author  Bernd Hofner
	@version 0.1
*/
class OExecutableThread : public NAMESPACE_VOS(OThread) 
{
	VOS_DECLARE_CLASSINFO(NAMESPACE_VOS(OExecutableThread));
public:
	
	/** Associate an IRunnable and optionally
		an IObserver with this thread.
	*/
	OExecutableThread(const ORef<IExecutable>& refWorker,
					  const ORef<IObserver>& refCompletionObserver= ORef<IObserver>(0));

	~OExecutableThread();

	/** Returns the executable associated with this thread.
	*/
	ORef<IExecutable> SAL_CALL getExecutable() const;

protected:

	ORef<IExecutable>	m_refExecutable;
	ORef<IObserver>		m_refCompletionObserver;

protected:
	
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();

};

#ifdef _USE_NAMESPACE
}
#endif


#endif // _VOS_RUNTHRD_HXX_

