/*
 * LocallisationCache.java
 *
 * Created on 28. Juli 2003, 15:55
 */
package com.sun.star.wizards.tutorial.executer;

import java.util.Vector;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.frame.XFrame;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.MacroCreator;
import com.sun.star.wizards.tutorial.executer.util.MacroReader;
import com.sun.star.wizards.tutorial.executer.util.URLDispatcher;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class LocalisationCache extends Thread {
	/**
	 * Properties
	 */
	public Vector commandsPool = new Vector();
	public boolean m_localisation = false;
	public static LocalisationCache m_executeCache;
	public Helper m_helper = null;

	/**
	 * Static initializer for this class. Creates the only instance for that.
	 */
	static {
		new LocalisationCache();
	}

	/**
	 * Creates a new AccessibilityTools object.
	 */
	private LocalisationCache() {
		m_executeCache = this;
		m_executeCache.setPriority(Thread.MAX_PRIORITY);
		m_executeCache.start();
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param helper DOCUMENT ME!
	 */
	public static void initialize(Helper helper) {
		m_executeCache.m_helper = helper;
	}

	/**
	 * DOCUMENT ME!
	 */
	public void run() {
		try {
			while (true) {
				while (commandsPool.size() > 0) {
					if (isInterrupted()) {
						break;
					}

					m_executeCache.commands();
				}

				m_executeCache.gotoSleep();

				if (isInterrupted()) {
					break;
				}
			}
		} catch (ThreadDeath td) {
		}
	}

	/**
	 * Close all alive internal threads.
	 */
	public void closeThread() {
		if (isAlive()) {
			synchronized (this) {
				interrupt();
				notify();
			}
		}
	}

	/**
	 * Wakeup thread.
	 */
	public static void waken() {
		synchronized (m_executeCache) {
			try {
				m_executeCache.notify();
			} catch (Exception e) {
			}
		}
	}

	/**
	 * Wakeup thread.
	 */
	public static void gotoSleep() {
		synchronized (m_executeCache) {
			try {
				m_executeCache.wait();
			} catch (Exception e) {
			}
		}
	}

	/**
	 * Is Alive this thread.
	 *
	 * @return DOCUMENT ME!
	 */
	public static synchronized boolean isActive() {
		boolean status = false;

		try {
			status = m_executeCache.isAlive();
		} catch (Exception e) {
		}

		return status;
	}

	/**
	 * The empty file, which ought to become opened, is inserted in a list. As soon as a
	 * new entry is inserted the thread will be resumed and will open the files one
	 * after another.
	 *
	 * @param macroName the path for empty Document: text doc :
	 *        staroffice.private:factory/swriter calc doc :
	 *        staroffice.private:factory/scalc draw doc :
	 *        staroffice.private:factory/sdraw pres doc :
	 *        staroffice.private:factory/simpress math doc :
	 *        staroffice.private:factory/smath
	 */
	public static synchronized void put(final String macroName) {
		Helper.log(" INSERT TO PUT");
		new Thread(new Runnable() {
			public void run() {
				try {
					boolean isEmpty = m_executeCache.commandsPool.isEmpty();
					m_executeCache.commandsPool.add(macroName);

					if (isEmpty) {
						m_executeCache.waken();
					}
				} catch (ThreadDeath td) {
				}
			}
		}).start();
		Helper.log(" EXIT TO PUT ");
	}

	/**
	 * DOCUMENT ME!
	 */
	public synchronized void commands() {
		while (!commandsPool.isEmpty()) {
			String macroName = (String) commandsPool.get(0);
			commandsPool.remove(0);
			m_executeCache.execute(macroName);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param macroName DOCUMENT ME!
	 */
	public synchronized void execute(String macroName) {
		try {
			String macro = MacroReader.readDocumentMacro(m_helper.getXModel(), "Standard", macroName);

			if (macro.indexOf("Step_") > 0) {
				char step = macro.charAt(macro.indexOf("Step_") + 5);
				int stepSize = Character.getNumericValue(step);
				ExecuteCache.m_localisation = true;
				ExecuteCache.m_localisationPaths.clear();
				Control.setMouseAnimate(false);

				for (int i = 0; i <= stepSize; i++) {
					//String url = "macro:///Tutorials." + macroName + ".Step_" + i + "_Action()";
					String url = "macro://./Standard." + macroName + ".Step_" + i + "_Action()";
					Helper.log("Dispatch  path :" + url);

					try {
						URLDispatcher.dispatch_Thread(m_helper.getXFrame(), url, "_self", 0, null);
					} catch (com.sun.star.uno.Exception ex) {
						ex.printStackTrace();
					}

					m_executeCache.gotoSleep();
				}

				Control.setMouseAnimate(true);
				ExecuteCache.m_localisation = false;

				Vector localisationPaths = ExecuteCache.getLocalisationPaths();

				if (!localisationPaths.isEmpty()) {
					Helper.log("**** trans begin *****");

					String transMacro = TranslateMacro.translateMacro(macroName, macro, localisationPaths);
					Helper.log("transMacro :" + transMacro);

					//MacroCreator.createDocumentMacro(m_helper.getXModel(), "Standard", macroName + "TRANS", transMacro);
					MacroCreator.createDocumentMacro(m_helper.getXModel(), "Standard", macroName, transMacro, true);
					Helper.log("**** trans done *****");
				}
			} else {
				Helper.log("transMacro :" + macro);

				//MacroCreator.createDocumentMacro(m_helper.getXModel(), "Standard", macroName + "TRANS", macro);
				MacroCreator.createDocumentMacro(m_helper.getXModel(), "Standard", macroName, macro, true);
				Helper.log("**** trans done *****");
			}
		} catch (com.sun.star.uno.Exception ex) {
		}
	}
}
