/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_fusel.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:19:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop


// INCLUDE ---------------------------------------------------------------

#include <bf_svx/eeitem.hxx>

#ifndef _PSTM_HXX
#include <tools/pstm.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#define ITEMID_FIELD EE_FEATURE_FIELD
#include <bf_svx/flditem.hxx>
#include <bf_svx/svdoole2.hxx>
#include <bf_svx/svdotext.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/ipfrm.hxx>
#include <so3/ipobj.hxx>
#include <svtools/imapobj.hxx>
#include <bf_svx/svdview.hxx>
#include <bf_svx/svdouno.hxx>
#include <bf_svx/svdpagv.hxx>
#include <bf_svx/outlobj.hxx>



#include "fusel.hxx"
#include "bf_sc.hrc"
#include "fudraw.hxx"
#include "futext.hxx"
#include "tabvwsh.hxx"
#include "drawpage.hxx"
#include "globstr.hrc"
#include "drwlayer.hxx"
namespace binfilter {

// -----------------------------------------------------------------------

//	Maximal erlaubte Mausbewegung um noch Drag&Drop zu starten
//!	fusel,fuconstr,futext - zusammenfassen!
#define SC_MAXDRAGMOVE	3

// -----------------------------------------------------------------------

#ifdef WNT
#pragma optimize ( "", off )
#endif


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ FuSelection::FuSelection(ScTabViewShell* pViewSh, Window* pWin, SdrView* pView,
/*N*/ 			   SdrModel* pDoc, SfxRequest& rReq ) :
/*N*/ 	FuDraw(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	bVCAction(FALSE)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuSelection::~FuSelection()
/*N*/ {
/*N*/ }

//STRIP001 BYTE FuSelection::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	//	special code for non-VCL OS2/UNX removed
//STRIP001 
//STRIP001 	return FuDraw::Command( rCEvt );
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuSelection::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 		if ( rMEvt.IsRight() )
//STRIP001 			pView->BckAction();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	bVCAction = FALSE;
//STRIP001 	bIsInDragMode = FALSE;		//	irgendwo muss es ja zurueckgesetzt werden (#50033#)
//STRIP001 
//STRIP001 	BOOL bReturn = FuDraw::MouseButtonDown(rMEvt);
//STRIP001 
//STRIP001 	aMDPos = pWindow->PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		SdrHdl* pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001 		SdrObject* pObj;
//STRIP001 		SdrPageView* pPV;
//STRIP001 
//STRIP001 		if ( pHdl!=NULL || pView->IsMarkedHit(aMDPos) )
//STRIP001 		{
//STRIP001 			aDragTimer.Start();
//STRIP001 			pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl);
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			BOOL bAlt = rMEvt.IsMod2();
//STRIP001 			if ( !bAlt && pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_PICKMACRO) )
//STRIP001 			{
//STRIP001 				pView->BegMacroObj(aMDPos, pObj, pPV, pWindow);
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//	URL / ImageMap
//STRIP001 
//STRIP001 				SdrViewEvent aVEvt;
//STRIP001 				if ( !bAlt &&
//STRIP001 					pView->PickAnything( rMEvt, SDRMOUSEBUTTONDOWN, aVEvt ) != SDRHIT_NONE &&
//STRIP001 					aVEvt.pObj != NULL )
//STRIP001 				{
//STRIP001 					if ( ScDrawLayer::GetIMapInfo( aVEvt.pObj ) )		// ImageMap
//STRIP001 					{
//STRIP001 						const IMapObject* pIMapObj =
//STRIP001 								ScDrawLayer::GetHitIMapObject( aVEvt.pObj, aMDPos, *pWindow );
//STRIP001 						if ( pIMapObj && pIMapObj->GetURL().Len() )
//STRIP001 						{
//STRIP001 							ScGlobal::OpenURL( pIMapObj->GetURL(), pIMapObj->GetTarget() );
//STRIP001 
//STRIP001 							pViewShell->FakeButtonUp( pViewShell->GetViewData()->GetActivePart() );
//STRIP001 							return TRUE;		// kein CaptureMouse etc.
//STRIP001 						}
//STRIP001 					}
//STRIP001 					if ( aVEvt.eEvent == SDREVENT_EXECUTEURL && aVEvt.pURLField )	// URL
//STRIP001 					{
//STRIP001 						ScGlobal::OpenURL( aVEvt.pURLField->GetURL(),
//STRIP001 											aVEvt.pURLField->GetTargetFrame() );
//STRIP001 
//STRIP001 						pViewShell->FakeButtonUp( pViewShell->GetViewData()->GetActivePart() );
//STRIP001 						return TRUE;		// kein CaptureMouse etc.
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				//	Is another object being edited in this view?
//STRIP001 				//	(Editing is ended in MarkListHasChanged - test before UnmarkAll)
//STRIP001 				SfxInPlaceClient* pClient = pViewShell->GetIPClient();
//STRIP001 				BOOL bWasOleActive = ( pClient && pClient->IsInPlaceActive() );
//STRIP001 
//STRIP001 				//	Markieren
//STRIP001 
//STRIP001 				if ( !rMEvt.IsShift() )
//STRIP001 					pView->UnmarkAll();
//STRIP001 
//STRIP001 				if ( pView->MarkObj(aMDPos, -2, FALSE, rMEvt.IsMod1()) )
//STRIP001 				{
					//*********************************************************
					//Objekt verschieben
					//********************************************************
//STRIP001 					if (pView->IsMarkedHit(aMDPos))
//STRIP001 					{
//STRIP001 						//	#95834# Don't start drag timer if inplace editing of an OLE object
//STRIP001 						//	was just ended with this mouse click - the view will be moved
//STRIP001 						//	(different tool bars) and the object that was clicked on would
//STRIP001 						//	be moved unintentionally.
//STRIP001 						if ( !bWasOleActive )
//STRIP001 							aDragTimer.Start();
//STRIP001 
//STRIP001 						pHdl=pView->HitHandle(aMDPos, *pWindow);
//STRIP001 						pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl);
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 					else									// Objekt am Rand getroffen
//STRIP001 						if (pViewShell->IsDrawSelMode())
//STRIP001 							bReturn = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//		nichts getroffen
//STRIP001 
//STRIP001 					if (pViewShell->IsDrawSelMode())
//STRIP001 					{
						//*********************************************************
						//Objekt selektieren
						//********************************************************
//STRIP001 						pView->BegMarkObj(aMDPos, (OutputDevice*) NULL);
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bReturn )
//STRIP001 			bReturn = TestComment( pView->GetPageViewPvNum(0), aMDPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bIsInDragMode)
//STRIP001 	{
//STRIP001 		if (!bVCAction)					// VC rufen selber CaptureMouse
//STRIP001 			pWindow->CaptureMouse();
//STRIP001 		ForcePointer(&rMEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuSelection::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FuDraw::MouseMove(rMEvt);
//STRIP001 
//STRIP001 	if (aDragTimer.IsActive() )
//STRIP001 	{
//STRIP001 		Point aOldPixel = pWindow->LogicToPixel( aMDPos );
//STRIP001 		Point aNewPixel = rMEvt.GetPosPixel();
//STRIP001 		if ( Abs( aOldPixel.X() - aNewPixel.X() ) > SC_MAXDRAGMOVE ||
//STRIP001 			 Abs( aOldPixel.Y() - aNewPixel.Y() ) > SC_MAXDRAGMOVE )
//STRIP001 			aDragTimer.Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 		Point aPix(rMEvt.GetPosPixel());
//STRIP001 		Point aPnt(pWindow->PixelToLogic(aPix));
//STRIP001 
//STRIP001 		ForceScroll(aPix);
//STRIP001 		pView->MovAction(aPnt);
//STRIP001 		bReturn = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ein VCControl ist aktiv
//STRIP001 	// Event an den Manager weiterleiten
//STRIP001 	if( bVCAction )
//STRIP001 	{
//STRIP001 		//	GetSbxForm gibts nicht mehr - Basic-Controls sind tot
//STRIP001 		//SdrPageView* pPgView = pView->GetPageViewPvNum(0);
//STRIP001 		//ScDrawPage*  pPage	 = (ScDrawPage*)pPgView->GetPage();
//STRIP001 		//VCSbxForm* pForm = (VCSbxForm*)(SbxObject*)(pPage->GetSbxForm());
//STRIP001 		//((VCManager*)(pForm->GetVCContainer()))->
//STRIP001 		//    MouseMove( pWindow, rMEvt );
//STRIP001 		bReturn = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL __EXPORT FuSelection::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	BOOL bReturn = FuDraw::MouseButtonUp(rMEvt);
//STRIP001 //	BOOL bOle	 = pViewShell->GetViewData()->IsOle();
//STRIP001 	BOOL bOle	 = pViewShell->GetViewFrame()->ISA(SfxInPlaceFrame);
//STRIP001 
//STRIP001 	if (aDragTimer.IsActive() )
//STRIP001 	{
//STRIP001 		aDragTimer.Stop();
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		if ( pView->IsDragObj() )
//STRIP001 		{
			/******************************************************************
			* Objekt wurde verschoben
			******************************************************************/
//STRIP001 			pView->EndDragObj( rMEvt.IsMod1() );
//STRIP001 			pView->ForceMarkedToAnotherPage();
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 		else if (pView->IsAction() )
//STRIP001 		{
//STRIP001 			pView->EndAction();
//STRIP001 			if ( pView->HasMarkedObj() )
//STRIP001 				bReturn = TRUE;
//STRIP001 		}
//STRIP001 	}

/*
	if ( pView->IsObjEdit() )
	{
		BOOL bShowCursor = TRUE;
//! 	pOutlinerView = pView->GetOutlinerView(pWindow, bShowCursor);
		bReturn = TRUE;
	}
*/
	/**************************************************************************
	* Ggf. OLE-Objekt beruecksichtigen
	**************************************************************************/
//STRIP001 	SfxInPlaceClient* pIPClient = pViewShell->GetIPClient();
//STRIP001 
//STRIP001 	if (pIPClient)
//STRIP001 	{
//STRIP001 		if ( pIPClient->IsInPlaceActive() )
//STRIP001 		{
//STRIP001 			pIPClient->GetProtocol().Reset2Open();
//STRIP001 			SFX_APP()->SetViewFrame(pViewShell->GetViewFrame()); // 242.a: ???
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nClicks = rMEvt.GetClicks();
//STRIP001 	if ( nClicks == 2 && rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		if ( pView->HasMarkedObj() )
//STRIP001 		{
//STRIP001 			const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 			if (rMarkList.GetMarkCount() == 1)
//STRIP001 			{
//STRIP001 				SdrMark* pMark = rMarkList.GetMark(0);
//STRIP001 				SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001 				//	#43984# aktivieren nur, wenn die Maus auch (noch) ueber dem
//STRIP001 				//	selektierten Objekt steht
//STRIP001 
//STRIP001 				SdrViewEvent aVEvt;
//STRIP001 				SdrHitKind eHit = pView->PickAnything( rMEvt, SDRMOUSEBUTTONDOWN, aVEvt );
//STRIP001 				if ( eHit != SDRHIT_NONE && aVEvt.pObj == pObj )
//STRIP001 				{
//STRIP001 					UINT16 nSdrObjKind = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001 					//
//STRIP001 					//	OLE: aktivieren
//STRIP001 					//
//STRIP001 
//STRIP001 					if (nSdrObjKind == OBJ_OLE2)
//STRIP001 					{
//STRIP001 						if (!bOle)
//STRIP001 						{
//STRIP001 							SvInPlaceObjectRef aIPObj = ((SdrOle2Obj*) pObj)->GetObjRef();
//STRIP001 							if (aIPObj.Is())
//STRIP001 							{
//STRIP001 								pView->HideMarkHdl(NULL);
//STRIP001 								pViewShell->ActivateObject( (SdrOle2Obj*) pObj, 0 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					//
//STRIP001 					//	Text: editieren
//STRIP001 					//	#49458# nicht bei Uno-Controls
//STRIP001 					//
//STRIP001 					else if ( pObj->ISA(SdrTextObj) && !pObj->ISA(SdrUnoObj) )
//STRIP001 					{
//STRIP001 						OutlinerParaObject* pOPO = pObj->GetOutlinerParaObject();
//STRIP001 						BOOL bVertical = ( pOPO && pOPO->IsVertical() );
//STRIP001 						USHORT nTextSlotId = bVertical ? SID_DRAW_TEXT_VERTICAL : SID_DRAW_TEXT;
//STRIP001 
//STRIP001 						pViewShell->GetViewData()->GetDispatcher().
//STRIP001 							Execute(nTextSlotId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 						// jetzt den erzeugten FuText holen und in den EditModus setzen
//STRIP001 						FuPoor* pPoor = pViewShell->GetViewData()->GetView()->GetDrawFuncPtr();
//STRIP001 						if ( pPoor && pPoor->GetSlotID() == nTextSlotId )	 //	hat keine RTTI
//STRIP001 						{
//STRIP001 							FuText* pText = (FuText*)pPoor;
//STRIP001 							Point aMousePixel = rMEvt.GetPosPixel();
//STRIP001 							pText->SetInEditMode( pObj, &aMousePixel );
//STRIP001 						}
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( TestDetective( pView->GetPageViewPvNum(0), aPnt ) )
//STRIP001 			bReturn = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ein VCControl ist aktiv
//STRIP001 	// Event an den Manager weiterleiten
//STRIP001 	if( bVCAction )
//STRIP001 	{
//STRIP001 		//	GetSbxForm gibts nicht mehr - Basic-Controls sind tot
//STRIP001 		//SdrPageView* pPgView = pView->GetPageViewPvNum(0);
//STRIP001 		//ScDrawPage*  pPage	 = (ScDrawPage*)pPgView->GetPage();
//STRIP001 		//VCSbxForm* pForm = (VCSbxForm*)(SbxObject*)(pPage->GetSbxForm());
//STRIP001 		//((VCManager*)(pForm->GetVCContainer()))->
//STRIP001 		//    MouseButtonUp( pWindow, rMEvt );
//STRIP001 		pView->ShowMarkHdl( pWindow );
//STRIP001 		bVCAction = FALSE;
//STRIP001 		bReturn = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 	//	::com::mand-Handler fuer Kontext-Menue kommt erst nach MouseButtonUp,
//STRIP001 	//	darum hier die harte IsLeft-Abfrage
//STRIP001 	if ( !bReturn && rMEvt.IsLeft() )
//STRIP001 		if (pViewShell->IsDrawSelMode())
//STRIP001 			pViewShell->GetViewData()->GetDispatcher().
//STRIP001 				Execute(SID_OBJECT_SELECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (!bReturn)
//STRIP001 	{
//STRIP001 		bReturn = FuDraw::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

//STRIP001 void FuSelection::Activate()
//STRIP001 {
/*
	SdrDragMode eMode;
	switch (aSfxRequest.GetSlot() )
	{
		case SID_OBJECT_SELECT:
			eMode = SDRDRAG_MOVE;
			break;
		case SID_OBJECT_ROTATE:
			eMode = SDRDRAG_ROTATE;
			break;
		case SID_OBJECT_MIRROR:
			eMode = SDRDRAG_MIRROR;
			break;
	}
	pView->SetDragMode(eMode);
*/
//STRIP001 	FuDraw::Activate();
//STRIP001 }



/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

//STRIP001 void FuSelection::Deactivate()
//STRIP001 {
	/**************************************************************************
	* Hide Cursor
	**************************************************************************/
//STRIP001 	BOOL bShowCursor = FALSE;
//STRIP001 //! pOutlinerView = pView->GetOutlinerView(pWindow, bShowCursor);
//STRIP001 
//STRIP001 //	pView->SetDragMode(SDRDRAG_MOVE);
//STRIP001 	FuDraw::Deactivate();
//STRIP001 }
//STRIP001 

#ifdef WNT
#pragma optimize ( "", on )
#endif





}
