/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_diagrtyp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:18:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define OFFSET_PYRAMID 1000
#define OFFSET_ROUND   2000
#define OFFSET_CONE    3000



#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#include <bf_sfx2/sfxsids.hrc>
#include <bf_svx/eeitem.hxx>
#pragma hdrstop

#include "schdll.hxx"
#define ITEMID_CHARTSTYLE	CHATTR_DIAGRAM_STYLE
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <bf_svx/chrtitem.hxx>
#endif

#include "strings.hrc"
#include "res_bmp.hrc"
// for high contrast images
#include "res_hc_bmp.hrc"

#include "schresid.hxx"
#include "chtmodel.hxx"
#include "diagrtyp.hxx"
#include "diagrtyp.hrc"

#include "chmod3d.hxx"
#include "schattr.hxx"
namespace binfilter {
/************************************************************************/
// TVM: CHTYPE wurde ins Model verschoben

// macro for selecting a normal or high contrast bitmap the stack variable
// bIsHighContrast must exist and reflect the correct state

#define SELECT_BITMAP(name) Bitmap( SchResId( bIsHighContrast ? name ## _HC : name ))


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

//STRIP001 SchDiagramTypeDlg::SchDiagramTypeDlg(Window* pWindow,
//STRIP001 									 const SfxItemSet& rInAttrs) :
//STRIP001 	ModalDialog(pWindow, SchResId(DLG_DIAGRAM_TYPE)),
//STRIP001 	aRbt2D(this, ResId(RBT_2D)),
//STRIP001 	aRbt3D(this, ResId(RBT_3D)),
//STRIP001 	aFlDimension(this, ResId(FL_DIMENSION)),
//STRIP001 	aFtDeep( this, ResId( FT_DEEP ) ),
//STRIP001 	aMtrFldDeep( this, ResId( MTR_FLD_DEEP ) ),
//STRIP001 	aFtGran( this, ResId( FT_GRAN ) ),
//STRIP001 	aMtrFldGran( this, ResId( MTR_FLD_GRAN ) ),
//STRIP001     aFtNumLines( this, ResId( FT_NUM_OF_LINES ) ),
//STRIP001     aMtrFldNumLines( this, ResId( MTR_FLD_NUM_OF_LINES ) ),
//STRIP001 
//STRIP001     aFtType(this, ResId(FT_TYPE)),
//STRIP001 	aCtlType(this, ResId(CTL_TYPE)),
//STRIP001 	aFtVariant(this, ResId(FT_VARIANT)),
//STRIP001 	aCtlVariant(this, ResId(CTL_VARIANT)),
//STRIP001 	aBtnOK(this, ResId(BTN_OK)),
//STRIP001 	aBtnCancel(this, ResId(BTN_CANCEL)),
//STRIP001 	aBtnHelp(this, ResId(BTN_HELP)),
//STRIP001 	eDimension(CHDIM_2D),
//STRIP001 	rOutAttrs(rInAttrs),
//STRIP001 	n3DGeometry(CHART_SHAPE3D_ANY)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aRbt2D.SetClickHdl(LINK(this, SchDiagramTypeDlg,
//STRIP001 							   SelectDimensionHdl));
//STRIP001 	aRbt3D.SetClickHdl(LINK(this, SchDiagramTypeDlg,
//STRIP001 							   SelectDimensionHdl));
//STRIP001 
//STRIP001 	aCtlType.SetStyle(aCtlType.GetStyle() |
//STRIP001 						 /*WB_ITEMBORDER | WB_DOUBLEBORDER |*/ WB_NAMEFIELD | WB_VSCROLL );
//STRIP001 
//STRIP001 	aCtlType.SetColCount(4);
//STRIP001 	aCtlType.SetLineCount(2);
//STRIP001 	aCtlType.SetExtraSpacing(2);
//STRIP001 
//STRIP001 	aCtlType.SetSelectHdl(LINK(this, SchDiagramTypeDlg, SelectTypeHdl));
//STRIP001 	aCtlType.SetDoubleClickHdl(LINK(this, SchDiagramTypeDlg,
//STRIP001 											 DoubleClickHdl));
//STRIP001 
//STRIP001 	aCtlVariant.SetStyle(aCtlVariant.GetStyle() |
//STRIP001 							/*WB_ITEMBORDER | WB_DOUBLEBORDER |*/ WB_NAMEFIELD | WB_VSCROLL );
//STRIP001 
//STRIP001 	aCtlVariant.SetColCount(4);
//STRIP001 	aCtlVariant.SetLineCount(1);
//STRIP001 	aCtlVariant.SetExtraSpacing(2);
//STRIP001 	aCtlVariant.SetDoubleClickHdl(LINK(this, SchDiagramTypeDlg,	DoubleClickHdl));
//STRIP001 	aCtlVariant.SetSelectHdl(LINK(this, SchDiagramTypeDlg, ClickHdl));
//STRIP001 
//STRIP001 	Reset();
//STRIP001 }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

//STRIP001 SchDiagramTypeDlg::~SchDiagramTypeDlg()
//STRIP001 {
//STRIP001 }
/*************************************************************************
|*
|*	Initialisierung
|*
\*************************************************************************/

//STRIP001 void SchDiagramTypeDlg::Reset()
//STRIP001 {
//STRIP001 	const SfxPoolItem *pPoolItem = NULL;
//STRIP001 
//STRIP001 	if (rOutAttrs.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem)
//STRIP001 			== SFX_ITEM_SET)
//STRIP001 			n3DGeometry=((const SfxInt32Item*)pPoolItem)->GetValue();
//STRIP001 
//STRIP001 	if (rOutAttrs.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem)
//STRIP001 			== SFX_ITEM_SET)
//STRIP001 	{
//STRIP001 		USHORT nType;
//STRIP001 		ChartDimension eDim;
//STRIP001 
//STRIP001 		//Hier sollte demnaechst folgendes ersatzweise stehen:
//STRIP001 		//nType=pDoc->GetBaseType();
//STRIP001 		//eDim=(pDoc->GetDisplayDimension()==3)?CHDIM_3D:CHDIM_2D;
//STRIP001 
//STRIP001 		switch (((const SvxChartStyleItem*)pPoolItem)->GetValue())
//STRIP001 		{
//STRIP001 			case CHSTYLE_2D_B_SPLINE :
//STRIP001 			case CHSTYLE_2D_B_SPLINE_SYMBOL :
//STRIP001 			case CHSTYLE_2D_LINE:
//STRIP001 			case CHSTYLE_2D_STACKEDLINE:
//STRIP001 			case CHSTYLE_2D_PERCENTLINE:
//STRIP001 			case CHSTYLE_2D_LINESYMBOLS:
//STRIP001 			case CHSTYLE_2D_STACKEDLINESYM:
//STRIP001 			case CHSTYLE_2D_PERCENTLINESYM:
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE :
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
//STRIP001 				nType	= CHTYPE_LINE;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_COLUMN:
//STRIP001 			case CHSTYLE_2D_STACKEDCOLUMN:
//STRIP001 			case CHSTYLE_2D_PERCENTCOLUMN:
//STRIP001 			case CHSTYLE_2D_LINE_COLUMN:
//STRIP001 			case CHSTYLE_2D_LINE_STACKEDCOLUMN:
//STRIP001 
//STRIP001 				nType	= CHTYPE_COLUMN;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_BAR:
//STRIP001 			case CHSTYLE_2D_STACKEDBAR:
//STRIP001 			case CHSTYLE_2D_PERCENTBAR:
//STRIP001 				nType	= CHTYPE_BAR;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_AREA:
//STRIP001 			case CHSTYLE_2D_STACKEDAREA:
//STRIP001 			case CHSTYLE_2D_PERCENTAREA:
//STRIP001 				nType	= CHTYPE_AREA;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_PIE:
//STRIP001 			case CHSTYLE_2D_PIE_SEGOF1:
//STRIP001 			case CHSTYLE_2D_PIE_SEGOFALL:
//STRIP001 			case CHSTYLE_2D_DONUT1:
//STRIP001 			case CHSTYLE_2D_DONUT2:
//STRIP001 				nType	= CHTYPE_CIRCLE;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_B_SPLINE_XY :
//STRIP001 			case CHSTYLE_2D_XY_LINE :
//STRIP001 			case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
//STRIP001 			case CHSTYLE_2D_XYSYMBOLS:
//STRIP001 			case CHSTYLE_2D_XY:
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE_XY :
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
//STRIP001 				nType	= CHTYPE_XY;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_NET:
//STRIP001 			case CHSTYLE_2D_NET_SYMBOLS:
//STRIP001 			case CHSTYLE_2D_NET_STACK:
//STRIP001 			case CHSTYLE_2D_NET_SYMBOLS_STACK:
//STRIP001 			case CHSTYLE_2D_NET_PERCENT:
//STRIP001 			case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
//STRIP001 				nType	= CHTYPE_NET;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_3D_STRIPE:
//STRIP001 				nType	= CHTYPE_LINE;
//STRIP001 				eDim	= CHDIM_3D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_3D_COLUMN:
//STRIP001 			case CHSTYLE_3D_FLATCOLUMN:
//STRIP001 			case CHSTYLE_3D_STACKEDFLATCOLUMN:
//STRIP001 			case CHSTYLE_3D_PERCENTFLATCOLUMN:
//STRIP001 				nType	= CHTYPE_COLUMN;
//STRIP001 				eDim	= CHDIM_3D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_3D_BAR:
//STRIP001 			case CHSTYLE_3D_FLATBAR:
//STRIP001 			case CHSTYLE_3D_STACKEDFLATBAR:
//STRIP001 			case CHSTYLE_3D_PERCENTFLATBAR:
//STRIP001 				nType	= CHTYPE_BAR;
//STRIP001 				eDim	= CHDIM_3D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_3D_AREA:
//STRIP001 			case CHSTYLE_3D_STACKEDAREA:
//STRIP001 			case CHSTYLE_3D_PERCENTAREA:
//STRIP001 				nType	= CHTYPE_AREA;
//STRIP001 				eDim	= CHDIM_3D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_3D_PIE:
//STRIP001 				nType	= CHTYPE_CIRCLE;
//STRIP001 				eDim	= CHDIM_3D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHSTYLE_2D_STOCK_1:
//STRIP001 			case CHSTYLE_2D_STOCK_2:
//STRIP001 			case CHSTYLE_2D_STOCK_3:
//STRIP001 			case CHSTYLE_2D_STOCK_4:
//STRIP001 				nType	= CHTYPE_STOCK;
//STRIP001 				eDim	= CHDIM_2D;
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR("Invalid chart style given!");
//STRIP001 				return;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (eDim == CHDIM_3D)
//STRIP001 		{
//STRIP001 			aRbt3D.Check(TRUE);
//STRIP001 			eDimension = CHDIM_2D;
//STRIP001 			SelectDimensionHdl(&aRbt3D);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aRbt2D.Check(TRUE);
//STRIP001 			eDimension = CHDIM_3D;
//STRIP001 			SelectDimensionHdl(&aRbt2D);
//STRIP001 		}
//STRIP001 
//STRIP001 		aCtlType.SelectItem(nType);
//STRIP001 		SelectTypeHdl(&aCtlType);
//STRIP001 
//STRIP001         USHORT nItemChartType = static_cast< USHORT >(
//STRIP001             static_cast< const SvxChartStyleItem * >( pPoolItem )->GetValue() );
//STRIP001 
//STRIP001         SwitchDepth( nItemChartType );
//STRIP001         SwitchNumLines( nItemChartType );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Fuellt das Typ-Set mit Bitmaps
|*
\************************************************************************/

//STRIP001 void SchDiagramTypeDlg::FillTypeSet(ChartDimension eDim, bool bForce /* default: false */ )
//STRIP001 {
//STRIP001 	if (eDim != eDimension || bForce)
//STRIP001 	{
//STRIP001 		eDimension = eDim;
//STRIP001 
//STRIP001 		USHORT nSelId = aCtlType.IsNoSelection() ?
//STRIP001 						0 : aCtlType.GetSelectItemId();
//STRIP001 
//STRIP001 		aCtlType.Clear();
//STRIP001 
//STRIP001         bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );
//STRIP001 
//STRIP001 		if (aRbt2D.IsChecked())
//STRIP001 		{
//STRIP001 			aCtlType.InsertItem(CHTYPE_LINE,
//STRIP001 								SELECT_BITMAP( BMP_LINES_2D ),
//STRIP001 								String(SchResId(STR_LINES)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_AREA,
//STRIP001 								SELECT_BITMAP( BMP_AREAS_2D ),
//STRIP001 								String(SchResId(STR_AREAS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_COLUMN,
//STRIP001 								SELECT_BITMAP( BMP_COLUMNS_2D ),
//STRIP001 								String(SchResId(STR_COLUMNS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_BAR,
//STRIP001 								SELECT_BITMAP( BMP_BARS_2D ),
//STRIP001 								String(SchResId(STR_BARS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_CIRCLE,
//STRIP001 								SELECT_BITMAP( BMP_CIRCLES_2D ),
//STRIP001 								String(SchResId(STR_CIRCLES)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_XY,
//STRIP001 								SELECT_BITMAP( BMP_XYSYMB_2D ),
//STRIP001 								String(SchResId(STR_XY)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_NET,
//STRIP001 								SELECT_BITMAP( BMP_NET_2D ),
//STRIP001 								String(SchResId(STR_NET)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_STOCK,
//STRIP001 								SELECT_BITMAP( BMP_STOCK_2 ),
//STRIP001 								String(SchResId(STR_STOCK)));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aCtlType.InsertItem(CHTYPE_LINE,
//STRIP001 								SELECT_BITMAP( BMP_LINES_3D ),
//STRIP001 								String(SchResId(STR_LINES)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_AREA,
//STRIP001 								SELECT_BITMAP( BMP_AREAS_3D_1 ),
//STRIP001 								String(SchResId(STR_AREAS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_BAR,
//STRIP001 								SELECT_BITMAP( BMP_BARS_3D_1 ),
//STRIP001 								String(SchResId(STR_BARS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_COLUMN,
//STRIP001 								SELECT_BITMAP( BMP_COLUMNS_3D_1 ),
//STRIP001 								String(SchResId(STR_COLUMNS)));
//STRIP001 			aCtlType.InsertItem(CHTYPE_CIRCLE,
//STRIP001 								SELECT_BITMAP( BMP_CIRCLES_3D ),
//STRIP001 								String(SchResId(STR_CIRCLES)));
//STRIP001 		}
//STRIP001 
//STRIP001 		aCtlType.Show();
//STRIP001 
//STRIP001 		if (nSelId > 0)
//STRIP001 		{
//STRIP001 			if (aCtlType.GetItemPos(nSelId) == VALUESET_ITEM_NOTFOUND) nSelId = aCtlType.GetItemId(0);
//STRIP001 
//STRIP001 			aCtlType.SelectItem(nSelId);
//STRIP001 			SelectTypeHdl(&aCtlType);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Fuellt das Varianten-Set mit Bitmaps
|*
\************************************************************************/

//STRIP001 void SchDiagramTypeDlg::FillVariantSet(USHORT nType)
//STRIP001 {
//STRIP001 	long nDefaultOffset = 0;
//STRIP001 	
//STRIP001 	aCtlVariant.Clear();
//STRIP001 
//STRIP001     bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );
//STRIP001 
//STRIP001 	if (eDimension == CHDIM_3D)
//STRIP001 	{
//STRIP001 		switch (nType)
//STRIP001 		{
//STRIP001 			case CHTYPE_LINE:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STRIPE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINES_3D ),
//STRIP001 									   String(SchResId(STR_DEEP)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_AREA:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDAREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_3D_1 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTAREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_3D_2 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_AREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_3D ),
//STRIP001 									   String(SchResId(STR_DEEP)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_COLUMN:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_3D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_3D_2 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_3D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_3D ),
//STRIP001 									   String(SchResId(STR_DEEP)));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_SAEULE_3D_1 ),
//STRIP001 									   String(SchResId(STR_SAEULE_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_SAEULE_3D_2 ),
//STRIP001 									   String(SchResId(STR_SAEULE_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_SAEULE_3D_3 ),
//STRIP001 									   String(SchResId(STR_SAEULE_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_SAEULE_3D_4 ),
//STRIP001 									   String(SchResId(STR_SAEULE_3D_4)));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMID_3D_1 ),
//STRIP001 									   String(SchResId(STR_PYRAMID_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMID_3D_2 ),
//STRIP001 									   String(SchResId(STR_PYRAMID_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMID_3D_3 ),
//STRIP001 									   String(SchResId(STR_PYRAMID_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMID_3D_4 ),
//STRIP001 									   String(SchResId(STR_PYRAMID_3D_4)));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGEL_3D_1 ),
//STRIP001 									   String(SchResId(STR_KEGEL_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGEL_3D_2 ),
//STRIP001 									   String(SchResId(STR_KEGEL_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGEL_3D_3 ),
//STRIP001 									   String(SchResId(STR_KEGEL_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGEL_3D_4 ),
//STRIP001 									   String(SchResId(STR_KEGEL_3D_4)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_CIRCLE:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PIE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_CIRCLES_3D ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_BAR:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_3D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_3D_2 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_3D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_3D ),
//STRIP001 									   String(SchResId(STR_DEEP)));
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_ROEHRE_3D_1 ),
//STRIP001 									   String(SchResId(STR_ROEHRE_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_ROEHRE_3D_2 ),
//STRIP001 									   String(SchResId(STR_ROEHRE_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_ROEHRE_3D_3 ),
//STRIP001 									   String(SchResId(STR_ROEHRE_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_ROUND,
//STRIP001 									   SELECT_BITMAP( BMP_ROEHRE_3D_4 ),
//STRIP001 									   String(SchResId(STR_ROEHRE_3D_4)));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMIDQ_3D_1 ),
//STRIP001 									   String(SchResId(STR_PYRAMIDQ_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMIDQ_3D_2 ),
//STRIP001 									   String(SchResId(STR_PYRAMIDQ_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMIDQ_3D_3 ),
//STRIP001 									   String(SchResId(STR_PYRAMIDQ_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_PYRAMID,
//STRIP001 									   SELECT_BITMAP( BMP_PYRAMIDQ_3D_4 ),
//STRIP001 									   String(SchResId(STR_PYRAMIDQ_3D_4)));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGELQ_3D_1 ),
//STRIP001 									   String(SchResId(STR_KEGELQ_3D_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGELQ_3D_2 ),
//STRIP001 									   String(SchResId(STR_KEGELQ_3D_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGELQ_3D_3 ),
//STRIP001 									   String(SchResId(STR_KEGELQ_3D_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_CONE,
//STRIP001 									   SELECT_BITMAP( BMP_KEGELQ_3D_4 ),
//STRIP001 									   String(SchResId(STR_KEGELQ_3D_4)));
//STRIP001 				break;
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else		// 2D types
//STRIP001 	{
//STRIP001 		switch (nType)
//STRIP001 		{
//STRIP001 			case CHTYPE_LINE:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINES_2D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDLINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINES_2D_2 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTLINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINES_2D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINESYMBOLS + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINESYMB_2D_1 ),
//STRIP001 									   String(SchResId(STR_SYMBOL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDLINESYM + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINESYMB_2D_2 ),
//STRIP001 									   String(SchResId(STR_SYMBOL_STACK)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTLINESYM + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINESYMB_2D_3 ),
//STRIP001 									   String(SchResId(STR_SYMBOL_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_CUBIC ),
//STRIP001 									   String(SchResId(STR_SPLINE_CUBIC)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_SYMBOL + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_CUBIC_SYMBOL ),
//STRIP001 									   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_B ),
//STRIP001 									   String(SchResId(STR_SPLINE_B)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_SYMBOL + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_B_SYMBOL ),
//STRIP001 									   String(SchResId(STR_SPLINE_B_SYMBOL)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_AREA:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_AREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_2D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDAREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_2D ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTAREA + 1,
//STRIP001 									   SELECT_BITMAP( BMP_AREAS_2D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				nDefaultOffset = 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_COLUMN:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_COLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_2D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_2D_2 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_2D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE_COLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_2D_4 ),
//STRIP001 									   String(SchResId(STR_LINE_COLUMN)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE_STACKEDCOLUMN + 1,
//STRIP001 									   SELECT_BITMAP( BMP_COLUMNS_2D_5 ),
//STRIP001 									   String(SchResId(STR_LINE_STACKEDCOLUMN)));
//STRIP001 
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_BAR:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_BAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_2D_1 ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDBAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_2D_2 ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTBAR + 1,
//STRIP001 									   SELECT_BITMAP( BMP_BARS_2D_3 ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_CIRCLE:
//STRIP001 			{
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PIE + 1,
//STRIP001 										SELECT_BITMAP( BMP_CIRCLES_2D ),
//STRIP001 										String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_DONUT1 + 1,
//STRIP001 										SELECT_BITMAP( BMP_DONUT1_2D ),
//STRIP001 										String(SchResId(STR_DONUT1)));
//STRIP001 				String aResStr( SchResId( STR_OFS ));
//STRIP001 				String aOfsStr = aResStr;
//STRIP001 
//STRIP001 				xub_StrLen nFound = aResStr.SearchAscii( "$(N)" );
//STRIP001 				if( nFound != STRING_NOTFOUND )
//STRIP001 					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 1 ));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem( (USHORT)CHSTYLE_2D_PIE_SEGOF1 + 1,
//STRIP001 										SELECT_BITMAP( BMP_CIRCLES_2D_1 ),
//STRIP001 										aOfsStr );
//STRIP001 
//STRIP001 				aOfsStr = aResStr;
//STRIP001 				if( nFound != STRING_NOTFOUND )
//STRIP001 					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 2 ));
//STRIP001 
//STRIP001 				aCtlVariant.InsertItem( (USHORT)CHSTYLE_2D_PIE_SEGOFALL + 1,
//STRIP001 										SELECT_BITMAP( BMP_CIRCLES_2D_2 ),
//STRIP001 										aOfsStr );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			case CHTYPE_XY:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XYSYMBOLS + 1,
//STRIP001 									   SELECT_BITMAP( BMP_XYSYMB_2D ),
//STRIP001 									   String(SchResId(STR_ONLY_SYMBOLS)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XY + 1,
//STRIP001 									   SELECT_BITMAP( BMP_XY_2D ),
//STRIP001 									   String(SchResId(STR_LINE_SYMBOLS)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XY_LINE + 1,
//STRIP001 									   SELECT_BITMAP( BMP_LINES_2D_1 ),
//STRIP001 									   String(SchResId(STR_ONLY_LINES)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_XY + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_CUBIC ),
//STRIP001 									   String(SchResId(STR_SPLINE_CUBIC)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_CUBIC_SYMBOL ),
//STRIP001 									   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_XY + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_B ),
//STRIP001 									   String(SchResId(STR_SPLINE_B)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_SYMBOL_XY + 1,
//STRIP001 									   SELECT_BITMAP( BMP_SPLINE_B_SYMBOL ),
//STRIP001 									   String(SchResId(STR_SPLINE_B_SYMBOL)));
//STRIP001 				break;
//STRIP001 			case CHTYPE_NET:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NET_2D ),
//STRIP001 									   String(SchResId(STR_NORMAL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_STACK + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NET_2D_STACK ),
//STRIP001 									   String(SchResId(STR_STACKED)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_PERCENT + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NET_2D_PERCENT ),
//STRIP001 									   String(SchResId(STR_PERCENT)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NETSYMB_2D ),
//STRIP001 									   String(SchResId(STR_SYMBOL)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS_STACK + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NETSYMB_2D_STACK ),
//STRIP001 									   String(SchResId(STR_SYMBOL_STACK)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS_PERCENT + 1,
//STRIP001 									   SELECT_BITMAP( BMP_NETSYMB_2D_PERCENT ),
//STRIP001 									   String(SchResId(STR_SYMBOL_PERCENT)));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case CHTYPE_STOCK:
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_1 + 1,
//STRIP001 									   SELECT_BITMAP( BMP_STOCK_1 ),
//STRIP001 									   String(SchResId(STR_STOCK_1)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_2 + 1,
//STRIP001 									   SELECT_BITMAP( BMP_STOCK_2 ),
//STRIP001 									   String(SchResId(STR_STOCK_2)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_3 + 1,
//STRIP001 									   SELECT_BITMAP( BMP_STOCK_3 ),
//STRIP001 									   String(SchResId(STR_STOCK_3)));
//STRIP001 				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_4 + 1,
//STRIP001 									   SELECT_BITMAP( BMP_STOCK_4 ),
//STRIP001 									   String(SchResId(STR_STOCK_4)));
//STRIP001 				nDefaultOffset = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aCtlVariant.Show();
//STRIP001 
//STRIP001 	USHORT nSelId = aCtlVariant.GetItemId(0);
//STRIP001 	const SfxPoolItem *pPoolItem = NULL;
//STRIP001 
//STRIP001 	if( rOutAttrs.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		USHORT nId = (USHORT)((const SvxChartStyleItem*)pPoolItem)->GetValue() + 1;
//STRIP001 		
//STRIP001 		if( aCtlVariant.GetItemPos(nId) != VALUESET_ITEM_NOTFOUND )
//STRIP001 		{
//STRIP001 			nSelId = nId;
//STRIP001 			nDefaultOffset = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	long nShape3dOffset = 0;
//STRIP001 	if( rOutAttrs.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		long nId3D = ((const SfxInt32Item*)&pPoolItem)->GetValue();
//STRIP001 		switch( n3DGeometry )
//STRIP001 		{
//STRIP001 			case CHART_SHAPE3D_CYLINDER:
//STRIP001 				nShape3dOffset = OFFSET_ROUND;
//STRIP001 				break;
//STRIP001 			case CHART_SHAPE3D_CONE:
//STRIP001 				nShape3dOffset = OFFSET_CONE;
//STRIP001 				break;
//STRIP001 			case CHART_SHAPE3D_PYRAMID:
//STRIP001 				nShape3dOffset = OFFSET_PYRAMID;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( aCtlVariant.GetItemPos( nSelId + nShape3dOffset + nDefaultOffset ) != VALUESET_ITEM_NOTFOUND )
//STRIP001 		nSelId += (nShape3dOffset + nDefaultOffset);
//STRIP001 
//STRIP001 	aCtlVariant.SelectItem( nSelId );
//STRIP001 
//STRIP001 	// make selected Item visible
//STRIP001 	aCtlVariant.SetFirstLine( aCtlVariant.GetItemPos( aCtlVariant.GetSelectItemId() ) / aCtlVariant.GetColCount() );
//STRIP001 								
//STRIP001 	SwitchDepth( nSelId - 1 );
//STRIP001     SwitchNumLines( nSelId - 1 );
//STRIP001 }

/*************************************************************************
|*
|* Select-Hdl der Dimensions-Buttons
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SchDiagramTypeDlg, SelectDimensionHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	FillTypeSet(aRbt3D.IsChecked() ? CHDIM_3D : CHDIM_2D);
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SchDiagramTypeDlg, SelectTypeHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	FillVariantSet(aCtlType.GetSelectItemId());
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SchDiagramTypeDlg, DoubleClickHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|*    Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

//STRIP001 void SchDiagramTypeDlg::GetAttr(SfxItemSet& rOutAttrs)
//STRIP001 {
//STRIP001 	long nId=aCtlVariant.GetSelectItemId() - 1;
//STRIP001 	long nGeo=CHART_SHAPE3D_ANY;
//STRIP001 	if(nId>OFFSET_CONE)
//STRIP001 	{
//STRIP001 		nId-=OFFSET_CONE;
//STRIP001 		nGeo=CHART_SHAPE3D_CONE;
//STRIP001 	}
//STRIP001 	if(nId>OFFSET_ROUND)
//STRIP001 	{
//STRIP001 		nId-=OFFSET_ROUND;
//STRIP001 		nGeo=CHART_SHAPE3D_CYLINDER;
//STRIP001 	}
//STRIP001 	if(nId>OFFSET_PYRAMID)
//STRIP001 	{
//STRIP001 		nId-=OFFSET_PYRAMID;
//STRIP001 		nGeo=CHART_SHAPE3D_PYRAMID;
//STRIP001 	}
//STRIP001 	if(nGeo != n3DGeometry)
//STRIP001 		rOutAttrs.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nGeo));
//STRIP001 	else
//STRIP001 		rOutAttrs.ClearItem(SCHATTR_STYLE_SHAPE);
//STRIP001 
//STRIP001 	rOutAttrs.Put(SvxChartStyleItem((SvxChartStyle)	(nId)));
//STRIP001 }

/*************************************************************************
|*
|* Gibt die eingestellte Intensitaet als double zurueck
|*
\************************************************************************/

//STRIP001 int SchDiagramTypeDlg::GetDepth()
//STRIP001 {
//STRIP001 	return aMtrFldDeep.GetValue();
//STRIP001 }

/*************************************************************************
|*
|* Setzt die uebergebene Intensitaet
|*
\************************************************************************/

//STRIP001 void SchDiagramTypeDlg::SetDepth( int nDepth )
//STRIP001 {
//STRIP001 	 aMtrFldDeep.SetValue( nDepth );
//STRIP001 }

/*************************************************************************
|*
|* Setzt die uebergebene Intensitaet
|*
\************************************************************************/

//STRIP001 void SchDiagramTypeDlg::SwitchDepth (USHORT nID)
//STRIP001 {
//STRIP001 	aFtDeep.Hide ();
//STRIP001 	aMtrFldDeep.Hide ();
//STRIP001 	aFtGran.Hide ();
//STRIP001 	aMtrFldGran.Hide ();
//STRIP001 
//STRIP001 	switch (nID)
//STRIP001 	{
//STRIP001 		case CHSTYLE_2D_B_SPLINE :
//STRIP001 		case CHSTYLE_2D_B_SPLINE_SYMBOL :
//STRIP001 		case CHSTYLE_2D_B_SPLINE_XY :
//STRIP001 		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
//STRIP001 			aFtDeep.Show ();
//STRIP001 			aMtrFldDeep.Show ();
//STRIP001 
//STRIP001 		case CHSTYLE_2D_CUBIC_SPLINE :
//STRIP001 		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
//STRIP001 		case CHSTYLE_2D_CUBIC_SPLINE_XY :
//STRIP001 		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
//STRIP001 			aFtGran.Show ();
//STRIP001 			aMtrFldGran.Show ();
//STRIP001 			break;
//STRIP001 
//STRIP001 		default :
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SchDiagramTypeDlg, ClickHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SwitchDepth (aCtlVariant.GetSelectItemId() - 1);
//STRIP001     SwitchNumLines( aCtlVariant.GetSelectItemId() - 1 );
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Laedt die Splineaufloesung
|*
\************************************************************************/

//STRIP001 int SchDiagramTypeDlg::GetGranularity()
//STRIP001 {
//STRIP001 	return aMtrFldGran.GetValue();
//STRIP001 }

/*************************************************************************
|*
|* Setzt die Splineaufloesung
|*
\************************************************************************/

//STRIP001 void SchDiagramTypeDlg::SetGranularity( int nGranularity )
//STRIP001 {
//STRIP001 	aMtrFldGran.SetValue( nGranularity );
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramTypeDlg::FillValueSets()
//STRIP001 {
//STRIP001     // type category (2d or 3d)
//STRIP001     FillTypeSet( eDimension, true /* force change */ );
//STRIP001 
//STRIP001     // sub-type
//STRIP001     USHORT nId = aCtlType.GetSelectItemId();
//STRIP001     if( nId != 0 )
//STRIP001     {
//STRIP001         FillVariantSet( nId );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramTypeDlg::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     ModalDialog::DataChanged( rDCEvt );
//STRIP001 
//STRIP001     if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001         FillValueSets();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SchDiagramTypeDlg::SwitchNumLines( USHORT nID )
//STRIP001 {
//STRIP001     switch( nID )
//STRIP001     {
//STRIP001         case CHSTYLE_2D_LINE_COLUMN:
//STRIP001         case CHSTYLE_2D_LINE_STACKEDCOLUMN:
//STRIP001             aFtNumLines.Show();
//STRIP001             aMtrFldNumLines.Show();
//STRIP001             break;
//STRIP001 
//STRIP001         default:
//STRIP001             aFtNumLines.Hide();
//STRIP001             aMtrFldNumLines.Hide();
//STRIP001             break;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramTypeDlg::SetMaximumNumberOfLines( long nMaxLines )
//STRIP001 {
//STRIP001     aMtrFldNumLines.SetLast( nMaxLines );
//STRIP001     aMtrFldNumLines.SetMax( nMaxLines );
//STRIP001 }
//STRIP001 
//STRIP001 void SchDiagramTypeDlg::SetNumberOfLines( long nLines )
//STRIP001 {
//STRIP001     aMtrFldNumLines.SetValue( nLines );
//STRIP001 }
//STRIP001 
//STRIP001 long SchDiagramTypeDlg::GetNumberOfLines() const
//STRIP001 {
//STRIP001     return aMtrFldNumLines.GetValue();
//STRIP001 }

}
