/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdmtf.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:04:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


//STRIP001 #ifndef _SD_SDMTF_HXX
//STRIP001 #define _SD_SDMTF_HXX

//STRIP001 #ifndef _SV_GDIMTF_HXX
//STRIP001 #include <vcl/gdimtf.hxx>
//STRIP001 #endif

/******************************************************************************
|*
|*
|*
\******************************************************************************/

//STRIP001 #define MARKER_NONE					((ULONG)0x00000000)
//STRIP001 #define MARKER_START				((ULONG)0x00000001)
//STRIP001 #define MARKER_END					((ULONG)0x00000002)
//STRIP001 #define MARKER_PAGE					((ULONG)0x00000100)
//STRIP001 #define	MARKER_ANIMOBJ				((ULONG)0x00000200)
//STRIP001 #define MARKER_BACKGROUND			((ULONG)0x00000400)
//STRIP001 #define MARKER_MTF					((ULONG)0x00000800)
//STRIP001 #define MARKER_FIRST				((ULONG)0x00001000)
//STRIP001 #define MARKER_SLOWOBJ				((ULONG)0x00100000)
//STRIP001 
//STRIP001 #define	MTF_START					Marker( NULL, MARKER_MTF | MARKER_START )
//STRIP001 #define	MTF_END						Marker( NULL, MARKER_MTF | MARKER_END )
//STRIP001 #define FIRST_START					Marker( NULL, MARKER_FIRST | MARKER_START )
//STRIP001 #define PAGE_START					Marker( NULL, MARKER_PAGE | MARKER_START )
//STRIP001 #define PAGE_END					Marker( NULL, MARKER_PAGE | MARKER_END )
//STRIP001 #define BACKOBJ_START				Marker( NULL, MARKER_BACKGROUND | MARKER_START )
//STRIP001 #define BACKOBJ_END					Marker( NULL, MARKER_BACKGROUND | MARKER_END )
//STRIP001 #define OBJ_START( pObj, bSlow )	Marker( pObj, MARKER_ANIMOBJ | MARKER_START | ( (bSlow) ? MARKER_SLOWOBJ : 0L ) )
//STRIP001 #define OBJ_END( pObj, bSlow )		Marker( pObj, MARKER_ANIMOBJ | MARKER_END | ( (bSlow) ? MARKER_SLOWOBJ : 0L ) )


/******************************************************************************
|*
|*
|*
\******************************************************************************/

//STRIP001 class Marker
//STRIP001 {
//STRIP001 	friend class SdMetaFile;
//STRIP001 
//STRIP001 	void*		pObj;
//STRIP001 	ULONG		nFlags;
//STRIP001 	ULONG		nMtfPos;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 				Marker( void* _pObj = NULL, ULONG _nFlags = MARKER_NONE ) : pObj( _pObj ), nFlags( _nFlags ), nMtfPos( GDI_METAFILE_END ) {}
//STRIP001 				~Marker() {}
//STRIP001 
//STRIP001 	inline BOOL	operator==( const Marker& rMarker ) const { return ( ( pObj == rMarker.pObj ) && ( nFlags == rMarker.nFlags ) ); }
//STRIP001 
//STRIP001 	BOOL		IsStart() const { return ( ( nFlags & MARKER_START ) == MARKER_START ); }
//STRIP001 	BOOL		IsEnd() const { return ( ( nFlags & MARKER_END ) == MARKER_END ); }
//STRIP001 	BOOL		IsObj() const { return ( ( nFlags & MARKER_ANIMOBJ ) == MARKER_ANIMOBJ ); }
//STRIP001 	BOOL		IsSlowObj() const { return IsObj() && ( ( nFlags & MARKER_SLOWOBJ ) == MARKER_SLOWOBJ ); }
//STRIP001 	BOOL		IsPage() const { return ( ( nFlags & MARKER_PAGE ) == MARKER_PAGE ); }
//STRIP001 	BOOL		IsMtf() const { return ( ( nFlags & MARKER_MTF ) == MARKER_MTF ); }
//STRIP001 	BOOL		IsBackground() const { return ( ( nFlags & MARKER_BACKGROUND ) == MARKER_BACKGROUND ); }
//STRIP001 
//STRIP001 	BOOL		IsObjStart() const { return IsObj() && IsStart(); }
//STRIP001 	BOOL		IsObjEnd() const { return IsObj() && IsEnd(); }
//STRIP001 
//STRIP001 	BOOL		IsMtfStart() const { return IsMtf() && IsStart(); }
//STRIP001 	BOOL		IsMtfEnd() const { return IsMtf() && IsEnd(); }
//STRIP001 
//STRIP001 	BOOL		IsPageStart() const { return IsPage() && IsStart(); }
//STRIP001 	BOOL		IsPageEnd() const { return IsPage() && IsEnd(); }
//STRIP001 
//STRIP001 	BOOL		IsBackgroundStart() const { return IsBackground() && IsStart(); }
//STRIP001 	BOOL		IsBackgroundEnd() const { return IsBackground() && IsEnd(); }
//STRIP001 
//STRIP001 	ULONG		GetMtfPos() const { return nMtfPos; }
//STRIP001 };


/******************************************************************************
|*
|*
|*
\******************************************************************************/

//STRIP001 class FuSlideShow;
//STRIP001 class SdrObject;

//STRIP001 class SdMetaFile : public GDIMetaFile
//STRIP001 {
//STRIP001 	FuSlideShow*	pFuSlideShow;
//STRIP001 	List*			pMarkerList;
//STRIP001 
//STRIP001 					SdMetaFile( const SdMetaFile& ) {};
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	ULONG			ImpGetMarkerPos( const Marker& rMarker );
//STRIP001 	void			ImpPlayToNextStart( ULONG& rMarker, OutputDevice* pOut );
//STRIP001 	void			ImpPlayToNextMarker( ULONG& rMarker, OutputDevice* pOut );
//STRIP001 	void			ImpPlaySlowObj( ULONG& rMarker, OutputDevice* pOut );
//STRIP001 	void			ImpSkipActualObject( ULONG& rMarker, OutputDevice* pOut );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					SdMetaFile( FuSlideShow* pShow );
//STRIP001 	virtual			~SdMetaFile();
//STRIP001 
//STRIP001 	void			Clear();
//STRIP001 	void			InsertMarker( const Marker& rMarker );
//STRIP001 	BOOL			ReplaceMarker( const Marker& rMarker, const Marker& rNewMarker );
//STRIP001 	BOOL			HasMarker( const Marker& rMarker ) const;
//STRIP001 	void			Play( OutputDevice* pOut,
//STRIP001 						  const Marker& rStartMarker, const Marker& rEndMarker,
//STRIP001 						  BOOL bUseOutDevDrawMode = FALSE );
//STRIP001 };


//STRIP001 #endif // _SD_SDMTF_HXX


