/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmshell.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:45:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
// auto strip #ifndef _SVX_FMVWIMP_HXX
// auto strip #include "fmvwimp.hxx"
// auto strip #endif

#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include "fmservs.hxx"
// auto strip #endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
// auto strip #ifndef _SVX_FMUNOPGE_HXX
// auto strip #include "fmpgeimp.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMITEMS_HXX
// auto strip #include "fmitems.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMUNDO_HXX
// auto strip #include "fmundo.hxx"
// auto strip #endif

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

// auto strip #ifndef _MULTIPRO_HXX
// auto strip #include "multipro.hxx"
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
// auto strip #include <com/sun/star/form/XLoadable.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_
// auto strip #include <com/sun/star/container/XNamed.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDDB_PRIVILEGE_HPP_
// auto strip #include <com/sun/star/sdbcx/Privilege.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HPP_
// auto strip #include <com/sun/star/form/XConfirmDeleteListener.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_ROWCHANGEACTION_HPP_
// auto strip #include <com/sun/star/sdb/RowChangeAction.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XMultiPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XFastPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
// auto strip #include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
// auto strip #include <com/sun/star/lang/XServiceInfo.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
// auto strip #include <com/sun/star/container/XNameContainer.hpp>
// auto strip #endif

#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif

// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif

// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif

// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif

#ifndef _SFXOBJFACE_HXX //autogen
#include <bf_sfx2/objface.hxx>
#endif

#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif

// auto strip #ifndef _SVDOBJ_HXX //autogen
// auto strip #include "svdobj.hxx"
// auto strip #endif

#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif

// auto strip #ifndef _SVDITER_HXX //autogen
// auto strip #include "svditer.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMOBJ_HXX
// auto strip #include "fmobj.hxx"
// auto strip #endif

#ifndef _SVX_SVXIDS_HRC
#include "svxids.hrc"
#endif

// auto strip #ifndef _SVX_TABORDER_HXX
// auto strip #include "taborder.hxx"
// auto strip #endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

// auto strip #ifndef _SVX_FMEXCH_HXX
// auto strip #include "fmexch.hxx"
// auto strip #endif

#ifndef _SVX_FMGLOB_HXX
#include "fmglob.hxx"
#endif

// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGE_HXX //autogen
// auto strip #include <svdpage.hxx>
// auto strip #endif

#ifndef _SVX_FMMODEL_HXX
#include "fmmodel.hxx"
#endif

#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif

#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif

#ifndef _SFX_OBJITEM_HXX //autogen
#include <bf_sfx2/objitem.hxx>
#endif

#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif

// auto strip #ifndef _SV_SOUND_HXX //autogen
// auto strip #include <vcl/sound.hxx>
// auto strip #endif

#ifndef _SVX_FMEXPL_HXX
#include "fmexpl.hxx"
#endif

// auto strip #ifndef _NUMUNO_HXX //autogen
// auto strip #include <svtools/numuno.hxx>
// auto strip #endif

#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
// auto strip #ifndef _COMPHELPER_TYPES_HXX_
// auto strip #include <comphelper/types.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

#define HANDLE_SQL_ERRORS( action, successflag, context, message )			\
	try 																	\
	{																		\
		successflag = sal_False;												\
		action; 															\
		successflag = sal_True; 												\
	}																		\
	catch(::com::sun::star::sdbc::SQLException& e)													\
	{																		\
		::com::sun::star::sdb::SQLContext eExtendedInfo =											\
		GetImpl()->prependContextInfo(e, Reference< XInterface > (), context, ::rtl::OUString());			   \
		displayException(eExtendedInfo);									\
	}																		\
	catch(Exception&)															\
	{																		\
		DBG_ERROR(message); 												\
	}																		\


#define DO_SAFE_WITH_ERROR( action, message ) try { action; } catch(Exception&) { DBG_ERROR(message); }


extern SfxType0 aSfxVoidItem_Impl;

#define FmFormShell
#include <svxslots.hxx>
} //namespace binfilter
#ifndef _SVX_SVXIDS_HRC
#include <svxids.hrc>
#endif

// auto strip #ifndef _SVX_TBXFORM_HXX
// auto strip #include "tbxform.hxx"
// auto strip #endif

// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
// auto strip #include <com/sun/star/beans/PropertyValue.hpp>
// auto strip #endif
namespace binfilter {//STRIP009
// wird fuer Invalidate verwendet -> mitpflegen
// aufsteigend sortieren !!!!!!
sal_uInt16 ControllerSlotMap[] =	// slots des Controllers
{
	SID_FM_CONFIG,
	SID_FM_PUSHBUTTON,
	SID_FM_RADIOBUTTON,
	SID_FM_CHECKBOX,
	SID_FM_FIXEDTEXT,
	SID_FM_GROUPBOX,
	SID_FM_EDIT,
	SID_FM_LISTBOX,
	SID_FM_COMBOBOX,
	SID_FM_URLBUTTON,
	SID_FM_DBGRID,
	SID_FM_IMAGEBUTTON,
	SID_FM_FILECONTROL,
	SID_FM_CTL_PROPERTIES,
	SID_FM_PROPERTIES,
	SID_FM_TAB_DIALOG,
	SID_FM_ADD_FIELD,
	SID_FM_DESIGN_MODE,
	SID_FM_SHOW_FMEXPLORER,
	SID_FM_SHOW_PROPERTIES,
	SID_FM_FMEXPLORER_CONTROL,
	SID_FM_DATEFIELD,
	SID_FM_TIMEFIELD,
	SID_FM_NUMERICFIELD,
	SID_FM_CURRENCYFIELD,
	SID_FM_PATTERNFIELD,
	SID_FM_OPEN_READONLY,
	SID_FM_IMAGECONTROL,
	SID_FM_USE_WIZARDS,
	SID_FM_FORMATTEDFIELD,
	SID_FM_FILTER_NAVIGATOR,
	SID_FM_AUTOCONTROLFOCUS,

	0
};

sal_uInt16 DatabaseSlotMap[] =	// slots des Controllers
{
	SID_FM_RECORD_FIRST,
	SID_FM_RECORD_NEXT,
	SID_FM_RECORD_PREV,
	SID_FM_RECORD_LAST,
	SID_FM_RECORD_NEW,
	SID_FM_RECORD_DELETE,
	SID_FM_RECORD_ABSOLUTE,
	SID_FM_RECORD_TOTAL,
	SID_FM_RECORD_SAVE,
	SID_FM_RECORD_UNDO,
	SID_FM_REMOVE_FILTER_SORT,
	SID_FM_SORTUP,
	SID_FM_SORTDOWN,
	SID_FM_ORDERCRIT,
	SID_FM_AUTOFILTER,
	SID_FM_FORM_FILTERED,
	SID_FM_REFRESH,
	SID_FM_SEARCH,
	SID_FM_FILTER_START,
	SID_FM_VIEW_AS_GRID,
	0
};

sal_uInt16 AutoSlotMap[] =
{
	SID_FM_SORTUP,
	SID_FM_SORTDOWN,
	SID_FM_AUTOFILTER,
	0
};
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::form;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;

//========================================================================
//========================================================================
//#ifdef NOOLDSV
////------------------------------------------------------------------------
///*?*/ FmFormShell::FormShellWaitObject::FormShellWaitObject(const FmFormShell* _pShell)
///*?*/ 	:m_pWindow(NULL)
///*?*/ {
///*?*/ 	const OutputDevice* pDevice = _pShell ? _pShell->GetCurrentViewDevice() : NULL;
///*?*/ 	m_pWindow = pDevice && (pDevice->GetOutDevType() == OUTDEV_WINDOW) ? const_cast<Window*>(static_cast<const Window*>(pDevice)) : NULL;
///*?*/ 
///*?*/ 	if (m_pWindow)
///*?*/ 		m_pWindow->EnterWait();
///*?*/ 	else
///*?*/ 		DBG_ERROR("FormShellWaitObject::FormShellWaitObject : could not find a window for the waitcursor !");
///*?*/ }
///*?*/ //------------------------------------------------------------------------
///*?*/ FmFormShell::FormShellWaitObject::~FormShellWaitObject()
///*?*/ {
///*?*/ 	if (m_pWindow)
///*?*/ 		m_pWindow->LeaveWait();
///*?*/ }
//#else
//class FormShellWaitObject : public WaitObject
//{
//public:
///*?*/ 	FormShellWaitObject(FmFormShell* _pShell) { }
//};
//#endif
//========================================================================
//------------------------------------------------------------------------
//STRIP001 sal_Bool IsFormComponent( const SdrObject& rObj )
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Gruppenobjekte rekursiv pruefen
//STRIP001 	if( rObj.IsGroupObject() )
//STRIP001 	{
//STRIP001 		SdrObject* pObj;
//STRIP001 		SdrObjListIter aIter( *rObj.GetSubList() );
//STRIP001 
//STRIP001 		while( aIter.IsMore() )
//STRIP001 		{
//STRIP001 			pObj = aIter.Next();
//STRIP001 
//STRIP001 			if( !IsFormComponent(*pObj) )
//STRIP001 				return sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//////////////////////////////////////////////////////////////////
//STRIP001 	// ...ansonsten Pruefen, ob SdrObj eine FormComponent ist
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( !rObj.ISA(SdrUnoObj) )
//STRIP001 			return sal_False;
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::form::XFormComponent >  xFormComponent(((SdrUnoObj*)&rObj)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 		if (!xFormComponent.is())
//STRIP001 			return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_True;
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 sal_Bool IsFormComponentList( const SdrMarkList& rMarkList )
//STRIP001 {
//STRIP001 	sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
//STRIP001 
//STRIP001 	if( nMarkCount==0 )
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	SdrObject* pObj;
//STRIP001 	for( sal_uInt32 i=0; i<nMarkCount; ++i )
//STRIP001 	{
//STRIP001 		pObj = rMarkList.GetMark(i)->GetObj();
//STRIP001 		if( !IsFormComponent(*pObj) )
//STRIP001 			return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_True;
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 sal_Bool IsFormComponentList( const SdrObjList& rSdrObjList )
//STRIP001 {
//STRIP001 	SdrObject* pSdrObj;
//STRIP001 
//STRIP001 
//STRIP001 	SdrObjListIter aIter( rSdrObjList );
//STRIP001 	while( aIter.IsMore() )
//STRIP001 	{
//STRIP001 		pSdrObj = aIter.Next();
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////
//STRIP001 		// Gruppenobjekte rekursiv pruefen
//STRIP001 		if( pSdrObj->IsGroupObject() )
//STRIP001 		{
//STRIP001 			if( !IsFormComponentList(*pSdrObj->GetSubList()) )
//STRIP001 				return sal_False;
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////
//STRIP001 		// ...ansonsten Pruefen, ob SdrObj eine FormComponent ist
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (!pSdrObj->ISA(SdrUnoObj))
//STRIP001 				return sal_False;
//STRIP001 
//STRIP001 			Reference< ::com::sun::star::form::XFormComponent >  xFormComponent(((SdrUnoObj*)pSdrObj)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 			if (!xFormComponent.is())
//STRIP001 				return sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_True;
//STRIP001 }

#if SUPD>500
//========================================================================
// class FmDesignModeChangedHint
//========================================================================
/*N*/ TYPEINIT1( FmDesignModeChangedHint, SfxHint );

//------------------------------------------------------------------------
/*N*/ FmDesignModeChangedHint::FmDesignModeChangedHint( sal_Bool bDesMode )
/*N*/ 	:m_bDesignMode( bDesMode )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmDesignModeChangedHint::~FmDesignModeChangedHint()
/*N*/ {
/*N*/ }
#endif

//========================================================================
const sal_uInt32 FM_UI_FEATURE_SHOW_DATABASEBAR 	= 0x00000001;
const sal_uInt32 FM_UI_FEATURE_SHOW_FIELD			= 0x00000002;
const sal_uInt32 FM_UI_FEATURE_SHOW_PROPERTIES		= 0x00000004;
const sal_uInt32 FM_UI_FEATURE_SHOW_EXPLORER			= 0x00000008;
const sal_uInt32 FM_UI_FEATURE_SHOW_FILTERBAR		= 0x00000010;
const sal_uInt32 FM_UI_FEATURE_SHOW_FILTERNAVIGATOR = 0x00000020;

/*N*/ SFX_IMPL_INTERFACE(FmFormShell, SfxShell, SVX_RES(RID_STR_FORMSHELL))
/*N*/ {
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_NAVIGATION|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_READONLYDOC,
/*N*/ 		SVX_RES(RID_SVXTBX_FORM_NAVIGATION),
/*N*/ 		FM_UI_FEATURE_SHOW_DATABASEBAR );
/*N*/ 
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_NAVIGATION|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_READONLYDOC,
/*N*/ 		SVX_RES(RID_SVXTBX_FORM_FILTER),
/*N*/ 		FM_UI_FEATURE_SHOW_FILTERBAR );
/*N*/ 
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_ADD_FIELD, FM_UI_FEATURE_SHOW_FIELD);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_SHOW_PROPERTIES, FM_UI_FEATURE_SHOW_PROPERTIES);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_SHOW_FMEXPLORER, FM_UI_FEATURE_SHOW_EXPLORER);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_FILTER_NAVIGATOR, FM_UI_FEATURE_SHOW_FILTERNAVIGATOR);
/*N*/ }

//========================================================================
/*N*/ TYPEINIT1(FmFormShell,SfxShell)

//------------------------------------------------------------------------
/*N*/ FmFormShell::FmFormShell( SfxViewShell* _pParent, FmFormView* pView )
/*N*/ 			:SfxShell(_pParent)
/*N*/ 			,m_pFormView( pView )
/*N*/ 			,m_pFormModel( NULL )
/*N*/ 			,m_pImpl(new FmXFormShell(this, _pParent->GetViewFrame()))
/*N*/ 			,m_nLastSlot( 0 )
/*N*/ 			,m_bDesignMode( sal_True )
/*N*/ 			,m_bHasForms(sal_False)
/*N*/ 			,m_pParentShell(_pParent)
/*N*/ {
/*N*/ 	m_pImpl->acquire();
/*N*/ 	SetPool( &SFX_APP()->GetPool() );
/*N*/ 	String sName;
/*N*/ 	sName.AssignAscii("Form");
/*N*/ 	SetName( sName );
/*N*/ 	// SetHelpId( SVX_INTERFACE_FORM_SH );
/*N*/ 
/*N*/ 	SetView(m_pFormView);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmFormShell::~FmFormShell()
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 		GetImpl()->ResetForms();
/*N*/ 
/*N*/ 	m_pImpl->dispose();
/*N*/ 	m_pImpl->release();
/*N*/ 	
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		m_pFormView->SetFormShell(NULL);
/*N*/ 		m_pFormView  = NULL;
/*N*/ 	}
/*N*/ 	
/*N*/ 
/*N*/ 	// reset the model after disposing the shell !
/*N*/ 	m_pFormModel = NULL;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::NotifyMarkListChanged(FmFormView* pWhichView)
/*N*/ {
/*N*/ 	FmNavViewMarksChanged aChangeNotification(pWhichView);
/*N*/ 	Broadcast(aChangeNotification);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_uInt16 FmFormShell::PrepareClose(sal_Bool bUI, sal_Bool bForBrowsing)
/*N*/ {
/*N*/ 	if ( GetImpl()->m_bPreparedClose )
/*N*/ 		// we already did a PrepareClose for the current modifications of the current form
/*N*/ 		// 2002-11-12 #104702# - fs@openoffice.org
/*N*/ 		return sal_True;
/*N*/ 
/*N*/ 	sal_Bool nResult = sal_True;
/*N*/ 	// Save the data records, not in DesignMode and FilterMode
/*N*/ 	if (!m_bDesignMode && !GetImpl()->isInFilterMode() &&
/*N*/ 		m_pFormView && m_pFormView->GetActualOutDev() &&
/*N*/ 		m_pFormView->GetActualOutDev()->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 	{
/*N*/ 		if (GetImpl()->HasAnyPendingCursorAction())
/*?*/			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			GetImpl()->CancelAnyPendingCursorAction();
/*?*/ 
/*N*/ 		SdrPageView* pCurPageView = m_pFormView->GetPageViewPvNum(0);
/*N*/ 		sal_uInt16 nPos = pCurPageView ? pCurPageView->GetWinList().Find((OutputDevice*)m_pFormView->GetActualOutDev()) : SDRPAGEVIEWWIN_NOTFOUND;
/*N*/ 		if (nPos != SDRPAGEVIEWWIN_NOTFOUND)
/*N*/ 		{
/*N*/ 			// Zunaechst werden die aktuellen Inhalte der Controls gespeichert
/*N*/ 			// Wenn alles glatt gelaufen ist, werden die modifizierten Datensaetze gespeichert
/*N*/ 			Reference< ::com::sun::star::form::XFormController >  xController(GetImpl()->getActiveController());
/*N*/ 			if (xController.is() && FmXFormShell::CommitCurrent(xController))
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 				sal_Bool bModified = FmXFormShell::IsModified(xController);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( bModified && bUI )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					QueryBox aQry(NULL, SVX_RES(RID_QRY_SAVEMODIFIED));
//STRIP001 /*?*/ 					if (bForBrowsing)
//STRIP001 /*?*/ 						aQry.AddButton(ResId(RID_STR_NEW_TASK), RET_NEWTASK,
//STRIP001 /*?*/ 							BUTTONDIALOG_DEFBUTTON | BUTTONDIALOG_FOCUSBUTTON);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					switch (aQry.Execute())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						case RET_NO:
//STRIP001 /*?*/ 							bModified = sal_False;
//STRIP001 /*?*/ 							GetImpl()->m_bPreparedClose = sal_True;
//STRIP001 /*?*/ 							break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						case RET_CANCEL:
//STRIP001 /*?*/ 							return sal_False;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						case RET_NEWTASK:
//STRIP001 /*?*/ 							return RET_NEWTASK;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (bModified)
//STRIP001 /*?*/ 						nResult = (sal_Bool)FmXFormShell::SaveModified(xController, sal_False);
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return nResult;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::SetDesignMode(sal_Bool bDesign)
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		if (!bDesign)
/*N*/ 			m_nLastSlot = SID_FM_DESIGN_MODE;
/*N*/ 
/*N*/ 		GetImpl()->SetDesignMode(bDesign);
/*N*/ 		// mein m_bDesignMode wird auch von der Impl gesetzt ...
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		m_bHasForms = sal_False;
/*?*/ 		m_bDesignMode = bDesign;
/*?*/ 		UIFeatureChanged();
/*N*/ 	}
/*N*/ 
/*N*/ 	GetViewShell()->GetViewFrame()->GetBindings().Invalidate(ControllerSlotMap);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool FmFormShell::HasUIFeature( sal_uInt32 nFeature )
/*N*/ {
/*N*/ 	sal_Bool bResult = sal_False;
/*N*/ 	if ((nFeature & FM_UI_FEATURE_SHOW_DATABASEBAR) == FM_UI_FEATURE_SHOW_DATABASEBAR)
/*N*/ 	{
/*N*/ 		// nur wenn auch formulare verfuegbar
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && !GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FILTERBAR) == FM_UI_FEATURE_SHOW_FILTERBAR)
/*N*/ 	{
/*N*/ 		// nur wenn auch formulare verfuegbar
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FILTERNAVIGATOR) == FM_UI_FEATURE_SHOW_FILTERNAVIGATOR)
/*N*/ 	{
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FIELD) == FM_UI_FEATURE_SHOW_FIELD)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_PROPERTIES) == FM_UI_FEATURE_SHOW_PROPERTIES)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_EXPLORER) == FM_UI_FEATURE_SHOW_EXPLORER)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode; // OJ #101593# && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	return bResult;
/*N*/ }
} //namespace binfilter
// auto strip #ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
// auto strip #include <com/sun/star/frame/FrameSearchFlag.hpp>
// auto strip #endif
namespace binfilter {//STRIP009
//------------------------------------------------------------------------
/*N*/ void FmFormShell::Execute(SfxRequest &rReq)
/*N*/ {
/*N*/ 	sal_uInt16 nSlot = rReq.GetSlot();
/*N*/ 
/*N*/ 	//////////////////////////////////////////////////////////////////////
/*N*/ 	// MasterSlot setzen
/*N*/ 	switch( nSlot )
/*N*/ 	{
/*N*/ 		case SID_FM_PUSHBUTTON:
/*N*/ 		case SID_FM_RADIOBUTTON:
/*N*/ 		case SID_FM_CHECKBOX:
/*N*/ 		case SID_FM_FIXEDTEXT:
/*N*/ 		case SID_FM_GROUPBOX:
/*N*/ 		case SID_FM_LISTBOX:
/*N*/ 		case SID_FM_COMBOBOX:
/*N*/ 		case SID_FM_URLBUTTON:
/*N*/ 		case SID_FM_EDIT:
/*N*/ 		case SID_FM_DBGRID:
/*N*/ 		case SID_FM_IMAGEBUTTON:
/*N*/ 		case SID_FM_IMAGECONTROL:
/*N*/ 		case SID_FM_FILECONTROL:
/*N*/ 		case SID_FM_DATEFIELD:
/*N*/ 		case SID_FM_TIMEFIELD:
/*N*/ 		case SID_FM_NUMERICFIELD:
/*N*/ 		case SID_FM_CURRENCYFIELD:
/*N*/ 		case SID_FM_PATTERNFIELD:
/*N*/ 		case SID_FM_FORMATTEDFIELD:
/*?*/ 			m_nLastSlot = nSlot;
/*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate( SID_FM_CONFIG );
/*?*/ 			break;
/*N*/ 		case SID_FM_DESIGN_MODE:	// gibt es was zu tun?
/*N*/ 		{
/*N*/ 			// if we are moving our data source cursor currently ....
/*N*/ 			if (GetImpl()->HasAnyPendingCursorAction())
/*N*/ 				// ... cancel this
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				GetImpl()->CancelAnyPendingCursorAction();
/*N*/ 
/*N*/ 			SFX_REQUEST_ARG(rReq, pDesignItem, SfxBoolItem, nSlot, sal_False);
/*N*/ 			if (!pDesignItem || pDesignItem->GetValue() != m_bDesignMode)
/*N*/ 			{
/*N*/ 				m_nLastSlot = nSlot;
/*N*/ 				GetViewShell()->GetViewFrame()->GetBindings().Invalidate( SID_FM_CONFIG );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				rReq.Done();
/*N*/ 				return;
/*N*/ 			}
/*N*/ 		}	break;
/*N*/ 	}
/*N*/ 
/*N*/ 	//////////////////////////////////////////////////////////////////////
/*N*/ 	// Identifier und Inventor des Uno-Controls setzen
/*N*/ 	sal_uInt16 nIdentifier = 0;
/*N*/ 	switch( nSlot )
/*N*/ 	{
/*?*/ 		case SID_FM_CHECKBOX:
/*?*/ 			nIdentifier = OBJ_FM_CHECKBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_PUSHBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_BUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_FIXEDTEXT:
/*?*/ 			nIdentifier = OBJ_FM_FIXEDTEXT;
/*?*/ 			break;
/*?*/ 		case SID_FM_LISTBOX:
/*?*/ 			nIdentifier = OBJ_FM_LISTBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_EDIT:
/*?*/ 			nIdentifier = OBJ_FM_EDIT;
/*?*/ 			break;
/*?*/ 		case SID_FM_RADIOBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_RADIOBUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_GROUPBOX:
/*?*/ 			nIdentifier = OBJ_FM_GROUPBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_COMBOBOX:
/*?*/ 			nIdentifier = OBJ_FM_COMBOBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_DBGRID:
/*?*/ 			nIdentifier = OBJ_FM_GRID;
/*?*/ 			break;
/*?*/ 		case SID_FM_IMAGEBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_IMAGEBUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_IMAGECONTROL:
/*?*/ 			nIdentifier = OBJ_FM_IMAGECONTROL;
/*?*/ 			break;
/*?*/ 		case SID_FM_FILECONTROL:
/*?*/ 			nIdentifier = OBJ_FM_FILECONTROL;
/*?*/ 			break;
/*?*/ 		case SID_FM_DATEFIELD:
/*?*/ 			nIdentifier = OBJ_FM_DATEFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_TIMEFIELD:
/*?*/ 			nIdentifier = OBJ_FM_TIMEFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_NUMERICFIELD:
/*?*/ 			nIdentifier = OBJ_FM_NUMERICFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_CURRENCYFIELD:
/*?*/ 			nIdentifier = OBJ_FM_CURRENCYFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_PATTERNFIELD:
/*?*/ 			nIdentifier = OBJ_FM_PATTERNFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_FORMATTEDFIELD:
/*?*/ 			nIdentifier = OBJ_FM_FORMATTEDFIELD;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	switch ( nSlot )
/*N*/ 	{
/*N*/ 		case SID_FM_CHECKBOX:
/*N*/ 		case SID_FM_PUSHBUTTON:
/*N*/ 		case SID_FM_FIXEDTEXT:
/*N*/ 		case SID_FM_LISTBOX:
/*N*/ 		case SID_FM_EDIT:
/*N*/ 		case SID_FM_RADIOBUTTON:
/*N*/ 		case SID_FM_COMBOBOX:
/*N*/ 		case SID_FM_GROUPBOX:
/*N*/ 		case SID_FM_DBGRID:
/*N*/ 		case SID_FM_IMAGEBUTTON:
/*N*/ 		case SID_FM_IMAGECONTROL:
/*N*/ 		case SID_FM_FILECONTROL:
/*N*/ 		case SID_FM_DATEFIELD:
/*N*/ 		case SID_FM_TIMEFIELD:
/*N*/ 		case SID_FM_NUMERICFIELD:
/*N*/ 		case SID_FM_CURRENCYFIELD:
/*N*/ 		case SID_FM_PATTERNFIELD:
/*N*/ 		case SID_FM_FORMATTEDFIELD:
/*N*/ 		{
/*?*/ 			SFX_REQUEST_ARG( rReq, pGrabFocusItem, SfxBoolItem, SID_FM_GRABCONTROLFOCUS, sal_False );
/*?*/ 			if ( pGrabFocusItem && pGrabFocusItem->GetValue() )
/*?*/ 			{	// see below
/*?*/ 				SfxViewShell* pShell = GetViewShell();
/*?*/ 				Window* pShellWnd = pShell ? pShell->GetWindow() : NULL;
/*?*/ 				if ( pShellWnd )
/*?*/ 					pShellWnd->GrabFocus();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			SfxUInt16Item aIdentifierItem( SID_FM_CONTROL_IDENTIFIER, nIdentifier );
/*?*/ 			SfxUInt32Item aInventorItem( SID_FM_CONTROL_INVENTOR, FmFormInventor );
/*?*/ 			const SfxPoolItem* pArgs[] =
/*?*/ 			{
/*?*/ 				&aIdentifierItem, &aInventorItem, NULL
/*?*/ 			};
/*?*/ 			const SfxPoolItem* pInternalArgs[] =
/*?*/ 			{
/*?*/ 				NULL
/*?*/ 			};
/*?*/ 
/*?*/ 			GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( SID_FM_CREATE_CONTROL, SFX_CALLMODE_ASYNCHRON,
/*?*/ 									  pArgs, rReq.GetModifier(), pInternalArgs );
/*?*/ 
/*?*/ 			if ( rReq.GetModifier() & KEY_MOD1 )
/*?*/ 			{
/*?*/ 				//	#99013# if selected with control key, return focus to current view
/*?*/ 				// do this asynchron, so that the creation can be finished first
/*?*/ 				// reusing the SID_FM_GRABCONTROLFOCUS is somewhat hacky ... which it wouldn't if it would have another
/*?*/ 				// name, so I do not really have a big problem with this ....
/*?*/ 				SfxBoolItem aGrabFocusIndicatorItem( SID_FM_GRABCONTROLFOCUS, sal_True );
/*?*/ 				GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( nSlot, SFX_CALLMODE_ASYNCHRON,
/*?*/ 										  &aGrabFocusIndicatorItem, NULL );
/*?*/ 			}
/*?*/ 
/*?*/ 			rReq.Done();
/*N*/ 		}	break;
/*N*/ 	}
/*N*/ 
/*N*/ 	sal_Bool bSortUp = sal_True;
/*N*/ 	// Individuelle Aktionen
	switch( nSlot )
/*?*/ 	{{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
//STRIP001 /*?*/ 		case SID_FM_GRABCONTROLFOCUS:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			FmFormView* pFormView = GetFormView();
//STRIP001 /*?*/ 			if ( pFormView )
//STRIP001 /*?*/ 				pFormView->GrabFirstControlFocus( );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case SID_FM_VIEW_AS_GRID:
//STRIP001 /*?*/ 			GetImpl()->CreateExternalView();
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_EDIT			:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_BUTTON			:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_FIXEDTEXT 	:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_LISTBOX		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_CHECKBOX		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_RADIOBUTTON	:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_GROUPBOX		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_COMBOBOX		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_GRID			:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_IMAGEBUTTON	:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_FILECONTROL	:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_DATE			:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_TIME			:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_NUMERIC		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_CURRENCY		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_PATTERN		:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_IMAGECONTROL	:
//STRIP001 /*?*/ 		case SID_FM_CONVERTTO_FORMATTED 	:
//STRIP001 /*?*/ 			GetImpl()->ExecuteControlConversionSlot(Reference< ::com::sun::star::form::XFormComponent > (GetImpl()->getCurControl(), UNO_QUERY),
//STRIP001 /*?*/ 				nSlot);
//STRIP001 /*?*/ 			// nach dem Konvertieren die Selektion neu bestimmern, da sich ja das selektierte Objekt
//STRIP001 /*?*/ 			// geaendert hat
//STRIP001 /*?*/ 			GetImpl()->SetSelection(GetFormView()->GetMarkList());
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 		case SID_FM_LEAVE_CREATE:
//STRIP001 /*?*/ 			m_nLastSlot = 0;
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate( SID_FM_CONFIG );
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 		case SID_FM_SHOW_PROPERTY_BROWSER:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SFX_REQUEST_ARG( rReq, pInterfaceItem, FmInterfaceItem, nSlot, sal_False );
//STRIP001 /*?*/ 			SFX_REQUEST_ARG( rReq, pShowItem, SfxBoolItem, SID_FM_SHOW_PROPERTIES, sal_False );
//STRIP001 /*?*/ 			Reference< XInterface >  xInterface;
//STRIP001 /*?*/ 			sal_Bool bShow = sal_True;
//STRIP001 /*?*/ 			if( pShowItem )
//STRIP001 /*?*/ 				bShow = pShowItem->GetValue();
//STRIP001 /*?*/ 			if( pInterfaceItem )
//STRIP001 /*?*/ 				xInterface = pInterfaceItem->GetInterface();
//STRIP001 /*?*/ 			GetImpl()->ShowProperties( xInterface, bShow );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		} break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case SID_FM_PROPERTIES:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// PropertyBrowser anzeigen
//STRIP001 /*?*/ 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nSlot, sal_False);
//STRIP001 /*?*/ 			sal_Bool bShow = pShowItem ? pShowItem->GetValue() : sal_True;
//STRIP001 /*?*/ 			GetImpl()->setSelObject(GetImpl()->getCurForm());
//STRIP001 /*?*/ 			GetImpl()->ShowProperties(GetImpl()->getCurForm(), bShow );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case SID_FM_CTL_PROPERTIES:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			GetImpl()->setSelObject(GetImpl()->getCurControl());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// PropertyBrowser anzeigen
//STRIP001 /*?*/ 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nSlot, sal_False);
//STRIP001 /*?*/ 			sal_Bool bShow = pShowItem ? pShowItem->GetValue() : sal_True;
//STRIP001 /*?*/ 			GetImpl()->ShowProperties( GetImpl()->getSelObject(), bShow );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_SHOW_PROPERTIES:
//STRIP001 /*?*/ 		case SID_FM_ADD_FIELD:
//STRIP001 /*?*/ 		case SID_FM_FILTER_NAVIGATOR:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->ChildWindowExecute(rReq);
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_SHOW_FMEXPLORER:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (!m_pFormView)	// setzen der ::com::sun::star::sdbcx::View Forcieren
//STRIP001 /*?*/ 				GetViewShell()->GetViewFrame()->GetDispatcher()->Execute(SID_CREATE_SW_DRAWVIEW);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->ChildWindowExecute(rReq);
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_TAB_DIALOG:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			FmTabOrderDlg aTabOrderDlg(::legacy_binfilters::getLegacyProcessServiceFactory(), GetpApp()->GetAppWindow(), this );
//STRIP001 /*?*/ 			aTabOrderDlg.Execute();
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_DESIGN_MODE:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SFX_REQUEST_ARG(rReq, pDesignItem, SfxBoolItem, nSlot, sal_False);
//STRIP001 /*?*/ 			if (!pDesignItem || pDesignItem->GetValue() != m_bDesignMode)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				FmFormModel* pModel = GetFormModel();
//STRIP001 /*?*/ 				if (pModel)
//STRIP001 /*?*/ 				{	// fuer die Zeit des Uebergangs das Undo-Environment ausschalten, das sichert, dass man dort auch nicht-transiente
//STRIP001 /*?*/ 					// Properties mal eben aendern kann (sollte allerdings mit Vorsicht genossen und beim Rueckschalten des Modes
//STRIP001 /*?*/ 					// auch immer wieder rueckgaegig gemacht werden. Ein Beispiel ist das Setzen der maximalen Text-Laenge durch das
//STRIP001 /*?*/ 					// OEditModel an seinem Control.)
//STRIP001 /*?*/ 					pModel->GetUndoEnv().Lock();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// dann die eigentliche Umschaltung
//STRIP001 /*?*/ 				if (m_bDesignMode || PrepareClose(sal_True))
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SetDesignMode(!m_bDesignMode );
//STRIP001 /*?*/ 					rReq.Done();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				// und mein Undo-Environment wieder an
//STRIP001 /*?*/ 				if (pModel)
//STRIP001 /*?*/ 					pModel->GetUndoEnv().UnLock();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_AUTOCONTROLFOCUS:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			FmFormModel* pModel = GetFormModel();
//STRIP001 /*?*/ 			DBG_ASSERT(pModel, "FmFormShell::Execute : invalid call !");
//STRIP001 /*?*/ 				// should have been disabled in GetState if we don't have a FormModel
//STRIP001 /*?*/ 			pModel->SetAutoControlFocus( !pModel->GetAutoControlFocus() );
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_AUTOCONTROLFOCUS);
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		break;
//STRIP001 /*?*/ 		case SID_FM_OPEN_READONLY:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			FmFormModel* pModel = GetFormModel();
//STRIP001 /*?*/ 			DBG_ASSERT(pModel, "FmFormShell::Execute : invalid call !");
//STRIP001 /*?*/ 				// should have been disabled in GetState if we don't have a FormModel
//STRIP001 /*?*/ 			pModel->SetOpenInDesignMode( !pModel->GetOpenInDesignMode() );
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_OPEN_READONLY);
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		break;
//STRIP001 /*?*/ 		case SID_FM_USE_WIZARDS:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			GetImpl()->SetWizardUsing(!GetImpl()->GetWizardUsing());
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_USE_WIZARDS);
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		break;
//STRIP001 /*?*/ 		case SID_FM_SEARCH:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 				GetImpl()->ExecuteSearch();
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		} break;
//STRIP001 /*?*/ 		// First, Next, Prev, Last, Absolute wirken auf den NavController
//STRIP001 /*?*/ 		case SID_FM_RECORD_FIRST:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getNavController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getNavController()->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 				DO_SAFE( xCursor->first(); );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_NEXT:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (!GetImpl()->CommitCurrent(GetImpl()->getNavController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				rReq.Done();
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			// SaveModified kann hier nicht verwendet werden
//STRIP001 /*?*/ 			GetImpl()->MoveRight(GetImpl()->getNavController());
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_PREV:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (!GetImpl()->CommitCurrent(GetImpl()->getNavController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				rReq.Done();
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			// SaveModified kann hier nicht verwendet werden
//STRIP001 /*?*/ 			GetImpl()->MoveLeft(GetImpl()->getNavController());
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_LAST:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getNavController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getNavController()->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// run in an own thread if ...
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	xCursorProps(xCursor, UNO_QUERY);
//STRIP001 /*?*/ 				// ... the data source is thread safe ...
//STRIP001 /*?*/ 				sal_Bool bAllowOwnThread = ::comphelper::hasProperty(FM_PROP_THREADSAFE, xCursorProps) && ::comphelper::getBOOL(xCursorProps->getPropertyValue(FM_PROP_THREADSAFE));
//STRIP001 /*?*/ 				// ... the record count is unknown
//STRIP001 /*?*/ 				sal_Bool bNeedOwnThread = ::comphelper::hasProperty(FM_PROP_ROWCOUNTFINAL, xCursorProps) && !::comphelper::getBOOL(xCursorProps->getPropertyValue(FM_PROP_ROWCOUNTFINAL));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (bNeedOwnThread && bAllowOwnThread)
//STRIP001 /*?*/ 					GetImpl()->DoAsyncCursorAction(GetImpl()->getNavController(), FmXFormShell::CA_MOVE_TO_LAST);
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 					DO_SAFE( xCursor->last(); );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_NEW:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				DBG_ASSERT( GetImpl()->getNavController()->getModel() == GetImpl()->getActiveForm(),
//STRIP001 /*?*/ 					"FmFormShell::Execute: why this different forms?" );
//STRIP001 /*?*/ 					// FS: just wondering: the previous "last" block worked with the nav controller (which seems the
//STRIP001 /*?*/ 					// most appropriate), the old "new" implementation here uses the active form
//STRIP001 /*?*/ 					// So they should be equal ....
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// don't even want to guess what happens when the "active controller" (which is used for the SaveModified)
//STRIP001 /*?*/ 				// is not the "nav controller"
//STRIP001 /*?*/ 				// TODO: This all seems to be worth an additional deeper look ....
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// additional TODO: why this "DO_SAFE" instead of handling any SQLExceptions which may occur?????
//STRIP001 /*?*/ 				// I remember me introducing this DO_SAFE a very long time ago (it was in pre-5.2 times me thinks), perhaps
//STRIP001 /*?*/ 				// this was appropriate then. But now, we should really handle these error instead of silencing them!
//STRIP001 /*?*/ 				// In theory, we're a SQLErrorListener at the database form, so all errors occured should be notified
//STRIP001 /*?*/ 				// to us instead of beeing thrown. But nevertheless, this DO_SAFE looks strange to me ....
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< XResultSet >  xCursor( GetImpl()->getNavController()->getModel(), UNO_QUERY );
//STRIP001 /*?*/ 				DO_SAFE( xCursor->last(); );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< XResultSetUpdate >  xUpdateCursor( GetImpl()->getActiveForm(), UNO_QUERY );
//STRIP001 /*?*/ 				DO_SAFE( xUpdateCursor->moveToInsertRow(); );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_DELETE:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSet >	xCursor(GetImpl()->getActiveForm(), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 /*?*/ 			::com::sun::star::uno::Reference< XResultSetUpdate >  xUpdateCursor(xCursor, ::com::sun::star::uno::UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::beans::XPropertySet >	xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			sal_uInt32 nCount = ::comphelper::getINT32(xSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// naechste position festellen
//STRIP001 /*?*/ 			sal_Bool bLeft = xCursor->isLast() && nCount > 1;
//STRIP001 /*?*/ 			sal_Bool bRight= !xCursor->isLast();
//STRIP001 /*?*/ 			sal_Bool bSuccess = sal_False;
//STRIP001 /*?*/ 			try
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// ask for confirmation
//STRIP001 /*?*/ 				Reference< ::com::sun::star::form::XConfirmDeleteListener >  xConfirm(GetImpl()->getActiveController(),UNO_QUERY);
//STRIP001 /*?*/ 				if (xConfirm.is())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					::com::sun::star::sdb::RowChangeEvent aEvent;
//STRIP001 /*?*/ 					aEvent.Source = Reference< XInterface > (xCursor, UNO_QUERY);
//STRIP001 /*?*/ 					aEvent.Action = ::com::sun::star::sdb::RowChangeAction::DELETE;
//STRIP001 /*?*/ 					aEvent.Rows = 1;
//STRIP001 /*?*/ 					bSuccess = xConfirm->confirmDelete(aEvent);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// das Ding loeschen
//STRIP001 /*?*/ 				if (bSuccess)
//STRIP001 /*?*/ 					xUpdateCursor->deleteRow();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			catch(Exception&)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				bSuccess = sal_False;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (bSuccess)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (bLeft || bRight)
//STRIP001 /*?*/ 					xCursor->relative(bRight ? 1 : -1);
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					sal_Bool bCanInsert = GetImpl()->canInsert(xSet);
//STRIP001 /*?*/ 					// kann noch ein Datensatz eingefuegt weden
//STRIP001 /*?*/ 					try
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (bCanInsert)
//STRIP001 /*?*/ 							xUpdateCursor->moveToInsertRow();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							// Datensatz bewegen um Stati neu zu setzen
//STRIP001 /*?*/ 							xCursor->first();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					catch(Exception&)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DBG_ERROR("FmFormShell::Execute : couldn't position on the next record !");
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_ABSOLUTE:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 /*?*/ 			sal_Int32 nRecord = -1;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pArgs )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SfxPoolItem* pItem;
//STRIP001 /*?*/ 				if( (pArgs->GetItemState(FN_PARAM_1, sal_True, &pItem)) == SFX_ITEM_SET )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					const SfxInt32Item* pTypedItem = PTR_CAST( SfxInt32Item, pItem );
//STRIP001 /*?*/ 					if ( pTypedItem )
//STRIP001 /*?*/ 						nRecord = Max( pTypedItem->GetValue(), sal_Int32(0) );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				FmInputRecordNoDialog dlg(NULL);
//STRIP001 /*?*/ 				dlg.SetValue(xCursor->getRow());
//STRIP001 /*?*/ 				if (dlg.Execute() == RET_OK)
//STRIP001 /*?*/ 					nRecord = dlg.GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				rReq.AppendItem( SfxInt32Item( FN_PARAM_1, nRecord ) );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (nRecord != -1)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	   xSet    (GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				sal_Bool	bFinal		= ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ROWCOUNTFINAL));
//STRIP001 /*?*/ 				sal_Int32  nRecordCount= ::comphelper::getINT32(xSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( bFinal && (sal_Int32)nRecord >= nRecordCount )
//STRIP001 /*?*/ 					nRecord = nRecordCount - 1;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (GetImpl()->SaveModified(GetImpl()->getNavController()))
//STRIP001 /*?*/ 					DO_SAFE( xCursor->absolute(nRecord); );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_SAVE:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (!GetImpl()->CommitCurrent(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				rReq.Done();
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::beans::XPropertySet >	xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			sal_Bool bIsInserting  = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSetUpdate >  xUpdateCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			sal_Bool bSuccess = sal_True;
//STRIP001 /*?*/ 			try
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (bIsInserting)
//STRIP001 /*?*/ 					xUpdateCursor->insertRow();
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 					xUpdateCursor->updateRow();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			catch(Exception&)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				bSuccess = sal_False;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (bSuccess && bIsInserting)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				DO_SAFE( xCursor->last(); );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_RECORD_UNDO:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSetUpdate >  xUpdateCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			Reference< ::com::sun::star::beans::XPropertySet >	xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			sal_Bool bInserting = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 /*?*/ 			if (!bInserting)
//STRIP001 /*?*/ 				xUpdateCursor->cancelRowUpdates();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ //			GetImpl()->ResetCurrent(GetImpl()->getActiveController());
//STRIP001 /*?*/ 			GetImpl()->ResetAll(Reference< ::com::sun::star::form::XForm > (GetImpl()->getActiveController()->getModel(), UNO_QUERY));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (bInserting) 				// wieder in den EinfuegeModus
//STRIP001 /*?*/ 				DO_SAFE( xUpdateCursor->moveToInsertRow(); );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			GetImpl()->m_bActiveModified = sal_False;
//STRIP001 /*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate(DatabaseSlotMap);
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_REMOVE_FILTER_SORT:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// gleichzeitiges Zuruecksetzen der Filter- und der Sort-Eigenschaft
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XMultiPropertySet >  xProperties(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				if (xProperties.is())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					::rtl::OUString ustrNames[2] = { FM_PROP_FILTER_CRITERIA, FM_PROP_SORT };
//STRIP001 /*?*/ 					Any  anyValues[2] = { makeAny(::rtl::OUString()),
//STRIP001 /*?*/ 						makeAny(::rtl::OUString()) };
//STRIP001 /*?*/ 					Sequence< ::rtl::OUString> seqNames(ustrNames, 2);
//STRIP001 /*?*/ 					Sequence< Any> seqValues(anyValues, 2);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 					xProperties->setPropertyValues(seqNames, seqValues);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					try
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Reference< ::com::sun::star::form::XLoadable >	xReload(xProperties, UNO_QUERY);
//STRIP001 /*?*/ 						xReload->reload();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					catch(::com::sun::star::sdbc::SQLException e)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						e;
//STRIP001 /*?*/ 						DBG_ERROR("FmFormShell::Execute(REMOVE_FILTER_SORT) : catched an SQL exeption !");
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_SORTDOWN:
//STRIP001 /*?*/ 			bSortUp = sal_False;
//STRIP001 /*?*/ 		case SID_FM_SORTUP:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdb::XSQLQueryComposer >  xParser = GetImpl()->getParser();
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 			Reference< ::com::sun::star::form::XFormController >  xFormCtrler = GetImpl()->getActiveController();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::awt::XControl >  xControl = xFormCtrler->getCurrentControl();
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(xFormCtrler) && xControl.is() && xCursor.is())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	xField = GetImpl()->GetBoundField(xControl, GetImpl()->getActiveForm());
//STRIP001 /*?*/ 				if (xField.is())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					Reference< ::com::sun::star::beans::XPropertySet >	xFormSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 					::rtl::OUString sOriginalSort;
//STRIP001 /*?*/ 					try { sOriginalSort = ::comphelper::getString(xFormSet->getPropertyValue(FM_PROP_SORT)); }
//STRIP001 /*?*/ 					catch(Exception&) { }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// immer nur eine Sortierung
//STRIP001 /*?*/ 					DO_SAFE_WITH_ERROR( xParser->setOrder(::rtl::OUString()), "FmFormShell::Execute(AUTOFILTER) : could not reset the parsers order !" );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					sal_Bool bParserSuccess;
//STRIP001 /*?*/ 					HANDLE_SQL_ERRORS(
//STRIP001 /*?*/ 						xParser->appendOrderByColumn(xField, bSortUp),
//STRIP001 /*?*/ 						bParserSuccess,
//STRIP001 /*?*/ 						::rtl::OUString(SVX_RES(RID_STR_COULDNOTSETORDER)),
//STRIP001 /*?*/ 						"FmFormShell::Execute(SORTUP/DOWN) : unknown exception while updating the parser !"
//STRIP001 /*?*/ 					)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (bParserSuccess)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 						Reference< ::com::sun::star::form::XLoadable >	xReload(xFormSet, UNO_QUERY);
//STRIP001 /*?*/ 						try
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							xFormSet->setPropertyValue(FM_PROP_SORT, makeAny(xParser->getOrder()));
//STRIP001 /*?*/ 							xReload->reload();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						catch(Exception&)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (!isRowSetAlive(xFormSet))
//STRIP001 /*?*/ 						{	// restore the original state
//STRIP001 /*?*/ 							try
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								xParser->setOrder(sOriginalSort);
//STRIP001 /*?*/ 								xFormSet->setPropertyValue(FM_PROP_SORT, makeAny(xParser->getOrder()));
//STRIP001 /*?*/ 								xReload->reload();
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							catch(Exception&)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case SID_FM_FILTER_EXECUTE:
//STRIP001 /*?*/ 		case SID_FM_FILTER_EXIT:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			sal_Bool bCancelled = ( SID_FM_FILTER_EXIT == nSlot );
//STRIP001 /*?*/ 			sal_Bool bReopenNavigator = sal_False;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( !bCancelled )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// if the filter navigator is still open, we need to close it, so it can possibly
//STRIP001 /*?*/ 				// commit it's most recent changes
//STRIP001 /*?*/ 				if ( GetViewShell() && GetViewShell()->GetViewFrame() )
//STRIP001 /*?*/ 					if ( GetViewShell()->GetViewFrame()->HasChildWindow( SID_FM_FILTER_NAVIGATOR ) )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						GetViewShell()->GetViewFrame()->ToggleChildWindow( SID_FM_FILTER_NAVIGATOR );
//STRIP001 /*?*/ 						bReopenNavigator = sal_True;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< XFormController >  xController( GetImpl()->getActiveController() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if	(	GetViewShell()->GetViewFrame()->HasChildWindow( SID_FM_FILTER_NAVIGATOR )
//STRIP001 /*?*/ 						// closing the window was denied, for instance because of a invalid criterion
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					||	(	xController.is()
//STRIP001 /*?*/ 						&& !FmXFormShell::CommitCurrent( xController )
//STRIP001 /*?*/ 						)
//STRIP001 /*?*/ 						// committing the controller was denied
//STRIP001 /*?*/ 					)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					rReq.Done();
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			GetImpl()->stopFiltering( !bCancelled );
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( bReopenNavigator )
//STRIP001 /*?*/ 				// we closed the navigator only to implicitly commit it (as we do not have another
//STRIP001 /*?*/ 				// direct wire to it), but to the user, it should look it it was always open
//STRIP001 /*?*/ 				GetViewShell()->GetViewFrame()->ToggleChildWindow( SID_FM_FILTER_NAVIGATOR );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case SID_FM_FILTER_START:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			GetImpl()->startFiltering();
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_ORDERCRIT:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Reference< ::com::sun::star::form::XFormController >	xFormCtrler = GetImpl()->getActiveController();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(xFormCtrler))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::awt::XControl >			xControl = xFormCtrler->getCurrentControl();
//STRIP001 /*?*/ 				Reference< ::com::sun::star::sdb::XSQLQueryComposer >	xParser = GetImpl()->getParser();
//STRIP001 /*?*/ 				Reference< XRowSet >									xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet > xField(GetImpl()->GetBoundField(xControl, GetImpl()->getActiveForm()), UNO_QUERY);
//STRIP001 /*?*/ 				
//STRIP001 /*?*/ 				PropertyValue aFirst;
//STRIP001 /*?*/ 				aFirst.Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("QueryComposer"));
//STRIP001 /*?*/ 				aFirst.Value <<= xParser;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				PropertyValue aSecond;
//STRIP001 /*?*/ 				aSecond.Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("RowSet"));
//STRIP001 /*?*/ 				aSecond.Value <<= xSet;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				PropertyValue aThird;
//STRIP001 /*?*/ 				aThird.Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DefaultOrderColumn"));
//STRIP001 /*?*/ 				aThird.Value <<= xField;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Sequence<Any> aInit(3);
//STRIP001 /*?*/ 				aInit[0] <<= aFirst;
//STRIP001 /*?*/ 				aInit[1] <<= aSecond;
//STRIP001 /*?*/ 				aInit[2] <<= aThird;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< ::com::sun::star::ui::dialogs::XExecutableDialog> xDlg(
//STRIP001 /*?*/ 					::legacy_binfilters::getLegacyProcessServiceFactory()->createInstanceWithArguments(::rtl::OUString::createFromAscii("com.sun.star.sdb.OrderDialog"),aInit),UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if(xDlg.is())
//STRIP001 /*?*/ 					xDlg->execute();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	xFormSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 				try
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					xFormSet->setPropertyValue(FM_PROP_SORT, makeAny(xParser->getOrder()));
//STRIP001 /*?*/ 					Reference< ::com::sun::star::form::XLoadable >	xReload(xFormSet, UNO_QUERY);
//STRIP001 /*?*/ 					xReload->reload();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				catch(Exception&)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					DBG_ERROR("Exception occured!");
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_AUTOFILTER:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Reference< ::com::sun::star::form::XFormController >	xFormCtrler = GetImpl()->getActiveController();
//STRIP001 /*?*/ 			Reference< ::com::sun::star::awt::XControl >			xControl = xFormCtrler->getCurrentControl();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdb::XSQLQueryComposer >	xParser = GetImpl()->getParser();
//STRIP001 /*?*/ 			Reference< ::com::sun::star::sdbc::XResultSet > 		xCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(xFormCtrler) && xControl.is() && xCursor.is())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	xField = GetImpl()->GetBoundField(xControl, GetImpl()->getActiveForm());
//STRIP001 /*?*/ 				if (xField.is())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 					::rtl::OUString sOriginalFilter = ::comphelper::getString(xActiveSet->getPropertyValue(FM_PROP_FILTER_CRITERIA));
//STRIP001 /*?*/ 					sal_Bool bApplied = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_APPLYFILTER));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// do we have a filter but not applied, then we have to overwrite it, else append one
//STRIP001 /*?*/ 					if (!bApplied)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DO_SAFE_WITH_ERROR( xParser->setFilter(::rtl::OUString()), "FmFormShell::Execute(AUTOFILTER) : could not reset the parsers filter !" );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					sal_Bool bParserSuccess;
//STRIP001 /*?*/ 					HANDLE_SQL_ERRORS(
//STRIP001 /*?*/ 						xParser->appendFilterByColumn(xField),
//STRIP001 /*?*/ 						bParserSuccess,
//STRIP001 /*?*/ 						::rtl::OUString(SVX_RES(RID_STR_COULDNOTSETFILTER)),
//STRIP001 /*?*/ 						"FmFormShell::Execute(AUTOFILTER) : could not append the filter to my parser !"
//STRIP001 /*?*/ 					)
//STRIP001 /*?*/ 					if (bParserSuccess)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Reference< ::com::sun::star::form::XLoadable >	xReload(xActiveSet, UNO_QUERY);
//STRIP001 /*?*/ 						try
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 							xActiveSet->setPropertyValue(FM_PROP_FILTER_CRITERIA, makeAny(xParser->getFilter()));
//STRIP001 /*?*/ 							sal_Bool bB(sal_True);
//STRIP001 /*?*/ 							xActiveSet->setPropertyValue(FM_PROP_APPLYFILTER, Any(&bB,getBooleanCppuType()));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							xReload->reload();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						catch(Exception&)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if (!isRowSetAlive(xActiveSet))
//STRIP001 /*?*/ 						{	// restore the original state
//STRIP001 /*?*/ 							try
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								xParser->setOrder(sOriginalFilter);
//STRIP001 /*?*/ 								xActiveSet->setPropertyValue(FM_PROP_APPLYFILTER, Any(&bApplied,getBooleanCppuType()));
//STRIP001 /*?*/ 								xActiveSet->setPropertyValue(FM_PROP_FILTER_CRITERIA, makeAny(xParser->getFilter()));
//STRIP001 /*?*/ 								xReload->reload();
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							catch(Exception&)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 		}	break;
//STRIP001 /*?*/ 		case SID_FM_REFRESH:
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 				Reference< ::com::sun::star::form::XLoadable >	xReload(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				xReload->reload();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 		case SID_FM_FORM_FILTERED: // toggle the item
//STRIP001 /*?*/ 			if (GetImpl()->SaveModified(GetImpl()->getActiveController()))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				sal_Bool bApplied = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_APPLYFILTER));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				sal_Bool bB(!bApplied);
//STRIP001 /*?*/ 				xActiveSet->setPropertyValue(FM_PROP_APPLYFILTER, Any(&bB,getBooleanCppuType()));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				FormShellWaitObject aWO(this);
//STRIP001 /*?*/ 				Reference< ::com::sun::star::form::XLoadable >	xReload(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				xReload->reload();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			rReq.Done();
//STRIP001 /*?*/ 			break;
/*?*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	sal_uInt16 nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch( nWhich )
/*N*/ 		{
/*N*/ 			case SID_FM_FILTER_EXECUTE:
/*N*/ 			case SID_FM_FILTER_EXIT:
/*?*/ 				if (!GetImpl()->isInFilterMode())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_FM_USE_WIZARDS:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetImpl()->GetWizardUsing() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_AUTOCONTROLFOCUS:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetFormModel()->GetAutoControlFocus() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_OPEN_READONLY:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetFormModel()->GetOpenInDesignMode() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_RADIOBUTTON:
/*?*/ 			case SID_FM_COMBOBOX:
/*?*/ 			case SID_FM_URLBUTTON:
/*?*/ 			case SID_FM_GROUPBOX:
/*?*/ 			case SID_FM_CHECKBOX:
/*?*/ 			case SID_FM_PUSHBUTTON:
/*?*/ 			case SID_FM_FIXEDTEXT:
/*?*/ 			case SID_FM_LISTBOX:
/*?*/ 			case SID_FM_EDIT:
/*?*/ 			case SID_FM_DBGRID:
/*?*/ 			case SID_FM_IMAGEBUTTON:
/*?*/ 			case SID_FM_IMAGECONTROL:
/*?*/ 			case SID_FM_FILECONTROL:
/*?*/ 			case SID_FM_DATEFIELD:
/*?*/ 			case SID_FM_TIMEFIELD:
/*?*/ 			case SID_FM_NUMERICFIELD:
/*?*/ 			case SID_FM_CURRENCYFIELD:
/*?*/ 			case SID_FM_PATTERNFIELD:
/*?*/ 			case SID_FM_FORMATTEDFIELD:
/*?*/ 				if (!m_bDesignMode)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					sal_Bool bLayerLocked = sal_False;
/*?*/ 					if (m_pFormView)
/*?*/ 					{
/*?*/ 						// Ist der ::com::sun::star::drawing::Layer gelocked, so mssen die Slots disabled werden. #36897
/*?*/ 						SdrPageView* pPV = m_pFormView->GetPageViewPvNum(0);
/*?*/ 						bLayerLocked = pPV->IsLayerLocked(m_pFormView->GetActiveLayer());
/*?*/ 					}
/*?*/ 					if (bLayerLocked)
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem(nWhich, (nWhich==m_nLastSlot)) );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 			case SID_FM_FILTER_NAVIGATOR_CONTROL:
/*?*/ 			{
/*?*/ 				if (GetImpl()->isInFilterMode())
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 			}	break;
/*?*/ 			case SID_FM_FIELDS_CONTROL:
/*?*/ 			case SID_FM_PROPERTY_CONTROL:
/*?*/ 			{
/*?*/ 				if (!m_bDesignMode || !m_pFormView || !m_bHasForms)
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 
/*?*/ 			}	break;
/*?*/ 			case SID_FM_FMEXPLORER_CONTROL:
/*?*/ 			{
/*?*/ 				if (!m_bDesignMode || !m_pFormView)
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 
/*?*/ 			}	break;
/*?*/ 			case SID_FM_ADD_FIELD:
/*?*/ 			case SID_FM_SHOW_FMEXPLORER:
/*?*/ 			case SID_FM_SHOW_PROPERTIES:
/*?*/ 			case SID_FM_FILTER_NAVIGATOR:
/*?*/ 			{
/*?*/ 				if ( GetViewShell()->GetViewFrame()->KnowsChildWindow(nWhich) )
/*?*/ 					rSet.Put( SfxBoolItem( nWhich, GetViewShell()->GetViewFrame()->HasChildWindow(nWhich)) );
/*?*/ 				else
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			}	break;
/*?*/ 
/*?*/ 			case SID_FM_SHOW_PROPERTY_BROWSER:
/*?*/ 			{
/*?*/ 				rSet.Put(SfxBoolItem(GetImpl()->IsPropBrwOpen()));
/*?*/ 			} break;
/*?*/ 
/*?*/ 			case SID_FM_CTL_PROPERTIES:
/*?*/ 			{
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					sal_Bool bChecked  = GetImpl()->IsPropBrwOpen() && (GetImpl()->getSelObject() == GetImpl()->getCurControl());
/*?*/ 					rSet.Put(SfxBoolItem(nWhich, bChecked));
/*?*/ 				}
/*?*/ 			}	break;
/*?*/ 
/*?*/ 			case SID_FM_PROPERTIES:
/*?*/ 			{
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurForm().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					// aktuelle form
/*?*/ 					Reference< ::com::sun::star::form::XForm >	xForm(GetImpl()->getSelObject(), UNO_QUERY);
/*?*/ 					sal_Bool bChecked = GetImpl()->IsPropBrwOpen() && xForm.is();
/*?*/ 					rSet.Put(SfxBoolItem(nWhich, bChecked));
/*?*/ 				}
/*?*/ 			}	break;
/*?*/ 			case SID_FM_TAB_DIALOG:
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurForm().is() )
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 			case SID_FM_CONFIG:
/*N*/ 				rSet.Put(SfxUInt16Item(nWhich, m_nLastSlot));
/*N*/ 				break;
/*N*/ 			case SID_FM_DESIGN_MODE:
/*N*/ 				if (!m_pFormView)
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 					rSet.Put( SfxBoolItem(nWhich, m_bDesignMode) );
/*N*/ 				break;
/*N*/ 			case SID_FM_SEARCH:
/*N*/ 			case SID_FM_RECORD_FIRST:
/*N*/ 			case SID_FM_RECORD_NEXT:
/*N*/ 			case SID_FM_RECORD_PREV:
/*N*/ 			case SID_FM_RECORD_LAST:
/*N*/ 			case SID_FM_RECORD_NEW:
/*N*/ 			case SID_FM_RECORD_DELETE:
/*N*/ 			case SID_FM_RECORD_ABSOLUTE:
/*N*/ 			case SID_FM_RECORD_TOTAL:
/*N*/ 			case SID_FM_RECORD_SAVE:
/*N*/ 			case SID_FM_RECORD_UNDO:
/*N*/ 			case SID_FM_FORM_FILTERED:
/*N*/ 			case SID_FM_REMOVE_FILTER_SORT:
/*N*/ 			case SID_FM_SORTUP:
/*N*/ 			case SID_FM_SORTDOWN:
/*N*/ 			case SID_FM_ORDERCRIT:
/*N*/ 			case SID_FM_FILTER_START:
/*N*/ 			case SID_FM_AUTOFILTER:
/*N*/ 			case SID_FM_REFRESH:
/*N*/ 			case SID_FM_VIEW_AS_GRID:
/*?*/				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				GetFormState(rSet,nWhich);
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_FM_CHANGECONTROLTYPE:
/*?*/ 			{
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					Reference< ::com::sun::star::form::XFormComponent >  xSelAsComp(GetImpl()->getCurControl(), UNO_QUERY);
/*?*/ 					if (!xSelAsComp.is())
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 			} break;
/*?*/ 
/*?*/ 			case SID_FM_CONVERTTO_EDIT			:
/*?*/ 			case SID_FM_CONVERTTO_BUTTON			:
/*?*/ 			case SID_FM_CONVERTTO_FIXEDTEXT 	:
/*?*/ 			case SID_FM_CONVERTTO_LISTBOX		:
/*?*/ 			case SID_FM_CONVERTTO_CHECKBOX		:
/*?*/ 			case SID_FM_CONVERTTO_RADIOBUTTON	:
/*?*/ 			case SID_FM_CONVERTTO_GROUPBOX		:
/*?*/ 			case SID_FM_CONVERTTO_COMBOBOX		:
/*?*/ 			case SID_FM_CONVERTTO_GRID			:
/*?*/ 			case SID_FM_CONVERTTO_IMAGEBUTTON	:
/*?*/ 			case SID_FM_CONVERTTO_FILECONTROL	:
/*?*/ 			case SID_FM_CONVERTTO_DATE			:
/*?*/ 			case SID_FM_CONVERTTO_TIME			:
/*?*/ 			case SID_FM_CONVERTTO_NUMERIC		:
/*?*/ 			case SID_FM_CONVERTTO_CURRENCY		:
/*?*/ 			case SID_FM_CONVERTTO_PATTERN		:
/*?*/ 			case SID_FM_CONVERTTO_IMAGECONTROL	:
/*?*/ 			case SID_FM_CONVERTTO_FORMATTED 	:
/*?*/ 			{
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					Reference< ::com::sun::star::beans::XPropertySet >	xSelProps(GetImpl()->getCurControl(), UNO_QUERY);
//STRIP001 /*?*/ 					if (!xSelProps.is() || !GetImpl()->IsConversionPossible(xSelProps, nWhich))
//STRIP001 /*?*/ 						// it isn't a form component
//STRIP001 /*?*/ 						rSet.DisableItem( nWhich );
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						rSet.Put(SfxBoolItem(nWhich, sal_False));
/*?*/ 						// just to have a defined state (available and not checked)
/*N*/ 				}
/*N*/ 			} break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 void FmFormShell::GetFormState(SfxItemSet &rSet, sal_uInt16 nWhich)
//STRIP001 {
//STRIP001 	if	(	!GetImpl()->getNavController().is()
//STRIP001 		||	!isRowSetAlive(GetImpl()->getNavController()->getModel())
//STRIP001 		||	!m_pFormView
//STRIP001 		||	m_bDesignMode
//STRIP001 		||	!GetImpl()->getActiveForm().is()
//STRIP001 		||	GetImpl()->isInFilterMode()
//STRIP001 		||	(	GetImpl()->HasPendingCursorAction(GetImpl()->getNavController())
//STRIP001 			&&	(SID_FM_RECORD_TOTAL != nWhich)
//STRIP001 			)
//STRIP001 		)
//STRIP001 		rSet.DisableItem(nWhich);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		sal_Bool	bEnable = sal_False;
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_FM_VIEW_AS_GRID:
//STRIP001 				if (GetImpl()->m_xAttachedFrame.is() && GetImpl()->getNavController().is())
//STRIP001 				{
//STRIP001 					bEnable = sal_True;
//STRIP001 					sal_Bool bDisplayingCurrent = GetImpl()->getInternalForm(Reference< ::com::sun::star::form::XForm > (GetImpl()->getNavController()->getModel(), UNO_QUERY)) == GetImpl()->m_xExternalDisplayedForm;
//STRIP001 					rSet.Put(SfxBoolItem(nWhich, bDisplayingCurrent));
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_FM_SEARCH:
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet >	xNavSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				sal_Int32 nCount = ::comphelper::getINT32(xNavSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 				bEnable = nCount != 0;
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_FIRST:
//STRIP001 			case SID_FM_RECORD_PREV:
//STRIP001 				bEnable = GetImpl()->canNavigate() && GetImpl()->CanMoveLeft(GetImpl()->getNavController());
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_NEXT:
//STRIP001 				if (GetImpl()->canNavigate())
//STRIP001 				{
//STRIP001 					if (GetImpl()->CanMoveRight(GetImpl()->getNavController()))
//STRIP001 						bEnable = sal_True;
//STRIP001 					else if (GetImpl()->getNavController() == GetImpl()->getActiveController() &&
//STRIP001 							 GetImpl()->getActiveForm().is())
//STRIP001 					{
//STRIP001 						Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 						sal_Bool bIsNew = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 						bEnable = bIsNew && GetImpl()->isActiveModified();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_LAST:
//STRIP001 			{
//STRIP001 				if (GetImpl()->canNavigate())
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xNavSet(GetImpl()->getNavController()->getModel(), UNO_QUERY);
//STRIP001 					Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(xNavSet, UNO_QUERY);
//STRIP001 					sal_Int32  nCount		= ::comphelper::getINT32(xNavSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 					sal_Bool bIsNew = ::comphelper::getBOOL(xNavSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 					bEnable = nCount && (!xCursor->isLast() || bIsNew);
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_NEW:
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				bEnable = GetImpl()->canInsert(xActiveSet);
//STRIP001 				// if we are inserting we can move to the next row if the current record is modified
//STRIP001 				bEnable  = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_ISNEW))
//STRIP001 					? GetImpl()->isActiveModified() || ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_ISMODIFIED))
//STRIP001 					: GetImpl()->canInsert(xActiveSet);
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_DELETE:
//STRIP001 			{
//STRIP001 				// already deleted ?
//STRIP001 				Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				sal_Bool bIsDeleted = !xCursor.is() || xCursor->rowDeleted();
//STRIP001 				if (!bIsDeleted)
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(xCursor, UNO_QUERY);
//STRIP001 					// allowed to delete the row ?
//STRIP001 					bEnable = !::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_ISNEW)) && GetImpl()->canDelete(xActiveSet);
//STRIP001 				}
//STRIP001 				else
//STRIP001 					bEnable = sal_False;
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_ABSOLUTE:
//STRIP001 			{
//STRIP001 				if (GetImpl()->canNavigate())
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xNavSet(GetImpl()->getNavController()->getModel(), UNO_QUERY);
//STRIP001 					Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(xNavSet, UNO_QUERY);
//STRIP001 
//STRIP001 					sal_Int32  nPos 	 = xCursor->getRow();
//STRIP001 					sal_Bool bIsNew 	= ::comphelper::getBOOL(xNavSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 					sal_Int32 nCount	 = ::comphelper::getINT32(xNavSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 					sal_Bool   bTotal	 = ::comphelper::getBOOL(xNavSet->getPropertyValue(FM_PROP_ROWCOUNTFINAL));
//STRIP001 					if (nPos >= 0 || bIsNew)
//STRIP001 					{
//STRIP001 						if (bTotal)
//STRIP001 						{
//STRIP001 							// Sonderfall, es koennen keine Datensaetze eingefuegt werden
//STRIP001 							// und es gibt keinen Datensatz -> dann
//STRIP001 							if (nCount == 0 && !GetImpl()->canInsert(xNavSet))
//STRIP001 							{
//STRIP001 								bEnable = sal_False;
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								if (bIsNew)
//STRIP001 									nPos = ++nCount;
//STRIP001 								rSet.Put( SfxInt32Item( nWhich, nPos ) );
//STRIP001 								bEnable = sal_True;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							rSet.Put( SfxInt32Item( nWhich, nPos ) );
//STRIP001 							bEnable = sal_True;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_TOTAL:
//STRIP001 			{
//STRIP001 				String aValue;
//STRIP001 				if (!GetImpl()->canNavigate())
//STRIP001 				{
//STRIP001 					aValue = String();
//STRIP001 					bEnable = sal_False;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					bEnable = sal_True;
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xNavSet(GetImpl()->getNavController()->getModel(), UNO_QUERY);
//STRIP001 					sal_Bool bIsNew 	= ::comphelper::getBOOL(xNavSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 					sal_Bool bIsFinal	= ::comphelper::getBOOL(xNavSet->getPropertyValue(FM_PROP_ROWCOUNTFINAL));
//STRIP001 					sal_Int32  nCount	= ::comphelper::getINT32(xNavSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 
//STRIP001 					if (bIsNew)
//STRIP001 						++nCount;
//STRIP001 
//STRIP001 					aValue = String::CreateFromInt32(sal_uInt32(nCount));
//STRIP001 					if(!bIsFinal)
//STRIP001 						aValue += String::CreateFromAscii(" *");
//STRIP001 				}
//STRIP001 				rSet.Put(SfxStringItem(nWhich, aValue));
//STRIP001 			}	break;
//STRIP001 			case SID_FM_REMOVE_FILTER_SORT:
//STRIP001 				if (GetImpl()->isParsable() && GetImpl()->hasFilter())
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 					bEnable = !::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_INSERTONLY));
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SID_FM_SORTUP:
//STRIP001 			case SID_FM_SORTDOWN:
//STRIP001 			case SID_FM_AUTOFILTER:
//STRIP001 				if (GetImpl()->isParsable())
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 					sal_Bool bInsertOnly = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_INSERTONLY));
//STRIP001 
//STRIP001 					Reference< ::com::sun::star::sdbc::XResultSet >  xCursor(xActiveSet, UNO_QUERY);
//STRIP001 					sal_Bool bIsDeleted = xCursor.is() && xCursor->rowDeleted();
//STRIP001 
//STRIP001 					if (!bIsDeleted && !bInsertOnly)
//STRIP001 					{
//STRIP001 						Reference< ::com::sun::star::form::XFormController >  xFormCtrler(GetImpl()->getActiveController());
//STRIP001 						Reference< ::com::sun::star::awt::XControl >  xControl(xFormCtrler->getCurrentControl());
//STRIP001 
//STRIP001 						Reference< ::com::sun::star::beans::XPropertySet >	xSet = GetImpl()->GetBoundField(xControl, GetImpl()->getActiveForm());
//STRIP001 						// auslesen der Searchflags
//STRIP001 						if (xSet.is())
//STRIP001 						{
//STRIP001 							bEnable = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_SEARCHABLE));
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}	break;
//STRIP001 			case SID_FM_ORDERCRIT:
//STRIP001 			case SID_FM_FILTER_START:
//STRIP001 				if (GetImpl()->isParsable())
//STRIP001 				{
//STRIP001 					Reference< ::com::sun::star::beans::XPropertySet >	xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 					bEnable = !::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_INSERTONLY));
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SID_FM_REFRESH:
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::sdbc::XRowSet >			xRowSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet >		xSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				bEnable = GetImpl()->getRowSetConnection(xRowSet).is() && ::comphelper::getString(xSet->getPropertyValue(FM_PROP_ACTIVECOMMAND)).getLength();
//STRIP001 			}	break;
//STRIP001 			case SID_FM_FORM_FILTERED:
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				::rtl::OUString aFilter = ::comphelper::getString(xActiveSet->getPropertyValue(FM_PROP_FILTER_CRITERIA));
//STRIP001 				if (aFilter.getLength())
//STRIP001 				{
//STRIP001 					rSet.Put(SfxBoolItem(nWhich, ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_APPLYFILTER))));
//STRIP001 					bEnable = !::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_INSERTONLY));
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 			case SID_FM_RECORD_SAVE:
//STRIP001 			case SID_FM_RECORD_UNDO:
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet >	xActiveSet(GetImpl()->getActiveForm(), UNO_QUERY);
//STRIP001 				sal_Bool bIsModified = ::comphelper::getBOOL(xActiveSet->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001 				bEnable = bIsModified || GetImpl()->isActiveModified();
//STRIP001 			}	break;
//STRIP001 		}
//STRIP001 		if (!bEnable)
//STRIP001 			rSet.DisableItem(nWhich);
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ FmFormPage* FmFormShell::GetCurPage() const
/*N*/ {
/*N*/ 	FmFormPage* pP = NULL;
/*N*/ 	if (m_pFormView && m_pFormView->GetPageViewPvNum(0))
/*N*/ 		pP = PTR_CAST(FmFormPage,m_pFormView->GetPageViewPvNum(0)->GetPage());
/*N*/ 	return pP;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::SetView(FmFormView* pView)
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		m_pFormView->SetFormShell( NULL );
/*N*/ 		GetImpl()->ResetForms();
/*N*/ 		m_pFormModel = NULL;
/*N*/ 	}
/*N*/ 	if (pView)
/*N*/ 	{
/*N*/ 		m_pFormView = pView;
/*N*/ 		m_pFormView->SetFormShell( this );
/*N*/ 		m_pFormModel = (FmFormModel*)m_pFormView->GetModel();
/*N*/ 
/*N*/ 		SetDesignMode(pView->IsDesignMode());
/*N*/ 
/*N*/ 		// We activate our view if we are activated ourself, but sometimes the Activate precedes the SetView.
/*N*/ 		// But here we know both the view and our activation state so we at least are able to pass the latter
/*N*/ 		// to the former.
/*N*/ 		// FS - 30.06.99 - 67308
/*N*/ 		if ( IsActive() )
/*?*/ 			GetImpl()->viewActivated( m_pFormView );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		m_pFormView = NULL;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::DetermineForms(sal_Bool bInvalidate)
/*N*/ {
/*N*/ 	// Existieren Formulare auf der aktuellen Page
/*N*/ 	sal_Bool bForms = GetImpl()->hasForms();
/*N*/ 	if (bForms != m_bHasForms)
/*N*/ 	{
/*N*/ 		m_bHasForms = bForms;
/*N*/ 		if (bInvalidate)
/*N*/ 			UIFeatureChanged();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 sal_Bool FmFormShell::GetY2KState(sal_uInt16& nReturn)
//STRIP001 {
//STRIP001 	return GetImpl()->GetY2KState(nReturn);
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 void FmFormShell::SetY2KState(sal_uInt16 n)
//STRIP001 {
//STRIP001 	GetImpl()->SetY2KState(n);
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::Activate(sal_Bool bMDI)
/*N*/ {
/*N*/ 	SfxShell::Activate(bMDI);
/*N*/ 
/*N*/ 	GetImpl()->viewActivated( m_pFormView, sal_True );
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::Deactivate(sal_Bool bMDI)
/*N*/ {
/*N*/ 	SfxShell::Deactivate(bMDI);
/*N*/ 
/*N*/ 	GetImpl()->viewDeactivated( m_pFormView, sal_False );
/*N*/ }
/*N*/ 

}
