/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_parasc.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:58:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#ifdef PCH
// auto strip #include "filt_pch.hxx"
#endif

// auto strip #ifndef _STREAM_HXX //autogen
// auto strip #include <tools/stream.hxx>
// auto strip #endif

#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _RTL_TENCINFO_H
#include <rtl/tencinfo.h>
#endif
// auto strip #ifndef _SFX_PRINTER_HXX
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FONTITEM_HXX //autogen wg. SvxFontItem
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LANGITEM_HXX //autogen wg. SvxLanguageItem
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BRKITEM_HXX //autogen
// auto strip #include <bf_svx/brkitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SCRIPTTYPEITEM_HXX
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #endif

// auto strip #ifndef _SHELLIO_HXX
// auto strip #include <shellio.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif

// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
// auto strip #ifndef _FRMATR_HXX
// auto strip #include <frmatr.hxx>
// auto strip #endif
// auto strip #ifndef _FLTINI_HXX
// auto strip #include <fltini.hxx>
// auto strip #endif
// auto strip #ifndef _PAGEDESC_HXX
// auto strip #include <pagedesc.hxx>
// auto strip #endif
// auto strip #ifndef _BREAKIT_HXX
// auto strip #include <breakit.hxx>
// auto strip #endif

#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _STATSTR_HRC
#include <statstr.hrc>          // ResId fuer Statusleiste
#endif
// auto strip #ifndef _MDIEXP_HXX
// auto strip #include <mdiexp.hxx>           // ...Percent()
// auto strip #endif
// auto strip #ifndef _POOLFMT_HXX
// auto strip #include <poolfmt.hxx>
// auto strip #endif
namespace binfilter {

#define ASC_BUFFLEN 4096

//STRIP001 class SwASCIIParser
//STRIP001 {
//STRIP001 	SwDoc* pDoc;
//STRIP001 	SwPaM* pPam;
//STRIP001 	SvStream& rInput;
//STRIP001 	sal_Char* pArr;
//STRIP001 	const SwAsciiOptions& rOpt;
//STRIP001 	SfxItemSet* pItemSet;
//STRIP001 	long nFileSize;
//STRIP001 	USHORT nScript;
//STRIP001 	bool bNewDoc;
//STRIP001 
//STRIP001 	ULONG ReadChars();
//STRIP001 	void InsertText( const String& rStr );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwASCIIParser( SwDoc* pD, const SwPaM& rCrsr, SvStream& rIn,
//STRIP001 							int bReadNewDoc, const SwAsciiOptions& rOpts );
//STRIP001 	~SwASCIIParser();
//STRIP001 
//STRIP001 	ULONG CallParser();
//STRIP001 };


// Aufruf fuer die allg. Reader-Schnittstelle
//STRIP001 ULONG AsciiReader::Read( SwDoc &rDoc, SwPaM &rPam, const String & )
//STRIP001 {
//STRIP001 	if( !pStrm )
//STRIP001 	{
//STRIP001 		ASSERT( !this, "ASCII-Read ohne Stream" );
//STRIP001 		return ERR_SWG_READ_ERROR;
//STRIP001 	}
//STRIP001 
//STRIP001 	//JP 18.01.96: Alle Ueberschriften sind normalerweise ohne
//STRIP001 	//              Kapitelnummer. Darum hier explizit abschalten
//STRIP001 	//              weil das Default jetzt wieder auf AN ist.
//STRIP001 	if( !bInsertMode )
//STRIP001 		Reader::SetNoOutlineNum( rDoc );
//STRIP001 
//STRIP001 	SwASCIIParser* pParser = new SwASCIIParser( &rDoc, rPam, *pStrm,
//STRIP001 										!bInsertMode, aOpt.GetASCIIOpts() );
//STRIP001 	ULONG nRet = pParser->CallParser();
//STRIP001 
//STRIP001 	delete pParser;
//STRIP001 	// after Read reset the options
//STRIP001 	aOpt.ResetASCIIOpts();
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 SwASCIIParser::SwASCIIParser( SwDoc* pD, const SwPaM& rCrsr, SvStream& rIn,
//STRIP001 							int bReadNewDoc, const SwAsciiOptions& rOpts )
//STRIP001 	: pDoc( pD ), rInput( rIn ), rOpt( rOpts ), bNewDoc( bReadNewDoc ),
//STRIP001 	nScript( 0 )
//STRIP001 {
//STRIP001 	pPam = new SwPaM( *rCrsr.GetPoint() );
//STRIP001 	pArr = new sal_Char [ ASC_BUFFLEN + 1 ];
//STRIP001 
//STRIP001 	pItemSet = new SfxItemSet( pDoc->GetAttrPool(),
//STRIP001 				RES_CHRATR_FONT,		RES_CHRATR_LANGUAGE,
//STRIP001 				RES_CHRATR_CJK_FONT,	RES_CHRATR_CJK_LANGUAGE,
//STRIP001 				RES_CHRATR_CTL_FONT,	RES_CHRATR_CTL_LANGUAGE,
//STRIP001 				0 );
//STRIP001 
//STRIP001 	// set defaults from the options
//STRIP001 	if( rOpt.GetLanguage() )
//STRIP001 	{
//STRIP001 		SvxLanguageItem aLang( (LanguageType)rOpt.GetLanguage(),
//STRIP001 						 		RES_CHRATR_LANGUAGE );
//STRIP001 		pItemSet->Put( aLang );
//STRIP001 		pItemSet->Put( aLang, RES_CHRATR_CJK_LANGUAGE );
//STRIP001 		pItemSet->Put( aLang, RES_CHRATR_CTL_LANGUAGE );
//STRIP001 	}
//STRIP001 	if( rOpt.GetFontName().Len() )
//STRIP001 	{
//STRIP001 		bool bDelete = false;
//STRIP001 		const SfxFont* pFnt = 0;
//STRIP001 		if( pDoc->GetPrt() )
//STRIP001 			pFnt = pDoc->GetPrt()->GetFontByName( rOpt.GetFontName() );
//STRIP001 
//STRIP001 		if( !pFnt )
//STRIP001 		{
//STRIP001 			pFnt = new SfxFont( FAMILY_DONTKNOW, rOpt.GetFontName() );
//STRIP001 			bDelete = true;
//STRIP001 		}
//STRIP001 		SvxFontItem aFont( pFnt->GetFamily(), pFnt->GetName(),
//STRIP001 						aEmptyStr, pFnt->GetPitch(), pFnt->GetCharSet() );
//STRIP001 		pItemSet->Put( aFont );
//STRIP001 		pItemSet->Put( aFont, RES_CHRATR_CJK_FONT );
//STRIP001 		pItemSet->Put( aFont, RES_CHRATR_CTL_FONT );
//STRIP001 
//STRIP001 		if( bDelete )
//STRIP001 			delete (SfxFont*)pFnt;
//STRIP001 	}
//STRIP001 }

//STRIP001 SwASCIIParser::~SwASCIIParser()
//STRIP001 {
//STRIP001 	delete pPam;
//STRIP001 	delete [] pArr;
//STRIP001 	delete pItemSet;
//STRIP001 }


// Aufruf des Parsers
//STRIP001 ULONG SwASCIIParser::CallParser()
//STRIP001 {
//STRIP001 	rInput.Seek(STREAM_SEEK_TO_END);
//STRIP001 	rInput.ResetError();
//STRIP001 
//STRIP001 	nFileSize = rInput.Tell();
//STRIP001 	rInput.Seek(STREAM_SEEK_TO_BEGIN);
//STRIP001 	rInput.ResetError();
//STRIP001 
//STRIP001 	::StartProgress( STR_STATSTR_W4WREAD, 0, nFileSize, pDoc->GetDocShell() );
//STRIP001 
//STRIP001 	SwPaM* pInsPam = 0;
//STRIP001 	xub_StrLen nSttCntnt;
//STRIP001 	if( !bNewDoc )
//STRIP001 	{
//STRIP001 		const SwNodeIndex& rTmp = pPam->GetPoint()->nNode;
//STRIP001 		pInsPam = new SwPaM( rTmp, rTmp, 0, -1 );
//STRIP001 		nSttCntnt = pPam->GetPoint()->nContent.GetIndex();
//STRIP001 	}
//STRIP001 
//STRIP001     SwTxtFmtColl *pColl = 0;
//STRIP001 
//STRIP001     if (bNewDoc)
//STRIP001     {
//STRIP001         pColl = pDoc->GetTxtCollFromPoolSimple(RES_POOLCOLL_HTML_PRE, false);
//STRIP001         if (!pColl)
//STRIP001             pColl = pDoc->GetTxtCollFromPoolSimple(RES_POOLCOLL_STANDARD,false);
//STRIP001         if (pColl)
//STRIP001             pDoc->SetTxtFmtColl(*pPam, pColl);
//STRIP001     }
//STRIP001 
//STRIP001 	ULONG nError = ReadChars();
//STRIP001 
//STRIP001 	if( pItemSet )
//STRIP001 	{
//STRIP001 		// set only the attribute, for scanned scripts.
//STRIP001 		if( !( SCRIPTTYPE_LATIN & nScript ))
//STRIP001 		{
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_FONT );
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_LANGUAGE );
//STRIP001 		}
//STRIP001 		if( !( SCRIPTTYPE_ASIAN & nScript ))
//STRIP001 		{
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_CJK_FONT );
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_CJK_LANGUAGE );
//STRIP001 		}
//STRIP001 		if( !( SCRIPTTYPE_COMPLEX & nScript ))
//STRIP001 		{
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_CTL_FONT );
//STRIP001 			pItemSet->ClearItem( RES_CHRATR_CTL_LANGUAGE );
//STRIP001 		}
//STRIP001 		if( pItemSet->Count() )
//STRIP001 		{
//STRIP001 			if( bNewDoc )
//STRIP001 			{
//STRIP001                 if (pColl)
//STRIP001                 {
//STRIP001 				    // Using the pool defaults for the font causes significant
//STRIP001 				    // trouble for the HTML filter, because it is not able
//STRIP001 				    // to export the pool defaults (or to be more precice:
//STRIP001 				    // the HTML filter is not able to detect whether a pool
//STRIP001 				    // default has changed or not. Even a comparison with the
//STRIP001 				    // HTMLi template does not work, because the defaults are
//STRIP001 				    // not copied when a new doc is created. The result of
//STRIP001 				    // comparing pool defaults therfor would be that the
//STRIP001 				    // defaults are exported always if the have changed for
//STRIP001 				    // text documents in general. That's not sensible, as well
//STRIP001 				    // as it is not sensible to export them always.
//STRIP001 				    sal_uInt16 aWhichIds[4] = 
//STRIP001                     { 
//STRIP001                         RES_CHRATR_FONT, RES_CHRATR_CJK_FONT,
//STRIP001                         RES_CHRATR_CTL_FONT, 0 
//STRIP001                     };
//STRIP001 				    sal_uInt16 *pWhichIds = aWhichIds;
//STRIP001 				    while (*pWhichIds)
//STRIP001 				    {
//STRIP001 				        const SfxPoolItem *pItem;
//STRIP001 					    if (SFX_ITEM_SET == pItemSet->GetItemState(*pWhichIds,
//STRIP001                             false, &pItem))
//STRIP001 					    {
//STRIP001 						    pColl->SetAttr( *pItem );
//STRIP001 						    pItemSet->ClearItem( *pWhichIds );
//STRIP001 					    }
//STRIP001 					    ++pWhichIds;
//STRIP001 				    }
//STRIP001                 }
//STRIP001 				if (pItemSet->Count())
//STRIP001 					pDoc->SetDefault(*pItemSet);
//STRIP001 			}
//STRIP001 			else if( pInsPam )
//STRIP001 			{
//STRIP001 				// then set over the insert range the defined attributes
//STRIP001 				*pInsPam->GetMark() = *pPam->GetPoint();
//STRIP001 				pInsPam->GetPoint()->nNode++;
//STRIP001 				pInsPam->GetPoint()->nContent.Assign(
//STRIP001 									pInsPam->GetCntntNode(), nSttCntnt );
//STRIP001 
//STRIP001 				// !!!!!
//STRIP001 				ASSERT( !this, "Have to change - hard attr. to para. style" );
//STRIP001 				pDoc->Insert( *pInsPam, *pItemSet );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pItemSet, pItemSet = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pInsPam )
//STRIP001 		delete pInsPam;
//STRIP001 
//STRIP001 	::EndProgress( pDoc->GetDocShell() );
//STRIP001 	return nError;
//STRIP001 }

//STRIP001 ULONG SwASCIIParser::ReadChars()
//STRIP001 {
//STRIP001 	sal_Unicode *pStt = 0, *pEnd = 0, *pLastStt = 0;
//STRIP001 	long nReadCnt = 0, nLineLen = 0;
//STRIP001 	sal_Unicode cLastCR = 0;
//STRIP001 	bool bSwapUnicode;
//STRIP001 
//STRIP001     const SwAsciiOptions *pUseMe=&rOpt;
//STRIP001     SwAsciiOptions aEmpty;
//STRIP001     if (nFileSize >= 2 &&
//STRIP001         aEmpty.GetFontName() == rOpt.GetFontName() && 
//STRIP001         aEmpty.GetCharSet() == rOpt.GetCharSet() && 
//STRIP001         aEmpty.GetLanguage() == rOpt.GetLanguage() && 
//STRIP001         aEmpty.GetParaFlags() == rOpt.GetParaFlags())
//STRIP001     {
//STRIP001         ULONG nLen, nOrig;
//STRIP001         nOrig = nLen = rInput.Read(pArr, ASC_BUFFLEN);
//STRIP001         CharSet eCharSet;
//STRIP001         bool bRet = SwIoSystem::IsDetectableText(pArr, nLen, &eCharSet, 
//STRIP001             &bSwapUnicode);
//STRIP001         ASSERT(bRet, "Autodetect of text import without nag dialog must "
//STRIP001             "have failed");
//STRIP001         if (bRet && eCharSet != RTL_TEXTENCODING_DONTKNOW)
//STRIP001         {
//STRIP001             aEmpty.SetCharSet(eCharSet);
//STRIP001             rInput.SeekRel(-(long(nLen)));
//STRIP001         }
//STRIP001         else 
//STRIP001             rInput.SeekRel(-(long(nOrig)));
//STRIP001         pUseMe=&aEmpty;
//STRIP001     }
//STRIP001 
//STRIP001 	rtl_TextToUnicodeConverter hConverter=0;
//STRIP001 	rtl_TextToUnicodeContext hContext=0;
//STRIP001 	CharSet currentCharSet = pUseMe->GetCharSet();
//STRIP001 	if (RTL_TEXTENCODING_UCS2 != currentCharSet)
//STRIP001 	{
//STRIP001 		if( currentCharSet == RTL_TEXTENCODING_DONTKNOW ) 
//STRIP001 	            currentCharSet = RTL_TEXTENCODING_ASCII_US; 
//STRIP001 		hConverter = rtl_createTextToUnicodeConverter( currentCharSet );
//STRIP001 		ASSERT( hConverter, "no string convert avaiable" );
//STRIP001 		if (!hConverter)
//STRIP001 			return ERR_W4W_DLL_ERROR | ERROR_SW_READ_BASE;
//STRIP001 		bSwapUnicode = false;
//STRIP001 		hContext = rtl_createTextToUnicodeContext( hConverter );
//STRIP001 	}
//STRIP001 	else if (pUseMe != &aEmpty)  //Already successfully figured out type
//STRIP001 	{
//STRIP001 		rInput.StartReadingUnicodeText();
//STRIP001 		bSwapUnicode = rInput.IsEndianSwap();
//STRIP001 	}
//STRIP001 
//STRIP001 	String sWork;
//STRIP001 	ULONG nArrOffset = 0;
//STRIP001 
//STRIP001 	do {
//STRIP001 		if( pStt >= pEnd )
//STRIP001 		{
//STRIP001 			if( pLastStt != pStt )
//STRIP001 				InsertText( String( pLastStt ));
//STRIP001 
//STRIP001 			// lese einen neuen Block ein
//STRIP001 			ULONG lGCount;
//STRIP001 			if( SVSTREAM_OK != rInput.GetError() || 0 == (lGCount =
//STRIP001 						rInput.Read( pArr + nArrOffset,
//STRIP001 									 ASC_BUFFLEN - nArrOffset )))
//STRIP001 				break;		// aus der WHILE-Schleife heraus
//STRIP001 
//STRIP001             /*
//STRIP001             #98380#
//STRIP001             If there was some unconverted bytes on the last cycle then they
//STRIP001             were put at the beginning of the array, so total bytes available
//STRIP001             to convert this cycle includes them. If we found 0 following bytes
//STRIP001             then we ignore the previous partial character.
//STRIP001             */
//STRIP001             lGCount+=nArrOffset;
//STRIP001 
//STRIP001 			if( hConverter )
//STRIP001 			{
//STRIP001 				sal_uInt32 nInfo;
//STRIP001 				sal_Size nNewLen = lGCount, nCntBytes;
//STRIP001 				sal_Unicode* pBuf = sWork.AllocBuffer( nNewLen );
//STRIP001 
//STRIP001 				nNewLen = rtl_convertTextToUnicode( hConverter, hContext,
//STRIP001 								pArr, lGCount, pBuf, nNewLen,
//STRIP001 								(
//STRIP001 								RTL_TEXTTOUNICODE_FLAGS_UNDEFINED_DEFAULT |
//STRIP001 								RTL_TEXTTOUNICODE_FLAGS_MBUNDEFINED_DEFAULT |
//STRIP001 								RTL_TEXTTOUNICODE_FLAGS_INVALID_DEFAULT |
//STRIP001                                 RTL_TEXTTOUNICODE_FLAGS_GLOBAL_SIGNATURE
//STRIP001 								),
//STRIP001 								&nInfo,
//STRIP001 								&nCntBytes );
//STRIP001 				if( 0 != ( nArrOffset = lGCount - nCntBytes ) )
//STRIP001 					memmove( pArr, pArr + nCntBytes, nArrOffset );
//STRIP001 				sWork.ReleaseBufferAccess( nNewLen );
//STRIP001 
//STRIP001 				pStt = pLastStt = sWork.GetBufferAccess();
//STRIP001 				pEnd = pStt + nNewLen;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pStt = pLastStt = (sal_Unicode*)pArr;
//STRIP001 				pEnd = (sal_Unicode*)(pArr + lGCount);
//STRIP001 
//STRIP001 				if( bSwapUnicode )
//STRIP001 				{
//STRIP001 					sal_Char* pF = pArr, *pN = pArr + 1;
//STRIP001 					for( ULONG n = 0; n < lGCount; n += 2, pF += 2, pN += 2 )
//STRIP001 					{
//STRIP001 						sal_Char c = *pF;
//STRIP001 						*pF = *pN;
//STRIP001 						*pN = c;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			*pEnd = 0;
//STRIP001 			nReadCnt += lGCount;
//STRIP001 
//STRIP001 			::binfilter::SetProgressState( nReadCnt, pDoc->GetDocShell() );
//STRIP001 
//STRIP001 			if( cLastCR )
//STRIP001 			{
//STRIP001 				if( 0x0a == *pStt && 0x0d == cLastCR )
//STRIP001 					pLastStt = ++pStt;
//STRIP001 				cLastCR = 0;
//STRIP001 				nLineLen = 0;
//STRIP001 				// JP 03.04.96: das letze am Ende nehmen wir nicht
//STRIP001 				if( !rInput.IsEof() || !(pEnd == pStt ||
//STRIP001 					( !*pEnd && pEnd == pStt+1 ) ) )
//STRIP001 					pDoc->SplitNode( *pPam->GetPoint() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		bool bIns = true, bSplitNode = false;
//STRIP001 		switch( *pStt )
//STRIP001 		{
//STRIP001 //JP 12.11.2001: task 94636 - don't ignore all behind the zero character,
//STRIP001 //							  change it to the default "control character"
//STRIP001 //		case 0:
//STRIP001 //					pEnd = pStt;
//STRIP001 //					bIns = false ;
//STRIP001 //					break;
//STRIP001 
//STRIP001 		case 0x0a:	if( LINEEND_LF == pUseMe->GetParaFlags() )
//STRIP001 					{
//STRIP001 						bIns = false;
//STRIP001 						*pStt = 0;
//STRIP001 						++pStt;
//STRIP001 
//STRIP001 						// JP 03.04.96: das letze am Ende nehmen wir nicht
//STRIP001 						if( !rInput.IsEof() || pEnd != pStt )
//STRIP001 							bSplitNode = true;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 		case 0x0d:	if( LINEEND_LF != pUseMe->GetParaFlags() )
//STRIP001 					{
//STRIP001 						bIns = false;
//STRIP001 						*pStt = 0;
//STRIP001 						++pStt;
//STRIP001 
//STRIP001 						bool bChkSplit = false;
//STRIP001 						if( LINEEND_CRLF == pUseMe->GetParaFlags() )
//STRIP001 						{
//STRIP001 							if( pStt == pEnd )
//STRIP001 								cLastCR = 0x0d;
//STRIP001 							else if( 0x0a == *pStt )
//STRIP001 							{
//STRIP001 								++pStt;
//STRIP001 								bChkSplit = true;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						else
//STRIP001 							bChkSplit = true;
//STRIP001 
//STRIP001 							// JP 03.04.96: das letze am Ende nehmen wir nicht
//STRIP001 						if( bChkSplit && ( !rInput.IsEof() || pEnd != pStt ))
//STRIP001 							bSplitNode = true;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 		case 0x0c:
//STRIP001 					{
//STRIP001 						// dann mal einen harten Seitenumbruch einfuegen
//STRIP001 						*pStt++ = 0;
//STRIP001 						if( nLineLen )
//STRIP001 						{
//STRIP001 							// Change to charset system!!!!
//STRIP001 							//rOpt.GetCharSet();
//STRIP001 							InsertText( String( pLastStt ));
//STRIP001 						}
//STRIP001 						pDoc->SplitNode( *pPam->GetPoint() );
//STRIP001 						pDoc->Insert( *pPam, SvxFmtBreakItem(
//STRIP001 									SVX_BREAK_PAGE_BEFORE ));
//STRIP001 						pLastStt = pStt;
//STRIP001 						nLineLen = 0;
//STRIP001 						bIns = false;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 		case 0x1a:
//STRIP001 					if( nReadCnt == nFileSize && pStt+1 == pEnd )
//STRIP001 						*pStt = 0;
//STRIP001 					else
//STRIP001 						*pStt = '#';        // Ersatzdarstellung
//STRIP001 					break;
//STRIP001 
//STRIP001 		case '\t':	break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			if( ' ' > *pStt )
//STRIP001 					// Ctrl-Zchn gefunden ersetze durch '#'
//STRIP001 				*pStt = '#';
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bIns )
//STRIP001 		{
//STRIP001 			if( ( nLineLen >= MAX_ASCII_PARA - 100 ) &&
//STRIP001 				( ( *pStt == ' ' ) || ( nLineLen >= MAX_ASCII_PARA - 1 ) ) )
//STRIP001 			{
//STRIP001 				sal_Unicode c = *pStt;
//STRIP001 				*pStt = 0;
//STRIP001 				InsertText( String( pLastStt ));
//STRIP001 				pDoc->SplitNode( *pPam->GetPoint() );
//STRIP001 				pLastStt = pStt;
//STRIP001 				nLineLen = 0;
//STRIP001 				*pStt = c;
//STRIP001 			}
//STRIP001 			++pStt;
//STRIP001 			++nLineLen;
//STRIP001 		}
//STRIP001 		else if( bSplitNode )
//STRIP001 		{
//STRIP001 			// es wurde ein CR/LF erkannt, also speichere den Text
//STRIP001 
//STRIP001 			InsertText( String( pLastStt ));
//STRIP001 			pDoc->SplitNode( *pPam->GetPoint() );
//STRIP001 			pLastStt = pStt;
//STRIP001 			nLineLen = 0;
//STRIP001 		}
//STRIP001 	} while(true);
//STRIP001 
//STRIP001 	if( hConverter )
//STRIP001 	{
//STRIP001 		rtl_destroyTextToUnicodeContext( hConverter, hContext );
//STRIP001 		rtl_destroyTextToUnicodeConverter( hConverter );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void SwASCIIParser::InsertText( const String& rStr )
//STRIP001 {
//STRIP001 	pDoc->Insert( *pPam, rStr );
//STRIP001 	if( pItemSet && pBreakIt && nScript != ( SCRIPTTYPE_LATIN |
//STRIP001 											 SCRIPTTYPE_ASIAN |
//STRIP001 											 SCRIPTTYPE_COMPLEX ) )
//STRIP001 		nScript |= pBreakIt->GetAllScriptsOfText( rStr );
//STRIP001 }

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
}
